/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.IOrgView;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgViewFactory;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgDataCollection;
import com.kingdee.eas.ma.bg.BgDataInfo;
import com.kingdee.eas.ma.bg.BgDataManagerHelper;
import com.kingdee.eas.ma.bg.BgOrgUnitLevelInfo;
import com.kingdee.eas.ma.bg.BgTypeCollection;
import com.kingdee.eas.ma.bg.BgTypeFactory;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.BgValueTypeEnum;
import com.kingdee.eas.ma.bg.IBgType;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Vector;

public class DataGatherHelper {
    public static synchronized void gatherBgData(Context ctx, BgValueTypeEnum bgValueTypeEnum) throws BOSException, EASBizException {
        IOrgView iOrgView = OrgViewFactory.getLocalInstance((Context)ctx);
        List list = OrgViewType.getEnumList();
        for (OrgViewType orgViewType : list) {
            FullOrgUnitCollection orgUnitCollection;
            Vector vecLevelOrgs = BgDataManagerHelper.getUpdateDataOrgs(ctx, orgViewType, orgUnitCollection = NewOrgViewHelper.getAllOrgs(null, (OrgViewType)orgViewType));
            if (vecLevelOrgs == null || vecLevelOrgs.size() <= 0) continue;
            DataGatherHelper.sumDataByLowerOrg(ctx, vecLevelOrgs, bgValueTypeEnum);
        }
    }

    private static void sumDataByLowerOrg(Context ctx, Vector vecLevelOrgs, BgValueTypeEnum bgValueTypeEnum) throws EASBizException, BOSException {
        IBgType iBgType = BgTypeFactory.getLocalInstance(ctx);
        int size = vecLevelOrgs.size();
        for (int i = 0; i < size; ++i) {
            BgOrgUnitLevelInfo bgOrgUnitLevelInfo = (BgOrgUnitLevelInfo)vecLevelOrgs.elementAt(i);
            int bosUuidOrgUnit = NewOrgViewHelper.convert((OrgViewType)OrgViewType.getEnum((int)((Integer)bgOrgUnitLevelInfo.getOrgUnitInfo().get("treeType")))).getValue();
            BgTypeCollection bgTypeCollection = iBgType.getCollection(bosUuidOrgUnit);
            int sizeType = bgTypeCollection.size();
            for (int j = 0; j < sizeType; ++j) {
                BgTypeInfo bgTypeInfo = bgTypeCollection.get(j);
                String strBgTypeId = bgTypeInfo.getId().toString();
                DataGatherHelper.gatherBgData(ctx, strBgTypeId, bgOrgUnitLevelInfo, bgValueTypeEnum);
            }
        }
    }

    private static void gatherBgData(Context ctx, String strBgTypeId, BgOrgUnitLevelInfo bgOrgUnitLevelInfo, BgValueTypeEnum bgValueTypeEnum) throws SQLDataException {
        OrgUnitCollection orgUnitCollection = bgOrgUnitLevelInfo.getSubOrgUnitCollection();
        int size = orgUnitCollection.size();
        Vector<BgDataCollection> vecBgData = new Vector<BgDataCollection>();
        for (int i = 0; i < size; ++i) {
            String strOrgUnitId = orgUnitCollection.get(i).getId().toString();
            BgDataCollection bgDataCollectionTemp = DataGatherHelper.getBgDataCollectionByOrgUnit(ctx, strBgTypeId, strOrgUnitId, bgValueTypeEnum);
            if (bgDataCollectionTemp.size() <= 0) continue;
            vecBgData.add(bgDataCollectionTemp);
        }
        String strOrgUnitIdParent = bgOrgUnitLevelInfo.getOrgUnitInfo().getId().toString();
        BgDataCollection bgDataCollectionParent = DataGatherHelper.getBgDataCollectionByOrgUnit(ctx, strBgTypeId, strOrgUnitIdParent, bgValueTypeEnum);
        if (vecBgData.size() > 0 && bgDataCollectionParent.size() > 0) {
            bgDataCollectionParent = DataGatherHelper.sumBgDatas(bgDataCollectionParent, vecBgData, bgValueTypeEnum);
            DataGatherHelper.excuteGatherBgData(ctx, strBgTypeId, strOrgUnitIdParent, bgDataCollectionParent, bgValueTypeEnum);
        }
    }

    private static void excuteGatherBgData(Context ctx, String strBgTypeId, String strOrgUnitId, BgDataCollection bgDataCollectionParent, BgValueTypeEnum bgValueTypeEnum) throws SQLDataException {
        int size = bgDataCollectionParent.size();
        PreparedStatement ps = null;
        Object rs = null;
        String strField = null;
        strField = bgValueTypeEnum.equals((Object)BgValueTypeEnum.BgValue) ? "FBgValue" : "FBgActual";
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            for (int i = 0; i < size; ++i) {
                BgDataInfo bgDataInfo = bgDataCollectionParent.get(i);
                StringBuffer strBuffer = new StringBuffer(200);
                strBuffer.append("update  t_bg_bgData set ");
                strBuffer.append(strField);
                strBuffer.append("=? ");
                BigDecimal updateValue = null;
                updateValue = bgValueTypeEnum.equals((Object)BgValueTypeEnum.BgValue) ? bgDataInfo.getBgValue() : bgDataInfo.getBgActual();
                strBuffer.append(" where fidentity in (select distinct (data.fidentity)  from t_bg_bgData data, t_Bg_bgForm fm, t_bg_BgEntry en where fm.fid = en.fBgformId and data.fbgEntryId = en.fid and fm.FState = 2 ");
                strBuffer.append(" and fm.FBgTypeID = ?");
                strBuffer.append(" and fm.FOrgUnitID =?");
                strBuffer.append(" and data.fidentity =?");
                strBuffer.append(")");
                strBuffer.append(" and t_bg_bgData.FID=?");
                ps = conn.prepareStatement(strBuffer.toString());
                ps.setBigDecimal(1, updateValue);
                ps.setString(2, strBgTypeId);
                ps.setString(3, strOrgUnitId);
                ps.setString(4, bgDataInfo.getIdentity());
                ps.setString(5, bgDataInfo.getId().toString());
                ps.executeUpdate();
                strBuffer = null;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e.toString());
        }
        finally {
            SQLUtils.cleanup(ps, (Connection)conn);
        }
    }

    private static BgDataCollection sumBgDatas(BgDataCollection bgDataCollectionParent, Vector vecBgData, BgValueTypeEnum bgValueTypeEnum) {
        int size = vecBgData.size();
        int dataSize = bgDataCollectionParent.size();
        for (int i = 0; i < dataSize; ++i) {
            BgDataInfo bgDataInfo = bgDataCollectionParent.get(i);
            if (bgDataInfo == null) continue;
            for (int j = 0; j < size; ++j) {
                BgDataCollection bgDataCollectionTemp = (BgDataCollection)((Object)vecBgData.get(j));
                if (bgDataCollectionTemp == null) continue;
                if (j == 0) {
                    DataGatherHelper.sumBgData(bgDataInfo, bgDataCollectionTemp, bgValueTypeEnum, true);
                    continue;
                }
                DataGatherHelper.sumBgData(bgDataInfo, bgDataCollectionTemp, bgValueTypeEnum, false);
            }
        }
        return bgDataCollectionParent;
    }

    private static void sumBgData(BgDataInfo bgDataInfo, BgDataCollection bgDataCollectionTemp, BgValueTypeEnum bgValueTypeEnum, boolean isAdd) {
        int size = bgDataCollectionTemp.size();
        for (int i = 0; i < size; ++i) {
            BigDecimal bigValue;
            BgDataInfo bgDataInfoTemp = bgDataCollectionTemp.get(i);
            if (bgDataInfoTemp == null || bgDataInfo.getIdentity() == null || !bgDataInfo.getIdentity().equals(bgDataInfoTemp.getIdentity())) continue;
            if (bgValueTypeEnum.equals((Object)BgValueTypeEnum.BgValue)) {
                if (isAdd) {
                    bigValue = bgDataInfoTemp.getBgValue();
                    bgDataInfo.setBgValue(bigValue);
                    continue;
                }
                bigValue = bgDataInfo.getBgValue().add(bgDataInfoTemp.getBgValue());
                bgDataInfo.setBgValue(bigValue);
                continue;
            }
            if (isAdd) {
                bigValue = bgDataInfoTemp.getBgActual();
                bgDataInfo.setBgActual(bigValue);
                continue;
            }
            bigValue = bgDataInfo.getBgActual().add(bgDataInfoTemp.getBgActual());
            bgDataInfo.setBgActual(bigValue);
        }
    }

    private static BgDataCollection getBgDataCollectionByOrgUnit(Context ctx, String strTypeId, String strOrgUnitInfoId, BgValueTypeEnum bgValueTypeEnum) throws SQLDataException {
        BgDataCollection bgDataCollection = new BgDataCollection();
        StringBuffer strBuffer = new StringBuffer(500);
        String strField = null;
        strField = bgValueTypeEnum.equals((Object)BgValueTypeEnum.BgValue) ? "FBgValue" : "FBgActual";
        strBuffer.append("select ");
        strBuffer.append("data." + strField);
        strBuffer.append(", data.fidentity, data.FID as fid  from t_bg_bgData data, t_Bg_bgForm fm, t_bg_BgEntry en where fm.fid = en.fBgformId and data.fbgEntryId = en.fid and fm.FState = 2 ");
        int fieldCount = 0;
        if (strTypeId != null) {
            strBuffer.append(" and fm.FBgTypeId = ?");
            ++fieldCount;
        }
        if (strOrgUnitInfoId != null) {
            strBuffer.append(" and fm.FOrgUnitId = ?");
            ++fieldCount;
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(strBuffer.toString());
            if (fieldCount == 1) {
                if (strTypeId != null) {
                    ps.setString(1, strTypeId);
                }
                if (strOrgUnitInfoId != null) {
                    ps.setString(1, strOrgUnitInfoId);
                }
            }
            if (fieldCount == 2) {
                ps.setString(1, strTypeId);
                ps.setString(2, strOrgUnitInfoId);
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                BgDataInfo bgDataInfo = new BgDataInfo();
                bgDataInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                BigDecimal bigDecimal = rs.getBigDecimal(strField);
                if (bigDecimal == null) {
                    bigDecimal = new BigDecimal("0");
                }
                if (bgValueTypeEnum.equals((Object)BgValueTypeEnum.BgValue)) {
                    bgDataInfo.setBgValue(bigDecimal);
                } else {
                    bgDataInfo.setBgActual(bigDecimal);
                }
                bgDataInfo.setIdentity(rs.getString("fidentity"));
                bgDataCollection.add(bgDataInfo);
            }
            strBuffer = null;
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new SQLDataException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return bgDataCollection;
    }

    private String[] getLowerOrgIds(OrgUnitCollection orgUnitCollection) {
        int size = orgUnitCollection.size();
        String[] strIdArray = new String[size];
        for (int i = 0; i < size; ++i) {
            strIdArray[i] = orgUnitCollection.get(i).getId().toString();
        }
        return strIdArray;
    }
}

