/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.ma.bg.BgAuditStyleEnum;
import com.kingdee.eas.ma.bg.BgAuditUtils;
import com.kingdee.eas.ma.bg.BgCarryForwardFactory;
import com.kingdee.eas.ma.bg.BgCheckHelper;
import com.kingdee.eas.ma.bg.BgControlFactory;
import com.kingdee.eas.ma.bg.BgCtrlData;
import com.kingdee.eas.ma.bg.BgCtrlDetailEntryInfo;
import com.kingdee.eas.ma.bg.BgCtrlDetailInfo;
import com.kingdee.eas.ma.bg.BgCtrlParam;
import com.kingdee.eas.ma.bg.BgDataCollection;
import com.kingdee.eas.ma.bg.BgDataInfo;
import com.kingdee.eas.ma.bg.BgElementEnum;
import com.kingdee.eas.ma.bg.BgFormInfo;
import com.kingdee.eas.ma.bg.BgHelper;
import com.kingdee.eas.ma.bg.BgInstantApproveException;
import com.kingdee.eas.ma.bg.BgManagerFactory;
import com.kingdee.eas.ma.bg.BgProviderFactory;
import com.kingdee.eas.ma.bg.BgTemplateColumnCollection;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.BgVerifyException;
import com.kingdee.eas.ma.bg.IBgCarryForward;
import com.kingdee.eas.ma.bg.IBgControl;
import com.kingdee.eas.ma.bg.IBgManager;
import com.kingdee.eas.ma.bg.IBgProvider;
import com.kingdee.eas.ma.bg.ReferencedDimensionCollection;
import com.kingdee.eas.ma.bg.app.AbstractBgAuditControllerBean;
import com.kingdee.eas.ma.bg.app.dao.BgCtrlDAO;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;

public class BgAuditControllerBean
extends AbstractBgAuditControllerBean {
    @Override
    protected boolean _audit(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        Object[] bgCtrlParamArray = BgAuditUtils.getBgCtrlParaByUuid(ctx, id);
        IBgControl iBgC = BgControlFactory.getLocalInstance(ctx);
        if (bgCtrlParamArray != null) {
            iBgC.bgAudit((BgCtrlParam[])bgCtrlParamArray);
        }
        if (BgHelper.isEmpty(bgCtrlParamArray)) {
            return true;
        }
        int size = bgCtrlParamArray.length;
        for (int i = 0; i < size; ++i) {
            if (((BgCtrlParam)bgCtrlParamArray[i]).isOK()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean _unAudit(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        BgCtrlParam[] bgCtrlParamArray = BgAuditUtils.getBgCtrlParaByUuid(ctx, id);
        IBgControl iBgC = BgControlFactory.getLocalInstance(ctx);
        if (bgCtrlParamArray != null) {
            iBgC.bgCancelAudit(bgCtrlParamArray);
        }
        return true;
    }

    @Override
    protected void _updateBalance(Context ctx, BgCtrlParam[] params, BgAuditStyleEnum aduitStyle) throws BOSException, EASBizException {
        IBgManager bgManage = BgManagerFactory.getLocalInstance(ctx);
        HashMap<String, BgFormInfo> cache = new HashMap<String, BgFormInfo>();
        for (int i = 0; i < params.length; ++i) {
            BgCtrlParam bgCtrlParam = params[i];
            BOSUuid bgTypeId = bgCtrlParam.getBgTypeId();
            String bgFormkey = bgCtrlParam.getBizOrgUnitId().toString() + bgTypeId + bgCtrlParam.getPeriodId();
            BgFormInfo bgFormInfo = (BgFormInfo)cache.get(bgFormkey);
            if (bgFormInfo == null) {
                bgFormInfo = bgManage.getExecutiveBgForm(bgCtrlParam.getBizOrgUnitId(), bgTypeId, bgCtrlParam.getPeriodId());
                cache.put(bgFormkey, bgFormInfo);
            }
            if (bgFormInfo == null || !BgAuditUtils.verifyBizData(params[i], bgFormInfo.getBgTemplate())) continue;
            boolean rs = BgAuditUtils.verifyCurrency(bgCtrlParam, bgFormInfo.getBgTemplate().getRefCurrencies());
            if (!rs) break;
            BgCtrlDetailInfo ctrlInfo = null;
            ctrlInfo = this.buildTraceFormInfo(ctx, bgFormInfo, bgCtrlParam, aduitStyle);
            this.updBgBalance(ctx, bgCtrlParam, bgFormInfo, ctrlInfo, aduitStyle);
            BgCtrlDAO.getInstance(ctx).ctrlDetailInsert(ctrlInfo);
        }
    }

    private BgCtrlDetailInfo buildTraceFormInfo(Context ctx, BgFormInfo bgFormInfo, BgCtrlParam param, BgAuditStyleEnum style) throws EASBizException {
        FullOrgUnitInfo bizOrgUnit = new FullOrgUnitInfo();
        bizOrgUnit.setId(param.getBizOrgUnitId());
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(param.getCompanyId());
        BgTypeInfo bgType = new BgTypeInfo();
        bgType.setId(param.getBgTypeId());
        PeriodInfo period = new PeriodInfo();
        period.setId(param.getPeriodId());
        CurrencyInfo currency = new CurrencyInfo();
        currency.setId(param.getCurrencyId());
        BgCtrlDetailInfo ctrlInfo = new BgCtrlDetailInfo();
        ctrlInfo.setBgForm(bgFormInfo);
        ctrlInfo.setCompany(company);
        ctrlInfo.setBizOrgUnit(bizOrgUnit);
        ctrlInfo.setPeriod(period);
        ctrlInfo.setCurrency(currency);
        ctrlInfo.setCtrlSystem(param.getCtrlSystem());
        ctrlInfo.setBgType(bgType);
        ctrlInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        ctrlInfo.setBizDate(param.getBizDate());
        ctrlInfo.setSrcBillID(param.getSrcBillId());
        ctrlInfo.setSrcBillNumber(param.getSrcBillNumber());
        ctrlInfo.setSrcBillTypeID(param.getSrcBillId().getType().toString());
        ctrlInfo.setBgAuditStyle(style);
        ctrlInfo.setCreator((UserInfo)ctx.get((Object)"UserInfo"));
        ctrlInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        ctrlInfo.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
        ctrlInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        this.parseDimsAndDatas(bgFormInfo, param, ctrlInfo);
        return ctrlInfo;
    }

    private void updBgBalance(Context ctx, BgCtrlParam bgCtrlParam, BgFormInfo bgFormInfo, BgCtrlDetailInfo ctrlDetail, BgAuditStyleEnum style) throws EASBizException, BOSException {
        IBgProvider bgProvider = BgProviderFactory.getLocalInstance(ctx);
        BgDataCollection bgDatas = bgProvider.getBgData(bgFormInfo, bgCtrlParam.getPeriodId(), bgCtrlParam.getDimensions(), bgCtrlParam.getCurrencyId());
        for (int e = 0; e < bgDatas.size(); ++e) {
            BgDataInfo bgData = bgDatas.get(e);
            BgElementEnum bizElement = bgData.getBgElement().getBizElement();
            BgCtrlData bizData = bgCtrlParam.getData(bizElement);
            BigDecimal changeOrigin = null;
            changeOrigin = this.getBizValue(bizData.getValue(), style);
            ctrlDetail = this.recTraceDetail(ctrlDetail, bgData, changeOrigin);
            if (changeOrigin == null) continue;
            BgCtrlDAO.getInstance(ctx).updateBgBalanceData(bgData, changeOrigin);
        }
    }

    protected BigDecimal getBizValue(BigDecimal bizValue, BgAuditStyleEnum style) throws EASBizException {
        if (style == BgAuditStyleEnum.BG_AUDIT || style == BgAuditStyleEnum.BG_CANCEL_CLOSE_BILL || style == BgAuditStyleEnum.BG_INC_AUDIT4BILL || style == BgAuditStyleEnum.BG_INC_REQ4BILL || style == BgAuditStyleEnum.BG_INC_AUDIT4DATA || style == BgAuditStyleEnum.BG_CANCEL_CLOSE_BILL || style == BgAuditStyleEnum.BG_SPECIAL) {
            return bizValue;
        }
        if (style == BgAuditStyleEnum.BG_CANCEL_AUDIT || style == BgAuditStyleEnum.BG_CLOSE_BILL || style == BgAuditStyleEnum.BG_CANCEL_INC_REQ4BILL || style == BgAuditStyleEnum.BG_CANCEL_INC_AUDIT4DATA || style == BgAuditStyleEnum.BG_CANCEL_SPECIAL || style == BgAuditStyleEnum.BG_CLOSE_BILL || style == BgAuditStyleEnum.BG_CANCEL_INC_AUDIT4BILL) {
            return bizValue.negate();
        }
        throw new EASBizException(BgVerifyException.CHECKNOEXIST, new Object[]{style});
    }

    protected void parseDimsAndDatas(BgFormInfo bgFormInfo, BgCtrlParam bgCtrlParam, BgCtrlDetailInfo ctrlInfo) throws EASBizException {
        ReferencedDimensionCollection refDimensions = bgFormInfo.getBgTemplate().getRefDimensions();
        for (int i = 0; i < refDimensions.size(); ++i) {
            IObjectValue bizDimesion = bgCtrlParam.getDimension(refDimensions.get(i).getBgDimension());
            if (bizDimesion == null) continue;
            ctrlInfo.setBOSUuid("bgItem" + i + "ID", bizDimesion.getBOSUuid("id"));
        }
        BgTemplateColumnCollection bgTpColumns = bgFormInfo.getBgTemplate().getBgTpColumns();
        for (int i = 0; i < bgTpColumns.size(); ++i) {
            BgCtrlData bizData = bgCtrlParam.getData(bgTpColumns.get(i).getBgElement().getBizElement());
            BgCheckHelper.checkBlank(bizData, new Object[]{bgTpColumns.get(i).getBgElement().getBizElement()});
            BigDecimal bizValue = bizData.getValue();
            BgCheckHelper.checkBlank(bizValue, new Object[]{"bizData.value"});
            ctrlInfo.setBigDecimal("bizData" + i, this.getBizValue(bizValue, ctrlInfo.getBgAuditStyle()));
        }
    }

    private BgCtrlDetailInfo recTraceDetail(BgCtrlDetailInfo ctrlDetail, BgDataInfo bgData, BigDecimal changeOrigin) {
        ctrlDetail.setBizData0(changeOrigin);
        ctrlDetail.setDataType(bgData.getDataType());
        BgCtrlDetailEntryInfo entry = new BgCtrlDetailEntryInfo();
        entry.setBgActualValue(changeOrigin);
        entry.setBgCurrency(bgData.getCurrency());
        entry.setBgData(bgData);
        ctrlDetail.getEntries().add(entry);
        entry.setSeq(ctrlDetail.getEntries().size());
        entry.setBill(ctrlDetail);
        return ctrlDetail;
    }

    @Override
    protected BgCtrlParam[] _getBgCtrlParaByUuid(Context ctx, BOSUuid billId) throws EASBizException, BOSException {
        int type = BgAuditUtils.getBillType(ctx, billId);
        BgCtrlParam[] bgCtrlParamArray = null;
        if (type == 1) {
            IVoucher iVoucher = VoucherFactory.getLocalInstance((Context)ctx);
            return bgCtrlParamArray;
        }
        return bgCtrlParamArray;
    }

    @Override
    protected boolean _unAuditNoWf(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        BgCtrlParam[] bgCtrlParamArray = BgAuditUtils.getBgCtrlParaByUuid(ctx, id);
        IBgControl iBgC = BgControlFactory.getLocalInstance(ctx);
        if (bgCtrlParamArray != null) {
            iBgC.bgCancelAudit(bgCtrlParamArray);
        }
        return true;
    }

    @Override
    protected void _initUsableBalance(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        IBgCarryForward cf = BgCarryForwardFactory.getLocalInstance(ctx);
        String bgFormId = this.getBgFormIdByBill(ctx, billId);
        cf.executor(new Date(System.currentTimeMillis()), bgFormId);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getBgFormIdByBill(Context ctx, BOSUuid billId) throws EASBizException, BOSException {
        String result = "";
        String sql = "select top 1 a.fbgformid from t_bg_bgctrldetail a where a.fsrcbillid = ?";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, BOSUuid.read((String)billId.toString()).toString());
            rs = stmt.executeQuery();
            if (rs.next()) {
                result = rs.getString(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
                catch (SQLDataException e2) {
                    throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return result;
    }
}

