/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgBizException;
import com.kingdee.eas.ma.bg.BgDataCollection;
import com.kingdee.eas.ma.bg.BgDataInfo;
import com.kingdee.eas.ma.bg.BgFormCollection;
import com.kingdee.eas.ma.bg.BgFormInfo;
import com.kingdee.eas.ma.bg.BgHelper;
import com.kingdee.eas.ma.bg.BgORMEngine;
import com.kingdee.eas.ma.bg.BgValueTypeEnum;
import com.kingdee.eas.ma.bg.DataGatherHelper;
import com.kingdee.eas.ma.bg.HashSearchEngine;
import com.kingdee.eas.ma.bg.app.AbstractBgDataManagerControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;

public class BgDataManagerControllerBean
extends AbstractBgDataManagerControllerBean {
    @Override
    protected void _gatherBgValue(Context ctx) throws BOSException, EASBizException {
        DataGatherHelper.gatherBgData(ctx, BgValueTypeEnum.BgValue);
    }

    @Override
    protected void _gatherBgActual(Context ctx) throws BOSException, EASBizException {
        DataGatherHelper.gatherBgData(ctx, BgValueTypeEnum.BgActual);
    }

    private void getBgForm(Context ctx, BgFormInfo bgform) throws BOSException, EASBizException {
        BgDataCollection parentColl = this.getBgData(ctx, bgform);
        BgDataCollection sumColl = this.getSumBgData(ctx, bgform);
        HashSearchEngine engine = new HashSearchEngine(BgORMEngine.buildVOArray((IObjectCollection)sumColl), new String[]{""});
        Iterator iter = parentColl.iterator();
        while (iter.hasNext()) {
            BgDataInfo bgData = (BgDataInfo)iter.next();
            if (!engine.evaluate((IObjectValue)bgData)) continue;
            bgData.setBgBalance(engine.getResult().getBigDecimal("bgBalance"));
        }
        BgORMEngine.updateColl(ctx, BgORMEngine.buildVOArray((IObjectCollection)parentColl), new String[]{"bgBalance"});
    }

    private BgDataCollection getSumBgData(Context ctx, BgFormInfo bgform) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer(128);
        sb.append("SELECT D.ItemNumberKey,");
        sb.append(" SUM(D.");
        sb.append("FBgBalance");
        sb.append("),");
        sb.append(" P.FPeriodYear * 100 + P.FPeriodNumber AS FPeriodSerial,");
        sb.append(" D.FCurrencyID,");
        sb.append(" D.FBgElementID FROM T_Bg_Org_rsp OU INNER JOIN V_BG_BgData D ON OU.FID = D.FOrgUnitID INNER JOIN T_BD_Period P ON D.FPeriodID = P.FID WHERE (D.FBgTypeID = ?) AND (OU.FLongNumber LIKE 'FI001%') AND (OU.FLevel = 2) AND (D.FPeriodID = ?) AND (D.FState IN (2, 6)) GROUP BY D.ItemNumberKey, P.FPeriodYear, P.FPeriodNumber, D.FCurrencyID, D.FBgElementID");
        BgDataCollection coll = new BgDataCollection();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sb.toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                BgDataInfo info = new BgDataInfo();
                coll.add(info);
            }
        }
        catch (SQLException exp) {
            try {
                throw new BgBizException(BgBizException.GETDATA, exp, new Object[0]);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return null;
    }

    private BgDataCollection getBgData(Context ctx, BgFormInfo bgform) throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer(128);
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        BgDataCollection coll = new BgDataCollection();
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sb.toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                BgDataInfo info = new BgDataInfo();
                coll.add(info);
            }
        }
        catch (SQLException exp) {
            try {
                throw new BgBizException(BgBizException.GETDATA, exp, new Object[0]);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return coll;
    }

    private PeriodCollection getPeriodColl(Context ctx, BOSUuid id) {
        return null;
    }

    private BgFormCollection getBgForm(Context ctx, Date date, BOSUuid bgTypeId) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeOrgUnitParent(Context ctx, String table, OrgUnitCollection coll) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer(128);
        sb.append("insert into ");
        sb.append(table);
        sb.append(" (FID,FLevel, FIsLeaf, FName,FNumber,FLongNumber, FSuperID)");
        sb.append(" Values  (?,?,?,?,?,?,?)");
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sb.toString());
            for (int i = 0; i < coll.size(); ++i) {
                this.setValue(stmt, coll.get(i));
                stmt.addBatch();
            }
            stmt.executeBatch();
            SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            SQLUtils.cleanup(stmt, (Connection)conn);
        }
    }

    private void setValue(PreparedStatement stmt, OrgUnitInfo info) throws SQLException {
        stmt.setString(1, info.getId().toString());
        stmt.setInt(2, info.getInt("level"));
        stmt.setBoolean(3, info.getBoolean("isLeaf"));
        stmt.setString(4, info.getName());
        stmt.setString(5, info.getNumber());
        stmt.setString(6, info.getString("longNumber"));
        stmt.setString(7, BgHelper.getId(info.get("superOrgUnit")));
    }
}

