/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.SimpleTimer;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.ContextUtils;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.bg.BgAdjustFormFactory;
import com.kingdee.eas.ma.bg.BgAuditUtils;
import com.kingdee.eas.ma.bg.BgBizException;
import com.kingdee.eas.ma.bg.BgCtrlData;
import com.kingdee.eas.ma.bg.BgCtrlHelper;
import com.kingdee.eas.ma.bg.BgCtrlParam;
import com.kingdee.eas.ma.bg.BgDataFactory;
import com.kingdee.eas.ma.bg.BgDataInfo;
import com.kingdee.eas.ma.bg.BgDimensionEnum;
import com.kingdee.eas.ma.bg.BgElementEnum;
import com.kingdee.eas.ma.bg.BgFormDataSourceEnum;
import com.kingdee.eas.ma.bg.BgFormFactory;
import com.kingdee.eas.ma.bg.BgFormInfo;
import com.kingdee.eas.ma.bg.BgHelper;
import com.kingdee.eas.ma.bg.BgIncSourceTypeEnum;
import com.kingdee.eas.ma.bg.BgIncreaseReqFormEntryInfo;
import com.kingdee.eas.ma.bg.BgIncreaseReqFormException;
import com.kingdee.eas.ma.bg.BgIncreaseReqFormInfo;
import com.kingdee.eas.ma.bg.BgInstantApproveException;
import com.kingdee.eas.ma.bg.BgORMEngine;
import com.kingdee.eas.ma.bg.BgOrgHelper;
import com.kingdee.eas.ma.bg.BgPastDataFactory;
import com.kingdee.eas.ma.bg.BgPastDataInfo;
import com.kingdee.eas.ma.bg.BgPastRecordFactory;
import com.kingdee.eas.ma.bg.BgPastRecordInfo;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.IBgData;
import com.kingdee.eas.ma.bg.IBgForm;
import com.kingdee.eas.ma.bg.IBgPastData;
import com.kingdee.eas.ma.bg.IBgPastRecord;
import com.kingdee.eas.ma.bg.app.AbstractBgIncreaseReqFormControllerBean;
import com.kingdee.eas.ma.bg.app.BgControlControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgIncreaseReqFormControllerBean
extends AbstractBgIncreaseReqFormControllerBean {
    private static Logger logger = Logger.getLogger(BgIncreaseReqFormControllerBean.class);

    @Override
    protected BOSUuid[] _buildReqBill(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        HashMap<BOSUuid, BgIncreaseReqFormInfo> cache = new HashMap<BOSUuid, BgIncreaseReqFormInfo>();
        BgCtrlParam[] params = BgAuditUtils.getBgCtrlParaByUuid(ctx, billId);
        BgControlControllerBean bean = new BgControlControllerBean();
        params = bean.bgAudit2(ctx, params);
        for (int i = 0; i < params.length; ++i) {
            BgIncreaseReqFormInfo info = null;
            BgCtrlParam param = params[i];
            if (param.isOK()) continue;
            BOSUuid bgFormOrgUnitId = param.getBizOrgUnitId();
            Object bill = cache.get(bgFormOrgUnitId);
            if (bill != null) {
                info = (BgIncreaseReqFormInfo)bill;
            } else {
                info = this.buildInfo(ctx, param);
                cache.put(bgFormOrgUnitId, info);
            }
            BgIncreaseReqFormEntryInfo entry = new BgIncreaseReqFormEntryInfo();
            if (!info.getEntries().add(entry)) continue;
            this.buildEntry(info, param, entry);
        }
        BOSUuid[] ids = new BOSUuid[cache.size()];
        int i = 0;
        for (BgIncreaseReqFormInfo info : cache.values()) {
            IObjectPK id = this._addnew(ctx, (IObjectValue)info);
            ids[i++] = BOSUuid.read((String)id.toString());
        }
        return ids;
    }

    private void buildEntry(BgIncreaseReqFormInfo info, BgCtrlParam param, BgIncreaseReqFormEntryInfo entry) {
        entry.setSeq(info.getEntries().size());
        Iterator elemIter = param.getDatas().keySet().iterator();
        BigDecimal req = null;
        while (elemIter.hasNext()) {
            BgElementEnum ele = (BgElementEnum)((Object)elemIter.next());
            BgCtrlData data = param.getData(ele);
            if (data.isOK()) continue;
            req = BgCtrlHelper.getReqValue(data.getValue(), data.getBgBalance(), data.getFlxParam());
            entry.setBizElement(ele);
            entry.setReqValue(req);
            entry.setBgData(new BgDataInfo());
            entry.getBgData().setId(data.getBgDataId());
            entry.setBizValue(data.getValue());
            entry.setCurrency(new CurrencyInfo());
            entry.getCurrency().setId(param.getCurrencyId());
            entry.setDateType(data.getDataType());
        }
    }

    private BgIncreaseReqFormInfo buildInfo(Context ctx, BgCtrlParam param) throws BOSException, CodingRuleException, EASBizException {
        BgIncreaseReqFormInfo info = new BgIncreaseReqFormInfo();
        info.setBgType(new BgTypeInfo());
        info.getBgType().setId(param.getBgTypeId());
        info.setBizDate(param.getBizDate());
        IBgForm iBgForm = BgFormFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("orgUnit"));
        ObjectUuidPK pk = new ObjectUuidPK(param.getBOSUuid("bgformorgunitid"));
        BgFormInfo bgForm = (BgFormInfo)iBgForm.getValue((IObjectPK)pk);
        info.setBizOrgUnit(bgForm.getOrgUnit());
        info.setCompany(new CompanyOrgUnitInfo());
        BOSUuid companyId = param.getCompanyId();
        info.getCompany().setId(companyId);
        info.setPeriod(new PeriodInfo());
        info.getPeriod().setId(param.getPeriodId());
        info.setSourceBillId(param.getSrcBillId().toString());
        info.setSrcType(BgIncSourceTypeEnum.BILL);
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        info.setCreator(ContextUtils.getUser((Context)ctx));
        info.setHandler(ContextUtils.getUser((Context)ctx));
        info.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        String number = this.getCodeNumber(ctx, info, companyId);
        if (number != null) {
            info.setNumber(number);
        }
        info.setHasEffected(true);
        return info;
    }

    private String getCodeNumber(Context ctx, BgIncreaseReqFormInfo info, BOSUuid companyId) throws BOSException, CodingRuleException, EASBizException {
        String str;
        String number = null;
        ICodingRuleManager code = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        number = !code.isExist((IObjectValue)info, companyId.toString()) ? (str = "IncReq" + new Timestamp(System.currentTimeMillis()).toString()) : code.getNumber((IObjectValue)info, companyId.toString());
        return number;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getBgFormIdByBgData(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        String result = "";
        String sql = "select a.fbgformid from t_bg_bgentry a,t_bg_bgdata b where a.fid=b.fbgentryid  and b.fid = (select top 1 c.fbgdataid from t_bg_bgincreasereqformentry c , t_bg_bgincreasereqform d where c.fbillid=d.fid and d.fid=?)";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, BOSUuid.read((String)pk.toString()).toString());
            rs = stmt.executeQuery();
            if (rs.next()) {
                result = rs.getString(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
                catch (SQLDataException e2) {
                    throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return result;
    }

    @Override
    protected int _getMaxPeriodYear(Context ctx, String bgFormId) throws BOSException, EASBizException {
        int year = 0;
        String updateSql = "select max(FperiodYear) from t_bd_period where fid in (select fperiodid from t_bg_bgentry where fbgformid=?)";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(updateSql);
            stmt.setString(1, bgFormId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                year = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return year;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        boolean isNumberDup;
        BgIncreaseReqFormInfo birfi = (BgIncreaseReqFormInfo)model;
        BOSUuid id = birfi.getId();
        String fid = "";
        if (id != null) {
            fid = id.toString();
        }
        if (isNumberDup = this._checkDupNumber(ctx, birfi.getNumber(), fid)) {
            throw new BgIncreaseReqFormException(BgIncreaseReqFormException.DUPNUMBER);
        }
        return super._submit(ctx, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        boolean isNumberDup = this._checkDupNumber(ctx, model.getString("number"), "");
        if (isNumberDup) {
            throw new BgIncreaseReqFormException(BgIncreaseReqFormException.DUPNUMBER);
        }
        if (BgHelper.ISDeBug) {
            BgORMEngine.setIsNew(model, true);
            BgIncreaseReqFormInfo info = (BgIncreaseReqFormInfo)model;
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            info.setCreator(userInfo);
            info.setLastUpdateUser(null);
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            info.setCreateTime(timestamp);
            info.setLastUpdateTime(null);
            info.setCU(BgOrgHelper.getDefCU());
            ArrayList<BgIncreaseReqFormEntryInfo> entryColl = new ArrayList<BgIncreaseReqFormEntryInfo>();
            BgIncreaseReqFormEntryInfo[] bgEntryAry = new BgIncreaseReqFormEntryInfo[]{};
            Iterator iter = info.getEntries().iterator();
            while (iter.hasNext()) {
                BgIncreaseReqFormEntryInfo entry = (BgIncreaseReqFormEntryInfo)iter.next();
                entry.setBill(info);
                entryColl.add(entry);
            }
            BgORMEngine.addnewVO(ctx, (IObjectValue[])new BgIncreaseReqFormInfo[]{info});
            BgORMEngine.addnewVO(ctx, (IObjectValue[])entryColl.toArray(bgEntryAry));
            return new ObjectUuidPK(info.getId());
        }
        return super._addnew(ctx, model);
    }

    public static void updateInfo(Context ctx, BgIncreaseReqFormInfo info) throws EASBizException {
        ArrayList<BgIncreaseReqFormEntryInfo> bgEntryList = new ArrayList<BgIncreaseReqFormEntryInfo>();
        List bgRemoveEntryList = new ArrayList();
        bgRemoveEntryList = BgORMEngine.getRemoveList((IObjectValue)info, "entries");
        Iterator iter = info.getEntries().iterator();
        while (iter.hasNext()) {
            BgIncreaseReqFormEntryInfo entryInfo = (BgIncreaseReqFormEntryInfo)iter.next();
            if (!BgORMEngine.isNeedUpdate((IObjectValue)entryInfo)) continue;
            entryInfo.setBill(info);
            bgEntryList.add(entryInfo);
        }
        BgORMEngine.removeVOColl(ctx, bgRemoveEntryList.toArray(new BOSUuid[0]));
        if (BgORMEngine.isNeedUpdate((IObjectValue)info)) {
            BgORMEngine.storeVOColl(ctx, new IObjectValue[]{info});
        }
        BgORMEngine.storeVOColl(ctx, bgEntryList.toArray());
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BgIncreaseReqFormInfo newMode = (BgIncreaseReqFormInfo)model;
        boolean isNumberDup = this._checkDupNumber(ctx, model.getString("number"), ((BOSUuid)model.get("id")).toString());
        if (isNumberDup) {
            throw new BgIncreaseReqFormException(BgIncreaseReqFormException.DUPNUMBER);
        }
        BgORMEngine.setIsBgORM(model, true);
        if (BgORMEngine.getIsBgORM(model)) {
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            newMode.setLastUpdateUser(userInfo);
            newMode.setLastUpdateTime(new Timestamp(new Date().getTime()));
            BgIncreaseReqFormControllerBean.updateInfo(ctx, newMode);
        } else {
            super._update(ctx, pk, model);
        }
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._inAudit(ctx, pk);
    }

    private void checkPeriod(Context ctx, BgIncreaseReqFormInfo info) throws BOSException, EASBizException, BgIncreaseReqFormException {
        PeriodInfo period = info.getPeriod();
        int year = period.getPeriodYear();
        int number = period.getPeriodNumber();
        BOSUuid companyId = info.getCompany().getId();
        PeriodInfo currentPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (Date)new Date(System.currentTimeMillis()), (IObjectPK)new ObjectUuidPK(companyId));
        int currentYear = currentPeriod.getPeriodYear();
        int currentNumber = currentPeriod.getPeriodNumber();
        if (currentYear > year || currentYear == year && currentNumber > number) {
            throw new BgIncreaseReqFormException(BgIncreaseReqFormException.NOTAUDIT);
        }
    }

    @Override
    protected void _cancel(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BOSUuid id = BOSUuid.read((String)pk.toString());
        BgIncreaseReqFormInfo info = this.getBgIncreaseReqFormInfo(ctx, " select checkedStatus ,srcType,company.id, entries.reqValue,entries.bgData.id,entries.bgData.bgValue,  period.id, period.periodYear, period.periodQuarter,period.periodNumber where id='" + pk.toString() + "'");
        if (info.getSrcType() == BgIncSourceTypeEnum.BGDATA) {
            this.checkPeriod(ctx, info);
        }
        info.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        info.setHasEffected(false);
        info.setAuditor(null);
        this.changeBgData(ctx, info, new BigDecimal("-1"));
        this.updateInc(ctx, pk.toString(), 1);
        String bgFormId = this.getBgFormIdByBgData(ctx, pk);
        this.addBgFormPastRecord(ctx, bgFormId, info, new BigDecimal("-1"));
    }

    private void changeBgData(Context ctx, BgIncreaseReqFormInfo info, BigDecimal quotiety) throws EASBizException, BOSException {
        String updateSql = "update t_bg_bgdata set fbgvalue=fbgvalue+?,fbgbalance=fbgbalance+? where fid=?";
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getConnection(ctx);
            Iterator iter = info.getEntries().iterator();
            while (iter.hasNext()) {
                BgIncreaseReqFormEntryInfo enInfo = (BgIncreaseReqFormEntryInfo)iter.next();
                stmt = conn.prepareStatement(updateSql);
                BigDecimal changeValue = enInfo.getReqValue().multiply(quotiety);
                stmt.setBigDecimal(1, changeValue);
                stmt.setBigDecimal(2, changeValue);
                stmt.setString(3, enInfo.getBgData().getId().toString());
                stmt.execute();
                SimpleTimer time = new SimpleTimer();
                Vector vec = this.getUPBgDatas(ctx, (IObjectPK)new ObjectUuidPK(enInfo.getBgData().getId()));
                logger.debug((Object)("\u83b7\u53d6\u4e0a\u7ea7bgData\u65f6\u95f4\uff1a" + time.getTime()));
                if (vec == null || vec.size() == 0) continue;
                int size = vec.size();
                for (int i = 0; i < size; ++i) {
                    String id = (String)vec.get(i);
                    stmt = conn.prepareStatement(updateSql);
                    stmt.setBigDecimal(1, changeValue);
                    stmt.setBigDecimal(2, changeValue);
                    stmt.setString(3, BOSUuid.read((String)id).toString());
                    stmt.execute();
                }
            }
        }
        catch (SQLException e) {
            throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
        }
        finally {
            SQLUtils.cleanup(stmt, (Connection)conn);
        }
    }

    @Override
    protected void _audit(Context ctx, BOSUuid[] ids) throws BOSException, EASBizException {
        if (!BgHelper.isEmpty(ids)) {
            return;
        }
        for (int i = 0; i < ids.length; ++i) {
            this._audit(ctx, (IObjectPK)new ObjectUuidPK(ids[i]));
        }
    }

    @Override
    protected void _inAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String bgFormId = this.getBgFormIdByBgData(ctx, pk);
        if (BgAdjustFormFactory.getLocalInstance(ctx).checkAdjust(bgFormId)) {
            throw new BgIncreaseReqFormException(BgIncreaseReqFormException.HASADJUSTFORM);
        }
        BgIncreaseReqFormInfo info = this.getBgIncreaseReqFormInfo(ctx, " select checkedStatus ,srcType,company.id, entries.reqValue,entries.bgData.id,entries.bgData.bgValue,  period.id, period.periodYear, period.periodQuarter,period.periodNumber where id='" + pk.toString() + "'");
        if (info.getCheckedStatus().equals((Object)CheckedStatusEnum.AUDITED)) {
            throw new BgIncreaseReqFormException(BgIncreaseReqFormException.HASAUDITED);
        }
        if (info.getSrcType() == BgIncSourceTypeEnum.BGDATA) {
            this.checkPeriod(ctx, info);
        }
        this.changeBgData(ctx, info, new BigDecimal("1"));
        this.updateInc(ctx, pk.toString(), 2);
        this.addBgFormPastRecord(ctx, bgFormId, info, new BigDecimal("1"));
    }

    private void updateInc(Context ctx, String id, int state) throws BOSException, EASBizException {
        String sql = " update t_bg_bgincreasereqform set FCheckedStatus = ? ,FAuditorID = ? where fid=?";
        Connection connection = null;
        PreparedStatement ps = null;
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.setInt(1, state);
            if (state == 1) {
                ps.setString(2, null);
            } else {
                ps.setString(2, ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
            }
            ps.setString(3, id);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
    }

    private void addBgFormPastRecord(Context ctx, String bgFormId, BgIncreaseReqFormInfo info, BigDecimal quotiety) throws BOSException, EASBizException {
        IBgPastRecord iRecord = BgPastRecordFactory.getLocalInstance(ctx);
        IBgPastData iData = BgPastDataFactory.getLocalInstance(ctx);
        String sql = " select count(fid) cnt from t_bg_bgpastrecord where fbgformid = ? ";
        ResultSet rs = null;
        Connection connection = null;
        PreparedStatement ps = null;
        int currentSeq = 0;
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.setString(1, bgFormId);
            rs = ps.executeQuery();
            if (rs.next()) {
                currentSeq = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        if (currentSeq == 0) {
            BgPastRecordInfo recordInfo = new BgPastRecordInfo();
            recordInfo.setModifyDate(new Date(System.currentTimeMillis()));
            recordInfo.setModifier(ContextUtils.getUser((Context)ctx));
            BgFormInfo bgForm = new BgFormInfo();
            bgForm.setId(BOSUuid.read((String)bgFormId));
            recordInfo.setBgForm(bgForm);
            recordInfo.setSeq(1);
            Iterator iter = info.getEntries().iterator();
            while (iter.hasNext()) {
                BgIncreaseReqFormEntryInfo enInfo = (BgIncreaseReqFormEntryInfo)iter.next();
                BgPastDataInfo dataInfo = new BgPastDataInfo();
                dataInfo.setBalance(enInfo.getReqValue().multiply(quotiety));
                dataInfo.setBgData(enInfo.getBgData());
                dataInfo.setBgPastRecord(recordInfo);
                dataInfo.setDataSource(BgFormDataSourceEnum.INCREASE);
                dataInfo.setPastValue(enInfo.getBgData().getBgValue());
                recordInfo.getPastData().add(dataInfo);
            }
            iRecord.addnew((CoreBaseInfo)recordInfo);
        } else {
            BgPastRecordInfo recordInfo = new BgPastRecordInfo();
            recordInfo.setModifyDate(new Date(System.currentTimeMillis()));
            recordInfo.setModifier(ContextUtils.getUser((Context)ctx));
            BgFormInfo bgForm = new BgFormInfo();
            bgForm.setId(BOSUuid.read((String)bgFormId));
            recordInfo.setBgForm(bgForm);
            recordInfo.setSeq(currentSeq + 1);
            Iterator iter = info.getEntries().iterator();
            while (iter.hasNext()) {
                BgIncreaseReqFormEntryInfo enInfo = (BgIncreaseReqFormEntryInfo)iter.next();
                BgPastDataInfo dataInfo = new BgPastDataInfo();
                dataInfo.setBalance(enInfo.getReqValue().multiply(quotiety));
                dataInfo.setBgData(enInfo.getBgData());
                dataInfo.setBgPastRecord(recordInfo);
                dataInfo.setDataSource(BgFormDataSourceEnum.INCREASE);
                dataInfo.setPastValue(enInfo.getBgData().getBgValue());
                recordInfo.getPastData().add(dataInfo);
            }
            iRecord.addnew((CoreBaseInfo)recordInfo);
        }
    }

    protected Vector getUPBgDatas(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        Vector<String> result = new Vector<String>(5);
        IBgData irf = BgDataFactory.getLocalInstance(ctx);
        BgDataInfo info = irf.getBgDataInfo(pk);
        ResultSet rs = null;
        Connection connection = null;
        PreparedStatement sm = null;
        int bgCycle = 0;
        String periodId = "";
        String bgFormId = "";
        Vector bgDim = new Vector();
        String sql1 = " select a.fbgcycle bgCycle ,a.fperiodid period ,a.fbgformid bgForm from  t_bg_bgentry a ,t_bg_bgdata b where a.fid = b.fbgentryid and b.fid = ? ";
        StringBuffer sql = new StringBuffer(60);
        boolean isEmpty = true;
        try {
            connection = this.getConnection(ctx);
            sm = connection.prepareStatement(sql1);
            sm.setString(1, BOSUuid.read((String)pk.toString()).toString());
            rs = sm.executeQuery();
            if (rs.next()) {
                bgCycle = rs.getInt("bgCycle");
                periodId = rs.getString("period");
                bgFormId = rs.getString("bgForm");
            }
            bgDim = this.getBgDimension(ctx, bgFormId);
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, sm, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)connection);
        if (((BgDimensionEnum)((Object)bgDim.get(0))).getValue() != 1100 && ((BgDimensionEnum)((Object)bgDim.get(0))).getValue() != 900 && ((BgDimensionEnum)((Object)bgDim.get(0))).getValue() != 500) {
            return result;
        }
        SimpleTimer time = new SimpleTimer();
        Vector vec = this.getUPBgEntryInfo(ctx, pk, bgCycle, periodId, bgFormId, bgDim);
        logger.debug((Object)("\u83b7\u53d6bgData\u65f6\u95f4\uff1a" + time.getTime()));
        if (vec == null || vec.size() == 0) {
            return null;
        }
        try {
            connection = this.getConnection(ctx);
            String[] selfStr = this.getSelfBgEntryInfo(ctx, pk, bgDim);
            for (int i = 0; i < vec.size(); ++i) {
                String[] str = (String[])vec.get(i);
                if (bgDim.size() == 1 ? selfStr[0].equals("") || str[1].equals("") || !selfStr[0].startsWith(str[1]) : (bgDim.size() == 2 ? selfStr[0].equals("") || str[1].equals("") || !selfStr[0].startsWith(str[1]) || selfStr[3].equals("") || str[4].equals("") || !selfStr[3].equals(str[4]) : bgDim.size() == 3 && (selfStr[0].equals("") || str[1].equals("") || !selfStr[0].startsWith(str[1]) || selfStr[4].equals("") || str[5].equals("") || !selfStr[4].equals(str[5]) || selfStr[5].equals("") || str[6].equals("") || !selfStr[5].equals(str[6])))) continue;
                String serSql = "select fid from t_bg_bgdata where felementnumber=? and fcurrencyid=? and fbgentryid=? and fid!=?";
                sm = connection.prepareStatement(serSql);
                sm.setString(1, info.getElementNumber());
                sm.setString(2, info.getCurrency().getId().toString());
                sm.setString(3, str[0]);
                sm.setString(4, pk.toString());
                rs = sm.executeQuery();
                while (rs.next()) {
                    result.add(rs.getString(1));
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)connection);
        }
        return result;
    }

    private String[] getSelfBgEntryInfo(Context ctx, IObjectPK pk, Vector bgDim) throws BOSException {
        int i;
        ResultSet rs = null;
        Connection connection = null;
        PreparedStatement sm = null;
        int bgDimSize = bgDim.size();
        String[] result = new String[2 * bgDimSize];
        String serSql = " select ";
        for (i = 1; i <= bgDimSize; ++i) {
            serSql = serSql + " i" + i + ".flongnumber , ";
        }
        for (i = 1; i <= bgDimSize; ++i) {
            serSql = serSql + " i" + i + ".fitemnumber ,";
        }
        serSql = serSql.substring(0, serSql.length() - 1);
        serSql = serSql + " from T_BG_BgEntry a ";
        for (i = 1; i <= bgDimSize; ++i) {
            serSql = serSql + " inner JOIN T_BG_BgItem i" + i + " ON a.FBgItem" + i + "ID = i" + i + ".FID ";
        }
        serSql = serSql + " where a.fid in ( select fbgentryid from t_bg_bgdata where fid =? )";
        try {
            connection = this.getConnection(ctx);
            sm = connection.prepareStatement(serSql);
            sm.setString(1, pk.toString());
            rs = sm.executeQuery();
            if (rs.next()) {
                for (i = 1; i <= 2 * bgDimSize; ++i) {
                    result[i - 1] = rs.getString(i) == null ? "" : rs.getString(i);
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, sm, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)connection);
        return result;
    }

    private Vector getUPBgEntryInfo(Context ctx, IObjectPK pk, int bgCycle, String periodId, String bgFormId, Vector bgDim) throws EASBizException, BOSException {
        ResultSet rs = null;
        Connection connection = null;
        PreparedStatement sm = null;
        Vector<String[]> vec = new Vector<String[]>(5);
        StringBuffer sql = new StringBuffer(60);
        boolean isEmpty = true;
        try {
            int i;
            connection = this.getConnection(ctx);
            int bgDimSize = bgDim.size();
            String serSql = "select a.fid ";
            for (i = 1; i <= bgDimSize; ++i) {
                serSql = serSql + " , i" + i + ".flongnumber ";
            }
            for (i = 1; i <= bgDimSize; ++i) {
                serSql = serSql + " , i" + i + ".fitemnumber ";
            }
            serSql = serSql + " from T_BG_BgEntry a ";
            for (i = 1; i <= bgDimSize; ++i) {
                serSql = serSql + " inner JOIN T_BG_BgItem i" + i + " ON a.FBgItem" + i + "ID = i" + i + ".FID ";
            }
            serSql = serSql + " where fbgcycle = ? and fperiodid = ? and fbgformid = ? ";
            sql.append(serSql);
            sm = connection.prepareStatement(sql.toString());
            sm.setInt(1, bgCycle);
            sm.setString(2, periodId);
            sm.setString(3, bgFormId);
            rs = sm.executeQuery();
            for (i = 0; i < bgDimSize; ++i) {
                if (((BgDimensionEnum)((Object)bgDim.get(i))).getValue() != 1100 && ((BgDimensionEnum)((Object)bgDim.get(i))).getValue() != 900 && ((BgDimensionEnum)((Object)bgDim.get(i))).getValue() != 500) continue;
                isEmpty = false;
                break;
            }
            while (rs.next() && !isEmpty) {
                String[] str = new String[1 + 2 * bgDimSize];
                str[0] = rs.getString(1) == null ? "" : rs.getString(1);
                int index = 1;
                for (int i2 = 1; i2 <= 2 * bgDimSize; ++i2) {
                    str[index] = rs.getString(1 + index) == null ? "" : rs.getString(1 + index);
                    ++index;
                }
                vec.add(str);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, sm, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)connection);
        if (isEmpty) {
            return null;
        }
        return vec;
    }

    protected Vector getBgDimension(Context ctx, String bgFormId) throws BOSException, EASBizException {
        Vector<BgDimensionEnum> result = new Vector<BgDimensionEnum>();
        String sql = "SELECT RefDims.FBgDimension bgdim FROM T_BG_BgForm BgForm INNER JOIN T_BG_BgTemplate BgTemplate ON BgForm.FBgTemplateID = BgTemplate.FID INNER JOIN T_BG_ReferencedDimension RefDims ON BgForm.FBgTemplateID = RefDims.FBgTemplateID WHERE (BgForm.FIsCurrent = 1) AND (BgForm.FID = ?) ";
        Connection conn = this.getConnection(ctx);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        BgFormInfo bgFormInfo = new BgFormInfo();
        try {
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, BOSUuid.read((String)bgFormId).toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                result.add(BgDimensionEnum.getEnum(rs.getInt(1)));
            }
        }
        catch (SQLException e) {
            try {
                throw new BgBizException(BgBizException.GETDATA, e, new Object[]{"bgForm"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return result;
    }

    protected boolean _checkDupNumber(Context ctx, String number, String id) throws BOSException, EASBizException {
        boolean result = false;
        ResultSet rs = null;
        Connection connection = null;
        PreparedStatement sm = null;
        StringBuffer sql = new StringBuffer(60);
        sql.append(" select fid from T_BG_BgIncreaseReqForm where fnumber=? ");
        if (!id.equals("")) {
            sql.append(" and fid!=?");
        }
        try {
            connection = this.getConnection(ctx);
            sm = connection.prepareStatement(sql.toString());
            sm.setString(1, number);
            if (!id.equals("")) {
                sm.setString(2, id);
            }
            if ((rs = sm.executeQuery()).next()) {
                result = true;
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, sm, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)connection);
        return result;
    }
}

