/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgFormInfo;
import com.kingdee.eas.ma.bg.BgPostilCollection;
import com.kingdee.eas.ma.bg.BgPostilInfo;
import com.kingdee.eas.ma.bg.app.AbstractBgPostilControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;

public class BgPostilControllerBean
extends AbstractBgPostilControllerBean {
    @Override
    protected IObjectCollection _getCollectionByBgFormId(Context ctx, IObjectPK bgFormId) throws BOSException, EASBizException {
        BgPostilCollection bgPostilCollection = new BgPostilCollection();
        if (bgFormId == null) {
            return bgPostilCollection;
        }
        PreparedStatement statement = null;
        ResultSet rs = null;
        Connection conn = null;
        conn = this.getConnection(ctx);
        Locale local = ctx.getLocale();
        StringBuffer strBuff = new StringBuffer(500);
        strBuff.append("select distinct FPos.FID AS FID, FPos.FSeq AS FSeq, FPos.FDescription AS FDes, FPos.FCreateTime AS FTime, FBgForm.Fid AS FFormId, FBgForm.FName AS FName, FUser.Fid AS FUserId, FUser.FName_");
        strBuff.append(local.toString());
        strBuff.append(" AS FUserName from T_BG_BgPostil FPos, T_BG_BgForm FBgForm, T_PM_User FUser where FPos.FBgFormId = FBgForm.FId and FPos.FUserId = FUser.FID and FPos.fbgFormid =? ");
        strBuff.append(" order by FPos.FSeq ");
        try {
            statement = conn.prepareStatement(strBuff.toString());
            statement.setString(1, bgFormId.toString());
            rs = statement.executeQuery();
            strBuff = null;
            while (rs.next()) {
                BgPostilInfo bgPostilInfo = new BgPostilInfo();
                String strId = rs.getString("FID");
                bgPostilInfo.setId(BOSUuid.read((String)strId));
                bgPostilInfo.setSeq(rs.getInt("FSeq"));
                bgPostilInfo.setDescription(rs.getString("FDes"));
                bgPostilInfo.setCreateTime(rs.getTimestamp("FTime"));
                BgFormInfo bgFormInfo = new BgFormInfo();
                bgFormInfo.setId(BOSUuid.read((String)bgFormId.toString()));
                bgFormInfo.setName(rs.getString("FName"));
                bgPostilInfo.setBgForm(bgFormInfo);
                String strUserId = rs.getString("FUserId");
                if (strUserId != null) {
                    UserInfo userInfo = new UserInfo();
                    userInfo.setId(BOSUuid.read((String)strUserId));
                    userInfo.setName(rs.getString("FUserName"));
                    bgPostilInfo.setUser(userInfo);
                }
                bgPostilCollection.add(bgPostilInfo);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        return bgPostilCollection;
    }

    @Override
    protected int _getSeqByBgFromId(Context ctx, IObjectPK bgFormId) throws BOSException, EASBizException {
        int seq = 0;
        if (ctx == null) {
            return seq;
        }
        PreparedStatement statement = null;
        ResultSet rs = null;
        Connection conn = null;
        String strSql = "Select count(fid) as fseq from T_BG_BgPostil where FBgFormId = ?";
        conn = this.getConnection(ctx);
        try {
            statement = conn.prepareStatement(strSql);
            statement.setString(1, bgFormId.toString());
            rs = statement.executeQuery();
            if (rs.next()) {
                seq = rs.getInt("fseq");
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        return seq;
    }
}

