/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageSender;
import com.kingdee.bos.service.message.agent.Sender;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.bg.BgCycleTypeEnum;
import com.kingdee.eas.ma.bg.BgFormFactory;
import com.kingdee.eas.ma.bg.BgFormHelper;
import com.kingdee.eas.ma.bg.BgFormInfo;
import com.kingdee.eas.ma.bg.BgFormStateEnum;
import com.kingdee.eas.ma.bg.BgInstantApproveException;
import com.kingdee.eas.ma.bg.BgVersionInfo;
import com.kingdee.eas.ma.bg.IBgForm;
import com.kingdee.eas.ma.bg.app.AbstractBgRollFormControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class BgRollFormControllerBean
extends AbstractBgRollFormControllerBean {
    @Override
    protected void _rollForm(Context ctx, IObjectValue sourceBgFormInfo) throws BOSException, EASBizException {
        BgFormInfo srcBgFormInfo = (BgFormInfo)sourceBgFormInfo;
        BgFormInfo cloneBgFormInfo = srcBgFormInfo.deepClone();
        String bgSourceFormId = srcBgFormInfo.getId().toString();
        String bgCloneFormId = cloneBgFormInfo.getId().toString();
        IBgForm iBg = BgFormFactory.getLocalInstance(ctx);
        cloneBgFormInfo.setState(BgFormStateEnum.Adjusted);
        cloneBgFormInfo.setNumber(cloneBgFormInfo.getNumber() + "V1.1");
        BgFormInfo oldBgFormInfo = iBg.getBgFormInfo((IObjectPK)new ObjectUuidPK(srcBgFormInfo.getId()), BgFormHelper.getDecDistDataSelectors());
        cloneBgFormInfo = iBg.updateWithRecord(cloneBgFormInfo, oldBgFormInfo);
        iBg.addnew((CoreBaseInfo)cloneBgFormInfo);
        String querySql = "select FOriginalBgFormId,FAdaptedBgFormId,FPreBgFormId from T_BG_BgVersion where FAdaptedBgFormId = ? ";
        String insertSql = "insert into T_BG_BgVersion(FID,FOriginalBgFormId,FAdaptedBgFormId,FPreBgFormId) values(?,?,?,?)";
        Connection conn = null;
        PreparedStatement stmt1 = null;
        PreparedStatement stmt2 = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            stmt1 = conn.prepareStatement(querySql);
            stmt2 = conn.prepareStatement(insertSql);
            stmt1.setString(1, bgSourceFormId);
            rs = stmt1.executeQuery();
            stmt2.setString(1, BOSUuid.create((BOSObjectType)new BgVersionInfo().getBOSType()).toString());
            if (rs.next()) {
                stmt2.setString(2, rs.getString(1));
            } else {
                stmt2.setString(2, bgSourceFormId);
            }
            stmt2.setString(3, bgCloneFormId);
            stmt2.setString(4, bgSourceFormId);
            stmt2.execute();
        }
        catch (SQLException e) {
            try {
                throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt1, (Connection)conn);
                SQLUtils.cleanup(stmt2);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt1, (Connection)conn);
        SQLUtils.cleanup((Statement)stmt2);
    }

    @Override
    protected IObjectValue _getFinalPeriod(Context ctx, String bgFormId, BgCycleTypeEnum cycle) throws BOSException, EASBizException {
        PeriodInfo pInfo = new PeriodInfo();
        String pId = null;
        String querySql = "select a.FPeriodId from T_BG_BgEntry a,T_BD_Period b where a.FPeriodId=b.FId and a.FBgFormId = ? and a.FBgCycle=? order by b.FPeriodYear desc ,b.FPeriodQuarter desc,b.FPeriodNumber desc";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(querySql);
            stmt.setString(1, bgFormId);
            stmt.setInt(2, cycle.getValue());
            rs = stmt.executeQuery();
            if (rs.next()) {
                pId = rs.getString(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        pInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(pId));
        return pInfo;
    }

    @Override
    protected IObjectValue _getSplitedPeriod(Context ctx, String bgFormId) throws BOSException, EASBizException {
        PeriodInfo pInfo = new PeriodInfo();
        return pInfo;
    }

    @Override
    protected String[] _rollAlarm(Context ctx) throws BOSException, EASBizException {
        int DAYAHEAD = 5;
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        int month = calendar.get(2);
        int day = calendar.get(5);
        StringBuffer sb = new StringBuffer(400);
        sb.append("SELECT DISTINCT T_BG_BgForm.FName as FormName,");
        sb.append("T_BG_BgForm.FCreatorId as CreateId,");
        sb.append("T_ORG_BaseUnit.FName_L1 as OrgName_L1,");
        sb.append("T_ORG_BaseUnit.FName_L2 as OrgName_L2,");
        sb.append("T_ORG_BaseUnit.FName_L3 as OrgName_L3");
        sb.append(" FROM ");
        sb.append("T_BG_BgEntry");
        sb.append(" INNER JOIN T_BD_Period ON T_BG_BgEntry.FPeriodID = T_BD_Period.FID");
        sb.append(" INNER JOIN T_BG_BgForm ON T_BG_BgEntry.FBgFormID = T_BG_BgForm.FID");
        sb.append(" INNER JOIN T_ORG_BaseUnit ON T_BG_BgForm.FOrgUnitID = T_ORG_BaseUnit.FID");
        sb.append(" INNER JOIN T_BG_BgTemplate ON T_BG_BgForm.FBgTemplateID = T_BG_BgTemplate.FID");
        sb.append(" WHERE T_BG_BgForm.FState = 2");
        sb.append(" AND T_BG_BgTemplate.FBgMethod = 2");
        sb.append(" AND T_BG_BgEntry.FIsLeafPeriod = 1");
        sb.append(" AND year(T_BD_Period.FEndDate) = ?");
        sb.append(" AND month(T_BD_Period.FEndDate) = ?");
        sb.append(" AND DayOfMonth(T_BD_Period.FEndDate) = ?");
        sb.append(" ORDER BY T_BG_BgForm.FName");
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String[] strNameArray = new String[5];
        Vector<String[]> vec = new Vector<String[]>();
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sb.toString());
            int index = 1;
            stmt.setInt(index++, year);
            stmt.setInt(index++, month + 1);
            stmt.setInt(index++, day + 5);
            rs = stmt.executeQuery();
            while (rs.next()) {
                strNameArray[0] = rs.getString("FormName");
                strNameArray[1] = rs.getString("CreateId");
                strNameArray[2] = rs.getString("OrgName_L1");
                strNameArray[3] = rs.getString("OrgName_L2");
                strNameArray[4] = rs.getString("OrgName_L3");
                vec.add(strNameArray);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        int size = vec.size();
        Sender sender = MessageSender.getInstance();
        for (int i = 0; i < size; ++i) {
            String[] strAay = (String[])vec.elementAt(i);
            Hashtable<Locale, String> titles = new Hashtable<Locale, String>();
            titles.put(new Locale("L2"), strAay[0]);
            Hashtable<Locale, String> bodys = new Hashtable<Locale, String>();
            bodys.put(new Locale("L2"), strAay[0]);
            String recive = strAay[1];
            Message msg = null;
            sender.sendMessage(msg);
        }
        return strNameArray;
    }

    @Override
    protected boolean _checkAddedPeriod(Context ctx, String bgFormId, String orgUnitId, String bgTypeId, int beginNumber, int endNumber) throws BOSException, EASBizException {
        int result = 0;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String sql = "select count(a.fid) from t_bg_bgentry a,t_bd_period b where a.fbgformid in  (select fid from t_bg_bgform where (fstate=2 or fstate=1) and FOrgUnitID=? and fbgtypeid=?) and  a.fperiodid=b.fid and  (b.fperiodyear * 100) + b.fperiodnumber>? and  (b.fperiodyear * 100) + b.fperiodnumber<=? and  a.fbgformid != ? ";
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, orgUnitId);
            stmt.setString(2, bgTypeId);
            stmt.setInt(3, beginNumber);
            stmt.setInt(4, endNumber);
            stmt.setString(5, bgFormId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return result > 0;
    }

    @Override
    protected boolean _checkNewPeriod(Context ctx, String orgUnitId, String bgTypeId, int beginNumber, int endNumber) throws BOSException, EASBizException {
        int result = 0;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String sql = "select count(a.fid) from t_bg_bgentry a,t_bd_period b where a.fbgformid in  (select fid from t_bg_bgform where (fstate=2 or fstate=4) and FOrgUnitID=? and fbgtypeid=?) and  a.fperiodid=b.fid and  (b.fperiodyear * 100) + b.fperiodnumber>? and  (b.fperiodyear * 100) + b.fperiodnumber<=? ";
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, orgUnitId);
            stmt.setString(2, bgTypeId);
            stmt.setInt(3, beginNumber);
            stmt.setInt(4, endNumber);
            rs = stmt.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return result > 0;
    }
}

