/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgFormDAFactory;
import com.kingdee.eas.ma.bg.BgFormInfo;
import com.kingdee.eas.ma.bg.BgHelper;
import com.kingdee.eas.ma.bg.BgManagerFactory;
import com.kingdee.eas.ma.bg.BgRptTemplateDAFactory;
import com.kingdee.eas.ma.bg.BgRptTemplateInfo;
import com.kingdee.eas.ma.bg.BgSchemeFactory;
import com.kingdee.eas.ma.bg.BgSchemeHelper;
import com.kingdee.eas.ma.bg.BgSchemeInfo;
import com.kingdee.eas.ma.bg.BgTemplateDAFactory;
import com.kingdee.eas.ma.bg.BgTemplateException;
import com.kingdee.eas.ma.bg.BgTemplateFactory;
import com.kingdee.eas.ma.bg.BgTemplateInfo;
import com.kingdee.eas.ma.bg.BgTypeCollection;
import com.kingdee.eas.ma.bg.BgTypeFactory;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.IBgFormDA;
import com.kingdee.eas.ma.bg.IBgManager;
import com.kingdee.eas.ma.bg.IBgRptTemplateDA;
import com.kingdee.eas.ma.bg.IBgScheme;
import com.kingdee.eas.ma.bg.IBgTemplateDA;
import com.kingdee.eas.ma.bg.IBgType;
import com.kingdee.eas.ma.bg.app.AbstractBgRptFormDAControllerBean;

public class BgRptFormDAControllerBean
extends AbstractBgRptFormDAControllerBean {
    @Override
    protected IObjectValue _getBgForm(Context ctx, IObjectValue bgType, IObjectValue orgUnit, IObjectValue bgScheme, boolean autoCreated) throws BOSException, EASBizException {
        BgFormInfo bfi = null;
        IBgFormDA iBgFormDa = BgFormDAFactory.getLocalInstance(ctx);
        bfi = iBgFormDa.matchSingleForm(bgType.getBOSUuid("id").toString(), orgUnit.getBOSUuid("id").toString(), bgScheme.getBOSUuid("id").toString());
        if (bfi == null) {
            if (autoCreated) {
                IBgTemplateDA iBgTpDa = BgTemplateDAFactory.getLocalInstance(ctx);
                BgTemplateInfo bgTemplateInfo = iBgTpDa.getCurrentBgTemplate(orgUnit.getBOSUuid("id").toString(), bgType.getBOSUuid("id").toString());
                if (bgTemplateInfo == null) {
                    throw new BgTemplateException(BgTemplateException.NOCURRENTTEMPLATE);
                }
                bfi = this.createNewBgForm(ctx, bgScheme, (IObjectValue)bgTemplateInfo, orgUnit);
            }
        } else {
            this.detailTemplate(ctx, bfi);
        }
        return bfi;
    }

    private void detailTemplate(Context ctx, BgFormInfo bfi) throws BOSException, EASBizException {
        IBgRptTemplateDA iBgRptTpDa = BgRptTemplateDAFactory.getLocalInstance(ctx);
        BgRptTemplateInfo bgRptTpInfo = iBgRptTpDa.getBgRptTpByBgTp(bfi.getBgTemplate().getId().toString());
        bfi.setBgRptTemplate(bgRptTpInfo);
        bfi.setBgTemplate(bgRptTpInfo.getBgTemplate());
    }

    private IObjectValue getFormWithTemplate(Context ctx, IObjectValue bgType, IObjectValue orgUnit, IObjectValue bgScheme, IObjectValue bgTemplate, boolean autoCreated) throws BOSException, EASBizException {
        BgFormInfo bfi = null;
        IBgFormDA iBgFormDa = BgFormDAFactory.getLocalInstance(ctx);
        bfi = iBgFormDa.matchSingleForm(bgType.getBOSUuid("id").toString(), orgUnit.getBOSUuid("id").toString(), bgScheme.getBOSUuid("id").toString());
        if (bfi == null) {
            if (autoCreated) {
                bfi = this.createNewBgForm(ctx, bgScheme, bgTemplate, orgUnit);
            }
        } else {
            this.detailTemplate(ctx, bfi);
        }
        return bfi;
    }

    private BgFormInfo createNewBgForm(Context ctx, IObjectValue bgScheme, IObjectValue bgTemplate, IObjectValue orgUnit) throws BOSException, EASBizException {
        IBgScheme iBgScheme = BgSchemeFactory.getLocalInstance(ctx);
        BgSchemeInfo bgSchemeInfo = iBgScheme.getBgSchemeInfo((IObjectPK)new ObjectUuidPK(bgScheme.getBOSUuid("id")), BgSchemeHelper.getPeriodSelectors());
        IBgTemplateDA iBgTpDa = BgTemplateDAFactory.getLocalInstance(ctx);
        IBgRptTemplateDA iBgRptTpDa = BgRptTemplateDAFactory.getLocalInstance(ctx);
        BgRptTemplateInfo bgRptTpInfo = iBgRptTpDa.getBgRptTpByBgTp(bgTemplate.getBOSUuid("id").toString());
        IBgManager iBgManager = BgManagerFactory.getLocalInstance(ctx);
        BgFormInfo bfi = iBgManager.generateBgRptForm(bgRptTpInfo, bgSchemeInfo, (FullOrgUnitInfo)orgUnit);
        return bfi;
    }

    @Override
    protected IObjectValue _getBgForm4Edit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IBgFormDA iBgFormDa = BgFormDAFactory.getLocalInstance(ctx);
        BgFormInfo bfi = iBgFormDa.getSingleForm(pk);
        this.detailTemplate(ctx, bfi);
        return bfi;
    }

    @Override
    protected IObjectValue _getFormWithTemplate(Context ctx, String typeId, String orgId, String schemeId, String templateId, boolean autoCreated) throws BOSException, EASBizException {
        IBgType iBgType = BgTypeFactory.getLocalInstance(ctx);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filters = new FilterInfo();
        ev.setFilter(filters);
        ev.getSelector().addObjectCollection((IObjectCollection)BgHelper.getShortSelectors());
        filters.getFilterItems().add(new FilterItemInfo("id", (Object)typeId));
        BgTypeCollection coll = iBgType.getBgTypeCollection(ev);
        BgTypeInfo bgType = coll.get(0);
        FullOrgUnitInfo orgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
        BgSchemeInfo bgScheme = BgSchemeFactory.getLocalInstance(ctx).getBgSchemeInfo((IObjectPK)new ObjectUuidPK(schemeId), this.getSchemeSelectors());
        BgTemplateInfo bgTemplate = BgTemplateFactory.getLocalInstance(ctx).getBgTemplateInfo((IObjectPK)new ObjectUuidPK(templateId));
        return this.getFormWithTemplate(ctx, (IObjectValue)bgType, (IObjectValue)orgUnit, (IObjectValue)bgScheme, (IObjectValue)bgTemplate, autoCreated);
    }

    public SelectorItemCollection getSchemeSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("periodFrom.id"));
        sic.add(new SelectorItemInfo("periodTo.id"));
        return sic;
    }
}

