/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.INewOrgViewFacade;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.ma.bg.BgExistSameRecordException;
import com.kingdee.eas.ma.bg.BgFormulaInfo;
import com.kingdee.eas.ma.bg.BgModelNodeInfo;
import com.kingdee.eas.ma.bg.BgORMEngine;
import com.kingdee.eas.ma.bg.BgSchemeCollection;
import com.kingdee.eas.ma.bg.BgSchemeException;
import com.kingdee.eas.ma.bg.BgSchemeFactory;
import com.kingdee.eas.ma.bg.BgSchemeInfo;
import com.kingdee.eas.ma.bg.BgTemplateInfo;
import com.kingdee.eas.ma.bg.BgTypeException;
import com.kingdee.eas.ma.bg.CompressedObjectValue;
import com.kingdee.eas.ma.bg.app.AbstractBgSchemeControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

public class BgSchemeControllerBean
extends AbstractBgSchemeControllerBean {
    public static boolean bgOrmDelete = true;

    @Override
    public boolean _checkIsSameOrgAndPeriod(Context ctx, IObjectValue bgSchemeInfo) throws SQLDataException, EASBizException {
        boolean isSame = false;
        if (bgSchemeInfo == null) {
            isSame = true;
        }
        BgSchemeInfo bgSchemeInfoNew = (BgSchemeInfo)bgSchemeInfo;
        String strOrgUnitID = null;
        String strPeriodFromID = null;
        String StrPeriodToID = null;
        String strCompanyID = null;
        if (bgSchemeInfoNew.getCompany() != null && bgSchemeInfoNew.getCompany().getId() != null) {
            strCompanyID = bgSchemeInfoNew.getCompany().getId().toString();
        }
        if (bgSchemeInfoNew.getOrgUnit() != null && bgSchemeInfoNew.getOrgUnit().getId() != null) {
            strOrgUnitID = bgSchemeInfoNew.getOrgUnit().getId().toString();
        }
        if (bgSchemeInfoNew.getPeriodFrom() != null && bgSchemeInfoNew.getPeriodFrom().getId() != null) {
            strPeriodFromID = bgSchemeInfoNew.getPeriodFrom().getId().toString();
        }
        if (bgSchemeInfoNew.getPeriodTo() != null && bgSchemeInfoNew.getPeriodTo().getId() != null) {
            StrPeriodToID = bgSchemeInfoNew.getPeriodTo().getId().toString();
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection connection = null;
        try {
            connection = this.getConnection(ctx);
            StringBuffer strBuffer = new StringBuffer(200);
            strBuffer.append("Select fid from T_Bg_BgScheme where FIsFormal=1 ");
            if (strOrgUnitID != null && strPeriodFromID != null && StrPeriodToID != null) {
                BOSUuid fid;
                strBuffer.append(" and FOrgUnitID = '");
                strBuffer.append(strOrgUnitID);
                strBuffer.append("' ");
                strBuffer.append(" and FPeriodFromID = '");
                strBuffer.append(strPeriodFromID);
                strBuffer.append("'");
                strBuffer.append(" and FPeriodToID = '");
                strBuffer.append(StrPeriodToID);
                strBuffer.append("'");
                if (strCompanyID != null) {
                    strBuffer.append(" and FCompanyID = '");
                    strBuffer.append(bgSchemeInfoNew.getCompany().getId().toString());
                    strBuffer.append("' ");
                }
                if ((fid = bgSchemeInfoNew.getId()) != null) {
                    strBuffer.append(" and FID !='");
                    strBuffer.append(fid.toString());
                    strBuffer.append("'");
                }
                ps = connection.prepareStatement(strBuffer.toString());
                strBuffer = null;
                rs = ps.executeQuery();
                if (rs.next()) {
                    isSame = true;
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e.toString());
        }
        finally {
            SQLUtils.cleanup(rs, ps, (Connection)connection);
        }
        return isSame;
    }

    @Override
    public boolean _isUsedBgScheme(Context ctx, BOSUuid bgSchemeID) throws BOSException, EASBizException {
        boolean isUsed = false;
        if (bgSchemeID == null) {
            return isUsed;
        }
        String strID = bgSchemeID.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection connection = null;
        try {
            connection = this.getConnection(ctx);
            StringBuffer strBuffer = new StringBuffer(100);
            strBuffer.append("Select fid from T_Bg_BgForm where ");
            if (strID != null && strID.length() > 0) {
                strBuffer.append(" FBgSchemeID = '");
                strBuffer.append(strID);
                strBuffer.append("'");
            }
            ps = connection.prepareStatement(strBuffer.toString());
            strBuffer = null;
            rs = ps.executeQuery();
            if (rs.next()) {
                isUsed = true;
            }
        }
        catch (SQLException e) {
            try {
                throw new EASBizException(EASBizException.CHECKBLANK, (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        return isUsed;
    }

    @Override
    protected IObjectCollection _getCollectionByOrgUnit(Context ctx, IObjectValue orgUnitInfo) throws EASBizException, BOSException {
        if (orgUnitInfo == null) {
            return null;
        }
        String companyId = null;
        IFullOrgUnit iFull = FullOrgUnitFactory.getLocalInstance((Context)ctx);
        FullOrgUnitInfo org = iFull.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(((FullOrgUnitInfo)orgUnitInfo).getId()));
        if (!org.isIsCU()) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("CU.id"));
            FullOrgUnitInfo org1 = iFull.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(org.getId()), sic);
            if (org1 == null) {
                throw new BgSchemeException(BgSchemeException.NOTFINDCOMPANY);
            }
            companyId = org1.getCU().getId().toString();
        } else {
            companyId = orgUnitInfo.get("id").toString();
        }
        if (companyId == null) {
            return null;
        }
        BgSchemeCollection bgSchemeCollection = this.getBgSchemeCollectionByCompanyId(ctx, companyId);
        return bgSchemeCollection;
    }

    private OrgUnitInfo getOrgParent(Context ctx, INewOrgViewFacade iNew, String orgId) throws BOSException, EASBizException {
        OrgUnitInfo parent = iNew.getParent(orgId, OrgViewType.CTRLUNIT);
        if (parent == null) {
            return null;
        }
        if (parent != null && parent.isIsCU()) {
            return parent;
        }
        return this.getOrgParent(ctx, iNew, parent.getId().toString());
    }

    private BgSchemeCollection getBgSchemeCollectionByCompanyId(Context ctx, String companyId) throws EASBizException, BOSException {
        BgSchemeCollection bgSchemeCollection = new BgSchemeCollection();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)companyId, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        entityViewInfo.getSelector().add(new SelectorItemInfo("id"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("name"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("number"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("isFormal"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("isSysDefined"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("bgModelNodes"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("orgUnit"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("parentScheme"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("periodFrom.periodYear"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("periodFrom.periodNumber"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("periodFrom.periodQuarter"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("periodTo.periodYear"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("periodTo.periodNumber"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("periodTo.periodQuarter"));
        bgSchemeCollection = this.getBgSchemeCollection(ctx, entityViewInfo);
        if (bgSchemeCollection.size() == 0) {
            INewOrgViewFacade iNew = NewOrgViewFacadeFactory.getLocalInstance((Context)ctx);
            OrgUnitInfo parent = iNew.getParent(companyId, OrgViewType.CTRLUNIT);
            if (parent == null) {
                return new BgSchemeCollection();
            }
            companyId = parent.getId().toString();
            bgSchemeCollection = this.getBgSchemeCollectionByCompanyId(ctx, companyId);
        }
        return bgSchemeCollection;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkData(ctx, model);
        return super._submit(ctx, model);
    }

    private void checkData(Context ctx, IObjectValue model) throws SQLDataException, EASBizException, BgExistSameRecordException, BOSException {
        boolean isFormal = ((BgSchemeInfo)model).isIsFormal();
        if (isFormal) {
            boolean isSame = this._checkIsSameOrgAndPeriod(ctx, model);
            if (isSame) {
                throw new BgExistSameRecordException(BgExistSameRecordException.EXISTSAMEORGPERIOD);
            }
            boolean isExist = this._checkPeriodIsCross(ctx, model);
            if (isExist) {
                throw new BgExistSameRecordException(BgExistSameRecordException.SCHEMEPERIODEXISTCROSS);
            }
        }
        if (model.getBOSUuid("id") == null) {
            this.checkNumberDup(ctx, null, (CoreBillBaseInfo)((BgSchemeInfo)model));
        } else {
            this.checkDupNumber(ctx, model.getBOSUuid("id").toString(), (BgSchemeInfo)model);
        }
    }

    private void checkDupNumber(Context ctx, String id, BgSchemeInfo info) throws BOSException, EASBizException {
        String number = info.getNumber();
        ResultSet rs = null;
        Connection connection = null;
        PreparedStatement sm = null;
        StringBuffer sql = new StringBuffer(60);
        sql.append(" select fid from t_bg_bgscheme where fnumber=? ");
        if (!id.equals("")) {
            sql.append(" and fid!=?");
        }
        try {
            connection = this.getConnection(ctx);
            sm = connection.prepareStatement(sql.toString());
            sm.setString(1, number);
            if (!id.equals("")) {
                sm.setString(2, id);
            }
            if ((rs = sm.executeQuery()).next()) {
                throw new BgTypeException(BgTypeException.NUMBERDUP);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, sm, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)connection);
    }

    @Override
    protected boolean _checkPeriodIsCross(Context ctx, IObjectValue bgSchemeInfo) throws BOSException, EASBizException {
        boolean isExist = false;
        if (bgSchemeInfo == null) {
            return false;
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection connection = null;
        try {
            connection = this.getConnection(ctx);
            BgSchemeInfo bgScheme = (BgSchemeInfo)bgSchemeInfo;
            int startYear = -1;
            int startNumber = -1;
            String strTypeId = null;
            if (bgScheme.getPeriodFrom() != null) {
                startYear = bgScheme.getPeriodFrom().getPeriodYear();
                startNumber = bgScheme.getPeriodFrom().getPeriodNumber();
                if (bgScheme.getPeriodFrom().getPeriodType() == null) {
                    IPeriod iperiod = PeriodFactory.getLocalInstance((Context)ctx);
                    PeriodInfo perinfo = (PeriodInfo)iperiod.getValue((IObjectPK)new ObjectUuidPK(bgScheme.getPeriodFrom().getId()));
                    bgScheme.setPeriodFrom(perinfo);
                }
                strTypeId = bgScheme.getPeriodFrom().getPeriodType().getId().toString();
                startYear = startYear * 100 + startNumber;
            }
            int endYear = -1;
            if (bgScheme.getPeriodTo() != null) {
                int startYearTo = bgScheme.getPeriodTo().getPeriodYear();
                int startNumberTo = bgScheme.getPeriodTo().getPeriodNumber();
                endYear = startYearTo * 100 + startNumberTo;
            }
            if (startYear == -1 || endYear == -1) {
                boolean startYearTo = false;
                return startYearTo;
            }
            StringBuffer strBuffer = new StringBuffer(500);
            strBuffer.append("SELECT b.fperiodyear fromYear,b.fperiodnumber fromNumber,c.fperiodyear toYear,c.fperiodnumber toNumber FROM T_BG_BgScheme a INNER JOIN T_BD_Period b ON a.FPeriodFromID = b.FID ");
            strBuffer.append(" INNER JOIN T_BD_Period c ON a.FPeriodToID = c.FID ");
            strBuffer.append(" where b.FTypeId ='");
            strBuffer.append(strTypeId);
            strBuffer.append("'");
            strBuffer.append(" and c.FTypeId ='");
            strBuffer.append(strTypeId);
            strBuffer.append("'");
            strBuffer.append(" and a.FIsFormal =1 ");
            strBuffer.append(" and a.FCompanyId = '");
            strBuffer.append(bgScheme.getCompany().getId().toString());
            strBuffer.append("' ");
            strBuffer.append(" and a.FOrgUnitId = '");
            strBuffer.append(bgScheme.getOrgUnit().getId().toString());
            strBuffer.append("' ");
            BOSUuid fid = bgScheme.getId();
            if (fid != null) {
                strBuffer.append(" and a.FID !='");
                strBuffer.append(fid.toString());
                strBuffer.append("'");
            }
            ps = connection.prepareStatement(strBuffer.toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                int toNumber;
                int fromYear = rs.getInt(1);
                int fromNumber = rs.getInt(2);
                int toYear = rs.getInt(3);
                if (toYear * 100 + (toNumber = rs.getInt(4)) < startYear || fromYear * 100 + fromNumber > endYear) continue;
                isExist = true;
                break;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        }
        catch (SQLException e) {
            throw new EASBizException(EASBizException.CHECKBLANK, (Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rs, ps, (Connection)connection);
        }
        return isExist;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkData(ctx, model);
        return super._save(ctx, model);
    }

    @Override
    protected boolean _checkIsEsixstLowerScheme(Context ctx, BOSUuid schemeId) throws BOSException {
        boolean isExist = false;
        ResultSet rs = null;
        Connection connection = null;
        PreparedStatement sm = null;
        if (schemeId == null) {
            return isExist;
        }
        try {
            int n;
            connection = this.getConnection(ctx);
            StringBuffer strBuffer = new StringBuffer(100);
            strBuffer.append("SELECT count(fid) cnt from t_bg_bgScheme where fbgSchemeId = ?");
            sm = connection.prepareStatement(strBuffer.toString());
            sm.setString(1, schemeId.toString());
            rs = sm.executeQuery();
            if (rs.next() && (n = rs.getInt(1)) > 0) {
                isExist = true;
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, sm, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)connection);
        return isExist;
    }

    @Override
    protected boolean _checkIsAssignByOrgUnit(Context ctx, BOSUuid schemeId, BOSUuid orgUnitId) throws BOSException {
        boolean isExist = false;
        ResultSet rs = null;
        Connection connection = null;
        PreparedStatement sm = null;
        if (schemeId == null || orgUnitId == null) {
            return isExist;
        }
        try {
            int n;
            connection = this.getConnection(ctx);
            StringBuffer strBuffer = new StringBuffer(200);
            strBuffer.append("SELECT count(fid) cnt from t_bg_bgScheme where fbgSchemeId =? ");
            strBuffer.append(" and ForgUnitId =?");
            sm = connection.prepareStatement(strBuffer.toString());
            sm.setString(1, schemeId.toString());
            sm.setString(2, orgUnitId.toString());
            rs = sm.executeQuery();
            if (rs.next() && (n = rs.getInt(1)) > 0) {
                isExist = true;
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, sm, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)connection);
        return isExist;
    }

    public IObjectPK _addnew(Context ctx, IObjectValue cmodel) throws BOSException, EASBizException {
        BgSchemeInfo info = null;
        if (cmodel instanceof CompressedObjectValue) {
            try {
                info = (BgSchemeInfo)((CompressedObjectValue)cmodel).getUncompressedObject();
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        } else {
            info = (BgSchemeInfo)cmodel;
        }
        if (bgOrmDelete) {
            UserInfo userInfo = new UserInfo();
            userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
            BgSchemeInfo objectBaseInfo = null;
            objectBaseInfo = info;
            Object pk = null;
            objectBaseInfo.setCreator(userInfo);
            Date date = new Date();
            long time = date.getTime();
            objectBaseInfo.setCreateTime(new Timestamp(time));
            objectBaseInfo.setLastUpdateUser(userInfo);
            objectBaseInfo.setLastUpdateTime(new Timestamp(time));
            ArrayList<BgFormulaInfo> dataColl = new ArrayList<BgFormulaInfo>();
            ArrayList<BgModelNodeInfo> entryColl = new ArrayList<BgModelNodeInfo>();
            Iterator iter = info.getBgModelNodes().iterator();
            while (iter.hasNext()) {
                BgModelNodeInfo bgEntry = (BgModelNodeInfo)iter.next();
                Iterator dataIter = bgEntry.getBgFormulas().iterator();
                while (dataIter.hasNext()) {
                    BgFormulaInfo bgData = (BgFormulaInfo)dataIter.next();
                    bgData.setBgModelNode(bgEntry);
                    dataColl.add(bgData);
                }
                bgEntry.setBgScheme(info);
                entryColl.add(bgEntry);
            }
            BgFormulaInfo[] bgDataAry = new BgFormulaInfo[]{};
            BgModelNodeInfo[] bgEntryAry = new BgModelNodeInfo[]{};
            BgORMEngine.addnewVO(ctx, (IObjectValue[])new BgSchemeInfo[]{info});
            BgORMEngine.addnewVO(ctx, (IObjectValue[])entryColl.toArray(bgEntryAry));
            BgORMEngine.addnewVO(ctx, (IObjectValue[])dataColl.toArray(bgDataAry));
            return new ObjectUuidPK(info.getId());
        }
        return super._addnew(ctx, (IObjectValue)info);
    }

    @Override
    protected IObjectValue _getBgSchemePeriodDesc(Context ctx, BOSUuid bgSchemeId) throws BOSException, EASBizException {
        ResultSet rs = null;
        Connection connection = null;
        PreparedStatement sm = null;
        BgSchemeInfo bgSchemeInfo = null;
        if (bgSchemeId == null) {
            return bgSchemeInfo;
        }
        try {
            connection = this.getConnection(ctx);
            String strSchemeId = bgSchemeId.toString();
            StringBuffer strBuffer = new StringBuffer(1000);
            strBuffer.append("SELECT sc.Fid as schemeid, sc.fCompanyId as companyId, fp.fid as periodFromid, fp.FPeriodYear as periodFromYear, fp.FperiodQuarter as periodFromQuarter, fp.FperiodNumber as periodFromNumber, fp.FtypeId as periodFromTypeId, tp.fid as periodToId, tp.FPeriodYear as periodToYear, tp.FperiodQuarter as periodToQuarter, tp.FperiodNumber as periodToNumber, tp.FtypeId as periodToTypeId  from T_BG_BgScheme sc, T_BD_Period fp, T_BD_Period tp  where fp.fid =sc.fPeriodFromId and tp.fid=sc.FPeriodToId  and sc.fid = ?");
            sm = connection.prepareStatement(strBuffer.toString());
            sm.setString(1, strSchemeId);
            rs = sm.executeQuery();
            strBuffer = null;
            if (rs.next()) {
                String strToId;
                String strPeriodFromId;
                bgSchemeInfo = new BgSchemeInfo();
                bgSchemeInfo.setId(BOSUuid.read((String)rs.getString("schemeid")));
                String companyId = rs.getString("companyId");
                if (companyId != null) {
                    CompanyOrgUnitInfo companyOrgUnitInfo = new CompanyOrgUnitInfo();
                    companyOrgUnitInfo.setId(BOSUuid.read((String)companyId));
                    bgSchemeInfo.setCompany(companyOrgUnitInfo);
                }
                if ((strPeriodFromId = rs.getString("periodFromid")) != null) {
                    PeriodInfo periodInfoFrom = new PeriodInfo();
                    periodInfoFrom.setId(BOSUuid.read((String)strPeriodFromId));
                    periodInfoFrom.setPeriodYear(rs.getInt("periodFromYear"));
                    periodInfoFrom.setPeriodQuarter(rs.getInt("periodFromQuarter"));
                    periodInfoFrom.setPeriodNumber(rs.getInt("periodFromNumber"));
                    String strTypeId = rs.getString("periodFromTypeId");
                    if (strTypeId != null) {
                        PeriodTypeInfo periodTypeInfoForm = new PeriodTypeInfo();
                        periodTypeInfoForm.setId(BOSUuid.read((String)strTypeId));
                        periodInfoFrom.setPeriodType(periodTypeInfoForm);
                    }
                    bgSchemeInfo.setPeriodFrom(periodInfoFrom);
                }
                if ((strToId = rs.getString("periodToId")) != null) {
                    PeriodInfo periodInfoTo = new PeriodInfo();
                    periodInfoTo.setId(BOSUuid.read((String)strToId));
                    periodInfoTo.setPeriodYear(rs.getInt("periodToYear"));
                    periodInfoTo.setPeriodQuarter(rs.getInt("periodToQuarter"));
                    periodInfoTo.setPeriodNumber(rs.getInt("periodToNumber"));
                    String strTypeId = rs.getString("periodToTypeId");
                    if (strTypeId != null) {
                        PeriodTypeInfo periodTypeInfoTo = new PeriodTypeInfo();
                        periodTypeInfoTo.setId(BOSUuid.read((String)strTypeId));
                        periodInfoTo.setPeriodType(periodTypeInfoTo);
                    }
                    bgSchemeInfo.setPeriodTo(periodInfoTo);
                }
            }
            strBuffer = new StringBuffer(200);
            strBuffer.append("select FID, FBgTemplateID from t_bg_bgModelNode where fbgSchemeid =?");
            rs.close();
            sm = connection.prepareStatement(strBuffer.toString());
            sm.setString(1, strSchemeId);
            rs = sm.executeQuery();
            while (rs.next()) {
                String strTempId;
                BgModelNodeInfo bgModelNodeInfo = new BgModelNodeInfo();
                String strId = rs.getString("FID");
                if (strId != null) {
                    bgModelNodeInfo.setId(BOSUuid.read((String)strId));
                }
                if ((strTempId = rs.getString("FBgTemplateID")) != null) {
                    BgTemplateInfo bgTemplateInfo = new BgTemplateInfo();
                    bgTemplateInfo.setId(BOSUuid.read((String)strTempId));
                    bgModelNodeInfo.setBgTemplate(bgTemplateInfo);
                }
                bgModelNodeInfo.setBgScheme(bgSchemeInfo);
                if (bgSchemeInfo == null) continue;
                bgSchemeInfo.getBgModelNodes().add(bgModelNodeInfo);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, sm, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)connection);
        return bgSchemeInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IObjectCollection _getCollectionBeUsedByBgForm(Context ctx, IObjectValue orgUnitInfo) throws BOSException, EASBizException {
        ResultSet rs = null;
        Connection connection = null;
        PreparedStatement sm = null;
        if (orgUnitInfo == null || ((FullOrgUnitInfo)orgUnitInfo).getId() == null) {
            return null;
        }
        String strOrgUnitId = ((FullOrgUnitInfo)orgUnitInfo).getId().toString();
        BgSchemeCollection bgSchemeColl = new BgSchemeCollection();
        StringBuffer sbSQL = new StringBuffer("select distinct fbgschemeid from t_bg_bgform ");
        sbSQL.append("where FOrgUnitID='");
        sbSQL.append(((FullOrgUnitInfo)orgUnitInfo).getId().toString());
        sbSQL.append("'");
        try {
            connection = this.getConnection(ctx);
            sm = connection.prepareStatement(sbSQL.toString());
            rs = sm.executeQuery();
            while (rs.next()) {
                String strSchemeId = rs.getString("fbgschemeid");
                BgSchemeInfo bgSchemeInfo = BgSchemeFactory.getLocalInstance(ctx).getBgSchemeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)strSchemeId)), this.getSelectors());
                if (bgSchemeInfo == null || bgSchemeInfo.getOrgUnit() == null || bgSchemeInfo.getOrgUnit().getId().toString().equals(strOrgUnitId)) continue;
                bgSchemeInfo.setName(bgSchemeInfo.getName() + "(\u4e0a\u7ea7)");
                bgSchemeColl.add(bgSchemeInfo);
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, sm, (Connection)connection);
                throw throwable;
            }
            SQLUtils.cleanup(rs, (Statement)sm, (Connection)connection);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)connection);
        return bgSchemeColl;
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("periodTo.periodYear"));
        sic.add(new SelectorItemInfo("periodFrom.periodYear"));
        sic.add(new SelectorItemInfo("isFormal"));
        sic.add(new SelectorItemInfo("bgModelNodes.bgTemplate.createTime"));
        sic.add(new SelectorItemInfo("bgModelNodes.bgTemplate.bgType.name"));
        sic.add(new SelectorItemInfo("bgModelNodes.bgTemplate.number"));
        sic.add(new SelectorItemInfo("bgModelNodes.bgTemplate.creator.name"));
        sic.add(new SelectorItemInfo("bgModelNodes.bgTemplate.name"));
        sic.add(new SelectorItemInfo("bgModelNodes.bgTemplate.id"));
        sic.add(new SelectorItemInfo("bgModelNodes.*"));
        sic.add(new SelectorItemInfo("periodTo.periodNumber"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("orgUnit.*"));
        sic.add(new SelectorItemInfo("periodFrom.periodNumber"));
        sic.add(new SelectorItemInfo("parentScheme.name"));
        return sic;
    }
}

