/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgDataTypeEnum;
import com.kingdee.eas.ma.bg.BgDimensionEnum;
import com.kingdee.eas.ma.bg.BgElementInfo;
import com.kingdee.eas.ma.bg.BgHelper;
import com.kingdee.eas.ma.bg.BgOrgTypeInfo;
import com.kingdee.eas.ma.bg.BgTypeCollection;
import com.kingdee.eas.ma.bg.BgTypeException;
import com.kingdee.eas.ma.bg.BgTypeFactory;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.IBgType;
import com.kingdee.eas.ma.bg.ValidBgDimensionInfo;
import com.kingdee.eas.ma.bg.app.AbstractBgTypeControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgTypeControllerBean
extends AbstractBgTypeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.bg.app.BgTypeControllerBean");

    @Override
    protected IObjectValue _getValueByNumber(Context ctx, String strNumber) throws BOSException {
        IBgType iBgType = BgTypeFactory.getLocalInstance(ctx);
        BgTypeInfo bgTypeInfo = null;
        try {
            bgTypeInfo = iBgType.getBgTypeInfo("select * where number='" + strNumber + "'");
        }
        catch (EASBizException e) {
            logger.debug((Object)("BgError:" + (Object)((Object)e)));
            e.printStackTrace();
        }
        catch (BOSException e) {
            logger.debug((Object)("BgError:" + (Object)((Object)e)));
            e.printStackTrace();
        }
        return bgTypeInfo;
    }

    @Override
    protected IObjectCollection _getCollection(Context ctx, int orgType) throws BOSException, EASBizException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filters = new FilterInfo();
        ev.setFilter(filters);
        ev.getSelector().addObjectCollection((IObjectCollection)BgHelper.getShortSelectors());
        filters.getFilterItems().add(new FilterItemInfo("isEffective", (Object)new Integer(1)));
        BgTypeCollection coll = this.getBgTypeCollection(ctx, ev);
        BgTypeCollection result = new BgTypeCollection();
        Iterator iter = coll.iterator();
        block0: while (iter.hasNext()) {
            BgTypeInfo element = (BgTypeInfo)iter.next();
            Iterator iter1 = element.getBgOrgType().iterator();
            while (iter1.hasNext()) {
                BgOrgTypeInfo element1 = (BgOrgTypeInfo)iter1.next();
                if (element1.getOrgType().getValue() != orgType) continue;
                result.add(element);
                continue block0;
            }
        }
        return result;
    }

    @Override
    protected IObjectCollection _getCollection(Context ctx, Vector vec) throws BOSException, EASBizException {
        HashMap map = new HashMap();
        BgTypeCollection result = new BgTypeCollection();
        for (int i = 0; i < vec.size(); ++i) {
            int orgType = ((OrgType)vec.get(i)).getValue();
            BgTypeCollection coll = (BgTypeCollection)this._getCollection(ctx, orgType);
            for (int j = 0; j < coll.size(); ++j) {
                result.add(coll.get(j));
            }
        }
        return result;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        BgTypeInfo bti = (BgTypeInfo)super._getValue(ctx, pk, selector);
        if ("ProjectBudget".equals(bti.getNumber())) {
            ValidBgDimensionInfo prjDim = new ValidBgDimensionInfo();
            prjDim.setBgDimension(BgDimensionEnum.PROJECT);
            prjDim.setBgType(bti);
            ValidBgDimensionInfo acctDim = new ValidBgDimensionInfo();
            acctDim.setBgDimension(BgDimensionEnum.ACCOUNT);
            acctDim.setBgType(bti);
            bti.getValidBgDimensions().clear();
            bti.getValidBgDimensions().add(prjDim);
            bti.getValidBgDimensions().add(acctDim);
        }
        return bti;
    }

    @Override
    protected IObjectValue _getBgTypeBySql(Context ctx, BOSUuid bgTypeId) throws BOSException {
        BgTypeInfo bgTypeInfo;
        PreparedStatement sm;
        Connection connection;
        ResultSet rs;
        block18: {
            rs = null;
            connection = null;
            sm = null;
            bgTypeInfo = null;
            if (bgTypeId == null) {
                return bgTypeInfo;
            }
            try {
                connection = this.getConnection(ctx);
                Locale loc = ctx.getLocale();
                String strTypeId = bgTypeId.toString();
                StringBuffer strBuffer = new StringBuffer(300);
                String strName = "FName_" + loc.getLanguage();
                strBuffer.append("SELECT FID, FNumber, ");
                strBuffer.append(strName);
                strBuffer.append(" As fname, FIsEffective, FIsSysDefined, FControllable,FIsRptBgForm FROM T_BG_BgType WHERE FID = ?");
                sm = connection.prepareStatement(strBuffer.toString());
                sm.setString(1, strTypeId);
                rs = sm.executeQuery();
                strBuffer = null;
                if (rs.next()) {
                    int count;
                    int isEfc;
                    bgTypeInfo = new BgTypeInfo();
                    bgTypeInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                    bgTypeInfo.setNumber(rs.getString("FNumber"));
                    bgTypeInfo.setName(rs.getString("fname"));
                    int isSys = rs.getInt("FIsSysDefined");
                    if (isSys == 1) {
                        bgTypeInfo.setIsSysDefined(true);
                    }
                    if ((isEfc = rs.getInt("FIsEffective")) == 1) {
                        bgTypeInfo.setIsEffective(true);
                    }
                    if ((count = rs.getInt("FControllable")) == 1) {
                        bgTypeInfo.setControllable(true);
                    }
                    if ((count = rs.getInt("FIsRptBgForm")) == 1) {
                        bgTypeInfo.setIsRptBgForm(true);
                    }
                }
                strBuffer = new StringBuffer(200);
                strBuffer.append("SELECT FID, FNumber, ");
                strBuffer.append(strName);
                strBuffer.append(" As FName, FDataType, FApportionable, FControllable, FSummable, FEnabled, FFormula  FROM T_BG_BgElement WHERE FBgTypeID = ?");
                rs.close();
                sm = connection.prepareStatement(strBuffer.toString());
                sm.setString(1, strTypeId);
                rs = sm.executeQuery();
                while (rs.next()) {
                    int sum;
                    int controllable;
                    int enab;
                    String elemId = rs.getString("FID");
                    if (elemId == null) continue;
                    BgElementInfo bgElementInfo = new BgElementInfo();
                    bgElementInfo.setId(BOSUuid.read((String)elemId));
                    bgElementInfo.setNumber(rs.getString("FNumber"));
                    bgElementInfo.setName(rs.getString("FName"));
                    int dataType = rs.getInt("FDataType");
                    bgElementInfo.setDataType(BgDataTypeEnum.getEnum(dataType));
                    int app = rs.getInt("FApportionable");
                    if (app == 1) {
                        bgElementInfo.setApportionable(true);
                    }
                    if ((enab = rs.getInt("FEnabled")) == 1) {
                        bgElementInfo.setEnabled(true);
                    }
                    if ((controllable = rs.getInt("FControllable")) == 1) {
                        bgElementInfo.setControllable(true);
                    }
                    if ((sum = rs.getInt("FSummable")) == 1) {
                        bgElementInfo.setSummable(true);
                    }
                    bgElementInfo.setFormula(rs.getString("FFormula"));
                    bgElementInfo.setBgType(bgTypeInfo);
                    if (bgTypeInfo == null) continue;
                    bgTypeInfo.getElements().add(bgElementInfo);
                }
                if (bgTypeInfo != null && "ProjectBudget".equals(bgTypeInfo.getNumber())) {
                    ValidBgDimensionInfo prjDim = new ValidBgDimensionInfo();
                    prjDim.setBgDimension(BgDimensionEnum.PROJECT);
                    prjDim.setBgType(bgTypeInfo);
                    ValidBgDimensionInfo acctDim = new ValidBgDimensionInfo();
                    acctDim.setBgDimension(BgDimensionEnum.ACCOUNT);
                    acctDim.setBgType(bgTypeInfo);
                    bgTypeInfo.getValidBgDimensions().clear();
                    bgTypeInfo.getValidBgDimensions().add(prjDim);
                    bgTypeInfo.getValidBgDimensions().add(acctDim);
                    break block18;
                }
                strBuffer = new StringBuffer(200);
                strBuffer.append("SELECT FID, FBgDimension, FBgItemFecthPath FROM T_BG_ValidBgDimension WHERE FBgTypeID = ?");
                rs.close();
                sm = connection.prepareStatement(strBuffer.toString());
                sm.setString(1, strTypeId);
                rs = sm.executeQuery();
                while (rs.next()) {
                    String strValidId = rs.getString("FID");
                    if (strValidId == null) continue;
                    ValidBgDimensionInfo validBgDimensionInfo = new ValidBgDimensionInfo();
                    validBgDimensionInfo.setId(BOSUuid.read((String)strValidId));
                    String strDim = rs.getString("FBgDimension");
                    if (strDim != null) {
                        int dimValue = new Integer(strDim);
                        validBgDimensionInfo.setBgDimension(BgDimensionEnum.getEnum(dimValue));
                    }
                    validBgDimensionInfo.setBgType(bgTypeInfo);
                    if (bgTypeInfo == null) continue;
                    bgTypeInfo.getValidBgDimensions().add(validBgDimensionInfo);
                }
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, sm, (Connection)connection);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)connection);
        return bgTypeInfo;
    }

    @Override
    protected boolean _isRefByTem(Context ctx, String bgTypeId) throws BOSException {
        boolean result = false;
        ResultSet rs = null;
        Connection connection = null;
        PreparedStatement sm = null;
        String sql = "select count(fbgtypeid) from t_bg_bgtemplate where fbgtypeid=?";
        try {
            int count;
            connection = this.getConnection(ctx);
            sm = connection.prepareStatement(sql);
            sm.setString(1, bgTypeId);
            rs = sm.executeQuery();
            if (rs.next() && (count = rs.getInt(1)) > 0) {
                result = true;
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, sm, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)connection);
        return result;
    }

    @Override
    protected Vector _getOrgType(Context ctx, String bgTypeId) throws BOSException, EASBizException {
        Vector<OrgType> vec = new Vector<OrgType>(3);
        ResultSet rs = null;
        Connection connection = null;
        PreparedStatement sm = null;
        String sql = "select forgtype from t_bg_bgorgtype where fbgtypeid=?";
        try {
            connection = this.getConnection(ctx);
            sm = connection.prepareStatement(sql);
            sm.setString(1, bgTypeId);
            rs = sm.executeQuery();
            while (rs.next()) {
                int orgTypeNo = rs.getInt(1);
                OrgType orgType = OrgType.getEnum((int)orgTypeNo);
                vec.add(orgType);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, sm, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)connection);
        return vec;
    }

    @Override
    protected boolean _checkDupName(Context ctx, String name, String id) throws BOSException, EASBizException {
        PreparedStatement sm;
        Connection connection;
        ResultSet rs;
        block6: {
            boolean bl;
            rs = null;
            connection = null;
            sm = null;
            StringBuffer sql = new StringBuffer(60);
            String language = ctx.getLocale().getLanguage();
            sql.append(" select fid from t_bg_bgtype where fname_" + language + "=? ");
            if (!id.equals("")) {
                sql.append(" and fid!=?");
            }
            try {
                connection = this.getConnection(ctx);
                sm = connection.prepareStatement(sql.toString());
                sm.setString(1, name);
                if (!id.equals("")) {
                    sm.setString(2, id);
                }
                if (!(rs = sm.executeQuery()).next()) break block6;
                bl = true;
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, sm, (Connection)connection);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)connection);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)connection);
        return false;
    }

    @Override
    protected boolean _checkDupNumber(Context ctx, String number, String id) throws BOSException, EASBizException {
        PreparedStatement sm;
        Connection connection;
        ResultSet rs;
        block6: {
            boolean bl;
            rs = null;
            connection = null;
            sm = null;
            StringBuffer sql = new StringBuffer(60);
            sql.append(" select fid from t_bg_bgtype where fnumber=? ");
            if (!id.equals("")) {
                sql.append(" and fid!=?");
            }
            try {
                connection = this.getConnection(ctx);
                sm = connection.prepareStatement(sql.toString());
                sm.setString(1, number);
                if (!id.equals("")) {
                    sm.setString(2, id);
                }
                if (!(rs = sm.executeQuery()).next()) break block6;
                bl = true;
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, sm, (Connection)connection);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)connection);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)connection);
        return false;
    }

    protected IObjectPK _submit(Context arg0, IObjectValue arg1) throws BOSException, EASBizException {
        BgTypeInfo info = (BgTypeInfo)arg1;
        String id = info.getId() == null ? "" : info.getId().toString();
        boolean dupName = this._checkDupName(arg0, info.getName(), id);
        boolean dupNumber = this._checkDupNumber(arg0, info.getNumber(), id);
        if (dupName) {
            throw new BgTypeException(BgTypeException.NAMEDUP);
        }
        if (dupNumber) {
            throw new BgTypeException(BgTypeException.NUMBERDUP);
        }
        return super._submit(arg0, arg1);
    }

    @Override
    protected void _enable(Context ctx, String id) throws EASBizException, BOSException {
        Connection conn = this.getConnection(ctx);
        PreparedStatement stmt = null;
        String sql = "update T_BG_BgType set FIsEffective = 1 WHERE FID = ?";
        try {
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, id);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        }
    }

    @Override
    protected void _disEnable(Context ctx, String id) throws EASBizException, BOSException {
        Connection conn = this.getConnection(ctx);
        PreparedStatement stmt = null;
        String sql = "update T_BG_BgType set FIsEffective = 0 WHERE FID = ?";
        try {
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, id);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        }
    }
}

