/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.facade.FaActualDataProviderImplFactory;
import com.kingdee.eas.fi.fa.facade.IFaActualDataProviderImpl;
import com.kingdee.eas.fi.rpt.BizAcctActualDataProviderFactory;
import com.kingdee.eas.fi.rpt.IBizAcctActualDataProvider;
import com.kingdee.eas.ma.bg.BgBizException;
import com.kingdee.eas.ma.bg.BgCtrlData;
import com.kingdee.eas.ma.bg.BgCtrlParam;
import com.kingdee.eas.ma.bg.BgCycleTypeEnum;
import com.kingdee.eas.ma.bg.BgDataCollection;
import com.kingdee.eas.ma.bg.BgDataInfo;
import com.kingdee.eas.ma.bg.BgDimensionEnum;
import com.kingdee.eas.ma.bg.BgElementEnum;
import com.kingdee.eas.ma.bg.BgEntityAccess;
import com.kingdee.eas.ma.bg.BgFormCollection;
import com.kingdee.eas.ma.bg.BgFormFactory;
import com.kingdee.eas.ma.bg.BgFormInfo;
import com.kingdee.eas.ma.bg.BgORMEngine;
import com.kingdee.eas.ma.bg.BgTemplateInfo;
import com.kingdee.eas.ma.bg.IBgForm;
import com.kingdee.eas.ma.bg.app.AbstractBizActualExecutorControllerBean;
import com.kingdee.eas.ma.bg.app.dao.BgCtrlDAO;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class BizActualExecutorControllerBean
extends AbstractBizActualExecutorControllerBean {
    private PeriodCollection getPeriodsList(Context ctx, BOSUuid bgFormId) throws BOSException, EASBizException {
        String sql = "SELECT DISTINCT E.FPeriodID, P.FPeriodYear, P.FPeriodQuarter, P.FPeriodNumber FROM T_BG_BgEntry E INNER JOIN T_BD_Period P ON E.FPeriodID = P.FID WHERE (E.FBgFormID = ?)";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        PeriodCollection list = new PeriodCollection();
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            int length = bgFormId.toString().length();
            if (length != 28 && length != 44) {
                throw new SQLException("\u4e1a\u52a1\u5bf9\u8c61ID\u957f\u5ea6\u8bbe\u7f6e\u5f02\u5e38\uff01");
            }
            stmt.setAsciiStream(1, (InputStream)new ByteArrayInputStream(bgFormId.toString().getBytes()), length);
            rs = stmt.executeQuery();
            while (rs.next()) {
                PeriodInfo info = new PeriodInfo();
                info.setId(BOSUuid.read((String)rs.getString(1)));
                info.setPeriodYear(rs.getInt("FPeriodYear"));
                info.setPeriodQuarter(rs.getInt("FPeriodQuarter"));
                info.setPeriodNumber(rs.getInt("FPeriodNumber"));
                list.add(info);
            }
        }
        catch (SQLException exp) {
            try {
                throw new BgBizException(BgBizException.GETDATA, exp, new Object[0]);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return list;
    }

    @Override
    protected void _execute(Context ctx, java.util.Date pardate) throws BOSException, EASBizException {
        BgFormInfo vo;
        int i;
        Date date = new Date(pardate.getTime());
        BgCtrlDAO dao = BgCtrlDAO.getInstance(ctx);
        BgFormCollection coll = dao.getBgForm(ctx, date);
        HashMap cache = new HashMap();
        for (i = 0; i < coll.size(); ++i) {
            vo = coll.get(i);
            System.out.println("A:" + i + vo.getId());
        }
        for (i = 0; i < coll.size(); ++i) {
            vo = coll.get(i);
            System.out.println(vo.getId());
            if (!vo.getBgType().getId().toString().equals("c292cd11-00fb-1000-e000-0013c0a8129f530DC15D")) continue;
            this.execute(ctx, vo, cache);
        }
    }

    public void execute(Context ctx, BgFormInfo vo, Map cache) throws EASBizException, BOSException {
        block12: {
            String typeId;
            BgCycleTypeEnum cycle;
            block11: {
                Hashtable table;
                Hashtable table2;
                BgTemplateInfo bgTemplate = (BgTemplateInfo)cache.get(vo.getBgTemplate().getId().toString());
                if (bgTemplate == null) {
                    bgTemplate = (BgTemplateInfo)BgORMEngine.getVO(ctx, vo.getBgTemplate().getId(), new String[]{"bgCycle"});
                }
                cycle = bgTemplate.getBgCycle();
                typeId = vo.getBgType().getId().toString();
                if (!typeId.equals("c292cd11-00fb-1000-e000-0013c0a8129f530DC15D") && !typeId.equals("c292cd11-00fb-1000-e000-0036c0a8129f530DC15D") && !typeId.equals("c292cd11-00fb-1000-e000-0001c0a8129f530DC15D")) break block11;
                PeriodCollection periodColl = this.getPeriodsList(ctx, vo.getId());
                IFullOrgUnit org = FullOrgUnitFactory.getLocalInstance((Context)ctx);
                FullOrgUnitInfo comOrgUnitInfo = null;
                if (ctx.get((Object)"BG_ACCT_COMPANY") == null) {
                    table2 = new Hashtable();
                    comOrgUnitInfo = org.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(vo.getCompany().getId()));
                    table2.put(vo.getCompany().getId().toString(), comOrgUnitInfo);
                    ctx.put((Object)"BG_ACCT_COMPANY", (Object)table2);
                } else {
                    table2 = (Hashtable)ctx.get((Object)"BG_ACCT_COMPANY");
                    if (table2.get(vo.getCompany().getId().toString()) == null) {
                        comOrgUnitInfo = org.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(vo.getCompany().getId()));
                        table2.put(vo.getCompany().getId().toString(), comOrgUnitInfo);
                    } else {
                        comOrgUnitInfo = (FullOrgUnitInfo)table2.get(vo.getCompany().getId().toString());
                    }
                }
                String fiOrgUnit = comOrgUnitInfo.getNumber();
                FullOrgUnitInfo bizOrgUnitInfo = null;
                if (ctx.get((Object)"BG_ACCT_BIZORG") == null) {
                    table = new Hashtable();
                    bizOrgUnitInfo = org.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(vo.getOrgUnit().getId()));
                    table.put(vo.getOrgUnit().getId().toString(), bizOrgUnitInfo);
                    ctx.put((Object)"BG_ACCT_BIZORG", (Object)table);
                } else {
                    table = (Hashtable)ctx.get((Object)"BG_ACCT_BIZORG");
                    if (table.get(vo.getOrgUnit().getId().toString()) == null) {
                        bizOrgUnitInfo = org.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(vo.getOrgUnit().getId()));
                        table.put(vo.getOrgUnit().getId().toString(), bizOrgUnitInfo);
                    } else {
                        bizOrgUnitInfo = (FullOrgUnitInfo)table.get(vo.getOrgUnit().getId().toString());
                    }
                }
                String bizOrgUnit = bizOrgUnitInfo.getNumber();
                vo.getCompany().setNumber(fiOrgUnit);
                vo.getOrgUnit().setNumber(bizOrgUnit);
                for (int j = 0; j < periodColl.size(); ++j) {
                    PeriodInfo period = periodColl.get(j);
                    Integer endNumber = this.getEndNumber(period, cycle);
                    this.execute(ctx, vo, period, endNumber, cache);
                }
                break block12;
            }
            if (!typeId.equals("c292cd11-00fb-1000-e000-0096c0a8129f530DC15D")) break block12;
            PeriodCollection periodColl = this.getPeriodsList(ctx, vo.getId());
            IFullOrgUnit org = FullOrgUnitFactory.getLocalInstance((Context)ctx);
            String fiOrgUnit = org.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(vo.getCompany().getId())).getNumber();
            String bizOrgUnit = org.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(vo.getOrgUnit().getId())).getNumber();
            vo.getCompany().setNumber(fiOrgUnit);
            vo.getOrgUnit().setNumber(bizOrgUnit);
            for (int j = 0; j < periodColl.size(); ++j) {
                PeriodInfo period = periodColl.get(j);
                Integer endNumber = this.getEndNumber(period, cycle);
                this.execute(ctx, vo, period, endNumber, cache, typeId);
            }
        }
    }

    private Integer getEndNumber(PeriodInfo period, BgCycleTypeEnum cycle) {
        Integer endNumber = null;
        if (cycle == BgCycleTypeEnum.Period) {
            endNumber = new Integer(period.getPeriodNumber());
        } else if (cycle == BgCycleTypeEnum.Season) {
            if (period.getPeriodQuarter() == 1) {
                endNumber = new Integer(3);
            } else if (period.getPeriodQuarter() == 2) {
                endNumber = new Integer(6);
            } else if (period.getPeriodQuarter() == 3) {
                endNumber = new Integer(9);
            } else if (period.getPeriodQuarter() == 4) {
                endNumber = new Integer(12);
            }
        } else if (cycle == BgCycleTypeEnum.Year) {
            endNumber = new Integer(12);
        }
        return endNumber;
    }

    public void execute(Context ctx, BgFormInfo vo, PeriodInfo period, Integer endNumber, Map cache) throws BOSException, EASBizException {
        BgCtrlParam param = new BgCtrlParam();
        IFullOrgUnit iFull = FullOrgUnitFactory.getLocalInstance((Context)ctx);
        FullOrgUnitInfo org = iFull.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(vo.getOrgUnit().getId()));
        if (org.isIsCompanyOrgUnit()) {
            param.put("bizOrgUnitType", OrgType.Company);
        } else if (org.isIsCostOrgUnit()) {
            param.put("bizOrgUnitType", OrgType.CostCenter);
        } else if (org.isIsProfitOrgUnit()) {
            param.put("bizOrgUnitType", OrgType.ProfitCenter);
        }
        param.setCompanyId(vo.getCompany().getId());
        param.setBizOrgUnitId(vo.getOrgUnit().getId());
        param.put("beginYear", period.get("periodYear"));
        param.put("beginNumber", period.get("periodNumber"));
        param.put("endYear", period.get("periodYear"));
        param.put("endNumber", endNumber);
        param.put("companyNumber", vo.getCompany().getNumber());
        param.put("bizOrgUnitNumber", vo.getOrgUnit().getNumber());
        param.setBgTypeId(vo.getBgType().getId());
        param.setPeriodId(period.getId());
        this.initBgForm(ctx, vo, param, cache);
    }

    public void execute(Context ctx, BgFormInfo vo, PeriodInfo period, Integer endNumber, Map cache, String bgTypeId) throws BOSException, EASBizException {
        BgCtrlParam param = new BgCtrlParam();
        param.setCompanyId(vo.getCompany().getId());
        param.setBizOrgUnitId(vo.getOrgUnit().getId());
        param.put("beginYear", period.get("periodYear"));
        param.put("beginNumber", period.get("periodNumber"));
        param.put("endYear", period.get("periodYear"));
        param.put("endNumber", endNumber);
        param.put("companyNumber", vo.getCompany().getNumber());
        param.put("bizOrgUnitNumber", vo.getOrgUnit().getNumber());
        param.setBgTypeId(vo.getBgType().getId());
        param.setPeriodId(period.getId());
        this.initBgForm(ctx, vo, param, cache, bgTypeId);
    }

    private void initBgForm(Context ctx, BgFormInfo bgForm, BgCtrlParam param, Map cache) throws BOSException, EASBizException {
        BgDataCollection dataColl = this.getBgData(ctx, bgForm.getId(), param.getPeriodId());
        if (dataColl == null || dataColl.size() == 0) {
            return;
        }
        IBizAcctActualDataProvider provider = BizAcctActualDataProviderFactory.getLocalInstance((Context)ctx);
        for (int n = 0; n < dataColl.size(); ++n) {
            BgDataInfo data = dataColl.get(n);
            this.initParamItemData(ctx, param, data, cache);
            try {
                BgCtrlParam val = provider.getBizActualTotal(param);
            }
            catch (EASBizException exp) {
                exp.printStackTrace();
                continue;
            }
            BigDecimal bizValue = param.getData(BgElementEnum.getEnum(data.getInt("FBizElement"))).getValue();
            if (bizValue == null) continue;
            data.setBizActual(bizValue);
        }
        String[] proper = new String[]{"bizActual"};
        BgEntityAccess ea = new BgEntityAccess(ctx, dataColl.get(0).getBOSType(), proper);
        ea.update(ctx, BgORMEngine.buildVOArray((IObjectCollection)dataColl));
    }

    private void initBgForm(Context ctx, BgFormInfo bgForm, BgCtrlParam param, Map cache, String bgTypeId) throws BOSException, EASBizException {
        BgDataCollection dataColl = this.getBgData(ctx, bgForm.getId(), param.getPeriodId());
        if (dataColl == null || dataColl.size() == 0) {
            return;
        }
        IFaActualDataProviderImpl provider = null;
        if (bgTypeId.equals("c292cd11-00fb-1000-e000-0096c0a8129f530DC15D")) {
            provider = FaActualDataProviderImplFactory.getLocalInstance((Context)ctx);
        }
        for (int n = 0; n < dataColl.size(); ++n) {
            BgDataInfo data;
            block6: {
                data = dataColl.get(n);
                this.initParamItemData(ctx, param, data, cache);
                try {
                    if (provider == null) break block6;
                    BgCtrlParam bgCtrlParam = provider.getBizActualTotal(param);
                }
                catch (EASBizException exp) {
                    exp.printStackTrace();
                    continue;
                }
            }
            BigDecimal bizValue = param.getData(BgElementEnum.getEnum(data.getInt("FBizElement"))).getValue();
            if (bizValue != null) {
                data.setBizActual(bizValue);
            }
            param.removeData(BgElementEnum.getEnum(data.getInt("FBizElement")));
        }
        String[] proper = new String[]{"bizActual"};
        BgEntityAccess ea = new BgEntityAccess(ctx, dataColl.get(0).getBOSType(), proper);
        ea.update(ctx, BgORMEngine.buildVOArray((IObjectCollection)dataColl));
    }

    private void buildItem(Context ctx, BgCtrlParam param, int dims, String itemId, String number, Map cache) {
        if (itemId == null) {
            return;
        }
        IObjectValue vo = (IObjectValue)cache.get(itemId);
        if (vo == null) {
            BOSUuid id = BOSUuid.read((String)itemId);
            vo = BgORMEngine.getNewVOInstance(ctx, id);
            vo.setString("number", number);
            vo.setBOSUuid("id", id);
            cache.put(itemId, vo);
        }
        param.addDimension(BgDimensionEnum.getEnum(dims), vo);
    }

    public BgDataCollection getBgData(Context ctx, BOSUuid bgFormId, BOSUuid periodId) throws BOSException, EASBizException {
        String sql = "SELECT D.FID, D.FBgEntryID,D.FCurrencyID, C.FNumber AS FCurrencyNumber, E.FBizElement,  D.FBgValue, D.FBizActual, D.I1FBgDimension, D.I1FItemID, D.I1FItemNumber, D.I2FBgDimension,D.I2FItemID, D.I2FItemNumber, D.I3FBgDimension,D.I3FItemID, D.I3FItemNumber, D.I4FBgDimension,D.I4FItemID, D.I4FItemNumber, D.I5FBgDimension,D.I5FItemID, D.I5FItemNumber FROM V_BG_BgData D INNER JOIN T_BD_Currency C ON D.FCurrencyID = C.FID INNER JOIN T_BG_BgElement E ON D.FBgElementID = E.FID INNER JOIN T_BG_BgEntry F ON D.FBgEntryID=F.FID  WHERE (D.FBgFormID = ?) AND (D.FPeriodID = ?) AND F.FIsLeafPeriod=1";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        BgDataCollection coll = new BgDataCollection();
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            int length1 = bgFormId.toString().length();
            if (length1 != 28 && length1 != 44) {
                throw new SQLException("\u4e1a\u52a1\u5bf9\u8c61ID\u957f\u5ea6\u8bbe\u7f6e\u5f02\u5e38\uff01");
            }
            stmt.setAsciiStream(1, (InputStream)new ByteArrayInputStream(bgFormId.toString().getBytes()), length1);
            int length2 = periodId.toString().length();
            if (length2 != 28 && length2 != 44) {
                throw new SQLException("\u4e1a\u52a1\u5bf9\u8c61ID\u957f\u5ea6\u8bbe\u7f6e\u5f02\u5e38\uff01");
            }
            stmt.setAsciiStream(1, (InputStream)new ByteArrayInputStream(periodId.toString().getBytes()), length2);
            rs = stmt.executeQuery();
            HashMap cache = new HashMap();
            while (rs.next()) {
                BgDataInfo info = new BgDataInfo();
                info.setId(BOSUuid.read((String)rs.getString(1)));
                CurrencyInfo cuInfo = new CurrencyInfo();
                cuInfo.setId(BOSUuid.read((String)rs.getString("FCurrencyID")));
                info.setCurrency(cuInfo);
                info.setInt("I1FBgDimension", rs.getInt("I1FBgDimension"));
                info.setString("I1FItemID", rs.getString("I1FItemID"));
                info.setString("I1FItemNumber", rs.getString("I1FItemNumber"));
                info.setInt("I2FBgDimension", rs.getInt("I2FBgDimension"));
                info.setString("I2FItemID", rs.getString("I2FItemID"));
                info.setString("I2FItemNumber", rs.getString("I2FItemNumber"));
                info.setInt("I3FBgDimension", rs.getInt("I3FBgDimension"));
                info.setString("I3FItemID", rs.getString("I3FItemID"));
                info.setString("I3FItemNumber", rs.getString("I3FItemNumber"));
                info.setInt("I4FBgDimension", rs.getInt("I4FBgDimension"));
                info.setString("I4FItemID", rs.getString("I4FItemID"));
                info.setString("I4FItemNumber", rs.getString("I4FItemNumber"));
                info.setInt("I5FBgDimension", rs.getInt("I5FBgDimension"));
                info.setString("I5FItemID", rs.getString("I5FItemID"));
                info.setString("I5FItemNumber", rs.getString("I5FItemNumber"));
                info.setString("FCurrencyNumber", rs.getString("FCurrencyNumber"));
                info.setInt("FBizElement", rs.getInt("FBizElement"));
                info.setBgValue(rs.getBigDecimal("FBgValue"));
                info.setBizActual(rs.getBigDecimal("FBizActual"));
                coll.add(info);
            }
        }
        catch (SQLException exp) {
            try {
                throw new BgBizException(BgBizException.GETDATA, exp, new Object[0]);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return coll;
    }

    private void initParamItemData(Context ctx, BgCtrlParam param, BgDataInfo info, Map cache) {
        BgCtrlData ctrlData = new BgCtrlData();
        param.addData(BgElementEnum.getEnum(info.getInt("FBizElement")), ctrlData);
        param.setString("currencyNumber", info.getString("FCurrencyNumber"));
        param.setCurrencyId(info.getCurrency().getId());
        this.buildItem(ctx, param, info.getInt("I1FBgDimension"), info.getString("I1FItemID"), info.getString("I1FItemNumber"), cache);
        this.buildItem(ctx, param, info.getInt("I2FBgDimension"), info.getString("I2FItemID"), info.getString("I2FItemNumber"), cache);
        this.buildItem(ctx, param, info.getInt("I3FBgDimension"), info.getString("I3FItemID"), info.getString("I3FItemNumber"), cache);
        this.buildItem(ctx, param, info.getInt("I4FBgDimension"), info.getString("I4FItemID"), info.getString("I4FItemNumber"), cache);
        this.buildItem(ctx, param, info.getInt("I5FBgDimension"), info.getString("I5FItemID"), info.getString("I5FItemNumber"), cache);
    }

    @Override
    public void _execute(Context ctx) throws BOSException, EASBizException {
        java.util.Date date = new java.util.Date(System.currentTimeMillis());
        this._execute(ctx, date);
    }

    @Override
    public void _execute(Context ctx, IObjectPK bgFormId) throws BOSException, EASBizException {
        IBgForm iBgForm = BgFormFactory.getLocalInstance(ctx);
        BgFormInfo info = iBgForm.getBgFormInfo(bgFormId);
        if (info != null) {
            HashMap cache = new HashMap();
            this.execute(ctx, info, cache);
        }
    }
}

