/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgBizException;
import com.kingdee.eas.ma.bg.BgHelper;
import com.kingdee.eas.ma.bg.DisplayPeriodStyleEnum;
import com.kingdee.eas.ma.bg.app.dao.BgAlyDAOBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class BgBalanceAlyDAO
extends BgAlyDAOBase {
    private BgBalanceAlyDAO() {
    }

    public static BgBalanceAlyDAO getInstance(Context ctx) {
        BgBalanceAlyDAO dao = new BgBalanceAlyDAO();
        dao.ctx = ctx;
        dao.locale = ctx.getLocale().toString();
        return dao;
    }

    protected Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    public IRowSet getResult(EntityViewInfo ev) throws EASBizException, BOSException {
        FilterItemCollection filters = ev.getFilter().getFilterItems();
        boolean filterByBizDate = this.isByBizDate(filters);
        Integer dispPeriod = (Integer)BgHelper.getFilterValue(filters, "displayPeriodStyle");
        String table1 = BgHelper.getTableName(this.ctx);
        String table2 = BgHelper.getTableName(this.ctx);
        String sbCreateTable1 = this.getCreateSql1(table1);
        String sbInsertTable1 = this.getInsertSql1(filters, filterByBizDate, table1, dispPeriod);
        String sbCreateTable2 = this.getCreateSql2(table2);
        String sbInsertTable2 = this.getInsertSql2(filterByBizDate, dispPeriod, table1, table2);
        String table3 = BgHelper.getTableName(this.ctx);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        JdbcRowSet result = null;
        Connection conn = this.getConnection(this.ctx);
        try {
            stmt = conn.prepareStatement(sbCreateTable1);
            stmt.execute();
            SQLUtils.cleanup((Statement)stmt);
            stmt = conn.prepareStatement(sbInsertTable1);
            this.setParams1(filters, filterByBizDate, stmt);
            stmt.execute();
            SQLUtils.cleanup((Statement)stmt);
            stmt = conn.prepareStatement(sbCreateTable2);
            stmt.execute();
            stmt = conn.prepareStatement(sbInsertTable2);
            this.setParams2(filters, filterByBizDate, stmt);
            stmt.execute();
            stmt.close();
            table3 = BgHelper.getTableName(this.ctx);
            String sql = this.getCreateSql2(table3);
            stmt = conn.prepareStatement(sql);
            stmt.execute();
            stmt.close();
            stmt = conn.prepareStatement(this.getInsertSql3(filterByBizDate, dispPeriod, table2, table3));
            stmt.execute();
            String dispSql = this.getDisplaySql(table3);
            stmt = conn.prepareStatement(dispSql);
            rs = stmt.executeQuery();
            result = new JdbcRowSet();
            result.populate(rs);
        }
        catch (SQLException e) {
            try {
                throw new BgBizException(BgBizException.GETDATA, e, new Object[]{"filterBgType"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
                BgHelper.dropTable(this.ctx, table1);
                BgHelper.dropTable(this.ctx, table2);
                BgHelper.dropTable(this.ctx, table3);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        BgHelper.dropTable(this.ctx, table1);
        BgHelper.dropTable(this.ctx, table2);
        BgHelper.dropTable(this.ctx, table3);
        return result;
    }

    public void setParams2(FilterItemCollection filters, boolean filterByBizDate, PreparedStatement stmt) throws SQLException {
        if (filterByBizDate) {
            stmt.setDate(1, (Date)BgHelper.getFilterValue(filters, "beginBizDate"));
            stmt.setDate(2, (Date)BgHelper.getFilterValue(filters, "endBizDate"));
        }
    }

    public void setParams1(FilterItemCollection filters, boolean filterByBizDate, PreparedStatement stmt) throws SQLException {
        int number = 1;
        stmt.setString(number++, BgHelper.getId(BgHelper.getFilterValue(filters, "bgType")));
        if (filterByBizDate) {
            stmt.setDate(number++, (Date)BgHelper.getFilterValue(filters, "beginBizDate"));
            stmt.setDate(number++, (Date)BgHelper.getFilterValue(filters, "endBizDate"));
        } else {
            int beginPeriodYear = Integer.parseInt(BgHelper.getFilterValue(filters, "beginPeriodYear").toString());
            int beginPeriodMonth = Integer.parseInt(BgHelper.getFilterValue(filters, "beginPeriodMonth").toString());
            int endPeriodYear = Integer.parseInt(BgHelper.getFilterValue(filters, "endPeriodYear").toString());
            int endPeriodMonth = Integer.parseInt(BgHelper.getFilterValue(filters, "endPeriodMonth").toString());
            stmt.setInt(number++, beginPeriodYear * 100 + beginPeriodMonth);
            stmt.setInt(number++, endPeriodYear * 100 + endPeriodMonth);
        }
    }

    public String getInsertSql2(boolean filterByBizDate, Integer dispPeriod, String tableName1, String tableName2) {
        if (dispPeriod == 12) {
            String dispPeriodS = " to_char(Period.FPeriodYear)||'" + (Object)((Object)DisplayPeriodStyleEnum.YEAR) + "'  as FDispPeriod,";
            String groupPeriod = " Period.FPeriodYear,";
            return this.groupByPeriod(filterByBizDate, tableName1, tableName2, dispPeriodS, groupPeriod);
        }
        if (dispPeriod == 3) {
            String dispPeriodS = " to_char(Period.FPeriodYear)||'-'||to_char(Period.FPeriodQuarter)||'" + (Object)((Object)DisplayPeriodStyleEnum.QUARTER) + "'  as FDispPeriod,";
            String groupPeriod = " Period.FPeriodYear,Period.FPeriodQuarter,";
            return this.groupByPeriod(filterByBizDate, tableName1, tableName2, dispPeriodS, groupPeriod);
        }
        String dispPeriodS = " to_char(Period.FPeriodYear)||'-'||right('0'||to_char(Period.FPeriodNumber),2)||'" + (Object)((Object)DisplayPeriodStyleEnum.PERIOD) + "' as FDispPeriod,";
        String groupPeriod = " Period.FPeriodYear,Period.FPeriodNumber,";
        return this.groupByPeriod(filterByBizDate, tableName1, tableName2, dispPeriodS, groupPeriod);
    }

    private String groupByPeriod(boolean filterByBizDate, String tableName1, String tableName2, String dispPeriod, String groupPeriod) {
        StringBuffer sbInsertTable2 = new StringBuffer();
        sbInsertTable2.append("INSERT INTO ");
        sbInsertTable2.append(tableName2);
        sbInsertTable2.append(" SELECT isnull(BgEntry.FBgItem1ID,'') || isnull(BgEntry.FBgItem2ID,'') || isnull(BgEntry.FBgItem3ID,'') || isnull(BgEntry.FBgItem4ID,'') || isnull(BgEntry.FBgItem5ID,'')  AS FID,  BgEntry.FOrgUnitID, BgEntry.FBgTypeID," + dispPeriod + " BgElement.FBizElement, BgData.FCurrencyID, isnull(BgData.FBgValue,0), isnull(BgData.FBgLastBalance,0), isnull(BgData.FBgActual,0), isnull(BgData.FBizActual,0), isnull(BgData.FBgInitialValue,0), isnull(BgData.FBgBalance,0), isnull(BgData.FBgUsableValue,0), Sum(BgCtrlDetail.FBizData0), Sum(BgCtrlDetail.FBizData1), Sum(BgCtrlDetail.FBizData2), Sum(BgCtrlDetail.FBizData3), Sum(BgCtrlDetail.FBizData4), BgCtrlDetail.FCtrlSystem, BgEntry.FBgItem1ID, BgEntry.FBgItem2ID, BgEntry.FBgItem3ID, BgEntry.FBgItem4ID, BgEntry.FBgItem5ID, BgEntry.FBgItem6ID ");
        sbInsertTable2.append(" FROM T_BG_BgCtrlDetail BgCtrlDetail INNER JOIN T_BG_BgCtrlDetailEntry CtrlDetailEntry ON BgCtrlDetail.FID = CtrlDetailEntry.FBillID  RIGHT OUTER JOIN T_BG_BgData BgData INNER JOIN T_BG_BgElement BgElement ON BgData.FBgElementID = BgElement.FID inner JOIN ");
        sbInsertTable2.append(tableName1);
        sbInsertTable2.append(" BgEntry ON BgData.FBgEntryID = BgEntry.FID ON CtrlDetailEntry.FBgDataID = BgData.FID INNER JOIN T_BD_Period Period ON Period.FID = BgEntry.FPeriodID");
        if (filterByBizDate) {
            sbInsertTable2.append(" Where  (BgCtrlDetail.FBizDate BETWEEN ? AND ?)");
        }
        sbInsertTable2.append(" GROUP BY  BgEntry.FOrgUnitID,BgEntry.FBgTypeID," + groupPeriod + "BgElement.FBizElement,BgData.FCurrencyID,BgCtrlDetail.FCtrlSystem , BgEntry.FBgItem1ID,BgEntry.FBgItem2ID,BgEntry.FBgItem3ID,BgEntry.FBgItem4ID,BgEntry.FBgItem5ID,BgEntry.FBgItem6ID, BgData.FBgValue, BgData.FBgLastBalance, BgData.FBgActual, BgData.FBizActual, BgData.FBgInitialValue, BgData.FBgBalance, BgData.FBgUsableValue");
        return sbInsertTable2.toString();
    }

    public String getInsertSql3(boolean filterByBizDate, Integer dispPeriod, String tableName1, String tableName2) {
        return this.groupByPeriod2(filterByBizDate, tableName1, tableName2);
    }

    private String groupByPeriod2(boolean filterByBizDate, String table1, String table2) {
        StringBuffer sbInsertTable2 = new StringBuffer();
        sbInsertTable2.append("INSERT INTO ");
        sbInsertTable2.append(table2);
        sbInsertTable2.append(" SELECT FOrgUnitId||FDispPeriod||FID AS FID,  FOrgUnitID, FBgTypeID, FDispPeriod, FBizElement, FCurrencyID, sum(FBgValue), sum(FBgLastBalance), sum(FBgValue)-sum(FBgBalance),  sum(FBizActual), sum(FBgInitialValue), sum(FBgBalance), sum(FBgUsableValue), Sum(FBizData0), Sum(FBizData1), Sum(FBizData2), Sum(FBizData3), Sum(FBizData4), FCtrlSystem, FBgItem1ID, FBgItem2ID, FBgItem3ID, FBgItem4ID, FBgItem5ID, FBgItem6ID ");
        sbInsertTable2.append(" FROM ");
        sbInsertTable2.append(table1);
        sbInsertTable2.append(" GROUP BY  FOrgUnitID,FBgTypeID,FDispPeriod, FBizElement, FCurrencyID, FBgItem1ID,FBgItem2ID,FBgItem3ID,FBgItem4ID,FBgItem5ID,FBgItem6ID,FID, FCtrlSystem ");
        return sbInsertTable2.toString();
    }

    public String getCreateSql2(String tableName2) {
        StringBuffer sbCreateTable2 = new StringBuffer();
        sbCreateTable2.append("Create Table ");
        sbCreateTable2.append(tableName2);
        sbCreateTable2.append(" (FID varchar (512),FOrgUnitID char (44),FBgTypeID char (44),FDispPeriod char (44),FBizElement int ,FCurrencyID char (44),FBgValue decimal(28,10),FBgLastBalance decimal(28,10),FBgActual decimal(28,10),FBizActual decimal(28,10),FBgInitialValue decimal(28,10),FBgBalance decimal(28,10),FBgUsableValue decimal(28,10),FBizData0 decimal(28,10),FBizData1 decimal(28,10),FBizData2 decimal(28,10),FBizData3 decimal(28,10),FBizData4 decimal(28,10),FCtrlSystem int ,FBgItem1ID char (44),FBgItem2ID char (44),FBgItem3ID char (44),FBgItem4ID char (44),FBgItem5ID char (44),FBgItem6ID char (44))");
        return sbCreateTable2.toString();
    }

    public String getInsertSql1(FilterItemCollection filters, boolean filterByBizDate, String tableName1, Integer dispPeriod) {
        StringBuffer sbInsertTable1 = new StringBuffer();
        sbInsertTable1.append("INSERT INTO ");
        sbInsertTable1.append(tableName1);
        sbInsertTable1.append(" SELECT v.FID, v.FOrgUnitID, v.FBgTypeID, v.FPeriodID, v.FBgItem1ID, v.FBgItem2ID, v.FBgItem3ID, v.FBgItem4ID, v.FBgItem5ID, v.FBgItem6ID FROM V_BG_BgEntry as v, t_bg_bgentry as t");
        if (filterByBizDate) {
            sbInsertTable1.append(" WHERE  (v.FOrgUnitID IN (").append(BgHelper.getFilterValue(filters, "bizOrgUnitIDs")).append(")  AND (v.FBgTypeID = ?) AND (v.FEndDate  > ?) AND  (v.FBeginDate < ?))");
        } else {
            sbInsertTable1.append(" WHERE  (v.FOrgUnitID IN (").append(BgHelper.getFilterValue(filters, "bizOrgUnitIDs")).append(") ").append(" AND (v.FBgTypeID = ?) AND (v.FPeriodYear*100+v.FPeriodNumber  BETWEEN ? AND ?)) ");
        }
        sbInsertTable1.append(" and v.fid=t.fid ");
        if (dispPeriod != 12) {
            if (dispPeriod == 1) {
                sbInsertTable1.append(" and t.FBgCycle=3 ");
            } else if (dispPeriod == 3) {
                sbInsertTable1.append(" and (t.FBgCycle=2 or t.FBgCycle=3) ");
            }
        }
        return sbInsertTable1.toString();
    }

    public String getCreateSql1(String tableName1) {
        StringBuffer sbCreateTable1 = new StringBuffer();
        sbCreateTable1.append("Create Table ");
        sbCreateTable1.append(tableName1);
        sbCreateTable1.append("( FID char (44), FOrgUnitID char (44), FBgTypeID char (44), FPeriodID char (44), FBgItem1ID char (44), FBgItem2ID char (44), FBgItem3ID char (44), FBgItem4ID char (44), FBgItem5ID char (44), FBgItem6ID char (44) )");
        return sbCreateTable1.toString();
    }
}

