/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgBizException;
import com.kingdee.eas.ma.bg.BgConstants;
import com.kingdee.eas.ma.bg.BgCtrlDetailEntryInfo;
import com.kingdee.eas.ma.bg.BgCtrlDetailInfo;
import com.kingdee.eas.ma.bg.BgDataInfo;
import com.kingdee.eas.ma.bg.BgDataTypeEnum;
import com.kingdee.eas.ma.bg.BgFormCollection;
import com.kingdee.eas.ma.bg.BgFormInfo;
import com.kingdee.eas.ma.bg.BgHelper;
import com.kingdee.eas.ma.bg.BgTemplateInfo;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.BgVerifyException;
import com.kingdee.eas.ma.bg.app.dao.BgDAO;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class BgCtrlDAO {
    private static Logger logger = Logger.getLogger(BgCtrlDAO.class);
    protected Context ctx = null;
    protected String locale = null;

    protected BgCtrlDAO() {
    }

    protected Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    public void initDAO(Context ctx) {
        this.ctx = ctx;
        this.locale = ctx.getLocale().toString();
    }

    public static BgCtrlDAO getInstance(Context ctx) {
        BgCtrlDAO dao = new BgCtrlDAO();
        dao.initDAO(ctx);
        return dao;
    }

    public boolean updateBgBalanceData(BgDataInfo info, BigDecimal changeValue) throws EASBizException, BOSException {
        String sql = "update T_BG_BgData set FBgBalance = FBgBalance - ? where FID = ?";
        PreparedStatement stmt = null;
        Connection conn = this.getConnection(this.ctx);
        try {
            stmt = conn.prepareStatement(sql);
            stmt.setBigDecimal(1, changeValue);
            int length = info.getId().toString().length();
            if (length != 28 && length != 44) {
                throw new SQLException("\u4e1a\u52a1\u5bf9\u8c61ID\u957f\u5ea6\u8bbe\u7f6e\u5f02\u5e38\uff01");
            }
            stmt.setAsciiStream(2, (InputStream)new ByteArrayInputStream(info.getId().toString().getBytes()), length);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("BgBalance is:" + changeValue));
            }
            boolean bl = stmt.execute();
            return bl;
        }
        catch (SQLException e3) {
            throw new EASBizException(BgBizException.UPDATEBALANCE, (Throwable)e3, new Object[]{info.getId() + ": " + changeValue});
        }
        finally {
            SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        }
    }

    public boolean updateBizActualData(BgDataInfo info, BigDecimal changeValue) throws EASBizException, BOSException {
        String sql = "update T_BG_BgData set FBizActual =  ? where FID = ?";
        PreparedStatement stmt = null;
        Connection conn = this.getConnection(this.ctx);
        try {
            stmt = conn.prepareStatement(sql);
            stmt.setBigDecimal(1, changeValue);
            int length = info.getId().toString().length();
            if (length != 28 && length != 44) {
                throw new SQLException("\u4e1a\u52a1\u5bf9\u8c61ID\u957f\u5ea6\u8bbe\u7f6e\u5f02\u5e38\uff01");
            }
            stmt.setAsciiStream(2, (InputStream)new ByteArrayInputStream(info.getId().toString().getBytes()), length);
            if (logger.isDebugEnabled()) {
                logger.info((Object)("FBizActual is: " + changeValue));
            }
            boolean bl = stmt.execute();
            return bl;
        }
        catch (SQLException e3) {
            throw new EASBizException(BgBizException.UPDATEBALANCE, (Throwable)e3, new Object[]{info.getId() + ": " + changeValue});
        }
        finally {
            SQLUtils.cleanup((Statement)stmt);
            SQLUtils.cleanup((Connection)conn);
        }
    }

    public boolean updateBgValueData(BgDataInfo info, BigDecimal changeValue) throws EASBizException, BOSException {
        if (changeValue == null || changeValue.compareTo(BgConstants.ZERO) == 0) {
            return false;
        }
        this.updateBgBalanceData(info, changeValue.negate());
        String sql = "update T_BG_BgData set FBgValue = FBgValue + ? where FID = ?";
        PreparedStatement stmt = null;
        Connection conn = this.getConnection(this.ctx);
        try {
            stmt = conn.prepareStatement(sql);
            stmt.setBigDecimal(1, changeValue);
            int length = info.getId().toString().length();
            if (length != 28 && length != 44) {
                throw new SQLException("\u4e1a\u52a1\u5bf9\u8c61ID\u957f\u5ea6\u8bbe\u7f6e\u5f02\u5e38\uff01");
            }
            stmt.setAsciiStream(2, (InputStream)new ByteArrayInputStream(info.getId().toString().getBytes()), length);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("BgValue is: " + changeValue));
            }
            boolean bl = stmt.execute();
            return bl;
        }
        catch (SQLException e3) {
            throw new EASBizException(BgBizException.UPDATEBALANCE, (Throwable)e3, new Object[]{info.getId() + ": " + changeValue});
        }
        finally {
            SQLUtils.cleanup((Statement)stmt);
            SQLUtils.cleanup((Connection)conn);
        }
    }

    public int ctrlDetailInsert(BgCtrlDetailInfo ctrlInfo) throws EASBizException, BOSException {
        if (ctrlInfo.getEntries().size() == 0) {
            return 0;
        }
        if (ctrlInfo.getDataType() == null) {
            ctrlInfo.setDataType(BgDataTypeEnum.Amount);
        }
        for (int i = 0; i < ctrlInfo.getEntries().size(); ++i) {
            ctrlInfo.getEntries().get(i).setBill(ctrlInfo);
        }
        int result = 0;
        StringBuffer sb = new StringBuffer(2250);
        sb.append("INSERT INTO T_BG_BgCtrlDetail (FID,                      FName_L1,                 FName_L2,                 FName_L3,                 FNumber,                  FDescription_L1,          FDescription_L2,          FDescription_L3,          FSimpleName,              FCreatorID,               FCreateTime,              FLastUpdateUserID,        FLastUpdateTime,          FCompanyID,               FBgTypeID,                FBgFormID,                FPeriodID,                FCurrencyID,              FMeasureUnitID,           FBgAuditStyle,            FSrcBillTypeID,           FSrcBillNumber,           FSrcBillID,               FSrcEntryNumber,          FSrcEntryID,              FBizOrgUnitID,            FBizDate,                 FCtrlSystem,              FDataType,                FBizData0,                FBizData1,                FBizData2,                FBizData3,                FBizData4,                FBgItem0ID,               FBgItem1ID,               FBgItem2ID,               FBgItem3ID,               FBgItem4ID,               FBgItem5ID,               FBgItem6ID                )");
        sb.append("VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        Connection conn = this.getConnection(this.ctx);
        PreparedStatement stmt = null;
        PreparedStatement stmtEntry = null;
        int number = 1;
        try {
            stmt = conn.prepareStatement(sb.toString());
            String id = Uuid.create().toString() + ctrlInfo.getBOSType().toString();
            stmt.setString(number++, id);
            stmt.setString(number++, ctrlInfo.getName(new Locale("L1")));
            stmt.setString(number++, ctrlInfo.getName(new Locale("L2")));
            stmt.setString(number++, ctrlInfo.getName(new Locale("L3")));
            stmt.setString(number++, ctrlInfo.getNumber());
            stmt.setString(number++, ctrlInfo.getDescription(new Locale("L1")));
            stmt.setString(number++, ctrlInfo.getDescription(new Locale("L2")));
            stmt.setString(number++, ctrlInfo.getDescription(new Locale("L3")));
            stmt.setString(number++, ctrlInfo.getSimpleName());
            stmt.setString(number++, BgHelper.getId(ctrlInfo.getCreator()));
            stmt.setTimestamp(number++, ctrlInfo.getCreateTime());
            stmt.setString(number++, BgHelper.getId(ctrlInfo.getLastUpdateUser()));
            stmt.setTimestamp(number++, ctrlInfo.getLastUpdateTime());
            stmt.setString(number++, BgHelper.getId(ctrlInfo.getCompany()));
            stmt.setString(number++, ctrlInfo.getBgType().getId().toString());
            stmt.setString(number++, BgHelper.getId(ctrlInfo.getBgForm()));
            stmt.setString(number++, BgHelper.getId(ctrlInfo.getPeriod()));
            stmt.setString(number++, BgHelper.getId(ctrlInfo.getCurrency()));
            stmt.setString(number++, BgHelper.getId(ctrlInfo.getMeasureUnit()));
            stmt.setInt(number++, ctrlInfo.getBgAuditStyle().getValue());
            stmt.setString(number++, ctrlInfo.getSrcBillTypeID());
            stmt.setString(number++, ctrlInfo.getSrcBillNumber());
            stmt.setString(number++, BgHelper.getString(ctrlInfo.getSrcBillID()));
            stmt.setString(number++, ctrlInfo.getSrcEntryNumber());
            stmt.setString(number++, BgHelper.getString(ctrlInfo.getSrcEntryID()));
            stmt.setString(number++, BgHelper.getId(ctrlInfo.getBizOrgUnit()));
            stmt.setDate(number++, (Date)ctrlInfo.getBizDate());
            stmt.setInt(number++, ctrlInfo.getCtrlSystem().getValue());
            stmt.setInt(number++, BgHelper.getValue(ctrlInfo.getDataType()));
            stmt.setBigDecimal(number++, ctrlInfo.getBizData0());
            stmt.setBigDecimal(number++, ctrlInfo.getBizData1());
            stmt.setBigDecimal(number++, ctrlInfo.getBizData2());
            stmt.setBigDecimal(number++, ctrlInfo.getBizData3());
            stmt.setBigDecimal(number++, ctrlInfo.getBizData4());
            stmt.setString(number++, BgHelper.getString(ctrlInfo.getBgItem0ID()));
            stmt.setString(number++, BgHelper.getString(ctrlInfo.getBgItem1ID()));
            stmt.setString(number++, BgHelper.getString(ctrlInfo.getBgItem2ID()));
            stmt.setString(number++, BgHelper.getString(ctrlInfo.getBgItem3ID()));
            stmt.setString(number++, BgHelper.getString(ctrlInfo.getBgItem4ID()));
            stmt.setString(number++, BgHelper.getString(ctrlInfo.getBgItem5ID()));
            stmt.setString(number++, BgHelper.getString(ctrlInfo.getBgItem6ID()));
            result = stmt.executeUpdate();
            String sqlEntry = "INSERT INTO T_Bg_BgCtrlDetailEntry   (FID, FSeq, FBgDataID, FBgCurrencyID, FBgActualValue, FBillID)VALUES (?, ?, ?, ?, ?, ?);";
            stmtEntry = conn.prepareStatement(sqlEntry);
            for (int seq = 0; seq < ctrlInfo.getEntries().size(); ++seq) {
                BgCtrlDetailEntryInfo entry = ctrlInfo.getEntries().get(seq);
                stmtEntry.setString(1, Uuid.create().toString() + entry.getBOSType().toString());
                stmtEntry.setInt(2, seq);
                stmtEntry.setString(3, BgHelper.getId(entry.getBgData()));
                stmtEntry.setString(4, BgHelper.getId(entry.getBgCurrency()));
                stmtEntry.setBigDecimal(5, entry.getBgActualValue());
                stmtEntry.setString(6, id);
                stmtEntry.execute();
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgBizException(BgBizException.ADDNEWCTRLDETAIL, ex, new Object[]{"sql err"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt);
                SQLUtils.cleanup(stmtEntry);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt);
        SQLUtils.cleanup((Statement)stmtEntry);
        SQLUtils.cleanup((Connection)conn);
        return result;
    }

    public BOSUuid getBgCtrlOrgUnitId(BOSUuid bgTreeId, BOSUuid bizTreeId, String number) throws EASBizException, BOSException {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block4: {
            BOSUuid bOSUuid;
            String sql = "SELECT BgTree.FUnitID, BgTree.FIsLeaf\tFROM T_ORG_Structure BgTree INNER JOIN\tT_ORG_Structure CCTree ON BgTree.FUnitID = CCTree.FUnitID\tWHERE (BgTree.FIsLeaf = 1) AND (BgTree.FTreeID = ?) AND (CCTree.FTreeID = ?) AND (LEFT(?, LENGTH(CCTree.FLongNumber))= CCTree.FLongNumber)";
            conn = this.getConnection(this.ctx);
            stmt = null;
            rs = null;
            try {
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, bgTreeId.toString());
                stmt.setString(2, bizTreeId.toString());
                stmt.setString(3, number);
                rs = stmt.executeQuery();
                if (!rs.next()) break block4;
                bOSUuid = BOSUuid.read((String)rs.getString(1));
            }
            catch (SQLException e) {
                try {
                    throw new EASBizException(BgBizException.GETDATA, (Throwable)e, new Object[]{number});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, (Statement)stmt);
                    SQLUtils.cleanup((Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            SQLUtils.cleanup((Connection)conn);
            return bOSUuid;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        SQLUtils.cleanup((Connection)conn);
        throw new EASBizException(BgVerifyException.CHECKNOEXIST, new Object[]{number});
    }

    public BOSUuid getBgCtrlOrgUnitId(BOSUuid bgTreeId, BOSUuid bizTreeId, BOSUuid bizOrgId) throws EASBizException, BOSException {
        String number = BgDAO.getInstant(this.ctx).getLongNumber(bizTreeId, bizOrgId);
        return this.getBgCtrlOrgUnitId(bgTreeId, bizTreeId, number);
    }

    public BOSUuid getBgTreeId(BOSUuid bgTypeId) throws EASBizException, BOSException {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block4: {
            BOSUuid bOSUuid;
            String sql = "SELECT FOrgTreeID FROM T_BG_BgType  WHERE (FID = ?)";
            conn = this.getConnection(this.ctx);
            stmt = null;
            rs = null;
            try {
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, bgTypeId.toString());
                rs = stmt.executeQuery();
                if (!rs.next()) break block4;
                bOSUuid = BOSUuid.read((String)rs.getString(1));
            }
            catch (SQLException e) {
                try {
                    throw new EASBizException(BgBizException.GETDATA, (Throwable)e, new Object[]{bgTypeId});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, (Statement)stmt);
                    SQLUtils.cleanup((Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            SQLUtils.cleanup((Connection)conn);
            return bOSUuid;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        SQLUtils.cleanup((Connection)conn);
        throw new EASBizException(BgBizException.GETDATA, new Object[]{bgTypeId});
    }

    public BOSUuid getBgCtrlOrgUnitId(BOSUuid bgTreeId, BOSUuid bizOrgUnitId) throws EASBizException, BOSException {
        BOSUuid bOSUuid;
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block5: {
            String sql = " SELECT  FUnitID FROM T_ORG_Structure WHERE (FTreeID = ?) AND (FIsLeaf = 1) AND (FUnitID = ?)";
            conn = this.getConnection(this.ctx);
            stmt = null;
            rs = null;
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, bgTreeId.toString());
            stmt.setString(2, bizOrgUnitId.toString());
            rs = stmt.executeQuery();
            if (!rs.next()) break block5;
            BOSUuid bOSUuid2 = BOSUuid.read((String)rs.getString(1));
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            SQLUtils.cleanup((Connection)conn);
            return bOSUuid2;
        }
        try {
            bOSUuid = null;
        }
        catch (SQLException e) {
            try {
                throw new EASBizException(BgBizException.GETDATA, (Throwable)e, new Object[]{bgTreeId});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        SQLUtils.cleanup((Connection)conn);
        return bOSUuid;
    }

    public BgFormCollection getBgForm(Context ctx, Date date) throws BOSException, EASBizException {
        String curAndHisFormSql = "SELECT DISTINCT F.FID, F.FBgTypeID, F.FCompanyID, F.FOrgUnitID, F.FBgTemplateID FROM T_BG_BgForm F INNER JOIN T_BD_Period P1 ON F.FPeriodFromID = P1.FID INNER JOIN T_BD_Period P2 ON F.FPeriodToID = P2.FID WHERE (F.FState IN (2, 6)) AND (? BETWEEN P1.FBeginDate AND P2.FEndDate)";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        BgFormCollection coll = new BgFormCollection();
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(curAndHisFormSql);
            stmt.setDate(1, date);
            rs = stmt.executeQuery();
            HashMap cache = new HashMap();
            while (rs.next()) {
                BgFormInfo info = new BgFormInfo();
                info.setId(BOSUuid.read((String)rs.getString("FID")));
                BgHelper.buildVO((IObjectValue)info, "company", rs, "FCompanyID", CompanyOrgUnitInfo.class, cache);
                BgHelper.buildVO((IObjectValue)info, "bgType", rs, "FBgTypeID", BgTypeInfo.class, cache);
                BgHelper.buildVO((IObjectValue)info, "orgUnit", rs, "FOrgUnitID", FullOrgUnitInfo.class, cache);
                BgHelper.buildVO((IObjectValue)info, "bgTemplate", rs, "FBgTemplateID", BgTemplateInfo.class, cache);
                coll.add(info);
            }
        }
        catch (SQLException e) {
            try {
                throw new BgBizException(BgBizException.GETDATA, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return coll;
    }

    public BgFormCollection getBgForm(Context ctx, Date date, String id) throws BOSException, EASBizException {
        String curAndHisFormSql = "SELECT DISTINCT F.FID, F.FBgTypeID, F.FCompanyID, F.FOrgUnitID, F.FBgTemplateID FROM T_BG_BgForm F INNER JOIN T_BD_Period P1 ON F.FPeriodFromID = P1.FID INNER JOIN T_BD_Period P2 ON F.FPeriodToID = P2.FID WHERE (F.FState IN (2, 6)) AND (? BETWEEN P1.FBeginDate AND P2.FEndDate) AND F.FID=?";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        BgFormCollection coll = new BgFormCollection();
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(curAndHisFormSql);
            stmt.setDate(1, date);
            stmt.setString(2, id);
            rs = stmt.executeQuery();
            HashMap cache = new HashMap();
            while (rs.next()) {
                BgFormInfo info = new BgFormInfo();
                info.setId(BOSUuid.read((String)rs.getString("FID")));
                BgHelper.buildVO((IObjectValue)info, "company", rs, "FCompanyID", CompanyOrgUnitInfo.class, cache);
                BgHelper.buildVO((IObjectValue)info, "bgType", rs, "FBgTypeID", BgTypeInfo.class, cache);
                BgHelper.buildVO((IObjectValue)info, "orgUnit", rs, "FOrgUnitID", FullOrgUnitInfo.class, cache);
                BgHelper.buildVO((IObjectValue)info, "bgTemplate", rs, "FBgTemplateID", BgTemplateInfo.class, cache);
                coll.add(info);
            }
        }
        catch (SQLException e) {
            try {
                throw new BgBizException(BgBizException.GETDATA, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return coll;
    }

    public String getOrgUnitTable(Context ctx) throws BOSException, EASBizException {
        String table = "";
        try {
            table = BgHelper.getTableName(ctx);
        }
        catch (BOSException e) {
            e.printStackTrace();
            logger.info((Object)"bgCtrlDAO");
            logger.info((Object)e);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            logger.info((Object)e);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("create table ");
        sb.append(table);
        sb.append("( FID char(44),");
        sb.append(" FName nvarchar(256),");
        sb.append(" FLevel int,");
        sb.append(" FIsLeaf int,");
        sb.append(" FNumber varchar(50),");
        sb.append(" FLongNumber varchar(256),");
        sb.append(" FSuperID char(44))");
        Connection conn = this.getConnection(ctx);
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(sb.toString());
            stmt.execute();
        }
        catch (SQLException e) {
            throw new BgBizException(BgBizException.CREATETABLE, e, new String[]{"orgTempTable" + table});
        }
        finally {
            SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        }
        return table;
    }
}

