/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgBizException;
import com.kingdee.eas.ma.bg.BgDimensionEnum;
import com.kingdee.eas.ma.bg.BgElementEnum;
import com.kingdee.eas.ma.bg.BgVerifyException;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class BgDAO {
    protected Context ctx = null;
    protected String locale = null;

    public void initDAO(Context ctx) {
        this.ctx = ctx;
        this.locale = ctx.getLocale().toString();
    }

    public static BgDAO getInstant(Context ctx) {
        BgDAO dao = new BgDAO();
        dao.initDAO(ctx);
        return dao;
    }

    protected Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    public CurrencyCollection getHistCurrencyCollRowSet(BOSUuid bgTypeId) throws EASBizException, BOSException {
        String sql = "SELECT DISTINCT \tT_BD_Currency.FID AS FId,  T_BD_Currency.FNumber AS FNumber,\tT_BD_Currency.FName_" + this.locale + " AS FName\tFROM T_BG_BgTemplate INNER JOIN\tT_BG_ReferencedCurrency ON T_BG_BgTemplate.FID = T_BG_ReferencedCurrency.FBgTemplateID INNER JOIN\tT_BD_Currency ON T_BG_ReferencedCurrency.FCurrencyID = T_BD_Currency.FID  WHERE (T_BG_BgTemplate.FBgTypeID = ?)";
        PreparedStatement stmt = null;
        CurrencyCollection coll = null;
        ResultSet rs = null;
        Connection conn = this.getConnection(this.ctx);
        try {
            stmt = conn.prepareStatement(sql);
            int number = 1;
            stmt.setString(number++, bgTypeId.toString());
            rs = stmt.executeQuery();
            coll = new CurrencyCollection();
            while (rs.next()) {
                CurrencyInfo info = new CurrencyInfo();
                info.setId(BOSUuid.read((String)rs.getString(1)));
                info.setNumber(rs.getString(2));
                info.setName(rs.getString(3));
                coll.add(info);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgBizException(BgBizException.BGALYRPTFETCHDATA, ex, new Object[]{"getHistCurrencyCollRowSet"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        SQLUtils.cleanup((Connection)conn);
        return coll;
    }

    public List getHistDimList(BOSUuid bgTypeId) throws EASBizException, BOSException {
        String sql = " SELECT DISTINCT  T_BG_BgItem.FBgDimension ,T_BG_ReferencedDimension.FSeq FROM T_BG_BgTemplate  INNER JOIN T_BG_ReferencedDimension ON T_BG_BgTemplate.FID = T_BG_ReferencedDimension.FBgTemplateID INNER JOIN T_BG_BgItem ON T_BG_ReferencedDimension.FID = T_BG_BgItem.FRefDimensionID  WHERE (T_BG_BgTemplate.FBgTypeID = ?) ORDER BY T_BG_ReferencedDimension.FSeq ASC, T_BG_BgItem.FBgDimension DESC ";
        PreparedStatement stmt = null;
        ArrayList<BgDimensionEnum> list = null;
        Connection conn = this.getConnection(this.ctx);
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(sql);
            int number = 1;
            stmt.setString(number++, bgTypeId.toString());
            rs = stmt.executeQuery();
            list = new ArrayList<BgDimensionEnum>();
            while (rs.next()) {
                BgDimensionEnum value = BgDimensionEnum.getEnum(rs.getInt(1));
                if (value == null || list.contains((Object)value)) continue;
                list.add(value);
            }
        }
        catch (SQLException ex) {
            try {
                ex.printStackTrace();
                throw new BgBizException(BgBizException.BGALYRPTFETCHDATA, new Object[]{"getHistDimCollRowSet"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        SQLUtils.cleanup((Connection)conn);
        return list;
    }

    public List getHistDimList(BOSUuid bgTypeId, BOSUuid bizOrgUnitId) throws EASBizException, BOSException {
        String sql = " SELECT DISTINCT  T_BG_BgItem.FBgDimension ,T_BG_ReferencedDimension.FIsPrimary FROM T_BG_BgTemplate  INNER JOIN T_BG_ReferencedDimension ON T_BG_BgTemplate.FID = T_BG_ReferencedDimension.FBgTemplateID INNER JOIN T_BG_BgItem ON T_BG_ReferencedDimension.FID = T_BG_BgItem.FRefDimensionID  WHERE (T_BG_BgTemplate.FBgTypeID = ?) ORDER BY T_BG_ReferencedDimension.FIsPrimary DESC";
        PreparedStatement stmt = null;
        ArrayList<BgDimensionEnum> list = null;
        Connection conn = this.getConnection(this.ctx);
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(sql);
            int number = 1;
            stmt.setString(number++, bgTypeId.toString());
            rs = stmt.executeQuery();
            list = new ArrayList<BgDimensionEnum>();
            while (rs.next()) {
                list.add(BgDimensionEnum.getEnum(rs.getInt(1)));
            }
        }
        catch (SQLException ex) {
            try {
                ex.printStackTrace();
                throw new BgBizException(BgBizException.BGALYRPTFETCHDATA, new Object[]{"getHistDimCollRowSet"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        SQLUtils.cleanup((Connection)conn);
        return list;
    }

    public List getHistElementList(BOSUuid bgTypeId) throws EASBizException, BOSException {
        String sql = " SELECT DISTINCT FBizElement FROM T_BG_BgElement WHERE (FBgTypeID = ?) And  fsummable =1";
        PreparedStatement stmt = null;
        ArrayList<BgElementEnum> list = null;
        Connection conn = this.getConnection(this.ctx);
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(sql);
            int number = 1;
            stmt.setString(number++, bgTypeId.toString());
            rs = stmt.executeQuery();
            list = new ArrayList<BgElementEnum>();
            while (rs.next()) {
                list.add(BgElementEnum.getEnum(rs.getInt(1)));
            }
        }
        catch (SQLException ex) {
            try {
                ex.printStackTrace();
                throw new BgBizException(BgBizException.BGALYRPTFETCHDATA, new Object[]{"HistElementCollRowSet"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        SQLUtils.cleanup((Connection)conn);
        return list;
    }

    public int getPeriodSerial(BOSUuid id) throws BOSException, EASBizException {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block4: {
            int n;
            String sql = "SELECT FPeriodYear*100 + FPeriodNumber FROM T_BD_Period WHERE FID ='" + id.toString() + "'";
            conn = null;
            stmt = null;
            rs = null;
            try {
                conn = this.getConnection(this.ctx);
                stmt = conn.prepareStatement(sql);
                rs = stmt.executeQuery();
                if (!rs.next()) break block4;
                n = rs.getInt(1);
            }
            catch (SQLException exp) {
                try {
                    throw new EASBizException(BgBizException.GETDATA, (Throwable)exp, new Object[]{id});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, stmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
            return n;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        System.err.print("period" + id);
        return -1;
    }

    public List getPeriodIDList(int beginYear, int beginNumber, int endYear, int endNumber, String typeIDs) throws EASBizException, BOSException {
        String sql = " SELECT FID, FTypeID FROM T_BD_Period WHERE (FPeriodYear * 100 + FPeriodNumber BETWEEN ? AND ?) AND (FTypeID IN (" + typeIDs + "))";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<String> list = null;
        Connection conn = this.getConnection(this.ctx);
        try {
            stmt = conn.prepareStatement(sql);
            int number = 1;
            stmt.setInt(number++, beginYear * 100 + beginNumber);
            stmt.setInt(number++, endYear * 100 + endNumber);
            rs = stmt.executeQuery();
            list = new ArrayList<String>();
            while (rs.next()) {
                list.add(rs.getString(1));
            }
        }
        catch (SQLException ex) {
            try {
                ex.printStackTrace();
                throw new BgBizException(BgBizException.BGALYRPTFETCHDATA, ex, new Object[]{"getPeriodIDs"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        SQLUtils.cleanup((Connection)conn);
        return list;
    }

    public String getLongNumber(BOSUuid treeId, BOSUuid orgId) throws EASBizException, BOSException {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block4: {
            String string;
            String sql = "SELECT FLongNumber FROM T_ORG_Structure WHERE (FTreeID = ?) AND (FUnitID = ?)";
            conn = this.getConnection(this.ctx);
            stmt = null;
            rs = null;
            try {
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, BOSUuid.read((String)treeId.toString()).toString());
                stmt.setString(2, BOSUuid.read((String)orgId.toString()).toString());
                rs = stmt.executeQuery();
                if (!rs.next()) break block4;
                string = rs.getString(1);
            }
            catch (SQLException e) {
                try {
                    throw new EASBizException(BgBizException.GETDATA, (Throwable)e, new Object[]{orgId});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
            return string;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        throw new EASBizException(BgVerifyException.CHECKNOEXIST, new Object[]{orgId});
    }

    public PeriodInfo getPeriodInfo(java.util.Date date, BOSUuid companyId) throws BOSException, EASBizException {
        String sql = "SELECT P.FID, P.FTypeID, P.FPeriodYear, P.FPeriodQuarter, P.FPeriodNumber, P.FBeginDate, P.FEndDate FROM T_BD_Period P INNER JOIN  T_BD_PeriodType PT ON P.FTypeID = PT.FID INNER JOIN  T_ORG_Company C ON PT.FID = C.FAccountPeriodID WHERE   (? BETWEEN P.FBeginDate AND P.FEndDate)  AND (C.FID = ?)";
        Connection conn = null;
        PreparedStatement stmt = null;
        PeriodInfo info = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(this.ctx);
            stmt = conn.prepareStatement(sql);
            stmt.setDate(1, new Date(date.getTime()));
            stmt.setString(2, companyId.toString());
            rs = stmt.executeQuery();
            if (rs.next()) {
                info = new PeriodInfo();
                info.setId(BOSUuid.read((String)rs.getString("FID")));
                info.setPeriodNumber(rs.getInt("FPeriodNumber"));
                info.setPeriodYear(rs.getInt("FPeriodYear"));
                info.setPeriodQuarter(rs.getInt("FPeriodQuarter"));
                info.setPeriodType(new PeriodTypeInfo());
                info.getPeriodType().setId(BOSUuid.read((String)rs.getString("FTypeID")));
            }
        }
        catch (SQLException e) {
            try {
                throw new BgBizException(BgBizException.GETDATA, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return info;
    }
}

