/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg;

import com.kingdee.eas.ma.bg.AbstractBgEntryInfo;
import com.kingdee.eas.ma.bg.AbstractBgItemInfo;
import com.kingdee.eas.ma.bg.BgDataInfo;
import com.kingdee.eas.ma.bg.BgDimensionEnum;
import com.kingdee.eas.ma.bg.BgEntryCollection;
import com.kingdee.eas.ma.bg.BgHelper;
import com.kingdee.eas.ma.bg.BgItemInfo;
import com.kingdee.eas.ma.bg.BgPeriodNode;
import com.kingdee.eas.ma.bg.BgTemplateRowInfo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Iterator;

public class BgEntryInfo
extends AbstractBgEntryInfo
implements Serializable,
Comparable {
    public BgEntryInfo() {
        this("id");
    }

    protected BgEntryInfo(String pkField) {
        super(pkField);
    }

    public int compareTo(Object o) {
        BgEntryInfo bei = (BgEntryInfo)o;
        int result = 0;
        result = BgPeriodNode.comparePeriodAndBgCycle(this.getPeriod(), this.getInt("bgCycle"), bei.getPeriod(), bei.getInt("bgCycle"));
        if (result != 0) {
            return result;
        }
        for (int i = 0; i < BgTemplateRowInfo.MAXREFDIM; ++i) {
            String valueKey = "bgItem" + String.valueOf(i + 1);
            BgItemInfo srcBgItemInfo = (BgItemInfo)this.get(valueKey);
            BgItemInfo desBgItemInfo = (BgItemInfo)bei.get(valueKey);
            if (srcBgItemInfo == null || desBgItemInfo == null || (result = srcBgItemInfo.compareTo(desBgItemInfo)) != 0) break;
        }
        return result;
    }

    public static BgEntryInfo getSummedBgEntry(BgEntryCollection bgEntries) {
        BgEntryInfo bgEntryInfo = null;
        Iterator iter = bgEntries.iterator();
        while (iter.hasNext()) {
            BgEntryInfo tmpBgEntryInfo = (BgEntryInfo)iter.next();
            if (bgEntryInfo == null) {
                bgEntryInfo = tmpBgEntryInfo.cloneData();
                continue;
            }
            Iterator dataIter = tmpBgEntryInfo.getBgData().iterator();
            Iterator resultIter = bgEntryInfo.getBgData().iterator();
            while (dataIter.hasNext() && resultIter.hasNext()) {
                BgDataInfo bgDataInfo = (BgDataInfo)dataIter.next();
                BgDataInfo resultDataInfo = (BgDataInfo)resultIter.next();
                if (bgDataInfo.getBgValue() == null) {
                    bgDataInfo.setBgValue(new BigDecimal("0"));
                }
                if (bgDataInfo.getBgElement().isSummable() && resultDataInfo.getBgValue() != null) {
                    resultDataInfo.setBgValue(bgDataInfo.getBgValue().add(resultDataInfo.getBgValue()));
                    continue;
                }
                resultDataInfo.setBgValue(bgDataInfo.getBgValue());
            }
        }
        return bgEntryInfo;
    }

    public static BgEntryInfo getSummedBgEntry(BgEntryCollection bgEntries, String kindName) {
        BgEntryInfo bgEntryInfo = null;
        Iterator iter = bgEntries.iterator();
        while (iter.hasNext()) {
            BgEntryInfo tmpBgEntryInfo = (BgEntryInfo)iter.next();
            if (bgEntryInfo == null) {
                bgEntryInfo = tmpBgEntryInfo.cloneData();
                continue;
            }
            Iterator dataIter = tmpBgEntryInfo.getBgData().iterator();
            Iterator resultIter = bgEntryInfo.getBgData().iterator();
            while (dataIter.hasNext() && resultIter.hasNext()) {
                BgDataInfo bgDataInfo = (BgDataInfo)dataIter.next();
                BgDataInfo resultDataInfo = (BgDataInfo)resultIter.next();
                if (bgDataInfo.getBigDecimal(kindName) == null) {
                    bgDataInfo.setBigDecimal(kindName, new BigDecimal("0"));
                }
                if (bgDataInfo.getBgElement().isSummable() && resultDataInfo.getBgValue() != null) {
                    resultDataInfo.setBigDecimal(kindName, bgDataInfo.getBigDecimal(kindName).add(resultDataInfo.getBigDecimal(kindName)));
                    continue;
                }
                resultDataInfo.setBigDecimal(kindName, bgDataInfo.getBigDecimal(kindName));
            }
        }
        return bgEntryInfo;
    }

    @Override
    public String getBgItemsKey() {
        String key = super.getBgItemsKey();
        if (key != null) {
            return key;
        }
        key = BgHelper.getBgItemsKey(new Object[]{this.getBgItem1(), this.getBgItem2(), this.getBgItem3(), this.getBgItem4(), this.getBgItem5(), this.getBgItem6()});
        this.setBgItemsKey(key);
        return key;
    }

    public BgDataInfo getBgDataByElementNumber(String elementKey) {
        if (elementKey == null) {
            return null;
        }
        BgDataInfo result = null;
        Iterator iter = this.getBgData().iterator();
        while (iter.hasNext()) {
            BgDataInfo bgDataInfo = (BgDataInfo)iter.next();
            if (!bgDataInfo.getElementKey().startsWith(elementKey)) continue;
            result = bgDataInfo;
            break;
        }
        return result;
    }

    public BgPeriodNode getPeriodNode() {
        BgPeriodNode bgPeriodNode = new BgPeriodNode();
        bgPeriodNode.setPeriod(this.getPeriod());
        bgPeriodNode.setBgCycle(this.getBgCycle());
        bgPeriodNode.setLeaf(this.isIsLeafPeriod());
        return bgPeriodNode;
    }

    public boolean caculateIsLeafEntry() {
        String key;
        BgItemInfo tmpItem;
        boolean isLeaf = true;
        for (int i = 0; i < BgTemplateRowInfo.MAXREFDIM && (tmpItem = (BgItemInfo)this.get(key = "bgItem" + String.valueOf(i + 1))) != null; ++i) {
            if (tmpItem.isIsLeaf()) continue;
            isLeaf = false;
            break;
        }
        return isLeaf;
    }

    public BgItemInfo getBgItem(BgDimensionEnum bgDimEnum) {
        AbstractBgItemInfo bgItemInfo = null;
        for (int i = 0; i < BgTemplateRowInfo.MAXREFDIM; ++i) {
            String key = "bgItem" + String.valueOf(i + 1);
            BgItemInfo tmpItem = (BgItemInfo)this.get(key);
            if (bgItemInfo == null || bgItemInfo.getBgDimension().equals((Object)bgDimEnum)) break;
        }
        return bgItemInfo;
    }

    public BgEntryInfo deepClone() {
        BgEntryInfo bei = (BgEntryInfo)this.clone();
        bei.remove("id");
        bei.remove("bgForm");
        Iterator iter = bei.getBgData().iterator();
        while (iter.hasNext()) {
            BgDataInfo bdi = (BgDataInfo)iter.next();
            bdi.remove("id");
            bdi.remove("bgEntry");
        }
        return bei;
    }

    public BgEntryInfo deepClone_distr() {
        BgEntryInfo bei = (BgEntryInfo)this.clone();
        bei.remove("id");
        bei.remove("bgForm");
        Iterator iter = bei.getBgData().iterator();
        BigDecimal zero = new BigDecimal("0");
        while (iter.hasNext()) {
            BgDataInfo bdi = (BgDataInfo)iter.next();
            bdi.setBgActual(zero);
            bdi.setBgBalance(zero);
            bdi.setBgInitialValue(zero);
            bdi.setBgLastBalance(zero);
            bdi.setBgUsableValue(zero);
            bdi.setBgValue(zero);
            bdi.setBizActual(zero);
            bdi.remove("id");
            bdi.remove("bgEntry");
        }
        return bei;
    }

    public BgEntryInfo cloneData() {
        BgEntryInfo bei = new BgEntryInfo();
        bei.setBgItem1(this.getBgItem1());
        bei.setBgItem2(this.getBgItem2());
        bei.setBgItem3(this.getBgItem3());
        bei.setBgItem4(this.getBgItem4());
        bei.setBgItem5(this.getBgItem5());
        bei.setBgItem6(this.getBgItem6());
        bei.setPeriod(this.getPeriod());
        bei.setBgCycle(this.getBgCycle());
        bei.setIsLeafEntry(this.isIsLeafEntry());
        bei.setIsLeafPeriod(this.isIsLeafPeriod());
        Iterator iter = this.getBgData().iterator();
        while (iter.hasNext()) {
            BgDataInfo bdi = (BgDataInfo)iter.next();
            bei.getBgData().add(bdi.dataClone());
        }
        return bei;
    }

    public String getBgItemIds() {
        StringBuffer sb = new StringBuffer(128);
        for (int i = 1; i < 7; ++i) {
            BgItemInfo val = (BgItemInfo)this.getObjectValue("bgItem1");
            if (val == null) continue;
            sb.append(val.getId());
        }
        return sb.toString();
    }
}

