/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.ContextUtils;
import com.kingdee.eas.ma.bg.AbstractBgPastRecordInfo;
import com.kingdee.eas.ma.bg.BgDataCollection;
import com.kingdee.eas.ma.bg.BgDataInfo;
import com.kingdee.eas.ma.bg.BgEntryCollection;
import com.kingdee.eas.ma.bg.BgEntryInfo;
import com.kingdee.eas.ma.bg.BgFormInfo;
import com.kingdee.eas.ma.bg.BgPastDataCollection;
import com.kingdee.eas.ma.bg.BgPastDataInfo;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;

public class BgPastRecordInfo
extends AbstractBgPastRecordInfo
implements Serializable,
Comparable {
    public BgPastRecordInfo() {
    }

    protected BgPastRecordInfo(String pkField) {
        super(pkField);
    }

    public BgPastDataInfo getBgPastDataByBgData(BgDataInfo bdi) {
        BgPastDataInfo result = null;
        Iterator iter = this.getPastData().iterator();
        while (iter.hasNext()) {
            BgPastDataInfo bpdi = (BgPastDataInfo)iter.next();
            if (!bpdi.getBgData().getId().equals((Object)bdi.getId())) continue;
            result = bpdi;
            break;
        }
        return result;
    }

    public int compareTo(Object o) {
        BgPastRecordInfo obj = (BgPastRecordInfo)o;
        return this.getSeq() - obj.getSeq();
    }

    public static BgPastRecordInfo generatePastRecord(BgFormInfo newBgFormInfo, BgFormInfo oldBgFormInfo, Context ctx) {
        BgPastRecordInfo bgPastRecordInfo = new BgPastRecordInfo();
        BgPastDataCollection bgPastDataCollection = BgPastRecordInfo.compareBgFormInfo(newBgFormInfo, oldBgFormInfo);
        if (bgPastDataCollection.size() > 0) {
            bgPastRecordInfo.getPastData().addCollection(bgPastDataCollection);
            bgPastRecordInfo.setSeq(oldBgFormInfo.getPastRecords().size() + 1);
            bgPastRecordInfo.setModifier(ContextUtils.getUser((Context)ctx));
            bgPastRecordInfo.setModifyDate(new Date(System.currentTimeMillis()));
        }
        return bgPastRecordInfo;
    }

    public static BgPastDataCollection compareBgFormInfo(BgFormInfo newBgformInfo, BgFormInfo oldBgformInfo) {
        BgPastDataCollection bgPastDataCollection = new BgPastDataCollection();
        if (newBgformInfo == null || oldBgformInfo == null) {
            return bgPastDataCollection;
        }
        BgEntryCollection newBgEntryCollection = newBgformInfo.getBgEntries();
        BgEntryCollection oldBgEntryCollection = oldBgformInfo.getBgEntries();
        int size = oldBgEntryCollection.size();
        for (int i = 0; i < size; ++i) {
            BgEntryInfo newBgEntryInfo = newBgEntryCollection.get(i);
            BgEntryInfo oldBgEntryInfo = oldBgEntryCollection.get(i);
            bgPastDataCollection.addCollection(BgPastRecordInfo.compareBgEntryInfo(newBgEntryInfo, oldBgEntryInfo, newBgformInfo));
        }
        return bgPastDataCollection;
    }

    private static BgPastDataCollection compareBgEntryInfo(BgEntryInfo newBgEntryInfo, BgEntryInfo oldBgEntryInfo, BgFormInfo bgFromInfo) {
        BgPastDataCollection bgPastDataCollection = new BgPastDataCollection();
        if (newBgEntryInfo == null || oldBgEntryInfo == null) {
            return bgPastDataCollection;
        }
        if (!newBgEntryInfo.isIsLeafPeriod() || !newBgEntryInfo.isIsLeafEntry()) {
            return bgPastDataCollection;
        }
        if (!oldBgEntryInfo.isIsLeafPeriod() || !oldBgEntryInfo.isIsLeafEntry()) {
            return bgPastDataCollection;
        }
        BgDataCollection newBgDataCollection = newBgEntryInfo.getBgData();
        BgDataCollection oldBgDataCollection = oldBgEntryInfo.getBgData();
        int size = newBgDataCollection.size();
        for (int i = 0; i < size; ++i) {
            BgDataInfo oldBgDataInfo;
            BgDataInfo newBgDataInfo = newBgDataCollection.get(i);
            BgPastDataInfo bgPastDataInfo = BgPastRecordInfo.compareBgDataInfo(newBgDataInfo, oldBgDataInfo = oldBgDataCollection.get(i));
            if (bgPastDataInfo == null) continue;
            bgPastDataInfo.setDataSource(bgFromInfo.getDataSource());
            bgPastDataCollection.add(bgPastDataInfo);
        }
        return bgPastDataCollection;
    }

    private static BgPastDataInfo compareBgDataInfo(BgDataInfo newBgDataInfo, BgDataInfo oldBgDataInfo) {
        BgPastDataInfo bgPastDataInfo = null;
        if (newBgDataInfo == null || oldBgDataInfo == null) {
            return bgPastDataInfo;
        }
        if (newBgDataInfo.getBgValue() == null || oldBgDataInfo.getBgValue() == null) {
            return bgPastDataInfo;
        }
        if (newBgDataInfo.getBgValue().compareTo(oldBgDataInfo.getBgValue()) != 0) {
            bgPastDataInfo = new BgPastDataInfo();
            bgPastDataInfo.setBalance(newBgDataInfo.getBgValue().subtract(oldBgDataInfo.getBgValue()));
            bgPastDataInfo.setPastValue(oldBgDataInfo.getBgValue());
            bgPastDataInfo.setBgData(newBgDataInfo);
        }
        return bgPastDataInfo;
    }
}

