/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.SimpleTimer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.bg.BgDataInfo;
import com.kingdee.eas.ma.bg.BgEntryInfo;
import com.kingdee.eas.ma.bg.BgFormDAFactory;
import com.kingdee.eas.ma.bg.BgFormDataSourceEnum;
import com.kingdee.eas.ma.bg.BgFormFactory;
import com.kingdee.eas.ma.bg.BgFormInfo;
import com.kingdee.eas.ma.bg.BgFormStateEnum;
import com.kingdee.eas.ma.bg.BgInstantApproveException;
import com.kingdee.eas.ma.bg.BgItemFactory;
import com.kingdee.eas.ma.bg.BgItemInfo;
import com.kingdee.eas.ma.bg.BgPastDataCollection;
import com.kingdee.eas.ma.bg.BgPastDataInfo;
import com.kingdee.eas.ma.bg.BgPastRecordCollection;
import com.kingdee.eas.ma.bg.BgPastRecordInfo;
import com.kingdee.eas.ma.bg.BgVersionInfo;
import com.kingdee.eas.ma.bg.IBgForm;
import com.kingdee.eas.ma.bg.IBgFormDA;
import com.kingdee.eas.ma.bg.IBgItem;
import com.kingdee.eas.ma.bg.app.AbstractBgAdjustFormControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Iterator;

public class BgAdjustFormControllerBean
extends AbstractBgAdjustFormControllerBean {
    @Override
    protected IObjectPK _adjust(Context ctx, IObjectValue sourceBgFormInfo) throws BOSException, EASBizException {
        BgFormInfo srcBgFormInfo = (BgFormInfo)sourceBgFormInfo;
        if (this.checkAdjust(ctx, srcBgFormInfo.getId().toString())) {
            throw new BgInstantApproveException(BgInstantApproveException.HASADJUSTED1);
        }
        srcBgFormInfo.setDataSource(BgFormDataSourceEnum.CURRENTWORKOUT);
        String srcId = srcBgFormInfo.getId().toString();
        IObjectPK pk = this.addAdjustedForm1(ctx, srcBgFormInfo);
        IBgForm ibf = BgFormFactory.getLocalInstance(ctx);
        this.registerVersion(ctx, srcId, pk.toString());
        return pk;
    }

    private void registerVersion(Context ctx, String bgSourceFormId, String bgCloneFormId) throws SQLDataException, BgInstantApproveException {
        String insertSql = "insert into T_BG_BgVersion(FID,FOriginalBgFormId,FAdaptedBgFormId,FPreBgFormId) values(?,?,?,?)";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            String orginalFormId = this.findOrginalFormId(conn, bgSourceFormId);
            stmt = conn.prepareStatement(insertSql);
            stmt.setString(1, BOSUuid.create((BOSObjectType)new BgVersionInfo().getBOSType()).toString());
            stmt.setString(2, orginalFormId == null ? bgSourceFormId : orginalFormId);
            stmt.setString(3, bgCloneFormId);
            stmt.setString(4, bgSourceFormId);
            stmt.execute();
        }
        catch (SQLException e) {
            try {
                throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
    }

    private String findOrginalFormId(Connection conn, String bgSourceFormId) throws BgInstantApproveException {
        String result = null;
        String querySql = "select FOriginalBgFormId,FAdaptedBgFormId,FPreBgFormId from T_BG_BgVersion where FAdaptedBgFormId = ? ";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(querySql);
            stmt.setString(1, BOSUuid.read((String)bgSourceFormId).toString());
            rs = stmt.executeQuery();
            if (rs.next()) {
                result = rs.getString(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return result;
    }

    private IObjectPK addAdjustedForm(Context ctx, BgFormInfo srcBgFormInfo) throws BOSException, EASBizException {
        SimpleTimer st = new SimpleTimer();
        BgFormInfo cloneBgFormInfo = srcBgFormInfo.deepClone();
        cloneBgFormInfo.setState(BgFormStateEnum.Adjusted);
        IBgFormDA iBgFormDa = BgFormDAFactory.getLocalInstance(ctx);
        BgFormInfo oldBgFormInfo = iBgFormDa.getSingleForm((IObjectPK)new ObjectUuidPK(srcBgFormInfo.getId()));
        IBgForm iBgForm = BgFormFactory.getLocalInstance(ctx);
        int size = cloneBgFormInfo.getPastRecords().size();
        BgPastRecordCollection pastData = cloneBgFormInfo.getPastRecords();
        for (int i = 0; i < size; ++i) {
            BgPastRecordInfo info = pastData.get(i);
            if (info.getId() == null) continue;
            info.remove("id");
            info.setBgForm(cloneBgFormInfo);
            BgPastDataCollection bgPastDataCollection = info.getPastData();
            int dataSize = bgPastDataCollection.size();
            for (int j = 0; j < dataSize; ++j) {
                BgPastDataInfo bgData = bgPastDataCollection.get(j);
                bgData.remove("id");
                bgData.setBgPastRecord(info);
            }
        }
        IObjectPK pk = iBgForm.addnew((CoreBaseInfo)cloneBgFormInfo);
        return pk;
    }

    private IObjectPK addAdjustedForm1(Context ctx, BgFormInfo srcBgFormInfo) throws BOSException, EASBizException {
        SimpleTimer st = new SimpleTimer();
        srcBgFormInfo.setId(null);
        Iterator iter = srcBgFormInfo.getBgEntries().iterator();
        while (iter.hasNext()) {
            BgEntryInfo enInfo = (BgEntryInfo)iter.next();
            enInfo.setId(null);
            Iterator iter1 = enInfo.getBgData().iterator();
            while (iter1.hasNext()) {
                BgDataInfo daInfo = (BgDataInfo)iter1.next();
                daInfo.setId(null);
            }
        }
        Iterator iter2 = srcBgFormInfo.getPastRecords().iterator();
        while (iter2.hasNext()) {
            BgPastRecordInfo paInfo = (BgPastRecordInfo)iter2.next();
            paInfo.setId(null);
            Iterator iter3 = paInfo.getPastData().iterator();
            while (iter3.hasNext()) {
                BgPastDataInfo pdaInfo = (BgPastDataInfo)iter3.next();
                pdaInfo.setId(null);
            }
        }
        srcBgFormInfo.setState(BgFormStateEnum.Adjusted);
        IBgForm iBgForm = BgFormFactory.getLocalInstance(ctx);
        IObjectPK pk = iBgForm.addnew((CoreBaseInfo)srcBgFormInfo);
        return pk;
    }

    @Override
    protected boolean _checkAdjust(Context ctx, String bgFormId) throws BOSException, EASBizException {
        String querySql = "select count(*) from T_BG_BgVersion a,T_BG_BgForm b where a.FOriginalBgFormId=? and a.FAdaptedBgFormId = b.fid and b.FState=4 ";
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        int count = 0;
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(querySql);
            ps.setString(1, bgFormId);
            rs = ps.executeQuery();
            if (rs.next()) {
                count = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return count > 0;
    }

    @Override
    protected boolean _checkNumber(Context ctx, String tableName, String fid, String number) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer(40);
        sb.append("select count(*) from ");
        sb.append(tableName);
        sb.append("  where FNumber=?");
        if (fid != null) {
            sb.append(" and fid!=?");
        }
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        int count = 0;
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sb.toString());
            ps.setString(1, number);
            if (fid != null) {
                ps.setString(2, fid);
            }
            if ((rs = ps.executeQuery()).next()) {
                count = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return count > 0;
    }

    private String getBgEntryId(Context ctx, String periodId, String[] bgItemId, String bgFormId) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer(40);
        sb.append("select fid from t_bg_bgentry where fbgformid=?");
        sb.append(" and FIsLeafPeriod=1 ");
        sb.append(" and FPeriodID=?");
        for (int i = 0; i < bgItemId.length; ++i) {
            if (bgItemId[i] == null) continue;
            sb.append(" and FBgItem" + (i + 1) + "ID=?");
        }
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String result = "";
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sb.toString());
            ps.setString(1, bgFormId);
            ps.setString(2, periodId);
            int fieldCount = 2;
            for (int i = 0; i < bgItemId.length; ++i) {
                if (bgItemId[i] == null) continue;
                ps.setString(++fieldCount, bgItemId[i]);
            }
            rs = ps.executeQuery();
            if (rs.next()) {
                result = rs.getString(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return result;
    }

    @Override
    protected String _getBgDataId(Context ctx, String bgFormId, String[] bgItemId, String bgElementId, String currencyId, String periodIds) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer(100);
        sb.append("select b.fid fid from t_bg_bgentry a ,t_bg_bgdata b where a.fid=b.fbgentryid and a.fbgformid=?");
        sb.append(" and a.FIsLeafPeriod=1 ");
        sb.append(" and a.FPeriodID in ( ");
        sb.append(periodIds);
        sb.append(" ) ");
        for (int i = 0; i < bgItemId.length; ++i) {
            if (bgItemId[i] == null) continue;
            sb.append(" and a.FBgItem" + (i + 1) + "ID=?");
        }
        sb.append(" and b.FCurrencyID=?");
        sb.append(" and b.FBgElementID=?");
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String result = "";
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sb.toString());
            ps.setString(1, bgFormId);
            int fieldCount = 1;
            for (int i = 0; i < bgItemId.length; ++i) {
                if (bgItemId[i] == null) continue;
                ps.setString(++fieldCount, bgItemId[i]);
            }
            ps.setString(++fieldCount, currencyId);
            ps.setString(++fieldCount, bgElementId);
            rs = ps.executeQuery();
            if (rs.next()) {
                result = rs.getString(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewBgItem(Context ctx, BgItemInfo info) throws SQLDataException, SQLException {
        StringBuffer sb = new StringBuffer(40);
        sb.append("insert into t_bg_bgitem(FID,FIsLeaf,FLongNumber,FItemID,FItemNumber,FItemName_L1,FItemName_L2,FItemName_L3,FRefDimensionID,FBgDimension,FIsFromParent) ");
        sb.append(" values(?,?,?,?,?,?,?,?,?,?,?)");
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sb.toString());
            stmt.setString(1, info.getId().toString());
            stmt.setInt(2, info.isIsLeaf() ? 1 : 0);
            stmt.setString(3, info.getLongNumber());
            stmt.setString(4, info.getItemID().toString());
            stmt.setString(5, info.getItemNumber());
            stmt.setString(6, null);
            stmt.setString(7, info.getItemName());
            stmt.setString(8, null);
            stmt.setString(9, null);
            stmt.setInt(10, info.getBgDimension().getValue());
            stmt.setInt(11, 0);
            stmt.executeUpdate();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
        }
        SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
    }

    @Override
    protected IObjectPK _adjust(Context ctx, IObjectValue sourceBgFormInfo, Hashtable bgItems) throws BOSException, EASBizException {
        IBgItem ibi = BgItemFactory.getLocalInstance(ctx);
        for (BOSUuid id : bgItems.keySet()) {
            BgItemInfo info = (BgItemInfo)bgItems.get(id);
            try {
                this.addNewBgItem(ctx, info);
            }
            catch (SQLDataException e) {
                throw new BOSException((Throwable)e);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return this._adjust(ctx, sourceBgFormInfo);
    }
}

