/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.SimpleTimer;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgAuditStyleEnum;
import com.kingdee.eas.ma.bg.BgAuditUtils;
import com.kingdee.eas.ma.bg.BgBalanceAccess;
import com.kingdee.eas.ma.bg.BgBalanceWFEnum;
import com.kingdee.eas.ma.bg.BgBizException;
import com.kingdee.eas.ma.bg.BgCheckHelper;
import com.kingdee.eas.ma.bg.BgCtrlData;
import com.kingdee.eas.ma.bg.BgCtrlDetailEntryInfo;
import com.kingdee.eas.ma.bg.BgCtrlDetailInfo;
import com.kingdee.eas.ma.bg.BgCtrlHelper;
import com.kingdee.eas.ma.bg.BgCtrlParam;
import com.kingdee.eas.ma.bg.BgCtrlTypeEnum;
import com.kingdee.eas.ma.bg.BgCurrencyCtrlTypeEnum;
import com.kingdee.eas.ma.bg.BgDataCollection;
import com.kingdee.eas.ma.bg.BgDataFactory;
import com.kingdee.eas.ma.bg.BgDataInfo;
import com.kingdee.eas.ma.bg.BgDimensionEnum;
import com.kingdee.eas.ma.bg.BgElementEnum;
import com.kingdee.eas.ma.bg.BgFormInfo;
import com.kingdee.eas.ma.bg.BgHelper;
import com.kingdee.eas.ma.bg.BgIncreaseReqFormFactory;
import com.kingdee.eas.ma.bg.BgManagerFactory;
import com.kingdee.eas.ma.bg.BgProviderFactory;
import com.kingdee.eas.ma.bg.BgTemplateColumnCollection;
import com.kingdee.eas.ma.bg.BgTemplateInfo;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.BgVerifyException;
import com.kingdee.eas.ma.bg.IBgData;
import com.kingdee.eas.ma.bg.IBgIncreaseReqForm;
import com.kingdee.eas.ma.bg.IBgManager;
import com.kingdee.eas.ma.bg.IBgProvider;
import com.kingdee.eas.ma.bg.ReferencedCurrencyCollection;
import com.kingdee.eas.ma.bg.ReferencedCurrencyInfo;
import com.kingdee.eas.ma.bg.ReferencedDimensionCollection;
import com.kingdee.eas.ma.bg.app.AbstractBgControlControllerBean;
import com.kingdee.eas.ma.bg.app.dao.BgCtrlDAO;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import com.kingdee.util.enums.IntEnum;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgControlControllerBean
extends AbstractBgControlControllerBean {
    private static Logger logger = Logger.getLogger(BgControlControllerBean.class);

    private void checkBgData(Context ctx, BgCtrlParam bgCtrlParam, BgFormInfo bgFormInfo, Map cache) throws EASBizException, BOSException {
        IBgProvider bgProvider = BgProviderFactory.getLocalInstance(ctx);
        BgDataCollection bgDatas = bgProvider.getBgData(bgFormInfo, bgCtrlParam.getPeriodId(), bgCtrlParam.getDimensions(), bgCtrlParam.getCurrencyId());
        if (bgCtrlParam.getCtrlSystem().getValue() != 6 && bgDatas.size() == 0) {
            throw new BgBizException(BgBizException.BGITEMNOTEXIST);
        }
        BgCurrencyCtrlTypeEnum curCtrlType = BgCtrlHelper.getBgCurrencyCtrlType(ctx, bgFormInfo.getCompany().getId());
        for (int e = 0; e < bgDatas.size(); ++e) {
            BigDecimal bgBalance;
            BgDataInfo bgData = bgDatas.get(e);
            if (bgData.getBgCtrlType() == BgCtrlTypeEnum.NoCtrl) continue;
            BgElementEnum bizElement = bgData.getBgElement().getBizElement();
            BgCtrlData bizData = bgCtrlParam.getData(bizElement);
            BigDecimal bizValue = bizData.getValue();
            if (bizValue == null) {
                bizValue = new BigDecimal("0");
            }
            if ((bgBalance = (BigDecimal)cache.get(bgData.getId())) == null) {
                BgBalanceAccess ba = new BgBalanceAccess(ctx, bgFormInfo.getCompany().getId(), bgFormInfo.getId(), bgData.getBgEntry().getPeriod().getId());
                bgBalance = ba.getBgEnableValue(ctx, bgData, curCtrlType);
            }
            bizData.setBgDataId(bgData.getId());
            if (bgBalance == null) {
                bgBalance = new BigDecimal("0");
            }
            bizData.setBgBalance(bgBalance);
            if (bizValue.compareTo(bgBalance) > 0) {
                bizData.setOK(false);
                bizData.setFlxParam(bgData.getFlexibleBgCtrlParam());
                bgCtrlParam.setOK(false);
                continue;
            }
            bizData.setOK(true);
            cache.put(bgData.getId(), bgBalance.subtract(bizValue));
        }
    }

    private void updBgBalance(Context ctx, BgCtrlParam bgCtrlParam, BgFormInfo bgFormInfo, BgCtrlDetailInfo ctrlDetail, BgAuditStyleEnum style) throws EASBizException, BOSException {
        IBgProvider bgProvider = BgProviderFactory.getLocalInstance(ctx);
        BgDataCollection bgDatas = bgProvider.getBgData(bgFormInfo, bgCtrlParam.getPeriodId(), bgCtrlParam.getDimensions(), bgCtrlParam.getCurrencyId());
        for (int e = 0; e < bgDatas.size(); ++e) {
            BgDataInfo bgData = bgDatas.get(e);
            BgElementEnum bizElement = bgData.getBgElement().getBizElement();
            BgCtrlData bizData = bgCtrlParam.getData(bizElement);
            BigDecimal changeOrigin = null;
            changeOrigin = this.getBizValue(bizData.getValue(), style);
            ctrlDetail = this.recTraceDetail(ctrlDetail, bgData, changeOrigin);
            if (changeOrigin == null) continue;
            BgCtrlDAO.getInstance(ctx).updateBgBalanceData(bgData, changeOrigin);
        }
    }

    private BgCtrlDetailInfo recTraceDetail(BgCtrlDetailInfo ctrlDetail, BgDataInfo bgData, BigDecimal changeOrigin) {
        ctrlDetail.setBizData0(changeOrigin);
        ctrlDetail.setDataType(bgData.getDataType());
        BgCtrlDetailEntryInfo entry = new BgCtrlDetailEntryInfo();
        entry.setBgActualValue(changeOrigin);
        entry.setBgCurrency(bgData.getCurrency());
        entry.setBgData(bgData);
        ctrlDetail.getEntries().add(entry);
        entry.setSeq(ctrlDetail.getEntries().size());
        entry.setBill(ctrlDetail);
        return ctrlDetail;
    }

    protected boolean verifyParam(Context ctx, BgCtrlParam bgCtrlParam) throws EASBizException, BOSException {
        BgCheckHelper.checkBlank(bgCtrlParam, new Object[]{"param"});
        BgCheckHelper.checkBlank(bgCtrlParam.getCompanyId(), new Object[]{"companyId"});
        BgCheckHelper.checkBlank(bgCtrlParam.getPeriodId(), new Object[]{"periodId"});
        BgCheckHelper.checkBlank(bgCtrlParam.getBizDate(), new Object[]{"bizDate"});
        BgCheckHelper.checkBlank(bgCtrlParam.getBizOrgUnitId(), new Object[]{"bizOrgUnitId"});
        BgCheckHelper.checkBlank(bgCtrlParam.getCtrlSystem(), new Object[]{"ctrlSystem"});
        BgCheckHelper.checkBlank(bgCtrlParam.getBgTypeId(), new Object[]{"bgTypeId"});
        BgCheckHelper.checkBlank(bgCtrlParam.getSrcBillId(), new Object[]{"srcBillId"});
        BgCheckHelper.checkBlank(bgCtrlParam.getCurrencyId(), new Object[]{"currency"});
        BgCheckHelper.checkBlank(bgCtrlParam.getDimensions().size(), new Object[]{"dimensions"});
        BgCheckHelper.checkBlank(bgCtrlParam.getDatas().size(), new Object[]{"datas"});
        return true;
    }

    protected boolean verifyBizElement(BgCtrlParam bgCtrlParam, BgTemplateColumnCollection columns) throws EASBizException {
        for (int i = 0; i < columns.size(); ++i) {
            if (bgCtrlParam.getData(columns.get(i).getBgElement().getBizElement()) != null) continue;
            return false;
        }
        return true;
    }

    protected boolean verifyDimensions(BgCtrlParam bgCtrlParam, ReferencedDimensionCollection bgDims) throws EASBizException {
        for (int i = 0; i < bgDims.size(); ++i) {
            IObjectValue dim = bgCtrlParam.getDimension(bgDims.get(i).getBgDimension());
            if (dim == null) {
                return false;
            }
            dim.setInt("BgDimIndex", i);
        }
        return true;
    }

    protected boolean verifyCurrency(BgCtrlParam bgCtrlParam, ReferencedCurrencyCollection refCurColl) throws BgVerifyException {
        Iterator refCurrency = refCurColl.iterator();
        while (refCurrency.hasNext()) {
            ReferencedCurrencyInfo element = (ReferencedCurrencyInfo)refCurrency.next();
            if (!element.getCurrency().getId().equals((Object)bgCtrlParam.getCurrencyId())) continue;
            return true;
        }
        return false;
    }

    public boolean verifyBizData(BgCtrlParam param, BgTemplateInfo bgTemplateInfo) throws EASBizException, BgVerifyException, BOSException {
        if (!this.verifyDimensions(param, bgTemplateInfo.getRefDimensions())) {
            if (param.getCtrlSystem().getValue() == 6) {
                return false;
            }
            throw new BOSException("\u9884\u7b97\u8868\u7ef4\u5ea6\u4e0d\u5339\u914d,\u8bf7\u67e5\u770b\u9884\u7b97\u8868\u7ef4\u5ea6\u8bbe\u7f6e\uff01");
        }
        if (!this.verifyBizElement(param, bgTemplateInfo.getBgTpColumns())) {
            if (param.getCtrlSystem().getValue() == 6) {
                return false;
            }
            throw new BOSException("\u9884\u7b97\u8868\u9884\u7b97\u8981\u7d20\u4e0d\u6b63\u786e,\u8bf7\u67e5\u770b\u9884\u7b97\u8868\u9884\u7b97\u8981\u7d20\u8bbe\u7f6e\uff01");
        }
        if (!this.verifyCurrency(param, bgTemplateInfo.getRefCurrencies())) {
            if (param.getCtrlSystem().getValue() == 6) {
                return false;
            }
            throw new BOSException("\u9884\u7b97\u8868\u5e01\u522b\u4e0d\u6b63\u786e,\u8bf7\u67e5\u770b\u9884\u7b97\u8868\u5e01\u522b\u8bbe\u7f6e\uff01");
        }
        return true;
    }

    private BgCtrlDetailInfo buildTraceFormInfo(Context ctx, BgFormInfo bgFormInfo, BgCtrlParam param, BgAuditStyleEnum style) throws EASBizException {
        FullOrgUnitInfo bizOrgUnit = new FullOrgUnitInfo();
        bizOrgUnit.setId(param.getBizOrgUnitId());
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(param.getCompanyId());
        BgTypeInfo bgType = new BgTypeInfo();
        bgType.setId(param.getBgTypeId());
        PeriodInfo period = new PeriodInfo();
        period.setId(param.getPeriodId());
        CurrencyInfo currency = new CurrencyInfo();
        currency.setId(param.getCurrencyId());
        BgCtrlDetailInfo ctrlInfo = new BgCtrlDetailInfo();
        ctrlInfo.setBgForm(bgFormInfo);
        ctrlInfo.setCompany(company);
        ctrlInfo.setBizOrgUnit(bizOrgUnit);
        ctrlInfo.setPeriod(period);
        ctrlInfo.setCurrency(currency);
        ctrlInfo.setCtrlSystem(param.getCtrlSystem());
        ctrlInfo.setBgType(bgType);
        ctrlInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        ctrlInfo.setBizDate(param.getBizDate());
        ctrlInfo.setSrcBillID(param.getSrcBillId());
        ctrlInfo.setSrcBillNumber(param.getSrcBillNumber());
        ctrlInfo.setSrcBillTypeID(param.getSrcBillId().getType().toString());
        ctrlInfo.setBgAuditStyle(style);
        ctrlInfo.setCreator((UserInfo)ctx.get((Object)"UserInfo"));
        ctrlInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        ctrlInfo.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
        ctrlInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        this.parseDimsAndDatas(bgFormInfo, param, ctrlInfo);
        return ctrlInfo;
    }

    protected void parseDimsAndDatas(BgFormInfo bgFormInfo, BgCtrlParam bgCtrlParam, BgCtrlDetailInfo ctrlInfo) throws EASBizException {
        ReferencedDimensionCollection refDimensions = bgFormInfo.getBgTemplate().getRefDimensions();
        for (int i = 0; i < refDimensions.size(); ++i) {
            IObjectValue bizDimesion = bgCtrlParam.getDimension(refDimensions.get(i).getBgDimension());
            if (bizDimesion == null) continue;
            ctrlInfo.setBOSUuid("bgItem" + i + "ID", bizDimesion.getBOSUuid("id"));
        }
        BgTemplateColumnCollection bgTpColumns = bgFormInfo.getBgTemplate().getBgTpColumns();
        for (int i = 0; i < bgTpColumns.size(); ++i) {
            BgCtrlData bizData = bgCtrlParam.getData(bgTpColumns.get(i).getBgElement().getBizElement());
            BgCheckHelper.checkBlank(bizData, new Object[]{bgTpColumns.get(i).getBgElement().getBizElement()});
            BigDecimal bizValue = bizData.getValue();
            BgCheckHelper.checkBlank(bizValue, new Object[]{"bizData.value"});
            ctrlInfo.setBigDecimal("bizData" + i, this.getBizValue(bizValue, ctrlInfo.getBgAuditStyle()));
        }
    }

    protected BigDecimal getBizValue(BigDecimal bizValue, BgAuditStyleEnum style) throws EASBizException {
        if (style == BgAuditStyleEnum.BG_AUDIT || style == BgAuditStyleEnum.BG_CANCEL_CLOSE_BILL || style == BgAuditStyleEnum.BG_INC_AUDIT4BILL || style == BgAuditStyleEnum.BG_INC_REQ4BILL || style == BgAuditStyleEnum.BG_INC_AUDIT4DATA || style == BgAuditStyleEnum.BG_CANCEL_CLOSE_BILL || style == BgAuditStyleEnum.BG_SPECIAL) {
            return bizValue;
        }
        if (style == BgAuditStyleEnum.BG_CANCEL_AUDIT || style == BgAuditStyleEnum.BG_CLOSE_BILL || style == BgAuditStyleEnum.BG_CANCEL_INC_REQ4BILL || style == BgAuditStyleEnum.BG_CANCEL_INC_AUDIT4DATA || style == BgAuditStyleEnum.BG_CANCEL_SPECIAL || style == BgAuditStyleEnum.BG_CLOSE_BILL || style == BgAuditStyleEnum.BG_CANCEL_INC_AUDIT4BILL) {
            return bizValue.negate();
        }
        throw new EASBizException(BgVerifyException.CHECKNOEXIST, new Object[]{style});
    }

    @Override
    protected BgCtrlParam[] _bgAudit(Context ctx, BgCtrlParam[] params) throws BOSException, EASBizException {
        int i;
        SimpleTimer st = new SimpleTimer();
        if (BgHelper.isEmpty(params)) {
            return params;
        }
        this.verifyParam(ctx, params);
        IBgManager bgManage = BgManagerFactory.getLocalInstance(ctx);
        boolean isOK = true;
        HashMap<String, BgFormInfo> cache = new HashMap<String, BgFormInfo>();
        int count = 0;
        for (i = 0; i < params.length; ++i) {
            BOSUuid bgTypeId = params[i].getBgTypeId();
            String bgFormkey = params[i].getBizOrgUnitId().toString() + bgTypeId + params[i].getPeriodId();
            BgFormInfo bgFormInfo = (BgFormInfo)cache.get(bgFormkey);
            if (bgFormInfo == null) {
                bgFormInfo = bgManage.getExecutiveBgForm(params[i].getBizOrgUnitId(), bgTypeId, params[i].getPeriodId());
                cache.put(bgFormkey, bgFormInfo);
            }
            if (bgFormInfo == null) {
                ++count;
                continue;
            }
            if (!this.verifyBizData(params[i], bgFormInfo.getBgTemplate())) continue;
            params[i].setBOSUuid("bgFormOrgUnitId", bgFormInfo.getId());
            this.checkBgData(ctx, params[i], bgFormInfo, cache);
            if (params[i].isOK()) continue;
            isOK = false;
        }
        if (params.length > 0 && params[0].getCtrlSystem().getValue() == 6 && count == params.length) {
            for (i = 0; i < params.length; ++i) {
                params[i].setOK(true);
            }
            return params;
        }
        if (logger.isDebugEnabled()) {
            logger.info((Object)BgHelper.getBgAuditMsg(params));
        }
        if (!isOK) {
            return params;
        }
        return this.updBgBalance(ctx, params, BgAuditStyleEnum.BG_AUDIT);
    }

    public BgCtrlParam[] bgAudit2(Context ctx, BgCtrlParam[] params) throws BOSException, EASBizException {
        SimpleTimer st = new SimpleTimer();
        if (BgHelper.isEmpty(params)) {
            return params;
        }
        this.verifyParam(ctx, params);
        IBgManager bgManage = BgManagerFactory.getLocalInstance(ctx);
        boolean isOK = true;
        HashMap<String, BgFormInfo> cache = new HashMap<String, BgFormInfo>();
        for (int i = 0; i < params.length; ++i) {
            BOSUuid bgTypeId = params[i].getBgTypeId();
            String bgFormkey = params[i].getBizOrgUnitId().toString() + bgTypeId + params[i].getPeriodId();
            BgFormInfo bgFormInfo = (BgFormInfo)cache.get(bgFormkey);
            if (bgFormInfo == null) {
                bgFormInfo = bgManage.getExecutiveBgForm(params[i].getBizOrgUnitId(), bgTypeId, params[i].getPeriodId());
                cache.put(bgFormkey, bgFormInfo);
            }
            if (bgFormInfo == null || !this.verifyBizData(params[i], bgFormInfo.getBgTemplate())) continue;
            params[i].setBOSUuid("bgFormOrgUnitId", bgFormInfo.getId());
            this.checkBgData(ctx, params[i], bgFormInfo, cache);
            if (params[i].isOK()) continue;
            isOK = false;
        }
        if (logger.isDebugEnabled()) {
            logger.info((Object)BgHelper.getBgAuditMsg(params));
        }
        return params;
    }

    private BgCtrlParam[] updBgBalance(Context ctx, BgCtrlParam[] params, BgAuditStyleEnum style) throws BOSException, EASBizException, BgVerifyException {
        IBgManager bgManage = BgManagerFactory.getLocalInstance(ctx);
        HashMap<String, BgFormInfo> cache = new HashMap<String, BgFormInfo>();
        for (int i = 0; i < params.length; ++i) {
            BgCtrlParam bgCtrlParam = params[i];
            BOSUuid bgTypeId = bgCtrlParam.getBgTypeId();
            String bgFormkey = bgCtrlParam.getBizOrgUnitId().toString() + bgTypeId + bgCtrlParam.getPeriodId();
            BgFormInfo bgFormInfo = (BgFormInfo)cache.get(bgFormkey);
            if (bgFormInfo == null) {
                bgFormInfo = bgManage.getExecutiveBgForm(bgCtrlParam.getBizOrgUnitId(), bgTypeId, bgCtrlParam.getPeriodId());
                cache.put(bgFormkey, bgFormInfo);
            }
            if (bgFormInfo == null || !this.verifyBizData(params[i], bgFormInfo.getBgTemplate())) continue;
            boolean rs = this.verifyCurrency(bgCtrlParam, bgFormInfo.getBgTemplate().getRefCurrencies());
            if (!rs) break;
            BgCtrlDetailInfo ctrlInfo = null;
            ctrlInfo = this.buildTraceFormInfo(ctx, bgFormInfo, bgCtrlParam, style);
            this.updBgBalance(ctx, bgCtrlParam, bgFormInfo, ctrlInfo, style);
            BgCtrlDAO.getInstance(ctx).ctrlDetailInsert(ctrlInfo);
        }
        return params;
    }

    public void verifyParam(Context ctx, BgCtrlParam[] bgCtrlParamAry) throws EASBizException, BOSException, BgVerifyException {
        for (int i = 0; i < bgCtrlParamAry.length; ++i) {
            if (this.verifyParam(ctx, bgCtrlParamAry[i])) continue;
            throw new BgVerifyException(BgVerifyException.CHECKBGAUDIT, new Object[]{"param"});
        }
    }

    @Override
    protected BgCtrlParam[] _bgCancelAudit(Context ctx, BgCtrlParam[] params) throws BOSException, EASBizException {
        if (BgHelper.isEmpty(params)) {
            return params;
        }
        this.verifyParam(ctx, params);
        IBgIncreaseReqForm incCtrl = BgIncreaseReqFormFactory.getLocalInstance(ctx);
        Object[] incBills = this.getIncReqBill(ctx, params[0].getSrcBillId());
        if (!BgHelper.isEmpty(incBills)) {
            for (int i = 0; i < incBills.length; ++i) {
                Object incBill = incBills[i];
                incCtrl.cancel((IObjectPK)new ObjectUuidPK((BOSUuid)incBill));
            }
        }
        return this.updBgBalance(ctx, params, BgAuditStyleEnum.BG_CANCEL_AUDIT);
    }

    private BOSUuid[] getIncReqBill(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        BOSUuid[] bOSUuidArray;
        String sql = "SELECT  FID FROM T_BG_BgIncreaseReqForm WHERE (FSourceBillID = ?) and FCheckedStatus=2 and FHasEffected = 1";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, billId.toString());
            rs = stmt.executeQuery();
            ArrayList<BOSUuid> list = new ArrayList<BOSUuid>();
            while (rs.next()) {
                list.add(BOSUuid.read((String)rs.getString(1)));
            }
            bOSUuidArray = BgHelper.getIds(list);
        }
        catch (SQLException exp) {
            try {
                throw new BgBizException(BgBizException.GETDATA, new Object[]{billId});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return bOSUuidArray;
    }

    @Override
    protected void _bgSpecial(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        Object[] params = BgAuditUtils.getBgCtrlParaByUuid(ctx, billId);
        if (BgHelper.isEmpty(params)) {
            return;
        }
        this.verifyParam(ctx, (BgCtrlParam[])params);
        this.updBgBalance(ctx, (BgCtrlParam[])params, BgAuditStyleEnum.BG_SPECIAL);
    }

    @Override
    protected void _bgCancelSpecial(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        Object[] params = BgAuditUtils.getBgCtrlParaByUuid(ctx, billId);
        if (BgHelper.isEmpty(params)) {
            return;
        }
        this.verifyParam(ctx, (BgCtrlParam[])params);
        this.updBgBalance(ctx, (BgCtrlParam[])params, BgAuditStyleEnum.BG_CANCEL_SPECIAL);
    }

    @Override
    protected void _bgIncReq4Bill(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        Object[] params = BgAuditUtils.getBgCtrlParaByUuid(ctx, billId);
        if (BgHelper.isEmpty(params)) {
            return;
        }
        this.verifyParam(ctx, (BgCtrlParam[])params);
        this.updBgBalance(ctx, (BgCtrlParam[])params, BgAuditStyleEnum.BG_INC_REQ4BILL);
    }

    @Override
    protected void _bgIncAudit4Bill(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        Object[] params = BgAuditUtils.getBgCtrlParaByUuid(ctx, billId);
        if (BgHelper.isEmpty(params)) {
            return;
        }
        this.verifyParam(ctx, (BgCtrlParam[])params);
        BOSUuid bgTypeId = ((BgCtrlParam)params[0]).getBgTypeId();
        IBgManager bgManage = BgManagerFactory.getLocalInstance(ctx);
        String sql = "UPDATE T_BG_BgCtrlDetail  SET FBgAuditStyle = ? WHERE (FBgAuditStyle = ?) AND (FSrcBillID = ?)";
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            stmt.setInt(1, 55);
            stmt.setInt(2, 50);
            stmt.setString(3, ((BgCtrlParam)params[0]).getSrcBillId().toString());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BgBizException(BgBizException.UPDATEBGCTRL, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    @Override
    protected void _bgCancelIncAudit4Bill(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        Object[] params = BgAuditUtils.getBgCtrlParaByUuid(ctx, billId);
        if (BgHelper.isEmpty(params)) {
            return;
        }
        this.verifyParam(ctx, (BgCtrlParam[])params);
        this.updBgBalance(ctx, (BgCtrlParam[])params, BgAuditStyleEnum.BG_CANCEL_INC_AUDIT4BILL);
    }

    @Override
    protected void _bgCancelIncReq4Bill(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        Object[] params = BgAuditUtils.getBgCtrlParaByUuid(ctx, billId);
        if (BgHelper.isEmpty(params)) {
            return;
        }
        this.verifyParam(ctx, (BgCtrlParam[])params);
        this.updBgBalance(ctx, (BgCtrlParam[])params, BgAuditStyleEnum.BG_CANCEL_INC_AUDIT4BILL);
    }

    @Override
    protected BgCtrlParam[] _bgIncAduit4Data(Context ctx, BgCtrlParam[] params) throws BOSException, EASBizException {
        if (BgHelper.isEmpty(params)) {
            return params;
        }
        this.verifyParam(ctx, params);
        return this.updBgBalance(ctx, params, BgAuditStyleEnum.BG_INC_AUDIT4DATA);
    }

    @Override
    protected BgCtrlParam[] _bgCancelIncAudit4Data(Context ctx, BgCtrlParam[] params) throws BOSException, EASBizException {
        if (BgHelper.isEmpty(params)) {
            return params;
        }
        this.verifyParam(ctx, params);
        return this.updBgBalance(ctx, params, BgAuditStyleEnum.BG_CANCEL_INC_AUDIT4DATA);
    }

    @Override
    protected BgCtrlParam[] _bgCloseBill(Context ctx, BgCtrlParam[] params) throws BOSException, EASBizException {
        if (BgHelper.isEmpty(params)) {
            return params;
        }
        this.verifyParam(ctx, params);
        return this.updBgBalance(ctx, params, BgAuditStyleEnum.BG_CLOSE_BILL);
    }

    @Override
    protected BgCtrlParam[] _bgCancelCloseBill(Context ctx, BgCtrlParam[] params) throws BOSException, EASBizException {
        if (BgHelper.isEmpty(params)) {
            return params;
        }
        this.verifyParam(ctx, params);
        return this.updBgBalance(ctx, params, BgAuditStyleEnum.BG_CANCEL_CLOSE_BILL);
    }

    private BgCtrlParam[] getBgCtrlParam(Context ctx, BgCtrlParam[] bgCtrlParamAry) throws BOSException, EASBizException {
        SimpleTimer st = new SimpleTimer();
        Object[] params = bgCtrlParamAry;
        if (BgHelper.isEmpty(params)) {
            return params;
        }
        this.verifyParam(ctx, (BgCtrlParam[])params);
        IBgManager bgManage = BgManagerFactory.getLocalInstance(ctx);
        boolean isOK = true;
        HashMap<String, BgFormInfo> cache = new HashMap<String, BgFormInfo>();
        for (int i = 0; i < params.length; ++i) {
            BOSUuid bgTypeId = ((BgCtrlParam)params[i]).getBgTypeId();
            String bgFormkey = ((BgCtrlParam)params[i]).getBizOrgUnitId().toString() + bgTypeId + ((BgCtrlParam)params[i]).getPeriodId();
            BgFormInfo bgFormInfo = (BgFormInfo)cache.get(bgFormkey);
            if (bgFormInfo == null) {
                bgFormInfo = bgManage.getExecutiveBgForm(((BgCtrlParam)params[i]).getBizOrgUnitId(), bgTypeId, ((BgCtrlParam)params[i]).getPeriodId());
                cache.put(bgFormkey, bgFormInfo);
            }
            if (bgFormInfo == null || !this.verifyBizData((BgCtrlParam)params[i], bgFormInfo.getBgTemplate())) continue;
            params[i].setBOSUuid("bgFormOrgUnitId", bgFormInfo.getId());
            this.checkBgData(ctx, (BgCtrlParam)params[i], bgFormInfo, cache);
            if (((BgCtrlParam)params[i]).isOK()) continue;
            isOK = false;
        }
        return params;
    }

    @Override
    protected BgDataCollection _bgGetBgDataCollection(Context ctx, BgCtrlParam[] bgCtrlParamAry) throws BOSException, EASBizException {
        BgCtrlParam[] params = this.getBgCtrlParam(ctx, bgCtrlParamAry);
        BgDataCollection collection = new BgDataCollection();
        if (params != null && params.length > 0) {
            IBgData iBgData = BgDataFactory.getLocalInstance(ctx);
            for (int i = 0; i < params.length; ++i) {
                BgCtrlParam param = params[i];
                Object[] keyAry = param.getDatas().keySet().toArray();
                for (int j = 0; j < keyAry.length; ++j) {
                    BgElementEnum key = (BgElementEnum)((Object)keyAry[j]);
                    BgCtrlData bizData = param.getData(key);
                    BOSUuid bgDataId = bizData.getBgDataId();
                    if (bgDataId == null) continue;
                    BgDataInfo bgData = iBgData.getBgDataInfo((IObjectPK)new ObjectUuidPK(bgDataId));
                    collection.add(bgData);
                }
            }
        }
        return collection;
    }

    @Override
    protected String _getBgAuditMsg(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer(128);
        String strBgBalance = BgBalanceWFEnum.BgBalance.getAlias();
        String strBizValue = BgBalanceWFEnum.BizValue.getAlias();
        Object[] params = BgAuditUtils.getBgCtrlParaByUuid(ctx, billId);
        if (BgHelper.isEmpty(params)) {
            return "";
        }
        params = this.bgAudit2(ctx, (BgCtrlParam[])params);
        for (int i = 0; i < params.length; ++i) {
            if (((BgCtrlParam)params[i]).isOK()) continue;
            Object param = params[i];
            for (IntEnum key : ((BgCtrlParam)param).getDimensions().keySet()) {
                String number = ((BgCtrlParam)param).getDimension((BgDimensionEnum)key).getString("number");
                if (StringUtils.isEmpty((String)number)) continue;
                sb.append("\n");
                sb.append(key);
                sb.append(":");
                sb.append(((BgCtrlParam)param).getDimension((BgDimensionEnum)key).getString("number"));
            }
            for (IntEnum key : ((BgCtrlParam)param).getDatas().keySet()) {
                sb.append("\n" + key);
                sb.append("_");
                sb.append(strBgBalance);
                sb.append(":");
                BigDecimal bgBalance = ((BgCtrlParam)param).getData((BgElementEnum)key).getBgBalance();
                if (bgBalance == null) {
                    bgBalance = new BigDecimal("0");
                }
                sb.append(BgHelper.cutZero(bgBalance));
                sb.append("\n" + key);
                sb.append("_");
                sb.append(strBizValue);
                sb.append(":");
                BigDecimal bizValue = ((BgCtrlParam)param).getData((BgElementEnum)key).getValue();
                if (bizValue == null) {
                    bizValue = new BigDecimal("0");
                }
                sb.append(BgHelper.cutZero(bizValue));
            }
        }
        return sb.toString();
    }
}

