/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.SimpleTimer;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.IOrgView;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgViewFactory;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.AbstractBgPastRecordInfo;
import com.kingdee.eas.ma.bg.BgBizException;
import com.kingdee.eas.ma.bg.BgDaHelper;
import com.kingdee.eas.ma.bg.BgDataInfo;
import com.kingdee.eas.ma.bg.BgElementInfo;
import com.kingdee.eas.ma.bg.BgEntryCollection;
import com.kingdee.eas.ma.bg.BgEntryInfo;
import com.kingdee.eas.ma.bg.BgFormCollection;
import com.kingdee.eas.ma.bg.BgFormInfo;
import com.kingdee.eas.ma.bg.BgFormLogCollection;
import com.kingdee.eas.ma.bg.BgFormLogFactory;
import com.kingdee.eas.ma.bg.BgFormStateEnum;
import com.kingdee.eas.ma.bg.BgInstantApproveException;
import com.kingdee.eas.ma.bg.BgItemCollection;
import com.kingdee.eas.ma.bg.BgItemInfo;
import com.kingdee.eas.ma.bg.BgKDSFactory;
import com.kingdee.eas.ma.bg.BgKDSInfo;
import com.kingdee.eas.ma.bg.BgManagerFactory;
import com.kingdee.eas.ma.bg.BgPastDataInfo;
import com.kingdee.eas.ma.bg.BgPastRecordCollection;
import com.kingdee.eas.ma.bg.BgPastRecordInfo;
import com.kingdee.eas.ma.bg.BgPostilCollection;
import com.kingdee.eas.ma.bg.BgPostilFactory;
import com.kingdee.eas.ma.bg.BgRptTemplateInfo;
import com.kingdee.eas.ma.bg.BgSchemeFactory;
import com.kingdee.eas.ma.bg.BgSchemeHelper;
import com.kingdee.eas.ma.bg.BgSchemeInfo;
import com.kingdee.eas.ma.bg.BgTemplateDAFactory;
import com.kingdee.eas.ma.bg.BgTemplateException;
import com.kingdee.eas.ma.bg.BgTemplateInfo;
import com.kingdee.eas.ma.bg.BgTemplateRowInfo;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.IBgFormLog;
import com.kingdee.eas.ma.bg.IBgKDS;
import com.kingdee.eas.ma.bg.IBgManager;
import com.kingdee.eas.ma.bg.IBgPostil;
import com.kingdee.eas.ma.bg.IBgScheme;
import com.kingdee.eas.ma.bg.IBgTemplateDA;
import com.kingdee.eas.ma.bg.app.AbstractBgFormDAControllerBean;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgFormDAControllerBean
extends AbstractBgFormDAControllerBean {
    private static Logger logger = Logger.getLogger(BgFormDAControllerBean.class);
    private static final String BGENTRY_ID = "bgEntry_id";
    private static final String PERIOD_NUMBER = "period_number";
    private static final String PERIOD_QUARTER = "period_quarter";
    private static final String PERIOD_YEAR = "period_year";
    private static final String BGENTRY_PERIOD = "bgEntry_period";
    private static final String BGENTRY_BGCYCLE = "bgEntry_bgCycle";
    private static final String BGENTRY_ISLEAFENTRY = "bgEntry_isLeafEntry";
    private static final String BGENTRY_ISLEAFPERIOD = "bgEntry_isLeafPeriod";
    private static final String BGENTRY_ENTRYTYPE = "bgEntry_entryType";
    private static final String BGDATA_ID = "bgData_id";
    private static final String BGELEMENT_APPORTIONABLE = "bgElement_apportionable";
    private static final String BGELEMENT_SUMMABLE = "bgElement_summable";
    private static final String BGELEMENT_NUMBER = "bgElement_number";
    private static final String BGELEMENT_SEQ = "bgElement_seq";
    private static final String BGDATA_BGELEMENT = "bgData_bgElement";
    private static final String CURRENCY_NUMBER = "currency_number";
    private static final String BGDATA_CURRENCY = "bgData_Currency";
    private static final String BGDATA_FLEXIBLEBGCTRLPARAM = "bgData_flexibleBgCtrlParam";
    private static final String BGDATA_ISFLEXIBLECTRL = "bgData_isFlexibleCtrl";
    private static final String BGDATA_BGCTRLTYPE = "bgData_bgCtrlType";
    private static final String BGDATA_ELEMENTNUMBER = "bgData_elementNumber";
    private static final String BGDATA_DATATYPE = "bgData_dataType";
    private static final String BGDATA_BGBALANCE = "bgData_bgBalance";
    private static final String BGDATA_BIZACTUAL = "bgData_bizActual";
    private static final String BGDATA_BGVALUE = "bgData_bgValue";
    private static StringBuffer sqlFor_getSingForm = null;
    private static StringBuffer sqlFor_getSingleFormForDistribute = null;
    private static StringBuffer sqlFor_getBgEntryCollection = null;
    private static StringBuffer sqlFor_getBgEntryCollectionForDistribute = null;

    @Override
    protected IObjectValue _matchSingleForm(Context ctx, String bgTypeId, String orgUnitId, String bgSchemeId) throws BOSException, EASBizException {
        return this.innerMatchForm(ctx, bgTypeId, orgUnitId, bgSchemeId);
    }

    @Override
    protected IObjectValue _matchForm(Context ctx, String bgTypeId, String orgUnitId, String bgSchemeID) throws BOSException, EASBizException {
        BgFormInfo bfi = this.innerMatchForm(ctx, bgTypeId, orgUnitId, bgSchemeID);
        if (bfi != null) {
            this.detailTemplate(ctx, bfi);
        }
        return bfi;
    }

    @Override
    protected IObjectValue _matchFormWithOrgPath(Context ctx, String bgTypeId, String orgUnitId, String bgSchemeId, Vector orgUnitPath, boolean autoCreate) throws BOSException, EASBizException {
        BgFormInfo bfi = null;
        bfi = this.matchForm(ctx, bgTypeId, orgUnitId, bgSchemeId);
        if (bfi == null && autoCreate) {
            IBgTemplateDA iBgTpDa = BgTemplateDAFactory.getLocalInstance(ctx);
            BgTemplateInfo bgTemplateInfo = iBgTpDa.getCurrentBgTemplate(orgUnitPath, bgTypeId);
            if (bgTemplateInfo == null) {
                throw new BgTemplateException(BgTemplateException.NOCURRENTTEMPLATE);
            }
            FullOrgUnitInfo oui = new FullOrgUnitInfo();
            oui.setId(BOSUuid.read((String)orgUnitId));
            bfi = this.createNewBgForm(ctx, bgSchemeId, bgTemplateInfo.getId().toString(), oui);
        }
        return bfi;
    }

    @Override
    protected IObjectValue _matchFormWithTemplate(Context ctx, String bgTypeId, String orgUnitId, String bgSchemeId, String bgTemplateId, boolean autoCreate) throws BOSException, EASBizException {
        BgFormInfo bfi = null;
        bfi = this.matchForm(ctx, bgTypeId, orgUnitId, bgSchemeId);
        if (bfi == null && autoCreate) {
            IBgTemplateDA iBgTpDa = BgTemplateDAFactory.getLocalInstance(ctx);
            FullOrgUnitInfo oui = new FullOrgUnitInfo();
            oui.setId(BOSUuid.read((String)orgUnitId));
            bfi = this.createNewBgForm(ctx, bgSchemeId, bgTemplateId, oui);
        }
        return bfi;
    }

    @Override
    protected IObjectValue _getFormForEdit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SimpleTimer timer = new SimpleTimer();
        BgFormInfo bfi = (BgFormInfo)this._getSingleForm(ctx, pk);
        System.out.println("------------------------- getBgForm:" + timer.getTime());
        timer.reset();
        this.detailTemplate(ctx, bfi);
        System.out.println("------------------------- getBgTemplate:" + timer.getTime());
        timer.reset();
        bfi.getBgFormLog().addCollection(this.getBgFormLogCByBgFormId(ctx, pk));
        System.out.println("------------------------- getBgFormLog:" + timer.getTime());
        timer.reset();
        bfi.getBgPostil().addCollection(this.getBgPostilCByBgFormId(ctx, pk));
        System.out.println("------------------------- getBgPostil:" + timer.getTime());
        timer.reset();
        return bfi;
    }

    protected BgFormInfo getFormForEditForDistribute(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BgFormInfo bfi = (BgFormInfo)this.getSingleFormForDistribute(ctx, pk);
        this.detailTemplate(ctx, bfi);
        bfi.getBgFormLog().addCollection(this.getBgFormLogCByBgFormId(ctx, pk));
        bfi.getBgPostil().addCollection(this.getBgPostilCByBgFormId(ctx, pk));
        return bfi;
    }

    @Override
    protected IObjectCollection _getCollectionForDecDist(Context ctx, IObjectPK pk, IObjectCollection subOrgs, boolean autoCreated) throws BOSException, EASBizException {
        BgFormCollection bgFormCollection = new BgFormCollection();
        BgFormInfo upperFormInfo = this.getFormForEdit(ctx, pk);
        bgFormCollection.add(upperFormInfo);
        BgTypeInfo bgTypeInfo = upperFormInfo.getBgType();
        BgTemplateInfo bgTpInfo = upperFormInfo.getBgTemplate();
        BgSchemeInfo bgSchemeInfo = upperFormInfo.getBgScheme();
        IBgScheme iBgScheme = BgSchemeFactory.getLocalInstance(ctx);
        bgSchemeInfo = iBgScheme.getBgSchemeInfo((IObjectPK)new ObjectUuidPK(bgSchemeInfo.getId()), BgSchemeHelper.getPeriodSelectors());
        for (FullOrgUnitInfo orgInfo : subOrgs) {
            BgFormInfo tmpBgFormInfo = this.matchFormWithUpperTemplate(ctx, bgTypeInfo.getId().toString(), orgInfo, bgSchemeInfo, bgTpInfo, autoCreated);
            if (tmpBgFormInfo == null) continue;
            bgFormCollection.add(tmpBgFormInfo);
        }
        return bgFormCollection;
    }

    private BgFormInfo matchFormWithUpperTemplate(Context ctx, String bgTypeId, FullOrgUnitInfo orgUnitInfo, BgSchemeInfo bgSchemeInfo, BgTemplateInfo bgTpInfo, boolean autoCreated) throws EASBizException, BOSException {
        BgFormInfo bfi = this.matchForm(ctx, bgTypeId, orgUnitInfo.getId().toString(), bgSchemeInfo.getId().toString());
        if (bfi != null) {
            int state = bfi.getState().getValue();
            if (state == 1 || state == 4 || state == 9) {
                return bfi;
            }
            bfi = null;
        }
        if (bfi == null && autoCreated) {
            IBgTemplateDA iBgTpDA = BgTemplateDAFactory.getLocalInstance(ctx);
            BgTemplateInfo bti = iBgTpDA.getCurrentBgTemplate(orgUnitInfo.getId().toString(), bgTypeId);
            bti = bti == null ? bgTpInfo : iBgTpDA.getBgTemplate(bti.getId().toString());
            IBgManager ibm = BgManagerFactory.getLocalInstance(ctx);
            bfi = ibm.generateBgForm((IObjectValue)bti, (IObjectValue)bgSchemeInfo, orgUnitInfo);
        }
        return bfi;
    }

    private BgFormInfo matchFormWithUpperTemplateForDistribute(Context ctx, String bgTypeId, FullOrgUnitInfo orgUnitInfo, BgSchemeInfo bgSchemeInfo, BgTemplateInfo bgTpInfo, boolean autoCreated) throws EASBizException, BOSException {
        BgFormInfo bfi = this.matchFormForDistribute(ctx, bgTypeId, orgUnitInfo.getId().toString(), bgSchemeInfo.getId().toString());
        if (bfi == null && autoCreated) {
            IBgTemplateDA iBgTpDA = BgTemplateDAFactory.getLocalInstance(ctx);
            BgTemplateInfo bti = iBgTpDA.getCurrentBgTemplate(orgUnitInfo.getId().toString(), bgTypeId);
            bti = bti == null ? bgTpInfo : iBgTpDA.getBgTemplate(bti.getId().toString());
            BgSchemeInfo bsi = null;
            String schemeId = this.getMatchedBgScheme(ctx, bgSchemeInfo.getId().toString(), orgUnitInfo.getId().toString());
            if (schemeId == null) {
                bsi = bgSchemeInfo;
            } else {
                IBgScheme iBgScheme = BgSchemeFactory.getLocalInstance(ctx);
                bsi = iBgScheme.getBgSchemeInfo((IObjectPK)new ObjectUuidPK(schemeId));
            }
            bfi = this.createNewBgForm(ctx, bsi.getId().toString(), bti.getId().toString(), orgUnitInfo);
        }
        return bfi;
    }

    private BgFormInfo matchFormWithUpperTemplateForDistribute2(Context ctx, String bgTypeId, FullOrgUnitInfo orgUnitInfo, BgSchemeInfo bgSchemeInfo, BgTemplateInfo bgTpInfo, boolean autoCreated) throws EASBizException, BOSException {
        BgFormInfo bfi = this.matchFormForDistribute2(ctx, bgTypeId, orgUnitInfo.getId().toString(), bgSchemeInfo.getId().toString());
        if (bfi == null && autoCreated) {
            IBgTemplateDA iBgTpDA = BgTemplateDAFactory.getLocalInstance(ctx);
            BgTemplateInfo bti = iBgTpDA.getCurrentBgTemplate(orgUnitInfo.getId().toString(), bgTypeId);
            bti = bti == null ? bgTpInfo : iBgTpDA.getBgTemplate(bti.getId().toString());
            IBgScheme iBgScheme = BgSchemeFactory.getLocalInstance(ctx);
            bgSchemeInfo = iBgScheme.getBgSchemeInfo((IObjectPK)new ObjectUuidPK(bgSchemeInfo.getId()));
            BgSchemeInfo bsi = null;
            String schemeId = this.getMatchedBgScheme(ctx, bgSchemeInfo.getId().toString(), orgUnitInfo.getId().toString());
            bsi = schemeId == null ? bgSchemeInfo : iBgScheme.getBgSchemeInfo((IObjectPK)new ObjectUuidPK(schemeId));
            IBgManager ibm = BgManagerFactory.getLocalInstance(ctx);
            bfi = ibm.generateBgForm((IObjectValue)bti, (IObjectValue)bsi, orgUnitInfo);
        }
        return bfi;
    }

    private String getMatchedBgScheme(Context ctx, String bgSchemeId, String orgUnitId) throws BOSException, EASBizException {
        String schemeId = null;
        ResultSet rs = null;
        Connection connection = null;
        PreparedStatement ps = null;
        String sql = "select fid from t_bg_bgscheme where fbgschemeid=? and forgunitid=?";
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.setString(1, BOSUuid.read((String)bgSchemeId).toString());
            ps.setString(2, BOSUuid.read((String)orgUnitId).toString());
            rs = ps.executeQuery();
            if (rs.next()) {
                schemeId = rs.getString(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        return schemeId;
    }

    private BgFormInfo matchFormForDistribute(Context ctx, String bgTypeId, String orgUnitId, String bgSchemeID) throws BOSException, EASBizException {
        BgFormInfo bfi = this.innerMatchFormForDistribute(ctx, bgTypeId, orgUnitId, bgSchemeID);
        if (bfi != null) {
            this.detailTemplate(ctx, bfi);
        }
        return bfi;
    }

    private BgFormInfo matchFormForDistribute2(Context ctx, String bgTypeId, String orgUnitId, String bgSchemeID) throws BOSException, EASBizException {
        BgFormInfo bfi = this.innerMatchFormForDistribute2(ctx, bgTypeId, orgUnitId, bgSchemeID);
        if (bfi != null) {
            this.detailTemplate(ctx, bfi);
        }
        return bfi;
    }

    protected BgFormInfo innerMatchFormForDistribute(Context ctx, String bgTypeId, String orgUnitId, String bgSchemeID) throws BOSException, EASBizException {
        Connection conn = this.getConnection(ctx);
        PreparedStatement ps = null;
        ResultSet rs = null;
        BgFormInfo bgFormInfo = null;
        try {
            boolean blbgTypeId = bgTypeId != null;
            boolean blorgUnitId = orgUnitId != null;
            boolean blbgSchemeID = bgSchemeID != null;
            StringBuffer strBuffer = new StringBuffer(" SELECT FID , FSTATE = CASE FSTATE\tWHEN 4 THEN 1\tELSE 2\tEND\tFROM T_BG_BgForm where FSTATE in (1,2,3,4,6,7,8,9,10,11,13,14)");
            if (blbgTypeId) {
                strBuffer.append(" and fbgTypeId = ? ");
            }
            if (blorgUnitId) {
                strBuffer.append(" and forgUnitID = ? ");
            }
            if (blorgUnitId) {
                strBuffer.append(" and fBgschemeID = ? ");
            }
            strBuffer.append(" ORDER BY FSTATE");
            ps = conn.prepareStatement(strBuffer.toString());
            strBuffer = null;
            int index = 1;
            if (blbgTypeId) {
                ps.setString(index++, bgTypeId);
            }
            if (blbgTypeId) {
                ps.setString(index++, orgUnitId);
            }
            if (blbgTypeId) {
                ps.setString(index++, bgSchemeID);
            }
            rs = ps.executeQuery();
            String strId = null;
            if (rs.next()) {
                strId = rs.getString("FID");
            }
            if (strId != null) {
                bgFormInfo = (BgFormInfo)this.getSingleFormForDistribute(ctx, (IObjectPK)new ObjectUuidPK(strId));
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return bgFormInfo;
    }

    protected BgFormInfo innerMatchFormForDistribute2(Context ctx, String bgTypeId, String orgUnitId, String bgSchemeID) throws BOSException, EASBizException {
        Connection conn = this.getConnection(ctx);
        PreparedStatement ps = null;
        ResultSet rs = null;
        BgFormInfo bgFormInfo = null;
        try {
            boolean blbgTypeId = bgTypeId != null;
            boolean blorgUnitId = orgUnitId != null;
            boolean blbgSchemeID = bgSchemeID != null;
            StringBuffer strBuffer = new StringBuffer(" SELECT FID , FSTATE = CASE FSTATE\tWHEN 4 THEN 1\tELSE 2\tEND\tFROM T_BG_BgForm where FSTATE in (1,2,3,4,6,7,8,9,10,11,13,14)");
            if (blbgTypeId) {
                strBuffer.append(" and fbgTypeId = ? ");
            }
            if (blorgUnitId) {
                strBuffer.append(" and forgUnitID = ? ");
            }
            if (blorgUnitId) {
                strBuffer.append(" and fBgschemeID = ? ");
            }
            strBuffer.append(" ORDER BY FSTATE");
            ps = conn.prepareStatement(strBuffer.toString());
            strBuffer = null;
            int index = 1;
            if (blbgTypeId) {
                ps.setString(index++, bgTypeId);
            }
            if (blbgTypeId) {
                ps.setString(index++, orgUnitId);
            }
            if (blbgTypeId) {
                ps.setString(index++, bgSchemeID);
            }
            rs = ps.executeQuery();
            String strId = null;
            if (rs.next()) {
                strId = rs.getString("FID");
            }
            if (strId != null) {
                bgFormInfo = (BgFormInfo)this.getSingleFormForDistribute2(ctx, (IObjectPK)new ObjectUuidPK(strId));
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return bgFormInfo;
    }

    private BgFormInfo matchFormWithUpperTemplateForDeclare(Context ctx, String bgTypeId, String orgUnitId, String bgSchemeId, boolean autoCreated) throws EASBizException, BOSException {
        BgFormInfo bfi = this.matchFormForDeclare(ctx, bgTypeId, orgUnitId, bgSchemeId);
        return bfi;
    }

    private BgFormInfo matchFormForDeclare(Context ctx, String bgTypeId, String orgUnitId, String bgSchemeID) throws BOSException, EASBizException {
        BgFormInfo bfi = this.innerMatchFormForDeclare(ctx, bgTypeId, orgUnitId, bgSchemeID);
        if (bfi != null) {
            this.detailTemplate(ctx, bfi);
        }
        return bfi;
    }

    protected BgFormInfo innerMatchFormForDeclare(Context ctx, String bgTypeId, String orgUnitId, String bgSchemeID) throws BOSException, EASBizException {
        Connection conn = this.getConnection(ctx);
        PreparedStatement ps = null;
        ResultSet rs = null;
        BgFormInfo bgFormInfo = null;
        try {
            boolean blbgTypeId = bgTypeId != null;
            boolean blorgUnitId = orgUnitId != null;
            boolean blbgSchemeID = bgSchemeID != null;
            StringBuffer strBuffer = new StringBuffer(" SELECT FID , FSTATE = CASE FSTATE\tWHEN 4 THEN 1\tELSE 2\tEND\tFROM T_BG_BgForm where FSTATE in (1,2,3,4,6,7,8,9,10,11,13,14)");
            if (blbgTypeId) {
                strBuffer.append(" and fbgTypeId = ? ");
            }
            if (blorgUnitId) {
                strBuffer.append(" and forgUnitID = ? ");
            }
            if (blorgUnitId) {
                strBuffer.append(" and fBgschemeID = ? ");
            }
            strBuffer.append(" ORDER BY FSTATE");
            ps = conn.prepareStatement(strBuffer.toString());
            strBuffer = null;
            int index = 1;
            if (blbgTypeId) {
                ps.setString(index++, bgTypeId);
            }
            if (blbgTypeId) {
                ps.setString(index++, orgUnitId);
            }
            if (blbgTypeId) {
                ps.setString(index++, bgSchemeID);
            }
            rs = ps.executeQuery();
            String strId = null;
            if (rs.next()) {
                strId = rs.getString("FID");
            }
            if (strId != null) {
                bgFormInfo = (BgFormInfo)this.getSingleFormForDistribute(ctx, (IObjectPK)new ObjectUuidPK(strId));
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return bgFormInfo;
    }

    @Override
    protected IObjectValue _getSingleForm(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BgFormInfo bgFormInfo;
        ResultSet resultSet;
        PreparedStatement stmt;
        Connection conn;
        block7: {
            if (sqlFor_getSingForm == null) {
                StringBuffer sb = new StringBuffer(5000);
                sb.append("SELECT T_BG_BgForm.FID, T_BG_BgForm.FNumber, T_BG_BgForm.FName,");
                sb.append("T_BG_BgForm.FCreatorID, T_BG_BgForm.FCreateTime, ");
                sb.append("T_BG_BgForm.FBgTemplateID, T_BG_BgForm.FBgTypeID, ");
                sb.append("T_BG_BgForm.FPeriodFromID, T_BG_BgForm.FPeriodToID, ");
                sb.append("T_BG_BgForm.FOrgUnitID, T_BG_BgForm.FBgRptTemplateID, ");
                sb.append("T_BG_BgForm.FDataSource,");
                sb.append("T_BG_BgForm.FSTATE,");
                sb.append("T_BG_BgForm.FLastUpdateUserID,");
                sb.append("T_BG_BgForm.FLastUpdateTime,");
                sb.append("T_BG_BgForm.FCompanyID,");
                sb.append("T_BG_BgForm.FBgSchemeID, T_BG_BgScheme.FNumber AS bgScheme_number,");
                sb.append("T_BG_BgScheme.FName AS bgScheme_name, ");
                sb.append("T_BG_BgScheme.FIsFormal AS bgScheme_isFormal, ");
                sb.append("T_BD_Period_From.FPeriodYear periodFrom_year, T_BD_Period_From.FPeriodQuarter periodFrom_quarter,T_BD_Period_From.FPeriodNumber periodFrom_number,");
                sb.append("T_BD_Period_From.FID AS periodFrom_id,T_BD_Period_From.FBeginDate periodFrom_beginDate,T_BD_Period_From.FEndDate periodFrom_endDate,");
                sb.append("T_BD_Period_To.FPeriodYear periodTo_year, T_BD_Period_To.FPeriodQuarter periodTo_quarter,T_BD_Period_To.FPeriodNumber periodTo_number,");
                sb.append("T_BD_Period_To.FID AS periodTo_id,T_BD_Period_To.FBeginDate periodTo_beginDate,T_BD_Period_To.FEndDate periodTo_endDate,");
                sb.append("LastUpdateUser.FNumber AS lastUpdateUser_number,");
                sb.append("LastUpdateUser.FName_@L@ AS lastUpdateUser_name,");
                sb.append("T_PM_User.FNumber AS creator_number,");
                sb.append("T_PM_User.FName_@L@ AS creator_name,");
                sb.append("T_PM_User.FID AS creator_id,");
                sb.append("T_ORG_BaseUnit.FID AS orgUnit_id,");
                sb.append("T_ORG_BaseUnit.FNumber AS orgUnit_number,");
                sb.append("T_ORG_BaseUnit.FName_@L@ AS orgUnit_name,");
                sb.append("T_BG_BgType.FID AS bgType_id,");
                sb.append("T_BG_BgType.FNumber AS bgType_number,");
                sb.append("T_BG_BgType.FName_@L@ AS bgType_name, ");
                sb.append("T_BG_BgType.FIsRptBgForm AS bgType_isRptBgForm ");
                sb.append(" FROM T_BG_BgForm ");
                sb.append(" INNER JOIN T_BG_BgScheme ON T_BG_BgForm.FBgSchemeID = T_BG_BgScheme.FID");
                sb.append(" LEFT OUTER JOIN T_PM_User ON T_BG_BgForm.FCreatorID = T_PM_User.FID");
                sb.append(" LEFT OUTER JOIN T_PM_User AS LastUpdateUser ON T_BG_BgForm.FLastUpdateUserID = LastUpdateUser.FID");
                sb.append(" INNER JOIN T_ORG_BaseUnit ON T_BG_BgForm.FOrgUnitID = T_ORG_BaseUnit.FID");
                sb.append(" INNER JOIN T_BD_Period T_BD_Period_From ON T_BG_BgForm.FPeriodFromID = T_BD_Period_From.FID ");
                sb.append(" INNER JOIN T_BD_Period T_BD_Period_To ON T_BG_BgForm.FPeriodToID = T_BD_Period_To.FID ");
                sb.append(" INNER JOIN T_BG_BgType ON T_BG_BgForm.FBgTypeID = T_BG_BgType.FID");
                sb.append(" WHERE T_BG_BgForm.FID = ?");
                sqlFor_getSingForm = sb;
            }
            conn = this.getConnection(ctx);
            stmt = null;
            resultSet = null;
            bgFormInfo = null;
            HashMap cache = new HashMap();
            try {
                BgPastRecordCollection bprc;
                stmt = conn.prepareStatement(BgDaHelper.convert(ctx, sqlFor_getSingForm.toString()));
                stmt.setString(1, pk.toString());
                resultSet = stmt.executeQuery();
                if (!resultSet.next()) break block7;
                bgFormInfo = this.generatePlainBgForm(resultSet);
                BgEntryCollection bec = this.getBgEntryCollection(ctx, conn, pk, cache);
                if (bec != null) {
                    bgFormInfo.getBgEntries().addCollection(bec);
                }
                if ((bprc = this.getPastRecordCollection(ctx, conn, pk, cache)) != null) {
                    bgFormInfo.getPastRecords().addCollection(bprc);
                }
            }
            catch (SQLException e) {
                try {
                    System.out.println("get bg bgform!");
                    e.printStackTrace();
                    throw new EASBizException(BgBizException.GETDATA, (Throwable)e, new Object[]{"BgForm"});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(resultSet, stmt, (Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)resultSet, (Statement)stmt, (Connection)conn);
        return bgFormInfo;
    }

    private BgEntryCollection getBgEntryCollectionByBgKDS(Context ctx, Connection conn, IObjectPK pk, Map cache) throws EASBizException, BOSException {
        BgEntryCollection coll = new BgEntryCollection();
        try {
            IBgKDS iBgKDS = BgKDSFactory.getLocalInstance(ctx);
            BOSUuid kdsId = iBgKDS.getBgKDSByBgForm(BOSUuid.read((String)pk.toString()));
            BgKDSInfo kdsInfo = iBgKDS.getBgKDSInfo((IObjectPK)new ObjectUuidPK(kdsId));
            byte[] byteArray = kdsInfo.getBgEntryArray();
            if (byteArray == null || byteArray.length == 0) {
                throw new Exception("\u8bfb\u53d6\u5927\u5bf9\u8c61\u51fa\u9519");
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(byteArray);
            ObjectInputStream ois = new ObjectInputStream(bais);
            ArrayList entryColl = (ArrayList)ois.readObject();
            ois.close();
            bais.close();
            int n = entryColl.size();
            for (int i = 0; i < n; ++i) {
                BgEntryInfo bgEntry = (BgEntryInfo)entryColl.get(i);
                coll.add(bgEntry);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            coll = this.getBgEntryCollection(ctx, conn, pk, cache);
        }
        return coll;
    }

    protected IObjectValue getSingleFormForDistribute(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BgFormInfo bgFormInfo;
        ResultSet resultSet;
        PreparedStatement stmt;
        Connection conn;
        block7: {
            if (sqlFor_getSingleFormForDistribute == null) {
                StringBuffer sb = new StringBuffer(5000);
                sb.append("SELECT T_BG_BgForm.FID, T_BG_BgForm.FNumber, T_BG_BgForm.FName,");
                sb.append("T_BG_BgForm.FCreatorID, T_BG_BgForm.FCreateTime, ");
                sb.append("T_BG_BgForm.FBgTemplateID, T_BG_BgForm.FBgTypeID, ");
                sb.append("T_BG_BgForm.FPeriodFromID, T_BG_BgForm.FPeriodToID, ");
                sb.append("T_BG_BgForm.FOrgUnitID, T_BG_BgForm.FBgRptTemplateID, ");
                sb.append("T_BG_BgForm.FDataSource,");
                sb.append("T_BG_BgForm.FSTATE,");
                sb.append("T_BG_BgForm.FLastUpdateUserID,");
                sb.append("T_BG_BgForm.FLastUpdateTime,");
                sb.append("T_BG_BgForm.FCompanyID,");
                sb.append("T_BG_BgForm.FBgSchemeID, T_BG_BgScheme.FNumber AS bgScheme_number,");
                sb.append("T_BG_BgScheme.FName AS bgScheme_name, ");
                sb.append("T_BG_BgScheme.FIsFormal AS bgScheme_isFormal, ");
                sb.append("T_BD_Period_From.FPeriodYear periodFrom_year, T_BD_Period_From.FPeriodQuarter periodFrom_quarter,T_BD_Period_From.FPeriodNumber periodFrom_number,");
                sb.append("T_BD_Period_From.FID AS periodFrom_id,T_BD_Period_From.FBeginDate periodFrom_beginDate,T_BD_Period_From.FEndDate periodFrom_endDate,");
                sb.append("T_BD_Period_To.FPeriodYear periodTo_year, T_BD_Period_To.FPeriodQuarter periodTo_quarter,T_BD_Period_To.FPeriodNumber periodTo_number,");
                sb.append("T_BD_Period_To.FID AS periodTo_id,T_BD_Period_To.FBeginDate periodTo_beginDate,T_BD_Period_To.FEndDate periodTo_endDate,");
                sb.append("LastUpdateUser.FNumber AS lastUpdateUser_number,");
                sb.append("LastUpdateUser.FName_@L@ AS lastUpdateUser_name,");
                sb.append("T_PM_User.FNumber AS creator_number,");
                sb.append("T_PM_User.FName_@L@ AS creator_name,");
                sb.append("T_PM_User.FID AS creator_id,");
                sb.append("T_ORG_BaseUnit.FID AS orgUnit_id,");
                sb.append("T_ORG_BaseUnit.FNumber AS orgUnit_number,");
                sb.append("T_ORG_BaseUnit.FName_@L@ AS orgUnit_name,");
                sb.append("T_BG_BgType.FID AS bgType_id,");
                sb.append("T_BG_BgType.FNumber AS bgType_number,");
                sb.append("T_BG_BgType.FName_@L@ AS bgType_name, ");
                sb.append("T_BG_BgType.FIsRptBgForm AS bgType_isRptBgForm ");
                sb.append(" FROM T_BG_BgForm ");
                sb.append(" INNER JOIN T_BG_BgScheme ON T_BG_BgForm.FBgSchemeID = T_BG_BgScheme.FID");
                sb.append(" LEFT OUTER JOIN T_PM_User ON T_BG_BgForm.FCreatorID = T_PM_User.FID");
                sb.append(" LEFT OUTER JOIN T_PM_User AS LastUpdateUser ON T_BG_BgForm.FLastUpdateUserID = LastUpdateUser.FID");
                sb.append(" INNER JOIN T_ORG_BaseUnit ON T_BG_BgForm.FOrgUnitID = T_ORG_BaseUnit.FID");
                sb.append(" INNER JOIN T_BD_Period T_BD_Period_From ON T_BG_BgForm.FPeriodFromID = T_BD_Period_From.FID ");
                sb.append(" INNER JOIN T_BD_Period T_BD_Period_To ON T_BG_BgForm.FPeriodToID = T_BD_Period_To.FID ");
                sb.append(" INNER JOIN T_BG_BgType ON T_BG_BgForm.FBgTypeID = T_BG_BgType.FID");
                sb.append(" WHERE T_BG_BgForm.FID = ?");
                sqlFor_getSingleFormForDistribute = sb;
            }
            conn = this.getConnection(ctx);
            stmt = null;
            resultSet = null;
            bgFormInfo = null;
            HashMap cache = new HashMap();
            try {
                BgPastRecordCollection bprc;
                stmt = conn.prepareStatement(BgDaHelper.convert(ctx, sqlFor_getSingleFormForDistribute.toString()));
                stmt.setString(1, pk.toString());
                resultSet = stmt.executeQuery();
                if (!resultSet.next()) break block7;
                bgFormInfo = this.generatePlainBgForm(resultSet);
                BgEntryCollection bec = this.getBgEntryCollectionByBgKDS(ctx, conn, pk, cache);
                if (bec != null) {
                    bgFormInfo.getBgEntries().addCollection(bec);
                }
                if ((bprc = this.getPastRecordCollection(ctx, conn, pk, cache)) != null) {
                    bgFormInfo.getPastRecords().addCollection(bprc);
                }
            }
            catch (SQLException e) {
                try {
                    System.out.println("get bg bgform!");
                    e.printStackTrace();
                    throw new EASBizException(BgBizException.GETDATA, (Throwable)e, new Object[]{"BgForm"});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(resultSet, stmt, (Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)resultSet, (Statement)stmt, (Connection)conn);
        return bgFormInfo;
    }

    protected IObjectValue getSingleFormForDistribute2(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BgFormInfo bgFormInfo;
        ResultSet resultSet;
        PreparedStatement stmt;
        Connection conn;
        block7: {
            if (sqlFor_getSingleFormForDistribute == null) {
                StringBuffer sb = new StringBuffer(5000);
                sb.append("SELECT T_BG_BgForm.FID, T_BG_BgForm.FNumber, T_BG_BgForm.FName,");
                sb.append("T_BG_BgForm.FCreatorID, T_BG_BgForm.FCreateTime, ");
                sb.append("T_BG_BgForm.FBgTemplateID, T_BG_BgForm.FBgTypeID, ");
                sb.append("T_BG_BgForm.FPeriodFromID, T_BG_BgForm.FPeriodToID, ");
                sb.append("T_BG_BgForm.FOrgUnitID, T_BG_BgForm.FBgRptTemplateID, ");
                sb.append("T_BG_BgForm.FDataSource,");
                sb.append("T_BG_BgForm.FSTATE,");
                sb.append("T_BG_BgForm.FLastUpdateUserID,");
                sb.append("T_BG_BgForm.FLastUpdateTime,");
                sb.append("T_BG_BgForm.FCompanyID,");
                sb.append("T_BG_BgForm.FBgSchemeID, T_BG_BgScheme.FNumber AS bgScheme_number,");
                sb.append("T_BG_BgScheme.FName AS bgScheme_name, ");
                sb.append("T_BG_BgScheme.FIsFormal AS bgScheme_isFormal, ");
                sb.append("T_BD_Period_From.FPeriodYear periodFrom_year, T_BD_Period_From.FPeriodQuarter periodFrom_quarter,T_BD_Period_From.FPeriodNumber periodFrom_number,");
                sb.append("T_BD_Period_From.FID AS periodFrom_id,T_BD_Period_From.FBeginDate periodFrom_beginDate,T_BD_Period_From.FEndDate periodFrom_endDate,");
                sb.append("T_BD_Period_To.FPeriodYear periodTo_year, T_BD_Period_To.FPeriodQuarter periodTo_quarter,T_BD_Period_To.FPeriodNumber periodTo_number,");
                sb.append("T_BD_Period_To.FID AS periodTo_id,T_BD_Period_To.FBeginDate periodTo_beginDate,T_BD_Period_To.FEndDate periodTo_endDate,");
                sb.append("LastUpdateUser.FNumber AS lastUpdateUser_number,");
                sb.append("LastUpdateUser.FName_@L@ AS lastUpdateUser_name,");
                sb.append("T_PM_User.FNumber AS creator_number,");
                sb.append("T_PM_User.FName_@L@ AS creator_name,");
                sb.append("T_PM_User.FID AS creator_id,");
                sb.append("T_ORG_BaseUnit.FID AS orgUnit_id,");
                sb.append("T_ORG_BaseUnit.FNumber AS orgUnit_number,");
                sb.append("T_ORG_BaseUnit.FName_@L@ AS orgUnit_name,");
                sb.append("T_BG_BgType.FID AS bgType_id,");
                sb.append("T_BG_BgType.FNumber AS bgType_number,");
                sb.append("T_BG_BgType.FName_@L@ AS bgType_name, ");
                sb.append("T_BG_BgType.FIsRptBgForm AS bgType_isRptBgForm ");
                sb.append(" FROM T_BG_BgForm ");
                sb.append(" INNER JOIN T_BG_BgScheme ON T_BG_BgForm.FBgSchemeID = T_BG_BgScheme.FID");
                sb.append(" LEFT OUTER JOIN T_PM_User ON T_BG_BgForm.FCreatorID = T_PM_User.FID");
                sb.append(" LEFT OUTER JOIN T_PM_User AS LastUpdateUser ON T_BG_BgForm.FLastUpdateUserID = LastUpdateUser.FID");
                sb.append(" INNER JOIN T_ORG_BaseUnit ON T_BG_BgForm.FOrgUnitID = T_ORG_BaseUnit.FID");
                sb.append(" INNER JOIN T_BD_Period T_BD_Period_From ON T_BG_BgForm.FPeriodFromID = T_BD_Period_From.FID ");
                sb.append(" INNER JOIN T_BD_Period T_BD_Period_To ON T_BG_BgForm.FPeriodToID = T_BD_Period_To.FID ");
                sb.append(" INNER JOIN T_BG_BgType ON T_BG_BgForm.FBgTypeID = T_BG_BgType.FID");
                sb.append(" WHERE T_BG_BgForm.FID = ?");
                sqlFor_getSingleFormForDistribute = sb;
            }
            conn = this.getConnection(ctx);
            stmt = null;
            resultSet = null;
            bgFormInfo = null;
            HashMap cache = new HashMap();
            try {
                BgPastRecordCollection bprc;
                stmt = conn.prepareStatement(BgDaHelper.convert(ctx, sqlFor_getSingleFormForDistribute.toString()));
                stmt.setString(1, pk.toString());
                resultSet = stmt.executeQuery();
                if (!resultSet.next()) break block7;
                bgFormInfo = this.generatePlainBgForm(resultSet);
                BgEntryCollection bec = new BgEntryCollection();
                if (bec != null) {
                    bgFormInfo.getBgEntries().addCollection(bec);
                }
                if ((bprc = this.getPastRecordCollection(ctx, conn, pk, cache)) != null) {
                    bgFormInfo.getPastRecords().addCollection(bprc);
                }
            }
            catch (SQLException e) {
                try {
                    System.out.println("get bg bgform!");
                    e.printStackTrace();
                    throw new EASBizException(BgBizException.GETDATA, (Throwable)e, new Object[]{"BgForm"});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(resultSet, stmt, (Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)resultSet, (Statement)stmt, (Connection)conn);
        return bgFormInfo;
    }

    protected BgFormInfo innerMatchForm(Context ctx, String bgTypeId, String orgUnitId, String bgSchemeID) throws BOSException, EASBizException {
        Connection conn = this.getConnection(ctx);
        PreparedStatement ps = null;
        ResultSet rs = null;
        BgFormInfo bgFormInfo = null;
        try {
            boolean blbgTypeId = bgTypeId != null;
            boolean blorgUnitId = orgUnitId != null;
            boolean blbgSchemeID = bgSchemeID != null;
            StringBuffer strBuffer = new StringBuffer(" SELECT FID , FSTATE = CASE FSTATE\tWHEN 1 THEN 1\tWHEN 4 THEN 2\tWHEN 2 THEN 3\tWHEN 9 THEN 4\tWHEN 8 THEN 5 else 6 \tEND\tFROM T_BG_BgForm where FSTATE not in (5,50,51,52,53,54,55)");
            if (blbgTypeId) {
                strBuffer.append(" and fbgTypeId = ? ");
            }
            if (blorgUnitId) {
                strBuffer.append(" and forgUnitID = ? ");
            }
            if (blorgUnitId) {
                strBuffer.append(" and fBgschemeID = ? ");
            }
            strBuffer.append(" ORDER BY FSTATE");
            ps = conn.prepareStatement(strBuffer.toString());
            strBuffer = null;
            int index = 1;
            if (blbgTypeId) {
                ps.setString(index++, bgTypeId);
            }
            if (blbgTypeId) {
                ps.setString(index++, orgUnitId);
            }
            if (blbgTypeId) {
                ps.setString(index++, bgSchemeID);
            }
            rs = ps.executeQuery();
            String strId = null;
            if (rs.next()) {
                strId = rs.getString("FID");
            }
            if (strId != null) {
                bgFormInfo = this.getSingleForm(ctx, (IObjectPK)new ObjectUuidPK(strId));
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return bgFormInfo;
    }

    private boolean isSameBgEntry(BgEntryInfo bgEntryInfo, String bgEntryId) {
        return bgEntryInfo.getId().toString().equals(bgEntryId);
    }

    private void detailTemplate(Context ctx, BgFormInfo bfi) throws BOSException, EASBizException {
        IBgTemplateDA iBgTpDa = BgTemplateDAFactory.getLocalInstance(ctx);
        bfi.setBgTemplate(iBgTpDa.getBgTemplate(bfi.getBgTemplate().getId().toString()));
    }

    private BgFormInfo createNewBgForm(Context ctx, String bgSchemeId, String bgTemplateId, FullOrgUnitInfo orgUnitInfo) throws BOSException, EASBizException {
        IBgScheme iBgScheme = BgSchemeFactory.getLocalInstance(ctx);
        BgSchemeInfo bgSchemeInfo = iBgScheme.getBgSchemePeriodDesc(BOSUuid.read((String)bgSchemeId));
        IBgTemplateDA iBgTpDa = BgTemplateDAFactory.getLocalInstance(ctx);
        IBgTemplateDA ibgTpDa = BgTemplateDAFactory.getLocalInstance(ctx);
        BgTemplateInfo bgTemplateInfo = ibgTpDa.getBgTemplate(bgTemplateId);
        IBgManager iBgManager = BgManagerFactory.getLocalInstance(ctx);
        BgFormInfo bfi = iBgManager.generateBgForm((IObjectValue)bgTemplateInfo, (IObjectValue)bgSchemeInfo, orgUnitInfo);
        return bfi;
    }

    private BgEntryCollection getBgEntryCollection(Context ctx, Connection conn, IObjectPK pk, Map cache) throws BgBizException {
        if (sqlFor_getBgEntryCollection == null) {
            StringBuffer sb = new StringBuffer(5000);
            sb.append(" SELECT ");
            sb.append("T_BG_BgEntry.FID AS bgEntry_id,");
            sb.append("T_BG_BgEntry.FIsLeafPeriod AS bgEntry_isLeafPeriod,");
            sb.append("T_BG_BgEntry.FIsLeafEntry AS bgEntry_isLeafEntry, ");
            sb.append("T_BG_BgEntry.FPeriodID AS bgEntry_period, ");
            sb.append("T_BG_BgEntry.FBgFormID AS bgEntry_bgForm, ");
            sb.append("T_BG_BgEntry.FBgItem1ID AS bgEntry_bgItem1, ");
            sb.append("T_BG_BgEntry.FBgItem2ID AS bgEntry_bgItem2, ");
            sb.append("T_BG_BgEntry.FBgItem3ID AS bgEntry_bgItem3, ");
            sb.append("T_BG_BgEntry.FBgItem4ID AS bgEntry_bgItem4, ");
            sb.append("T_BG_BgEntry.FBgItem5ID AS bgEntry_bgItem5, ");
            sb.append("T_BG_BgEntry.FBgItem6ID AS bgEntry_bgItem6,");
            sb.append("T_BG_BgEntry.FBgCycle AS bgEntry_bgCycle, ");
            sb.append("T_BG_BgEntry.FEntryType AS bgEntry_entryType, ");
            sb.append("T_BD_Period.FID AS period_id,");
            sb.append("T_BD_Period.FPeriodYear AS period_year, ");
            sb.append("T_BD_Period.FPeriodQuarter AS period_quarter,");
            sb.append("T_BD_Period.FPeriodNumber AS period_number,");
            sb.append("T_BG_BgData.FID AS bgData_id,");
            sb.append("T_BG_BgData.FDataType AS bgData_dataType,");
            sb.append("T_BG_BgData.FBgValue AS bgData_bgValue,");
            sb.append("T_BG_BgData.FBizActual AS bgData_bizActual,");
            sb.append("T_BG_BgData.FBgBalance AS bgData_bgBalance,");
            sb.append("T_BG_BgData.FElementNumber AS bgData_elementNumber,");
            sb.append("T_BG_BgData.FCurrencyID AS bgData_currency, ");
            sb.append("T_BG_BgData.FBgElementID AS bgData_bgElement,");
            sb.append("T_BG_BgData.FBgEntryID AS bgData_bgEntry, ");
            sb.append("T_BG_BgData.FBgCtrlType AS bgData_bgCtrlType, ");
            sb.append("T_BG_BgData.FIsFlexibleCtrl AS bgData_isFlexibleCtrl, ");
            sb.append("T_BG_BgData.FFlexibleBgCtrlParam AS bgData_flexibleBgCtrlParam, ");
            sb.append("T_BG_BgElement.FID AS bgElement_id,");
            sb.append("T_BG_BgElement.FSeq AS bgElement_seq,");
            sb.append("T_BG_BgElement.FNumber AS bgElement_number,");
            sb.append("T_BG_BgElement.FSummable AS bgElement_summable,");
            sb.append("T_BG_BgElement.FApportionable AS bgElement_apportionable,");
            sb.append("T_BD_Currency.FID AS currency_id,");
            sb.append("T_BD_Currency.FNumber AS currency_number,");
            sb.append("T_BG_BgItem1.FID AS bgItem1_id, T_BG_BgItem1.FIsLeaf AS bgItem1_isLeaf, ");
            sb.append("T_BG_BgItem1.FLongNumber AS bgItem1_longNumber, ");
            sb.append("T_BG_BgItem1.FItemNumber AS bgItem1_itemNumber, ");
            sb.append("T_BG_BgItem1.FItemID AS bgItem1_itemId, ");
            sb.append("T_BG_BgItem1.FItemName_@L@ AS bgItem1_itemName,");
            sb.append("T_BG_BgItem1.FBgDimension AS bgItem1_bgDimension, ");
            sb.append("T_BG_BgItem2.FID AS bgItem2_id, T_BG_BgItem2.FIsLeaf AS bgItem2_isLeaf, ");
            sb.append("T_BG_BgItem2.FLongNumber AS bgItem2_longNumber, ");
            sb.append("T_BG_BgItem2.FItemNumber AS bgItem2_itemNumber, ");
            sb.append("T_BG_BgItem2.FItemID AS bgItem2_itemId, ");
            sb.append("T_BG_BgItem2.FItemName_@L@ AS bgItem2_itemName,");
            sb.append("T_BG_BgItem2.FBgDimension AS bgItem2_bgDimension, ");
            sb.append("T_BG_BgItem3.FID AS bgItem3_id, T_BG_BgItem3.FIsLeaf AS bgItem3_isLeaf,");
            sb.append("T_BG_BgItem3.FLongNumber AS bgItem3_longNumber, ");
            sb.append("T_BG_BgItem3.FItemNumber AS bgItem3_itemNumber, ");
            sb.append("T_BG_BgItem3.FItemID AS bgItem3_itemId, ");
            sb.append("T_BG_BgItem3.FItemName_@L@ AS bgItem3_itemName,");
            sb.append("T_BG_BgItem3.FBgDimension AS bgItem3_bgDimension,");
            sb.append("T_BG_BgItem4.FID AS bgItem4_id, T_BG_BgItem4.FIsLeaf AS bgItem4_isLeaf,");
            sb.append("T_BG_BgItem4.FLongNumber AS bgItem4_longNumber, ");
            sb.append("T_BG_BgItem4.FItemNumber AS bgItem4_itemNumber, ");
            sb.append("T_BG_BgItem4.FItemID AS bgItem4_itemId, ");
            sb.append("T_BG_BgItem4.FItemName_@L@ AS bgItem4_itemName,");
            sb.append("T_BG_BgItem4.FBgDimension AS bgItem4_bgDimension, ");
            sb.append("T_BG_BgItem5.FID AS bgItem5_id, T_BG_BgItem5.FIsLeaf AS bgItem5_isLeaf,");
            sb.append("T_BG_BgItem5.FLongNumber AS bgItem5_longNumber, ");
            sb.append("T_BG_BgItem5.FItemNumber AS bgItem5_itemNumber, ");
            sb.append("T_BG_BgItem5.FItemID AS bgItem5_itemId, ");
            sb.append("T_BG_BgItem5.FItemName_@L@ AS bgItem5_itemName,");
            sb.append("T_BG_BgItem5.FBgDimension AS bgItem5_bgDimension, ");
            sb.append("T_BG_BgItem6.FID AS bgItem6_id, T_BG_BgItem6.FIsLeaf AS bgItem6_isLeaf,");
            sb.append("T_BG_BgItem6.FLongNumber AS bgItem6_longNumber, ");
            sb.append("T_BG_BgItem6.FItemNumber AS bgItem6_itemNumber, ");
            sb.append("T_BG_BgItem6.FItemID AS bgItem6_itemId, ");
            sb.append("T_BG_BgItem6.FItemName_@L@ AS bgItem6_itemName,");
            sb.append("T_BG_BgItem6.FBgDimension AS bgItem6_bgDimension ");
            sb.append("FROM T_BG_BgEntry");
            sb.append(" INNER JOIN T_BG_BgData ON T_BG_BgEntry.FID = T_BG_BgData.FBgEntryID");
            sb.append(" INNER JOIN T_BD_Period ON T_BG_BgEntry.FPeriodID = T_BD_Period.FID");
            sb.append(" LEFT OUTER JOIN T_BG_BgItem T_BG_BgItem1 ON T_BG_BgEntry.FBgItem1ID = T_BG_BgItem1.FID");
            sb.append(" LEFT OUTER JOIN T_BG_BgItem T_BG_BgItem2 ON T_BG_BgEntry.FBgItem2ID = T_BG_BgItem2.FID");
            sb.append(" LEFT OUTER JOIN T_BG_BgItem T_BG_BgItem3 ON T_BG_BgEntry.FBgItem3ID = T_BG_BgItem3.FID");
            sb.append(" LEFT OUTER JOIN T_BG_BgItem T_BG_BgItem4 ON T_BG_BgEntry.FBgItem4ID = T_BG_BgItem4.FID");
            sb.append(" LEFT OUTER JOIN T_BG_BgItem T_BG_BgItem5 ON T_BG_BgEntry.FBgItem5ID = T_BG_BgItem5.FID");
            sb.append(" LEFT OUTER JOIN T_BG_BgItem T_BG_BgItem6 ON T_BG_BgEntry.FBgItem6ID = T_BG_BgItem6.FID ");
            sb.append(" INNER JOIN T_BG_BgElement ON T_BG_BgData.FBgElementID = T_BG_BgElement.FID");
            sb.append(" LEFT OUTER JOIN T_BD_Currency ON T_BG_BgData.FCurrencyID = T_BD_Currency.FID");
            sb.append(" WHERE T_BG_BgEntry.FBgFormID = ?");
            sb.append(" ORDER BY ");
            sb.append("T_BD_Period.FPeriodYear,");
            sb.append("T_BD_Period.FPeriodQuarter,");
            sb.append("T_BD_Period.FPeriodNumber, ");
            sb.append("T_BG_BgEntry.FBgCycle,");
            sb.append("T_BG_BgItem1.FItemNumber,");
            sb.append("T_BG_BgItem2.FItemNumber, ");
            sb.append("T_BG_BgItem3.FItemNumber,");
            sb.append("T_BG_BgItem4.FItemNumber,");
            sb.append("T_BG_BgItem5.FItemNumber,");
            sb.append("T_BG_BgItem6.FItemNumber,");
            sb.append("T_BG_BgElement.FSeq,");
            sb.append("T_BD_Currency.FNumber");
            sqlFor_getBgEntryCollection = sb;
        }
        BgEntryCollection bgEntryCollection = new BgEntryCollection();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            stmt = conn.prepareStatement(BgDaHelper.convert(ctx, sqlFor_getBgEntryCollection.toString()));
            stmt.setString(1, pk.toString());
            resultSet = stmt.executeQuery();
            BgEntryInfo bgEntryInfo = null;
            while (resultSet.next()) {
                String bgEntryId = resultSet.getString(BGENTRY_ID);
                if (!BgDaHelper.isValidIdString(bgEntryId)) continue;
                Object bgentry = cache.get(bgEntryId);
                if (bgentry != null) {
                    bgEntryInfo = (BgEntryInfo)bgentry;
                } else {
                    if (bgEntryInfo == null || !this.isSameBgEntry(bgEntryInfo, bgEntryId)) {
                        bgEntryInfo = this.generatePlainBgEntry(resultSet, bgEntryId, cache);
                        cache.put(bgEntryId, bgEntryInfo);
                    }
                    bgEntryCollection.add(bgEntryInfo);
                }
                bgEntryInfo.getBgData().add(this.generatePlainBgData(resultSet, cache));
            }
        }
        catch (SQLException e) {
            try {
                throw new BgBizException(BgBizException.GETDATA, e, new Object[]{"BgForm"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(resultSet, stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)resultSet, (Statement)stmt);
        return bgEntryCollection;
    }

    private BgEntryCollection getBgEntryCollectionForDistribute(Context ctx, Connection conn, IObjectPK pk, Map cache) throws BgBizException {
        if (sqlFor_getBgEntryCollectionForDistribute == null) {
            StringBuffer sb = new StringBuffer(5000);
            sb.append(" SELECT ");
            sb.append("T_BG_BgEntry.FID AS bgEntry_id,");
            sb.append("T_BG_BgEntry.FIsLeafPeriod AS bgEntry_isLeafPeriod,");
            sb.append("T_BG_BgEntry.FIsLeafEntry AS bgEntry_isLeafEntry, ");
            sb.append("T_BG_BgEntry.FPeriodID AS bgEntry_period, ");
            sb.append("T_BG_BgEntry.FBgFormID AS bgEntry_bgForm, ");
            sb.append("T_BG_BgEntry.FBgItem1ID AS bgEntry_bgItem1, ");
            sb.append("T_BG_BgEntry.FBgItem2ID AS bgEntry_bgItem2, ");
            sb.append("T_BG_BgEntry.FBgItem3ID AS bgEntry_bgItem3, ");
            sb.append("T_BG_BgEntry.FBgItem4ID AS bgEntry_bgItem4, ");
            sb.append("T_BG_BgEntry.FBgItem5ID AS bgEntry_bgItem5, ");
            sb.append("T_BG_BgEntry.FBgItem6ID AS bgEntry_bgItem6,");
            sb.append("T_BG_BgEntry.FBgCycle AS bgEntry_bgCycle, ");
            sb.append("T_BG_BgEntry.FEntryType AS bgEntry_entryType, ");
            sb.append("T_BD_Period.FID AS period_id,");
            sb.append("T_BD_Period.FPeriodYear AS period_year, ");
            sb.append("T_BD_Period.FPeriodQuarter AS period_quarter,");
            sb.append("T_BD_Period.FPeriodNumber AS period_number,");
            sb.append("T_BG_BgData.FID AS bgData_id,");
            sb.append("T_BG_BgData.FDataType AS bgData_dataType,");
            sb.append("T_BG_BgData.FBgValue AS bgData_bgValue,");
            sb.append("T_BG_BgData.FBizActual AS bgData_bizActual,");
            sb.append("T_BG_BgData.FBgBalance AS bgData_bgBalance,");
            sb.append("T_BG_BgData.FElementNumber AS bgData_elementNumber,");
            sb.append("T_BG_BgData.FCurrencyID AS bgData_currency, ");
            sb.append("T_BG_BgData.FBgElementID AS bgData_bgElement,");
            sb.append("T_BG_BgData.FBgEntryID AS bgData_bgEntry, ");
            sb.append("T_BG_BgData.FBgCtrlType AS bgData_bgCtrlType, ");
            sb.append("T_BG_BgData.FIsFlexibleCtrl AS bgData_isFlexibleCtrl, ");
            sb.append("T_BG_BgData.FFlexibleBgCtrlParam AS bgData_flexibleBgCtrlParam, ");
            sb.append("T_BG_BgElement.FID AS bgElement_id,");
            sb.append("T_BG_BgElement.FSeq AS bgElement_seq,");
            sb.append("T_BG_BgElement.FNumber AS bgElement_number,");
            sb.append("T_BG_BgElement.FSummable AS bgElement_summable,");
            sb.append("T_BG_BgElement.FApportionable AS bgElement_apportionable,");
            sb.append("T_BD_Currency.FID AS currency_id,");
            sb.append("T_BD_Currency.FNumber AS currency_number,");
            sb.append("T_BG_BgItem1.FID AS bgItem1_id, T_BG_BgItem1.FIsLeaf AS bgItem1_isLeaf, ");
            sb.append("T_BG_BgItem1.FLongNumber AS bgItem1_longNumber, ");
            sb.append("T_BG_BgItem1.FItemNumber AS bgItem1_itemNumber, ");
            sb.append("T_BG_BgItem1.FItemID AS bgItem1_itemId, ");
            sb.append("T_BG_BgItem1.FItemName_@L@ AS bgItem1_itemName,");
            sb.append("T_BG_BgItem1.FBgDimension AS bgItem1_bgDimension, ");
            sb.append("T_BG_BgItem2.FID AS bgItem2_id, T_BG_BgItem2.FIsLeaf AS bgItem2_isLeaf, ");
            sb.append("T_BG_BgItem2.FLongNumber AS bgItem2_longNumber, ");
            sb.append("T_BG_BgItem2.FItemNumber AS bgItem2_itemNumber, ");
            sb.append("T_BG_BgItem2.FItemID AS bgItem2_itemId, ");
            sb.append("T_BG_BgItem2.FItemName_@L@ AS bgItem2_itemName,");
            sb.append("T_BG_BgItem2.FBgDimension AS bgItem2_bgDimension, ");
            sb.append("T_BG_BgItem3.FID AS bgItem3_id, T_BG_BgItem3.FIsLeaf AS bgItem3_isLeaf,");
            sb.append("T_BG_BgItem3.FLongNumber AS bgItem3_longNumber, ");
            sb.append("T_BG_BgItem3.FItemNumber AS bgItem3_itemNumber, ");
            sb.append("T_BG_BgItem3.FItemID AS bgItem3_itemId, ");
            sb.append("T_BG_BgItem3.FItemName_@L@ AS bgItem3_itemName,");
            sb.append("T_BG_BgItem3.FBgDimension AS bgItem3_bgDimension,");
            sb.append("T_BG_BgItem4.FID AS bgItem4_id, T_BG_BgItem4.FIsLeaf AS bgItem4_isLeaf,");
            sb.append("T_BG_BgItem4.FLongNumber AS bgItem4_longNumber, ");
            sb.append("T_BG_BgItem4.FItemNumber AS bgItem4_itemNumber, ");
            sb.append("T_BG_BgItem4.FItemID AS bgItem4_itemId, ");
            sb.append("T_BG_BgItem4.FItemName_@L@ AS bgItem4_itemName,");
            sb.append("T_BG_BgItem4.FBgDimension AS bgItem4_bgDimension, ");
            sb.append("T_BG_BgItem5.FID AS bgItem5_id, T_BG_BgItem5.FIsLeaf AS bgItem5_isLeaf,");
            sb.append("T_BG_BgItem5.FLongNumber AS bgItem5_longNumber, ");
            sb.append("T_BG_BgItem5.FItemNumber AS bgItem5_itemNumber, ");
            sb.append("T_BG_BgItem5.FItemID AS bgItem5_itemId, ");
            sb.append("T_BG_BgItem5.FItemName_@L@ AS bgItem5_itemName,");
            sb.append("T_BG_BgItem5.FBgDimension AS bgItem5_bgDimension, ");
            sb.append("T_BG_BgItem6.FID AS bgItem6_id, T_BG_BgItem6.FIsLeaf AS bgItem6_isLeaf,");
            sb.append("T_BG_BgItem6.FLongNumber AS bgItem6_longNumber, ");
            sb.append("T_BG_BgItem6.FItemNumber AS bgItem6_itemNumber, ");
            sb.append("T_BG_BgItem6.FItemID AS bgItem6_itemId, ");
            sb.append("T_BG_BgItem6.FItemName_@L@ AS bgItem6_itemName,");
            sb.append("T_BG_BgItem6.FBgDimension AS bgItem6_bgDimension ");
            sb.append("FROM T_BG_BgEntry");
            sb.append(" INNER JOIN T_BG_BgData ON T_BG_BgEntry.FID = T_BG_BgData.FBgEntryID");
            sb.append(" INNER JOIN T_BD_Period ON T_BG_BgEntry.FPeriodID = T_BD_Period.FID");
            sb.append(" LEFT OUTER JOIN T_BG_BgItem T_BG_BgItem1 ON T_BG_BgEntry.FBgItem1ID = T_BG_BgItem1.FID");
            sb.append(" LEFT OUTER JOIN T_BG_BgItem T_BG_BgItem2 ON T_BG_BgEntry.FBgItem2ID = T_BG_BgItem2.FID");
            sb.append(" LEFT OUTER JOIN T_BG_BgItem T_BG_BgItem3 ON T_BG_BgEntry.FBgItem3ID = T_BG_BgItem3.FID");
            sb.append(" LEFT OUTER JOIN T_BG_BgItem T_BG_BgItem4 ON T_BG_BgEntry.FBgItem4ID = T_BG_BgItem4.FID");
            sb.append(" LEFT OUTER JOIN T_BG_BgItem T_BG_BgItem5 ON T_BG_BgEntry.FBgItem5ID = T_BG_BgItem5.FID");
            sb.append(" LEFT OUTER JOIN T_BG_BgItem T_BG_BgItem6 ON T_BG_BgEntry.FBgItem6ID = T_BG_BgItem6.FID ");
            sb.append(" INNER JOIN T_BG_BgElement ON T_BG_BgData.FBgElementID = T_BG_BgElement.FID");
            sb.append(" LEFT OUTER JOIN T_BD_Currency ON T_BG_BgData.FCurrencyID = T_BD_Currency.FID");
            sb.append(" WHERE T_BG_BgEntry.FBgFormID = ? AND (T_BG_BgEntry.FEntryType is null OR T_BG_BgEntry.FEntryType=0 OR T_BG_BgEntry.FEntryType=1)");
            sb.append(" ORDER BY ");
            sb.append("T_BD_Period.FPeriodYear,");
            sb.append("T_BD_Period.FPeriodQuarter,");
            sb.append("T_BD_Period.FPeriodNumber, ");
            sb.append("T_BG_BgEntry.FBgCycle,");
            sb.append("T_BG_BgItem1.FItemNumber,");
            sb.append("T_BG_BgItem2.FItemNumber, ");
            sb.append("T_BG_BgItem3.FItemNumber,");
            sb.append("T_BG_BgItem4.FItemNumber,");
            sb.append("T_BG_BgItem5.FItemNumber,");
            sb.append("T_BG_BgItem6.FItemNumber,");
            sb.append("T_BG_BgElement.FSeq,");
            sb.append("T_BD_Currency.FNumber");
            sqlFor_getBgEntryCollectionForDistribute = sb;
        }
        BgEntryCollection bgEntryCollection = new BgEntryCollection();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            stmt = conn.prepareStatement(BgDaHelper.convert(ctx, sqlFor_getBgEntryCollectionForDistribute.toString()));
            stmt.setString(1, pk.toString());
            resultSet = stmt.executeQuery();
            BgEntryInfo bgEntryInfo = null;
            while (resultSet.next()) {
                String bgEntryId = resultSet.getString(BGENTRY_ID);
                if (!BgDaHelper.isValidIdString(bgEntryId)) continue;
                Object bgentry = cache.get(bgEntryId);
                if (bgentry != null) {
                    bgEntryInfo = (BgEntryInfo)bgentry;
                } else {
                    if (bgEntryInfo == null || !this.isSameBgEntry(bgEntryInfo, bgEntryId)) {
                        bgEntryInfo = this.generatePlainBgEntry(resultSet, bgEntryId, cache);
                        cache.put(bgEntryId, bgEntryInfo);
                    }
                    bgEntryCollection.add(bgEntryInfo);
                }
                bgEntryInfo.getBgData().add(this.generatePlainBgData(resultSet, cache));
            }
        }
        catch (SQLException e) {
            try {
                throw new BgBizException(BgBizException.GETDATA, e, new Object[]{"BgForm"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(resultSet, stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)resultSet, (Statement)stmt);
        return bgEntryCollection;
    }

    private BgDataInfo generatePlainBgData(ResultSet resultSet, Map cache) throws SQLException {
        String bgDataId = resultSet.getString(BGDATA_ID);
        CurrencyInfo cyInfo = null;
        BgElementInfo bgEleInfo = null;
        if (BgDaHelper.isValidIdString(bgDataId)) {
            String elementId;
            BgDataInfo bdi = new BgDataInfo();
            bdi.setId(BOSUuid.read((String)bgDataId));
            bdi.setBgValue(resultSet.getBigDecimal(BGDATA_BGVALUE));
            bdi.setBizActual(resultSet.getBigDecimal(BGDATA_BIZACTUAL));
            bdi.setBgBalance(resultSet.getBigDecimal(BGDATA_BGBALANCE));
            bdi.setInt("dataType", resultSet.getInt(BGDATA_DATATYPE));
            bdi.setElementNumber(resultSet.getString(BGDATA_ELEMENTNUMBER));
            bdi.setInt("bgCtrlType", resultSet.getInt(BGDATA_BGCTRLTYPE));
            bdi.setIsFlexibleCtrl(resultSet.getBoolean(BGDATA_ISFLEXIBLECTRL));
            bdi.setFlexibleBgCtrlParam(resultSet.getBigDecimal(BGDATA_FLEXIBLEBGCTRLPARAM));
            String cyId = resultSet.getString(BGDATA_CURRENCY);
            if (BgDaHelper.isValidIdString(cyId)) {
                Object currency = cache.get(cyId);
                if (currency != null) {
                    cyInfo = (CurrencyInfo)currency;
                } else {
                    cyInfo = new CurrencyInfo();
                    cyInfo.setId(BOSUuid.read((String)cyId));
                    cyInfo.setNumber(resultSet.getString(CURRENCY_NUMBER));
                    cache.put(cyId, cyInfo);
                }
                bdi.setCurrency(cyInfo);
            }
            if (BgDaHelper.isValidIdString(elementId = resultSet.getString(BGDATA_BGELEMENT))) {
                Object bgEle = cache.get(elementId);
                if (bgEle != null) {
                    bgEleInfo = (BgElementInfo)bgEle;
                } else {
                    bgEleInfo = new BgElementInfo();
                    bgEleInfo.setId(BOSUuid.read((String)elementId));
                    bgEleInfo.setSeq(resultSet.getInt(BGELEMENT_SEQ));
                    bgEleInfo.setNumber(resultSet.getString(BGELEMENT_NUMBER));
                    bgEleInfo.setInt("summable", resultSet.getInt(BGELEMENT_SUMMABLE));
                    bgEleInfo.setInt("apportionable", resultSet.getInt(BGELEMENT_APPORTIONABLE));
                    cache.put(elementId, bgEleInfo);
                }
                bdi.setBgElement(bgEleInfo);
            }
            return bdi;
        }
        return null;
    }

    private BgEntryInfo generatePlainBgEntry(ResultSet resultSet, String bgEntryId, Map cache) throws UuidException, SQLException {
        BgEntryInfo bei = null;
        bei = (BgEntryInfo)cache.get(bgEntryId);
        if (bei != null) {
            return bei;
        }
        bei = new BgEntryInfo();
        cache.put(bgEntryId, bei);
        bei.setId(BOSUuid.read((String)bgEntryId));
        bei.setInt("isLeafPeriod", resultSet.getInt(BGENTRY_ISLEAFPERIOD));
        bei.setInt("isLeafEntry", resultSet.getInt(BGENTRY_ISLEAFENTRY));
        bei.setInt("bgCycle", resultSet.getInt(BGENTRY_BGCYCLE));
        bei.setInt("entryType", resultSet.getInt(BGENTRY_ENTRYTYPE));
        String periodId = resultSet.getString(BGENTRY_PERIOD);
        PeriodInfo pi = null;
        if (BgDaHelper.isValidIdString(periodId)) {
            Object period = cache.get(periodId);
            if (period != null) {
                pi = (PeriodInfo)period;
            } else {
                pi = new PeriodInfo();
                pi.setId(BOSUuid.read((String)periodId));
                pi.setPeriodYear(resultSet.getInt(PERIOD_YEAR));
                pi.setPeriodQuarter(resultSet.getInt(PERIOD_QUARTER));
                pi.setPeriodNumber(resultSet.getInt(PERIOD_NUMBER));
                cache.put(periodId, pi);
            }
            bei.setPeriod(pi);
        }
        BgItemInfo bgItemInfo = null;
        for (int i = 1; i <= BgTemplateRowInfo.MAXREFDIM; ++i) {
            String key = "bgItem" + String.valueOf(i);
            String bgItemId = resultSet.getString("bgEntry_" + key);
            if (!BgDaHelper.isValidIdString(bgItemId)) continue;
            Object bgItem = cache.get(bgItemId);
            if (bgItem != null) {
                bgItemInfo = (BgItemInfo)bgItem;
            } else {
                bgItemInfo = new BgItemInfo();
                bgItemInfo.setId(BOSUuid.read((String)bgItemId));
                bgItemInfo.setInt("isLeaf", resultSet.getInt(key + "_isLeaf"));
                bgItemInfo.setLongNumber(resultSet.getString(key + "_longNumber"));
                bgItemInfo.setItemNumber(resultSet.getString(key + "_itemNumber"));
                bgItemInfo.setItemName(resultSet.getString(key + "_itemName"));
                bgItemInfo.setInt("bgDimension", resultSet.getInt(key + "_bgDimension"));
                cache.put(bgItemId, bgItemInfo);
            }
            bei.put(key, bgItemInfo);
        }
        return bei;
    }

    private BgFormInfo generatePlainBgForm(ResultSet resultSet) throws UuidException, SQLException {
        String lastUpdateUserId;
        String periodToId;
        String periodFormId;
        String bgSchemeId;
        String bgTypeId;
        String creatorId;
        String orgUnitId;
        BgFormInfo bfi = new BgFormInfo();
        bfi.setId(BOSUuid.read((String)resultSet.getString("FID")));
        bfi.setNumber(resultSet.getString("FNumber"));
        bfi.setName(resultSet.getString("FName"));
        bfi.setCreateTime(resultSet.getTimestamp("FCreateTime"));
        bfi.setInt("dataSource", resultSet.getInt("FDataSource"));
        bfi.setInt("state", resultSet.getInt("FSTATE"));
        String bgTemplateId = resultSet.getString("FBgTemplateID");
        String bgRptTemplateId = resultSet.getString("FBgRptTemplateID");
        if (BgDaHelper.isValidIdString(bgTemplateId)) {
            BgTemplateInfo tmpBgTpInfo = new BgTemplateInfo();
            tmpBgTpInfo.setId(BOSUuid.read((String)bgTemplateId));
            bfi.setBgTemplate(tmpBgTpInfo);
        }
        if (BgDaHelper.isValidIdString(bgRptTemplateId)) {
            BgRptTemplateInfo tmpBgRptTpInfo = new BgRptTemplateInfo();
            tmpBgRptTpInfo.setId(BOSUuid.read((String)bgRptTemplateId));
            bfi.setBgRptTemplate(tmpBgRptTpInfo);
        }
        if (BgDaHelper.isValidIdString(orgUnitId = resultSet.getString("FOrgUnitID"))) {
            FullOrgUnitInfo orgInfo = new FullOrgUnitInfo();
            orgInfo.setId(BOSUuid.read((String)orgUnitId));
            orgInfo.setNumber(resultSet.getString("orgUnit_number"));
            orgInfo.setName(resultSet.getString("orgUnit_name"));
            bfi.setOrgUnit(orgInfo);
        }
        if (BgDaHelper.isValidIdString(creatorId = resultSet.getString("FCreatorID"))) {
            UserInfo userInfo = new UserInfo();
            userInfo.setId(BOSUuid.read((String)creatorId));
            userInfo.setNumber(resultSet.getString("creator_number"));
            userInfo.setName(resultSet.getString("creator_name"));
            bfi.setCreator(userInfo);
        }
        if (BgDaHelper.isValidIdString(bgTypeId = resultSet.getString("FBgTypeID"))) {
            BgTypeInfo bti = new BgTypeInfo();
            bti.setId(BOSUuid.read((String)bgTypeId));
            bti.setNumber(resultSet.getString("bgType_number"));
            bti.setName(resultSet.getString("bgType_name"));
            bti.setIsRptBgForm(resultSet.getInt("bgType_isRptBgForm") == 1);
            bfi.setBgType(bti);
        }
        if (BgDaHelper.isValidIdString(bgSchemeId = resultSet.getString("FBgSchemeID"))) {
            BgSchemeInfo bsi = new BgSchemeInfo();
            bsi.setId(BOSUuid.read((String)bgSchemeId));
            bsi.setNumber(resultSet.getString("bgScheme_number"));
            bsi.setName(resultSet.getString("bgScheme_name"));
            bsi.setIsFormal(resultSet.getBoolean("bgScheme_isFormal"));
            bfi.setBgScheme(bsi);
        }
        if (BgDaHelper.isValidIdString(periodFormId = resultSet.getString("FPeriodFromID"))) {
            PeriodInfo periodFrom = new PeriodInfo();
            periodFrom.setId(BOSUuid.read((String)periodFormId));
            periodFrom.setPeriodYear(resultSet.getInt("periodFrom_year"));
            periodFrom.setPeriodQuarter(resultSet.getInt("periodFrom_quarter"));
            periodFrom.setPeriodNumber(resultSet.getInt("periodFrom_number"));
            bfi.setPeriodFrom(periodFrom);
        }
        if (BgDaHelper.isValidIdString(periodToId = resultSet.getString("FPeriodToID"))) {
            PeriodInfo periodTo = new PeriodInfo();
            periodTo.setId(BOSUuid.read((String)periodToId));
            periodTo.setPeriodYear(resultSet.getInt("periodTo_year"));
            periodTo.setPeriodQuarter(resultSet.getInt("periodTo_quarter"));
            periodTo.setPeriodNumber(resultSet.getInt("periodTo_number"));
            bfi.setPeriodTo(periodTo);
        }
        if (BgDaHelper.isValidIdString(lastUpdateUserId = resultSet.getString("FLastUpdateUserID"))) {
            UserInfo userInfo = new UserInfo();
            userInfo.setId(BOSUuid.read((String)lastUpdateUserId));
            userInfo.setNumber(resultSet.getString("lastUpdateUser_number"));
            userInfo.setName(resultSet.getString("lastUpdateUser_name"));
            bfi.setLastUpdateUser(userInfo);
        }
        bfi.setLastUpdateTime(resultSet.getTimestamp("FLastUpdateTime"));
        String companyId = resultSet.getString("FCompanyID");
        CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
        companyInfo.setId(BOSUuid.read((String)companyId));
        bfi.setCompany(companyInfo);
        return bfi;
    }

    private BgPastRecordCollection getPastRecordCollection(Context ctx, Connection conn, IObjectPK pk, Map cache) throws BOSException, EASBizException {
        BgPastRecordCollection bgPastRecordCollection;
        StringBuffer sb = new StringBuffer(512);
        sb.append(" SELECT ");
        sb.append(" T_BG_BgPastRecord.FID AS fid, ");
        sb.append(" T_BG_BgPastRecord.FSeq AS seq, ");
        sb.append(" T_BG_BgPastRecord.FModifyDate AS modifyDate, ");
        sb.append(" T_BG_BgPastRecord.FBgFormID AS bgForm, ");
        sb.append(" T_BG_BgPastRecord.FModifierID AS modifier, ");
        sb.append(" T_BG_BgPastData.FID AS bgPastData_id, ");
        sb.append(" T_BG_BgPastData.FPastValue AS bgPastData_pastValue, ");
        sb.append(" T_BG_BgPastData.FBalance AS bgPastData_balance, ");
        sb.append(" T_BG_BgPastData.FBgPastRecordID AS bgPastData_bgPastRecordId, ");
        sb.append(" T_BG_BgPastData.FBgDataID AS bgPastData_bgData, ");
        sb.append(" T_BG_BgPastData.FDataSource AS bgPastData_dataSource, ");
        sb.append(" T_PM_User.FName_@L@ AS user_name, ");
        sb.append(" T_PM_User.FID AS fuser_id ");
        sb.append(" FROM T_BG_BgPastData ");
        sb.append(" INNER JOIN T_BG_BgPastRecord ON T_BG_BgPastData.FBgPastRecordID = T_BG_BgPastRecord.FID ");
        sb.append(" LEFT OUTER JOIN T_PM_User ON T_BG_BgPastRecord.FModifierID = T_PM_User.FID ");
        sb.append(" WHERE T_BG_BgPastRecord.FBgFormID = ?");
        sb.append(" ORDER BY T_BG_BgPastRecord.FModifyDate desc, T_BG_BgPastRecord.FID ");
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            stmt = conn.prepareStatement(BgDaHelper.convert(ctx, sb.toString()));
            stmt.setString(1, pk.toString());
            resultSet = stmt.executeQuery();
            bgPastRecordCollection = this.generateBgPtRdCollection(resultSet, cache);
        }
        catch (SQLException e) {
            try {
                throw new EASBizException(BgBizException.GETDATA, (Throwable)e, new Object[]{"BgForm"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(resultSet, stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)resultSet, (Statement)stmt);
        return bgPastRecordCollection;
    }

    private BgPastRecordCollection generateBgPtRdCollection(ResultSet resultSet, Map cache) throws SQLException {
        BgPastRecordCollection bgPtRdCollection = new BgPastRecordCollection();
        AbstractBgPastRecordInfo bgPtRdInfo = null;
        while (resultSet.next()) {
            String bgPtRdId = resultSet.getString("fid");
            if (bgPtRdInfo == null || !bgPtRdInfo.getId().toString().equals(bgPtRdId)) {
                Object bgPtd = cache.get(bgPtRdId);
                if (bgPtd != null) {
                    bgPtRdInfo = (BgPastRecordInfo)bgPtd;
                } else {
                    bgPtRdInfo = this.generatePlainBgPtRd(resultSet, bgPtRdId, cache);
                    cache.put(bgPtRdId, bgPtRdInfo);
                }
                bgPtRdCollection.add((BgPastRecordInfo)bgPtRdInfo);
            }
            bgPtRdInfo.getPastData().add(this.generatePlainBgPtData(resultSet, cache));
        }
        return bgPtRdCollection;
    }

    private BgPastRecordInfo generatePlainBgPtRd(ResultSet resultSet, String bgPtRdId, Map cache) throws SQLException {
        BgPastRecordInfo bgPastRdInfo = new BgPastRecordInfo();
        bgPastRdInfo.setId(BOSUuid.read((String)bgPtRdId));
        bgPastRdInfo.setSeq(resultSet.getInt("seq"));
        bgPastRdInfo.setModifyDate(resultSet.getDate("modifyDate"));
        String userId = resultSet.getString("modifier");
        UserInfo user = null;
        if (BgDaHelper.isValidIdString(userId)) {
            Object u = cache.get(userId);
            if (u != null) {
                user = (UserInfo)u;
            } else {
                user = new UserInfo();
                user.setId(BOSUuid.read((String)userId));
                user.setName(resultSet.getString("user_name"));
                cache.put(userId, user);
            }
            bgPastRdInfo.setModifier(user);
        }
        return bgPastRdInfo;
    }

    private BgPastDataInfo generatePlainBgPtData(ResultSet resultSet, Map cache) throws SQLException {
        BgPastDataInfo bgPtDtInfo = null;
        String bgPtDtId = resultSet.getString("bgPastData_id");
        if (BgDaHelper.isValidIdString(bgPtDtId)) {
            Object d = cache.get(bgPtDtId);
            if (d != null) {
                bgPtDtInfo = (BgPastDataInfo)d;
            } else {
                bgPtDtInfo = new BgPastDataInfo();
                bgPtDtInfo.setId(BOSUuid.read((String)bgPtDtId));
                bgPtDtInfo.setPastValue(resultSet.getBigDecimal("bgPastData_pastValue"));
                bgPtDtInfo.setBalance(resultSet.getBigDecimal("bgPastData_balance"));
                bgPtDtInfo.setInt("dataSource", resultSet.getInt("bgPastData_dataSource"));
                String bgDataId = resultSet.getString("bgPastData_bgData");
                if (BgDaHelper.isValidIdString(bgDataId)) {
                    Object data = cache.get(bgDataId);
                    BgDataInfo bgDataInfo = null;
                    if (data != null) {
                        bgDataInfo = (BgDataInfo)data;
                    } else {
                        bgDataInfo = new BgDataInfo();
                        bgDataInfo.setId(BOSUuid.read((String)bgDataId));
                    }
                    bgPtDtInfo.setBgData(bgDataInfo);
                    cache.put(bgDataId, bgDataInfo);
                }
            }
            cache.put(bgPtDtId, bgPtDtInfo);
        }
        return bgPtDtInfo;
    }

    private BgFormLogCollection getBgFormLogCByBgFormId(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IBgFormLog iBgFormLog = BgFormLogFactory.getLocalInstance(ctx);
        BgFormLogCollection bgFormLogCollection = iBgFormLog.getCollectionByBgFormId(BOSUuid.read((String)pk.toString()));
        return bgFormLogCollection;
    }

    private BgPostilCollection getBgPostilCByBgFormId(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IBgPostil iBgPostil = BgPostilFactory.getLocalInstance(ctx);
        BgPostilCollection bgPostilCollection = iBgPostil.getCollectionByBgFormId(pk);
        return bgPostilCollection;
    }

    @Override
    protected void _updateBgFormStatus(Context ctx, IObjectPK bgFormId, BgFormStateEnum bgFormStatus) throws BOSException, EASBizException {
        if (ctx == null) {
            return;
        }
        PreparedStatement ps = null;
        Connection conn = null;
        StringBuffer strSql = new StringBuffer();
        strSql.append("update T_BG_BgForm set FState=?");
        strSql.append(" where FId = ?");
        conn = this.getConnection(ctx);
        try {
            ps = conn.prepareStatement(strSql.toString());
            strSql = null;
            ps.setInt(1, bgFormStatus.getValue());
            ps.setString(2, bgFormId.toString());
            ps.execute();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)ps, (Connection)conn);
        }
    }

    protected FullOrgUnitCollection getOrgs(Context ctx, OrgViewType orgViewType) throws BOSException, EASBizException {
        IOrgStructure iOrgStru = OrgStructureFactory.getLocalInstance((Context)ctx);
        IFullOrgUnit iFullOrg = FullOrgUnitFactory.getLocalInstance((Context)ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("tree.type", (Object)new Integer(orgViewType.getValue())));
        viewInfo.setFilter(fi);
        SelectorItemCollection itemColl = this.getUnitSelector();
        viewInfo.getSelector().addObjectCollection((IObjectCollection)itemColl);
        OrgStructureCollection orgStruColl = iOrgStru.getOrgStructureCollection(viewInfo);
        if (orgStruColl == null || orgStruColl.size() == 0) {
            return null;
        }
        FullOrgUnitCollection orgColl = new FullOrgUnitCollection();
        for (int i = 0; i < orgStruColl.size(); ++i) {
            FullOrgUnitInfo orgInfo = orgStruColl.get(i).getUnit();
            orgColl.add(orgInfo);
        }
        return orgColl;
    }

    private SelectorItemCollection getUnitSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("unit.isGrouping"));
        sic.add(new SelectorItemInfo("unit.effectDate"));
        sic.add(new SelectorItemInfo("unit.invalidDate"));
        sic.add(new SelectorItemInfo("unit.isFreeze"));
        sic.add(new SelectorItemInfo("unit.isCompanyOrgUnit"));
        sic.add(new SelectorItemInfo("unit.isAdminOrgUnit"));
        sic.add(new SelectorItemInfo("unit.isSaleOrgUnit"));
        sic.add(new SelectorItemInfo("unit.isPurchaseOrgUnit"));
        sic.add(new SelectorItemInfo("unit.isStorageOrgUnit"));
        sic.add(new SelectorItemInfo("unit.isProfitOrgUnit"));
        sic.add(new SelectorItemInfo("unit.isCostOrgUnit"));
        sic.add(new SelectorItemInfo("unit.isCU"));
        sic.add(new SelectorItemInfo("unit.isLeaf"));
        sic.add(new SelectorItemInfo("unit.level"));
        sic.add(new SelectorItemInfo("unit.longNumber"));
        sic.add(new SelectorItemInfo("unit.name"));
        sic.add(new SelectorItemInfo("unit.number"));
        sic.add(new SelectorItemInfo("unit.description"));
        sic.add(new SelectorItemInfo("unit.simpleName"));
        sic.add(new SelectorItemInfo("unit.createTime"));
        sic.add(new SelectorItemInfo("unit.lastUpdateTime"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("id"));
        return sic;
    }

    @Override
    protected Hashtable _getBgFormCByOrgViewType(Context ctx, IObjectPK bgSchemeId, IObjectPK bgTypeId, OrgViewType orgViewType) throws BOSException, EASBizException {
        Hashtable<String, BgFormInfo> hash = new Hashtable<String, BgFormInfo>();
        if (bgSchemeId == null || bgTypeId == null) {
            return hash;
        }
        IOrgView iOrgView = OrgViewFactory.getLocalInstance((Context)ctx);
        FullOrgUnitCollection orgUnitC = this.getOrgs(ctx, orgViewType);
        int size = orgUnitC.size();
        StringBuffer strBuffId = new StringBuffer(1000);
        for (int i = 0; i < size; ++i) {
            FullOrgUnitInfo orgUnit = orgUnitC.get(i);
            strBuffId.append("'");
            strBuffId.append(orgUnit.getId().toString());
            if (i == size - 1) {
                strBuffId.append("'");
                continue;
            }
            strBuffId.append("',");
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection conn = this.getConnection(ctx);
        Locale locale = ctx.getLocale();
        StringBuffer strSql = new StringBuffer(1500);
        strSql.append("Select FBg.fid AS fid, FBg.fnumber AS fnumber, FBg.fname AS fname, FBg.fstate AS fstate, FOrg.Fid AS ForgId, FOrg.Fname_");
        strSql.append(locale);
        strSql.append(" AS ForgName, FOrg.fnumber AS ForgNumber from T_BG_BgForm FBg, T_Org_BaseUnit FOrg where FBg.FOrgUnitId=FOrg.FId and FBg.fbgschemeId =?");
        strSql.append(" and FBg.FbgTypeId=?");
        strSql.append(" and FBg.forgUnitid in (");
        strSql.append(strBuffId);
        strSql.append(") and FBg.fstate in(1, 2,7,8,9,10,11,12, 13)");
        try {
            ps = conn.prepareStatement(strSql.toString());
            ps.setString(1, bgSchemeId.toString());
            ps.setString(2, bgTypeId.toString());
            rs = ps.executeQuery();
            strBuffId = null;
            strSql = null;
            while (rs.next()) {
                String strFId = rs.getString("fid");
                BgFormInfo bgForm = new BgFormInfo();
                bgForm.setId(BOSUuid.read((String)strFId));
                String strNumber = rs.getString("fnumber");
                bgForm.setNumber(strNumber);
                String strName = rs.getString("fname");
                bgForm.setName(strName);
                bgForm.setState(BgFormStateEnum.getEnum(rs.getInt("fstate")));
                String strOrgId = rs.getString("ForgId");
                if (strOrgId != null) {
                    FullOrgUnitInfo org = new FullOrgUnitInfo();
                    org.setId(BOSUuid.read((String)strOrgId));
                    org.setName(rs.getString("ForgName"));
                    org.setNumber(rs.getString("ForgNumber"));
                    bgForm.setOrgUnit(org);
                }
                hash.put(strOrgId, bgForm);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return hash;
    }

    @Override
    protected IObjectCollection _getCollectionForDeclare(Context ctx, IObjectPK pk, IObjectCollection subOrgs, boolean autoCreated) throws BOSException, EASBizException {
        BgFormCollection bgFormCollection = new BgFormCollection();
        BgFormInfo upperFormInfo = this.getFormForEditForDistribute(ctx, pk);
        bgFormCollection.add(upperFormInfo);
        BgTypeInfo bgTypeInfo = upperFormInfo.getBgType();
        BgTemplateInfo bgTpInfo = upperFormInfo.getBgTemplate();
        String upperBgSchemeId = upperFormInfo.getBgScheme().getId().toString();
        Iterator iter = subOrgs.iterator();
        String orgUnitId = null;
        while (iter.hasNext()) {
            BgFormInfo tmpBgFormInfo;
            orgUnitId = ((FullOrgUnitInfo)iter.next()).getId().toString();
            String schemeId = this.getMatchedBgScheme(ctx, upperBgSchemeId, orgUnitId);
            if (schemeId == null) {
                schemeId = upperBgSchemeId;
            }
            if ((tmpBgFormInfo = this.matchFormWithUpperTemplateForDeclare(ctx, bgTypeInfo.getId().toString(), orgUnitId, schemeId, autoCreated)) == null) continue;
            bgFormCollection.add(tmpBgFormInfo);
        }
        return bgFormCollection;
    }

    @Override
    protected IObjectCollection _getCollectionForDistribute(Context ctx, IObjectPK pk, IObjectCollection subOrgs, boolean autoCreated) throws BOSException, EASBizException {
        BgFormCollection bgFormCollection = new BgFormCollection();
        BgFormInfo upperFormInfo = this.getFormForEditForDistribute(ctx, pk);
        bgFormCollection.add(upperFormInfo);
        BgTypeInfo bgTypeInfo = upperFormInfo.getBgType();
        BgTemplateInfo bgTpInfo = upperFormInfo.getBgTemplate();
        BgSchemeInfo bgSchemeInfo = upperFormInfo.getBgScheme();
        IBgScheme iBgScheme = BgSchemeFactory.getLocalInstance(ctx);
        bgSchemeInfo = iBgScheme.getBgSchemeInfo((IObjectPK)new ObjectUuidPK(bgSchemeInfo.getId()), BgSchemeHelper.getPeriodSelectors());
        for (FullOrgUnitInfo orgInfo : subOrgs) {
            BgFormInfo tmpBgFormInfo = this.matchFormWithUpperTemplateForDistribute(ctx, bgTypeInfo.getId().toString(), orgInfo, bgSchemeInfo, bgTpInfo, autoCreated);
            if (tmpBgFormInfo == null) continue;
            bgFormCollection.add(tmpBgFormInfo);
        }
        return bgFormCollection;
    }

    @Override
    protected IObjectCollection _getBgEntryCollection(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        Connection conn = null;
        BgEntryCollection bgEntryColl = null;
        HashMap cache = new HashMap();
        try {
            conn = this.getConnection(ctx);
            bgEntryColl = this.getBgEntryCollection(ctx, conn, pk, cache);
        }
        catch (SQLDataException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return bgEntryColl;
    }

    @Override
    protected IObjectValue _getBgFormForDis(Context ctx, String bgTypeId, IObjectValue orgInfo, IObjectValue bgSchemeInfo, IObjectValue bgTpInfo) throws BOSException, EASBizException {
        BgFormInfo tmpBgFormInfo = this.matchFormWithUpperTemplateForDistribute(ctx, bgTypeId, (FullOrgUnitInfo)orgInfo, (BgSchemeInfo)bgSchemeInfo, (BgTemplateInfo)bgTpInfo, true);
        return tmpBgFormInfo;
    }

    @Override
    protected IObjectValue _getBgFormForDecl(Context ctx, String bgTypeId, String orgUnitId, String bgSchemeId) throws BOSException, EASBizException {
        String schemeId = this.getMatchedBgScheme(ctx, bgSchemeId, orgUnitId);
        if (schemeId == null) {
            schemeId = bgSchemeId;
        }
        BgFormInfo tmpBgFormInfo = this.matchFormWithUpperTemplateForDeclare(ctx, bgTypeId, orgUnitId, schemeId, true);
        return tmpBgFormInfo;
    }

    @Override
    protected IObjectValue _getBgFormForDecalre(Context ctx, IObjectPK pk, IObjectCollection fouColl) throws BOSException, EASBizException {
        FullOrgUnitCollection inOrgs = (FullOrgUnitCollection)fouColl;
        BgFormInfo bgFormInfoTotal = (BgFormInfo)this._getFormForEdit(ctx, pk);
        HashMap mapTotal = bgFormInfoTotal.reassembleBgForm1();
        Object[] vecMapData = mapTotal.values().toArray();
        for (int i = 0; i < vecMapData.length; ++i) {
            HashMap mapData = (HashMap)vecMapData[i];
            Object[] vecData = mapData.values().toArray();
            for (int j = 0; j < vecData.length; ++j) {
                BgDataInfo dataInfo = (BgDataInfo)vecData[j];
                dataInfo.setBgValue(new BigDecimal("0"));
            }
        }
        int cycleTotal = bgFormInfoTotal.getBgTemplate().getBgCycle().getValue();
        int m = inOrgs.size();
        for (int i = 0; i < m; ++i) {
            FullOrgUnitInfo orgInfo = inOrgs.get(i);
            BgFormInfo subBgFormInfo = (BgFormInfo)this._getBgFormForDecl(ctx, bgFormInfoTotal.getBgType().getId().toString(), orgInfo.getId().toString(), bgFormInfoTotal.getBgScheme().getId().toString());
            if (subBgFormInfo == null) continue;
            int cycleSub = subBgFormInfo.getBgTemplate().getBgCycle().getValue();
            HashMap mapSub = subBgFormInfo.reassembleBgForm1();
            Object[] vecEntryKey = mapTotal.keySet().toArray();
            for (int j = 0; j < vecEntryKey.length; ++j) {
                Object entryKey = vecEntryKey[j];
                HashMap mapDataTotal = (HashMap)mapTotal.get(entryKey);
                HashMap mapDataSub = (HashMap)mapSub.get(entryKey);
                if (mapDataTotal == null || mapDataSub == null) continue;
                Object[] vecDataKey = mapDataTotal.keySet().toArray();
                for (int k = 0; k < vecDataKey.length; ++k) {
                    Object dataKey = vecDataKey[k];
                    BgDataInfo dataInfoTotal = (BgDataInfo)mapDataTotal.get(dataKey);
                    BgDataInfo dataInfoSub = (BgDataInfo)mapDataSub.get(dataKey);
                    if (dataInfoTotal == null || dataInfoSub == null) continue;
                    dataInfoTotal.setBgValue(dataInfoTotal.getBgValue().add(dataInfoSub.getBgValue()));
                }
            }
            if (cycleTotal == cycleSub) continue;
            String tempId = "";
            for (int j = 0; j < vecEntryKey.length; ++j) {
                BgDataInfo dataInfoSub;
                BgDataInfo dataInfoTotal;
                Object dataKey;
                int k;
                Object[] vecDataKey;
                HashMap mapDataSub;
                HashMap mapDataTotal;
                String subEntryKey;
                int y;
                int n;
                Vector periodVec;
                String periodId;
                Object entryKey = vecEntryKey[j];
                if (((String)entryKey).substring(0, 1).equals("2") && cycleTotal == 2) {
                    periodId = ((String)entryKey).substring(1, 45);
                    periodVec = this._getPeriodIds(ctx, periodId, 2);
                    n = periodVec.size();
                    for (y = 0; y < n; ++y) {
                        tempId = (String)periodVec.get(y);
                        subEntryKey = "3" + tempId + ((String)entryKey).substring(45);
                        mapDataTotal = (HashMap)mapTotal.get(entryKey);
                        mapDataSub = (HashMap)mapSub.get(subEntryKey);
                        if (mapDataTotal == null || mapDataSub == null) continue;
                        vecDataKey = mapDataTotal.keySet().toArray();
                        for (k = 0; k < vecDataKey.length; ++k) {
                            dataKey = vecDataKey[k];
                            dataInfoTotal = (BgDataInfo)mapDataTotal.get(dataKey);
                            dataInfoSub = (BgDataInfo)mapDataSub.get(dataKey);
                            if (dataInfoTotal == null || dataInfoSub == null) continue;
                            dataInfoTotal.setBgValue(dataInfoTotal.getBgValue().add(dataInfoSub.getBgValue()));
                        }
                    }
                    continue;
                }
                if (!((String)entryKey).substring(0, 1).equals("1") || cycleTotal != 1) continue;
                periodId = ((String)entryKey).substring(1, 45);
                periodVec = this._getPeriodIds(ctx, periodId, 1);
                n = periodVec.size();
                for (y = 0; y < n; ++y) {
                    tempId = (String)periodVec.get(y);
                    subEntryKey = "2" + tempId + ((String)entryKey).substring(45);
                    mapDataTotal = (HashMap)mapTotal.get(entryKey);
                    mapDataSub = (HashMap)mapSub.get(subEntryKey);
                    if (mapDataTotal == null || mapDataSub == null) continue;
                    vecDataKey = mapDataTotal.keySet().toArray();
                    for (k = 0; k < vecDataKey.length; ++k) {
                        dataKey = vecDataKey[k];
                        dataInfoTotal = (BgDataInfo)mapDataTotal.get(dataKey);
                        dataInfoSub = (BgDataInfo)mapDataSub.get(dataKey);
                        if (dataInfoTotal == null || dataInfoSub == null) continue;
                        dataInfoTotal.setBgValue(dataInfoTotal.getBgValue().add(dataInfoSub.getBgValue()));
                    }
                }
            }
        }
        return bgFormInfoTotal;
    }

    @Override
    protected IObjectValue _getBgFormForDis2(Context ctx, String bgTypeId, IObjectValue orgInfo, IObjectValue bgSchemeInfo, IObjectValue bgTpInfo) throws BOSException, EASBizException {
        BgFormInfo tmpBgFormInfo = this.matchFormWithUpperTemplateForDistribute2(ctx, bgTypeId, (FullOrgUnitInfo)orgInfo, (BgSchemeInfo)bgSchemeInfo, (BgTemplateInfo)bgTpInfo, true);
        return tmpBgFormInfo;
    }

    @Override
    protected Vector _getPeriodIds(Context ctx, String periodId, int bgCycle) throws BOSException, EASBizException {
        Vector<String> result = new Vector<String>();
        String sql = "";
        if (bgCycle == 1) {
            sql = " select fid from t_bd_period where  fperiodyear in ( select fperiodyear from t_bd_period where fid = ? ) and  ftypeid in ( select ftypeid from t_bd_period where fid = ? )";
        } else if (bgCycle == 2) {
            sql = " select fid from t_bd_period where  fperiodyear in ( select fperiodyear from t_bd_period where fid = ? ) and  fperiodquarter in ( select fperiodquarter from t_bd_period where fid = ? ) and  ftypeid in ( select ftypeid from t_bd_period where fid = ? )";
        } else {
            throw new BOSException("\u9519\u8bef");
        }
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        boolean count = false;
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sql);
            if (bgCycle == 1) {
                ps.setString(1, periodId);
                ps.setString(2, periodId);
            } else {
                ps.setString(1, periodId);
                ps.setString(2, periodId);
                ps.setString(3, periodId);
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                result.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            try {
                throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return result;
    }

    @Override
    protected IObjectValue _getFormHeadInfo(Context ctx, String bgFormId) throws BOSException, EASBizException {
        if (sqlFor_getSingForm == null) {
            StringBuffer sb = new StringBuffer(5000);
            sb.append("SELECT T_BG_BgForm.FID, T_BG_BgForm.FNumber, T_BG_BgForm.FName,");
            sb.append("T_BG_BgForm.FCreatorID, T_BG_BgForm.FCreateTime, ");
            sb.append("T_BG_BgForm.FBgTemplateID, T_BG_BgForm.FBgTypeID, ");
            sb.append("T_BG_BgForm.FPeriodFromID, T_BG_BgForm.FPeriodToID, ");
            sb.append("T_BG_BgForm.FOrgUnitID, T_BG_BgForm.FBgRptTemplateID, ");
            sb.append("T_BG_BgForm.FDataSource,");
            sb.append("T_BG_BgForm.FSTATE,");
            sb.append("T_BG_BgForm.FLastUpdateUserID,");
            sb.append("T_BG_BgForm.FLastUpdateTime,");
            sb.append("T_BG_BgForm.FCompanyID,");
            sb.append("T_BG_BgForm.FBgSchemeID, T_BG_BgScheme.FNumber AS bgScheme_number,");
            sb.append("T_BG_BgScheme.FName AS bgScheme_name, ");
            sb.append("T_BG_BgScheme.FIsFormal AS bgScheme_isFormal, ");
            sb.append("T_BD_Period_From.FPeriodYear periodFrom_year, T_BD_Period_From.FPeriodQuarter periodFrom_quarter,T_BD_Period_From.FPeriodNumber periodFrom_number,");
            sb.append("T_BD_Period_From.FID AS periodFrom_id,T_BD_Period_From.FBeginDate periodFrom_beginDate,T_BD_Period_From.FEndDate periodFrom_endDate,");
            sb.append("T_BD_Period_To.FPeriodYear periodTo_year, T_BD_Period_To.FPeriodQuarter periodTo_quarter,T_BD_Period_To.FPeriodNumber periodTo_number,");
            sb.append("T_BD_Period_To.FID AS periodTo_id,T_BD_Period_To.FBeginDate periodTo_beginDate,T_BD_Period_To.FEndDate periodTo_endDate,");
            sb.append("LastUpdateUser.FNumber AS lastUpdateUser_number,");
            sb.append("LastUpdateUser.FName_@L@ AS lastUpdateUser_name,");
            sb.append("T_PM_User.FNumber AS creator_number,");
            sb.append("T_PM_User.FName_@L@ AS creator_name,");
            sb.append("T_PM_User.FID AS creator_id,");
            sb.append("T_ORG_BaseUnit.FID AS orgUnit_id,");
            sb.append("T_ORG_BaseUnit.FNumber AS orgUnit_number,");
            sb.append("T_ORG_BaseUnit.FName_@L@ AS orgUnit_name,");
            sb.append("T_BG_BgType.FID AS bgType_id,");
            sb.append("T_BG_BgType.FNumber AS bgType_number,");
            sb.append("T_BG_BgType.FName_@L@ AS bgType_name, ");
            sb.append("T_BG_BgType.FIsRptBgForm AS bgType_isRptBgForm ");
            sb.append(" FROM T_BG_BgForm ");
            sb.append(" INNER JOIN T_BG_BgScheme ON T_BG_BgForm.FBgSchemeID = T_BG_BgScheme.FID");
            sb.append(" LEFT OUTER JOIN T_PM_User ON T_BG_BgForm.FCreatorID = T_PM_User.FID");
            sb.append(" LEFT OUTER JOIN T_PM_User AS LastUpdateUser ON T_BG_BgForm.FLastUpdateUserID = LastUpdateUser.FID");
            sb.append(" INNER JOIN T_ORG_BaseUnit ON T_BG_BgForm.FOrgUnitID = T_ORG_BaseUnit.FID");
            sb.append(" INNER JOIN T_BD_Period T_BD_Period_From ON T_BG_BgForm.FPeriodFromID = T_BD_Period_From.FID ");
            sb.append(" INNER JOIN T_BD_Period T_BD_Period_To ON T_BG_BgForm.FPeriodToID = T_BD_Period_To.FID ");
            sb.append(" INNER JOIN T_BG_BgType ON T_BG_BgForm.FBgTypeID = T_BG_BgType.FID");
            sb.append(" WHERE T_BG_BgForm.FID = ?");
            sqlFor_getSingForm = sb;
        }
        Connection conn = this.getConnection(ctx);
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        BgFormInfo bgFormInfo = null;
        HashMap cache = new HashMap();
        try {
            stmt = conn.prepareStatement(BgDaHelper.convert(ctx, sqlFor_getSingForm.toString()));
            stmt.setString(1, bgFormId);
            resultSet = stmt.executeQuery();
            if (resultSet.next()) {
                bgFormInfo = this.generatePlainBgForm(resultSet);
            }
        }
        catch (SQLException e) {
            try {
                System.out.println("get bg bgform!");
                e.printStackTrace();
                throw new EASBizException(BgBizException.GETDATA, (Throwable)e, new Object[]{"BgForm"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(resultSet, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)resultSet, (Statement)stmt, (Connection)conn);
        return bgFormInfo;
    }

    @Override
    protected IObjectCollection _getBgItemC(Context ctx, String bgFormId, int index) throws BOSException, EASBizException {
        String sql = " select distinct  a.fid, a.fname_l2, a.fnumber, a.flongnumber,  a.fitemid, a.fitemnumber, a.fitemname_l2 from t_bg_bgitem a ,t_bg_bgentry b  where a.fid = b.fbgitem" + index + "id and b.fbgformid = ? order by a.flongnumber ";
        Connection conn = this.getConnection(ctx);
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        BgItemCollection bgItemC = new BgItemCollection();
        try {
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, bgFormId);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                BgItemInfo bgItemInfo = this.generateBgItem(resultSet);
                bgItemC.add(bgItemInfo);
            }
        }
        catch (SQLException e) {
            try {
                System.out.println("get bg bgform!");
                logger.debug((Object)e);
                throw new EASBizException(BgBizException.GETDATA, (Throwable)e, new Object[]{"BgForm"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(resultSet, (Statement)stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)resultSet, (Statement)stmt, (Connection)conn);
        return bgItemC;
    }

    private BgItemInfo generateBgItem(ResultSet rs) throws SQLException {
        BgItemInfo bgItemInfo = new BgItemInfo();
        String id = rs.getString("fid");
        String name = rs.getString("fname_l2") == null ? "" : rs.getString("fname_l2");
        String number = rs.getString("fnumber") == null ? "" : rs.getString("fnumber");
        String longNumber = rs.getString("flongnumber") == null ? "" : rs.getString("flongnumber");
        String itemId = rs.getString("fitemid") == null ? "" : rs.getString("fitemid");
        String itemNumber = rs.getString("fitemnumber") == null ? "" : rs.getString("fitemnumber");
        String itemName = rs.getString("fitemname_l2") == null ? "" : rs.getString("fitemname_l2");
        bgItemInfo.setId(BOSUuid.read((String)id));
        bgItemInfo.setName(name);
        bgItemInfo.setNumber(number);
        bgItemInfo.setLongNumber(longNumber);
        bgItemInfo.setItemID(BOSUuid.read((String)itemId));
        bgItemInfo.setItemName(itemName);
        bgItemInfo.setItemNumber(itemNumber);
        return bgItemInfo;
    }
}

