/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgFormDAFactory;
import com.kingdee.eas.ma.bg.BgFormInfo;
import com.kingdee.eas.ma.bg.BgFormQuerySchemaFactory;
import com.kingdee.eas.ma.bg.BgFormQuerySchemaInfo;
import com.kingdee.eas.ma.bg.BgInstantApproveException;
import com.kingdee.eas.ma.bg.IBgFormDA;
import com.kingdee.eas.ma.bg.IBgFormQuerySchema;
import com.kingdee.eas.ma.bg.app.AbstractBgFormQuerySchemaControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class BgFormQuerySchemaControllerBean
extends AbstractBgFormQuerySchemaControllerBean {
    @Override
    protected List _getBgForm(Context ctx, BOSUuid bgQuerySchemeId) throws BOSException, EASBizException {
        if (bgQuerySchemeId == null) {
            throw new IllegalArgumentException("Argumen is null");
        }
        BgFormQuerySchemaInfo info = this.getQuerySchemaInfo(ctx, bgQuerySchemeId);
        return this._getBgForm(ctx, info);
    }

    @Override
    protected List _getBgForm(Context ctx, BgFormQuerySchemaInfo querySchemaInfo) throws BOSException, EASBizException {
        if (querySchemaInfo == null) {
            throw new IllegalArgumentException("Argumen is null");
        }
        List lstBgFormId = this.getBgFormIdList(ctx, querySchemaInfo);
        List lstBgForm = this.getBgForms(ctx, lstBgFormId);
        return lstBgForm;
    }

    private List getBgForms(Context ctx, List lstBgFormId) throws BOSException, EASBizException {
        ArrayList<BgFormInfo> lstBgForm = new ArrayList<BgFormInfo>(6);
        IBgFormDA bgForm = BgFormDAFactory.getLocalInstance(ctx);
        int size = lstBgFormId.size();
        for (int i = 0; i < size; ++i) {
            String id = lstBgFormId.get(i).toString();
            BgFormInfo formInfo = bgForm.getFormForEdit((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
            lstBgForm.add(formInfo);
        }
        return lstBgForm;
    }

    private String generateCondition(BgFormQuerySchemaInfo info) throws BOSException, EASBizException {
        StringBuffer buff = new StringBuffer(512);
        String head = "select a.fid from t_bg_bgform a,t_bg_bgscheme b where ";
        String unitCond = this.generateFieldCondition("a.FOrgUnitID", info.getOrgunit(), ",");
        String bgTypeIds = this.getBgTypeIds(info.getBgtype());
        String bgTypeCond = this.generateFieldCondition("FBgTypeID", bgTypeIds, ",");
        String stateCond = " (FState <> 4 and FState <> 5) ";
        String[] schemes = info.getBgschema().split(",");
        String schemeCond = " (a.fbgschemeid = '" + schemes[0] + "' or b.fname like '" + schemes[1] + "_%')";
        String joinCond = "( a.fbgschemeid = b.fid)";
        buff.append(head);
        buff.append(unitCond);
        buff.append(" and ");
        buff.append(bgTypeCond);
        buff.append(" and ");
        buff.append(stateCond);
        buff.append(" and ");
        buff.append(schemeCond);
        buff.append(" and ");
        buff.append(joinCond);
        return buff.toString();
    }

    private BgFormQuerySchemaInfo getQuerySchemaInfo(Context ctx, BOSUuid bgQuerySchemeId) throws BOSException, EASBizException {
        IBgFormQuerySchema querySchema = BgFormQuerySchemaFactory.getLocalInstance(ctx);
        ObjectUuidPK pk = new ObjectUuidPK(bgQuerySchemeId);
        BgFormQuerySchemaInfo info = querySchema.getBgFormQuerySchemaInfo((IObjectPK)pk);
        return info;
    }

    private List getBgFormIdList(Context ctx, BgFormQuerySchemaInfo info) throws BOSException, EASBizException {
        ArrayList<String> lst = new ArrayList<String>(6);
        String sql = this.generateCondition(info);
        Connection cn = this.getConnection(ctx);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = cn.prepareStatement(sql);
            System.out.println("sql:" + sql);
            rs = stmt.executeQuery();
            while (rs.next()) {
                lst.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            try {
                throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
        return lst;
    }

    @Override
    protected byte[] _getReportData(Context ctx, String bgQuerySchemeId, String bgType) throws BOSException, EASBizException {
        ResultSet rs;
        PreparedStatement stmt;
        Connection cn;
        byte[] data;
        block6: {
            if (bgQuerySchemeId == null || bgType == null) {
                throw new IllegalArgumentException("Argumen is null");
            }
            data = null;
            String sql = "select fdata from t_bg_bgformqsdata where FBgFormQSID='" + bgQuerySchemeId + "' and fbgtype = '" + bgType + "'";
            cn = this.getConnection(ctx);
            stmt = null;
            rs = null;
            stmt = cn.prepareStatement(sql);
            rs = stmt.executeQuery();
            if (rs.next()) break block6;
            byte[] byArray = null;
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
            return byArray;
        }
        try {
            data = rs.getBytes(1);
        }
        catch (SQLException e) {
            try {
                throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
        return data;
    }

    private String generateFieldCondition(String field, String condition, String delimiter) {
        StringBuffer buff = new StringBuffer(128);
        buff.append("(");
        StringTokenizer token = new StringTokenizer(condition, delimiter);
        while (token.hasMoreTokens()) {
            buff.append(field + "='" + token.nextToken() + "' or ");
        }
        return buff.toString().substring(0, buff.length() - 3) + ")";
    }

    private String getBgTypeIds(String ids) {
        String[] substring = ids.split(";");
        String[] typeIds = new String[substring.length];
        int n = typeIds.length;
        for (int i = 0; i < n; ++i) {
            String[] tmpstring = substring[i].split(":");
            typeIds[i] = tmpstring[0];
        }
        StringBuffer buffer = new StringBuffer(192);
        for (String element : typeIds) {
            buffer.append(element);
            buffer.append(",");
        }
        return buffer.toString().substring(0, buffer.length() - 1);
    }

    @Override
    protected void _storeReportData(Context ctx, String bgQuerySchemaId, byte[] data, String bgType) throws BOSException, EASBizException {
        if (bgQuerySchemaId == null || bgType == null || data == null) {
            throw new IllegalArgumentException("Argumen is null");
        }
        String sql = "insert into t_bg_bgformqsdata(fbgformqsid,fdata,fbgtype) values(?,?,?)";
        Connection cn = this.getConnection(ctx);
        PreparedStatement stmt = null;
        try {
            stmt = cn.prepareStatement(sql);
            stmt.setString(1, bgQuerySchemaId);
            stmt.setBytes(2, data);
            stmt.setString(3, bgType.toString());
            stmt.execute();
        }
        catch (SQLException e) {
            throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
        }
        finally {
            SQLUtils.cleanup((Statement)stmt, (Connection)cn);
        }
    }

    @Override
    protected void _deleteReportData(Context ctx, String bgQuerySchemaId, List lstBgType) throws BOSException, EASBizException {
        if (bgQuerySchemaId == null || lstBgType == null) {
            throw new IllegalArgumentException("Argumen is null");
        }
        if (lstBgType.size() == 0) {
            this.deleteReportDatas(ctx, bgQuerySchemaId);
            return;
        }
        String sql = "delete from t_bg_bgformqsdata where fbgformqsid = '" + bgQuerySchemaId + "' and fbgtype = ?";
        Connection cn = this.getConnection(ctx);
        PreparedStatement stmt = null;
        try {
            for (int i = 0; i < lstBgType.size(); ++i) {
                stmt = cn.prepareStatement(sql);
                stmt.setString(1, lstBgType.get(i).toString());
                stmt.addBatch();
            }
            if (stmt != null) {
                stmt.execute();
            }
        }
        catch (SQLException e) {
            try {
                throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
    }

    private void deleteReportDatas(Context ctx, String bgQuerySchemaId) throws BOSException, EASBizException {
        String sql = "delete from t_bg_bgformqsdata where fbgformqsid = '" + bgQuerySchemaId + "'";
        Connection cn = this.getConnection(ctx);
        PreparedStatement stmt = null;
        try {
            stmt = cn.prepareStatement(sql);
            stmt.execute();
        }
        catch (SQLException e) {
            throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
        }
        finally {
            SQLUtils.cleanup((Statement)stmt, (Connection)cn);
        }
    }

    @Override
    protected void _storeReportDatas(Context ctx, String bgQuerySchemaId, HashMap hashData) throws BOSException, EASBizException {
        if (bgQuerySchemaId == null || hashData == null || hashData.size() == 0) {
            throw new IllegalArgumentException("Argumen is null");
        }
        String sql = "insert into t_bg_bgformqsdata(fbgformqsid,fdata,fbgtype) values(?,?,?)";
        Connection cn = this.getConnection(ctx);
        PreparedStatement stmt = null;
        Iterator itor = hashData.keySet().iterator();
        try {
            while (itor.hasNext()) {
                String bgType = itor.next().toString();
                stmt = cn.prepareStatement(sql);
                stmt.setString(1, bgQuerySchemaId);
                stmt.setBytes(2, (byte[])hashData.get(bgType));
                stmt.setString(3, bgType);
                stmt.addBatch();
            }
            if (stmt != null) {
                stmt.execute();
            }
        }
        catch (SQLException e) {
            try {
                throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
    }

    @Override
    protected HashMap _getReportDatas(Context ctx, String bgQuerySchemaId) throws BOSException, EASBizException {
        if (bgQuerySchemaId == null) {
            throw new IllegalArgumentException("Argumen is null");
        }
        HashMap<String, byte[]> map = new HashMap<String, byte[]>(24);
        String sql = "select fbgtype,fdata from t_bg_bgformqsdata where FBgFormQSID='" + bgQuerySchemaId + "'";
        Connection cn = this.getConnection(ctx);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = cn.prepareStatement(sql);
            rs = stmt.executeQuery();
            while (!rs.next()) {
                String bgType = rs.getString(1);
                byte[] data = rs.getBytes(2);
                map.put(bgType, data);
            }
        }
        catch (SQLException e) {
            try {
                throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
        return map;
    }

    @Override
    protected boolean _existQueryResult(Context ctx, String bgFormQSId) throws BOSException, EASBizException {
        if (bgFormQSId == null) {
            throw new IllegalArgumentException("Argumen is null");
        }
        String sql = "select fbgformqsid from T_BG_BgFormQSData where fbgformqsid='" + bgFormQSId + "'";
        Connection cn = this.getConnection(ctx);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        boolean result = false;
        try {
            stmt = cn.prepareStatement(sql);
            rs = stmt.executeQuery();
            result = rs.next();
        }
        catch (SQLException e) {
            try {
                throw new BgInstantApproveException(BgInstantApproveException.DATABASEERROR, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
        return result;
    }
}

