/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitCommon;
import com.kingdee.eas.basedata.org.OrgUnitCommonFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgHelper;
import com.kingdee.eas.ma.bg.app.dao.BgDAO;
import java.util.List;
import org.apache.log4j.Logger;

public class BgAlyDAOBase {
    private static Logger logger = Logger.getLogger(BgAlyDAOBase.class);
    protected Context ctx = null;
    protected String locale = null;

    public String getPeriodIDs(FilterItemCollection filters) throws EASBizException, BOSException {
        int beginPeriodYear = Integer.parseInt(BgHelper.getFilterValue(filters, "beginPeriodYear").toString());
        int beginPeriodMonth = Integer.parseInt(BgHelper.getFilterValue(filters, "beginPeriodMonth").toString());
        int endPeriodYear = Integer.parseInt(BgHelper.getFilterValue(filters, "endPeriodYear").toString());
        int endPeriodMonth = Integer.parseInt(BgHelper.getFilterValue(filters, "endPeriodMonth").toString());
        List list = BgDAO.getInstant(this.ctx).getPeriodIDList(beginPeriodYear, beginPeriodMonth, endPeriodYear, endPeriodMonth, this.getCompanyAccountTypeIDs(filters));
        StringBuffer sb = new StringBuffer();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            sb.append("'").append(list.get(i)).append("',");
        }
        sb.append("''");
        return sb.toString();
    }

    public String getCompanyAccountTypeIDs(FilterItemCollection filters) {
        Object[] bizOrgUnit = (Object[])BgHelper.getFilterValue(filters, "bizOrgUnitAry");
        StringBuffer sb = new StringBuffer();
        try {
            IOrgUnitCommon orgUnitCommon = OrgUnitCommonFactory.getLocalInstance((Context)this.ctx);
            CompanyOrgUnitInfo company = null;
            int length = bizOrgUnit.length;
            for (int i = 0; i < length; ++i) {
                if (orgUnitCommon == null) continue;
                company = orgUnitCommon.getCompany(((OrgUnitInfo)bizOrgUnit[i]).getId());
                sb.append("'").append(company.getAccountPeriodType().getId()).append("',");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        sb.append("''");
        return sb.toString();
    }

    public String getFilterByBizDateSql(String tableName, boolean filterByBizDate) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT BgCtrlDetail.FID,  BgEntry.FOrgUnitID, BgEntry.FBgTypeID, BgEntry.FPeriodID, BgEntry.FIsLeafEntry, BgElement.FBizElement, BgData.FCurrencyID, BgData.FBgValue, BgData.FBgLastBalance, BgData.FBgActual, BgData.FBgBalance, BgData.FBgUsableValue, BgCtrlDetail.FCurrencyID AS FBizCurrencyID, BgCtrlDetail.FBizDate, BgCtrlDetail.FSrcBillTypeID, BgCtrlDetail.FSrcBillNumber, BgCtrlDetail.FSrcBillID, BgCtrlDetail.FBgAuditStyle, BgCtrlDetail.FBizData0, BgCtrlDetail.FBizData1, BgCtrlDetail.FBizData2, BgCtrlDetail.FBizData3, BgCtrlDetail.FBizData4, BgCtrlDetail.FCtrlSystem, BgEntry.FBgItem1ID, BgEntry.FBgItem2ID, BgEntry.FBgItem3ID, BgEntry.FBgItem4ID, BgEntry.FBgItem5ID, BgEntry.FBgItem6ID ");
        sb.append(" FROM T_BG_BgCtrlDetail BgCtrlDetail INNER JOIN T_BG_BgCtrlDetailEntry CtrlDetailEntry ON BgCtrlDetail.FID = CtrlDetailEntry.FBillID inner JOIN T_BG_BgData BgData INNER JOIN T_BG_BgElement BgElement ON BgData.FBgElementID = BgElement.FID inner JOIN ");
        sb.append(tableName);
        sb.append(" BgEntry ON BgData.FBgEntryID = BgEntry.FID ON CtrlDetailEntry.FBgDataID = BgData.FID");
        if (filterByBizDate) {
            sb.append(" WHERE (BgCtrlDetail.FBizDate BETWEEN ? AND ?)");
        }
        return sb.toString();
    }

    public boolean isByBizDate(FilterItemCollection filters) {
        boolean filterByBizDate = BgHelper.getFilterValue(filters, "filterByBizDate").equals(new Integer(32));
        return filterByBizDate;
    }

    public String getDisplaySql(String resultTableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ResultData.*, BgItem1.FItemID AS BgItem1ID , BgItem1.FItemNumber AS BgItem1Number , BgItem1.FItemName_");
        sb.append(this.locale);
        sb.append(" AS BgItem1Name , BgItem2.FItemID AS BgItem2ID , BgItem2.FItemNumber AS BgItem2Number , BgItem2.FItemName_");
        sb.append(this.locale);
        sb.append(" AS BgItem2Name , BgItem3.FItemID AS BgItem3ID , BgItem3.FItemNumber AS BgItem3Number , BgItem3.FItemName_");
        sb.append(this.locale);
        sb.append(" AS BgItem3Name , BgItem4.FItemID AS BgItem4ID , BgItem4.FItemNumber AS BgItem4Number , BgItem4.FItemName_");
        sb.append(this.locale);
        sb.append(" AS BgItem4Name , BgItem5.FItemID AS BgItem5ID , BgItem5.FItemNumber AS BgItem5Number , BgItem5.FItemName_");
        sb.append(this.locale);
        sb.append(" AS BgItem5Name , BgItem6.FItemID AS BgItem6ID , BgItem6.FItemNumber AS BgItem6Number , BgItem6.FItemName_");
        sb.append(this.locale);
        sb.append(" AS BgItem6Name");
        sb.append(" FROM ");
        sb.append(resultTableName);
        sb.append(" ResultData LEFT OUTER JOIN T_BG_BgItem BgItem6 ON ResultData.FBgItem6ID = BgItem6.FID LEFT OUTER JOIN T_BG_BgItem BgItem5 ON ResultData.FBgItem5ID =BgItem5.FID LEFT OUTER JOIN T_BG_BgItem BgItem4 ON ResultData.FBgItem4ID =BgItem4.FID LEFT OUTER JOIN T_BG_BgItem BgItem3 ON ResultData.FBgItem3ID =BgItem3.FID LEFT OUTER JOIN T_BG_BgItem BgItem2 ON ResultData.FBgItem2ID =BgItem2.FID LEFT OUTER JOIN T_BG_BgItem BgItem1 ON ResultData.FBgItem1ID =BgItem1.FID  Order by FOrgUnitID, FBgTypeID,FDispPeriod, BgItem1Number, BgItem2Number, BgItem3Number, BgItem4Number, BgItem5Number, BgItem6Number, ResultData.FID");
        return sb.toString();
    }

    public String getFilterBalanceByBizDateSql(String tableName, boolean filterByBizDate) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT BgEntry.FID,  BgEntry.FOrgUnitID, BgEntry.FBgTypeID, BgEntry.FPeriodID, Period.FPeriodYear * 100 + Period.FPeriodNumber AS periodSeq, BgElement.FBizElement, BgData.FCurrencyID, BgData.FBgValue, BgData.FBgLastBalance, BgData.FBgActual, BgData.FBizActual, BgData.FBgInitialValue, BgData.FBgBalance, BgData.FBgUsableValue, BgCtrlDetail.FCurrencyID AS FBizCurrencyID, BgCtrlDetail.FBizDate, BgCtrlDetail.FSrcBillTypeID, BgCtrlDetail.FSrcBillNumber, BgCtrlDetail.FSrcBillID, BgCtrlDetail.FBizData0, BgCtrlDetail.FBizData1, BgCtrlDetail.FBizData2, BgCtrlDetail.FBizData3, BgCtrlDetail.FBizData4, BgCtrlDetail.FCtrlSystem, BgEntry.FBgItem1ID, BgEntry.FBgItem2ID, BgEntry.FBgItem3ID, BgEntry.FBgItem4ID, BgEntry.FBgItem5ID, BgEntry.FBgItem6ID ");
        sb.append(" FROM T_BG_BgCtrlDetail BgCtrlDetail INNER JOIN T_BG_BgCtrlDetailEntry CtrlDetailEntry ON BgCtrlDetail.FID = CtrlDetailEntry.FBillID  RIGHT OUTER JOIN T_BG_BgData BgData INNER JOIN T_BG_BgElement BgElement ON BgData.FBgElementID = BgElement.FID inner JOIN ").append(tableName).append(" BgEntry ON BgData.FBgEntryID = BgEntry.FID ON CtrlDetailEntry.FBgDataID = BgData.FID INNER JOIN T_BD_Period Period ON Period.FID = BgEntry.FPeriodID");
        if (filterByBizDate) {
            sb.append(" WHERE (BgCtrlDetail.FBizDate BETWEEN ? AND ?)");
        }
        return sb.toString();
    }

    public String getFilterBgTypeOrgPeriodSql(FilterItemCollection filters, boolean filterByBizDate) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT FID, FOrgUnitID, FBgTypeID, FPeriodID, FIsLeafEntry, FBgItem1ID, FBgItem2ID, FBgItem3ID, FBgItem4ID, FBgItem5ID, FBgItem6ID FROM V_BG_BgEntry");
        if (filterByBizDate) {
            sb.append(" WHERE  (FOrgUnitID IN (").append(BgHelper.getFilterValue(filters, "bizOrgUnitIDs")).append(")  AND (FBgTypeID = ?) AND (FEndDate  > ?) AND  (FBeginDate < ?))");
        } else {
            sb.append(" WHERE  (FOrgUnitID IN (").append(BgHelper.getFilterValue(filters, "bizOrgUnitIDs")).append(") ").append(" AND (FBgTypeID = ?) AND (FPeriodYear*100+FPeriodNumber  BETWEEN ? AND ?)) ");
        }
        return sb.toString();
    }
}

