/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgBizException;
import com.kingdee.eas.ma.bg.BgHelper;
import com.kingdee.eas.ma.bg.DisplayPeriodStyleEnum;
import com.kingdee.eas.ma.bg.app.dao.BgAlyDAOBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class BgSchemeAlyDAO
extends BgAlyDAOBase {
    protected BgSchemeAlyDAO() {
    }

    public static BgSchemeAlyDAO getInstance(Context ctx) {
        BgSchemeAlyDAO dao = new BgSchemeAlyDAO();
        dao.ctx = ctx;
        dao.locale = ctx.getLocale().toString();
        return dao;
    }

    protected Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    public IRowSet getResult(EntityViewInfo ev) throws EASBizException, BgBizException, BOSException {
        FilterItemCollection filters = ev.getFilter().getFilterItems();
        StringBuffer sb = new StringBuffer();
        boolean filterByBizDate = this.isByBizDate(filters);
        Integer dispPeriod = (Integer)BgHelper.getFilterValue(filters, "displayPeriodStyle");
        String tableName1 = BgHelper.getTableName(this.ctx);
        String tableName2 = BgHelper.getTableName(this.ctx);
        String sbCreateTable1 = this.getCreateSql1(tableName1);
        String sbInsertTable1 = this.getInsertSql1(filters, filterByBizDate, tableName1, dispPeriod);
        String sbCreateTable2 = this.getCreateSql2(tableName2);
        String sbInsertTable2 = this.getInsertSql2(filterByBizDate, dispPeriod, tableName1, tableName2);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        JdbcRowSet result = null;
        Connection conn = this.getConnection(this.ctx);
        try {
            stmt = conn.prepareStatement(sbCreateTable1);
            stmt.execute();
            SQLUtils.cleanup((Statement)stmt);
            stmt = conn.prepareStatement(sbInsertTable1);
            this.setParams1(filters, filterByBizDate, stmt);
            stmt.execute();
            SQLUtils.cleanup((Statement)stmt);
            stmt = conn.prepareStatement(sbCreateTable2);
            stmt.execute();
            stmt = conn.prepareStatement(sbInsertTable2);
            this.setParams2(filters, filterByBizDate, stmt);
            stmt.execute();
            String sql = this.getDisplaySql4SameScheme(tableName2);
            stmt = conn.prepareStatement(sql);
            rs = stmt.executeQuery();
            result = new JdbcRowSet();
            result.populate(rs);
        }
        catch (SQLException ex) {
            try {
                ex.printStackTrace();
                throw new BgBizException(BgBizException.BGALYRPTFETCHDATA, ex, new Object[]{"getExpBalanceRowSet"});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
                BgHelper.dropTable(this.ctx, tableName1);
                BgHelper.dropTable(this.ctx, tableName2);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        BgHelper.dropTable(this.ctx, tableName1);
        BgHelper.dropTable(this.ctx, tableName2);
        return result;
    }

    private String getDisplaySql4SameScheme(String resultTableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ResultData.*, BgItem1.FItemID AS BgItem1ID , BgItem1.FItemNumber AS BgItem1Number , BgItem1.FItemName_");
        sb.append(this.locale);
        sb.append(" AS BgItem1Name , BgItem2.FItemID AS BgItem2ID , BgItem2.FItemNumber AS BgItem2Number , BgItem2.FItemName_");
        sb.append(this.locale);
        sb.append(" AS BgItem2Name , BgItem3.FItemID AS BgItem3ID , BgItem3.FItemNumber AS BgItem3Number , BgItem3.FItemName_");
        sb.append(this.locale);
        sb.append(" AS BgItem3Name , BgItem4.FItemID AS BgItem4ID , BgItem4.FItemNumber AS BgItem4Number , BgItem4.FItemName_");
        sb.append(this.locale);
        sb.append(" AS BgItem4Name , BgItem5.FItemID AS BgItem5ID , BgItem5.FItemNumber AS BgItem5Number , BgItem5.FItemName_");
        sb.append(this.locale);
        sb.append(" AS BgItem5Name , BgItem6.FItemID AS BgItem6ID , BgItem6.FItemNumber AS BgItem6Number , BgItem6.FItemName_");
        sb.append(this.locale);
        sb.append(" AS BgItem6Name");
        sb.append(" FROM ");
        sb.append(resultTableName);
        sb.append(" ResultData LEFT OUTER JOIN T_BG_BgItem BgItem6 ON ResultData.FBgItem6ID = BgItem6.FID LEFT OUTER JOIN T_BG_BgItem BgItem5 ON ResultData.FBgItem5ID =BgItem5.FID LEFT OUTER JOIN T_BG_BgItem BgItem4 ON ResultData.FBgItem4ID =BgItem4.FID LEFT OUTER JOIN T_BG_BgItem BgItem3 ON ResultData.FBgItem3ID =BgItem3.FID LEFT OUTER JOIN T_BG_BgItem BgItem2 ON ResultData.FBgItem2ID =BgItem2.FID LEFT OUTER JOIN T_BG_BgItem BgItem1 ON ResultData.FBgItem1ID =BgItem1.FID  Order by  FOrgUnitID,FBgTypeID ,BgItem1Number,   ResultData.FID,ResultData.FPeriodID");
        return sb.toString();
    }

    private String getFilterSameSchemeByBizDateSql(String tableName, boolean filterByBizDate) {
        return null;
    }

    public void setParams2(FilterItemCollection filters, boolean filterByBizDate, PreparedStatement stmt) throws SQLException {
        if (filterByBizDate) {
            stmt.setDate(1, (Date)BgHelper.getFilterValue(filters, "beginBizDate"));
            stmt.setDate(2, (Date)BgHelper.getFilterValue(filters, "endBizDate"));
        }
    }

    public void setParams1(FilterItemCollection filters, boolean filterByBizDate, PreparedStatement stmt) throws SQLException {
        int number = 1;
        stmt.setString(number++, BgHelper.getId(BgHelper.getFilterValue(filters, "bgType")));
        if (filterByBizDate) {
            stmt.setDate(number++, (Date)BgHelper.getFilterValue(filters, "beginBizDate"));
            stmt.setDate(number++, (Date)BgHelper.getFilterValue(filters, "endBizDate"));
        } else {
            int beginPeriodYear = Integer.parseInt(BgHelper.getFilterValue(filters, "beginPeriodYear").toString());
            int beginPeriodMonth = Integer.parseInt(BgHelper.getFilterValue(filters, "beginPeriodMonth").toString());
            int endPeriodYear = Integer.parseInt(BgHelper.getFilterValue(filters, "endPeriodYear").toString());
            int endPeriodMonth = Integer.parseInt(BgHelper.getFilterValue(filters, "endPeriodMonth").toString());
            stmt.setInt(number++, beginPeriodYear * 100 + beginPeriodMonth);
            stmt.setInt(number++, endPeriodYear * 100 + endPeriodMonth);
        }
    }

    public String getInsertSql2(boolean filterByBizDate, Integer dispPeriod, String tableName1, String tableName2) {
        DisplayPeriodStyleEnum lbl = DisplayPeriodStyleEnum.getEnum(dispPeriod);
        if (dispPeriod == 12) {
            String dispPeriodS = " to_char(Period.FPeriodYear)||'" + (Object)((Object)lbl) + "'";
            String groupPeriod = " Period.FPeriodYear,";
            return this.groupByPeriod(filterByBizDate, tableName1, tableName2, dispPeriodS, groupPeriod);
        }
        if (dispPeriod == 3) {
            String dispPeriodS = " to_char(Period.FPeriodYear)||'-'||to_char(Period.FPeriodQuarter)||'" + (Object)((Object)lbl) + "'";
            String groupPeriod = " Period.FPeriodYear,Period.FPeriodQuarter,";
            return this.groupByPeriod(filterByBizDate, tableName1, tableName2, dispPeriodS, groupPeriod);
        }
        String dispPeriodS = " to_char(Period.FPeriodYear)||'-'||right('0'||to_char(Period.FPeriodNumber),2)||'" + (Object)((Object)lbl) + "'";
        String groupPeriod = " Period.FPeriodYear,Period.FPeriodNumber,";
        return this.groupByPeriod(filterByBizDate, tableName1, tableName2, dispPeriodS, groupPeriod);
    }

    private String groupByPeriod(boolean filterByBizDate, String tableName1, String tableName2, String dispPeriod, String groupPeriod) {
        StringBuffer sb = new StringBuffer(128);
        sb.append("INSERT INTO ");
        sb.append(tableName2);
        sb.append(" SELECT  BgEntry.FOrgUnitID || isnull(BgEntry.FBgItem1ID,'') || isnull(BgEntry.FBgItem2ID,'') || isnull(BgEntry.FBgItem3ID,'') || isnull(BgEntry.FBgItem4ID,'') || isnull(BgEntry.FBgItem5ID,'')  AS FID, BgEntry.FOrgUnitID, BgEntry.FBgTypeID," + dispPeriod + " AS FDispPeriod, BgElement.FBizElement, BgData.FCurrencyID, sum(BgData.FBgValue), BgEntry.FBgItem1ID, BgEntry.FBgItem2ID, BgEntry.FBgItem3ID, BgEntry.FBgItem4ID, BgEntry.FBgItem5ID, BgEntry.FBgItem6ID ");
        sb.append(" FROM  T_BG_BgData BgData INNER JOIN T_BG_BgElement BgElement ON BgData.FBgElementID = BgElement.FID inner JOIN ").append(tableName1).append(" BgEntry ON BgData.FBgEntryID = BgEntry.FID INNER JOIN T_BD_Period Period ON Period.FID = BgEntry.FPeriodID");
        if (filterByBizDate) {
            sb.append(" HAVING  (BgCtrlDetail.FBizDate BETWEEN ? AND ?)");
        }
        sb.append(" GROUP BY  BgEntry.FOrgUnitID,BgEntry.FBgTypeID," + groupPeriod + "BgElement.FBizElement,BgData.FCurrencyID, BgEntry.FBgItem1ID,BgEntry.FBgItem2ID,BgEntry.FBgItem3ID,BgEntry.FBgItem4ID,BgEntry.FBgItem5ID,BgEntry.FBgItem6ID");
        return sb.toString();
    }

    public String getCreateSql2(String tableName2) {
        StringBuffer sb = new StringBuffer(128);
        sb.append("Create Table ");
        sb.append(tableName2);
        sb.append(" (FID varchar (512),FOrgUnitID char (44),FBgTypeID char (44),FPeriodID char (44),FBizElement int ,FCurrencyID char (44),FBgValue decimal(28,10),FBgItem1ID char (44),FBgItem2ID char (44),FBgItem3ID char (44),FBgItem4ID char (44),FBgItem5ID char (44),FBgItem6ID char (44))");
        return sb.toString();
    }

    public String getInsertSql1(FilterItemCollection filters, boolean filterByBizDate, String tableName1, Integer dispPeriod) {
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO ");
        sb.append(tableName1);
        sb.append(" SELECT v.FID, v.FOrgUnitID, v.FBgTypeID, v.FPeriodID, v.FBgSchemeID, v.FBgTemplateID, v.FBgItem1ID, v.FBgItem2ID, v.FBgItem3ID, v.FBgItem4ID, v.FBgItem5ID, v.FBgItem6ID FROM V_BG_BgEntryScheme as v, t_bg_bgentry as t");
        if (filterByBizDate) {
            sb.append(" WHERE  (v.FOrgUnitID IN (").append(BgHelper.getFilterValue(filters, "bizOrgUnitIDs")).append(")  AND (v.FBgTypeID = ?) AND (v.FEndDate  > ?) AND  (v.FBeginDate < ?)");
        } else {
            sb.append(" WHERE  (v.FOrgUnitID IN (").append(BgHelper.getFilterValue(filters, "bizOrgUnitIDs")).append(")  AND (v.FBgTypeID = ?) AND (v.FPeriodYear*100+v.FPeriodNumber  BETWEEN ? AND ?) ");
        }
        sb.append("AND (v.FBgSchemeID IN(").append(BgHelper.getFilterValue(filters, "bgSchemeIDs")).append(")) )");
        sb.append(" and v.fid=t.fid ");
        if (dispPeriod != 12) {
            if (dispPeriod == 1) {
                sb.append(" and t.FBgCycle=3 ");
            } else if (dispPeriod == 3) {
                sb.append(" and (t.FBgCycle=2 or t.FBgCycle=3) ");
            }
        }
        return sb.toString();
    }

    public String getCreateSql1(String tableName1) {
        StringBuffer sb = new StringBuffer(128);
        sb.append("Create Table ");
        sb.append(tableName1);
        sb.append(" (FID char (44),FOrgUnitID char (44),FBgTypeID char (44),FPeriodID char (44),FBgSchemeID char (44),FBgTemplateID char (44),FBgItem1ID char (44),FBgItem2ID char (44),FBgItem3ID char (44),FBgItem4ID char (44),FBgItem5ID char (44),FBgItem6ID char (44))");
        return sb.toString();
    }
}

