/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz;

import com.kingdee.eas.ma.biz.BizCalcParseException;
import com.kingdee.eas.ma.biz.expr.oper.AbstractOper;
import com.kingdee.eas.ma.biz.parse.BizAssignExprChecker;
import com.kingdee.eas.ma.biz.parse.BizConditionChecker;
import com.kingdee.eas.ma.biz.parse.BizExprParser;
import com.kingdee.eas.ma.biz.parse.BizParseExceptionHandler;
import com.kingdee.eas.ma.biz.parse.BizParseHelper;
import com.kingdee.eas.ma.biz.parse.BizParseParam;
import com.kingdee.eas.ma.biz.parse.IBizParser;
import com.kingdee.eas.ma.biz.parse.expr.IBizExpr;
import com.kingdee.eas.ma.biz.parse.expr.impl.BizAssignmentExpr;
import com.kingdee.eas.ma.biz.parse.expr.impl.BizConditionExpr;
import com.kingdee.eas.ma.biz.parse.operand.impl.Operand;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class BizConditionParser
implements IBizParser {
    private BizParseParam param = null;
    private Integer currLine = null;
    private String text = null;
    private String bizName = null;
    private String subsetName = null;
    private Map<String, Map<String, Map<Integer, List<IBizExpr>>>> exprMap = null;
    private Map<String, Map<String, Map<Integer, List<Exception>>>> allExceptions = new LinkedHashMap<String, Map<String, Map<Integer, List<Exception>>>>();
    private int currPos = 0;
    private char currChar = '\u0000';
    private final String IF_TAG = "IF";
    private final String ELSE_TAG = "ELSE";
    private String ifStack = "";
    private boolean hasEnd = false;
    private final char SEMICOLON = (char)59;
    private final char STACK_OPERATOR = '\u0000';
    private Operand IFLeftOper = null;
    private Operand ELSELeftOper = null;
    private Integer line = null;

    public BizConditionParser(BizParseParam param) {
        this.param = param;
        this.currLine = param.getCurrLine();
        this.text = param.getText();
        this.bizName = param.getBizName();
        this.subsetName = param.getSubsetName();
        this.exprMap = param.getExprMap();
        this.allExceptions = param.getAllExceptions();
    }

    @Override
    public boolean parse() {
        this.readChar();
        while (this.currChar != '\u0000') {
            IBizExpr expr;
            if (this.currChar == '/' && this.preViewNextChar() == '*') {
                String annoStr = this.readAnnotation(true);
                if (!this.isAnnotation(annoStr)) {
                    this.recordException(BizCalcParseException.ERROR_ANNO_NO_END, annoStr.charAt(annoStr.length() - 1) + "");
                    return false;
                }
            } else if (this.currChar == 'I') {
                String ifToken = "";
                ifToken = ifToken + this.currChar;
                this.readChar();
                ifToken = ifToken + this.currChar;
                if (!ifToken.equals("IF") || !this.ifStack.equals("")) {
                    this.recordException(BizCalcParseException.ERROR_CHAR, String.valueOf(ifToken.charAt(0)));
                    return false;
                }
                this.ifStack = this.ifStack + ifToken;
            } else if (this.currChar == 'E') {
                String elseToken = "";
                elseToken = elseToken + this.currChar;
                for (int i = 0; i < 3; ++i) {
                    this.readChar();
                    elseToken = elseToken + this.currChar;
                }
                if (!elseToken.equals("ELSE") || !this.ifStack.equals("IF[]{}")) {
                    this.recordException(BizCalcParseException.ERROR_CHAR, String.valueOf(elseToken.charAt(0)));
                    return false;
                }
                this.ifStack = this.ifStack + elseToken;
            } else if (this.currChar == '[') {
                if (!this.ifStack.equals("IF")) {
                    this.recordException(BizCalcParseException.ERROR_CHAR, this.currChar + "");
                    return false;
                }
                String conditionStr = this.readCondition();
                if (conditionStr == null) {
                    this.recordException(BizCalcParseException.ERROR_CONDITION, this.currChar + "");
                    return false;
                }
                this.ifStack = this.ifStack + "[]";
                BizExprParser parser = new BizExprParser(this.createParam(conditionStr));
                if (parser.parse()) {
                    this.currLine = parser.getCurrLine();
                    Stack conditionStack = parser.getExprStack();
                    BizConditionChecker condiCheck = new BizConditionChecker(this.createParam(conditionStr));
                    if (condiCheck.check(conditionStack)) {
                        expr = new BizConditionExpr(conditionStack, null);
                        this.recordExpr(expr);
                    }
                } else {
                    this.currLine = parser.getCurrLine();
                }
            } else if (this.currChar == '{') {
                if (!this.ifStack.equals("IF[]") && !this.ifStack.equals("IF[]{}ELSE")) {
                    this.recordException(BizCalcParseException.ERROR_CHAR, this.currChar + "");
                    return false;
                }
                this.ifStack = this.ifStack + this.currChar;
                while (this.preViewNextChar() != '}') {
                    IBizParser parser;
                    this.readCharIgnoreLine();
                    String script = this.readScript();
                    if (this.isLikeIF(script)) {
                        parser = new BizConditionParser(this.createParam(script));
                        if (!((BizConditionParser)parser).parse()) {
                            this.currLine = ((BizConditionParser)parser).getCurrLine();
                            return false;
                        }
                        this.currLine = ((BizConditionParser)parser).getCurrLine();
                        this.checkTempUnSupportInnerIF();
                        continue;
                    }
                    if (StringUtils.isEmpty((String)script) || script.trim().equals(String.valueOf(';')) || this.isAnnotation(org.apache.commons.lang.StringUtils.strip((String)script, (String)String.valueOf(';')))) {
                        this.currLine = this.currLine + org.apache.commons.lang.StringUtils.countMatches((String)script, (String)String.valueOf('\n'));
                        continue;
                    }
                    parser = new BizExprParser(this.createParam(script));
                    if (!((BizExprParser)parser).parse()) {
                        this.currLine = ((BizExprParser)parser).getCurrLine();
                        return false;
                    }
                    this.currLine = ((BizExprParser)parser).getCurrLine();
                    Stack exprStack = ((BizExprParser)parser).getExprStack();
                    BizAssignExprChecker exprCheck = new BizAssignExprChecker(this.createParam(script));
                    if (!exprCheck.check(exprStack)) {
                        return false;
                    }
                    expr = new BizAssignmentExpr(exprStack);
                    this.recordExpr(expr);
                    this.checkTempUnSupportMultiExpr(expr);
                }
            } else if (this.currChar == '}') {
                if (!this.ifStack.equals("IF[]{") && !this.ifStack.equals("IF[]{}ELSE{")) {
                    this.recordException(BizCalcParseException.ERROR_CHAR, this.currChar + "");
                    return false;
                }
                this.ifStack = this.ifStack + this.currChar;
            } else if (this.currChar == ';') {
                if (!this.ifStack.matches("IF\\[\\]\\{\\}")) {
                    if (!this.ifStack.equals("IF[]{}")) {
                        this.recordException(BizCalcParseException.ERROR_CHAR, this.currChar + "");
                    }
                    return false;
                }
                this.hasEnd = true;
            } else if (!BizParseHelper.isBlank(this.currChar)) {
                this.recordException(BizCalcParseException.ERROR_CHAR, this.currChar + "");
                return false;
            }
            this.readChar();
        }
        this.checkTempUnSupportDiffExpr();
        if (!this.hasEnd) {
            this.recordException(BizCalcParseException.EXPR_NO_END, null);
        }
        return this.hasEnd;
    }

    private String readCondition() {
        StringBuffer conditionStr = new StringBuffer();
        int count = 0;
        while (this.currChar != '\u0000') {
            if (this.currChar == '[') {
                ++count;
            }
            if (this.currChar == ']') {
                --count;
            }
            if (this.currChar == '/' && this.preViewNextChar() == '*') {
                String annoStr = this.readAnnotation(false);
                if (annoStr == null) {
                    return null;
                }
                conditionStr.append(annoStr);
                continue;
            }
            conditionStr.append(this.currChar);
            if (count == 0) {
                return conditionStr.toString().substring(1, conditionStr.length() - 1);
            }
            this.readChar();
        }
        return null;
    }

    private String readAnnotation(boolean changeLine) {
        StringBuffer annoStr = new StringBuffer();
        while (this.currChar != '\u0000') {
            if (this.currChar == '/' && annoStr.length() > 1 && annoStr.charAt(annoStr.length() - 1) == '*') {
                annoStr.append(this.currChar);
                break;
            }
            annoStr.append(this.currChar);
            if (changeLine) {
                this.readChar();
                continue;
            }
            this.readCharIgnoreLine();
        }
        return annoStr.toString();
    }

    private char preViewNextChar() {
        return this.text.charAt(this.currPos);
    }

    private void readChar() {
        if (this.currPos == this.text.length()) {
            this.currChar = '\u0000';
            return;
        }
        this.currChar = this.text.charAt(this.currPos++);
        if (this.currChar == '\n') {
            Integer n = this.currLine;
            Integer n2 = this.currLine = Integer.valueOf(this.currLine + 1);
        }
    }

    private void readCharIgnoreLine() {
        if (this.currPos == this.text.length()) {
            this.currChar = '\u0000';
            return;
        }
        this.currChar = this.text.charAt(this.currPos++);
    }

    private boolean isSemicolon(char c) {
        return ';' == c;
    }

    private void recordException(NumericExceptionSubItem excSubItem, String charSeq) {
        BizParseExceptionHandler.recordException(excSubItem, charSeq, this.createParam(""));
    }

    private void recordException(NumericExceptionSubItem excSubItem, String charSeq, Integer line) {
        BizParseExceptionHandler.recordException(excSubItem, charSeq, this.createParam("", line));
    }

    private BizParseParam createParam(String text) {
        return this.createParam(text, null);
    }

    private BizParseParam createParam(String text, Integer line) {
        BizParseParam param = new BizParseParam();
        param.setCurrLine(line == null ? this.currLine : line);
        param.setBizName(this.bizName);
        param.setSubsetName(this.subsetName);
        param.setText(text);
        param.setExprMap(this.exprMap);
        param.setAllExceptions(this.allExceptions);
        return param;
    }

    private String readScript() {
        StringBuffer script = new StringBuffer();
        int count = 0;
        while (!(this.isSemicolon(this.currChar) && count == 0 || this.currChar == '\u0000' || this.preViewNextChar() == '}' && count == 0)) {
            if (this.currChar == '/' && this.preViewNextChar() == '*') {
                String annoStr = this.readAnnotation(false);
                script.append(annoStr);
                this.readCharIgnoreLine();
                continue;
            }
            if (this.currChar == '{') {
                ++count;
            }
            if (this.currChar == '}') {
                --count;
            }
            script.append(this.currChar);
            this.readCharIgnoreLine();
        }
        if (this.isSemicolon(this.currChar) || this.currChar == '\n') {
            script.append(this.currChar);
        }
        return script.toString();
    }

    private boolean isAnnotation(String script) {
        return script.trim().matches("\\/\\*[\\s\\S]*\\*\\/");
    }

    private boolean isLikeExpr(String script) {
        for (int i = 0; i < script.length(); ++i) {
            char c = script.charAt(i);
            if (BizParseHelper.isBlank(c)) continue;
            if (c == '/' && script.charAt(i + 1) == '*') {
                if ((i = script.indexOf("*/", i) + 1) > 0) continue;
                return false;
            }
            return c == 'M' || c == 'V' || c == 'F' || c == 'G';
        }
        return false;
    }

    private boolean isLikeIF(String script) {
        for (int i = 0; i < script.length(); ++i) {
            char c = script.charAt(i);
            if (BizParseHelper.isBlank(c)) continue;
            if (c == '/' && script.charAt(i + 1) == '*') {
                if ((i = script.indexOf("*/", i) + 1) > 0) continue;
                return false;
            }
            if (c == 'I') {
                return script.charAt(i + 1) == 'F';
            }
            return false;
        }
        return false;
    }

    private void recordExpr(IBizExpr expr) {
        List<IBizExpr> lineList = this.exprMap.get(this.bizName).get(this.subsetName).get(this.currLine);
        if (lineList == null) {
            lineList = new ArrayList<IBizExpr>();
            this.exprMap.get(this.bizName).get(this.subsetName).put(this.currLine, lineList);
        }
        lineList.add(expr);
    }

    @Override
    public Integer getCurrLine() {
        return this.currLine;
    }

    private void checkTempUnSupportCondition(Stack exprStack) {
        List unSupportOper = Arrays.asList((Object[])new String[]{">", ">=", "<", "<=", "==", "AND", "OR", "NOT"});
        Stack tempStack = (Stack)exprStack.clone();
        while (!tempStack.isEmpty()) {
            String oper;
            Object obj = tempStack.pop();
            if (!(obj instanceof AbstractOper) || !unSupportOper.contains(oper = ((AbstractOper)obj).getOper())) continue;
            this.recordException(BizCalcParseException.ERROR_UNSUPPORT_CONDITION, oper);
        }
    }

    private void checkTempUnSupportMultiExpr(IBizExpr expr) {
        Operand leftOper = (Operand)expr.getExpr().get(0);
        if (this.ifStack.equals("IF[]{")) {
            if (this.IFLeftOper != null) {
                this.recordException(BizCalcParseException.ERROR_UNSUPPORT_MULTI_EXPR, expr.toString());
            } else {
                this.IFLeftOper = leftOper;
            }
        } else if (this.ifStack.equals("IF[]{}ELSE{")) {
            if (this.ELSELeftOper != null) {
                this.recordException(BizCalcParseException.ERROR_UNSUPPORT_MULTI_EXPR, expr.toString());
            } else {
                this.ELSELeftOper = leftOper;
                this.line = this.currLine;
            }
        }
    }

    private void checkTempUnSupportDiffExpr() {
        if (this.ifStack.toString().equals("IF[]{") && this.IFLeftOper == null) {
            this.recordException(BizCalcParseException.ERROR_UNSUPPORT_EXIST_EXPR, "");
        } else if (this.ifStack.toString().equals("IF[]{}ELSE{") && this.ELSELeftOper == null) {
            this.recordException(BizCalcParseException.ERROR_UNSUPPORT_EXIST_EXPR, "");
        } else if (this.ifStack.toString().equals("IF[]{}ELSE{}")) {
            String elseLeftMem;
            String ifLeftMem = this.IFLeftOper != null ? this.IFLeftOper.getOperand() : "";
            String string = elseLeftMem = this.ELSELeftOper != null ? this.ELSELeftOper.getOperand() : "";
            if (!ifLeftMem.equals(elseLeftMem)) {
                this.recordException(BizCalcParseException.ERROR_UNSUPPORT_DIFF_MEM, elseLeftMem, this.line);
            }
        }
    }

    private void checkTempUnSupportOnlyIF() {
        this.recordException(BizCalcParseException.ERROR_UNSUPPORT_ONLY_IF, "");
    }

    private void checkTempUnSupportInnerIF() {
        this.recordException(BizCalcParseException.ERROR_UNSUPPORT_INNER_IF, "");
    }
}

