/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.api;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.utils.BgScenarioHelper;
import com.kingdee.eas.ma.base.utils.BgVersionHelper;
import com.kingdee.eas.ma.biz.BizCalcFacadeFactory;
import com.kingdee.eas.ma.biz.api.IBizCalc;
import com.kingdee.eas.ma.biz.execute.calc.face.ICalcData;
import com.kingdee.eas.ma.biz.execute.calc.impl.BizCalcImpl;
import com.kingdee.eas.ma.biz.execute.face.IBizParameter;
import com.kingdee.eas.ma.biz.execute.impl.BizCalcParameter;
import com.kingdee.eas.ma.mbg.common.IBgNData;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;

public class BizCalcCaller
implements IBizCalc {
    public static synchronized IBizCalc getInstance() {
        return new BizCalcCaller();
    }

    @Override
    public void calcUpdate(Context ctx, BOSUuid bgSchemeId, BOSUuid orgUnitId, int calcType, String bgPeriodNum, BOSUuid unionId) throws BOSException, EASBizException {
        this.calcUpdate(ctx, bgSchemeId, orgUnitId, null, calcType, bgPeriodNum, unionId, null);
    }

    @Override
    public void calcUpdate(Context ctx, BOSUuid bgSchemeId, BOSUuid orgUnitId, List<BOSUuid> calcIds, int calcType, String bgPeriodNum, BOSUuid unionId, Map<String, Set<String>> executeDimData) throws BOSException, EASBizException {
        if (ctx == null || bgSchemeId == null || orgUnitId == null || calcIds == null || calcIds.isEmpty()) {
            return;
        }
        IBizParameter parameter = BizCalcCaller.getBizParameter(bgSchemeId, orgUnitId, calcIds, calcType, bgPeriodNum, unionId, executeDimData);
        BizCalcFacadeFactory.getLocalInstance(ctx).executeBGUpdate(parameter);
    }

    public static IBizParameter getBizParameter(BOSUuid bgSchemeId, BOSUuid orgUnitId, List<BOSUuid> calcIds, int calcType, String bgPeriodNum, BOSUuid unionId, Map<String, Set<String>> executeDimData) {
        BizCalcParameter parameter = new BizCalcParameter();
        parameter.setOrgUnitId(orgUnitId);
        parameter.setBgSchemeId(bgSchemeId);
        parameter.setCalcIds(calcIds);
        parameter.setValueType(calcType);
        parameter.setBgPeriodNum(bgPeriodNum);
        parameter.setUnionId(unionId);
        parameter.setExecuteDimData(executeDimData);
        parameter.getControlManager().setBizCalc(true);
        parameter.getControlManager().setSaveMultiData(true);
        return parameter;
    }

    @Override
    public void calcUpdate(BOSUuid bgSchemeId, BOSUuid orgUnitId, List<BOSUuid> calcIds, int calcType, String bgPeriodNum, BOSUuid unionId) throws BOSException, EASBizException {
        if (bgSchemeId == null || orgUnitId == null || calcIds == null || calcIds.isEmpty()) {
            return;
        }
        BizCalcParameter parameter = new BizCalcParameter();
        parameter.setOrgUnitId(orgUnitId);
        parameter.setBgSchemeId(bgSchemeId);
        parameter.setCalcIds(calcIds);
        parameter.setValueType(calcType);
        parameter.setBgPeriodNum(bgPeriodNum);
        parameter.setUnionId(unionId);
        parameter.getControlManager().setBizCalc(true);
        BizCalcFacadeFactory.getRemoteInstance().executeBGUpdate(parameter);
    }

    @Override
    public void runBizCalc(BOSUuid orgUnitId, Collection<BOSUuid> calcIds) throws BOSException, EASBizException {
    }

    @Override
    public void runBackUpdate(BOSUuid bgSchemeId, BOSUuid orgUnitId, BOSUuid billId) {
    }

    @Override
    public void runBackUpdate(BOSUuid bgSchemeId, BOSUuid orgUnitId, BOSUuid billId, boolean isAdjust) {
        if (bgSchemeId == null || orgUnitId == null) {
            return;
        }
        final BOSUuid _bgSchemeId = bgSchemeId;
        final BOSUuid _orgUnitId = orgUnitId;
        final BOSUuid _billId = billId;
        final boolean _isAdjust = isAdjust;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BizCalcCaller.this.runBackUpdate(null, _bgSchemeId, _orgUnitId, _billId, _isAdjust);
            }
        });
    }

    @Override
    public void runBackUpdate(Context ctx, BOSUuid bgSchemeId, BOSUuid orgUnitId, BOSUuid billId) {
        this.runBackUpdate(ctx, bgSchemeId, orgUnitId, billId, false);
    }

    public void runBackUpdate(Context ctx, BOSUuid bgSchemeId, BOSUuid orgUnitId, BOSUuid billId, boolean isAdjust) {
        if (bgSchemeId == null || orgUnitId == null) {
            return;
        }
    }

    @Override
    public void runBackUpdate(final List<String> bgAdjustBillIds) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (bgAdjustBillIds != null && !bgAdjustBillIds.isEmpty()) {
                    try {
                        BizCalcFacadeFactory.getRemoteInstance().executeBizAdjust(new HashSet(bgAdjustBillIds));
                    }
                    catch (EASBizException e) {
                        e.printStackTrace();
                    }
                    catch (BOSException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    @Override
    public void runBackUpdate(Context ctx, IDimensionParameter parameter, IDimDataQuery query, Map mbgDatas) {
        if (ctx == null || parameter == null || mbgDatas == null || mbgDatas.isEmpty()) {
            return;
        }
        IBgNData bgNData22 = null;
        ICalcData calcData = null;
        Map tmpDataMap = null;
        Object var8_8 = null;
        HashSet<String> bgScenarios = new HashSet<String>();
        if (parameter.getDataManager().getBgScenarioMap().isEmpty()) {
            try {
                parameter.getDataManager().getBgScenarioMap().putAll(BgScenarioHelper.getScenariooObjMap((Context)ctx));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (parameter.getDataManager().getBgVersionMap().isEmpty()) {
            try {
                parameter.getDataManager().getBgVersionMap().putAll(BgVersionHelper.getVersionObjMap((Context)ctx));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        boolean isDaily = parameter.getValueType() == 16 || parameter.getValueType() == 32 || parameter.getValueType() == 2048;
        boolean isDecompose = DimensionCommonHelper.isDecompose((int)parameter.getValueType());
        if (isDaily || isDecompose) {
            BgScenarioInfo scenario22 = null;
            for (BgScenarioInfo scenario22 : parameter.getDataManager().getBgScenarioMap().values()) {
                if (0 != scenario22.getType().getValue()) continue;
                bgScenarios.add(scenario22.getNumber());
            }
        }
        ArrayList<ICalcData> calcDatas = new ArrayList<ICalcData>();
        for (Map.Entry entry : mbgDatas.entrySet()) {
            if (entry.getValue() instanceof Map) {
                tmpDataMap = (Map)entry.getValue();
                if (tmpDataMap == null) continue;
                for (IBgNData bgNData22 : tmpDataMap.values()) {
                    if (isDaily && bgScenarios.contains(bgNData22.getBgScenario()) || isDecompose && !bgScenarios.contains(bgNData22.getBgScenario()) || (calcData = bgNData22.toCalcData(parameter.getDataManager().getBgScenarioMap(), parameter.getDataManager().getBgVersionMap(), parameter.getValueType())) == null) continue;
                    calcData.setOrgUnitId((String)entry.getKey());
                    calcDatas.add(calcData);
                }
                continue;
            }
            if (!(entry.getValue() instanceof IBgNData)) continue;
            bgNData22 = (IBgNData)entry.getValue();
            if (isDaily && bgScenarios.contains(bgNData22.getBgScenario()) || (calcData = bgNData22.toCalcData(parameter.getDataManager().getBgScenarioMap(), parameter.getDataManager().getBgVersionMap(), parameter.getValueType())) == null) continue;
            calcDatas.add(calcData);
        }
        BizCalcImpl impl = new BizCalcImpl(ctx);
        impl.setDimParam(parameter);
        impl.setSaveDatas(calcDatas);
        int state = query.getBizState();
        if (Boolean.TRUE.equals(ctx.get((Object)"AUTO_CALCULATOR"))) {
            if (state == 4 || state == 35) {
                parameter.setBillId(query.getAdjustId());
            }
            impl.updataCalcData();
        } else if (state == 4 || state == 35) {
            parameter.setBillId(query.getAdjustId());
            impl.updataCalcData();
        } else {
            impl.start();
        }
    }
}

