/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.CanNotDeleteException;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.BindingPropertyInfo;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgPeriodDispCollection;
import com.kingdee.eas.ma.base.BgPeriodDispFactory;
import com.kingdee.eas.ma.base.BgPeriodException;
import com.kingdee.eas.ma.base.BgVersionCollection;
import com.kingdee.eas.ma.base.BgVersionFactory;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.MbgDimCollection;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCodeNumberCHelper;
import com.kingdee.eas.ma.base.utils.BgCodeNumberNHelper;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgNumberHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.biz.BizCalcCollection;
import com.kingdee.eas.ma.biz.BizCalcException;
import com.kingdee.eas.ma.biz.BizCalcFactory;
import com.kingdee.eas.ma.biz.BizCalcGroupFactory;
import com.kingdee.eas.ma.biz.BizCalcGroupInfo;
import com.kingdee.eas.ma.biz.BizCalcHistCollection;
import com.kingdee.eas.ma.biz.BizCalcHistFactory;
import com.kingdee.eas.ma.biz.BizCalcInfo;
import com.kingdee.eas.ma.biz.BizCalcParseException;
import com.kingdee.eas.ma.biz.BizCalcSubsetCollection;
import com.kingdee.eas.ma.biz.BizCalcSubsetFactory;
import com.kingdee.eas.ma.biz.BizCalcSubsetInfo;
import com.kingdee.eas.ma.biz.BizExecuteReportCollection;
import com.kingdee.eas.ma.biz.BizExecuteReportFactory;
import com.kingdee.eas.ma.biz.BizExecuteReportInfo;
import com.kingdee.eas.ma.biz.BizExecuteResultEnum;
import com.kingdee.eas.ma.biz.BizFacadeFactory;
import com.kingdee.eas.ma.biz.BizParameter;
import com.kingdee.eas.ma.biz.BizRefBgTemplateFactory;
import com.kingdee.eas.ma.biz.BizRefBgTemplateInfo;
import com.kingdee.eas.ma.biz.BizRelyCollection;
import com.kingdee.eas.ma.biz.BizRelyFactory;
import com.kingdee.eas.ma.biz.BizRelyInfo;
import com.kingdee.eas.ma.biz.BizScopeCollection;
import com.kingdee.eas.ma.biz.BizScopeFactory;
import com.kingdee.eas.ma.biz.BizScopeInfo;
import com.kingdee.eas.ma.biz.BizStateEnum;
import com.kingdee.eas.ma.biz.IBizCalc;
import com.kingdee.eas.ma.biz.IBizCalcGroup;
import com.kingdee.eas.ma.biz.IBizRely;
import com.kingdee.eas.ma.biz.api.BizCalcCaller;
import com.kingdee.eas.ma.biz.app.AbstractBizCalcControllerBean;
import com.kingdee.eas.ma.biz.app.utils.BizCalcServelHelper;
import com.kingdee.eas.ma.biz.execute.calc.impl.BizCalcImpl;
import com.kingdee.eas.ma.biz.execute.calc.impl.BizCalcMember;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.BinaryExpr;
import com.kingdee.eas.ma.biz.execute.face.IBizParameter;
import com.kingdee.eas.ma.biz.execute.impl.BizCalcQuery;
import com.kingdee.eas.ma.biz.expr.face.IExpress;
import com.kingdee.eas.ma.biz.parse.BizFormulaVerifyHelper;
import com.kingdee.eas.ma.biz.utils.BizCalcRefUtils;
import com.kingdee.eas.ma.biz.utils.BizConstants;
import com.kingdee.eas.ma.biz.utils.BizDimInfo;
import com.kingdee.eas.ma.biz.utils.BizExprUtils;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSchemeCollection;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemplateCollection;
import com.kingdee.eas.ma.mbg.BgTemplateFactory;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.TemplateFacadeFactory;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.common.BgCopySchemeResult;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IMbgSheetManager;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgViewManagerImpl;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgVariateUtils;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.ma.mbg.utils.MBgPeriodVariable;
import com.kingdee.eas.ma.mbg.utils.MbgQingAnalyseHelper;
import com.kingdee.eas.tools.datatask.ErrorHandleModeEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BizCalcControllerBean
extends AbstractBizCalcControllerBean {
    private static final long serialVersionUID = -183162644014529976L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.biz.app.BizCalcControllerBean");
    protected String RES = "com.kingdee.eas.ma.mbg.BgSchemeCopyResource";

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._submit(ctx, model);
        this.dealBgTemplate(ctx, model);
        BizCalcServelHelper.dealProCalc(ctx, model);
        return pk;
    }

    protected void deleteScope(Context ctx, String bizCalcId) throws BOSException {
        if (ctx == null || bizCalcId == null) {
            return;
        }
        try {
            BgDBUtils.executeUpdate((Context)ctx, (String)"delete from T_MBG_BizScope where FBizCalcID = ?", (Object[])new Object[]{bizCalcId});
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BizCalcInfo cal = (BizCalcInfo)model;
        FullOrgUnitInfo orgUnit = cal.getOrgUnit();
        String OUID = orgUnit.getId().toString();
        boolean hasCodeNumber = BgCodeNumberCHelper.hasCodeNumberLocal((IObjectValue)cal, (String)OUID, (String)"sourceType", (Context)ctx);
        boolean hasDisplayNumber = BgCodeNumberCHelper.hasDisplayNumberLocal((IObjectValue)cal, (String)OUID, (String)"sourceType", (Context)ctx);
        if (StringUtils.isEmpty((String)cal.getNumber())) {
            String numberCodeRule = BgCodeNumberCHelper.getNumberCodeRule((IObjectValue)cal, (String)OUID, (String)"sourceType", null, (Context)ctx);
            cal.setNumber(numberCodeRule);
        }
        if (hasCodeNumber && !hasDisplayNumber) {
            if (StringUtils.isEmpty((String)cal.getNumber())) {
                BgCodeNumberNHelper.applyNumber((Context)ctx, (IObjectValue)cal, (String)cal.getOrgUnit().getId().toString());
            }
            if (!StringUtils.isEmpty((String)cal.getNumber()) && !BgNumberHelper.checkBaseNumber((String)cal.getNumber())) {
                throw new BOSException(BgCommCHelper.getMessageStr((String)BizConstants.BIZ_RESOURCE_APP, (String)"haveEspecial"));
            }
        }
        if (StringUtils.isEmpty((String)cal.getNumber())) {
            BgCodeNumberNHelper.applyNumber((Context)ctx, (IObjectValue)cal, (String)cal.getOrgUnit().getId().toString());
        }
        if (StringUtils.isEmpty((String)cal.getNumber())) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        return super._addnew(ctx, model);
    }

    protected void _canDelete(Context ctx, IObjectPK pk, Connection cn) throws CanNotDeleteException {
        super._canDelete(ctx, pk, cn);
        try {
            String _pk = pk.toString();
            if (this.checkHasSchemeRelation(ctx, _pk)) {
                throw new CanNotDeleteException(new BizCalcException(BizCalcException.HASRELATIONS).getMessage());
            }
        }
        catch (CanNotDeleteException e) {
            throw e;
        }
        catch (EASBizException e) {
            throw new CanNotDeleteException((Throwable)e);
        }
        catch (BOSException e) {
            throw new CanNotDeleteException((Throwable)e);
        }
    }

    private boolean checkHasSchemeRelation(Context ctx, String bgSchemeId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)bgSchemeId)) {
            return false;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemeId, CompareType.EQUALS));
        return BizCalcFactory.getLocalInstance(ctx).exists(filter);
    }

    @Override
    protected Map<String, Set<String>> _getRuleIds(Context ctx, BizParameter parameter) throws BOSException, EASBizException {
        HashMap<String, Set<String>> orgBizIdMap = new HashMap<String, Set<String>>();
        if (ctx == null || parameter == null || parameter.getSelOrgUnitIds().isEmpty()) {
            return orgBizIdMap;
        }
        String tmpTable = null;
        String orgUnitId = null;
        String bizId = null;
        StringBuffer sql = new StringBuffer();
        Set<String> bizIds = null;
        HashSet<String> allIds = new HashSet<String>();
        Connection conn = null;
        IRowSet rst = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            conn = this.getConnection(ctx);
            rst = BgDBUtils.executeQuery((Connection)conn, (String)"select FID from T_MBG_BizCalc where FBgSchemeId = ?", (Object[])new Object[]{parameter.getSchemeId()});
            while (rst.next()) {
                allIds.add(rst.getString("FID"));
            }
            SQLUtils.cleanup((ResultSet)rst);
            orgBizIdMap.put(BgBaseConstants.ORGUNIT_ID, allIds);
            tmpTable = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FOrgUnitID VARCHAR(44))");
            BgDBUtils.insertKey((Connection)conn, (String)("insert Into " + tmpTable + " (FOrgUnitID) values (?)"), parameter.getSelOrgUnitIds());
            sql.append("select FBizID, FOrgUnitID from T_MBG_BizRelationDist where exists (select FID from T_MBG_BizCalc where FBgSchemeId = ? and FID = T_MBG_BizRelationDist.FBizID) and exists (select FOrgUnitID from " + tmpTable + " where FOrgUnitID = T_MBG_BizRelationDist.FOrgUnitID)");
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{parameter.getSchemeId()});
            while (rst.next()) {
                bizId = rst.getString("FBizID");
                orgUnitId = rst.getString("FOrgUnitID");
                if (orgBizIdMap.containsKey(orgUnitId)) {
                    bizIds = (Set)orgBizIdMap.get(orgUnitId);
                } else {
                    bizIds = new HashSet();
                    orgBizIdMap.put(orgUnitId, bizIds);
                }
                if (bizIds == null) continue;
                bizIds.add(bizId);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"queryRuleIds sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                BgDBUtils.releaseTmpTable((TempTablePool)pool, tmpTable);
                SQLUtils.cleanup(rst, null, (Connection)conn);
                throw throwable;
            }
        }
        BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpTable);
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        return orgBizIdMap;
    }

    @Override
    protected BgSchemeCollection _getDisScheme(Context ctx) throws BOSException, EASBizException {
        BgSchemeCollection colls = new BgSchemeCollection();
        String orgUnitId = ContextUtil.getCurrentCostUnit((Context)ctx).getId().toString();
        Set bgSchemeIds = BgSchemeFactory.getLocalInstance((Context)ctx).getCollection4SchemeList(orgUnitId, false);
        if (bgSchemeIds == null || bgSchemeIds.isEmpty()) {
            return colls;
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(new SelectorItemCollection());
        view.getSelector().add("id");
        view.getSelector().add("number");
        view.getSelector().add("name");
        view.getSelector().add("dateFrom");
        view.getSelector().add("dateTo");
        view.getSelector().add("orgUnit.id");
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)bgSchemeIds, CompareType.INCLUDE));
        colls = BgSchemeFactory.getLocalInstance((Context)ctx).getBgSchemeCollection(view);
        ObjectStringPK treeid = new ObjectStringPK(NewOrgViewHelper.convert2TreeId((OrgViewType)OrgViewType.COSTCENTER));
        ObjectUuidPK userPk = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        Map orgMap = PermissionFactory.getLocalInstance((Context)ctx).getAuthorizedOrgs((IObjectPK)userPk, OrgType.CostCenter, (IObjectPK)treeid, (IMetaDataPK)null, (IMetaDataPK)null);
        Iterator it = colls.iterator();
        while (it.hasNext()) {
            BgSchemeInfo info = (BgSchemeInfo)it.next();
            orgUnitId = info.getOrgUnit().getId().toString();
            if (orgMap != null && orgMap.containsKey(orgUnitId)) continue;
            it.remove();
        }
        return colls;
    }

    @Override
    protected CostCenterOrgUnitCollection _getDisOrgunitByScheme(Context ctx, String schemeID) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)schemeID)) {
            return null;
        }
        CostCenterOrgUnitCollection colls = new CostCenterOrgUnitCollection();
        Connection conn = null;
        PreparedStatement pmst = null;
        ResultSet rs = null;
        CostCenterOrgUnitInfo info = null;
        CostCenterOrgUnitInfo pInfo = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pmst = conn.prepareStatement("SELECT FID,FNUMBER,FLONGNUMBER,FNAME_" + ctx.getLocale() + " NAME,FPARENTID,FLEVEL,FISLEAF FROM T_ORG_COSTCENTER WHERE FID IN (SELECT FORGUNITID FROM T_MBG_BGSCHEME WHERE FID=?)");
            pmst.setString(1, schemeID);
            rs = pmst.executeQuery();
            while (rs.next()) {
                info = new CostCenterOrgUnitInfo();
                info.setId(BOSUuid.read((String)rs.getString("FID")));
                info.setNumber(rs.getString("FNUMBER"));
                info.setName(rs.getString("NAME"));
                info.setLongNumber(rs.getString("FLONGNUMBER"));
                info.setLevel(rs.getInt("FLEVEL"));
                info.setIsLeaf(rs.getBoolean("FISLEAF"));
                if (!StringUtils.isEmpty((String)rs.getString("FPARENTID"))) {
                    pInfo = new CostCenterOrgUnitInfo();
                    pInfo.setId(BOSUuid.read((String)rs.getString("FPARENTID")));
                    info.setParent(pInfo);
                }
                colls.add(info);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pmst, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pmst, (Connection)conn);
        return colls;
    }

    protected Set _getRuleIDDispScheme(Context ctx, BizParameter parameter) throws BOSException, EASBizException {
        if (parameter == null || StringUtils.isEmpty((String)parameter.getSchemeId())) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        Connection conn = null;
        PreparedStatement pmst = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pmst = conn.prepareStatement("SELECT FBIZCALCID FROM T_MBG_BIZCALCSCHEMERELATION WHERE FBGSCHEMEID=?");
            pmst.setString(1, parameter.getSchemeId());
            rs = pmst.executeQuery();
            while (rs.next()) {
                set.add(rs.getString("FBIZCALCID"));
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pmst, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pmst, (Connection)conn);
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _saveRuleDispRelation(Context ctx, BizParameter parameter) throws BOSException, EASBizException {
        block12: {
            if (ctx == null || parameter == null || parameter.getSelOrgUnitIds().isEmpty()) {
                return;
            }
            if (parameter.getSelBizIds().isEmpty() && parameter.getUnSelBizIds().isEmpty()) {
                return;
            }
            String tmpTable = null;
            Connection conn = null;
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            try {
                conn = this.getConnection(ctx);
                if (parameter.getUnSelBizIds().isEmpty()) break block12;
                try {
                    tmpTable = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FBizID VARCHAR(44), FOrgUnitId VARCHAR(44))");
                    ArrayList sqlParams = new ArrayList();
                    ArrayList<String> params = null;
                    for (String bizId : parameter.getUnSelBizIds()) {
                        for (String orgUnitId : parameter.getSelOrgUnitIds()) {
                            params = new ArrayList<String>();
                            params.add(bizId);
                            params.add(orgUnitId);
                            sqlParams.add(params);
                        }
                    }
                    BgDBUtils.insertValue((Connection)conn, (String)("Insert Into " + tmpTable + " (FBizID, FOrgUnitId) values (?,?)"), sqlParams);
                    BgDBUtils.executeQuery((Connection)conn, (String)("delete from T_MBG_BizRelationDist where exists (select * from " + tmpTable + " where FBizID = T_MBG_BizRelationDist.FBizID and FOrgUnitId = T_MBG_BizRelationDist.FOrgUnitId)"));
                }
                finally {
                    BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpTable);
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"saveRuleDispRelation sql error:", (Throwable)ex);
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
        }
    }

    private void dealBgTemplate(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgTemplateCollection refBgTemplateColl;
        BizCalcInfo currBizCalc = (BizCalcInfo)model;
        if (currBizCalc.get("bgtemplate") == null || !(currBizCalc.get("bgtemplate") instanceof BgTemplateCollection)) {
            return;
        }
        if (currBizCalc.getId() != null) {
            BizRefBgTemplateFactory.getLocalInstance(ctx).delete("where bizCalc.id = '" + currBizCalc.getId() + "'");
        }
        if ((refBgTemplateColl = (BgTemplateCollection)currBizCalc.get("bgtemplate")) != null && refBgTemplateColl.size() != 0) {
            CoreBaseCollection colls = new CoreBaseCollection();
            BizRefBgTemplateInfo refBgTemplate = null;
            int n = refBgTemplateColl.size();
            for (int i = 0; i < n; ++i) {
                refBgTemplate = new BizRefBgTemplateInfo();
                refBgTemplate.setBizCalc(currBizCalc);
                refBgTemplate.setBgTemplate(refBgTemplateColl.get(i));
                colls.add((CoreBaseInfo)refBgTemplate);
            }
            BizRefBgTemplateFactory.getLocalInstance(ctx).addnew(colls);
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.checkReferenced(ctx, pk);
        BizCalcServelHelper.updateHisBizcalc(ctx, pk.toString());
        BizRefBgTemplateFactory.getLocalInstance(ctx).delete("where bizCalc.id = '" + pk.toString() + "'");
        BizRelyFactory.getLocalInstance(ctx).delete("where bizCalc.id = '" + pk.toString() + "'");
        super._delete(ctx, pk);
        HashSet<String> id = new HashSet<String>();
        id.add(pk.toString());
        this.deleteBizRely(ctx, id);
        BizCalcRefUtils.getInterface(ctx).deleteRef(pk);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        super._delete(ctx, arrayPK);
    }

    protected void checkReferenced(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            return;
        }
        BizCalcInfo currBizCalc = (BizCalcInfo)BizCalcFactory.getLocalInstance(ctx).getBizBaseInfo(pk);
        Connection conn = null;
        IRowSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" select bizCalc.FNumber from T_Mbg_BizRely bizRely join T_Mbg_BizCalc bizCalc on bizRely.FBizCalcID = bizCalc.FID ").append(" where bizRely.FRelyBizID = ? ");
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{currBizCalc.getId().toString()});
            StringBuffer msg = new StringBuffer();
            while (rst.next()) {
                msg.append("\u201c").append(rst.getString("FNumber")).append("\u201d\uff0c");
            }
            if (msg.length() > 0) {
                msg.delete(msg.length() - 1, msg.length());
                throw new BizCalcException(BizCalcException.ISREFERENCED, new Object[]{currBizCalc.getNumber(), msg});
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    @Override
    protected void _copySubset(Context ctx, String srcBizCalcID, IObjectValue targetBizCalc) throws BOSException, EASBizException {
        if (srcBizCalcID == null) {
            logger.error((Object)"copySubSet : srcBizCalcID can not be null!");
            return;
        }
        HashMap<String, BizCalcSubsetInfo> subsetMap = new HashMap<String, BizCalcSubsetInfo>();
        CoreBaseCollection targetSubsetColls = new CoreBaseCollection();
        BizCalcSubsetCollection subSetColls = BizCalcSubsetFactory.getLocalInstance(ctx).getBizCalcSubsetCollection("where bizCalc.id = '" + srcBizCalcID + "'");
        for (int i = 0; i < subSetColls.size(); ++i) {
            BizCalcSubsetInfo srcsubset = subSetColls.get(i);
            BizCalcSubsetInfo targetSubset = new BizCalcSubsetInfo();
            targetSubset.setBizCalc((BizCalcInfo)targetBizCalc);
            targetSubset.setSeq(srcsubset.getSeq());
            targetSubset.setName(srcsubset.getName());
            targetSubset.setFormula(srcsubset.getFormula());
            targetSubsetColls.add((CoreBaseInfo)targetSubset);
            subsetMap.put(srcsubset.getId().toString(), targetSubset);
        }
        BizCalcSubsetFactory.getLocalInstance(ctx).addnew(targetSubsetColls);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("bizCalcSubset.id", subsetMap.keySet(), CompareType.INCLUDE));
        BizScopeCollection scopeColls = BizScopeFactory.getLocalInstance(ctx).getBizScopeCollection(view);
        CoreBaseCollection targetScopeColls = new CoreBaseCollection();
        for (int i = 0; i < scopeColls.size(); ++i) {
            BizScopeInfo srcScope = scopeColls.get(i);
            if (!subsetMap.containsKey(srcScope.getBizCalcSubset().getId().toString())) continue;
            BizScopeInfo targetScope = new BizScopeInfo();
            targetScope.setBizCalcSubset((BizCalcSubsetInfo)subsetMap.get(srcScope.getBizCalcSubset().getId().toString()));
            targetScope.setBgMemberNum(srcScope.getBgMemberNum());
            targetScope.setBgMemberAlias(srcScope.getBgMemberAlias());
            targetScope.setBgMemberType(srcScope.getBgMemberType());
            targetScopeColls.add((CoreBaseInfo)targetScope);
        }
        BizScopeFactory.getLocalInstance(ctx).addnew(targetScopeColls);
    }

    @Override
    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        FilterInfo filter = new FilterInfo();
        BizCalcInfo info = (BizCalcInfo)model;
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)info.getBgScheme().getId().toString(), CompareType.EQUALS));
        if (info.getOrgTree() != null) {
            filter.getFilterItems().add(new FilterItemInfo("orgTree.id", (Object)info.getOrgTree().getId().toString(), CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("orgTree.id", null, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)info.getOrgUnit().getId().toString(), CompareType.EQUALS));
        }
        return filter;
    }

    @Override
    protected String _importBizCalc(Context ctx, String bgSchemeId, String orgUnitId, Map calcMap, Map refBgTempMap, Map relyMap, ErrorHandleModeEnum errorHandle) throws BOSException, EASBizException {
        if (calcMap == null || calcMap.isEmpty()) {
            return null;
        }
        BgSchemeInfo bgScheme = new BgSchemeInfo();
        bgScheme.setId(BOSUuid.read((String)bgSchemeId));
        FullOrgUnitInfo orgUnit = new FullOrgUnitInfo();
        orgUnit.setId(BOSUuid.read((String)orgUnitId));
        Map _calcMap = calcMap;
        Map _refBgTempMap = refBgTempMap;
        Map _relyMap = relyMap;
        BizCalcInfo bizCalcInfo2 = null;
        BgTemplateCollection bgTemplateCol2 = null;
        BgTemplateInfo bgTemplateInfo = null;
        String bizCalcId2 = null;
        HashSet<String> keys = new HashSet<String>();
        HashMap<String, Object> number_info = new HashMap<String, Object>();
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("number");
        evi.setFilter(new FilterInfo());
        Iterator it = _calcMap.values().iterator();
        while (it.hasNext()) {
            keys.add(((BizCalcInfo)it.next()).getNumber());
        }
        evi.getFilter().getFilterItems().clear();
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemeId, CompareType.EQUALS));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("number", keys, CompareType.INCLUDE));
        BizCalcCollection bizCalcCol = this.getBizCalcCollection(ctx, evi);
        HashSet<String> hasBizNumber = new HashSet<String>();
        if (bizCalcCol != null && !bizCalcCol.isEmpty()) {
            for (int i = 0; i < bizCalcCol.size(); ++i) {
                hasBizNumber.add(bizCalcCol.get(i).getNumber());
            }
        }
        if (_refBgTempMap != null && !_refBgTempMap.isEmpty()) {
            int i;
            keys.clear();
            for (BgTemplateCollection bgTemplateCol2 : _refBgTempMap.values()) {
                for (i = 0; i < bgTemplateCol2.size(); ++i) {
                    if (StringUtils.isEmpty((String)bgTemplateCol2.get(i).getNumber())) continue;
                    keys.add(bgTemplateCol2.get(i).getNumber());
                }
            }
            evi.getFilter().getFilterItems().clear();
            evi.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemeId, CompareType.EQUALS));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("number", keys, CompareType.INCLUDE));
            BgTemplateCollection tempCol = BgTemplateFactory.getLocalInstance((Context)ctx).getBgTemplateCollection(evi);
            for (i = 0; i < tempCol.size(); ++i) {
                number_info.put(tempCol.get(i).getNumber(), tempCol.get(i));
            }
            for (String bizCalcId2 : _refBgTempMap.keySet()) {
                bgTemplateCol2 = (BgTemplateCollection)_refBgTempMap.get(bizCalcId2);
                Iterator it1 = bgTemplateCol2.iterator();
                while (it1.hasNext()) {
                    bgTemplateInfo = (BgTemplateInfo)it1.next();
                    if (!number_info.containsKey(bgTemplateInfo.getNumber())) {
                        it1.remove();
                        continue;
                    }
                    bgTemplateInfo.setId(((BgTemplateInfo)number_info.get(bgTemplateInfo.getNumber())).getId());
                }
                if (bgTemplateCol2.isEmpty() || !_calcMap.containsKey(bizCalcId2)) continue;
                bizCalcInfo2 = (BizCalcInfo)_calcMap.get(bizCalcId2);
                bizCalcInfo2.put("bgtemplate", bgTemplateCol2);
            }
        }
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(ctx, bgSchemeId);
        LinkedHashMap<String, LinkedHashMap<String, String>> bizCalcFormulaMap = new LinkedHashMap<String, LinkedHashMap<String, String>>();
        LinkedHashMap<String, Map<String, Set<String>>> bizScopeSrcMap = new LinkedHashMap<String, Map<String, Set<String>>>();
        LinkedHashMap<String, Map<String, BizScopeCollection>> bizScopeMap = new LinkedHashMap<String, Map<String, BizScopeCollection>>();
        BizFormulaVerifyHelper.buildParseParam(_calcMap.values(), bizCalcFormulaMap, bizScopeSrcMap, bizScopeMap, schemeHelper);
        BizFormulaVerifyHelper formulaParser = new BizFormulaVerifyHelper(bizCalcFormulaMap, bizScopeSrcMap, bizScopeMap, schemeHelper, true, BizFormulaVerifyHelper.getMemberMaps(_calcMap.values()));
        formulaParser.batchParse();
        HashSet<String> parseErrorNumber = new HashSet<String>();
        for (String number : formulaParser.getAllExceptions().keySet()) {
            Map<String, Map<Integer, List<Exception>>> subsetException = formulaParser.getAllExceptions().get(number);
            for (Map<Integer, List<Exception>> lineException : subsetException.values()) {
                if (lineException.isEmpty()) continue;
                parseErrorNumber.add(number);
            }
        }
        if (_relyMap != null && !_relyMap.isEmpty()) {
            keys.clear();
            number_info.clear();
            for (List bizs : _relyMap.values()) {
                for (BizCalcInfo bizCalcInfo2 : bizs) {
                    keys.add(bizCalcInfo2.getNumber());
                }
            }
            evi.getFilter().getFilterItems().clear();
            evi.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemeId, CompareType.EQUALS));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("number", keys, CompareType.INCLUDE));
            bizCalcCol = this.getBizCalcCollection(ctx, evi);
            for (int i = 0; i < bizCalcCol.size(); ++i) {
                number_info.put(bizCalcCol.get(i).getNumber(), bizCalcCol.get(i));
            }
            for (BizCalcInfo bizCalcInfo2 : _calcMap.values()) {
                if (number_info.containsKey(bizCalcInfo2.getNumber()) || parseErrorNumber.contains(bizCalcInfo2.getNumber())) continue;
                number_info.put(bizCalcInfo2.getNumber(), bizCalcInfo2);
            }
            for (String bizCalcId2 : _calcMap.keySet()) {
                List bizs;
                if (!_relyMap.containsKey(bizCalcId2)) continue;
                bizs = (List)_relyMap.get(bizCalcId2);
                Iterator it1 = bizs.iterator();
                while (it1.hasNext()) {
                    bizCalcInfo2 = (BizCalcInfo)it1.next();
                    if (!number_info.containsKey(bizCalcInfo2.getNumber())) {
                        it1.remove();
                        continue;
                    }
                    bizCalcInfo2.setId(((CoreBaseInfo)number_info.get(bizCalcInfo2.getNumber())).getId());
                }
                if (bizs.isEmpty()) continue;
                ((BizCalcInfo)_calcMap.get(bizCalcId2)).put("prebizcalc", bizs);
            }
        }
        StringBuffer message = new StringBuffer();
        int success = 0;
        boolean hasFail = !hasBizNumber.isEmpty() || !parseErrorNumber.isEmpty();
        IBizCalcGroup iBizCalcGroup = BizCalcGroupFactory.getLocalInstance(ctx);
        CoreBaseCollection updateColls = new CoreBaseCollection();
        CoreBaseCollection subSetCol = new CoreBaseCollection();
        for (BizCalcInfo bizCalcInfo2 : _calcMap.values()) {
            if (hasBizNumber.contains(bizCalcInfo2.getNumber())) {
                message.append(new BizCalcException(BizCalcException.NUMBEREXISTS, new Object[]{bizCalcInfo2.getNumber()}).getMessage());
                message.append("\r\n");
                continue;
            }
            if (!bizCalcInfo2.getBizCalcGroup().getId().toString().equals("IkpMdUyjQyOGom8OtZ0y2TQyFtQ=") && !iBizCalcGroup.exists((IObjectPK)new ObjectUuidPK(bizCalcInfo2.getBizCalcGroup().getId()))) {
                if (iBizCalcGroup.exists("where number = '" + bizCalcInfo2.getBizCalcGroup().getNumber() + "' and bgScheme.id = '" + bgSchemeId + "' and isCsl = 0")) {
                    BizCalcGroupInfo group = iBizCalcGroup.getBizCalcGroupInfo("where number = '" + bizCalcInfo2.getBizCalcGroup().getNumber() + "' and bgScheme.id = '" + bgSchemeId + "' and isCsl = 0");
                    if (group != null) {
                        bizCalcInfo2.setBizCalcGroup(group);
                    }
                } else {
                    message.append(new BizCalcException(BizCalcException.BIZCALCGROUP_NOTEXIST, new Object[]{bizCalcInfo2.getNumber()}).getMessage());
                    message.append("\r\n");
                    continue;
                }
            }
            if (formulaParser.getAllExceptions().containsKey(bizCalcInfo2.getNumber())) {
                boolean hasException = false;
                Map<String, Map<Integer, List<Exception>>> subsetException = formulaParser.getAllExceptions().get(bizCalcInfo2.getNumber());
                for (String subsetName : subsetException.keySet()) {
                    Map<Integer, List<Exception>> lineException = subsetException.get(subsetName);
                    ArrayList<Integer> keyList = new ArrayList<Integer>(lineException.keySet());
                    Collections.sort(keyList);
                    for (Integer line : keyList) {
                        hasException = true;
                        List<Exception> Exceptions = lineException.get(line);
                        for (Exception exception : Exceptions) {
                            message.append(new BizCalcParseException(BizCalcParseException.ERROR_SHOWBIZNAME, new Object[]{bizCalcInfo2.getNumber(), exception.getMessage()}).getMessage()).append("\r\n");
                        }
                    }
                }
                if (hasException) continue;
            }
            if (hasFail && ErrorHandleModeEnum.ReturnRightnow.equals((Object)errorHandle)) continue;
            ++success;
            subSetCol.addObjectCollection((IObjectCollection)bizCalcInfo2.getBizCalcSubset());
            bizCalcInfo2.setBgScheme(bgScheme);
            bizCalcInfo2.setOrgUnit(orgUnit);
            bizCalcInfo2.setVersion(bizCalcInfo2.getVersion() == null ? BizCalcServelHelper.DEFAULT_VERSION : bizCalcInfo2.getVersion());
            this._submit(ctx, (IObjectValue)bizCalcInfo2);
            updateColls.add((CoreBaseInfo)bizCalcInfo2);
            if (!BizStateEnum.SAVED.equals((Object)bizCalcInfo2.getState())) continue;
            bizCalcInfo2.setVersion(null);
            this.addHisBizcalc(ctx, bizCalcInfo2, false, false);
        }
        if (!updateColls.isEmpty()) {
            BizCalcRefUtils.getInterface(ctx).checkRef((IObjectCollection)updateColls).saveRef();
        }
        BizCalcSubsetFactory.getLocalInstance(ctx).saveBatchData(subSetCol);
        if (message.length() != 0) {
            message.insert(0, new BizCalcException(BizCalcException.IMPORTFAIL, new Object[]{_calcMap.size() - success}).getMessage() + "\r\n");
            message.insert(0, new BizCalcException(BizCalcException.IMPORTSUCCESS, new Object[]{success}).getMessage() + "\r\n");
        }
        return message.toString();
    }

    @Override
    protected void _execute(Context ctx, BOSUuid bgSchemeId, BOSUuid orgUnitId, List calcIds, int calcType, String bgPeriodNum) throws BOSException, EASBizException {
        if (bgSchemeId == null || calcIds == null) {
            return;
        }
        com.kingdee.eas.ma.biz.api.IBizCalc bizCalcCaller = BizCalcCaller.getInstance();
        try {
            bizCalcCaller.calcUpdate(ctx, bgSchemeId, orgUnitId, calcIds, calcType, bgPeriodNum, null, null);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    @Override
    protected void _executeBatch(Context ctx, BOSUuid bgSchemeId, BOSUuid unionId, List calcIds, int calcType, String bgPeriodNum, Map executeDimData) throws BOSException, EASBizException {
        if (bgSchemeId == null || calcIds == null) {
            return;
        }
        this.checkIsExecuting(ctx, calcIds);
        Map<String, Map<String, Set<Object>>> executeReportDimMemberRange = this.getExecuteReportDimMemberRange(ctx, bgSchemeId, calcType, calcIds, bgPeriodNum, executeDimData, unionId);
        this.writeReport(ctx, calcIds, bgSchemeId, executeReportDimMemberRange);
        new Thread(new BizCalcRunner(ctx, bgSchemeId, unionId, calcIds, calcType, bgPeriodNum, executeDimData)).start();
    }

    private Map<String, Map<String, Set<Object>>> getExecuteReportDimMemberRange(Context ctx, BOSUuid bgSchemeId, int calcType, List calcIds, String bgPeriodNum, Map executeDimData, BOSUuid unionId) throws BOSException {
        Connection conn = null;
        String dimNumber2 = null;
        String srcNumber = null;
        String field = null;
        String[] tmpStrs = null;
        HashMap<String, Map<String, Set<Object>>> calcRefDimInfoMap = new HashMap<String, Map<String, Set<Object>>>();
        try {
            conn = this.getConnection(ctx);
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(ctx, bgSchemeId.toString());
            String bgOrgViewId = schemeHelper.getBgOrgViewId();
            ArrayList<BOSUuid> _calcIds = new ArrayList<BOSUuid>();
            if (calcIds != null) {
                for (Object id : calcIds) {
                    if (id instanceof BOSUuid) {
                        _calcIds.add((BOSUuid)id);
                        continue;
                    }
                    _calcIds.add(BOSUuid.read((String)id.toString()));
                }
            }
            IBizParameter bizParameter = BizCalcCaller.getBizParameter(bgSchemeId, BOSUuid.read((String)"00000000-0000-0000-0000-000000000000CCE7AED4"), _calcIds, calcType, bgPeriodNum, unionId, executeDimData);
            bizParameter.getDataManager().setBgScheme(BgViewServerHelper.getBgSchemeCubeInfo((Context)ctx, (BOSUuid)bgSchemeId));
            bizParameter.getDataManager().setOrgUnit(MbgDataHelper.getBaseOrgUnitInfo((Context)ctx, (BOSUuid)BOSUuid.read((String)"00000000-0000-0000-0000-000000000000CCE7AED4")));
            IDimensionParameter parameter = new BizCalcImpl(ctx).transParameter(bizParameter);
            parameter.getControlManager().setBizCalc(true);
            Map costCenterMap = BizFacadeFactory.getLocalInstance(ctx).getCostCenterIDByCalcID(calcIds, bgSchemeId, unionId);
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("number");
            selector.add("bgScheme.id");
            selector.add("bizCalcSubset.*");
            selector.add("bizCalcSubset.scope.*");
            view.setSelector(selector);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(calcIds), CompareType.INCLUDE));
            view.setFilter(filter);
            BizCalcCollection calcs = BizCalcFactory.getLocalInstance(ctx).getBizCalcCollection(view);
            HashMap<String, Set<String>> refNumMap = new HashMap<String, Set<String>>();
            Map variateMap = BgVariateUtils.queryVariate((Connection)conn, (BOSUuid)bgSchemeId);
            Map srcFieldMap = MbgQingAnalyseHelper.getSrcFieldMap((Context)ctx, (BgSchemeDimensionHelper)schemeHelper);
            HashMap<String, HashMap<String, Set<String>>> calcRefNumMap = new HashMap<String, HashMap<String, Set<String>>>();
            ArrayList<BizCalcInfo> _calcs = new ArrayList<BizCalcInfo>();
            HashSet<String> bgPeriodNums = new HashSet<String>();
            if (bgPeriodNum != null) {
                bgPeriodNums.add(bgPeriodNum);
            }
            if (!calcs.isEmpty()) {
                for (int i = 0; i < calcs.size(); ++i) {
                    _calcs.add(calcs.get(i));
                }
                List<BizCalcInfo> tmpCalcs = new BizCalcQuery(ctx).queryRelyBizCalc(conn, pool, _calcs);
                if (tmpCalcs != null && !tmpCalcs.isEmpty()) {
                    _calcs.addAll(tmpCalcs);
                }
                MBgPeriodVariable variable = new MBgPeriodVariable(ctx.getLocale());
                variable.transPeirodVariale(ctx, _calcs, bgPeriodNums, null);
            }
            if (variateMap != null) {
                for (String dimNumber2 : variateMap.values()) {
                    tmpStrs = dimNumber2.split(":");
                    if (tmpStrs == null || tmpStrs.length != 2 || !srcFieldMap.containsKey(srcNumber = tmpStrs[0])) continue;
                    field = (String)srcFieldMap.get(srcNumber);
                    BizExprUtils.putDimNumber(field, dimNumber2, refNumMap);
                }
            }
            HashMap<String, Set<String>> refDimMap = new HashMap<String, Set<String>>();
            if (calcs != null && !calcs.isEmpty()) {
                BgVersionInfo info;
                BizCalcInfo calcInfo = null;
                BizCalcSubsetInfo subCalc = null;
                String dimField = null;
                Set dimNums = null;
                int in = calcs.size();
                for (int i = 0; i < in; ++i) {
                    calcInfo = calcs.get(i);
                    BgVariateUtils.transVariate((BizCalcInfo)calcInfo, (Map)variateMap);
                    BizCalcMember calcMember = new BizCalcMember();
                    calcMember.setSrcFieldMap(srcFieldMap);
                    for (int s = 0; s < calcInfo.getBizCalcSubset().size(); ++s) {
                        subCalc = calcInfo.getBizCalcSubset().get(s);
                        calcMember.queryRefMbgMember(ctx, parameter, bgSchemeId, subCalc, refDimMap, variateMap, true, executeDimData, true);
                    }
                    if (refDimMap != null && !refDimMap.containsKey(DimensionBaseConstants.DEF_ORGUNIT_FIELD)) {
                        Object costCenterId2;
                        Set ids = (Set)costCenterMap.get(calcInfo.getId().toString());
                        ArrayList<BOSUuid> billIds = new ArrayList<BOSUuid>();
                        HashSet<String> nums = new HashSet<String>();
                        for (Object costCenterId2 : ids) {
                            billIds.add(BOSUuid.read((String)costCenterId2));
                        }
                        List orgUnits = MbgDataHelper.getBaseOrgUnitsByUuid((Context)ctx, billIds);
                        costCenterId2 = orgUnits.iterator();
                        while (costCenterId2.hasNext()) {
                            OrgUnitInfo orgUnitInfo = (OrgUnitInfo)costCenterId2.next();
                            nums.add(orgUnitInfo.getNumber());
                        }
                        refDimMap.put(DimensionBaseConstants.DEF_ORGUNIT_FIELD, nums);
                    }
                    if (refDimMap != null && !refDimMap.containsKey(DimensionBaseConstants.DEF_VERSION_FIELD)) {
                        refDimMap.put(DimensionBaseConstants.DEF_VERSION_FIELD, schemeHelper.getMemberSet(DimensionBaseConstants.DEF_VERSION_NUMBER, true));
                    }
                    if (refDimMap != null && !refDimMap.containsKey(DimensionBaseConstants.DEF_CURRENCY_FIELD)) {
                        refDimMap.put(DimensionBaseConstants.DEF_CURRENCY_FIELD, schemeHelper.getMemberSet(DimensionBaseConstants.DEF_CURRENCY_NUMBER, true));
                    }
                    if (refDimMap != null && !refDimMap.containsKey(DimensionBaseConstants.DEF_PROCESS_FIELD)) {
                        HashSet<String> processTyps = new HashSet<String>();
                        processTyps.add(BgProcessEnum.C01.getName());
                        processTyps.add(BgProcessEnum.C02.getName());
                        processTyps.add(BgProcessEnum.C03.getName());
                        processTyps.add(BgProcessEnum.C04.getName());
                        refDimMap.put(DimensionBaseConstants.DEF_PROCESS_FIELD, processTyps);
                    }
                    if (!refDimMap.isEmpty()) {
                        for (Map.Entry entry : refDimMap.entrySet()) {
                            dimField = (String)entry.getKey();
                            dimNums = (Set)entry.getValue();
                            if (executeDimData == null || !executeDimData.containsKey(dimField)) continue;
                            Set execDimNums = (Set)executeDimData.get(dimField);
                            dimNums.retainAll(execDimNums);
                        }
                    }
                    calcRefNumMap.put(calcInfo.getId().toString(), refDimMap);
                }
                Set _dimNums = null;
                Collection values = calcRefNumMap.values();
                HashMap collectNums = new HashMap();
                for (Map dimTypeNums : values) {
                    for (Map.Entry entry : dimTypeNums.entrySet()) {
                        dimField = (String)entry.getKey();
                        _dimNums = (Set)entry.getValue();
                        if (collectNums.containsKey(dimField)) {
                            ((Set)collectNums.get(dimField)).addAll(_dimNums);
                            continue;
                        }
                        HashSet nums = new HashSet();
                        nums.addAll(_dimNums);
                        collectNums.put(dimField, nums);
                    }
                }
                HashMap result = new HashMap();
                Map<String, BgVersionInfo> memberMap = null;
                _dimNums = (Set)collectNums.get(DimensionBaseConstants.DEF_ORGUNIT_FIELD);
                if (_dimNums != null && !_dimNums.isEmpty()) {
                    view.getSelector().clear();
                    selector.clear();
                    filter.getFilterItems().clear();
                    selector.add("id");
                    selector.add("number");
                    selector.add("name");
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)_dimNums, CompareType.INCLUDE));
                    filter.getFilterItems().add(new FilterItemInfo("viewID", (Object)bgOrgViewId, CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("isVirtual", (Object)false, CompareType.EQUALS));
                    BgOrgUnitCollection bgOrgUnitColl = BgOrgUnitFactory.getLocalInstance((Context)ctx).getBgOrgUnitCollection(view);
                    if (bgOrgUnitColl != null && !bgOrgUnitColl.isEmpty()) {
                        info = null;
                        memberMap = new HashMap();
                        int in2 = bgOrgUnitColl.size();
                        for (int i = 0; i < in2; ++i) {
                            info = bgOrgUnitColl.get(i);
                            memberMap.put(info.getNumber(), info);
                        }
                        result.put(DimensionBaseConstants.DEF_ORGUNIT_FIELD, memberMap);
                    }
                }
                if ((_dimNums = (Set)collectNums.get(DimensionBaseConstants.DEF_VERSION_FIELD)) != null && !_dimNums.isEmpty()) {
                    view.getSelector().clear();
                    selector.clear();
                    filter.getFilterItems().clear();
                    selector.add("id");
                    selector.add("number");
                    selector.add("name");
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)_dimNums, CompareType.INCLUDE));
                    BgVersionCollection bgVersionColl = BgVersionFactory.getLocalInstance((Context)ctx).getBgVersionCollection(view);
                    if (bgVersionColl != null && !bgVersionColl.isEmpty()) {
                        info = null;
                        memberMap = new HashMap();
                        int in3 = bgVersionColl.size();
                        for (int i = 0; i < in3; ++i) {
                            info = bgVersionColl.get(i);
                            memberMap.put(info.getNumber(), info);
                        }
                        result.put(DimensionBaseConstants.DEF_VERSION_FIELD, memberMap);
                    }
                }
                if ((_dimNums = (Set)collectNums.get(DimensionBaseConstants.DEF_CURRENCY_FIELD)) != null && !_dimNums.isEmpty()) {
                    view.getSelector().clear();
                    selector.clear();
                    filter.getFilterItems().clear();
                    selector.add("id");
                    selector.add("number");
                    selector.add("name");
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)_dimNums, CompareType.INCLUDE));
                    CurrencyCollection currencyColl = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(view);
                    if (currencyColl != null && !currencyColl.isEmpty()) {
                        info = null;
                        memberMap = new HashMap();
                        int in4 = currencyColl.size();
                        for (int i = 0; i < in4; ++i) {
                            info = currencyColl.get(i);
                            memberMap.put(info.getNumber(), info);
                        }
                        result.put(DimensionBaseConstants.DEF_CURRENCY_FIELD, memberMap);
                    }
                }
                if ((_dimNums = (Set)collectNums.get(DimensionBaseConstants.DEF_PROCESS_FIELD)) != null && !_dimNums.isEmpty()) {
                    memberMap = new HashMap<String, Object>();
                    for (int i = 0; i < BgProcessEnum.getEnumList().size(); ++i) {
                        if (!_dimNums.contains(((BgProcessEnum)BgProcessEnum.getEnumList().get(i)).getName())) continue;
                        memberMap.put(((BgProcessEnum)BgProcessEnum.getEnumList().get(i)).getName(), (BgVersionInfo)((BgProcessEnum)BgProcessEnum.getEnumList().get(i)));
                    }
                    result.put(DimensionBaseConstants.DEF_PROCESS_FIELD, memberMap);
                }
                HashMap refDimInfoMap = null;
                HashSet dimInfoSet = null;
                for (Map.Entry calcEntry : calcRefNumMap.entrySet()) {
                    String calcId = (String)calcEntry.getKey();
                    refDimInfoMap = new HashMap();
                    for (Map.Entry dimEntry : ((Map)calcEntry.getValue()).entrySet()) {
                        dimField = (String)dimEntry.getKey();
                        dimInfoSet = new HashSet();
                        if (result != null && result.containsKey(dimField)) {
                            memberMap = (Map)result.get(dimField);
                            for (String dimNum : (Set)dimEntry.getValue()) {
                                Object info2 = memberMap.get(dimNum);
                                dimInfoSet.add(info2);
                            }
                        }
                        refDimInfoMap.put(dimField, dimInfoSet);
                    }
                    calcRefDimInfoMap.put(calcId, refDimInfoMap);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"getExecuteReportDimMemberRange error :", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return calcRefDimInfoMap;
    }

    protected void checkIsExecuting(Context ctx, List calcIds) throws BOSException, EASBizException {
        if (calcIds == null) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("bizCalcID", new HashSet(calcIds), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("result", (Object)BizExecuteResultEnum.EXECUTING, CompareType.EQUALS));
        BizExecuteReportCollection reportColls = BizExecuteReportFactory.getLocalInstance(ctx).getBizExecuteReportCollection(view);
        if (reportColls.size() > 0) {
            throw new BizCalcException(BizCalcException.HASEXECUTING);
        }
    }

    protected void writeReport(Context ctx, List<String> calcIds, BOSUuid bgSchemeId, Map<String, Map<String, Set<Object>>> executeReportDimMemberRange) throws BOSException, EASBizException {
        if (calcIds == null) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet<String>(calcIds), CompareType.INCLUDE));
        BizCalcCollection bizColls = BizCalcFactory.getLocalInstance(ctx).getBizCalcCollection(view);
        CoreBaseCollection reportColls = new CoreBaseCollection();
        BizCalcInfo bizCalc = null;
        Map<String, Set<Object>> refDimNumMap = null;
        Set<Object> bgOrgUnits = null;
        Set<Object> bgVersions = null;
        Set<Object> currencys = null;
        Set<Object> processTypes = null;
        BgOrgUnitInfo orgUnitInfo = null;
        BgVersionInfo versionInfo = null;
        CurrencyInfo currencyInfo = null;
        BgProcessEnum bgProcessEnum = null;
        for (int i = 0; i < bizColls.size(); ++i) {
            bizCalc = bizColls.get(i);
            refDimNumMap = executeReportDimMemberRange.get(bizCalc.getId().toString());
            if (refDimNumMap == null || refDimNumMap.isEmpty()) continue;
            bgOrgUnits = refDimNumMap.get(DimensionBaseConstants.DEF_ORGUNIT_FIELD);
            bgVersions = refDimNumMap.get(DimensionBaseConstants.DEF_VERSION_FIELD);
            currencys = refDimNumMap.get(DimensionBaseConstants.DEF_CURRENCY_FIELD);
            processTypes = refDimNumMap.get(DimensionBaseConstants.DEF_PROCESS_FIELD);
            for (Object orgUnitType : bgOrgUnits) {
                if (orgUnitType == null) continue;
                orgUnitInfo = (BgOrgUnitInfo)orgUnitType;
                for (Object versionType : bgVersions) {
                    versionInfo = (BgVersionInfo)versionType;
                    for (Object currencyType : currencys) {
                        currencyInfo = (CurrencyInfo)currencyType;
                        for (Object bgProcessType : processTypes) {
                            bgProcessEnum = (BgProcessEnum)bgProcessType;
                            BizExecuteReportInfo report = new BizExecuteReportInfo();
                            report.setBizCalcID(bizCalc.getId().toString());
                            report.setBizCalcNumber(bizCalc.getNumber());
                            report.setBizCalcName(bizCalc.getName());
                            report.setOrgUnitName(orgUnitInfo.getName());
                            report.setBgVersionName(versionInfo.getName());
                            report.setCurrencyName(currencyInfo.getName());
                            report.setStartTime(new Timestamp(System.currentTimeMillis()));
                            report.setExecutor(ContextUtil.getCurrentUserInfo((Context)ctx));
                            report.setResult(BizExecuteResultEnum.EXECUTING);
                            report.setBgSchemeID(bgSchemeId.toString());
                            report.setProcessType(bgProcessEnum);
                            reportColls.add((CoreBaseInfo)report);
                        }
                    }
                }
            }
        }
        BizExecuteReportFactory.getLocalInstance(ctx).addnew(reportColls);
    }

    protected void updateReport(Context ctx, List<String> calcIds, BizExecuteResultEnum result, String resultData, Map<String, OrgUnitInfo> orgUnitMaps) throws BOSException, EASBizException {
        if (calcIds == null) {
            return;
        }
        if (resultData != null && resultData.length() > 2000) {
            resultData = resultData.substring(0, 2000);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("bizCalcID", new HashSet<String>(calcIds), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("result", (Object)BizExecuteResultEnum.EXECUTING, CompareType.EQUALS));
        BizExecuteReportCollection reportColls = BizExecuteReportFactory.getLocalInstance(ctx).getBizExecuteReportCollection(view);
        CoreBaseCollection updateColls = new CoreBaseCollection();
        long finishTime = System.currentTimeMillis();
        for (int i = 0; i < reportColls.size(); ++i) {
            BizExecuteReportInfo report = reportColls.get(i);
            report.setFinishTime(new Timestamp(finishTime));
            report.setResult(result);
            report.setResultData(resultData);
            updateColls.add((CoreBaseInfo)report);
        }
        BizExecuteReportFactory.getLocalInstance(ctx).update(updateColls);
    }

    @Override
    protected void _BGExecute(Context ctx, List IDList) throws BOSException, EASBizException {
        if (IDList == null || IDList.size() == 0) {
            return;
        }
        this.updateBGExeState(ctx, IDList, true);
    }

    @Override
    protected void _cancelBGExe(Context ctx, List IDList) throws BOSException, EASBizException {
        if (IDList == null || IDList.size() == 0) {
            return;
        }
        this.updateBGExeState(ctx, IDList, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateBGExeState(Context ctx, List IDList, boolean isBGExe) {
        Connection conn = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_Mbg_BizCalc set FIsBGExe = ").append(isBGExe ? 1 : 0).append("  where FID in (");
        for (Object id : IDList) {
            sql.append("'").append(id).append("', ");
        }
        sql.delete(sql.length() - 2, sql.length() - 1).append(")");
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString());
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    @Override
    protected IObjectPK _copyAddnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this._submit(ctx, model);
    }

    @Override
    protected Map _checkBizExecuteStatus(Context ctx, List calcIds) throws BOSException, EASBizException {
        if (calcIds == null) {
            return null;
        }
        HashMap resultMap = new HashMap();
        resultMap.put("bizTempsaveStr", new ArrayList());
        resultMap.put("bizExecutingStr", new ArrayList());
        resultMap.put("bizDisableStr", new ArrayList());
        EntityViewInfo view = new EntityViewInfo();
        SorterItemCollection soter = new SorterItemCollection();
        soter.add(new SorterItemInfo("number"));
        view.setSorter(soter);
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("state"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(calcIds), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)BizStateEnum.TEMPSAVED, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)BizStateEnum.DISABLE, CompareType.EQUALS));
        filter.setMaskString(" #0 AND ( #1 OR #2 )");
        BizCalcCollection bizColl = BizCalcFactory.getLocalInstance(ctx).getBizCalcCollection(view);
        BizCalcInfo bizCalcInfo = null;
        for (int i = 0; i < bizColl.size(); ++i) {
            bizCalcInfo = bizColl.get(i);
            if (BizStateEnum.TEMPSAVED == bizCalcInfo.getState()) {
                ((List)resultMap.get("bizTempsaveStr")).add(bizColl.get(i));
                continue;
            }
            if (BizStateEnum.DISABLE != bizCalcInfo.getState()) continue;
            ((List)resultMap.get("bizDisableStr")).add(bizColl.get(i));
        }
        EntityViewInfo viewExe = new EntityViewInfo();
        FilterInfo filterExe = new FilterInfo();
        soter.clear();
        soter.add(new SorterItemInfo("bizCalcNumber"));
        selector.clear();
        selector.add(new SelectorItemInfo("bizCalcId"));
        selector.add(new SelectorItemInfo("bizCalcNumber"));
        selector.add(new SelectorItemInfo("bizCalcName"));
        viewExe.setSelector(selector);
        viewExe.setSorter(soter);
        filterExe.getFilterItems().clear();
        filterExe.getFilterItems().add(new FilterItemInfo("bizCalcID", new HashSet(calcIds), CompareType.INCLUDE));
        filterExe.getFilterItems().add(new FilterItemInfo("result", (Object)BizExecuteResultEnum.EXECUTING, CompareType.EQUALS));
        viewExe.setFilter(filterExe);
        BizExecuteReportCollection reportColls = BizExecuteReportFactory.getLocalInstance(ctx).getBizExecuteReportCollection(viewExe);
        for (int i = 0; i < reportColls.size(); ++i) {
            BizExecuteReportInfo report = reportColls.get(i);
            BizCalcInfo bizCalc = new BizCalcInfo();
            bizCalc.setId(BOSUuid.read((String)report.getBizCalcID()));
            bizCalc.setNumber(report.getBizCalcNumber());
            bizCalc.setName(report.getBizCalcName());
            ((List)resultMap.get("bizExecutingStr")).add(bizCalc);
        }
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _checkIsTempSave(Context ctx, List IDList) throws BOSException, EASBizException {
        if (IDList == null) {
            return null;
        }
        ArrayList<String> tempSaveList = new ArrayList<String>();
        Connection conn = null;
        IRowSet rowset = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" select FID From T_Mbg_BizCalc").append(" where FID in (");
        for (Object id : IDList) {
            sql.append("'").append(id).append("', ");
        }
        sql.delete(sql.length() - 2, sql.length() - 1).append(")").append(" and ( FState = ").append(3).append(" or FState = ").append(4).append(")");
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            rowset = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString());
            while (rowset.next()) {
                tempSaveList.add(rowset.getString("FID"));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((Connection)conn);
                SQLUtils.cleanup(rowset);
                throw throwable;
            }
            SQLUtils.cleanup((Connection)conn);
            SQLUtils.cleanup((ResultSet)rowset);
        }
        SQLUtils.cleanup((Connection)conn);
        SQLUtils.cleanup((ResultSet)rowset);
        return tempSaveList;
    }

    @Override
    protected Map _batchDelete(Context ctx, List idList, String bgSchemeID) throws BOSException, EASBizException {
        if (idList == null || bgSchemeID == null) {
            return null;
        }
        Map<String, Set<String>> incorrectState = this.checkDeleteSavedBizRule(ctx, bgSchemeID, idList);
        IBizRely bizRelyImpl = BizRelyFactory.getLocalInstance(ctx);
        HashMap<String, Set<String>> relyMap = new HashMap<String, Set<String>>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("bizCalc.bgScheme.id", (Object)bgSchemeID, CompareType.EQUALS));
        BizRelyCollection coll = bizRelyImpl.getBizRelyCollection(view);
        HashSet<String> bizSet = null;
        for (int i = 0; i < coll.size(); ++i) {
            BizRelyInfo bizRely = coll.get(i);
            String relyID = bizRely.getRelyBiz().getId().toString();
            String bizID = bizRely.getBizCalc().getId().toString();
            bizSet = (HashSet<String>)relyMap.get(relyID);
            if (bizSet == null) {
                bizSet = new HashSet<String>();
                relyMap.put(relyID, bizSet);
            }
            bizSet.add(bizID);
        }
        HashSet<String> rmSet = new HashSet<String>();
        HashSet<String> notRmSet = new HashSet<String>();
        for (String id : idList) {
            if (!rmSet.contains(id) && !notRmSet.contains(id) && !this.checkRely(id, idList, relyMap, rmSet, notRmSet)) continue;
        }
        if (rmSet != null && rmSet.size() > 0) {
            ArrayList<ObjectUuidPK> pkList = new ArrayList<ObjectUuidPK>();
            BizCalcServelHelper.updateHisBizcalc(ctx, rmSet);
            for (String id : rmSet) {
                pkList.add(new ObjectUuidPK(id));
            }
            if (!rmSet.isEmpty()) {
                this.recycleNumberByOrg(ctx, rmSet);
            }
            BizCalcFactory.getLocalInstance(ctx).delete(pkList.toArray(new IObjectPK[pkList.size()]));
            this.deleteBizRely(ctx, rmSet);
        }
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("*");
        selector.add("bizCalc.number");
        selector.add("relyBiz.number");
        filter.getFilterItems().clear();
        filter.getFilterItems().add(new FilterItemInfo("relyBiz.id", notRmSet, CompareType.INCLUDE));
        view.setFilter(filter);
        BizRelyCollection notRmColl = bizRelyImpl.getBizRelyCollection(view);
        for (int i = 0; i < notRmColl.size(); ++i) {
            String relyNumber = notRmColl.get(i).getRelyBiz().getNumber();
            String bizNumber = notRmColl.get(i).getBizCalc().getNumber();
            if (null == bizNumber) continue;
            HashSet<String> bizNumberSet = (HashSet<String>)result.get(relyNumber);
            if (bizNumberSet == null) {
                bizNumberSet = new HashSet<String>();
                result.put(relyNumber, bizNumberSet);
            }
            bizNumberSet.add(bizNumber);
        }
        result.putAll(incorrectState);
        return result;
    }

    private void recycleNumberByOrg(Context ctx, Set<String> rmSet) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("state");
        sic.add("orgUnit.id");
        sic.add("bgScheme.id");
        sic.add("bgScheme.number");
        sic.add("sourceType");
        view.setSelector(sic);
        filter.getFilterItems().add(new FilterItemInfo("id", rmSet, CompareType.INCLUDE));
        BizCalcCollection colls = this.getBizCalcCollection(ctx, view);
        for (int i = 0; i < colls.size(); ++i) {
            boolean useIntermitNumber;
            BizCalcInfo model = colls.get(i);
            if (StringUtils.isEmpty((String)model.getNumber())) {
                return;
            }
            String companyId = model.getOrgUnit().getId().toString();
            CodingRuleInfo codingRule = null;
            String orgUnitId = null;
            BindingPropertyInfo bindingProperty = null;
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            boolean isCodingRule = iCodingRuleManager.isExist((IObjectValue)model, companyId, "sourceType");
            if (!isCodingRule) {
                isCodingRule = iCodingRuleManager.isExist((IObjectValue)model, companyId);
            }
            if (isCodingRule && (codingRule = iCodingRuleManager.getCodingRule((IObjectValue)model, companyId, "sourceType")) == null) {
                codingRule = iCodingRuleManager.getCodingRule((IObjectValue)model, companyId);
            }
            if (codingRule != null) {
                orgUnitId = codingRule.getAppOrgUnit().getId().toString();
                bindingProperty = codingRule.getBindingProperty();
            }
            if (StringUtils.isEmpty(orgUnitId)) {
                orgUnitId = companyId;
            }
            if (!(useIntermitNumber = iCodingRuleManager.isUseIntermitNumber((IObjectValue)model, companyId, "sourceType"))) {
                useIntermitNumber = iCodingRuleManager.isUseIntermitNumber((IObjectValue)model, companyId);
            }
            if (!isCodingRule || !useIntermitNumber) continue;
            if (bindingProperty != null && bindingProperty.getPropertyName() != null) {
                iCodingRuleManager.recycleNumber((IObjectValue)model, orgUnitId, bindingProperty.getPropertyName(), "", model.getNumber());
                continue;
            }
            iCodingRuleManager.recycleNumber((IObjectValue)model, orgUnitId, model.getNumber());
        }
    }

    private Map<String, Set<String>> checkDeleteSavedBizRule(Context ctx, String bgSchemeId, List idList) throws BOSException {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        if (ctx == null || idList == null || idList.isEmpty()) {
            return result;
        }
        result.put("SavedMap", new HashSet());
        HashSet selectedBizRule = new HashSet();
        HashSet<String> removeSet = new HashSet<String>();
        selectedBizRule.addAll(idList);
        BizCalcCollection selectedBizCalcs = this.getBizCalcCollectionByIds(ctx, bgSchemeId, selectedBizRule);
        BizCalcInfo bizCalcInfo = null;
        int count = selectedBizCalcs.size();
        for (int i = 0; i < count; ++i) {
            bizCalcInfo = selectedBizCalcs.get(i);
            if (bizCalcInfo.getState() != BizStateEnum.SAVED) continue;
            ((Set)result.get("SavedMap")).add(bizCalcInfo.getNumber());
            removeSet.add(bizCalcInfo.getId().toString());
        }
        idList.removeAll(removeSet);
        return result;
    }

    private boolean checkRely(String relyID, List idList, Map<String, Set<String>> relyMap, Set<String> rmSet, Set<String> notRmSet) throws BOSException, EASBizException {
        Set<String> bizSet = relyMap.get(relyID);
        if (bizSet == null) {
            if (idList.contains(relyID)) {
                rmSet.add(relyID);
                return true;
            }
            return false;
        }
        boolean subCanDel = true;
        for (String bizID : bizSet) {
            subCanDel &= this.checkRely(bizID, idList, relyMap, rmSet, notRmSet);
        }
        if (subCanDel && idList.contains(relyID)) {
            rmSet.add(relyID);
            return true;
        }
        if (idList.contains(relyID)) {
            notRmSet.add(relyID);
        }
        return false;
    }

    private void deleteBizRely(Context ctx, Set<String> idSet) throws BOSException, EASBizException {
        if (ctx == null || idSet == null || idSet.isEmpty()) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bizCalc", idSet, CompareType.INCLUDE));
        BizRelyFactory.getLocalInstance(ctx).delete(filter);
    }

    @Override
    protected void _cancelCancel(Context ctx, BOSUuid bizId) throws BOSException, EASBizException {
        if (bizId == null) {
            return;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.addObjectCollection((IObjectCollection)BizCalcServelHelper.getSelectors());
        IBizCalc ibizCalc = BizCalcFactory.getLocalInstance(ctx);
        BizCalcInfo calcInfo = ibizCalc.getBizCalcInfo((IObjectPK)new ObjectUuidPK(bizId), sic);
        this.addHisBizcalc(ctx, calcInfo, false, false);
        if (calcInfo != null && 4 == calcInfo.getState().getValue()) {
            calcInfo.setState(BizStateEnum.SAVED);
            SelectorItemCollection upSic = new SelectorItemCollection();
            upSic.add("state");
            ibizCalc.updatePartial(calcInfo, upSic);
        }
    }

    @Override
    protected void _cancel(Context ctx, BOSUuid bizId) throws BOSException, EASBizException {
        if (bizId == null) {
            return;
        }
        boolean isExistsHis = BizCalcHistFactory.getLocalInstance(ctx).exists("select id where sourceBizCalcId = '" + bizId + "'");
        SelectorItemCollection sic = new SelectorItemCollection();
        if (isExistsHis) {
            sic.add("id");
            sic.add("state");
        } else {
            sic.addObjectCollection((IObjectCollection)BizCalcServelHelper.getSelectors());
        }
        IBizCalc ibizCalc = BizCalcFactory.getLocalInstance(ctx);
        BizCalcInfo calcInfo = ibizCalc.getBizCalcInfo((IObjectPK)new ObjectUuidPK(bizId), sic);
        if (!isExistsHis) {
            this.addHisBizcalc(ctx, calcInfo, false, true);
        }
        if (calcInfo != null && 2 == calcInfo.getState().getValue()) {
            calcInfo.setState(BizStateEnum.DISABLE);
            SelectorItemCollection upSic = new SelectorItemCollection();
            upSic.add("state");
            ibizCalc.updatePartial(calcInfo, upSic);
        }
    }

    @Override
    protected Map _cancelCancelColls(Context ctx, Set bizCalcIds, String bgSchemeId) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (bizCalcIds == null || bizCalcIds.isEmpty() || StringUtils.isEmpty((String)bgSchemeId)) {
            return result;
        }
        BizCalcCollection calcInfoColls = this.getBizCalcCollectionByIds(ctx, bgSchemeId, bizCalcIds);
        CoreBaseCollection updateColls = new CoreBaseCollection();
        HashSet<BizCalcInfo> calcInfoSet = new HashSet<BizCalcInfo>();
        HashMap<String, BizCalcInfo> tmpMap = new HashMap<String, BizCalcInfo>();
        BizCalcInfo tmpCalcInfo = null;
        for (int i = 0; i < calcInfoColls.size(); ++i) {
            tmpCalcInfo = calcInfoColls.get(i);
            if (tmpCalcInfo.getState().getValue() != 2) {
                tmpCalcInfo.setState(BizStateEnum.SAVED);
                tmpMap.put(tmpCalcInfo.getNumber(), tmpCalcInfo);
                calcInfoSet.add(tmpCalcInfo);
                continue;
            }
            if (result.get("incorrectNumSet") == null) {
                HashSet<String> inCorrectStateSet = new HashSet<String>();
                result.put("incorrectNumSet", inCorrectStateSet);
                inCorrectStateSet.add(tmpCalcInfo.getNumber());
                continue;
            }
            ((Set)result.get("incorrectNumSet")).add(tmpCalcInfo.getNumber());
        }
        this.transFormulaToSimple(calcInfoSet);
        Map<String, String> verifyResultMsg = this.getVerifyResultMsgByCalcColls(ctx, calcInfoSet, bgSchemeId);
        String calcNum2 = null;
        for (String calcNum2 : tmpMap.keySet()) {
            if (verifyResultMsg.containsKey(calcNum2)) continue;
            updateColls.add((CoreBaseInfo)tmpMap.get(calcNum2));
        }
        BizCalcServelHelper.addHisBizcalc(ctx, updateColls, false, false);
        result.put("cancelFailCount", calcInfoColls.size() - updateColls.size());
        result.put("totalSize", calcInfoColls.size());
        result.put("verifyErrorMsg", this.combineAllKeysToStr(verifyResultMsg));
        if (!updateColls.isEmpty()) {
            this.transSimpleToFormat(updateColls);
            BizCalcFactory.getLocalInstance(ctx).updateBatchData(updateColls);
            BizCalcRefUtils.getInterface(ctx).checkRef((IObjectCollection)updateColls).saveRef();
        }
        return result;
    }

    private void addHisBizcalc(Context ctx, BizCalcInfo info, boolean isDelete, boolean isFromCancel) throws EASBizException, BOSException {
        CoreBaseCollection updateColls = new CoreBaseCollection();
        updateColls.add((CoreBaseInfo)info);
        BizCalcServelHelper.addHisBizcalc(ctx, updateColls, isDelete, isFromCancel);
    }

    private void transSimpleToFormat(CoreBaseCollection updateColls) {
        BizCalcServelHelper.transSimpleToFormat(updateColls);
    }

    private void transFormulaToSimple(Set<BizCalcInfo> calcInfoSet) {
        BizCalcServelHelper.transFormulaToSimple(calcInfoSet);
    }

    private String combineAllKeysToStr(Map<String, String> verifyResultMsg) {
        return BizCalcServelHelper.combineAllKeysToStr(verifyResultMsg);
    }

    private BizCalcCollection getBizCalcCollectionByIds(Context ctx, String bgSchemeId, Set bizCalcIds) throws BOSException {
        return BizCalcServelHelper.getBizCalcCollectionByIds(ctx, bgSchemeId, bizCalcIds);
    }

    private Map<String, String> getVerifyResultMsgByCalcColls(Context ctx, Set<BizCalcInfo> calcInfoSet, String bgSchemeId) throws EASBizException, BOSException {
        Map<String, String> resultMap = new HashMap<String, String>();
        if (ctx == null || calcInfoSet == null || calcInfoSet.isEmpty() || StringUtils.isEmpty((String)bgSchemeId)) {
            return resultMap;
        }
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(ctx, bgSchemeId);
        resultMap = BizCalcServelHelper.getVerifyResultMsgByCalcColls(ctx, calcInfoSet, schemeHelper);
        return resultMap;
    }

    @Override
    protected Map _batchCancel(Context ctx, Set calcIds) throws BOSException, EASBizException {
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        HashSet inCorrectStateSet = new HashSet();
        result.put("incorrectNumSet", inCorrectStateSet);
        if (calcIds == null || calcIds.isEmpty()) {
            return result;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.addObjectCollection((IObjectCollection)BizCalcServelHelper.getSelectors());
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(sic);
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)calcIds, CompareType.INCLUDE));
        IBizCalc ibizCalc = BizCalcFactory.getLocalInstance(ctx);
        BizCalcCollection calcInfoColls = ibizCalc.getBizCalcCollection(evi);
        CoreBaseCollection updateColls = new CoreBaseCollection();
        BizCalcInfo tmpCalcInfo = null;
        for (int i = 0; i < calcInfoColls.size(); ++i) {
            tmpCalcInfo = calcInfoColls.get(i);
            if (tmpCalcInfo.getState().getValue() == 2) {
                tmpCalcInfo.setState(BizStateEnum.DISABLE);
                updateColls.add((CoreBaseInfo)tmpCalcInfo);
                continue;
            }
            ((Set)result.get("incorrectNumSet")).add(tmpCalcInfo.getNumber());
        }
        result.put("cancelFailCount", Integer.valueOf(calcInfoColls.size() - updateColls.size()));
        result.put("totalSize", Integer.valueOf(calcInfoColls.size()));
        if (!updateColls.isEmpty()) {
            HashSet<String> bizCalcIds = new HashSet<String>();
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add("id");
            view.getSelector().add("sourceBizCalcId");
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("sourceBizCalcId", (Object)calcIds, CompareType.INCLUDE));
            view.setFilter(filter);
            BizCalcHistCollection histCol = BizCalcHistFactory.getLocalInstance(ctx).getBizCalcHistCollection(view);
            if (histCol != null && !histCol.isEmpty()) {
                int in = histCol.size();
                for (int i = 0; i < in; ++i) {
                    bizCalcIds.add(histCol.get(i).getSourceBizCalcId());
                }
            }
            CoreBaseCollection needAddHis = new CoreBaseCollection();
            int in = updateColls.size();
            for (int i = 0; i < in; ++i) {
                if (bizCalcIds.contains(updateColls.get(i).getId().toString())) continue;
                needAddHis.add(updateColls.get(i));
            }
            BizCalcServelHelper.addHisBizcalc(ctx, needAddHis, false, true);
            ibizCalc.updateBatchData(updateColls);
            BizCalcRefUtils.getInterface(ctx).deleteRef((IObjectCollection)updateColls);
        }
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean _checkPeriodVariable(Context ctx, BOSUuid bgSchemeId, List calcIds, boolean isBackBiz) throws BOSException, EASBizException {
        boolean check = false;
        if (ctx == null) return check;
        if (bgSchemeId == null) {
            return check;
        }
        Connection conn = null;
        IRowSet rst = null;
        ArrayList<String> bizCalcIds = new ArrayList<String>();
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            conn = this.getConnection(ctx);
            if (calcIds == null || calcIds.isEmpty()) {
                rst = BgDBUtils.executeQuery((Connection)conn, (String)"select FID from T_MBG_BizCalc where FOrgTreeId is null and FBgSchemeID = ? and FIsBGExe = ? and FState = 2", (Object[])new Object[]{bgSchemeId.toString(), isBackBiz});
                while (rst.next()) {
                    bizCalcIds.add(rst.getString(1));
                }
                SQLUtils.cleanup((ResultSet)rst);
            } else {
                bizCalcIds.addAll(calcIds);
            }
            BizCalcQuery query = new BizCalcQuery(ctx);
            List<BizCalcInfo> calcs = query.queryBizCalc(conn, pool, bizCalcIds);
            if (calcs != null) {
                MBgPeriodVariable variable = new MBgPeriodVariable(null);
                check = variable.checkPeirodVariale(calcs, null, null, false);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (Exception ex2) {
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, null, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        return check;
    }

    @Override
    protected List _bizDim(Context ctx, String bgSchemeId, String orgUnitId, String formula, String versionNumber, String bgPeriodNumber) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)bgSchemeId) || StringUtils.isEmpty((String)versionNumber) || StringUtils.isEmpty((String)formula) || StringUtils.isEmpty((String)orgUnitId)) {
            return null;
        }
        BgSchemeInfo bgScheme = BgViewServerHelper.getBgSchemeCubeInfo((Context)ctx, (BOSUuid)BOSUuid.read((String)bgSchemeId));
        MbgDimCollection mbgDims = DimUtils.getDimensionColls((Context)ctx);
        ArrayList<BizDimInfo> bizDims = new ArrayList<BizDimInfo>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("bizCalcSubset.*");
        selector.add("bizCalcSubset.scope.*");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemeId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)2, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgTree.id", null, CompareType.EQUALS));
        view.setFilter(filter);
        view.setSorter(new SorterItemCollection());
        view.getSorter().add(new SorterItemInfo("number"));
        view.getSorter().add(new SorterItemInfo("bizCalcSubset.seq"));
        BizCalcCollection calcs = BizCalcFactory.getLocalInstance(ctx).getBizCalcCollection(view);
        if (calcs == null || calcs.isEmpty()) {
            return bizDims;
        }
        String srcNumber = null;
        String field = null;
        HashMap<String, Set<String>> refNumMap = new HashMap<String, Set<String>>();
        BizCalcQuery query = BizCalcQuery.getInstance(ctx);
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(ctx, bgSchemeId);
        BgOrgUnitInfo orgUnit = BgOrgUnitFactory.getLocalInstance((Context)ctx).getBgOrgUnitInfo("select id, number, longNumber, name, orgUnitId where isVirtual = 0 and viewId = '" + schemeHelper.getBgOrgViewId() + "' and orgUnitId = '" + orgUnitId + "'");
        HashSet<String> orgNumbers = new HashSet<String>();
        orgNumbers.add(orgUnit.getNumber());
        BgOrgUnitCollection orgCol = BgOrgUnitFactory.getLocalInstance((Context)ctx).getBgOrgUnitCollection("select number where isVirtual = 0 and viewId = '" + schemeHelper.getBgOrgViewId() + "' and longNumber like '" + orgUnit.getLongNumber() + "!%'");
        if (orgCol != null && !orgCol.isEmpty()) {
            for (int i = 0; i < orgCol.size(); ++i) {
                orgNumbers.add(orgCol.get(i).getNumber());
            }
        }
        Map<String, String> variateMap = query.queryVariate(ctx, BOSUuid.read((String)bgSchemeId));
        HashSet<String> bgPeriodNums = new HashSet<String>();
        if (bgPeriodNumber != null) {
            bgPeriodNums.add(bgPeriodNumber);
        }
        try {
            if (!calcs.isEmpty() && bgPeriodNumber != null) {
                ArrayList<BizCalcInfo> _calcs = new ArrayList<BizCalcInfo>();
                for (int i = 0; i < calcs.size(); ++i) {
                    _calcs.add(calcs.get(i));
                }
                MBgPeriodVariable variable = new MBgPeriodVariable(ctx.getLocale());
                variable.transPeirodVariale(ctx, _calcs, bgPeriodNums, null);
            }
            Map srcFieldMap = MbgQingAnalyseHelper.getSrcFieldMap((Context)ctx, (BgSchemeDimensionHelper)schemeHelper);
            HashSet<String> formulaSet = new HashSet<String>();
            formulaSet.add(formula);
            HashSet<String> versionSet = new HashSet<String>();
            versionSet.add(versionNumber);
            MbgViewManagerImpl viewManager = DimensionFormulaHelper.buildViewMamager((Context)ctx, formulaSet, versionSet);
            IBgDimensionManager dimManager = ((IMbgSheetManager)viewManager.getSheetManagers().get(0)).getDimensionManager();
            BgDimensionInfo dimension = null;
            for (int d = 0; d < dimManager.getDimension().size(); ++d) {
                dimension = (BgDimensionInfo)dimManager.getDimension().get(d);
                if (dimension.getMember().isEmpty()) continue;
                ((BgDimensionMember)dimension.getMember().get(0)).setFillType(5);
            }
            viewManager = TemplateFacadeFactory.getLocalInstance((Context)ctx).loadViewManager(orgUnitId, bgSchemeId, (IMbgViewManager)viewManager);
            dimManager = ((IMbgSheetManager)viewManager.getSheetManagers().get(0)).getDimensionManager();
            HashMap<String, Set<String>> formulaMemberMap = new HashMap<String, Set<String>>();
            formulaMemberMap.put(DimensionConstants.DEF_VERSION_FIELD, versionSet);
            for (int d = 0; d < dimManager.getDimension().size(); ++d) {
                dimension = (BgDimensionInfo)dimManager.getDimension().get(d);
                if (dimension.getMember().isEmpty()) continue;
                field = schemeHelper.getRefField(dimension.getNumber());
                srcNumber = schemeHelper.getSrcNumber(dimension.getNumber());
                formulaMemberMap.put(field, new HashSet());
                for (int m = 0; m < dimension.getMember().size(); ++m) {
                    if (DimUtils.checkBaseDimension((String)dimension.getNumber())) {
                        ((Set)formulaMemberMap.get(field)).add(BgViewHelper.getNumber(dimension.getMember().get(m)));
                        continue;
                    }
                    ((Set)formulaMemberMap.get(field)).add(DimensionFormulaHelper.getCombination((String)srcNumber, (String)BgViewHelper.getNumber(dimension.getMember().get(m))));
                }
            }
            String formulaPeriod = BgNFSHelper.parseFormulaPara((String)formula)[1];
            BgPeriodDispCollection bgPeriodCol = BgPeriodDispFactory.getLocalInstance((Context)ctx).getBgPeriodDispCollection("select longNumber where number = '" + formulaPeriod + "'");
            bgPeriodCol = BgPeriodDispFactory.getLocalInstance((Context)ctx).getBgPeriodDispCollection("select number where longNumber like '" + bgPeriodCol.get(0).getLongNumber() + "!%'");
            for (int i = 0; i < bgPeriodCol.size(); ++i) {
                ((Set)formulaMemberMap.get(DimensionConstants.DEF_PERIOD_FIELD)).add(bgPeriodCol.get(i).getNumber());
            }
            if (calcs != null && !calcs.isEmpty()) {
                HashSet<String> ids = new HashSet<String>();
                BizCalcInfo calcInfo = null;
                BizCalcSubsetInfo subSetInfo = null;
                int in = calcs.size();
                for (int i = 0; i < in; ++i) {
                    calcInfo = calcs.get(i);
                    BgVariateUtils.transVariate((BizCalcInfo)calcInfo, variateMap);
                    for (int c = 0; c < calcInfo.getBizCalcSubset().size(); ++c) {
                        refNumMap.clear();
                        subSetInfo = calcInfo.getBizCalcSubset().get(c);
                        boolean isMatch = false;
                        for (String orgNumbrr : orgNumbers) {
                            if (!subSetInfo.checkHasOrgScope(ctx, orgUnit.getNumber(), schemeHelper.getBgOrgViewId(), bgSchemeId, null)) continue;
                            isMatch = true;
                            break;
                        }
                        if (!isMatch) continue;
                        Map<String, Set<String>> scopData = subSetInfo.getScopeData(variateMap, bgPeriodNums, null, true, true, ctx, bgScheme, mbgDims);
                        if (scopData != null) {
                            refNumMap.putAll(scopData);
                            refNumMap.remove(DimensionConstants.DEF_ORGUNIT_FIELD);
                        }
                        if (!this.martch(refNumMap, formulaMemberMap)) continue;
                        IExpress expre = null;
                        List<IExpress> express = null;
                        express = calcInfo.getBizCalcSubset().get(c).getExpres();
                        if (express == null) continue;
                        int jn = express.size();
                        for (int j = 0; j < jn; ++j) {
                            expre = express.get(j);
                            if (!(expre instanceof BinaryExpr)) continue;
                            refNumMap.clear();
                            BizExprUtils.putMbgMember(((BinaryExpr)expre).left, refNumMap, srcFieldMap, null);
                            if (!this.martch(refNumMap, formulaMemberMap)) continue;
                            BizDimInfo bizDimInfo = new BizDimInfo();
                            bizDimInfo.setExpress(expre.getOriginalExpr());
                            subSetInfo.setBizCalc(calcInfo);
                            bizDimInfo.setSubSet(subSetInfo);
                            ids.add(calcInfo.getId().toString());
                            bizDims.add(bizDimInfo);
                        }
                    }
                }
                if (!ids.isEmpty()) {
                    Map templateMap = BizRefBgTemplateFactory.getLocalInstance(ctx).getRefBgTemplates(ids);
                    for (BizDimInfo bizDimInfo : bizDims) {
                        if (!templateMap.containsKey(bizDimInfo.getSubSet().getBizCalc().getId().toString())) continue;
                        bizDimInfo.setRefBgTemplate((List)templateMap.get(bizDimInfo.getSubSet().getBizCalc().getId().toString()));
                    }
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return bizDims;
    }

    private boolean martch(Map<String, Set<String>> refNumMap, Map<String, Set<String>> formulaMemberMap) {
        boolean isMartch = true;
        HashSet subSet = new HashSet();
        for (String _field : refNumMap.keySet()) {
            if (!formulaMemberMap.containsKey(_field)) {
                isMartch = false;
                break;
            }
            subSet.clear();
            subSet.addAll(formulaMemberMap.get(_field));
            subSet.retainAll((Collection)refNumMap.get(_field));
            if (!subSet.isEmpty()) continue;
            isMartch = false;
            break;
        }
        return isMartch;
    }

    @Override
    protected List _importCalc(Context ctx, String bgSchemeId, String orgUnitId, Map calcMap, Map refBgTempMap, Map relyMap) throws BOSException, EASBizException {
        if (calcMap == null || calcMap.isEmpty()) {
            return null;
        }
        ArrayList<BgCopySchemeResult> result = new ArrayList<BgCopySchemeResult>();
        BgSchemeInfo bgScheme = new BgSchemeInfo();
        bgScheme.setId(BOSUuid.read((String)bgSchemeId));
        FullOrgUnitInfo orgUnit = new FullOrgUnitInfo();
        orgUnit.setId(BOSUuid.read((String)orgUnitId));
        Map _calcMap = calcMap;
        Map _refBgTempMap = refBgTempMap;
        Map _relyMap = relyMap;
        BizCalcInfo bizCalcInfo2 = null;
        BgTemplateCollection bgTemplateCol2 = null;
        BgTemplateInfo bgTemplateInfo = null;
        String bizCalcId2 = null;
        HashSet<String> keys = new HashSet<String>();
        HashMap<String, Object> number_info = new HashMap<String, Object>();
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("number");
        evi.setFilter(new FilterInfo());
        Iterator it = _calcMap.values().iterator();
        while (it.hasNext()) {
            keys.add(((BizCalcInfo)it.next()).getNumber());
        }
        evi.getFilter().getFilterItems().clear();
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemeId, CompareType.EQUALS));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("number", keys, CompareType.INCLUDE));
        BizCalcCollection bizCalcCol = this.getBizCalcCollection(ctx, evi);
        HashSet<String> hasBizNumber = new HashSet<String>();
        if (bizCalcCol != null && !bizCalcCol.isEmpty()) {
            for (int i = 0; i < bizCalcCol.size(); ++i) {
                hasBizNumber.add(bizCalcCol.get(i).getNumber());
            }
        }
        if (_refBgTempMap != null && !_refBgTempMap.isEmpty()) {
            int i;
            keys.clear();
            for (BgTemplateCollection bgTemplateCol2 : _refBgTempMap.values()) {
                for (i = 0; i < bgTemplateCol2.size(); ++i) {
                    if (StringUtils.isEmpty((String)bgTemplateCol2.get(i).getNumber())) continue;
                    keys.add(bgTemplateCol2.get(i).getNumber());
                }
            }
            evi.getFilter().getFilterItems().clear();
            evi.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemeId, CompareType.EQUALS));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("number", keys, CompareType.INCLUDE));
            BgTemplateCollection tempCol = BgTemplateFactory.getLocalInstance((Context)ctx).getBgTemplateCollection(evi);
            for (i = 0; i < tempCol.size(); ++i) {
                number_info.put(tempCol.get(i).getNumber(), tempCol.get(i));
            }
            for (String bizCalcId2 : _refBgTempMap.keySet()) {
                bgTemplateCol2 = (BgTemplateCollection)_refBgTempMap.get(bizCalcId2);
                Iterator it1 = bgTemplateCol2.iterator();
                while (it1.hasNext()) {
                    bgTemplateInfo = (BgTemplateInfo)it1.next();
                    if (!number_info.containsKey(bgTemplateInfo.getNumber())) {
                        it1.remove();
                        continue;
                    }
                    bgTemplateInfo.setId(((BgTemplateInfo)number_info.get(bgTemplateInfo.getNumber())).getId());
                }
                if (!bgTemplateCol2.isEmpty() && _calcMap.containsKey(bizCalcId2)) {
                    bizCalcInfo2 = (BizCalcInfo)_calcMap.get(bizCalcId2);
                    bizCalcInfo2.put("bgtemplate", bgTemplateCol2);
                }
                if (!bgTemplateCol2.isEmpty()) continue;
                BizCalcInfo remove = (BizCalcInfo)_calcMap.remove(bizCalcId2);
                String baseMsg = EASResource.getString((String)this.RES, (String)"biz");
                String name = this.getName(remove);
                String copyResult = EASResource.getString((String)this.RES, (String)"bizNotTemp");
                BgCopySchemeResult s = new BgCopySchemeResult();
                s.setBaseMsg(baseMsg);
                s.setName(name);
                s.setCopyResult(copyResult);
                result.add(s);
            }
        }
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(ctx, bgSchemeId);
        LinkedHashMap<String, LinkedHashMap<String, String>> bizCalcFormulaMap = new LinkedHashMap<String, LinkedHashMap<String, String>>();
        LinkedHashMap<String, Map<String, Set<String>>> bizScopeSrcMap = new LinkedHashMap<String, Map<String, Set<String>>>();
        LinkedHashMap<String, Map<String, BizScopeCollection>> bizScopeMap = new LinkedHashMap<String, Map<String, BizScopeCollection>>();
        BizFormulaVerifyHelper.buildParseParam(_calcMap.values(), bizCalcFormulaMap, bizScopeSrcMap, bizScopeMap, schemeHelper);
        BizFormulaVerifyHelper formulaParser = new BizFormulaVerifyHelper(bizCalcFormulaMap, bizScopeSrcMap, bizScopeMap, schemeHelper, true, BizFormulaVerifyHelper.getMemberMaps(_calcMap.values()));
        formulaParser.batchParse();
        HashSet<String> parseErrorNumber = new HashSet<String>();
        for (String number : formulaParser.getAllExceptions().keySet()) {
            Map<String, Map<Integer, List<Exception>>> subsetException = formulaParser.getAllExceptions().get(number);
            for (Map<Integer, List<Exception>> lineException : subsetException.values()) {
                if (lineException.isEmpty()) continue;
                parseErrorNumber.add(number);
            }
        }
        if (_relyMap != null && !_relyMap.isEmpty()) {
            keys.clear();
            number_info.clear();
            for (List bizs : _relyMap.values()) {
                for (BizCalcInfo bizCalcInfo2 : bizs) {
                    keys.add(bizCalcInfo2.getNumber());
                }
            }
            evi.getFilter().getFilterItems().clear();
            evi.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemeId, CompareType.EQUALS));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("number", keys, CompareType.INCLUDE));
            bizCalcCol = this.getBizCalcCollection(ctx, evi);
            for (int i = 0; i < bizCalcCol.size(); ++i) {
                number_info.put(bizCalcCol.get(i).getNumber(), bizCalcCol.get(i));
            }
            for (BizCalcInfo bizCalcInfo2 : _calcMap.values()) {
                if (number_info.containsKey(bizCalcInfo2.getNumber()) || parseErrorNumber.contains(bizCalcInfo2.getNumber()) || hasBizNumber.contains(bizCalcInfo2.getNumber())) continue;
                number_info.put(bizCalcInfo2.getNumber(), bizCalcInfo2);
            }
            for (String bizCalcId2 : _calcMap.keySet()) {
                List bizs;
                if (!_relyMap.containsKey(bizCalcId2)) continue;
                bizs = (List)_relyMap.get(bizCalcId2);
                Iterator it1 = bizs.iterator();
                while (it1.hasNext()) {
                    bizCalcInfo2 = (BizCalcInfo)it1.next();
                    if (!number_info.containsKey(bizCalcInfo2.getNumber())) {
                        it1.remove();
                        continue;
                    }
                    bizCalcInfo2.setId(((CoreBaseInfo)number_info.get(bizCalcInfo2.getNumber())).getId());
                }
                if (bizs.isEmpty()) continue;
                ((BizCalcInfo)_calcMap.get(bizCalcId2)).put("prebizcalc", bizs);
            }
        }
        boolean hasFail = !hasBizNumber.isEmpty() || !parseErrorNumber.isEmpty();
        IBizCalcGroup iBizCalcGroup = BizCalcGroupFactory.getLocalInstance(ctx);
        CoreBaseCollection updateColls = new CoreBaseCollection();
        CoreBaseCollection subSetCol = new CoreBaseCollection();
        for (BizCalcInfo bizCalcInfo2 : _calcMap.values()) {
            bizCalcInfo2.setId(BOSUuid.create((BOSObjectType)bizCalcInfo2.getBOSType()));
            if (hasBizNumber.contains(bizCalcInfo2.getNumber())) {
                String baseMsg = EASResource.getString((String)this.RES, (String)"biz");
                String name = this.getName(bizCalcInfo2);
                String orgName = this.getOrgName(bizCalcInfo2.getOrgUnit());
                String copyResult = EASResource.getString((String)this.RES, (String)"bizExistsNumber");
                BgCopySchemeResult s = new BgCopySchemeResult();
                s.setBaseMsg(baseMsg);
                s.setName(name);
                s.setCopyResult(copyResult);
                s.setOrgName(orgName);
                result.add(s);
                continue;
            }
            if (!bizCalcInfo2.getBizCalcGroup().getId().toString().equals("IkpMdUyjQyOGom8OtZ0y2TQyFtQ=")) {
                if (iBizCalcGroup.exists("where number = '" + bizCalcInfo2.getBizCalcGroup().getNumber() + "' and bgScheme.id = '" + bgSchemeId + "' and isCsl = 0")) {
                    BizCalcGroupInfo group = iBizCalcGroup.getBizCalcGroupInfo("where number = '" + bizCalcInfo2.getBizCalcGroup().getNumber() + "' and bgScheme.id = '" + bgSchemeId + "' and isCsl = 0");
                    if (group != null) {
                        bizCalcInfo2.setBizCalcGroup(group);
                    }
                } else {
                    BizCalcGroupInfo bizCalcGroup = bizCalcInfo2.getBizCalcGroup();
                    bizCalcGroup.setId(BOSUuid.create((BOSObjectType)bizCalcGroup.getBOSType()));
                    bizCalcGroup.setBgScheme(bgScheme);
                    bizCalcGroup.setOrgUnit(orgUnit);
                    bizCalcInfo2.setBizCalcGroup(bizCalcGroup);
                    iBizCalcGroup.addnew(bizCalcGroup);
                }
            }
            if (formulaParser.getAllExceptions().containsKey(bizCalcInfo2.getNumber())) {
                boolean hasException = false;
                Map<String, Map<Integer, List<Exception>>> subsetException = formulaParser.getAllExceptions().get(bizCalcInfo2.getNumber());
                StringBuilder msg = new StringBuilder();
                for (String subsetName : subsetException.keySet()) {
                    Map<Integer, List<Exception>> lineException = subsetException.get(subsetName);
                    ArrayList<Integer> keyList = new ArrayList<Integer>(lineException.keySet());
                    Collections.sort(keyList);
                    for (Integer line : keyList) {
                        hasException = true;
                        List<Exception> Exceptions = lineException.get(line);
                        for (Exception exception : Exceptions) {
                            msg.append(new BizCalcParseException(BizCalcParseException.ERROR_SHOWBIZNAME, new Object[]{bizCalcInfo2.getNumber(), exception.getMessage()}).getMessage() + ";");
                        }
                    }
                }
                if (hasException) {
                    String baseMsg = EASResource.getString((String)this.RES, (String)"biz");
                    String name = this.getName(bizCalcInfo2);
                    BgCopySchemeResult s = new BgCopySchemeResult();
                    s.setBaseMsg(baseMsg);
                    s.setName(name);
                    s.setCopyResult(msg.toString());
                    result.add(s);
                    continue;
                }
            }
            subSetCol.addObjectCollection((IObjectCollection)bizCalcInfo2.getBizCalcSubset());
            bizCalcInfo2.setBgScheme(bgScheme);
            bizCalcInfo2.setOrgUnit(orgUnit);
            bizCalcInfo2.setVersion(BizCalcServelHelper.DEFAULT_VERSION);
            BizCalcSubsetCollection bizCalcSubset = bizCalcInfo2.getBizCalcSubset();
            CoreBaseCollection subsetCol = new CoreBaseCollection();
            if (bizCalcSubset != null) {
                for (int i = 0; i < bizCalcSubset.size(); ++i) {
                    BizCalcSubsetInfo bizCalcSubsetInfo = bizCalcSubset.get(i);
                    bizCalcSubsetInfo.setId(BOSUuid.create((BOSObjectType)bizCalcSubsetInfo.getBOSType()));
                    bizCalcSubsetInfo.setBizCalc(bizCalcInfo2);
                    BizScopeCollection scope = bizCalcSubsetInfo.getScope();
                    for (int j = 0; j < scope.size(); ++j) {
                        scope.get(j).setBizCalcSubset(bizCalcSubsetInfo);
                    }
                    subsetCol.add((CoreBaseInfo)bizCalcSubsetInfo);
                }
            }
            this._submit(ctx, (IObjectValue)bizCalcInfo2);
            BizCalcSubsetFactory.getLocalInstance(ctx).saveBatchData(subsetCol);
            updateColls.add((CoreBaseInfo)bizCalcInfo2);
            if (!BizStateEnum.SAVED.equals((Object)bizCalcInfo2.getState())) continue;
            bizCalcInfo2.setVersion(null);
            this.addHisBizcalc(ctx, bizCalcInfo2, false, false);
        }
        if (!updateColls.isEmpty()) {
            BizCalcRefUtils.getInterface(ctx).checkRef((IObjectCollection)updateColls).saveRef();
        }
        return result;
    }

    private String getName(BizCalcInfo info) {
        return info.getName() + "(" + info.getNumber() + ")";
    }

    private String getOrgName(FullOrgUnitInfo info) {
        return info.getNumber() + "(" + info.getName() + ")";
    }

    protected class BizCalcRunner
    implements Runnable {
        private Context ctx = null;
        private BOSUuid bgSchemeId = null;
        private BOSUuid unionId = null;
        private List calcIds = null;
        private int calcType = 0;
        private String bgPeriodNum = null;
        private Map<String, Set<String>> executeDimData = null;

        BizCalcRunner(Context ctx, BOSUuid bgSchemeId, BOSUuid unionId, List calcIds, int calcType, String bgPeriodNum, Map executeDimData) {
            this.ctx = ctx;
            this.bgSchemeId = bgSchemeId;
            this.unionId = unionId;
            this.calcIds = calcIds;
            this.calcType = calcType;
            this.bgPeriodNum = bgPeriodNum;
            this.executeDimData = executeDimData;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            com.kingdee.eas.ma.biz.api.IBizCalc bizCalcCaller = BizCalcCaller.getInstance();
            try {
                Map costCenterMap = BizFacadeFactory.getLocalInstance(this.ctx).getCostCenterIDByCalcID(this.calcIds, this.bgSchemeId, this.unionId);
                HashSet allCostCenterIds = new HashSet();
                Iterator iter = costCenterMap.values().iterator();
                while (iter.hasNext()) {
                    allCostCenterIds.addAll((Collection)iter.next());
                }
                ArrayList<BOSUuid> billIds = new ArrayList<BOSUuid>();
                for (String costCenterId : allCostCenterIds) {
                    billIds.add(BOSUuid.read((String)costCenterId));
                }
                List orgUnits = MbgDataHelper.getBaseOrgUnitsByUuid((Context)this.ctx, billIds);
                HashMap<String, OrgUnitInfo> orgUnitMaps = new HashMap<String, OrgUnitInfo>();
                for (OrgUnitInfo info : orgUnits) {
                    orgUnitMaps.put(info.getId().toString(), info);
                }
                if (costCenterMap == null) return;
                BizExecuteResultEnum result = BizExecuteResultEnum.SECCESS;
                String message = null;
                for (String bizCalcID : costCenterMap.keySet()) {
                    try {
                        for (String costCenterID : (Set)costCenterMap.get(bizCalcID)) {
                            if (this.executeDimData != null && this.executeDimData.get(DimensionBaseConstants.DEF_ORGUNIT_FIELD) != null && !this.executeDimData.get(DimensionBaseConstants.DEF_ORGUNIT_FIELD).contains(((OrgUnitInfo)orgUnitMaps.get(costCenterID)).getNumber())) continue;
                            if (this.executeDimData != null && !this.executeDimData.isEmpty() && this.executeDimData.containsKey(DimensionBaseConstants.DEF_PROCESS_FIELD)) {
                                Set<String> processTypes = this.executeDimData.get(DimensionBaseConstants.DEF_PROCESS_FIELD);
                                for (String p : processTypes) {
                                    int valueType = DimensionCommonHelper.getDataType((BgProcessEnum)BgProcessEnum.getEnum((String)p));
                                    bizCalcCaller.calcUpdate(this.ctx, this.bgSchemeId, BOSUuid.read((String)costCenterID), Arrays.asList(BOSUuid.read((String)bizCalcID)), valueType, this.bgPeriodNum, this.unionId, this.executeDimData);
                                }
                                continue;
                            }
                            bizCalcCaller.calcUpdate(this.ctx, this.bgSchemeId, BOSUuid.read((String)costCenterID), Arrays.asList(BOSUuid.read((String)bizCalcID)), this.calcType, this.bgPeriodNum, this.unionId, this.executeDimData);
                        }
                    }
                    catch (Exception e) {
                        block13: {
                            try {
                                logger.error((Object)"", (Throwable)e);
                                result = BizExecuteResultEnum.ERROR;
                                message = e.getCause().getMessage();
                                if (!(e.getCause() instanceof BgPeriodException)) break block13;
                                message = e.getCause().getCause().getMessage();
                            }
                            catch (Throwable throwable) {
                                BizCalcControllerBean.this.updateReport(this.ctx, Arrays.asList(bizCalcID), result, message, orgUnitMaps);
                                throw throwable;
                                return;
                            }
                        }
                        BizCalcControllerBean.this.updateReport(this.ctx, Arrays.asList(bizCalcID), result, message, orgUnitMaps);
                        continue;
                    }
                    BizCalcControllerBean.this.updateReport(this.ctx, Arrays.asList(bizCalcID), result, message, orgUnitMaps);
                }
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
    }
}

