/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.biz.BizCalcException;
import com.kingdee.eas.ma.biz.app.AbstractBizCalcFacadeControllerBean;
import com.kingdee.eas.ma.biz.app.MbgBizCalcService;
import com.kingdee.eas.ma.biz.app.utils.BgAdjustBillBizCalcHelper;
import com.kingdee.eas.ma.biz.execute.calc.face.ICalcData;
import com.kingdee.eas.ma.biz.execute.calc.impl.BizCalcImpl;
import com.kingdee.eas.ma.biz.execute.face.IBizParameter;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BizCalcFacadeControllerBean
extends AbstractBizCalcFacadeControllerBean {
    private static final long serialVersionUID = 6046547870332974996L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.biz.app.BizCalcFacadeControllerBean");

    @Override
    protected Map _executeBiz(Context ctx, IBizParameter parameter) throws BOSException, EASBizException {
        this.beforeCheck(ctx, parameter);
        Map<String, Map<String, ICalcData>> result = null;
        BizCalcImpl calc = new BizCalcImpl(ctx, parameter);
        try {
            result = calc.calc();
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Override
    protected void _executeUpdate(Context ctx, IBizParameter parameter) throws BOSException, EASBizException {
        try {
            this.executeUpdateLocal(ctx, parameter, null);
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.error((Object)"executeUpdate Error:", (Throwable)ex);
            throw new BizCalcException(BizCalcException.CALCEXCEPTION, new String[]{ex.getMessage()});
        }
    }

    @Override
    protected void _executeBGUpdate(Context ctx, IBizParameter parameter) throws BOSException {
        try {
            this.executeUpdateLocal(ctx, parameter, null);
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    private void executeUpdateLocal(Context ctx, IBizParameter parameter, List adjustBillIds) throws Exception {
        this.beforeCheck(ctx, parameter);
        BizCalcImpl calc = new BizCalcImpl(ctx, parameter);
        Map<String, Map<String, ICalcData>> calcMap = calc.calc();
        if (calcMap != null && !calcMap.isEmpty()) {
            if (calc.isMultiProcessType()) {
                Map<String, Map<String, ICalcData>> dataMap = calcMap;
                for (String processType : dataMap.keySet()) {
                    Map<String, ICalcData> valueMap = dataMap.get(processType);
                    parameter.setValueType(DimensionCommonHelper.getDataType((BgProcessEnum)BgProcessEnum.getEnum((String)processType)));
                    calc.setParameter(parameter);
                    calc.updateResult(valueMap);
                }
            } else {
                calc.updateResult(calcMap);
            }
        }
    }

    @Override
    protected void _executeUpdate(Context ctx) throws BOSException, EASBizException {
        MbgBizCalcService service = new MbgBizCalcService(ctx);
        service.execute();
    }

    @Override
    protected void _executeBizAdjust(final Context ctx, final Set billIds) throws BOSException, EASBizException {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    BgAdjustBillBizCalcHelper helper = new BgAdjustBillBizCalcHelper(ctx);
                    helper.executeBizAdjust(billIds);
                }
                catch (EASBizException e) {
                    logger.error((Object)"", (Throwable)e);
                }
                catch (BOSException e) {
                    logger.error((Object)"", (Throwable)e);
                }
            }
        };
        thread.start();
    }
}

