/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.biz.BizCalcException;
import com.kingdee.eas.ma.biz.BizCalcGroupCollection;
import com.kingdee.eas.ma.biz.BizCalcGroupInfo;
import com.kingdee.eas.ma.biz.app.AbstractBizCalcGroupControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class BizCalcGroupControllerBean
extends AbstractBizCalcGroupControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.biz.app.BizCalcGroupControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BizCalcGroupInfo info = (BizCalcGroupInfo)model;
        if (this.isNumberExists(ctx, info)) {
            throw new BizCalcException(BizCalcException.BIZCALCGROUPNUMEXIST);
        }
        if (info.getId() == null) {
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        }
        IObjectPK pk = super._addnew(ctx, model);
        return pk;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BizCalcGroupInfo info = (BizCalcGroupInfo)model;
        if (this.isNumberExists(ctx, info)) {
            throw new BizCalcException(BizCalcException.BIZCALCGROUPNUMEXIST);
        }
        super._update(ctx, pk, model);
    }

    @Override
    public BizCalcGroupCollection getBizCalcGroupCollection(Context ctx, EntityViewInfo view) throws BOSException {
        BizCalcGroupCollection colls = super.getBizCalcGroupCollection(ctx, view);
        if (colls != null && !colls.isEmpty()) {
            colls.sort("number");
            BizCalcGroupInfo preInfo = null;
            for (int i = 0; i < colls.size(); ++i) {
                if (colls.get(i).getNumber() == null || !colls.get(i).getNumber().equals("PRE")) continue;
                preInfo = colls.get(i);
                break;
            }
            BizCalcGroupCollection newColls = new BizCalcGroupCollection();
            if (preInfo != null) {
                newColls.add(preInfo);
            }
            for (int i = 0; i < colls.size(); ++i) {
                if (colls.get(i).getNumber() == null || colls.get(i).getNumber().equals("PRE")) continue;
                newColls.add(colls.get(i));
            }
            if (!newColls.isEmpty()) {
                return newColls;
            }
        }
        return colls;
    }

    @Override
    protected boolean _isHasBizCalc(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String sql = "select top 1 FID from T_MBG_BIZCALC where FBizCalcGroupId = '" + pk.toString() + "'";
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rowset.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    private boolean isNumberExists(Context ctx, BizCalcGroupInfo info) throws EASBizException, BOSException {
        if (info == null || StringUtils.isEmpty((String)info.getNumber())) {
            return true;
        }
        String number = info.getNumber();
        if ("PRE".equals(number)) {
            return true;
        }
        String bgSchemeId = info.getBgScheme().getId().toString();
        int isCsl = info.isIsCsl() ? 1 : 0;
        String oql = null;
        oql = info.getId() == null ? "select id where number = '" + number + "' and bgScheme.id = '" + bgSchemeId + "' and isCsl = " + isCsl + "" : "select id where number = '" + number + "' and bgScheme.id = '" + bgSchemeId + "' and id <> '" + info.getId().toString() + "' and isCsl = " + isCsl + "";
        return this._exists(ctx, oql);
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        BizCalcGroupInfo bizCalcGroupInfo = (BizCalcGroupInfo)model;
        FilterInfo curCUFilter = new FilterInfo();
        if (bizCalcGroupInfo != null) {
            try {
                bizCalcGroupInfo = (BizCalcGroupInfo)this._getValue(ctx, "select bgScheme.id,isCsl where id = '" + bizCalcGroupInfo.getId().toString() + "'");
            }
            catch (EASBizException e) {
                logger.error((Object)"", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
            }
            if (bizCalcGroupInfo.getBgScheme() != null) {
                curCUFilter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bizCalcGroupInfo.getBgScheme().getId().toString(), CompareType.EQUALS));
                curCUFilter.getFilterItems().add(new FilterItemInfo("isCsl", (Object)bizCalcGroupInfo.isIsCsl(), CompareType.EQUALS));
            }
        }
        return curCUFilter;
    }
}

