/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.app.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.bgcsl.BizRefCslTemplateCollection;
import com.kingdee.eas.ma.bgcsl.BizRefCslTemplateFactory;
import com.kingdee.eas.ma.bgcsl.BizRefCslTemplateHistFactory;
import com.kingdee.eas.ma.bgcsl.BizRefCslTemplateHistInfo;
import com.kingdee.eas.ma.bgcsl.BizRefCslTemplateInfo;
import com.kingdee.eas.ma.biz.BizCalcCollection;
import com.kingdee.eas.ma.biz.BizCalcException;
import com.kingdee.eas.ma.biz.BizCalcFactory;
import com.kingdee.eas.ma.biz.BizCalcHistFactory;
import com.kingdee.eas.ma.biz.BizCalcHistInfo;
import com.kingdee.eas.ma.biz.BizCalcInfo;
import com.kingdee.eas.ma.biz.BizCalcParseException;
import com.kingdee.eas.ma.biz.BizCalcSubsetCollection;
import com.kingdee.eas.ma.biz.BizCalcSubsetInfo;
import com.kingdee.eas.ma.biz.BizRefBgTemplateCollection;
import com.kingdee.eas.ma.biz.BizRefBgTemplateFactory;
import com.kingdee.eas.ma.biz.BizRefBgTemplateHistFactory;
import com.kingdee.eas.ma.biz.BizRefBgTemplateHistInfo;
import com.kingdee.eas.ma.biz.BizRefBgTemplateInfo;
import com.kingdee.eas.ma.biz.BizRelyCollection;
import com.kingdee.eas.ma.biz.BizRelyFactory;
import com.kingdee.eas.ma.biz.BizRelyInfo;
import com.kingdee.eas.ma.biz.BizScopeCollection;
import com.kingdee.eas.ma.biz.execute.face.IBizParameter;
import com.kingdee.eas.ma.biz.parse.BizFormulaVerifyHelper;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.MbgFunctionHelper;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class BizCalcServelHelper {
    public static String DEFAULT_VERSION = "1.0";

    public static void dealProCalc(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        List relyBizCalcColl;
        BizCalcInfo currBizCalc = (BizCalcInfo)model;
        BizCalcServelHelper.checkBizCalcLoop(ctx, currBizCalc);
        if (currBizCalc.getId() != null) {
            BizRelyFactory.getLocalInstance(ctx).delete("where bizCalc.id = '" + currBizCalc.getId().toString() + "'");
        }
        if ((relyBizCalcColl = (List)currBizCalc.get("prebizcalc")) != null && relyBizCalcColl.size() != 0) {
            CoreBaseCollection colls = new CoreBaseCollection();
            BizRelyInfo relyBizCalcRela = null;
            for (BizCalcInfo relyBizCalc : relyBizCalcColl) {
                relyBizCalcRela = new BizRelyInfo();
                relyBizCalcRela.setBizCalc(currBizCalc);
                relyBizCalcRela.setRelyBiz(relyBizCalc);
                colls.add((CoreBaseInfo)relyBizCalcRela);
            }
            BizRelyFactory.getLocalInstance(ctx).addnew(colls);
        }
    }

    private static void checkBizCalcLoop(Context ctx, BizCalcInfo currBizCalc) throws EASBizException, BOSException {
        if (currBizCalc == null) {
            return;
        }
        String currBizCalcID = currBizCalc.getId().toString();
        HashMap<String, Set<String>> relyMap = new HashMap<String, Set<String>>();
        HashMap<String, String> currRelyMap = new HashMap<String, String>();
        List relyBizCalcColl = (List)currBizCalc.get("prebizcalc");
        if (relyBizCalcColl != null) {
            for (BizCalcInfo bizCalc : relyBizCalcColl) {
                currRelyMap.put(bizCalc.getId().toString(), bizCalc.getNumber());
            }
            Connection conn = null;
            IRowSet rst = null;
            StringBuffer sql = new StringBuffer();
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                sql.append("SELECT rely.FBizCalcID, rely.FRelyBizID,calc.FNUMBER  FROM T_Mbg_BizRely rely join T_Mbg_Bizcalc calc on calc.FID = rely.FRelyBizID ").append("join T_Mbg_BgScheme scheme on scheme.FID = calc.FBgSchemeID ").append("where scheme.FID = '").append(currBizCalc.getBgScheme().getId().toString()).append("' ");
                rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString());
                Set<String> relySet = null;
                while (rst.next()) {
                    if (!relyMap.keySet().contains(rst.getString("FBizCalcID"))) {
                        relySet = new HashSet();
                        relyMap.put(rst.getString("FBizCalcID"), relySet);
                    } else {
                        relySet = (Set)relyMap.get(rst.getString("FBizCalcID"));
                    }
                    if (relySet == null) continue;
                    relySet.add(rst.getString("FRelyBizID"));
                }
                for (String relyID : currRelyMap.keySet()) {
                    if (!BizCalcServelHelper.isLoopRely(currBizCalcID, relyID, relyMap)) continue;
                    throw new BizCalcException(BizCalcException.EXISTBIZCALCLOOP, new Object[]{currRelyMap.get(relyID)});
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
        }
    }

    private static boolean isLoopRely(String rootBizCalcID, String currBizCalcID, Map<String, Set<String>> relyMap) {
        Set<String> relySet = relyMap.get(currBizCalcID);
        if (relySet != null) {
            for (String relyID : relySet) {
                if (relyID.equals(rootBizCalcID)) {
                    return true;
                }
                if (!BizCalcServelHelper.isLoopRely(rootBizCalcID, relyID, relyMap)) continue;
                return true;
            }
        }
        return false;
    }

    public static void updateHisBizcalc(Context ctx, String id) throws BOSException {
        HashSet<String> rmSet = new HashSet<String>();
        rmSet.add(id);
        BizCalcServelHelper.updateHisBizcalc(ctx, rmSet);
    }

    public static void updateHisBizcalc(Context ctx, Set<String> rmSet) throws BOSException {
        if (rmSet == null || rmSet.isEmpty()) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("update T_MBG_BizCalcHist set FIsDelete = 1, FDELETETIME = now() where FsourceBizcalcid in ( ");
        for (String id : rmSet) {
            sql.append("'").append(id).append("'").append(",");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(" )");
        try {
            BgDBUtils.executeUpdate((Context)ctx, (String)sql.toString());
        }
        catch (SQLDataException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void addHisBizcalc(Context ctx, CoreBaseCollection updateColls, boolean isDelete, boolean isFromCancel) throws EASBizException, BOSException {
        if (updateColls.isEmpty()) {
            return;
        }
        CoreBaseCollection histColls = new CoreBaseCollection();
        CoreBaseCollection refHistCols = new CoreBaseCollection();
        HashMap<BOSUuid, Set<BizRefBgTemplateInfo>> refTpts = new HashMap<BOSUuid, Set<BizRefBgTemplateInfo>>();
        HashMap<BOSUuid, Set<BizRelyInfo>> bizRelys = new HashMap<BOSUuid, Set<BizRelyInfo>>();
        CoreBaseCollection refCslHistCols = new CoreBaseCollection();
        HashMap<BOSUuid, Set<BizRefCslTemplateInfo>> refCslTpts = new HashMap<BOSUuid, Set<BizRefCslTemplateInfo>>();
        HashSet<String> bizCalcIds = new HashSet<String>();
        int in = updateColls.size();
        for (int i = 0; i < in; ++i) {
            bizCalcIds.add(updateColls.get(i).getId().toString());
        }
        BizCalcServelHelper.getRefBgCslTemplateByBizCalc(ctx, bizCalcIds, refCslTpts);
        BizCalcServelHelper.getRefTemplateByBizCalc(ctx, bizCalcIds, refTpts);
        BizCalcServelHelper.getBizRely(ctx, bizCalcIds, bizRelys);
        DecimalFormat format = new DecimalFormat("#0.0");
        int in2 = updateColls.size();
        for (int i = 0; i < in2; ++i) {
            String tarVersion;
            BizCalcInfo tmpCalcInfo = (BizCalcInfo)updateColls.get(i);
            BizCalcHistInfo hisInfo = new BizCalcHistInfo();
            hisInfo.clone(tmpCalcInfo);
            hisInfo.setEnableTime(new Timestamp(System.currentTimeMillis()));
            hisInfo.setEnableUser(ContextUtil.getCurrentUserInfo((Context)ctx));
            hisInfo.setDeleteTime(new Timestamp(System.currentTimeMillis()));
            hisInfo.setDeleteUser(ContextUtil.getCurrentUserInfo((Context)ctx));
            hisInfo.setIsDelete(isDelete);
            histColls.add((CoreBaseInfo)hisInfo);
            String version = tmpCalcInfo.getVersion();
            String string = tarVersion = version == null ? DEFAULT_VERSION : format.format((double)Float.parseFloat(version) + 0.1);
            if (isFromCancel) {
                hisInfo.setVersion(version);
                tmpCalcInfo.setVersion(version);
            } else {
                hisInfo.setVersion(tarVersion);
                tmpCalcInfo.setVersion(tarVersion);
                tmpCalcInfo.setEnableTime(new Timestamp(System.currentTimeMillis()));
                tmpCalcInfo.setEnableUser(ContextUtil.getCurrentUserInfo((Context)ctx));
            }
            if (bizRelys.containsKey(tmpCalcInfo.getId())) {
                Set relyInfos = (Set)bizRelys.get(tmpCalcInfo.getId());
                StringBuffer str = new StringBuffer();
                for (BizRelyInfo relyInfo : relyInfos) {
                    if (!StringUtils.isEmpty((String)relyInfo.getRelyBiz().getVersion())) {
                        str.append(relyInfo.getRelyBiz().getName()).append(BgBaseConstants.COMBINATE_SPLITER_TABLE).append(relyInfo.getRelyBiz().getVersion()).append(BgBaseConstants.SEP_THR_STR);
                        continue;
                    }
                    str.append(relyInfo.getRelyBiz().getName()).append(BgBaseConstants.SEP_THR_STR);
                }
                str.deleteCharAt(str.length() - 1);
                hisInfo.setBizRely(str.toString());
            }
            if (refTpts.containsKey(tmpCalcInfo.getId())) {
                Set set = (Set)refTpts.get(tmpCalcInfo.getId());
                for (BizRefBgTemplateInfo refTptInfo : set) {
                    BizRefBgTemplateHistInfo refTptHistInfo = new BizRefBgTemplateHistInfo();
                    refTptHistInfo.setBizCalc(hisInfo);
                    refTptHistInfo.setBgTemplate(refTptInfo.getBgTemplate());
                    refHistCols.add((CoreBaseInfo)refTptHistInfo);
                }
            }
            if (!refCslTpts.containsKey(tmpCalcInfo.getId())) continue;
            Set refCsltpts = (Set)refCslTpts.get(tmpCalcInfo.getId());
            for (BizRefCslTemplateInfo info : refCsltpts) {
                BizRefCslTemplateHistInfo refCslTptInfo = new BizRefCslTemplateHistInfo();
                refCslTptInfo.setBizcalcId(hisInfo.getId());
                refCslTptInfo.setTemplateID(info.getTemplateID());
                refCslTptInfo.setType(info.getType());
                refCslHistCols.add((CoreBaseInfo)refCslTptInfo);
            }
        }
        BizCalcHistFactory.getLocalInstance(ctx).saveBatchData(histColls);
        BizRefBgTemplateHistFactory.getLocalInstance(ctx).saveBatchData(refHistCols);
        BizRefCslTemplateHistFactory.getLocalInstance((Context)ctx).saveBatchData(refCslHistCols);
    }

    private static Map<BOSUuid, Set<BizRefCslTemplateInfo>> getRefBgCslTemplateByBizCalc(Context ctx, Set<String> bizCalcIds, Map<BOSUuid, Set<BizRefCslTemplateInfo>> result) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("bizCalcID"));
        evi.getSelector().add(new SelectorItemInfo("templateID"));
        evi.getSelector().add(new SelectorItemInfo("type"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bizCalcID", bizCalcIds, CompareType.INCLUDE));
        evi.setFilter(filter);
        BizRefCslTemplateCollection refCols = BizRefCslTemplateFactory.getLocalInstance((Context)ctx).getBizRefCslTemplateCollection(evi);
        if (refCols == null || refCols.isEmpty()) {
            return result;
        }
        int in = refCols.size();
        for (int i = 0; i < in; ++i) {
            BizRefCslTemplateInfo refTptInfo = refCols.get(i);
            if (!result.containsKey(refTptInfo.getBizCalcID())) {
                result.put(refTptInfo.getBizCalcID(), new HashSet());
            }
            result.get(refTptInfo.getBizCalcID()).add(refTptInfo);
        }
        return result;
    }

    public static void getBizRely(Context ctx, Set<String> bizCalcIds, Map<BOSUuid, Set<BizRelyInfo>> bizRelys) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("relyBiz.version"));
        evi.getSelector().add(new SelectorItemInfo("relyBiz.name"));
        evi.getSelector().add(new SelectorItemInfo("bizCalc.id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bizCalc.id", bizCalcIds, CompareType.INCLUDE));
        evi.setFilter(filter);
        BizRelyCollection relyCols = BizRelyFactory.getLocalInstance(ctx).getBizRelyCollection(evi);
        if (relyCols == null || relyCols.isEmpty()) {
            return;
        }
        int in = relyCols.size();
        for (int i = 0; i < in; ++i) {
            BizRelyInfo info = relyCols.get(i);
            if (!bizRelys.containsKey(info.getBizCalc().getId())) {
                bizRelys.put(info.getBizCalc().getId(), new HashSet());
            }
            bizRelys.get(info.getBizCalc().getId()).add(info);
        }
    }

    public static void getRefTemplateByBizCalc(Context ctx, Set<String> bizCalcIds, Map<BOSUuid, Set<BizRefBgTemplateInfo>> result) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("bizCalc"));
        evi.getSelector().add(new SelectorItemInfo("bgTemplate"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bizCalc.id", bizCalcIds, CompareType.INCLUDE));
        evi.setFilter(filter);
        BizRefBgTemplateCollection refCols = BizRefBgTemplateFactory.getLocalInstance(ctx).getBizRefBgTemplateCollection(evi);
        if (refCols == null || refCols.isEmpty()) {
            return;
        }
        int in = refCols.size();
        for (int i = 0; i < in; ++i) {
            BizRefBgTemplateInfo refTptInfo = refCols.get(i);
            if (!result.containsKey(refTptInfo.getBizCalc().getId())) {
                result.put(refTptInfo.getBizCalc().getId(), new HashSet());
            }
            result.get(refTptInfo.getBizCalc().getId()).add(refTptInfo);
        }
    }

    public static BizCalcCollection getBizCalcCollectionByIds(Context ctx, String bgSchemeId, Set bizCalcIds) throws BOSException {
        if (ctx == null || bizCalcIds == null || bizCalcIds.isEmpty() || StringUtils.isEmpty((String)bgSchemeId)) {
            return null;
        }
        SelectorItemCollection sic = BizCalcServelHelper.getSelectors();
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(sic);
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemeId, CompareType.EQUALS));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)bizCalcIds, CompareType.INCLUDE));
        BizCalcCollection calcInfoColls = BizCalcFactory.getLocalInstance(ctx).getBizCalcCollection(evi);
        return calcInfoColls;
    }

    public static SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("description");
        sic.add("simpleName");
        sic.add("number");
        sic.add("creator.id");
        sic.add("createTime");
        sic.add("lastUpdateUser.id");
        sic.add("lastUpdateTime");
        sic.add("CU.id");
        sic.add("state");
        sic.add("orgUnit.id");
        sic.add("bgScheme.id");
        sic.add("isBGExe");
        sic.add("orgTree.id");
        sic.add("sourceType");
        sic.add("memberMap");
        sic.add("version");
        sic.add("enableTime");
        sic.add("enableUser.id");
        sic.add("bizCalcSubSet.*");
        sic.add("bizCalcSubSet.scope.*");
        sic.add("bizCalcGroup.id");
        sic.add("bizCalcGroup.number");
        sic.add("bizCalcGroup.name");
        return sic;
    }

    public static void transFormulaToSimple(Set<BizCalcInfo> calcInfoSet) {
        if (calcInfoSet.isEmpty()) {
            return;
        }
        BizCalcInfo bizCalcInfo2 = null;
        BizCalcSubsetInfo bizSubSetInfo = null;
        BizCalcSubsetCollection bizSubSetCols = null;
        String formula = null;
        for (BizCalcInfo bizCalcInfo2 : calcInfoSet) {
            bizSubSetCols = bizCalcInfo2.getBizCalcSubset();
            if (bizSubSetCols == null) continue;
            int size = bizSubSetCols.size();
            for (int i = 0; i < size; ++i) {
                bizSubSetInfo = bizSubSetCols.get(i);
                formula = bizSubSetInfo.getBizFormula();
                if (MbgFunctionHelper.isExprSimple((String)formula)) continue;
                bizSubSetInfo.setBizFormula(MbgFunctionHelper.transExprFormatToSimple((String)formula));
            }
        }
    }

    public static Map<String, String> getVerifyResultMsgByCalcColls(Context ctx, Set<BizCalcInfo> calcInfoSet, BgSchemeDimensionHelper schemeHelper) throws EASBizException, BOSException {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (ctx == null || calcInfoSet == null || calcInfoSet.isEmpty() || schemeHelper == null) {
            return resultMap;
        }
        LinkedHashMap<String, LinkedHashMap<String, String>> bizCalcFormulaMap = new LinkedHashMap<String, LinkedHashMap<String, String>>();
        LinkedHashMap<String, Map<String, Set<String>>> bizScopeSrcMap = new LinkedHashMap<String, Map<String, Set<String>>>();
        LinkedHashMap<String, Map<String, BizScopeCollection>> bizScopeMap = new LinkedHashMap<String, Map<String, BizScopeCollection>>();
        BizFormulaVerifyHelper.buildParseParam(calcInfoSet, bizCalcFormulaMap, bizScopeSrcMap, bizScopeMap, schemeHelper);
        BizFormulaVerifyHelper formulaParser = new BizFormulaVerifyHelper(bizCalcFormulaMap, bizScopeSrcMap, bizScopeMap, schemeHelper, true, BizFormulaVerifyHelper.getMemberMaps(calcInfoSet));
        formulaParser.batchParse();
        HashSet<String> parseErrorNumber = new HashSet<String>();
        for (String number : formulaParser.getAllExceptions().keySet()) {
            Map<String, Map<Integer, List<Exception>>> subsetException = formulaParser.getAllExceptions().get(number);
            for (Map<Integer, List<Exception>> lineException : subsetException.values()) {
                if (lineException.isEmpty()) continue;
                parseErrorNumber.add(number);
            }
        }
        StringBuffer result = null;
        Object msgRes = null;
        if (!parseErrorNumber.isEmpty()) {
            for (String parseErrorNum : parseErrorNumber) {
                result = new StringBuffer();
                if (formulaParser.getAllExceptions().containsKey(parseErrorNum)) {
                    Map<String, Map<Integer, List<Exception>>> subsetException = formulaParser.getAllExceptions().get(parseErrorNum);
                    for (String subsetName : subsetException.keySet()) {
                        Map<Integer, List<Exception>> lineException = subsetException.get(subsetName);
                        ArrayList<Integer> keyList = new ArrayList<Integer>(lineException.keySet());
                        Collections.sort(keyList);
                        for (Integer line : keyList) {
                            List<Exception> Exceptions = lineException.get(line);
                            for (Exception exception : Exceptions) {
                                result.append(new BizCalcParseException(BizCalcParseException.ERROR_SHOWBIZNAME, new Object[]{parseErrorNum, exception.getMessage()}).getMessage()).append("\r\n");
                            }
                        }
                    }
                }
                resultMap.put(parseErrorNum, result.toString());
            }
        }
        return resultMap;
    }

    public static String combineAllKeysToStr(Map<String, String> verifyResultMsg) {
        if (verifyResultMsg.isEmpty()) {
            return null;
        }
        String calcNum2 = null;
        StringBuffer resultStr = new StringBuffer();
        for (String calcNum2 : verifyResultMsg.keySet()) {
            resultStr.append(verifyResultMsg.get(calcNum2)).append(" ");
        }
        return resultStr.toString();
    }

    public static void transSimpleToFormat(CoreBaseCollection updateColls) {
        if (updateColls.size() == 0) {
            return;
        }
        BizCalcInfo bizCalcInfo = null;
        String formula = null;
        BizCalcSubsetCollection bizSubSetCols = null;
        BizCalcSubsetInfo bizSubSetInfo = null;
        int n = updateColls.size();
        for (int i = 0; i < n; ++i) {
            if (!(updateColls.get(i) instanceof BizCalcInfo) || (bizSubSetCols = (bizCalcInfo = (BizCalcInfo)updateColls.get(i)).getBizCalcSubset()) == null) continue;
            int size = bizSubSetCols.size();
            for (int j = 0; j < size; ++j) {
                bizSubSetInfo = bizSubSetCols.get(j);
                formula = bizSubSetInfo.getBizFormula();
                if (!MbgFunctionHelper.isExprSimple((String)formula)) continue;
                bizSubSetInfo.setBizFormula(MbgFunctionHelper.transExprSimpleToFormat((String)formula));
            }
        }
    }

    public static void beforeCheck(Context ctx, IBizParameter parameter) throws BOSException, EASBizException {
        if (ctx == null || parameter == null) {
            return;
        }
        BizCalcServelHelper.checkBizParameter(ctx, parameter);
        BizCalcServelHelper.prepareData(ctx, parameter);
    }

    private static void checkBizParameter(Context ctx, IBizParameter parameter) throws BOSException, EASBizException {
        if (ctx == null || parameter == null) {
            return;
        }
        BOSUuid bgSchemeId = parameter.getBgSchemeId();
        if (bgSchemeId == null) {
            throw new BizCalcException(BizCalcException.BGSCHEMEISNULL);
        }
        BOSUuid orgUnitId = parameter.getOrgUnitId();
        if (orgUnitId == null) {
            throw new BizCalcException(BizCalcException.ORGUNITISNULL);
        }
    }

    private static void prepareData(Context ctx, IBizParameter parameter) throws BOSException, EASBizException {
        if (ctx == null || parameter == null) {
            return;
        }
        Connection conn = null;
        try {
            OrgUnitInfo orgUnit;
            conn = EJBFactory.getConnection((Context)ctx);
            BOSUuid bgSchemeId = parameter.getBgSchemeId();
            BgSchemeInfo bgScheme = BgViewServerHelper.getBgSchemeCubeInfo((Context)ctx, (BOSUuid)bgSchemeId);
            if (bgScheme == null) {
                throw new BizCalcException(BizCalcException.BGSCHEMEERROR);
            }
            parameter.getDataManager().setBgScheme(bgScheme);
            if (parameter.getOrgUnitId() != null && parameter.getDataManager().getOrgUnit() == null && (orgUnit = BizCalcServelHelper.getOrgUnit(conn, ctx.getLocale(), parameter.getOrgUnitId())) != null) {
                parameter.getDataManager().setOrgUnit(orgUnit);
            }
            if (parameter.getDataManager().getDimsMap() == null) {
                parameter.getDataManager().setDimsMap(DimUtils.getDimInfoMap((Context)ctx));
            }
        }
        catch (SQLDataException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private static OrgUnitInfo getOrgUnit(Connection conn, Locale locale, BOSUuid orgUnitId) throws BOSException, EASBizException {
        return MbgDataHelper.getOrgUnitInfo((Connection)conn, (Locale)locale, (BOSUuid)orgUnitId);
    }
}

