/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.execute.calc.impl.expr;

import com.kingdee.eas.ma.biz.ParseException;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.FunctionProxy;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.BinaryExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.CalcExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.MdxMemberExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.MemberExpr;
import com.kingdee.eas.ma.biz.expr.face.IExpress;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MemberProxy {
    private static final String MEMBER_EXPR_TAG = "^(MBR|LEAF_MBR|NLEAF_MBR|PTO):\\[(,?\"?\\w{3}:[\\w|.|\\-|!|+]+\"?|,?\"\"|,?\"FX:\\[@\\w+\\(((\"?\\w+\"?)?,?\"?-?[0-9]\\d*\"?|,?\"?(\\w{3}:[\\w|.|\\-|!|+]+)?\"?)+\\)\\]\")+\\]";
    private static final String MEMBER_MULTI_TAG = "^(MBR|PTO):\\[,?\"?\\w{3,}:([\\w|.|-]+,?)+\"\\]";
    public static final String MEMBER_TAG = "\\w{3,}:(\\w+|.\\w)+\"|,\"\\w{3}:(\\w+|.\\w)+\")+\\]";
    public static final String MEMBER_SCHEXPR_TAG = "^(MBR|LEAF_MBR|NLEAF_MBR|PTO):\\[(Sch:[\\w-]+:)?(,?\"?\\w{3,}:[\\w|.|\\-|!|+]+\"?|,?\"\"|,?\"FX:\\[@\\w+\\(((\"?\\w+\"?)?,?\"?-?[0-9]\\d*\"?|,?\"?(\\w{3}:[\\w|.|\\-|!|+]+)?\"?)+\\)\\]\")+\\]";
    public static final String MEMBER_PARENT_FUN = "^(MBR|LEAF_MBR|NLEAF_MBR|PTO):\\[(,?\"\\w{3,}:[\\w|.|\\-|+|!]+\"|,?\"\"|,?\"FX:\\[@\\w+\\(((\"?\"?([\\w|.|\\-|+|!]+)?\"?\"))+\\)\\]\")+\\]";
    public static final String MEMBER_SCHEMEPARENT_FUN = "^(MBR|LEAF_MBR|NLEAF_MBR|PTO):\\[\"(Sch:[\\S]+)?\"(,?\"\\w{3,}:[\\w|.|\\-|+|!]+\"|,?\"\"|,?\"FX:\\[@\\w+\\(((\"?\"?([\\w|.|\\-|+|!]+)?\"?\"))+\\)\\]\")+\\]";

    public static boolean isMember(String mdxMemberStr) {
        return MemberProxy.verify(mdxMemberStr);
    }

    public static boolean isMultiMember(String mdxMemberStr) {
        if (StringUtils.isEmpty((String)mdxMemberStr)) {
            return false;
        }
        return mdxMemberStr.trim().matches(MEMBER_MULTI_TAG);
    }

    public static MdxMemberExpr parse(String mdxMemberStr) throws ParseException {
        return MemberProxy.getMemberExpr(mdxMemberStr);
    }

    public static List<MdxMemberExpr> parsePTO(String mdxMemberStr) throws ParseException {
        return MemberProxy.getPTOMemberExprs(mdxMemberStr);
    }

    public static MdxMemberExpr parseDimNum(String mdxMemberStr) throws ParseException {
        if (StringUtils.isEmpty((String)mdxMemberStr)) {
            return null;
        }
        String _mdxMemberStr = "MBR:[\"" + mdxMemberStr + "\"]";
        return MemberProxy.getMemberExpr(_mdxMemberStr);
    }

    public static MdxMemberExpr parseDimNumForLeaf(String mdxMemberStr) throws ParseException {
        if (StringUtils.isEmpty((String)mdxMemberStr)) {
            return null;
        }
        String _mdxMemberStr = "LEAF_MBR:[\"" + mdxMemberStr + "\"]";
        return MemberProxy.getMemberExpr(_mdxMemberStr);
    }

    public static MdxMemberExpr parseDimNumForNLeaf(String mdxMemberStr) throws ParseException {
        if (StringUtils.isEmpty((String)mdxMemberStr)) {
            return null;
        }
        String _mdxMemberStr = "NLEAF_MBR:[\"" + mdxMemberStr + "\"]";
        return MemberProxy.getMemberExpr(_mdxMemberStr);
    }

    public static boolean verify(String mdxMemberStr) {
        if (StringUtils.isEmpty((String)mdxMemberStr)) {
            return false;
        }
        if (mdxMemberStr.indexOf("Sch:") != -1) {
            return mdxMemberStr.trim().matches(MEMBER_SCHEXPR_TAG) || mdxMemberStr.trim().matches(MEMBER_SCHEMEPARENT_FUN);
        }
        return mdxMemberStr.trim().matches(MEMBER_EXPR_TAG) || mdxMemberStr.trim().matches(MEMBER_PARENT_FUN) || mdxMemberStr.trim().matches(MEMBER_MULTI_TAG);
    }

    public static boolean verify(IExpress expr) throws ParseException {
        if (expr == null) {
            return false;
        }
        HashMap<String, Set<String>> checkFieldMap = new HashMap<String, Set<String>>();
        if (expr instanceof BinaryExpr) {
            MemberProxy.verify((BinaryExpr)expr, checkFieldMap);
        }
        return true;
    }

    private static void verify(BinaryExpr expr, Map<String, Set<String>> checkFieldMap) throws ParseException {
        if (expr == null || checkFieldMap == null) {
            return;
        }
        if (expr.left instanceof BinaryExpr) {
            MemberProxy.verify((BinaryExpr)expr.left, checkFieldMap);
        } else if (expr.left instanceof MdxMemberExpr) {
            MemberProxy.verify((MdxMemberExpr)expr.left, checkFieldMap);
        }
        if (expr.right instanceof BinaryExpr) {
            MemberProxy.verify((BinaryExpr)expr.right, checkFieldMap);
        } else if (expr.right instanceof MdxMemberExpr) {
            MemberProxy.verify((MdxMemberExpr)expr.right, checkFieldMap);
        }
    }

    private static void verify(MdxMemberExpr expr, Map<String, Set<String>> checkFieldMap) throws ParseException {
        if (expr == null || checkFieldMap == null) {
            return;
        }
    }

    public static List<MdxMemberExpr> getPTOMemberExprs(String mdxMemberStr) throws ParseException {
        ArrayList<MdxMemberExpr> exprs = new ArrayList<MdxMemberExpr>();
        exprs.add(MemberProxy.getMemberExpr(mdxMemberStr));
        return exprs;
    }

    public static MdxMemberExpr getMemberExpr(String mdxMemberStr) throws ParseException {
        MdxMemberExpr expr = new MdxMemberExpr();
        String tmpMember = null;
        String[] tmpStrs = null;
        String[] tmpStrsOne = null;
        CalcExpr param = null;
        if (!StringUtils.isEmpty((String)mdxMemberStr)) {
            if (mdxMemberStr.startsWith("LEAF_MBR")) {
                expr.leafFeature = 1;
            } else if (mdxMemberStr.startsWith("NLEAF_MBR")) {
                expr.leafFeature = 2;
            } else if (mdxMemberStr.startsWith("PTO")) {
                expr.leafFeature = 3;
            }
            tmpMember = mdxMemberStr.substring(mdxMemberStr.indexOf("[") + 1, mdxMemberStr.length() - 1);
            tmpStrs = MemberProxy.splitMemberString(tmpMember);
            if (tmpStrs[0].indexOf("Sch:") != -1) {
                String memNumTmp;
                int firstSep = tmpStrs[0].indexOf(":");
                int secondSep = tmpStrs[0].indexOf(":", firstSep + 1);
                tmpStrs[0] = memNumTmp = tmpStrs[0].substring(secondSep + 1);
            }
            String dimMem = null;
            int length = tmpStrs.length;
            for (int i = 0; i < length; ++i) {
                if (tmpStrs[i] == null) continue;
                int len = tmpStrs[i].length();
                dimMem = tmpStrs[i];
                if (dimMem.startsWith("\"") || dimMem.startsWith("[")) {
                    dimMem = dimMem.substring(1);
                }
                if (dimMem.endsWith("\"") || dimMem.endsWith("[")) {
                    dimMem = dimMem.substring(0, dimMem.length() - 1);
                }
                if (dimMem.startsWith("FX:[")) {
                    param = FunctionProxy.getFunction(dimMem);
                } else {
                    tmpStrsOne = dimMem.split(":");
                    if (tmpStrsOne.length == 2) {
                        param = new MemberExpr();
                        ((MemberExpr)param).srcNumber = tmpStrsOne[0];
                        ((MemberExpr)param).number = tmpStrsOne[1];
                    } else if (param instanceof MemberExpr) {
                        String srcNumber = ((MemberExpr)param).srcNumber;
                        param = new MemberExpr();
                        ((MemberExpr)param).srcNumber = srcNumber;
                        ((MemberExpr)param).number = tmpStrsOne[0];
                    }
                }
                expr.params.add(param);
            }
        }
        return expr;
    }

    public static String[] splitMemberString(String memberStr) {
        String[] tmpStrs = memberStr.split(",");
        String[] rstStrs = new String[tmpStrs.length];
        int length = tmpStrs.length;
        int i = 0;
        int j = 0;
        while (i < length) {
            if (tmpStrs[i].indexOf("Lead") != -1) {
                rstStrs[j] = tmpStrs[i] + "," + tmpStrs[i + 1];
                i += 2;
            } else if (tmpStrs[i].indexOf("ParallelPeriod") != -1) {
                rstStrs[j] = tmpStrs[i] + "," + tmpStrs[i + 1] + "," + tmpStrs[i + 2];
                i += 3;
            } else {
                rstStrs[j] = tmpStrs[i];
                ++i;
            }
            ++j;
        }
        return rstStrs;
    }
}

