/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.execute.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.base.utils.MbgVirtualView;
import com.kingdee.eas.ma.biz.BizCalcInfo;
import com.kingdee.eas.ma.biz.BizCalcSubsetInfo;
import com.kingdee.eas.ma.biz.BizScopeInfo;
import com.kingdee.eas.ma.biz.execute.calc.impl.BaseCalcMember;
import com.kingdee.eas.ma.biz.execute.calc.impl.BizCalcMember;
import com.kingdee.eas.ma.biz.execute.calc.impl.ICalcMember;
import com.kingdee.eas.ma.mbg.BgMemberSelectTypeEnum;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.DimensionMemberTypeEnum;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.utils.OptimizeUtils;
import com.kingdee.eas.ma.mbg.utils.BgVariateUtils;
import com.kingdee.eas.ma.mbg.utils.MBgPeriodVariable;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BizCalcQuery {
    private static Logger logger = Logger.getLogger(BizCalcQuery.class);
    private Context ctx = null;
    private Map<BOSUuid, Set<BOSUuid>> relyMap = new HashMap<BOSUuid, Set<BOSUuid>>();
    private Map<String, Set<BizCalcInfo>> relyObjMap = new HashMap<String, Set<BizCalcInfo>>();

    protected void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    protected Context getCtx() {
        return this.ctx;
    }

    public BizCalcQuery(Context ctx) {
        this.setCtx(ctx);
    }

    public static BizCalcQuery getInstance(Context ctx) {
        return new BizCalcQuery(ctx);
    }

    public Map<BOSUuid, Set<BOSUuid>> getRelyMap() {
        return this.relyMap;
    }

    public Map<String, Set<BizCalcInfo>> getRelyObjMap() {
        return this.relyObjMap;
    }

    public void queryPeriodCalc(Connection conn, IDimensionParameter parameter) throws EASBizException {
        if (conn == null || parameter == null || parameter == null) {
            return;
        }
        BgSchemeInfo bgScheme = parameter.getDataManager().getBgScheme();
        BOSUuid bgIndViewId = bgScheme.getViewId(DimensionConstants.DEF_INDEX_NUMBER);
        String dimNumber = null;
        int periodType = 0;
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)"select t.FNumber, t.FPeriodAlgorithm from T_MBG_BgAccount t where t.FBgAccountViewId = ? and t.FPeriodAlgorithm IN (4,3)", (Object[])new Object[]{bgIndViewId.toString()});
            while (rst.next()) {
                dimNumber = DimensionBaseConstants.DEF_INDEX_SRCNUMBER + ":" + rst.getString("FNumber");
                periodType = rst.getInt("FPeriodAlgorithm");
                if (periodType == 3) {
                    parameter.getDataManager().getEndNumber().add(dimNumber);
                    continue;
                }
                if (periodType != 4) continue;
                parameter.getDataManager().getOpeningNumber().add(dimNumber);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
    }

    public List<ICalcMember> queryBaseCalc(Connection conn, IDimensionParameter parameter, Set<String> standbyDim) throws EASBizException {
        ArrayList<ICalcMember> members = new ArrayList<ICalcMember>();
        if (conn == null || parameter == null || parameter.getControlManager().isControlData()) {
            return members;
        }
        BgSchemeInfo bgScheme = parameter.getDataManager().getBgScheme();
        int type = 0;
        String factTable = null;
        String refField = null;
        String mbgDimNum = null;
        BaseCalcMember member = null;
        IRowSet rst = null;
        HashMap<String, Map<String, BaseCalcMember>> calcMemMap = new HashMap<String, Map<String, BaseCalcMember>>();
        Map<String, BaseCalcMember> memberMap = null;
        BOSUuid bgIndViewId = bgScheme.getViewId(DimensionConstants.DEF_INDEX_NUMBER);
        factTable = MbgVirtualView.getFactTable((Connection)conn, (BOSUuid)bgIndViewId);
        if (!StringUtils.isEmpty((String)factTable)) {
            try {
                rst = BgDBUtils.executeQuery((Connection)conn, (String)("select t.FDimLongNumber, p.FDimLongNumber as FPLN, a.FPolAlgorithm from " + factTable + " t join " + factTable + " p on t.FParentNumber = p.FDimNumber join T_MBG_BgAccount a on a.FNumber = t.FNumber where a.FBgAccountViewId = ? and a.FPolAlgorithm IN (" + 2 + "," + 3 + ") order by p.FDimLongNumber desc"), (Object[])new Object[]{bgIndViewId.toString()});
                while (rst.next()) {
                    if (calcMemMap.containsKey(DimensionBaseConstants.DEF_BGINDEX_FIELD)) {
                        memberMap = (Map)calcMemMap.get(DimensionBaseConstants.DEF_BGINDEX_FIELD);
                    } else {
                        memberMap = new HashMap();
                        calcMemMap.put(DimensionBaseConstants.DEF_BGINDEX_FIELD, memberMap);
                    }
                    if (memberMap.containsKey(rst.getString("FPLN"))) {
                        member = (BaseCalcMember)memberMap.get(rst.getString("FPLN"));
                    } else {
                        member = new BaseCalcMember();
                        member.setField(DimensionBaseConstants.DEF_BGINDEX_FIELD);
                        member.setParentLongNumber(rst.getString("FPLN"));
                        members.add(member);
                        memberMap.put(rst.getString("FPLN"), member);
                    }
                    type = rst.getInt("FPolAlgorithm");
                    if (type == 2) {
                        member.getSubNumber().add(rst.getString("FDimLongNumber"));
                        continue;
                    }
                    if (type != 3) continue;
                    member.getIgnNumber().add(rst.getString("FDimLongNumber"));
                }
            }
            catch (SQLException ex) {
                try {
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rst);
        }
        List viewIds = bgScheme.getExtDimViewIds();
        for (BOSUuid viewId : viewIds) {
            try {
                rst = BgDBUtils.executeQuery((Connection)conn, (String)"select t.FNumber, t.FRefField from T_MBG_MbgDim t join T_MBG_MbgView v on t.FID = v.FMbgDimID where v.FID = ?", (Object[])new Object[]{viewId.toString()});
                if (rst.next()) {
                    mbgDimNum = rst.getString("FNumber");
                    refField = rst.getString("FRefField");
                }
            }
            catch (SQLException ex) {
                try {
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rst);
            if (StringUtils.isEmpty(refField) || parameter.getUnionId() != null || standbyDim != null && standbyDim.contains(mbgDimNum) || StringUtils.isEmpty((String)(factTable = MbgVirtualView.getFactTable((Connection)conn, (BOSUuid)viewId)))) continue;
            try {
                rst = BgDBUtils.executeQuery((Connection)conn, (String)("select t.FDimLongNumber, p.FDimLongNumber as FPLN, m.FAggregation from " + factTable + " t join " + factTable + " p on t.FParentNumber = p.FDimNumber join T_MBG_MbgMember m on m.FNumber = t.FNumber where m.FViewId = ? and m.FAggregation IN (" + 2 + "," + 3 + ") order by p.FDimLongNumber desc"), (Object[])new Object[]{viewId.toString()});
                while (rst.next()) {
                    if (calcMemMap.containsKey(refField)) {
                        memberMap = (Map)calcMemMap.get(refField);
                    } else {
                        memberMap = new HashMap();
                        calcMemMap.put(refField, memberMap);
                    }
                    if (memberMap.containsKey(rst.getString("FPLN"))) {
                        member = (BaseCalcMember)memberMap.get(rst.getString("FPLN"));
                    } else {
                        member = new BaseCalcMember();
                        member.setField(refField);
                        member.setParentLongNumber(rst.getString("FPLN"));
                        members.add(member);
                        memberMap.put(rst.getString("FPLN"), member);
                    }
                    type = rst.getInt("FAggregation");
                    if (type == 2) {
                        member.getSubNumber().add(rst.getString("FDimLongNumber"));
                        continue;
                    }
                    if (type != 3) continue;
                    member.getIgnNumber().add(rst.getString("FDimLongNumber"));
                }
            }
            catch (SQLException ex) {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            finally {
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        return members;
    }

    public Map<String, String> queryVariate(Connection conn, BOSUuid bgSchemeId) throws Exception {
        return BgVariateUtils.queryVariate((Connection)conn, (BOSUuid)bgSchemeId);
    }

    public Map<String, String> queryVariate(Context ctx, BOSUuid bgSchemeId) throws BOSException {
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            Map map = BgVariateUtils.queryVariate((Connection)conn, (BOSUuid)bgSchemeId);
            return map;
        }
        catch (BOSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BizCalcInfo> queryBizCalc(IDimensionParameter parameter, Connection conn, BOSUuid bgSchemeId, BOSUuid unionId, BOSUuid[] bgTemplateId, List<BOSUuid> calcIds, boolean isbackCalc, Set<String> bgPeriodNums, Set<String> bgPeriodChecks, String orgViewID, String orgNumber) throws Exception {
        IRowSet rst;
        TempTablePool pool;
        String tmpTemplateTable;
        ArrayList<BizCalcInfo> calcs;
        block20: {
            calcs = new ArrayList<BizCalcInfo>();
            if (this.getCtx() == null || conn == null || bgSchemeId == null) {
                return calcs;
            }
            tmpTemplateTable = null;
            HashSet<String> _calcIds = new HashSet<String>();
            pool = TempTablePool.getInstance((Context)this.getCtx());
            rst = null;
            try {
                List<BizCalcInfo> tmpCalcs;
                block22: {
                    block21: {
                        ArrayList<String> _bgTemplateIds;
                        this.getRelyMap().clear();
                        if (calcIds != null && !calcIds.isEmpty()) break block21;
                        StringBuffer sql = new StringBuffer();
                        Object[] objs = null;
                        if (unionId == null) {
                            sql.append("select t.FID from T_MBG_BizCalc t where t.FBgSchemeID = ? and FOrgTreeID is null ");
                            if (bgTemplateId != null && bgTemplateId.length > 0 && (tmpTemplateTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))")) != null) {
                                _bgTemplateIds = new ArrayList<String>();
                                for (BOSUuid tmpId : bgTemplateId) {
                                    _bgTemplateIds.add(tmpId.toString());
                                }
                                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpTemplateTable + " (FID) values (?)"), _bgTemplateIds);
                                sql.append(" and exists (select FBizCalcId from T_MBG_BizRefBgTemplate where FBgTemplateId IN (select FID from " + tmpTemplateTable + ") and FBizCalcId = t.FID)");
                            }
                            objs = new Object[]{bgSchemeId.toString()};
                        } else {
                            sql.append("select t.FID from T_MBG_BizCalc t where t.FBgSchemeID = ? and FOrgTreeID = ? ");
                            if (bgTemplateId != null && bgTemplateId.length > 0 && (tmpTemplateTable = pool.createDBSystemTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))", conn)) != null) {
                                _bgTemplateIds = new ArrayList();
                                for (BOSUuid tmpId : bgTemplateId) {
                                    _bgTemplateIds.add(tmpId.toString());
                                }
                                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpTemplateTable + " (FID) values (?)"), _bgTemplateIds);
                                sql.append(" and exists (select FBizCalcId from T_MBG_BizRefCslTemplate where FTemplateID IN (select FID from " + tmpTemplateTable + ") and FBizCalcId = t.FID)");
                            }
                            objs = new Object[]{bgSchemeId.toString(), unionId.toString()};
                        }
                        if (isbackCalc) {
                            sql.append(" and t.FIsBgExe = 1 ");
                        }
                        sql.append(" and t.FState = 2");
                        try {
                            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])objs);
                            while (rst.next()) {
                                _calcIds.add(rst.getString("FID"));
                            }
                        }
                        catch (Throwable throwable) {
                            SQLUtils.cleanup(rst);
                            throw throwable;
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                        break block22;
                    }
                    for (BOSUuid calcId : calcIds) {
                        _calcIds.add(calcId.toString());
                    }
                }
                if ((tmpCalcs = this.queryBizCalc(conn, pool, _calcIds)) != null && !tmpCalcs.isEmpty()) {
                    calcs.addAll(tmpCalcs);
                }
                if ((tmpCalcs = this.queryRelyBizCalc(conn, pool, calcs)) != null && !tmpCalcs.isEmpty()) {
                    calcs.addAll(tmpCalcs);
                }
                this.calcPriority(calcs);
                if (calcs.isEmpty() || bgPeriodNums == null) break block20;
                this.checkBeforeTransPeirod(parameter, calcs);
                MBgPeriodVariable variable = new MBgPeriodVariable(this.getCtx().getLocale());
                this.getCtx().put((Object)"isExpressionCalc", (Object)parameter.getControlManager().isExpressionCalc());
                variable.transPeirodVariale(this.getCtx(), bgSchemeId.toString(), calcs, bgPeriodNums, bgPeriodChecks, orgViewID, orgNumber, unionId != null ? unionId.toString() : null);
            }
            catch (Exception ex) {
                try {
                    logger.error((Object)"queryRefBizCaclIds sql error:", (Throwable)ex);
                    throw ex;
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst);
                    if (pool != null && tmpTemplateTable != null) {
                        pool.releaseTable(tmpTemplateTable);
                    }
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup(rst);
        if (pool != null && tmpTemplateTable != null) {
            pool.releaseTable(tmpTemplateTable);
        }
        return calcs;
    }

    protected void checkBeforeTransPeirod(IDimensionParameter parameter, List<BizCalcInfo> calcs) throws Exception {
        if (parameter != null && calcs != null && !calcs.isEmpty()) {
            ArrayList<BizCalcMember> members = new ArrayList<BizCalcMember>();
            BizCalcMember member = null;
            for (BizCalcInfo calc : calcs) {
                member = new BizCalcMember();
                member.setSrcFieldMap(parameter.getDataManager().getSrcFieldMap());
                member.setNumInnMap(parameter.getDataManager().getNumInnMap());
                member.setCalc(calc);
                members.add(member);
            }
            OptimizeUtils.filterBizMember((Context)this.getCtx(), (IDimensionParameter)parameter, members);
            OptimizeUtils.filterExpressFormulaCalc((Context)this.getCtx(), members, (IDimensionParameter)parameter, null, (Map)parameter.getDataManager().getSrcFieldMap(), this.getRelyObjMap());
        }
    }

    public List<BizCalcInfo> queryBizCalc(Connection conn, BOSUuid bgSchemeId, BOSUuid unionId, BOSUuid[] bgTemplateId, List<BOSUuid> calcIds, boolean isbackCalc, Set<String> bgPeriodNums, Set<String> bgPeriodChecks) throws Exception {
        return this.queryBizCalc(null, conn, bgSchemeId, unionId, bgTemplateId, calcIds, isbackCalc, bgPeriodNums, bgPeriodChecks, null, null);
    }

    public List<BizCalcInfo> queryBizCalc(Connection conn, TempTablePool pool, Collection<String> calcIds) throws Exception {
        ArrayList<BizCalcInfo> calcs = new ArrayList<BizCalcInfo>();
        if (conn == null || calcIds == null || calcIds.isEmpty()) {
            return calcs;
        }
        BizCalcInfo calc = null;
        BizCalcSubsetInfo subCalc = null;
        BizScopeInfo scope = null;
        HashMap<String, BizCalcInfo> calcsMap = new HashMap<String, BizCalcInfo>();
        HashMap<String, BizCalcSubsetInfo> subMap = new HashMap<String, BizCalcSubsetInfo>();
        String tmpTable = null;
        String bizId = null;
        String subBizId = null;
        if (pool == null) {
            pool = TempTablePool.getInstance((Context)this.getCtx());
        }
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            tmpTable = pool.createTempTable("Create Table TEML_KSQL_0 (FID VARCHAR(44))");
            if (!StringUtils.isEmpty((String)tmpTable)) {
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpTable + " (FID) Values (?)"), calcIds);
                StringBuffer sql = new StringBuffer();
                sql.append("select t.FID, t.FNumber, t.FName_" + this.getCtx().getLocale() + " AS FName, t.FMemberMap,  sub.FID AS SUBID, sub.FBizCalcID, sub.FSeq, sub.FFormula, sub.FIncludePost, sub.FIsZeroUpdate, s.FID AS SOID, s.FBizCalcSubsetID, s.FBgMemberNum, s.FBgMemberType, s.FBizDataType, s.FRefField, s.FFillType, sub.FName_" + this.getCtx().getLocale() + " AS FSubName , sub.FShowDimNums from T_MBG_BizCalc t left join T_MBG_BizCalcSubset sub on t.FID = sub.FBizCalcID left join T_MBG_BizScope s on sub.FID = s.FBizCalcSubsetID where exists (select FID from " + tmpTable + " where FID = t.FID) and t.FState = " + 2 + " order by t.FNumber, sub.FSeq");
                pstmt = conn.prepareStatement(sql.toString());
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bizId = rst.getString("FID");
                    if (calcsMap.containsKey(bizId)) {
                        calc = (BizCalcInfo)calcsMap.get(bizId);
                    } else {
                        calc = new BizCalcInfo();
                        calc.setId(BOSUuid.read((String)bizId));
                        calc.setNumber(rst.getString("FNumber"));
                        calc.setName(rst.getString("FName"));
                        calc.setMemberMap(rst.getString("FMemberMap"));
                        calcs.add(calc);
                        calcsMap.put(rst.getString("FID"), calc);
                    }
                    subBizId = rst.getString("SUBID");
                    if (subMap.containsKey(subBizId)) {
                        subCalc = (BizCalcSubsetInfo)subMap.get(subBizId);
                    } else {
                        subCalc = new BizCalcSubsetInfo();
                        subCalc.setId(BOSUuid.read((String)subBizId));
                        subCalc.setSeq(rst.getInt("FSeq"));
                        subCalc.setFormula(BgDBUtils.getBytes((ResultSet)rst, (String)"FFormula"));
                        subCalc.setName(rst.getString("FSubName"));
                        subCalc.setBizCalc(calc);
                        subCalc.setIncludePost(rst.getBoolean("FIncludePost"));
                        subCalc.setIsZeroUpdate(rst.getBoolean("FIsZeroUpdate"));
                        subCalc.setShowDimNums(rst.getString("FShowDimNums"));
                        subMap.put(subBizId, subCalc);
                        calc.getBizCalcSubset().add(subCalc);
                    }
                    subBizId = rst.getString("FBizCalcSubsetID");
                    if (subMap.containsKey(subBizId)) {
                        subCalc = (BizCalcSubsetInfo)subMap.get(subBizId);
                        scope = new BizScopeInfo();
                        scope.setId(BOSUuid.read((String)rst.getString("SOID")));
                        scope.setBgMemberNum(rst.getString("FBgMemberNum"));
                        scope.setBgMemberType(rst.getInt("FBgMemberType"));
                        scope.setBizDataType(BgMemberSelectTypeEnum.getEnum((int)rst.getInt("FBizDataType")));
                        scope.setRefField(rst.getString("FRefField"));
                        scope.setFillType(DimensionMemberTypeEnum.getEnum((int)rst.getInt("FFillType")));
                        scope.setBizCalcSubset(subCalc);
                        subCalc.getScope().add(scope);
                    }
                    if (this.getRelyMap().isEmpty() || StringUtils.isEmpty((String)bizId)) continue;
                    for (BOSUuid bosId : this.getRelyMap().keySet()) {
                        if (!this.getRelyMap().get(bosId).contains(BOSUuid.read((String)bizId))) continue;
                        if (!this.getRelyObjMap().containsKey(bosId.toString())) {
                            this.getRelyObjMap().put(bosId.toString(), new HashSet());
                        }
                        this.getRelyObjMap().get(bosId.toString()).add(calc);
                    }
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"queryRefBizCaclIds sql error:", (Throwable)ex);
            throw ex;
        }
        finally {
            SQLUtils.cleanup(rst, pstmt);
            if (pool != null) {
                try {
                    BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpTable);
                }
                catch (Exception ex) {
                    logger.error((Object)"queryRefBizCaclIds sql error:", (Throwable)ex);
                }
            }
        }
        return calcs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BizCalcInfo> queryRelyBizCalc(Connection conn, TempTablePool pool, Collection<BizCalcInfo> calcs) throws Exception {
        if (conn == null || pool == null || calcs == null || calcs.isEmpty()) {
            return null;
        }
        List<BizCalcInfo> relys = new ArrayList<BizCalcInfo>();
        String tmpTable = null;
        String calcId = null;
        String relyId = null;
        BOSUuid _calcId = null;
        BOSUuid _relyId = null;
        HashSet allIds = new HashSet();
        HashSet<String> queryIds = new HashSet<String>();
        HashSet<String> tmpSet = new HashSet<String>();
        HashSet<String> relyIds = new HashSet<String>();
        Set<Object> relySet = null;
        for (BizCalcInfo _calc : calcs) {
            queryIds.add(_calc.getId().toString());
        }
        allIds.addAll(queryIds);
        IRowSet rst = null;
        try {
            block21: {
                tmpTable = pool.createTempTable("Create Table TEML_KSQL_0 (FID VARCHAR(44))");
                if (StringUtils.isEmpty((String)tmpTable)) break block21;
                while (!queryIds.isEmpty()) {
                    BgDBUtils.executeUpdate((Connection)conn, (String)("Truncate table " + tmpTable));
                    BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpTable + " (FID) Values (?)"), queryIds);
                    StringBuffer sql = new StringBuffer();
                    sql.append("select t.FRelyBizId, t.FBizCalcID from T_MBG_BizRely t where exists (select FID from " + tmpTable + " where FID = t.FBizCalcID)");
                    try {
                        rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString());
                        while (rst.next()) {
                            relyId = rst.getString("FRelyBizId");
                            calcId = rst.getString("FBizCalcID");
                            if (StringUtils.isEmpty((String)relyId) || StringUtils.isEmpty((String)calcId)) continue;
                            _calcId = BOSUuid.read((String)calcId);
                            _relyId = BOSUuid.read((String)relyId);
                            if (this.getRelyMap().containsKey(_calcId)) {
                                relySet = this.getRelyMap().get(_calcId);
                            } else {
                                relySet = new HashSet();
                                this.getRelyMap().put(_calcId, relySet);
                            }
                            if (relySet != null) {
                                relySet.add(_relyId);
                            }
                            if (allIds.contains(relyId)) continue;
                            allIds.add(relyId);
                            tmpSet.add(relyId);
                        }
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rst);
                        throw throwable;
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                    queryIds.clear();
                    queryIds.addAll(tmpSet);
                    tmpSet.clear();
                    relyIds.addAll(queryIds);
                }
            }
            if (!relyIds.isEmpty()) {
                relys = this.queryBizCalc(conn, pool, relyIds);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"queryRefBizCaclIds sql error:", (Throwable)ex);
            throw ex;
        }
        finally {
            SQLUtils.cleanup(rst);
            if (pool != null) {
                try {
                    BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpTable);
                }
                catch (Exception ex) {
                    logger.error((Object)"queryRefBizCaclIds sql error:", (Throwable)ex);
                }
            }
        }
        return relys;
    }

    public void calcPriority(List<BizCalcInfo> calcs) {
        if (calcs == null || calcs.isEmpty()) {
            return;
        }
        Map<BOSUuid, Set<BOSUuid>> relyIdMap = this.getRelyMap();
        HashMap<BOSUuid, BizCalcInfo> bizCalcMap = new HashMap<BOSUuid, BizCalcInfo>();
        for (BizCalcInfo bizCalc : calcs) {
            bizCalcMap.put(bizCalc.getId(), bizCalc);
        }
        for (BizCalcInfo bizCalc : calcs) {
            this.calcPriority(bizCalc, relyIdMap, bizCalcMap);
        }
        Collections.sort(calcs, new Comparator<BizCalcInfo>(){

            @Override
            public int compare(BizCalcInfo o1, BizCalcInfo o2) {
                int re = o1.getPriority() - o2.getPriority();
                if (re == 0) {
                    o1.getNumber().equals(o2.getNumber());
                }
                return re;
            }
        });
    }

    public Map<Integer, List<BizCalcInfo>> getPriority(List<BizCalcInfo> calcs) {
        HashMap<Integer, List<BizCalcInfo>> priority = new HashMap<Integer, List<BizCalcInfo>>();
        if (calcs == null || calcs.isEmpty()) {
            return priority;
        }
        this.calcPriority(calcs);
        List<BizCalcInfo> tmpList = null;
        for (BizCalcInfo bizCalc : calcs) {
            if (priority.containsKey(bizCalc.getPriority())) {
                tmpList = (List)priority.get(bizCalc.getPriority());
            } else {
                tmpList = new ArrayList();
                priority.put(bizCalc.getPriority(), tmpList);
            }
            if (tmpList == null) continue;
            tmpList.add(bizCalc);
        }
        return priority;
    }

    private void calcPriority(BizCalcInfo calc, Map<BOSUuid, Set<BOSUuid>> relyIdMap, Map<BOSUuid, BizCalcInfo> bizCalcMap) {
        if (calc == null || relyIdMap == null || bizCalcMap == null) {
            return;
        }
        if (relyIdMap.containsKey(calc.getId())) {
            Set<BOSUuid> relys = relyIdMap.get(calc.getId());
            for (BOSUuid relyId : relys) {
                BizCalcInfo _relyCalc = bizCalcMap.get(relyId);
                this.calcPriority(_relyCalc, relyIdMap, bizCalcMap);
                if (_relyCalc == null || _relyCalc.getPriority() < calc.getPriority()) continue;
                calc.setPriority(_relyCalc.getPriority() + 1);
            }
        } else {
            calc.setPriority(0);
        }
    }
}

