/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.utils;

import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.ma.biz.BizScopeCollection;
import com.kingdee.eas.ma.biz.BizScopeInfo;
import com.kingdee.eas.ma.mbg.BizFunctionType;
import com.kingdee.eas.ma.mbg.common.BgProcessHelper;
import com.kingdee.eas.ma.mbg.function.define.MbgFunctionSourceFactory;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class BizCalcCommonHelper {
    private static Map<String, List<String>> fnMap = null;
    private static List<String> memberFn = null;
    private static List<String> mathFn = null;
    private static List<String> boolFn = null;
    private static List<String> aggFn = null;

    public static boolean verifyFormula(String formulaName, String formula) {
        Pattern pattern = null;
        Matcher matcher = null;
        String reg = null;
        if (formulaName.equals("MBR")) {
            reg = formula.indexOf("Sch:") != -1 ? "^MBR:\\[(Sch:[\\w-]+:)?(,?\"?\\w{3}:[\\w|.|\\-|!|+]+\"?|,?\"\"|,?\"FX:\\[@\\w+\\(((\"?\\w+\"?)?,?\"?-?[0-9]\\d*\"?|,?\"?(\\w{3}:[\\w|.|\\-|!|+]+)?\"?)+\\)\\]\")+\\]" : "^MBR:\\[(,?\"\\w{3}:[\\w|.|\\-|!|+]+\"|,?\"\"|,?\"FX:\\[@\\w+\\(((\"?\\w+\"?)?,?\"?-?[0-9]\\d*\"?|,?\"?(\\w{3}:[\\w|.|\\-|!|+]+)?\"?)+\\)\\]\")+\\]";
        } else if (formulaName.equals("PTO")) {
            reg = formula.indexOf("Sch:") != -1 ? "^PTO:\\[(Sch:[\\w-]+:)?(,?\"?\\w{3,}:[\\w|.|\\-|!|+]+\"?|,?\"\"|,?\"FX:\\[@\\w+\\(((\"?\\w+\"?)?,?\"?-?[0-9]\\d*\"?|,?\"?(\\w{3,}:[\\w|.|\\-|!|+]+)?\"?)+\\)\\]\")+\\]" : "^PTO:\\[(,?\"\\w{3,}:[\\w|.|\\-|!|+]+\"|,?\"\"|,?\"FX:\\[@\\w+\\(((\"?\\w+\"?)?,?\"?-?[0-9]\\d*\"?|,?\"?(\\w{3,}:[\\w|.|\\-|!|+]+)?\"?)+\\)\\]\")+\\]";
        } else if (formulaName.equals("LEAF_MBR")) {
            reg = formula.indexOf("Sch:") != -1 ? "^LEAF_MBR:\\[(Sch:[\\w-]+:)?(,?\"?\\w{3}:[\\w|.|\\-|!|+]+\"?|,?\"\"|,?\"FX:\\[@\\w+\\(((\"?\\w+\"?)?,?\"?-?[0-9]\\d*\"?|,?\"?(\\w{3}:[\\w|.|\\-|!|+]+)?\"?)+\\)\\]\")+\\]" : "^LEAF_MBR:\\[(,?\"\\w{3}:[\\w|.|\\-|!|+]+\"|,?\"\"|,?\"FX:\\[@\\w+\\(((\"?\\w+\"?)?,?\"?-?[0-9]\\d*\"?|,?\"?(\\w{3}:[\\w|.|\\-|!|+]+)?\"?)+\\)\\]\")+\\]";
        } else if (formulaName.equals("NLEAF_MBR")) {
            reg = formula.indexOf("Sch:") != -1 ? "^NLEAF_MBR:\\[(Sch:[\\w-]+:)?(,?\"?\\w{3}:[\\w|.|\\-|!|+]+\"?|,?\"\"|,?\"FX:\\[@\\w+\\(((\"?\\w+\"?)?,?\"?-?[0-9]\\d*\"?|,?\"?(\\w{3}:[\\w|.|\\-|!|+]+)?\"?)+\\)\\]\")+\\]" : "^NLEAF_MBR:\\[(,?\"\\w{3}:[\\w|.|\\-|!|+]+\"|,?\"\"|,?\"FX:\\[@\\w+\\(((\"?\\w+\"?)?,?\"?-?[0-9]\\d*\"?|,?\"?(\\w{3}:[\\w|.|\\-|!|+]+)?\"?)+\\)\\]\")+\\]";
        } else if (formulaName.equals("VAR")) {
            reg = "^VAR:\\[\"([\\w-]+\\.)*[\\w-]+\"\\]";
        } else if (formulaName.equals("FX")) {
            if (BizCalcCommonHelper.getFunctionName(formula).equals("@ABS")) {
                reg = "^FX:\\[@ABS\\([\\S\\s]*\\)\\]";
            } else if (BizCalcCommonHelper.getFunctionName(formula).equals("@MAX") || BizCalcCommonHelper.getFunctionName(formula).equals("@MIN") || BizCalcCommonHelper.getFunctionName(formula).equals("@AVG")) {
                if (StringUtils.countMatches((String)formula, (String)"@") == 1) {
                    reg = formula.substring(formula.indexOf("(") + 1, formula.indexOf(":", formula.indexOf("("))).equals("MBR") ? "^FX:\\[@(MAX|MIN|AVG)\\(MBR:\\[\"[\\w]+:(([\\w-]+\\.)*[\\w-]+,)*([\\w-]+\\.)*[\\w-]+\"\\]\\)\\]" : (formula.substring(formula.indexOf("(") + 1, formula.indexOf(":", formula.indexOf("("))).equals("ADD") ? "^FX:\\[@(MAX|MIN|AVG)\\(ADD:\\[\"[\\w]+:(([\\w-]+\\.)*[\\w-]+,)*([\\w-]+\\.)*[\\w-]+\"\\]\\)\\]" : (formula.substring(formula.indexOf("(") + 1, formula.indexOf(":", formula.indexOf("("))).equals("LEAF_MBR") ? "^FX:\\[@(MAX|MIN|AVG)\\(LEAF_MBR:\\[\"[\\w]+:(([\\w-]+\\.)*[\\w-]+,)*([\\w-]+\\.)*[\\w-]+\"\\]\\)\\]" : (formula.substring(formula.indexOf("(") + 1, formula.indexOf(":", formula.indexOf("("))).equals("NLEAF_MBR") ? "^FX:\\[@(MAX|MIN|AVG)\\(NLEAF_MBR:\\[\"[\\w]+:(([\\w-]+\\.)*[\\w-]+,)*([\\w-]+\\.)*[\\w-]+\"\\]\\)\\]" : "^FX:\\[@(MAX|MIN|AVG)\\(VAR:\\[\"(([\\w-]+\\.)*[\\w-]+,)*([\\w-]+\\.)*[\\w-]+\"\\]\\)\\]")));
                } else if (StringUtils.countMatches((String)formula, (String)"@") > 1) {
                    reg = "^FX:\\[@(MAX|MIN|AVG)\\((@\\w+\\(\"\\w+:([\\w-]+\\.)*[\\w-]+\"(,\"(true|false)?\")?\\),)*@\\w+\\(\"\\w+:([\\w-]+\\.)*[\\w-]+\"(,\"(true|false)?\")?\\)\\)\\]";
                }
            } else if (BizCalcCommonHelper.getFunctionName(formula).equals("@IsMember")) {
                if (StringUtils.countMatches((String)formula, (String)"@") == 1) {
                    reg = formula.substring(formula.indexOf("(") + 1, formula.indexOf(":", formula.indexOf("("))).equals("MBR") ? "^FX:\\[@IsMember\\(MBR:\\[\"[\\w]+:(([\\w-]+\\.)*[\\w-]+,)*([\\w-]+\\.)*[\\w-]+\"\\]\\)\\]" : (formula.substring(formula.indexOf("(") + 1, formula.indexOf(":", formula.indexOf("("))).equals("ADD") ? "^FX:\\[@IsMember\\(ADD:\\[\"[\\w]+:(([\\w-]+\\.)*[\\w-]+,)*([\\w-]+\\.)*[\\w-]+\"\\]\\)\\]" : (formula.substring(formula.indexOf("(") + 1, formula.indexOf(":", formula.indexOf("("))).equals("LEAF_MBR") ? "^FX:\\[@IsMember\\(LEAF_MBR:\\[\"[\\w]+:(([\\w-]+\\.)*[\\w-]+,)*([\\w-]+\\.)*[\\w-]+\"\\]\\)\\]" : (formula.substring(formula.indexOf("(") + 1, formula.indexOf(":", formula.indexOf("("))).equals("NLEAF_MBR") ? "^FX:\\[@IsMember\\(NLEAF_MBR:\\[\"[\\w]+:(([\\w-]+\\.)*[\\w-]+,)*([\\w-]+\\.)*[\\w-]+\"\\]\\)\\]" : "^FX:\\[@IsMember\\(VAR:\\[\"(([\\w-]+\\.)*[\\w-]+,)*([\\w-]+\\.)*[\\w-]+\"\\]\\)\\]")));
                } else if (StringUtils.countMatches((String)formula, (String)"@") > 1) {
                    reg = "^FX:\\[@(IsMember)\\((@\\w+\\(\"\\w+:([\\w-]+\\.)*[\\w-]+\"(,\"(true|false)?\")?\\),)*@\\w+\\(\"\\w+:([\\w-]+\\.)*[\\w-]+\"(,\"(true|false)?\")?\\)\\)\\]";
                }
            } else {
                reg = "^FX:\\[@[a-zA-Z]+\\(\"[\\w]+:([\\w-]+\\.)*[\\w-]+\"\\)\\]";
            }
        } else if (formulaName.equals("GVF")) {
            if (formula.substring(formula.indexOf("[") + 1, formula.indexOf("(")).equals("Acct")) {
                reg = "^GVF:\\[Acct\\(\"(([\\w]+\\.)*[\\w]*+; *)*([\\w]+\\.)*[\\w]*\",\"[\\s\\S]*\",\"[\\w]*\",(-?[0-9]+,){4}\"([\\w]+\\.)*[\\w]*\",\"([\\w]+\\.)*[\\w]*\"\\)]";
            } else if (formula.substring(formula.indexOf("[") + 1, formula.indexOf("(")).equals("AcctItem")) {
                reg = "^GVF:\\[AcctItem\\((\"\\w*\",){7}([0-9]*,){3}(\"\\w*\",){3}((true|false),){2}\"\\w*\",(true|false),\"\\w*\"\\)\\]";
                if (formula.startsWith("GVF")) {
                    String formulaExpr = formula.substring(5, formula.length() - 1);
                    try {
                        Expression expression = ExcelFormulaPaserHelper.parse((String)formulaExpr);
                        return BizCalcCommonHelper.checkAcctItemExpression(expression);
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
            } else {
                if (formula.substring(formula.indexOf("[") + 1, formula.indexOf("(")).equals("MbgRefBgTem")) {
                    reg = "^GVF:\\[MbgRefBgTem\\(\"(([\\w]+\\.)*[\\w]*+; *)*([\\w]+\\.)*[\\w]*\",\"[\\s\\S]*\",\"[\\w]*\",(-?[0-9]+,){4}\"([\\w]+\\.)*[\\w]*\",\"([\\w]+\\.)*[\\w]*\"\\)]";
                    return true;
                }
                if (formula.substring(formula.indexOf("[") + 1, formula.indexOf("(")).equals("MbgAdjust")) {
                    reg = "^GVF:\\[MbgAdjust\\(\"(([\\w]+\\.)*[\\w]*+; *)*([\\w]+\\.)*[\\w]*\",\"[\\s\\S]*\",\"[\\w]*\",(-?[0-9]+,){4}\"([\\w]+\\.)*[\\w]*\",\"([\\w]+\\.)*[\\w]*\"\\)]";
                    return true;
                }
                if (formula.substring(formula.indexOf("[") + 1, formula.indexOf("(")).equals("MbgAdjustDate")) {
                    reg = "^GVF:\\[MbgAdjustDate\\(\"(([\\w]+\\.)*[\\w]*+; *)*([\\w]+\\.)*[\\w]*\",\"[\\s\\S]*\",\"[\\w]*\",(-?[0-9]+,){4}\"([\\w]+\\.)*[\\w]*\",\"([\\w]+\\.)*[\\w]*\"\\)]";
                    return true;
                }
            }
        }
        return !com.kingdee.util.StringUtils.isEmpty((String)reg) && (matcher = (pattern = Pattern.compile(reg)).matcher(formula)).matches();
    }

    private static boolean checkAcctItemExpression(Expression expression) {
        if (expression == null) {
            return false;
        }
        if (expression instanceof FunctionExpr) {
            return ((FunctionExpr)expression).parameters.size() == 18;
        }
        return false;
    }

    public static String getFunctionName(String formula) {
        try {
            return formula.substring(formula.indexOf("@"), formula.indexOf("("));
        }
        catch (Exception e) {
            return "";
        }
    }

    public static Set<String> processScope(BizScopeCollection scopes, BgSchemeDimensionHelper schemeHelper) {
        HashSet<String> scopeSrc = new HashSet<String>();
        for (int i = 0; i < scopes.size(); ++i) {
            BizScopeInfo scope = scopes.get(i);
            if (!com.kingdee.util.StringUtils.isEmpty((String)scope.getRefField())) {
                if (scope.getRefField().equals(BgProcessHelper.DEF_PROCESS_FIELD)) {
                    scopeSrc.add(BgProcessHelper.DEF_PROCESS_SRC);
                    continue;
                }
                scopeSrc.add(schemeHelper.getSrcNumberByRefField(scope.getRefField()));
                continue;
            }
            String[] memNum = scope.getBgMemberNum().split("\"");
            if (memNum.length > 1) {
                scopeSrc.add(memNum[1].split(":")[0]);
                continue;
            }
            scopeSrc.add(scope.getBgMemberNum().split(":")[0]);
        }
        return scopeSrc;
    }

    public static void init() {
        if (fnMap != null) {
            return;
        }
        fnMap = MbgFunctionSourceFactory.getInstance().getFunctionNameMap();
        memberFn = fnMap.get(BizFunctionType.MEMBER.getName());
        mathFn = fnMap.get(BizFunctionType.MATH.getName());
        boolFn = fnMap.get(BizFunctionType.BOOLEAN.getName());
        aggFn = fnMap.get(BizFunctionType.AGG.getName());
    }

    public static List<String> getMemberFn() {
        BizCalcCommonHelper.init();
        return memberFn;
    }

    public static List<String> getMathFn() {
        BizCalcCommonHelper.init();
        return mathFn;
    }

    public static List<String> getBoolFn() {
        BizCalcCommonHelper.init();
        return boolFn;
    }

    public static List<String> getAgglFn() {
        BizCalcCommonHelper.init();
        return aggFn;
    }
}

