/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.IMethodBatchQuery;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.ma.budget.BgValueBatchCalculater;
import com.kingdee.eas.ma.budget.CalendarHelper;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;

public class BgBatchCalculatorImpl
implements IMethodBatchQuery {
    private static String _BAD_FUNCTION_ = "#BAD FUNCTION: ";
    private ICalculateContextProvider context;

    public void batchMethodQuery(ICalculateContextProvider context, String methodName, SortedParameterArray params) {
        Context serverCtx = context.getServerContext();
        if (methodName.equalsIgnoreCase("bgFormula")) {
            for (int i = 0; i < params.size(); ++i) {
                Parameter param = params.getParameter(i);
                Object[] objs = param.getArgs();
                String currencyNumber = objs[4].toString();
                String beginNumber = objs[5].toString();
                String endNumber = objs[6].toString();
                String[] strs = this.dealWithPeriodNumber(context, currencyNumber, beginNumber, endNumber);
                objs[4] = new Variant((Object)strs[0]);
                objs[5] = new Variant((Object)strs[1]);
                objs[6] = new Variant((Object)strs[2]);
            }
            BgValueBatchCalculater bgValueCal = new BgValueBatchCalculater(serverCtx);
            bgValueCal.execute(params);
        } else {
            String string = _BAD_FUNCTION_ + methodName;
            for (int i = 0; i < params.size(); ++i) {
                params.getParameter(i).setValue((Object)string);
            }
        }
    }

    public boolean preCalculate(ICalculateContextProvider context, String methodName, Parameter params) {
        return true;
    }

    public boolean batchQuery(Map methods) {
        for (Map.Entry e : methods.entrySet()) {
            String method = (String)e.getKey();
            SortedParameterArray param = (SortedParameterArray)e.getValue();
            this.batchMethodQuery(this.context, method, param);
        }
        return true;
    }

    public Object bgFormula(String orgNum, String schemeNum, String elementNum, String bgItemNum, String currencyNum, String beginPeriodNum, String endPeriodNum) {
        return null;
    }

    public void initCalculateContext(ICalculateContextProvider context) {
        this.context = context;
    }

    private String[] dealWithPeriodNumber(ICalculateContextProvider context, String currencyNumber, String beginPeriodNumber, String endPeriodNumber) {
        IReportPropertyAdapter adapter = context.getReportAdapter();
        if (currencyNumber == null || currencyNumber.trim().equals("")) {
            currencyNumber = (String)adapter.getReportProperty("Currency.Number");
        }
        if (beginPeriodNumber.equals("")) {
            beginPeriodNumber = "0";
        }
        if (endPeriodNumber.equals("")) {
            endPeriodNumber = "0";
        }
        int begin = 0;
        int end = 0;
        boolean isPass = true;
        try {
            begin = Integer.parseInt(beginPeriodNumber);
            end = Integer.parseInt(endPeriodNumber);
        }
        catch (NumberFormatException e) {
            isPass = false;
        }
        int currentYear = 0;
        boolean currentPuarter = false;
        int currentPeriod = 0;
        if (adapter.getReportProperty("BG_PERIOD_TYPE") != null && isPass) {
            int bgPeriodType = (Integer)adapter.getReportProperty("BG_PERIOD_TYPE");
            currentYear = (Integer)adapter.getReportProperty("BG_PERIOD_YEAR");
            if (bgPeriodType == 1) {
                currentPeriod = 0;
                if (begin > 0) {
                    beginPeriodNumber = begin + "Y";
                } else {
                    int beginYear = currentYear + begin;
                    beginPeriodNumber = beginYear + "Y";
                }
                if (end > 0) {
                    endPeriodNumber = end + "Y";
                } else {
                    int endYear = currentYear + end;
                    endPeriodNumber = endYear + "Y";
                }
            } else if (bgPeriodType == 4) {
                currentPeriod = (Integer)adapter.getReportProperty("BG_PERIOD_MONTH");
                int beginYear = currentYear;
                int beginPeriod = 0;
                beginPeriod = begin <= 0 ? currentPeriod + begin : (begin <= 12 ? begin : 12);
                if (begin <= 0) {
                    if (beginPeriod <= 0) {
                        int i = beginPeriod / 12;
                        int j = beginPeriod % 12;
                        beginYear = beginYear + i - 1;
                        beginPeriod = 12 + j;
                    }
                } else {
                    beginYear = currentYear;
                    beginPeriod = begin;
                }
                int endYear = currentYear;
                int endPeriod = 0;
                endPeriod = end <= 0 ? currentPeriod + end : (end <= 12 ? end : 12);
                if (end <= 0) {
                    if (endPeriod <= 0) {
                        int i = endPeriod / 12;
                        int j = endPeriod % 12;
                        endYear = endYear + i - 1;
                        endPeriod = 12 + j;
                    }
                } else {
                    endYear = currentYear;
                    endPeriod = end;
                }
                beginPeriodNumber = beginYear + "Y." + (beginPeriod < 10 ? "0" + beginPeriod : beginPeriod + "") + "M";
                endPeriodNumber = endYear + "Y." + (endPeriod < 10 ? "0" + endPeriod : endPeriod + "") + "M";
            } else if (bgPeriodType == 3) {
                currentPeriod = (Integer)adapter.getReportProperty("BG_PERIOD_MONTH");
                int beginYear = currentYear;
                int beginPeriod = 0;
                beginPeriod = begin <= 0 ? currentPeriod + begin : (begin <= 4 ? begin : 4);
                if (begin <= 0) {
                    if (beginPeriod <= 0) {
                        int i = beginPeriod / 4;
                        int j = beginPeriod % 4;
                        beginYear = beginYear + i - 1;
                        beginPeriod = 4 + j;
                    }
                } else {
                    beginYear = currentYear;
                    beginPeriod = begin;
                }
                int endYear = currentYear;
                int endPeriod = 0;
                endPeriod = end <= 0 ? currentPeriod + end : (end <= 4 ? end : 4);
                if (end <= 0) {
                    if (endPeriod <= 0) {
                        int i = endPeriod / 4;
                        int j = endPeriod % 4;
                        endYear = endYear + i - 1;
                        endPeriod = 4 + j;
                    }
                } else {
                    endYear = currentYear;
                    endPeriod = end;
                }
                beginPeriodNumber = beginYear + "Y." + (beginPeriod < 10 ? "0" + beginPeriod : beginPeriod + "") + "Q";
                endPeriodNumber = endYear + "Y." + (endPeriod < 10 ? "0" + endPeriod : endPeriod + "") + "Q";
            } else if (bgPeriodType == 2) {
                currentPeriod = (Integer)adapter.getReportProperty("BG_PERIOD_MONTH");
                int beginYear = currentYear;
                int beginPeriod = 0;
                beginPeriod = begin <= 0 ? currentPeriod + begin : (begin <= 2 ? begin : 2);
                if (begin <= 0) {
                    if (beginPeriod <= 0) {
                        int i = beginPeriod / 2;
                        int j = beginPeriod % 2;
                        beginYear = beginYear + i - 1;
                        beginPeriod = 2 + j;
                    }
                } else {
                    beginYear = currentYear;
                    beginPeriod = begin;
                }
                int endYear = currentYear;
                int endPeriod = 0;
                endPeriod = end <= 0 ? currentPeriod + end : (end <= 2 ? end : 2);
                if (end <= 0) {
                    if (endPeriod <= 0) {
                        int i = endPeriod / 2;
                        int j = endPeriod % 2;
                        endYear = endYear + i - 1;
                        endPeriod = 2 + j;
                    }
                } else {
                    endYear = currentYear;
                    endPeriod = end;
                }
                beginPeriodNumber = beginYear + "Y." + (beginPeriod < 10 ? "0" + beginPeriod : beginPeriod + "") + "HY";
                endPeriodNumber = endYear + "Y." + (endPeriod < 10 ? "0" + endPeriod : endPeriod + "") + "HY";
            } else if (bgPeriodType == 5) {
                currentYear = (Integer)adapter.getReportProperty("BG_PERIOD_YEAR");
                currentPeriod = (Integer)adapter.getReportProperty("BG_PERIOD_MONTH");
                CalendarHelper calendar = new CalendarHelper();
                int beginYear = currentYear;
                int endYear = currentYear;
                int maxWeek = calendar.getWeeksOfYear(currentYear, true);
                int beginPeriod = 0;
                if (begin <= 0) {
                    if (beginPeriod <= 0) {
                        int _maxWeeks;
                        for (beginPeriod = begin <= 0 ? currentPeriod + begin : (begin <= maxWeek ? begin : maxWeek); beginPeriod <= 0; beginPeriod += _maxWeeks) {
                            _maxWeeks = calendar.getWeeksOfYear(--beginYear, true);
                        }
                    }
                } else {
                    beginYear = currentYear;
                    beginPeriod = begin;
                }
                int endPeriod = 0;
                if (end <= 0) {
                    if (endPeriod <= 0) {
                        int _maxWeeks;
                        for (endPeriod = end <= 0 ? currentPeriod + end : (end <= maxWeek ? end : maxWeek); endPeriod <= 0; endPeriod += _maxWeeks) {
                            _maxWeeks = calendar.getWeeksOfYear(--endYear, true);
                        }
                    }
                } else {
                    endYear = currentYear;
                    endPeriod = end;
                }
                beginPeriodNumber = beginYear + "Y." + (beginPeriod < 10 ? "0" + beginPeriod : beginPeriod + "") + "W";
                endPeriodNumber = endYear + "Y." + (endPeriod < 10 ? "0" + endPeriod : endPeriod + "") + "W";
            } else if (bgPeriodType == 7) {
                currentYear = (Integer)adapter.getReportProperty("BG_PERIOD_YEAR");
                currentPeriod = (Integer)adapter.getReportProperty("BG_PERIOD_MONTH");
                CalendarHelper calendar = new CalendarHelper();
                int maxDays = calendar.isLeapYear(currentYear) ? 366 : 365;
                int beginYear = currentYear;
                int endYear = currentYear;
                int beginPeriod = 0;
                if (begin <= 0) {
                    if (beginPeriod <= 0) {
                        int _maxDays;
                        for (beginPeriod = begin <= 0 ? currentPeriod + begin : (begin <= maxDays ? begin : maxDays); beginPeriod <= 0; beginPeriod += _maxDays) {
                            _maxDays = calendar.getDaysOfYear(--beginYear);
                        }
                    }
                } else {
                    beginYear = currentYear;
                    beginPeriod = begin;
                }
                int endPeriod = 0;
                if (end <= 0) {
                    if (endPeriod <= 0) {
                        int _maxDays;
                        for (endPeriod = end <= 0 ? currentPeriod + end : (end <= maxDays ? end : maxDays); endPeriod <= 0; endPeriod += _maxDays) {
                            _maxDays = calendar.getDaysOfYear(--endYear);
                        }
                    }
                } else {
                    endYear = currentYear;
                    endPeriod = end;
                }
                Calendar _calendar = Calendar.getInstance();
                _calendar.set(1, beginYear);
                _calendar.set(2, 1);
                _calendar.set(6, 1);
                _calendar.add(6, beginPeriod);
                beginPeriodNumber = new SimpleDateFormat("yyyy'Y.'MM'M.'dd'D'").format(_calendar.getTime());
                _calendar.set(1, endYear);
                _calendar.set(2, 1);
                _calendar.set(6, 1);
                _calendar.add(6, endPeriod);
                endPeriodNumber = new SimpleDateFormat("yyyy'Y.'MM'M.'dd'D'").format(_calendar.getTime());
            }
        } else if (isPass) {
            int endYear;
            currentYear = (Integer)adapter.getReportProperty("Report.Year");
            currentPeriod = (Integer)adapter.getReportProperty("Report.Period");
            RptPeriodTypeEnum type = RptPeriodTypeEnum.getEnum((int)((Integer)adapter.getReportProperty("PeriodType")));
            int reportStartYear = adapter.getReportProperty("Report_StartYear") == null ? 0 : (Integer)adapter.getReportProperty("Report_StartYear");
            int reportStartPeriod = adapter.getReportProperty("Report_StartPeriod") == null ? 0 : (Integer)adapter.getReportProperty("Report_StartPeriod");
            int reportEndYear = adapter.getReportProperty("Report_EndYear") == null ? 0 : (Integer)adapter.getReportProperty("Report_EndYear");
            int reportEndPeriod = adapter.getReportProperty("Report_EndPeriod") == null ? 0 : (Integer)adapter.getReportProperty("Report_EndPeriod");
            int beginYear = reportStartYear == 0 ? currentYear : reportStartYear;
            int n = endYear = reportEndYear == 0 ? currentYear : reportEndYear;
            if (type.getValue() == 6) {
                currentPeriod = 0;
                boolean beginPeriod = false;
                beginPeriodNumber = begin > 0 ? begin + "Y" : (beginYear += begin) + "Y";
                endPeriodNumber = end > 0 ? end + "Y" : (endYear += end) + "Y";
            } else if (type.getValue() == 3) {
                int beginPeriod = 0;
                beginPeriod = begin <= 0 ? (reportStartPeriod == 0 ? currentPeriod + begin : reportStartPeriod + begin) : (begin <= 12 ? begin : 12);
                if (begin <= 0) {
                    if (beginPeriod <= 0) {
                        int i = beginPeriod / 12;
                        int j = beginPeriod % 12;
                        beginYear = beginYear + i - 1;
                        beginPeriod = 12 + j;
                    }
                } else {
                    beginYear = currentYear;
                    beginPeriod = begin;
                }
                int endPeriod = 0;
                endPeriod = end <= 0 ? (reportEndPeriod == 0 ? currentPeriod + end : reportEndPeriod + end) : (end <= 12 ? end : 12);
                if (end <= 0) {
                    if (endPeriod <= 0) {
                        int i = endPeriod / 12;
                        int j = endPeriod % 12;
                        endYear = endYear + i - 1;
                        endPeriod = 12 + j;
                    }
                } else {
                    endYear = currentYear;
                    endPeriod = end;
                }
                beginPeriodNumber = beginYear + "Y." + (beginPeriod < 10 ? "0" + beginPeriod : beginPeriod + "") + "M";
                endPeriodNumber = endYear + "Y." + (endPeriod < 10 ? "0" + endPeriod : endPeriod + "") + "M";
            } else if (type.getValue() == 4) {
                int beginPeriod = 0;
                beginPeriod = begin <= 0 ? (reportStartPeriod == 0 ? currentPeriod + begin : reportStartPeriod + begin) : (begin <= 4 ? begin : 4);
                if (begin <= 0) {
                    if (beginPeriod <= 0) {
                        int i = beginPeriod / 4;
                        int j = beginPeriod % 4;
                        beginYear = beginYear + i - 1;
                        beginPeriod = 4 + j;
                    }
                } else {
                    beginYear = currentYear;
                    beginPeriod = begin;
                }
                int endPeriod = 0;
                endPeriod = end <= 0 ? (reportEndPeriod == 0 ? currentPeriod + end : reportEndPeriod + end) : (end <= 4 ? end : 4);
                if (end <= 0) {
                    if (endPeriod <= 0) {
                        int i = endPeriod / 4;
                        int j = endPeriod % 4;
                        endYear = endYear + i - 1;
                        endPeriod = 4 + j;
                    }
                } else {
                    endYear = currentYear;
                    endPeriod = end;
                }
                beginPeriodNumber = beginYear + "Y." + (beginPeriod < 10 ? "0" + beginPeriod : beginPeriod + "") + "Q";
                endPeriodNumber = endYear + "Y." + (endPeriod < 10 ? "0" + endPeriod : endPeriod + "") + "Q";
            } else if (type.getValue() == 5) {
                int beginPeriod = 0;
                beginPeriod = begin <= 0 ? (reportStartPeriod == 0 ? currentPeriod + begin : reportStartPeriod + begin) : (begin <= 2 ? begin : 2);
                if (begin <= 0) {
                    if (beginPeriod <= 0) {
                        int i = beginPeriod / 2;
                        int j = beginPeriod % 2;
                        beginYear = beginYear + i - 1;
                        beginPeriod = 2 + j;
                    }
                } else {
                    beginYear = currentYear;
                    beginPeriod = begin;
                }
                int endPeriod = 0;
                endPeriod = end <= 0 ? (reportEndPeriod == 0 ? currentPeriod + end : reportEndPeriod + end) : (end <= 2 ? end : 2);
                if (end <= 0) {
                    if (endPeriod <= 0) {
                        int i = endPeriod / 2;
                        int j = endPeriod % 2;
                        endYear = endYear + i - 1;
                        endPeriod = 2 + j;
                    }
                } else {
                    endYear = currentYear;
                    endPeriod = end;
                }
                beginPeriodNumber = beginYear + "Y." + (beginPeriod < 10 ? "0" + beginPeriod : beginPeriod + "") + "HY";
                endPeriodNumber = endYear + "Y." + (endPeriod < 10 ? "0" + endPeriod : endPeriod + "") + "HY";
            } else if (type.getValue() == 2) {
                CalendarHelper calendar = new CalendarHelper();
                int maxWeek = calendar.getWeeksOfYear(currentYear, true);
                int beginPeriod = 0;
                if (begin <= 0) {
                    if (beginPeriod <= 0) {
                        int _maxWeeks;
                        for (beginPeriod = begin <= 0 ? (reportStartPeriod == 0 ? currentPeriod + begin : reportStartPeriod + begin) : (begin <= maxWeek ? begin : maxWeek); beginPeriod <= 0; beginPeriod += _maxWeeks) {
                            _maxWeeks = calendar.getWeeksOfYear(--beginYear, true);
                        }
                    }
                } else {
                    beginYear = currentYear;
                    beginPeriod = begin;
                }
                int endPeriod = 0;
                if (end <= 0) {
                    if (endPeriod <= 0) {
                        int _maxWeeks;
                        for (endPeriod = end <= 0 ? (reportEndPeriod == 0 ? currentPeriod + end : reportEndPeriod + end) : (end <= maxWeek ? end : maxWeek); endPeriod <= 0; endPeriod += _maxWeeks) {
                            _maxWeeks = calendar.getWeeksOfYear(--endYear, true);
                        }
                    }
                } else {
                    endYear = currentYear;
                    endPeriod = end;
                }
                beginPeriodNumber = beginYear + "Y." + (beginPeriod < 10 ? "0" + beginPeriod : beginPeriod + "") + "W";
                endPeriodNumber = endYear + "Y." + (endPeriod < 10 ? "0" + endPeriod : endPeriod + "") + "W";
            } else if (type.getValue() == 1) {
                CalendarHelper calendar = new CalendarHelper();
                int maxDays = calendar.isLeapYear(currentYear) ? 366 : 365;
                int beginPeriod = 0;
                if (begin <= 0) {
                    if (beginPeriod <= 0) {
                        int _maxDays;
                        for (beginPeriod = begin <= 0 ? (reportStartPeriod == 0 ? currentPeriod + begin : reportStartPeriod + begin) : (begin <= maxDays ? begin : maxDays); beginPeriod <= 0; beginPeriod += _maxDays) {
                            _maxDays = calendar.getDaysOfYear(--beginYear);
                        }
                    }
                } else {
                    beginYear = currentYear;
                    beginPeriod = begin;
                }
                int endPeriod = 0;
                if (end <= 0) {
                    if (endPeriod <= 0) {
                        int _maxDays;
                        for (endPeriod = end <= 0 ? (reportEndPeriod == 0 ? currentPeriod + end : reportEndPeriod + end) : (end <= maxDays ? end : maxDays); endPeriod <= 0; endPeriod += _maxDays) {
                            _maxDays = calendar.getDaysOfYear(--endYear);
                        }
                    }
                } else {
                    endYear = currentYear;
                    endPeriod = end;
                }
                Calendar _calendar = Calendar.getInstance();
                _calendar.set(1, beginYear);
                _calendar.set(2, 1);
                _calendar.set(6, 1);
                _calendar.add(6, beginPeriod);
                beginPeriodNumber = new SimpleDateFormat("yyyy'Y.'MM'M.'dd'D'").format(_calendar.getTime());
                _calendar.set(1, endYear);
                _calendar.set(2, 1);
                _calendar.set(6, 1);
                _calendar.add(6, endPeriod);
                endPeriodNumber = new SimpleDateFormat("yyyy'Y.'MM'M.'dd'D'").format(_calendar.getTime());
            }
        }
        return new String[]{currencyNumber, beginPeriodNumber, endPeriodNumber};
    }
}

