/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.BgControlPeriodMapCollection;
import com.kingdee.eas.ma.budget.BgControlPeriodMapFactory;
import com.kingdee.eas.ma.budget.BgLocaleHelper;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgControlPeriodMapHelper {
    private static final Logger logger = Logger.getLogger(BgControlPeriodMapHelper.class);
    public static final String RESOURCE = "com.kingdee.eas.ma.budget.client.BgPeriodResource";
    private static Map clientResource = null;
    public static final String WILDCARD = "%";
    public static final String STAND_COMMON_DATE_STYLE = "yyyy-MM-dd";
    public static final String STAND_WILDCARD_DATE_STYLE = "%-MM-dd";

    public static String parseToWildcardDateStyle(String commonDateStyle) {
        StringBuffer result = new StringBuffer();
        if (commonDateStyle != null) {
            boolean isReplace = false;
            for (int i = 0; i < commonDateStyle.length(); ++i) {
                char c = commonDateStyle.charAt(i);
                if (c == 'Y' || c == 'y') {
                    if (isReplace) continue;
                    result.append('%');
                    isReplace = true;
                    continue;
                }
                result.append(c);
            }
        }
        return result.toString();
    }

    public static boolean isWildcard(String period) {
        return period != null && period.indexOf(WILDCARD) >= 0;
    }

    public static Map queryBgPeriod(Context ctx, BgControlPeriodMapCollection col) {
        return null;
    }

    public static Date processDate(Date bizDate, String date, Context ctx) throws BOSException {
        Date ret = new Date();
        for (int i = 0; i < BgLocaleHelper.locales.length; ++i) {
            date = date.replaceAll(BgControlPeriodMapHelper.getString(ctx, "9_BgControlPeriodMapControllerBean", BgLocaleHelper.locales[i]), "-");
            date = date.replaceAll(BgControlPeriodMapHelper.getString(ctx, "10_BgControlPeriodMapControllerBean", BgLocaleHelper.locales[i]), "-");
            date = date.replaceAll(BgControlPeriodMapHelper.getString(ctx, "11_BgControlPeriodMapControllerBean", BgLocaleHelper.locales[i]), "-");
        }
        String[] s = date.split("\\-");
        String year = s[0];
        String month = s[1];
        String day = s[2];
        if (year.indexOf(WILDCARD) > -1) {
            year = year.replaceAll(WILDCARD, String.valueOf(bizDate.getYear() + 1900));
        }
        if (month.indexOf("0") == 0) {
            month = month.substring(1, month.length());
        }
        if (day.indexOf("0") == 0) {
            day = day.substring(1, day.length());
        }
        ret.setYear(Integer.valueOf(year) - 1900);
        ret.setMonth(Integer.valueOf(month) - 1);
        ret.setDate(Integer.valueOf(day));
        return ret;
    }

    public static String getString(Context ctx, String key, Locale locale) throws BOSException {
        String resource = "com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource";
        if (ctx == null) {
            if (clientResource == null) {
                HashSet<String> keys = new HashSet<String>();
                keys.add("9_BgControlPeriodMapControllerBean");
                keys.add("10_BgControlPeriodMapControllerBean");
                keys.add("11_BgControlPeriodMapControllerBean");
                clientResource = BgControlPeriodMapFactory.getRemoteInstance().getString(resource, keys, BgLocaleHelper.locales);
            }
            if (locale == null) {
                locale = SysContext.getSysContext().getLocale();
            }
            if (clientResource.containsKey(key + "_" + locale)) {
                return (String)clientResource.get(key + "_" + locale);
            }
            return EASResource.getString((String)resource, (String)key);
        }
        if (locale == null) {
            locale = ctx.getLocale();
        }
        return ResourceBase.getString((String)resource, (String)key, (Locale)locale);
    }

    public static void convertBgPeriod(BgPeriodInfo bgPeriod, boolean isWild) {
        if (bgPeriod != null) {
            if (bgPeriod.getNumber().indexOf(WILDCARD) >= 0) {
                if (!isWild) {
                    int year = Calendar.getInstance().get(1);
                    bgPeriod.setYear(year);
                    bgPeriod.setNumber(bgPeriod.getNumber().replaceAll(WILDCARD, String.valueOf(year)));
                    bgPeriod.setName(bgPeriod.getName().replaceAll(WILDCARD, String.valueOf(year)));
                }
            } else if (isWild) {
                bgPeriod.setNumber(bgPeriod.getNumber().replaceAll(String.valueOf(bgPeriod.getYear()), WILDCARD));
                bgPeriod.setName(bgPeriod.getName().replaceAll(String.valueOf(bgPeriod.getYear()), WILDCARD));
            }
        }
    }

    public static void fillBgPeriodInfo(Context ctx, BgControlPeriodMapCollection col) throws BOSException {
        if (col == null || col.isEmpty()) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmtNumber = null;
        PreparedStatement pstmtNumberLike = null;
        PreparedStatement pstmtName = null;
        PreparedStatement pstmtNameLike = null;
        String select = "Select fnumber, fname_" + ctx.getLocale() + " fname, fyear, fperiodtype from t_bg_bgperiod where ";
        ResultSet res = null;
        String year_l2 = BgControlPeriodMapHelper.getString(ctx, "9_BgControlPeriodMapControllerBean", LocaleUtils.locale_l2);
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmtNumber = conn.prepareStatement(select + "fnumber = ?");
            pstmtNumberLike = conn.prepareStatement(select + "fnumber like ?");
            pstmtName = conn.prepareStatement(select + "fname_l2 = ? or fname_l3 = ?");
            pstmtNameLike = conn.prepareStatement(select + "fname_l2 like ? or fname_l3 like ?");
            for (int i = 0; i < col.size(); ++i) {
                boolean nameFilter;
                String period = col.get(i).getBgPeriod();
                boolean hasWild = period.indexOf(WILDCARD) >= 0;
                boolean bl = nameFilter = period.indexOf(year_l2) >= 0;
                if (hasWild) {
                    if (nameFilter) {
                        pstmtNameLike.setString(1, period);
                        pstmtNameLike.setString(2, period);
                        res = pstmtNameLike.executeQuery();
                    } else {
                        pstmtNumberLike.setString(1, period);
                        res = pstmtNumberLike.executeQuery();
                    }
                } else if (nameFilter) {
                    pstmtName.setString(1, period);
                    pstmtName.setString(2, period);
                    res = pstmtName.executeQuery();
                } else {
                    pstmtNumber.setString(1, period);
                    res = pstmtNumber.executeQuery();
                }
                if (!res.next()) continue;
                BgPeriodInfo bgPeriod = new BgPeriodInfo();
                bgPeriod.setNumber(res.getString("fnumber"));
                bgPeriod.setName(res.getString("fname"));
                bgPeriod.setYear(res.getInt("fyear"));
                bgPeriod.setPeriodType(BgPeriodEnum.getEnum(res.getInt("fperiodtype")));
                col.get(i).put("BGPERIOD_INFO", bgPeriod);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(res);
                SQLUtils.cleanup(pstmtNumber);
                SQLUtils.cleanup(pstmtNumberLike);
                SQLUtils.cleanup(pstmtName);
                SQLUtils.cleanup(pstmtNameLike);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(res);
        SQLUtils.cleanup((Statement)pstmtNumber);
        SQLUtils.cleanup((Statement)pstmtNumberLike);
        SQLUtils.cleanup((Statement)pstmtName);
        SQLUtils.cleanup((Statement)pstmtNameLike);
        SQLUtils.cleanup((Connection)conn);
    }
}

