/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.appframework.databinding.BindingUtility;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.metadata.MetaDataUtils;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.NewOrgUnitHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgControlRuleCollection;
import com.kingdee.eas.ma.budget.BgControlRuleInfo;
import com.kingdee.eas.ma.budget.BudgetCtrlCaller;
import com.kingdee.eas.ma.budget.INewBgControlFacade;
import com.kingdee.eas.ma.budget.NewBgControlFacadeFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgCtrlHelper {
    private static final Logger logger = CoreUIObject.getLogger(BgCtrlHelper.class);
    public static final String IsFindUpperOrg = "IsFindUpperOrg";
    public static final String FindUpperOrgMaxLevel = "FindUpperOrgMaxLevel";
    public static final String IsCanControlWithoutBudget = "IsCanControlWithoutBudget";

    public static Map getParentOrgUnitMap(Context ctx, Map orgUnitMap, boolean isFindUpperOrg, int findMaxLevel) throws EASBizException, BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (findMaxLevel <= 0 || orgUnitMap.isEmpty() || !isFindUpperOrg) {
            return map;
        }
        block2: for (String orgUnitId : orgUnitMap.keySet()) {
            for (int index = 1; index <= findMaxLevel; ++index) {
                OrgUnitInfo org = null;
                try {
                    org = NewOrgUnitHelper.getTypedOrgUnit((Context)ctx, (String)orgUnitId, (OrgType)OrgType.CostCenter);
                }
                catch (ObjectNotFoundException e) {
                    logger.error((Object)e);
                }
                if (org == null || org.get("parent") == null) continue block2;
                String realId = new String(orgUnitId);
                map.put(realId, ((OrgUnitInfo)org.get("parent")).getId().toString());
                orgUnitId = ((OrgUnitInfo)org.get("parent")).getId().toString();
            }
        }
        return map;
    }

    public static Map getBgCtrlNeededFields(Context ctx, IObjectValue billInfo) throws BOSException, EASBizException {
        String boName = BgCtrlHelper.getBONameFromObjectValue(ctx, billInfo);
        return BgCtrlHelper.getBgCtrlNeededFields(ctx, boName);
    }

    public static Map getBgCtrlNeededFields(Context ctx, String boName) throws BOSException, EASBizException {
        if (boName == null || boName.length() == 0) {
            throw new IllegalArgumentException("the boName parameter is null!");
        }
        HashMap<String, String> fieldsMap = new HashMap<String, String>();
        INewBgControlFacade newBgCtrl = null;
        newBgCtrl = ctx == null ? NewBgControlFacadeFactory.getRemoteInstance() : NewBgControlFacadeFactory.getLocalInstance(ctx);
        BgControlRuleCollection ruleCol = newBgCtrl.getCtrlRuleColl(boName);
        if (ruleCol == null || ruleCol.size() == 0) {
            return fieldsMap;
        }
        Iterator iterator = ruleCol.iterator();
        while (iterator.hasNext()) {
            BgControlRuleInfo rule = (BgControlRuleInfo)iterator.next();
            String oqlItemCombination = rule.getOqlItemCombination();
            String aliasItemCombination = rule.getAliasItemCombination();
            String[] tempField = oqlItemCombination.split("\\@");
            String[] tempAlias = aliasItemCombination.split("\\@");
            for (int i = 0; i < tempField.length; ++i) {
                String[] _tempField = tempField[i].split("\\|");
                String[] _tempAlias = tempAlias[i].split("\\|");
                fieldsMap.put(_tempField[0], _tempAlias[0].split("\\.")[0]);
            }
            String oqlOrgUnit = rule.getOqlOrgUnit();
            String aliasOrgUnit = rule.getAliasOrgUnit();
            fieldsMap.put(oqlOrgUnit.split("\\|")[0], aliasOrgUnit.split("\\|")[0]);
            String oqlCurrency = rule.getOqlCurrency();
            String aliasCurrency = rule.getAliasCurrency();
            fieldsMap.put(oqlCurrency, aliasCurrency);
            String oqlBizDate = rule.getOqlBizDate();
            String aliasBizDate = rule.getAliasBizDate();
            fieldsMap.put(oqlBizDate, aliasBizDate);
            String oqlRequest = rule.getOqlRequest();
            String aliasRequest = rule.getAliasRequest();
            fieldsMap.put(oqlRequest.split("\\|")[0], aliasRequest.split("\\|")[0]);
        }
        return fieldsMap;
    }

    public static boolean isBgCtrlNeededFields(Context ctx, IObjectValue billInfo, String fieldName) throws BOSException, EASBizException {
        String boName = BgCtrlHelper.getBONameFromObjectValue(ctx, billInfo);
        return BgCtrlHelper.isBgCtrlNeededFields(ctx, boName, fieldName);
    }

    public static boolean isBgCtrlNeededFields(Context ctx, String boName, String fieldName) throws EASBizException, BOSException {
        Map allNeededFields = BgCtrlHelper.getBgCtrlNeededFields(ctx, boName);
        if (allNeededFields == null || allNeededFields.isEmpty()) {
            return false;
        }
        return allNeededFields.containsKey(fieldName);
    }

    public static String checkBillInfo(Context ctx, IObjectValue billInfo) throws BOSException, EASBizException {
        BudgetCtrlCaller.checkBillInfo(ctx, billInfo);
        return null;
    }

    public static String getBONameFromObjectValue(Context ctx, IObjectValue info) throws BOSException {
        return MetaDataUtils.getBOFromCache((Context)ctx, (BOSObjectType)info.getBOSType()).getFullName();
    }

    private static boolean isSpecificallyOrg(Context ctx, String boName, IObjectValue billInfo) throws BOSException, EASBizException {
        INewBgControlFacade newBgCtrl = null;
        newBgCtrl = ctx == null ? NewBgControlFacadeFactory.getRemoteInstance() : NewBgControlFacadeFactory.getLocalInstance(ctx);
        BgControlRuleCollection ruleCol = newBgCtrl.getCtrlRuleColl(boName);
        Iterator iterator = ruleCol.iterator();
        while (iterator.hasNext()) {
            BgControlRuleInfo rule = (BgControlRuleInfo)iterator.next();
            String oqlOrgUnit = rule.getOqlOrgUnit();
            String[] oqlOrgTmp = oqlOrgUnit.split("\\|");
            if (oqlOrgTmp.length != 2) {
                return true;
            }
            String orgFiled = oqlOrgTmp[0];
            String[] SpecificallyOrgs = oqlOrgTmp[1].split("\\,");
            Vector fieldValues = BgCtrlHelper.getFieldValue(billInfo, orgFiled.split("\\."), true);
            for (int i = 0; i < SpecificallyOrgs.length; ++i) {
                String theSpecificallyOrg = SpecificallyOrgs[i];
                if (!theSpecificallyOrg.equals(fieldValues.get(0))) continue;
                return true;
            }
        }
        return false;
    }

    private static Vector getFieldValue(IObjectValue info, String[] orgUnitSubFields, boolean isFilterSame) {
        Vector vecOrgNumber = new Vector();
        ArrayList map = new ArrayList();
        BgCtrlHelper.subGetFieldValue(info, map, orgUnitSubFields, 0, isFilterSame);
        for (int i = 0; map != null && i < map.size(); ++i) {
            vecOrgNumber.add(map.get(i));
        }
        return vecOrgNumber;
    }

    private static void subGetFieldValue(IObjectValue info, List map, String[] tmp, int index, boolean isFilterSame) {
        if (BindingUtility.getBeanProperty((Object)info, (String)tmp[index]) != null) {
            if (BindingUtility.getBeanProperty((Object)info, (String)tmp[index]) instanceof IObjectCollection) {
                IObjectCollection coll = (IObjectCollection)BindingUtility.getBeanProperty((Object)info, (String)tmp[index]);
                for (int i = 0; i < coll.size(); ++i) {
                    IObjectValue tmpInfo = coll.getObject(i);
                    if (index + 1 < tmp.length) {
                        BgCtrlHelper.subGetFieldValue(tmpInfo, map, tmp, index + 1, isFilterSame);
                        continue;
                    }
                    if (isFilterSame) {
                        if (map.contains(BindingUtility.getBeanProperty((Object)info, (String)tmp[index]))) continue;
                        map.add(BindingUtility.getBeanProperty((Object)info, (String)tmp[index]));
                        continue;
                    }
                    map.add(BindingUtility.getBeanProperty((Object)info, (String)tmp[index]));
                }
            } else if (BindingUtility.getBeanProperty((Object)info, (String)tmp[index]) instanceof IObjectValue) {
                IObjectValue tmpInfo = (IObjectValue)BindingUtility.getBeanProperty((Object)info, (String)tmp[index]);
                if (index + 1 < tmp.length) {
                    BgCtrlHelper.subGetFieldValue(tmpInfo, map, tmp, index + 1, isFilterSame);
                } else if (isFilterSame) {
                    if (!map.contains(BindingUtility.getBeanProperty((Object)info, (String)tmp[index]))) {
                        map.add(BindingUtility.getBeanProperty((Object)info, (String)tmp[index]));
                    }
                } else {
                    map.add(BindingUtility.getBeanProperty((Object)info, (String)tmp[index]));
                }
            } else if (isFilterSame) {
                if (!map.contains(BindingUtility.getBeanProperty((Object)info, (String)tmp[index]))) {
                    map.add(BindingUtility.getBeanProperty((Object)info, (String)tmp[index]));
                }
            } else {
                map.add(BindingUtility.getBeanProperty((Object)info, (String)tmp[index]));
            }
        }
    }
}

