/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.ma.budget.BgCtrSettingFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.budget.IBgCtrSettingFacade;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNPeriodHelper;
import com.kingdee.eas.ma.nbudget.BgNTemplateHelper;
import com.kingdee.eas.ma.view.util.BgViewCommonHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class BgCtrlSetHelper {
    public static final String ISCTRL_FROM_SUPER_COLLECTION_FORM = "isctrl_from_super_collection_form";
    public static final String ISCTRL = "isCtrl";
    public static final String ISFLEXCTRL = "isFlexCtrl";
    public static final String FLEXCTRLPARAM = "flexCtrlParam";
    public static final String PERIODCTRLPOLICY = "periodCtrlPolicy";
    public static final String ISGROUPCTRL = "isGroupCtrl";
    public static final String GROUPCTRLNO = "groupCtrlNo";

    public static Hashtable getTemplateCtrlModeFromBook(Book book) {
        Hashtable<String, Hashtable> ctrlModeMap = new Hashtable<String, Hashtable>();
        Sheet sheet = null;
        Cell cell = null;
        int sheetCount = book.getSheetCount();
        for (int k = 0; k < sheetCount; ++k) {
            sheet = book.getSheet(k);
            int maxRowIndex = sheet.getMaxRowIndex();
            for (int i = 0; i <= maxRowIndex; ++i) {
                int maxColIndex = sheet.getMaxColIndex();
                for (int j = 0; j <= maxColIndex; ++j) {
                    Hashtable map;
                    String key;
                    cell = sheet.getCell(i, j, false);
                    if (cell == null || !BgNFSHelper.checkHasFormulaOfCell((Cell)cell) || (key = BgNFSHelper.getFormulaOfCell((Cell)cell)) == null || key.equals("")) continue;
                    if (ctrlModeMap.containsKey(key)) {
                        map = (Hashtable)ctrlModeMap.get(key);
                        BgCtrlSetHelper.setCtrlMap(cell, map);
                        ctrlModeMap.put(key, map);
                        continue;
                    }
                    map = new Hashtable();
                    BgCtrlSetHelper.setCtrlMap(cell, map);
                    ctrlModeMap.put(key, map);
                }
            }
        }
        return ctrlModeMap;
    }

    public static void setCtrlMap(Cell cell, Hashtable map) {
        Boolean isCtrl = BgNTemplateHelper.getBgItemForumluaUserObject((Cell)cell, (String)ISCTRL) == null ? Boolean.FALSE : new Boolean(BgNTemplateHelper.getBgItemForumluaUserObject((Cell)cell, (String)ISCTRL).toString());
        Boolean isFlexCtrl = BgNTemplateHelper.getBgItemForumluaUserObject((Cell)cell, (String)ISFLEXCTRL) == null ? Boolean.FALSE : new Boolean(BgNTemplateHelper.getBgItemForumluaUserObject((Cell)cell, (String)ISFLEXCTRL).toString());
        BigDecimal flexCtrlParam = BgNTemplateHelper.getBgItemForumluaUserObject((Cell)cell, (String)FLEXCTRLPARAM) == null ? new BigDecimal("1") : new BigDecimal(BgNTemplateHelper.getBgItemForumluaUserObject((Cell)cell, (String)FLEXCTRLPARAM).toString());
        Integer periodCtrlPolicy = BgNTemplateHelper.getBgItemForumluaUserObject((Cell)cell, (String)PERIODCTRLPOLICY) == null ? new Integer(-1) : new Integer(BgNTemplateHelper.getBgItemForumluaUserObject((Cell)cell, (String)PERIODCTRLPOLICY).toString());
        Boolean isGroupCtrl = BgNTemplateHelper.getBgItemForumluaUserObject((Cell)cell, (String)ISGROUPCTRL) == null ? Boolean.FALSE : new Boolean(BgNTemplateHelper.getBgItemForumluaUserObject((Cell)cell, (String)ISGROUPCTRL).toString());
        Integer groupNo = BgNTemplateHelper.getBgItemForumluaUserObject((Cell)cell, (String)GROUPCTRLNO) == null ? new Integer(-1) : new Integer(BgNTemplateHelper.getBgItemForumluaUserObject((Cell)cell, (String)GROUPCTRLNO).toString());
        Boolean isctrl_from_super = BgNTemplateHelper.getBgItemForumluaUserObject((Cell)cell, (String)ISCTRL_FROM_SUPER_COLLECTION_FORM) == null ? Boolean.FALSE : new Boolean(BgNTemplateHelper.getBgItemForumluaUserObject((Cell)cell, (String)ISCTRL_FROM_SUPER_COLLECTION_FORM).toString());
        Boolean isAllowAccess = BgNTemplateHelper.getBgItemForumluaUserObject((Cell)cell, (String)"isAllowAccess") == null ? Boolean.FALSE : new Boolean(BgNTemplateHelper.getBgItemForumluaUserObject((Cell)cell, (String)"isAllowAccess").toString());
        map.put(ISCTRL, isCtrl);
        map.put(ISFLEXCTRL, isFlexCtrl);
        map.put(FLEXCTRLPARAM, flexCtrlParam);
        map.put(PERIODCTRLPOLICY, periodCtrlPolicy);
        map.put(ISGROUPCTRL, isGroupCtrl);
        map.put(GROUPCTRLNO, groupNo);
        map.put(ISCTRL_FROM_SUPER_COLLECTION_FORM, isctrl_from_super);
        map.put("isAllowAccess", isAllowAccess);
    }

    public static Hashtable getBgFormCtrlModeFromBook(Book book) {
        Hashtable<String, Boolean> ctrlModeMap = new Hashtable<String, Boolean>();
        Sheet sheet = null;
        Cell cell = null;
        boolean isCtrlAllowChange = false;
        int sheetCount = book.getSheetCount();
        for (int k = 0; k < sheetCount; ++k) {
            sheet = book.getSheet(k);
            int maxRowIndex = sheet.getMaxRowIndex();
            for (int i = 0; i <= maxRowIndex; ++i) {
                int maxColIndex = sheet.getMaxColIndex();
                for (int j = 0; j <= maxColIndex; ++j) {
                    String key;
                    cell = sheet.getCell(i, j, false);
                    if (cell == null || !BgNFSHelper.checkHasFormulaOfCell((Cell)cell) || (key = BgNFSHelper.getFormulaOfCell((Cell)cell)) == null || key.equals("")) continue;
                    isCtrlAllowChange = !BgNFSHelper.checkCanEditFormulaOfCell((Cell)cell) ? !"DATA_SOURCE_TEMPLATE".equals(BgNFSHelper.getRowSource((Row)sheet.getRow(i, false))) || !"DATA_SOURCE_TEMPLATE".equals(BgNFSHelper.getColSource((Column)sheet.getColumn(j, false))) : true;
                    ctrlModeMap.put(key, new Boolean(isCtrlAllowChange));
                }
            }
        }
        return ctrlModeMap;
    }

    public static Map fillPeriodAndCurrency(Map ctrlModeMap, String period, String currency, int bgFormPeriodType) throws BgFormException {
        if (ctrlModeMap == null || period == null || currency == null) {
            return null;
        }
        Hashtable<String, Map> filledMap = new Hashtable<String, Map>();
        String sFormula = null;
        Map value = null;
        String[] sParam = null;
        String tFormula = null;
        String p = null;
        String c = null;
        boolean replace = false;
        Iterator it = ctrlModeMap.keySet().iterator();
        while (it.hasNext()) {
            replace = false;
            sFormula = (String)it.next();
            value = (Map)ctrlModeMap.get(sFormula);
            value.put("isFromSuper", Boolean.TRUE);
            value.put("isCtrlAllowChange", Boolean.FALSE);
            sParam = BgNFSHelper.parseFormulaPara(null, (String)sFormula);
            p = sParam[1];
            p = BgPeriodNVariableHelper.getBgPeriodByN(period, p, bgFormPeriodType);
            replace = true;
            sParam[1] = p;
            c = sParam[5];
            if (com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)p)) {
                sParam[1] = period;
                replace = true;
            } else if (!com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)p)) {
                if (BgCtrlSetHelper.isInteger(p)) {
                    sParam[1] = BgNPeriodHelper.getOffsetBgPeriodNumber((String)period, (int)Integer.valueOf(p));
                    replace = true;
                } else if (BgPeriodNVariableHelper.checkCanConvert(p)) {
                    sParam[1] = p = BgPeriodNVariableHelper.getBgPeriodByN(period, p, bgFormPeriodType);
                    replace = true;
                }
            }
            if (com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)c)) {
                sParam[5] = currency;
                replace = true;
            }
            if (replace) {
                tFormula = BgNFSHelper.getFormulaFromParam((String[])sParam);
                filledMap.put(tFormula, value);
                continue;
            }
            filledMap.put(sFormula, value);
        }
        return filledMap;
    }

    public static boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static Map getCtrlModeMap4InsertTmpData(Context ctx, BOSUuid bgTemplateId, BOSUuid bgFormId, Map adjustMap) throws Exception {
        if (bgTemplateId == null || bgFormId == null || adjustMap == null) {
            return new HashMap();
        }
        HashMap returnMap = new HashMap();
        Map ctrlModeMap_BgData = null;
        Map ctrlModeMap_TmpData = null;
        Map itemAndElementCtrl = null;
        String itemAndElement = null;
        String formula2 = null;
        HashMap formulaMap = new HashMap();
        String[] parameter = null;
        IBgCtrSettingFacade ibgCtrSettingFacade = null;
        ibgCtrSettingFacade = ctx == null ? BgCtrSettingFacadeFactory.getRemoteInstance() : BgCtrSettingFacadeFactory.getLocalInstance(ctx);
        ctrlModeMap_BgData = ibgCtrSettingFacade.getBgFormCtrlModeMap(bgFormId);
        ctrlModeMap_TmpData = ibgCtrSettingFacade.getCtrlModeMapFromTmpData(bgFormId);
        itemAndElementCtrl = (Map)ibgCtrSettingFacade.getTemplateCtrlSetting(bgTemplateId, null).get("ctrlModeMap");
        for (String formula2 : adjustMap.keySet()) {
            if (ctrlModeMap_TmpData.containsKey(formula2)) {
                returnMap.put(formula2, ctrlModeMap_TmpData.get(formula2));
                continue;
            }
            if (ctrlModeMap_BgData.containsKey(formula2)) {
                returnMap.put(formula2, ctrlModeMap_BgData.get(formula2));
                continue;
            }
            parameter = BgNFSHelper.parseFormulaPara(formulaMap, (String)formula2);
            itemAndElement = parameter[0] + "_" + parameter[2];
            Hashtable<String, Object> map = new Hashtable<String, Object>();
            if (itemAndElementCtrl.containsKey(itemAndElement)) {
                Map tmpCtrl = (Map)itemAndElementCtrl.get(itemAndElement);
                map.put(ISCTRL, tmpCtrl.get(ISCTRL) == null ? Boolean.FALSE : tmpCtrl.get(ISCTRL));
                map.put(ISFLEXCTRL, tmpCtrl.get(ISFLEXCTRL) == null ? Boolean.FALSE : tmpCtrl.get(ISFLEXCTRL));
                map.put(FLEXCTRLPARAM, tmpCtrl.get(FLEXCTRLPARAM) == null ? new BigDecimal("1") : tmpCtrl.get(FLEXCTRLPARAM));
                map.put(PERIODCTRLPOLICY, tmpCtrl.get(PERIODCTRLPOLICY) == null ? new Integer(-1) : tmpCtrl.get(PERIODCTRLPOLICY));
                map.put(ISGROUPCTRL, tmpCtrl.get(ISGROUPCTRL) == null ? Boolean.FALSE : tmpCtrl.get(ISGROUPCTRL));
                map.put(GROUPCTRLNO, tmpCtrl.get(GROUPCTRLNO) == null ? "-1" : tmpCtrl.get(GROUPCTRLNO));
                map.put("isCtrlAllowChange", Boolean.FALSE);
                map.put("isFromSuper", Boolean.TRUE);
                map.put("isAllowAccess", Boolean.FALSE);
            } else {
                map.put(ISCTRL, new Boolean(false));
                map.put(ISFLEXCTRL, new Boolean(false));
                map.put(FLEXCTRLPARAM, new BigDecimal("1"));
                map.put(PERIODCTRLPOLICY, new Integer(-1));
                map.put(ISGROUPCTRL, new Boolean(false));
                map.put(GROUPCTRLNO, "-1");
                map.put("isCtrlAllowChange", new Boolean(true));
                map.put("isFromSuper", new Boolean(false));
                map.put("isAllowAccess", new Boolean(false));
            }
            returnMap.put(formula2, map);
        }
        return returnMap;
    }

    public static String getStrGroupNo(Object obj, String bgformId) {
        String value;
        if (obj instanceof Integer) {
            int value2 = (Integer)obj;
            if (value2 > 0) {
                return value2 + "_" + bgformId;
            }
            return "-1";
        }
        if (obj instanceof String && !com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)(value = (String)obj)) && value.indexOf("_") > -1) {
            return value.split("_")[0] + "_" + bgformId;
        }
        return "-1";
    }

    public static Integer getIntGroupNo(Object obj) {
        String value;
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof String && !com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)(value = (String)obj)) && value.indexOf("_") > -1) {
            value = value.split("_")[0];
            try {
                return new Integer(value);
            }
            catch (Exception e) {
                return new Integer(-1);
            }
        }
        return new Integer(-1);
    }

    public static Hashtable getNoCtrlMap(String formula) {
        Hashtable<String, Comparable<Boolean>> temp = new Hashtable<String, Comparable<Boolean>>();
        temp.put(ISCTRL, Boolean.FALSE);
        temp.put(ISFLEXCTRL, Boolean.FALSE);
        temp.put(FLEXCTRLPARAM, new BigDecimal("1"));
        temp.put(PERIODCTRLPOLICY, new Integer(-1));
        temp.put(ISGROUPCTRL, Boolean.FALSE);
        temp.put(GROUPCTRLNO, new Integer(-1));
        temp.put("isFromSuper", Boolean.FALSE);
        temp.put("isCtrlAllowChange", Boolean.TRUE);
        temp.put("isAllowAccess", Boolean.TRUE);
        temp.put("ctrlModeFrom", new Integer(-1));
        return temp;
    }

    public static boolean isCtrl(Map ctrlMap) {
        boolean isCtrl = false;
        if (ctrlMap != null && ctrlMap.get(ISCTRL) instanceof Boolean) {
            isCtrl = (Boolean)ctrlMap.get(ISCTRL);
        }
        return isCtrl;
    }

    public static void clearTemplateNoCtrlRecord(Context ctx, String templateId) throws BOSException {
        if (ctx == null || StringUtils.isEmpty((String)templateId)) {
            return;
        }
        String sql = "DELETE T_BG_BgTemplateCtrlSetting WHERE FIsControl = 0 AND FBgTemplateID =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{templateId});
    }

    public static void fillNoCtrlRecord(Book book, Map ctrlSetting) throws ParserException {
        if (book == null || ctrlSetting == null) {
            return;
        }
        List formulalList = BgNFSHelper.getFormulaListOfBook((Book)book);
        BgCtrlSetHelper.fillNoCtrlRecord(formulalList, ctrlSetting);
    }

    public static void fillNoCtrlRecordForView(Context ctx, BOSUuid bgTemplateId, Map ctrlSetting) throws Exception {
        if (ctrlSetting == null || bgTemplateId == null) {
            return;
        }
        List formulaList = BgViewCommonHelper.buildFormula((Context)ctx, (BOSUuid)bgTemplateId, (boolean)true);
        BgCtrlSetHelper.fillNoCtrlRecord(formulaList, ctrlSetting);
    }

    public static void fillNoCtrlRecord(List formulaList, Map ctrlSetting) throws ParserException {
        BgCtrlSetHelper.fillNoCtrlRecord(formulaList, ctrlSetting, true);
    }

    public static void fillNoCtrlRecord(List formulaList, Map ctrlSetting, boolean needAddNoCtrl) throws ParserException {
        Vector<String> itemAndElement;
        if (formulaList == null || formulaList.isEmpty() || ctrlSetting == null) {
            return;
        }
        Hashtable<String, Hashtable> ctrlModel = (Hashtable<String, Hashtable>)ctrlSetting.get("ctrlModeMap");
        if (ctrlModel == null) {
            ctrlModel = new Hashtable<String, Hashtable>();
            ctrlSetting.put("ctrlModeMap", ctrlModel);
        }
        if ((itemAndElement = (Vector<String>)ctrlSetting.get("itemAndElement")) == null) {
            itemAndElement = new Vector<String>();
            ctrlSetting.put("itemAndElement", itemAndElement);
        }
        boolean isFromSuper = false;
        if (!ctrlModel.isEmpty()) {
            Object value2 = null;
            Map subMap = null;
            for (Object value2 : ctrlModel.values()) {
                if (!(value2 instanceof Map) || !((subMap = (Map)value2).get("isFromSuper") instanceof Boolean) || !((Boolean)subMap.get("isFromSuper")).booleanValue()) continue;
                isFromSuper = true;
                break;
            }
        }
        String formulaStr = null;
        String itemCombinNumber = null;
        String elementNumber = null;
        String key = null;
        String[] params = null;
        List list = null;
        FormulaHint hint = null;
        Hashtable map = null;
        for (int i = 0; i < formulaList.size(); ++i) {
            Vector<String> formulaSet;
            formulaStr = (String)formulaList.get(i);
            if (com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)formulaStr) || (list = TableToolkit.parseFormula((String)formulaStr, (boolean)false)) == null || list.isEmpty()) continue;
            hint = (FormulaHint)list.get(0);
            params = hint.getParams();
            itemCombinNumber = params[0];
            elementNumber = params[2];
            key = itemCombinNumber + "_" + elementNumber;
            if (!itemAndElement.contains(key) && needAddNoCtrl) {
                itemAndElement.add(key);
            }
            if (ctrlModel.containsKey(key)) {
                map = (Hashtable)ctrlModel.get(key);
                formulaSet = (Vector<String>)map.get("FORMULA");
                if (formulaSet.contains(formulaStr)) continue;
                formulaSet.add(formulaStr);
                continue;
            }
            if (!needAddNoCtrl) continue;
            map = BgCtrlSetHelper.getNoCtrlMap(formulaStr);
            map.put("isFromSuper", new Boolean(isFromSuper));
            formulaSet = new Vector<String>();
            formulaSet.add(formulaStr);
            map.put("FORMULA", formulaSet);
            ctrlModel.put(key, map);
        }
    }

    public static void clearTemplateCtrlSetting(Connection conn, String orgUnitId, String templateId, boolean isNeedCloseConn) throws BOSException {
        if (conn == null || com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)orgUnitId) || com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)templateId)) {
            return;
        }
        String sql_deleteCtrl = "delete from T_BG_BgTemplateCtrlSetting where FOrgUnitId = ? and FBgTemplateID = ?";
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql_deleteCtrl);
            pstmt.setString(1, orgUnitId);
            pstmt.setString(2, templateId);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
            if (isNeedCloseConn) {
                SQLUtils.cleanup((Connection)conn);
            }
        }
    }
}

