/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget;

import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgExamineException;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class BgDBUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.dimension.util.DBUtils");
    public static int CANCEL = -1;
    public static int YES = 1;
    public static int NO = 0;
    public static final int batchSize = 50;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isMSSQL(Context ctx) {
        if (ctx == null) {
            return false;
        }
        boolean re = false;
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            re = BgDBUtils.isMSSQL(conn);
        }
        catch (SQLException ex) {
            logger.error((Object)"isMSSQL:", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return re;
    }

    public static boolean isMSSQL(Connection conn) {
        if (conn == null) {
            return false;
        }
        boolean re = false;
        DatabaseMetaData metaData = null;
        try {
            metaData = conn.getMetaData();
            String _name = metaData.getDatabaseProductName().toLowerCase();
            if (_name != null && (_name.indexOf("sql server") >= 0 || _name.indexOf("microsoft sql server") >= 0)) {
                re = true;
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"isMSSQL:", (Throwable)ex);
        }
        return re;
    }

    public static boolean isOracle(Connection conn) {
        if (conn == null) {
            return false;
        }
        boolean re = false;
        DatabaseMetaData metaData = null;
        try {
            metaData = conn.getMetaData();
            String _name = metaData.getDatabaseProductName().toLowerCase();
            if (_name != null && _name.indexOf("oracle") >= 0) {
                re = true;
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"isMSSQL:", (Throwable)ex);
        }
        return re;
    }

    public static boolean isDB2(Connection conn) {
        if (conn == null) {
            return false;
        }
        boolean re = false;
        DatabaseMetaData metaData = null;
        try {
            metaData = conn.getMetaData();
            String _name = metaData.getDatabaseProductName().toLowerCase();
            if (_name != null && _name.indexOf("db2") >= 0) {
                re = true;
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"isMSSQL:", (Throwable)ex);
        }
        return re;
    }

    public static boolean isPostgresql(Connection conn) {
        if (conn == null) {
            return false;
        }
        boolean re = false;
        DatabaseMetaData metaData = null;
        try {
            metaData = conn.getMetaData();
            String _name = metaData.getDatabaseProductName().toLowerCase();
            if (_name != null && _name.indexOf("postgresql") >= 0) {
                re = true;
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"isPostgresql:", (Throwable)ex);
        }
        return re;
    }

    public static Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int existTable(Context ctx, String tableName) {
        if (ctx == null || StringUtils.isEmpty((String)tableName)) {
            return CANCEL;
        }
        Connection conn = null;
        int re = NO;
        try {
            conn = BgDBUtils.getConnection(ctx);
            re = BgDBUtils.existTable(conn, tableName);
        }
        catch (SQLDataException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            re = CANCEL;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return re;
    }

    public static int existTable(Connection conn, String tableName) {
        if (conn == null || StringUtils.isEmpty((String)tableName)) {
            return CANCEL;
        }
        int re = NO;
        re = BgDBUtils.isPostgresql(conn) ? BgDBUtils.existTableByPostgreSql(conn, tableName) : BgDBUtils.existTableByKSql(conn, tableName);
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int existTableByDB(Connection conn, String tableName) {
        if (conn == null || StringUtils.isEmpty((String)tableName)) {
            return CANCEL;
        }
        ResultSet rst = null;
        Statement pstmt = null;
        int re = NO;
        String _tableName = tableName.toUpperCase();
        String[] filterTypes = new String[]{"TABLE"};
        try {
            String catalog = conn.getCatalog();
            String schemaPattern = null;
            if (BgDBUtils.isOracle(conn)) {
                schemaPattern = conn.getMetaData().getUserName().toUpperCase();
            }
            rst = conn.getMetaData().getTables(catalog, schemaPattern, _tableName, filterTypes);
            while (rst.next()) {
                if (!tableName.equalsIgnoreCase(rst.getString("TABLE_NAME"))) continue;
                re = YES;
                break;
            }
            SQLUtils.cleanup((ResultSet)rst, pstmt);
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            re = CANCEL;
        }
        finally {
            SQLUtils.cleanup(rst, pstmt);
        }
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int existTableByKSql(Connection conn, String tableName) {
        int re;
        PreparedStatement pstmt;
        ResultSet rst;
        block6: {
            if (conn == null || StringUtils.isEmpty((String)tableName)) {
                return CANCEL;
            }
            rst = null;
            pstmt = null;
            re = NO;
            String _tableName = tableName.toUpperCase();
            try {
                if (BgDBUtils.isPostgresql(conn)) {
                    re = BgDBUtils.existTableByPostgreSql(conn, tableName);
                    break block6;
                }
                pstmt = conn.prepareStatement("select * from KSQL_USERTABLES where KSQL_TABNAME = ?");
                pstmt.setString(1, _tableName);
                rst = pstmt.executeQuery();
                if (!rst.next()) break block6;
                re = YES;
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"sql error:", (Throwable)ex);
                    re = CANCEL;
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt);
                    throw throwable;
                }
                SQLUtils.cleanup(rst, (Statement)pstmt);
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt);
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int existTableByPostgreSql(Connection conn, String tableName) {
        int re;
        PreparedStatement pstmt;
        ResultSet rst;
        block5: {
            if (conn == null || StringUtils.isEmpty((String)tableName)) {
                return CANCEL;
            }
            rst = null;
            pstmt = null;
            re = NO;
            String _tableName = tableName.toLowerCase();
            try {
                pstmt = conn.prepareStatement("SELECT relname FROM pg_class WHERE relname = ?");
                pstmt.setString(1, _tableName);
                rst = pstmt.executeQuery();
                if (!rst.next()) break block5;
                re = YES;
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"sql error:", (Throwable)ex);
                    re = CANCEL;
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, (Statement)pstmt);
                    throw throwable;
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int existView(Context ctx, String viewName) {
        if (ctx == null || StringUtils.isEmpty((String)viewName)) {
            return CANCEL;
        }
        Connection conn = null;
        int re = NO;
        try {
            conn = BgDBUtils.getConnection(ctx);
            re = BgDBUtils.existView(conn, viewName);
        }
        catch (SQLDataException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            re = CANCEL;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int existView(Connection conn, String viewName) {
        if (conn == null || StringUtils.isEmpty((String)viewName)) {
            return CANCEL;
        }
        ResultSet rst = null;
        int re = NO;
        try {
            String[] filterTypes = new String[]{"VIEW"};
            String catalog = conn.getCatalog();
            String schemaPattern = null;
            if (BgDBUtils.isOracle(conn)) {
                schemaPattern = conn.getMetaData().getUserName().toUpperCase();
            }
            rst = conn.getMetaData().getTables(catalog, schemaPattern, viewName.toUpperCase(), filterTypes);
            while (rst.next()) {
                if (!viewName.equalsIgnoreCase(rst.getString("TABLE_NAME"))) continue;
                re = YES;
                break;
            }
            SQLUtils.cleanup((ResultSet)rst);
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            re = CANCEL;
        }
        finally {
            SQLUtils.cleanup(rst);
        }
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int existIndex(Context ctx, String tableName, String indexName) {
        if (ctx == null || StringUtils.isEmpty((String)tableName) || StringUtils.isEmpty((String)indexName)) {
            return CANCEL;
        }
        Connection conn = null;
        int re = CANCEL;
        try {
            conn = BgDBUtils.getConnection(ctx);
            re = BgDBUtils.existIndex(conn, tableName, indexName);
        }
        catch (SQLDataException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int existIndex(Connection conn, String tableName, String indexName) {
        int re;
        block9: {
            if (conn == null || StringUtils.isEmpty((String)tableName) || StringUtils.isEmpty((String)indexName)) {
                return CANCEL;
            }
            ResultSet rst = null;
            re = NO;
            String _indexName = indexName.toUpperCase();
            try {
                if (BgDBUtils.isPostgresql(conn)) {
                    re = BgDBUtils.existIndexByPostgreSql(conn, tableName, indexName);
                    break block9;
                }
                String catalog = conn.getCatalog();
                String schemaPattern = null;
                if (BgDBUtils.isOracle(conn)) {
                    schemaPattern = conn.getMetaData().getUserName().toUpperCase();
                }
                rst = conn.getMetaData().getIndexInfo(catalog, schemaPattern, tableName.toUpperCase(), false, false);
                while (rst.next()) {
                    if (!_indexName.equalsIgnoreCase(rst.getString("INDEX_NAME"))) continue;
                    re = YES;
                    break;
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"sql error:", (Throwable)ex);
                re = CANCEL;
            }
            finally {
                SQLUtils.cleanup(rst);
            }
        }
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int existIndexByPostgreSql(Connection conn, String tableName, String indexName) {
        if (conn == null || StringUtils.isEmpty((String)tableName) || StringUtils.isEmpty((String)indexName)) {
            return CANCEL;
        }
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int re = NO;
        String _tableName = tableName.toLowerCase();
        String _indexName = indexName.toLowerCase();
        try {
            pstmt = conn.prepareStatement("SELECT c.relname, c1.relname FROM pg_index i inner join pg_class c on i.indrelid = c.oid inner join pg_class c1 on i.indexrelid = c1.oid WHERE c.relname = ? and c1.relname = ?");
            pstmt.setString(1, _tableName);
            pstmt.setString(2, _indexName);
            rst = pstmt.executeQuery();
            if (rst.next()) {
                re = YES;
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            re = CANCEL;
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getColumns(Context ctx, String tableName) {
        if (ctx == null || StringUtils.isEmpty((String)tableName)) {
            return null;
        }
        ArrayList<String> columns = new ArrayList();
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection(ctx);
            columns = BgDBUtils.getColumns(conn, tableName);
        }
        catch (SQLDataException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return columns;
    }

    public static List<String> getColumns(Connection conn, String tableName) {
        if (conn == null || StringUtils.isEmpty((String)tableName)) {
            return null;
        }
        List<Object> columns = new ArrayList();
        columns = BgDBUtils.isPostgresql(conn) ? BgDBUtils.getColumnsByPostgreSql(conn, tableName) : BgDBUtils.getColumnsByKSql(conn, tableName);
        return columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getColumnsByKSql(Connection conn, String tableName) {
        if (conn == null || StringUtils.isEmpty((String)tableName)) {
            return null;
        }
        ArrayList<String> columns = new ArrayList<String>();
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String _tableName = tableName.toUpperCase();
        try {
            pstmt = conn.prepareStatement("select KSQL_COL_NAME from KSQL_USERCOLUMNS where KSQL_COL_TABNAME = ?");
            pstmt.setString(1, _tableName);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                columns.add(rst.getString(1));
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        return columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getColumnsByPostgreSql(Connection conn, String tableName) {
        ResultSet rst;
        PreparedStatement pstmt;
        HashSet<String> columnSet;
        block6: {
            if (conn == null || StringUtils.isEmpty((String)tableName)) {
                return null;
            }
            columnSet = new HashSet<String>();
            pstmt = null;
            rst = null;
            String _tableName = tableName.toLowerCase();
            try {
                if (BgDBUtils.isPostgresql(conn)) break block6;
                pstmt = conn.prepareStatement("select a.attname from pg_attribute a inner join pg_class c on a.attrelid = c.oid where c.relname = ? and a.attnum > 0");
                pstmt.setString(1, _tableName);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    columnSet.add(rst.getString(1).toUpperCase());
                }
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"sql error:", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt);
                    throw throwable;
                }
                SQLUtils.cleanup(rst, (Statement)pstmt);
            }
        }
        SQLUtils.cleanup(rst, pstmt);
        return new ArrayList<String>(columnSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int existColumn(Context ctx, String tableName, String columnName) {
        if (ctx == null || StringUtils.isEmpty((String)tableName) || StringUtils.isEmpty((String)columnName)) {
            return CANCEL;
        }
        Connection conn = null;
        int re = CANCEL;
        try {
            conn = BgDBUtils.getConnection(ctx);
            re = BgDBUtils.existColumnByKSql(conn, tableName, columnName);
        }
        catch (SQLDataException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return re;
    }

    public static int existColumn(Connection conn, String tableName, String columnName) {
        if (BgDBUtils.isPostgresql(conn)) {
            return BgDBUtils.existColumnByPostgreSql(conn, tableName, columnName);
        }
        return BgDBUtils.existColumnByKSql(conn, tableName, columnName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int existColumnByKSql(Connection conn, String tableName, String columnName) {
        if (conn == null || StringUtils.isEmpty((String)tableName) || StringUtils.isEmpty((String)columnName)) {
            return CANCEL;
        }
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int re = NO;
        String _tableName = tableName.toUpperCase();
        String _columnName = columnName.toUpperCase();
        try {
            pstmt = conn.prepareStatement("select KSQL_COL_NAME from KSQL_USERCOLUMNS where KSQL_COL_NAME = ? and KSQL_COL_TABNAME = ?");
            pstmt.setString(1, _columnName);
            pstmt.setString(2, _tableName);
            rst = pstmt.executeQuery();
            if (rst.next()) {
                re = YES;
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            re = CANCEL;
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int existColumnByPostgreSql(Connection conn, String tableName, String columnName) {
        if (conn == null || StringUtils.isEmpty((String)tableName) || StringUtils.isEmpty((String)columnName)) {
            return CANCEL;
        }
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int re = NO;
        String _tableName = tableName.toLowerCase();
        String _columnName = columnName.toLowerCase();
        try {
            pstmt = conn.prepareStatement("select a.attname from pg_attribute a inner join pg_class c on a.attrelid = c.oid where c.relname = ? and a.attname = ? and a.attnum > 0");
            pstmt.setString(1, _tableName);
            pstmt.setString(2, _columnName);
            rst = pstmt.executeQuery();
            if (rst.next()) {
                re = YES;
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            re = CANCEL;
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        return re;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int executeUpdate(Context ctx, String sql) throws SQLDataException, SQLException {
        if (ctx == null) return CANCEL;
        if (StringUtils.isEmpty((String)sql)) {
            return CANCEL;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        int re = NO;
        try {
            conn = BgDBUtils.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            re = pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"sql error:", (Throwable)ex);
                throw ex;
                catch (SQLDataException ex2) {
                    logger.error((Object)"sql error:", (Throwable)ex2);
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return re;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int executeUpdate(Context ctx, String sql, Object[] params) throws SQLDataException, SQLException {
        if (ctx == null) return CANCEL;
        if (StringUtils.isEmpty((String)sql)) return CANCEL;
        if (params == null) {
            return CANCEL;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        int re = CANCEL;
        try {
            conn = BgDBUtils.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            int in = params.length;
            for (int i = 0; i < in; ++i) {
                pstmt.setObject(i + 1, params[i]);
            }
            re = pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"sql error:", (Throwable)ex);
                throw ex;
                catch (SQLDataException ex2) {
                    logger.error((Object)"sql error:", (Throwable)ex2);
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return re;
    }

    public static int executeUpdate(Connection conn, String sql) throws SQLException {
        if (conn == null || StringUtils.isEmpty((String)sql)) {
            return CANCEL;
        }
        PreparedStatement pstmt = null;
        int re = CANCEL;
        try {
            pstmt = conn.prepareStatement(sql);
            re = pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
        return re;
    }

    public static int[] executeUpdate(Connection conn, String[] sqls) throws SQLException {
        if (conn == null || sqls == null) {
            return null;
        }
        PreparedStatement pstmt = null;
        int[] re = new int[sqls.length];
        try {
            for (int i = 0; i < sqls.length; ++i) {
                pstmt = conn.prepareStatement(sqls[i]);
                re[i] = pstmt.executeUpdate();
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw ex;
        }
        finally {
            SQLUtils.cleanup(pstmt);
        }
        return re;
    }

    public static int executeUpdate(Connection conn, String sql, List<Object> params) throws SQLException {
        if (conn == null || StringUtils.isEmpty((String)sql) || params == null) {
            return CANCEL;
        }
        PreparedStatement pstmt = null;
        int re = CANCEL;
        try {
            pstmt = conn.prepareStatement(sql);
            int in = params.size();
            for (int i = 0; i < in; ++i) {
                pstmt.setObject(i + 1, params.get(i));
            }
            re = pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
        return re;
    }

    public static int executeUpdate(Connection conn, String sql, Object[] params) throws SQLException {
        if (conn == null || StringUtils.isEmpty((String)sql) || params == null) {
            return CANCEL;
        }
        PreparedStatement pstmt = null;
        int re = CANCEL;
        try {
            pstmt = conn.prepareStatement(sql);
            int in = params.length;
            for (int i = 0; i < in; ++i) {
                pstmt.setObject(i + 1, params[i]);
            }
            re = pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
        return re;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void executeBatch(Context ctx, String sql, List<Object[]> params) throws SQLDataException, SQLException {
        if (ctx == null) return;
        if (StringUtils.isEmpty((String)sql)) return;
        if (params == null) return;
        if (params.isEmpty()) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        int batchIndex = 0;
        int batchNum = 100;
        Object[] objs = null;
        try {
            conn = BgDBUtils.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            int in = params.size();
            for (int i = 0; i < in; ++i, ++batchIndex) {
                objs = params.get(i);
                if (objs != null) {
                    for (int j = 0; j < objs.length; ++j) {
                        pstmt.setObject(j + 1, objs[j]);
                    }
                    pstmt.addBatch();
                }
                if (batchIndex < batchNum) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex > 0) {
                pstmt.executeBatch();
                batchIndex = 0;
            }
        }
        catch (SQLException ex) {
            try {
                throw ex;
                catch (SQLDataException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    public static void executeBatch(Connection conn, String sql, List<Object[]> params) throws SQLException {
        if (conn == null || StringUtils.isEmpty((String)sql) || params == null || params.isEmpty()) {
            return;
        }
        PreparedStatement pstmt = null;
        int batchIndex = 0;
        int batchNum = 100;
        Object[] objs = null;
        try {
            pstmt = conn.prepareStatement(sql);
            int i = 0;
            int in = params.size();
            while (i < in) {
                objs = params.get(i);
                if (objs != null) {
                    for (int j = 0; j < objs.length; ++j) {
                        pstmt.setObject(j + 1, objs[j]);
                    }
                    pstmt.addBatch();
                }
                if (batchIndex >= batchNum) {
                    pstmt.executeBatch();
                    batchIndex = 0;
                }
                ++i;
                ++batchIndex;
            }
            if (batchIndex > 0) {
                pstmt.executeBatch();
                batchIndex = 0;
            }
        }
        catch (SQLException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    public static IRowSet executeQuery(Context ctx, String sql) throws SQLException {
        JdbcRowSet rowset = new JdbcRowSet();
        if (ctx == null || sql == null) {
            return rowset;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            rowset.populate(rs);
        }
        catch (SQLException exc) {
            try {
                logger.error((Object)("Sql execute exception : " + sql), (Throwable)exc);
                throw exc;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return rowset;
    }

    public static IRowSet executeQuery(Context ctx, String sql, Object[] params) throws SQLException {
        JdbcRowSet rowset = new JdbcRowSet();
        if (ctx == null || sql == null) {
            return rowset;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql);
            if (params != null) {
                int in = params.length;
                for (int i = 0; i < in; ++i) {
                    pstmt.setObject(i + 1, params[i]);
                }
            }
            rs = pstmt.executeQuery();
            rowset.populate(rs);
        }
        catch (SQLException exc) {
            try {
                logger.error((Object)"sql error:", (Throwable)exc);
                throw exc;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return rowset;
    }

    public static IRowSet executeQuery(Connection conn, String sql) throws SQLException {
        JdbcRowSet rowset = new JdbcRowSet();
        if (conn == null || sql == null) {
            return rowset;
        }
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = conn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            rowset.populate(rs);
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"sql error:", (Throwable)ex);
                throw ex;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
        return rowset;
    }

    public static IRowSet executeQuery(Connection conn, String sql, Object[] params) throws SQLException {
        JdbcRowSet rowset = new JdbcRowSet();
        if (conn == null || StringUtils.isEmpty((String)sql)) {
            return rowset;
        }
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            pstmt = conn.prepareStatement(sql);
            if (params != null) {
                int in = params.length;
                for (int i = 0; i < in; ++i) {
                    pstmt.setObject(i + 1, params[i]);
                }
            }
            rst = pstmt.executeQuery();
            rowset.populate(rst);
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"sql error:", (Throwable)ex);
                throw ex;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return rowset;
    }

    public static IRowSet executeQuery(Connection conn, String sql, List<Object> params) throws SQLException {
        JdbcRowSet rowset = new JdbcRowSet();
        if (conn == null || StringUtils.isEmpty((String)sql)) {
            return rowset;
        }
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            pstmt = conn.prepareStatement(sql);
            if (params != null) {
                int in = params.size();
                for (int i = 0; i < in; ++i) {
                    pstmt.setObject(i + 1, params.get(i));
                }
            }
            rst = pstmt.executeQuery();
            rowset.populate(rst);
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
        return rowset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Object[]> executeBatchQuery(Connection conn, String sql, List<Object> params, int resultSize) throws SQLException {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        if (conn == null || StringUtils.isEmpty((String)sql) || params == null) {
            return result;
        }
        int size = params.size();
        int count = (size - 1) / 50 + 1;
        int pos = 0;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Object[] objs = null;
        try {
            pstmt = conn.prepareStatement(sql);
            for (int index = 0; index < count; ++index) {
                int x = 1;
                while (x <= 50) {
                    if (pos < size) {
                        pstmt.setObject(x, params.get(pos));
                    } else {
                        pstmt.setObject(x, "#");
                    }
                    ++x;
                    ++pos;
                }
                try {
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        objs = new Object[resultSize];
                        for (int i = 0; i < resultSize; ++i) {
                            objs[i] = rst.getObject(i + 1);
                        }
                        result.add(objs);
                    }
                    continue;
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst);
                }
            }
        }
        catch (SQLException exc) {
            logger.error((Object)"sql error:", (Throwable)exc);
            throw exc;
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int dropTable(Context ctx, String tableName) {
        if (ctx == null || StringUtils.isEmpty((String)tableName)) {
            return CANCEL;
        }
        Connection conn = null;
        int re = 0;
        try {
            conn = BgDBUtils.getConnection(ctx);
            re = BgDBUtils.dropTable(conn, tableName);
        }
        catch (SQLDataException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int dropTable(Connection conn, String tableName) {
        if (conn == null || StringUtils.isEmpty((String)tableName)) {
            return CANCEL;
        }
        PreparedStatement pstmt = null;
        int re = CANCEL;
        try {
            pstmt = conn.prepareStatement("Drop Table " + tableName);
            re = pstmt.executeUpdate();
            SQLUtils.cleanup((Statement)pstmt);
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(pstmt);
        }
        return re;
    }

    public static String createTmpTable(TempTablePool pool, String tableSql) throws EASBizException {
        if (pool == null || tableSql == null) {
            throw new BgExamineException(BgExamineException.TMPTABLENAMECANTISNULL);
        }
        String tableName = null;
        try {
            tableName = pool.createTempTable(tableSql);
        }
        catch (Exception ex) {
            logger.error((Object)"createTmpTable Error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        return tableName;
    }

    public static String createDBTmpTable(TempTablePool pool, Connection conn, String tableSql) throws EASBizException {
        if (pool == null || conn == null || tableSql == null) {
            throw new BgExamineException(BgExamineException.TMPTABLENAMECANTISNULL);
        }
        String tableName = null;
        try {
            tableName = pool.createDBSystemTempTable(tableSql, conn);
        }
        catch (Exception ex) {
            logger.error((Object)"createDBTmpTable Error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        return tableName;
    }

    public static String createDBTmpIndex(TempTablePool pool, Connection conn, String tableName, String columns, boolean isUnique, boolean isClustered) throws EASBizException {
        if (pool == null || conn == null || StringUtils.isEmpty((String)tableName) || StringUtils.isEmpty((String)columns)) {
            throw new BgExamineException(BgExamineException.TMPTABLENAMECANTISNULL);
        }
        String indexName = null;
        try {
            indexName = pool.createDBSystemTempTableIndex(tableName, columns, isUnique, isClustered, conn);
        }
        catch (Exception ex) {
            logger.error((Object)"createDBTmpTable Error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        return indexName;
    }

    public static String createIndex(TempTablePool pool, String tableName, String columns, boolean isUnique, boolean isClustered) throws Exception {
        return pool.createIndex(tableName, columns, isUnique, isClustered);
    }

    public static void releaseTmpTable(TempTablePool pool, String tableName) throws EASBizException {
        if (pool == null || tableName == null) {
            throw new BgExamineException(BgExamineException.TMPTABLENAMECANTISNULL);
        }
        pool.releaseTable(tableName);
    }

    public static void releaseTmpTable(TempTablePool pool, List<String> tableName) throws EASBizException {
        if (pool == null || tableName == null) {
            throw new BgExamineException(BgExamineException.TMPTABLENAMECANTISNULL);
        }
        int in = tableName.size();
        for (int i = 0; i < in; ++i) {
            pool.releaseTable(tableName.get(i));
        }
    }

    public static void releaseTmpTable(TempTablePool pool, Collection<String> tableName) throws EASBizException {
        if (pool == null || tableName == null) {
            throw new BgExamineException(BgExamineException.TMPTABLENAMECANTISNULL);
        }
        for (String tmpTableName : tableName) {
            pool.releaseTable(tmpTableName);
        }
    }

    public static void releaseDBTmpTable(TempTablePool pool, Connection conn, String tableName) throws Exception {
        if (pool == null || conn == null || tableName == null) {
            throw new BgExamineException(BgExamineException.TMPTABLENAMECANTISNULL);
        }
        pool.releaseDBSystemTempTable(tableName, conn);
    }

    public static void releaseDBTmpTable(TempTablePool pool, Connection conn, List<String> tableName) throws Exception {
        if (pool == null || conn == null || tableName == null) {
            throw new BgExamineException(BgExamineException.TMPTABLENAMECANTISNULL);
        }
        int in = tableName.size();
        for (int i = 0; i < in; ++i) {
            pool.releaseDBSystemTempTable(tableName.get(i), conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int insertValue(Connection conn, String sql, List<List<Object>> sqlParams) throws SQLException {
        if (conn == null || StringUtils.isEmpty((String)sql) || sqlParams == null || sqlParams.isEmpty()) {
            return CANCEL;
        }
        int batchSize = 50;
        int batchIndex = 0;
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
            for (List<Object> sqlData : sqlParams) {
                int in = sqlData.size();
                for (int i = 0; i < in; ++i) {
                    pstmt.setObject(i + 1, sqlData.get(i));
                }
                pstmt.addBatch();
                if (++batchIndex < batchSize) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex > 0) {
                pstmt.executeBatch();
            }
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
        return YES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int insertKey(Connection conn, String sql, Collection<String> sqlParams) throws SQLException {
        if (conn == null || StringUtils.isEmpty((String)sql) || sqlParams == null || sqlParams.isEmpty()) {
            return CANCEL;
        }
        int batchSize = 50;
        int batchIndex = 0;
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
            for (String sqlData : sqlParams) {
                pstmt.setString(1, sqlData);
                pstmt.addBatch();
                if (++batchIndex < batchSize) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex > 0) {
                pstmt.executeBatch();
            }
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
        return YES;
    }

    public static void regorgTable(Connection conn, String cubeName) throws SQLException {
        if (BgDBUtils.isDB2(conn)) {
            String userName = conn.getMetaData().getUserName();
            CallableStatement c = conn.prepareCall("{CALL SYSPROC.ADMIN_CMD('reorg  table " + userName + "." + cubeName + "')}");
            c.execute();
        }
    }
}

