/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.ma.budget.BgDecomposerFormInfo;
import com.kingdee.eas.ma.budget.BgDecomposerStateEnum;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.RefBgDecFormInfo;
import com.kingdee.eas.ma.nbudget.BgInfoHelper;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class BgDecHelper {
    public static BgDecomposerFormInfo getBgDecInfo(Context ctx, Connection conn, BOSUuid bgDecFormId) throws Exception {
        ResultSet rst;
        PreparedStatement pstmt;
        BgDecomposerFormInfo bgDecFormInfo;
        block9: {
            if (conn == null || bgDecFormId == null) {
                return null;
            }
            byte[] bytes = null;
            bgDecFormInfo = null;
            pstmt = null;
            rst = null;
            StringBuffer sql = new StringBuffer();
            sql.append("select FID, FNumber, FName_" + ctx.getLocale() + ", FKdtData, FAdjustMapData, FState, FOrgUnitID,  FBgFormID from T_BG_BgDecomposerForm where FID = ?");
            try {
                pstmt = conn.prepareStatement(sql.toString());
                pstmt.setString(1, bgDecFormId.toString());
                rst = pstmt.executeQuery();
                if (!rst.next()) break block9;
                bgDecFormInfo = new BgDecomposerFormInfo();
                bgDecFormInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                bgDecFormInfo.setNumber(rst.getString("FNumber"));
                bgDecFormInfo.setName(rst.getString("FName_" + ctx.getLocale()));
                bgDecFormInfo.setState(BgDecomposerStateEnum.getEnum(rst.getInt("FState")));
                bytes = BgInfoHelper.getBytes((ResultSet)rst, (String)"FKdtData");
                if (bytes != null && bytes.length > 0) {
                    bgDecFormInfo.setKdtData(bytes);
                }
                if ((bytes = BgInfoHelper.getBytes((ResultSet)rst, (String)"FAdjustMapData")) != null && bytes.length > 0) {
                    bgDecFormInfo.setAdjustMapData(bytes);
                }
                if (rst.getString("FOrgUnitID") != null) {
                    bgDecFormInfo.setOrgUnit(new FullOrgUnitInfo());
                    bgDecFormInfo.getOrgUnit().setId(BOSUuid.read((String)rst.getString("FOrgUnitID")));
                }
                if (rst.getString("FBgFormID") != null) {
                    bgDecFormInfo.setBgForm(new BgFormInfo());
                    bgDecFormInfo.getBgForm().setId(BOSUuid.read((String)rst.getString("FBgFormID")));
                }
            }
            catch (SQLException ex) {
                try {
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, (Statement)pstmt);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return bgDecFormInfo;
    }

    public static RefBgDecFormInfo getRefBgDecFormInfo(Context ctx, Connection conn, BOSUuid refBgDecFormId) throws Exception {
        ResultSet rst;
        PreparedStatement pstmt;
        RefBgDecFormInfo refBgDecFormInfo;
        block8: {
            if (conn == null || refBgDecFormId == null) {
                return null;
            }
            byte[] bytes = null;
            refBgDecFormInfo = null;
            pstmt = null;
            rst = null;
            StringBuffer sql = new StringBuffer();
            sql.append("select FID, FKdtData, FAdjustMapData, FBgFormID from T_BG_RefBgDecForm where FID = ?");
            try {
                pstmt = conn.prepareStatement(sql.toString());
                pstmt.setString(1, refBgDecFormId.toString());
                rst = pstmt.executeQuery();
                if (!rst.next()) break block8;
                refBgDecFormInfo = new RefBgDecFormInfo();
                refBgDecFormInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                bytes = BgInfoHelper.getBytes((ResultSet)rst, (String)"FKdtData");
                if (bytes != null && bytes.length > 0) {
                    refBgDecFormInfo.setKdtData(bytes);
                }
                if ((bytes = BgInfoHelper.getBytes((ResultSet)rst, (String)"FAdjustMapData")) != null && bytes.length > 0) {
                    refBgDecFormInfo.setAdjustMapData(bytes);
                }
                if (rst.getString("FBgFormID") != null) {
                    refBgDecFormInfo.setBgForm(new BgFormInfo());
                    refBgDecFormInfo.getBgForm().setId(BOSUuid.read((String)rst.getString("FBgFormID")));
                }
            }
            catch (SQLException ex) {
                try {
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, (Statement)pstmt);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return refBgDecFormInfo;
    }
}

