/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.kdf.util.file.KDFException;
import com.kingdee.bos.ctrl.kdf.util.file.ZipKDF;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.ma.budget.AbstractBgDecomposerFormInfo;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.RefBgDecFormInfo;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;

public class BgDecomposerFormInfo
extends AbstractBgDecomposerFormInfo
implements Serializable {
    private transient HashMap adjustMap = null;

    public BgDecomposerFormInfo() {
    }

    protected BgDecomposerFormInfo(String pkField) {
        super(pkField);
    }

    public void setKDF(KDF kdf) throws IOException {
        super.setKdtData(ZipKDF.pack((KDF)kdf));
    }

    public KDF getKDF() throws IOException, KDFException {
        return ZipKDF.unpack((byte[])super.getKdtData());
    }

    public HashMap getAdjustMap() throws IOException, ClassNotFoundException {
        if (this.adjustMap == null) {
            this.adjustMap = BgHelper.buildHashMapByByte(this.getAdjustMapData());
        }
        return this.adjustMap;
    }

    public void saveAdjustMap() throws IOException {
        if (this.adjustMap != null) {
            super.setAdjustMapData(BgHelper.storeHashMapToByte(this.adjustMap));
        }
    }

    public HashMap getAdjustMapByBgFormId(String bgFormId) throws IOException, ClassNotFoundException {
        if (this.getBgForm().getId().toString().equals(bgFormId)) {
            return this.getAdjustMap();
        }
        return this.getRefBgDecFormInfo(bgFormId).getAdjustMap();
    }

    public RefBgDecFormInfo getRefBgDecFormInfo(String bgFormId) {
        if (this.getBgForm().getId().toString().equals(bgFormId)) {
            return null;
        }
        Iterator iter = this.getRefBgDecForms().iterator();
        while (iter.hasNext()) {
            RefBgDecFormInfo refDecForm = (RefBgDecFormInfo)iter.next();
            if (!refDecForm.getBgForm().getId().toString().equals(bgFormId)) continue;
            return refDecForm;
        }
        return null;
    }

    public String getLogInfo() {
        return this.getBgForm().getNumber() + " - " + this.getBgForm().getName();
    }

    public Book getBook() throws Exception {
        return IOHelper.unpackBook((byte[])super.getKdtData());
    }

    public void setBook(Book book) throws IOException {
        super.setKdtData(IOHelper.packBook((Book)book));
    }
}

