/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.util.db.SQLUtils;
import java.awt.Component;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public final class BgElimHelper {
    public static final int ABIN = 10;
    public static final int BAOUT = 20;
    public static final int ABOUT = 30;
    public static final int BAIN = 40;
    public static final int ABOTHER = 50;
    public static final int BAOTHER = 60;

    public static String convertToSqlParam(List list) {
        if (list.size() == 0) {
            return null;
        }
        StringBuffer paramBuffer = new StringBuffer();
        String paramString = null;
        for (int i = 0; i < list.size(); ++i) {
            paramBuffer.append("'").append((String)list.get(i)).append("',");
        }
        paramString = paramBuffer.substring(0, paramBuffer.lastIndexOf(","));
        paramString = "(" + paramString + ")";
        return paramString;
    }

    private static Connection getConnection(Context ctx) throws SQLException {
        return EJBFactory.getConnection((Context)ctx);
    }

    public static void executeBatch(Context ctx, List sqls) throws BOSException {
        Connection conn = null;
        Statement stmt = null;
        StringBuffer src = new StringBuffer();
        try {
            conn = BgElimHelper.getConnection(ctx);
            stmt = conn.createStatement();
            for (String sql : sqls) {
                stmt.addBatch(sql);
                src.append(sql + ";\n");
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException("Sql1 execute exception : " + src.toString(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    public static void executeBatch(Context ctx, String paramSql, List params) throws BOSException {
        Connection conn = null;
        PreparedStatement stmt = null;
        StringBuffer src = new StringBuffer();
        src.append(paramSql + ";\n");
        try {
            conn = BgElimHelper.getConnection(ctx);
            stmt = conn.prepareStatement(paramSql);
            for (Object[] row : params) {
                src.append("[");
                for (int i = 0; i < row.length; ++i) {
                    stmt.setObject(i + 1, row[i]);
                    src.append(row[i] + ",");
                }
                stmt.addBatch();
                src.append("]\n");
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException("Sql execute exception : " + src.toString(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    public static void batchApplyMutexService(Component ui, String[] ids, String userName) {
    }

    public static void batchReleaseMutexService(String[] ids) {
        if (ids == null || ids.length <= 0) {
            return;
        }
        ArrayList<String> idList = new ArrayList<String>();
        int length = ids.length;
        for (int i = 0; i < length; ++i) {
            idList.add(ids[i]);
        }
        IMutexServiceControl iMC = MutexServiceControlFactory.getRemoteInstance();
        iMC.batchReleaseObjIDForUpdate(idList);
    }

    public static final void replaceFilterItems(FilterInfo filter, FilterItemInfo item) {
        if (filter == null || item == null) {
            return;
        }
        boolean isReplace = false;
        if (filter.getFilterItems() != null) {
            FilterItemInfo fiInfo = null;
            FilterItemCollection fiCol = filter.getFilterItems();
            int n = fiCol.size();
            for (int i = 0; i < n; ++i) {
                fiInfo = fiCol.get(i);
                if (!fiInfo.getPropertyName().trim().equals(item.getPropertyName().trim())) continue;
                fiInfo.setCompareType(item.getCompareType());
                fiInfo.setCompareValue(item.getCompareValue());
                isReplace = true;
            }
            if (!isReplace) {
                fiCol.add(item);
                int itemsSize = fiCol.size();
                if (itemsSize <= 1) {
                    filter.setMaskString("(#0)");
                } else {
                    filter.setMaskString(filter.getMaskString() + " and (#" + String.valueOf(itemsSize - 1) + ")");
                }
            }
        }
    }
}

