/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.rpt.RptCell;
import com.kingdee.eas.fi.rpt.client.RptSheet;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgFSHelper;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.client.BgFormProcessUI;
import com.kingdee.eas.ma.budget.client.BgProcessUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class BgFCHelper {
    public static final String IS_COLLECT = "IS_COLLECT";
    public static final String IS_COLLECT_CELL_VALUE = "IS_COLLECT_CELL_VALUE";
    public static final String IS_COLLECT_ENUMERATE = "IS_COLLECT_ENUMERATE";
    public static final String IS_COLLECT_REPEAT = "IS_COLLECT_REPEAT";
    public static final String IS_COLLECT_FODIAN = "IS_COLLECT_FODIAN";
    public static final String IS_COLLECT_ADJUST = "IS_COLLECT_ADJUST";
    public static final String COLLECT_FORM_ID = "COLLECT_FORM_ID";
    public static final String COLLECT_FORMULA = "COLLECT_FORMULA";
    public static final String COLLECT_ORGUNIT = "COLLECT_ORGUNIT";
    public static final String COLLECT_SCHEME = "COLLECT_SCHEME";
    public static final String COLLECT_BGFORM = "COLLECT_BGFORM";
    public static final String COLLECT_DATA_TYPE = "COLLECT_DATA_TYPE";
    public static final String COLLECT_MEASUREUNIT = "COLLECT_MEASUREUNIT";
    private static final String routineStr = EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"89_BgFCHelper");
    private static final String findStr = "0";

    public static boolean isNumericalOfCell(ICell cell) {
        String numberFormat;
        if (cell == null) {
            return false;
        }
        return cell.getStyleAttributes() != null && cell.getStyleAttributes().getNumberFormat() != null && ((numberFormat = cell.getStyleAttributes().getNumberFormat()).equals("") || numberFormat.equals(routineStr) || numberFormat.indexOf(findStr) >= 0);
    }

    public static int getDigitOfNumber(ICell cell, BigDecimal value, int digit) {
        if (cell == null || cell.getStyleAttributes().getNumberFormat() == null) {
            return digit;
        }
        String numberFormat = cell.getStyleAttributes().getNumberFormat();
        if (numberFormat.indexOf(findStr) >= 0) {
            String tmpString = null;
            if (numberFormat.trim().indexOf(";-") >= 0) {
                Pattern p = Pattern.compile(";-");
                String[] str = p.split(numberFormat.trim());
                if (value == null || value.compareTo(BgConstants.BIGZERO) >= 0) {
                    tmpString = str[0];
                    if (tmpString != null && tmpString.indexOf(".") >= 0) {
                        Pattern p1 = Pattern.compile("\\.");
                        String[] str1 = p1.split(tmpString);
                        if (str1[1] != null && str1[1].length() > 0) {
                            digit = str1[1].length();
                        }
                    } else {
                        digit = 0;
                    }
                } else {
                    tmpString = str[1];
                    if (tmpString != null && tmpString.indexOf(".") >= 0) {
                        Pattern p1 = Pattern.compile("\\.");
                        String[] str1 = p1.split(tmpString);
                        if (str1[1] != null && str1[1].length() > 0) {
                            digit = str1[1].length();
                        }
                    } else {
                        digit = 0;
                    }
                }
            } else if (numberFormat != null && numberFormat.indexOf(".") >= 0) {
                Pattern p = Pattern.compile("\\.");
                String[] str = p.split(numberFormat);
                if (str[1] != null && str[1].length() > 0) {
                    digit = 0;
                    int n = str[1].length();
                    for (int i = 0; i < n; ++i) {
                        tmpString = str[1].substring(i, i + 1);
                        if (!tmpString.equals(findStr)) continue;
                        ++digit;
                    }
                } else {
                    digit = 0;
                }
            } else {
                digit = 0;
            }
        }
        return digit;
    }

    public static void replaceFilterItems(FilterInfo filter, FilterItemInfo item) {
        if (filter == null || item == null) {
            return;
        }
        boolean isReplace = false;
        if (filter.getFilterItems() != null) {
            FilterItemInfo fiInfo = null;
            FilterItemCollection fiCol = filter.getFilterItems();
            int n = fiCol.size();
            for (int i = 0; i < n; ++i) {
                fiInfo = fiCol.get(i);
                if (!fiInfo.getPropertyName().trim().equals(item.getPropertyName().trim())) continue;
                fiInfo.setCompareType(item.getCompareType());
                fiInfo.setCompareValue(item.getCompareValue());
                isReplace = true;
            }
            if (!isReplace) {
                fiCol.add(item);
            }
        }
    }

    public static void removeFilterItems(FilterInfo filter, FilterItemInfo item) {
        if (filter == null || item == null) {
            return;
        }
        boolean isRemove = false;
        FilterItemInfo tmpItem = null;
        if (filter.getFilterItems() != null) {
            FilterItemInfo fiInfo = null;
            FilterItemCollection fiCol = filter.getFilterItems();
            int n = fiCol.size();
            for (int i = 0; i < n; ++i) {
                fiInfo = fiCol.get(i);
                if (!fiInfo.getPropertyName().trim().equals(item.getPropertyName().trim())) continue;
                isRemove = true;
                tmpItem = fiInfo;
            }
            if (isRemove) {
                fiCol.remove(tmpItem);
            }
        }
    }

    public static void showCollectInfo(List sheets, BgFormInfo tmpInfo, Map formulaMap, BgProcessUI ui) throws Exception {
        if (sheets.isEmpty() || tmpInfo == null || tmpInfo.getZipData() == null || ui == null || !(ui instanceof BgProcessUI)) {
            return;
        }
        KDF kdf = null;
        RptSheet sheet = null;
        KDTable table = null;
        KDTable collTable = null;
        IRow row = null;
        IRow collRow = null;
        IColumn column = null;
        IColumn collColumn = null;
        ICell cell = null;
        ICell collCell = null;
        BOSUuid uuid = null;
        BOSUuid rowId = null;
        BOSUuid colId = null;
        int rowIndex = 0;
        int rowCount = 0;
        int colIndex = 0;
        int colCount = 0;
        int rowTmpIndex = 0;
        int colTmpIndex = 0;
        int rowSize = 0;
        int colSize = 0;
        int maxRowIndex = 0;
        int maxColIndex = 0;
        Map aliasMap = null;
        Map tmpMap = null;
        HashMap<Integer, BOSUuid> rowMap = new HashMap<Integer, BOSUuid>();
        HashMap<Integer, BOSUuid> colMap = new HashMap<Integer, BOSUuid>();
        HashMap<BOSUuid, Integer> rowIdMap = new HashMap<BOSUuid, Integer>();
        HashMap<BOSUuid, Integer> colIdMap = new HashMap<BOSUuid, Integer>();
        kdf = tmpInfo.getKDF();
        ui.setProcess(false);
        int count = sheets.size();
        for (int index = 0; index < count; ++index) {
            sheet = (RptSheet)sheets.get(index);
            table = sheet.getTable();
            collTable = (KDTable)kdf.getTableByID(table.getID());
            table.setRefresh(false);
            BgFSHelper.removeCollRowsAndCols(table);
            rowCount = collTable.getExpandedRowCount();
            colCount = collTable.getExpandedColumnCount();
            for (rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                collRow = collTable.getRow(rowIndex);
                if (collRow == null || collRow.getUserObject() == null || !(collRow.getUserObject() instanceof HashMap) || !(aliasMap = (Map)collRow.getUserObject()).containsKey("SIGN_DATA_ID")) continue;
                uuid = (BOSUuid)aliasMap.get("SIGN_DATA_ID");
                rowMap.put(new Integer(rowIndex), uuid);
                rowIdMap.put(uuid, new Integer(rowIndex));
                maxRowIndex = rowIndex;
            }
            for (colIndex = 0; colIndex < colCount; ++colIndex) {
                collColumn = collTable.getColumn(colIndex);
                if (collColumn == null || collColumn.getUserObject() == null || !(collColumn.getUserObject() instanceof HashMap) || !(aliasMap = (Map)collColumn.getUserObject()).containsKey("SIGN_DATA_ID")) continue;
                uuid = (BOSUuid)aliasMap.get("SIGN_DATA_ID");
                colMap.put(new Integer(colIndex), uuid);
                colIdMap.put(uuid, new Integer(colIndex));
                maxColIndex = colIndex;
            }
            rowCount = table.getExpandedRowCount();
            for (rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                row = table.getRow(rowIndex);
                if (row == null || row.getUserObject() == null || !(row.getUserObject() instanceof HashMap) || !(aliasMap = (Map)row.getUserObject()).containsKey("SIGN_DATA_ID") || !rowIdMap.containsKey(uuid = (BOSUuid)aliasMap.get("SIGN_DATA_ID")) || (rowTmpIndex = ((Integer)rowIdMap.get(uuid)).intValue()) == rowIndex) continue;
                rowSize = BgFCHelper.abs(rowTmpIndex, rowIndex);
                int in = rowSize;
                for (int i = 0; i < in; ++i) {
                    table.addRow(rowIndex);
                    ++rowIndex;
                    ++rowCount;
                }
            }
            rowCount = table.getExpandedRowCount();
            for (rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                row = table.getRow(rowIndex);
                if (!rowMap.containsKey(new Integer(rowIndex))) continue;
                uuid = (BOSUuid)rowMap.get(new Integer(rowIndex));
                if (row.getUserObject() == null || !(row.getUserObject() instanceof HashMap) || !(aliasMap = (Map)row.getUserObject()).containsKey("SIGN_DATA_ID") || (rowId = (BOSUuid)aliasMap.get("SIGN_DATA_ID")).equals((Object)uuid)) continue;
                MsgBox.showWarning((Component)ui, (String)"row Alias is error!");
                SysUtil.abort();
            }
            if (rowCount <= maxRowIndex) {
                for (rowIndex = rowCount; rowIndex <= maxRowIndex; ++rowIndex) {
                    row = table.addRow(rowIndex);
                    if (!rowMap.containsKey(new Integer(rowIndex))) continue;
                    uuid = (BOSUuid)rowMap.get(new Integer(rowIndex));
                    if (row.getUserObject() == null || !(row.getUserObject() instanceof HashMap) || !(aliasMap = (Map)row.getUserObject()).containsKey("SIGN_DATA_ID") || (rowId = (BOSUuid)aliasMap.get("SIGN_DATA_ID")).equals((Object)uuid)) continue;
                    MsgBox.showWarning((Component)ui, (String)"row Alias is error!");
                    SysUtil.abort();
                }
            }
            colCount = table.getExpandedColumnCount();
            for (colIndex = 0; colIndex < colCount; ++colIndex) {
                column = table.getColumn(colIndex);
                if (column == null || column.getUserObject() == null || !(column.getUserObject() instanceof HashMap) || !(aliasMap = (Map)column.getUserObject()).containsKey("SIGN_DATA_ID") || !colIdMap.containsKey(uuid = (BOSUuid)aliasMap.get("SIGN_DATA_ID")) || (colTmpIndex = ((Integer)colIdMap.get(uuid)).intValue()) == colIndex) continue;
                colSize = BgFCHelper.abs(colTmpIndex, colIndex);
                int jn = colSize;
                for (int j = 0; j < jn; ++j) {
                    table.addColumn(colIndex);
                    ++colIndex;
                    ++colCount;
                }
            }
            colCount = table.getExpandedColumnCount();
            for (colIndex = 0; colIndex < colCount; ++colIndex) {
                column = table.getColumn(colIndex);
                if (!colMap.containsKey(new Integer(colIndex))) continue;
                uuid = (BOSUuid)colMap.get(new Integer(colIndex));
                if (column.getUserObject() != null && column.getUserObject() instanceof HashMap) {
                    aliasMap = (Map)column.getUserObject();
                    if (!aliasMap.containsKey("SIGN_DATA_ID") || (colId = (BOSUuid)aliasMap.get("SIGN_DATA_ID")).equals((Object)uuid)) continue;
                    MsgBox.showWarning((Component)ui, (String)"col Alias is error!");
                    SysUtil.abort();
                    continue;
                }
                BgSHelper.setColObject(column, "SIGN_DATA_ID", uuid);
                BgSHelper.setColObject(column, "SIGN_DATA_SOURCE", "DATA_SOURCE_COLLECT");
            }
            if (colCount <= maxColIndex) {
                for (colIndex = colCount; colIndex <= maxColIndex; ++colIndex) {
                    column = table.addColumn(colIndex);
                    if (!colMap.containsKey(new Integer(colIndex))) continue;
                    uuid = (BOSUuid)colMap.get(new Integer(colIndex));
                    if (column.getUserObject() != null && column.getUserObject() instanceof HashMap) {
                        aliasMap = (Map)column.getUserObject();
                        if (!aliasMap.containsKey("SIGN_DATA_ID") || (colId = (BOSUuid)aliasMap.get("SIGN_DATA_ID")).equals((Object)uuid)) continue;
                        MsgBox.showWarning((Component)ui, (String)"col Alias is error!");
                        SysUtil.abort();
                        continue;
                    }
                    BgSHelper.setColObject(column, "SIGN_DATA_ID", uuid);
                    BgSHelper.setColObject(column, "SIGN_DATA_SOURCE", "DATA_SOURCE_COLLECT");
                }
            }
            rowCount = table.getExpandedRowCount();
            colCount = table.getExpandedColumnCount();
            for (rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                row = table.getRow(rowIndex);
                if (row == null || row.getUserObject() == null || !(row.getUserObject() instanceof HashMap) || !(aliasMap = (Map)row.getUserObject()).containsKey("SIGN_DATA_ID")) continue;
                rowId = (BOSUuid)aliasMap.get("SIGN_DATA_ID");
                for (colIndex = 0; colIndex < colCount; ++colIndex) {
                    column = table.getColumn(colIndex);
                    if (column == null || column.getUserObject() == null || !(column.getUserObject() instanceof HashMap) || !(aliasMap = (Map)column.getUserObject()).containsKey("SIGN_DATA_ID")) continue;
                    colId = (BOSUuid)aliasMap.get("SIGN_DATA_ID");
                    rowTmpIndex = (Integer)rowIdMap.get(rowId);
                    colTmpIndex = (Integer)colIdMap.get(colId);
                    if (rowIndex == rowTmpIndex && colIndex == colTmpIndex) {
                        collCell = collTable.getCell(rowTmpIndex, colTmpIndex);
                        cell = table.getCell(rowIndex, colIndex);
                        BgFCHelper.copyCell(collCell, cell, ui);
                        continue;
                    }
                    MsgBox.showWarning((Component)ui, (String)"col Alias is error!");
                    SysUtil.abort();
                }
            }
            if (collTable.getUserObject() != null && collTable.getUserObject() instanceof HashMap) {
                aliasMap = (Map)collTable.getUserObject();
                if (table.getUserObject() != null && table.getUserObject() instanceof HashMap) {
                    tmpMap = (Map)table.getUserObject();
                } else {
                    tmpMap = new HashMap();
                    table.setUserObject(tmpMap);
                }
                tmpMap.put(IS_COLLECT_ADJUST, aliasMap.get(IS_COLLECT_ADJUST));
                tmpMap.put(COLLECT_ORGUNIT, aliasMap.get(COLLECT_ORGUNIT));
                tmpMap.put(COLLECT_SCHEME, aliasMap.get(COLLECT_SCHEME));
            }
            table.setRefresh(true);
            table.repaint();
        }
        ui.setProcess(true);
        if (ui instanceof BgFormProcessUI && tmpInfo.get("SIGN_SUBMIT_FORM_ADJUST") != null && tmpInfo.get("SIGN_SUBMIT_FORM_ADJUST") instanceof Map) {
            ((BgFormProcessUI)ui).setBefValueMap((Map)tmpInfo.get("SIGN_SUBMIT_FORM_ADJUST"));
        }
    }

    private static void copyCell(ICell sCell, ICell tCell, BgProcessUI ui) {
        if (sCell == null || tCell == null || ui == null) {
            return;
        }
        RptCell sRptCell = null;
        RptCell tRptCell = null;
        String formulaStr = null;
        if (BgFSHelper.checkHasExpressionsOfCell(sCell)) {
            tCell.setExpressions(sCell.getExpressions());
        }
        if (sCell.getUserObject() != null && sCell.getUserObject() instanceof RptCell) {
            sRptCell = (RptCell)sCell.getUserObject();
            if (BgFSHelper.checkHasFormulaOfCell(sRptCell)) {
                formulaStr = BgFSHelper.getFormulaOfCell(sRptCell);
                if (!BgFSHelper.checkHasFormulaOfCell(tCell)) {
                    tRptCell = new RptCell(tCell);
                    tRptCell.setItemFormula(formulaStr);
                    tCell.setUserObject((Object)tRptCell);
                }
            } else if (BgFSHelper.checkHasFormulaOfBgItem(sRptCell)) {
                tRptCell = BgFCHelper.getRptCell(tCell);
                BgFCHelper.copyCellBgItem(sRptCell, tRptCell);
            } else if (BgFSHelper.checkHasFormulaOfBgPeriod(sRptCell)) {
                tRptCell = BgFCHelper.getRptCell(tCell);
                BgFCHelper.copyCellBgPeriod(sRptCell, tRptCell);
            } else if (BgFSHelper.checkHasFormulaOfBgElement(sRptCell)) {
                tRptCell = BgFCHelper.getRptCell(tCell);
                BgFCHelper.copyCellBgElement(sRptCell, tRptCell);
            } else if (BgFSHelper.checkHasFormulaOfCurrency(sRptCell)) {
                tRptCell = BgFCHelper.getRptCell(tCell);
                BgFCHelper.copyCellCurrency(sRptCell, tRptCell);
            }
        }
        BgFCHelper.copyCellValue(sCell, tCell);
    }

    private static RptCell getRptCell(ICell cell) {
        if (cell == null) {
            return null;
        }
        RptCell rptCell = null;
        if (cell.getUserObject() != null && cell.getUserObject() instanceof RptCell) {
            rptCell = (RptCell)cell.getUserObject();
        } else {
            rptCell = new RptCell(cell);
            rptCell.setItemFormula(new ItemFormula());
        }
        return rptCell;
    }

    private static void copyCellValue(ICell sCell, ICell tCell) {
        if (sCell.getValue() != null) {
            tCell.setValue(sCell.getValue());
        }
    }

    private static void copyCellBgItem(RptCell sRptCell, RptCell tRptCell) {
        if (sRptCell == null || tRptCell == null) {
            return;
        }
        if (tRptCell.getItemFormula() == null) {
            tRptCell.setItemFormula(new ItemFormula());
        }
        tRptCell.getItemFormula().putExt("bgFillType", "bgFillValueType_item");
        tRptCell.getItemFormula().putExt("bgFillValue", sRptCell.getItemFormula().getExt("bgFillValue"));
        tRptCell.getItemFormula().putExt("bgFillValue_itemId", sRptCell.getItemFormula().getExt("bgFillValue_itemId"));
    }

    private static void copyCellBgPeriod(RptCell sRptCell, RptCell tRptCell) {
        if (sRptCell == null || tRptCell == null) {
            return;
        }
        if (tRptCell.getItemFormula() == null) {
            tRptCell.setItemFormula(new ItemFormula());
        }
        tRptCell.getItemFormula().putExt("bgFillType", "bgFillValueType_period");
        tRptCell.getItemFormula().putExt("bgFillValue", sRptCell.getItemFormula().getExt("bgFillValue"));
    }

    private static void copyCellBgElement(RptCell sRptCell, RptCell tRptCell) {
        if (sRptCell == null || tRptCell == null) {
            return;
        }
        if (tRptCell.getItemFormula() == null) {
            tRptCell.setItemFormula(new ItemFormula());
        }
        tRptCell.getItemFormula().putExt("bgFillType", "bgFillValueType_element");
        tRptCell.getItemFormula().putExt("bgFillValue", sRptCell.getItemFormula().getExt("bgFillValue"));
        tRptCell.getItemFormula().putExt("isAttachFormula", sRptCell.getItemFormula().getExt("isAttachFormula"));
    }

    private static void copyCellCurrency(RptCell sRptCell, RptCell tRptCell) {
        if (sRptCell == null || tRptCell == null) {
            return;
        }
        if (tRptCell.getItemFormula() == null) {
            tRptCell.setItemFormula(new ItemFormula());
        }
        tRptCell.getItemFormula().putExt("bgFillType", "bgFillValueType_currency");
        tRptCell.getItemFormula().putExt("bgFillValue", sRptCell.getItemFormula().getExt("bgFillValue"));
    }

    private static int abs(int one, int two) {
        return one > two ? one - two : two - one;
    }
}

