/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgDataInfo;
import com.kingdee.eas.ma.budget.BgFSHelper;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgRefBgCurrencyInfo;
import com.kingdee.eas.ma.budget.BgRefBgItemCombinInfo;
import com.kingdee.eas.ma.budget.BgRefBgPeriodInfo;
import com.kingdee.eas.ma.budget.BgTemplateFactory;
import com.kingdee.eas.ma.budget.IBgTemplate;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgFacadeHelper {
    private static final Logger logger = Logger.getLogger(BgFacadeHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String[] checkFormulaIsEctype(Connection conn, BOSUuid orgUnitId, BOSUuid bgSchemeId, BOSUuid bgFormId, List formulaList) throws EASBizException {
        String[] formulaInfo;
        block25: {
            if (conn == null || orgUnitId == null || bgSchemeId == null || bgFormId == null || formulaList == null || formulaList.isEmpty()) {
                return null;
            }
            PreparedStatement pstmt = null;
            ResultSet rst = null;
            int index = 0;
            int batchSize = 200;
            int size = formulaList.size();
            int count = (size - 1) / batchSize + 1;
            int pos = 0;
            formulaInfo = null;
            String noFindStr = "#";
            String formulaStr = null;
            String tmpBgFormId = null;
            String _orgUnitId = orgUnitId.toString();
            String _bgSchemeId = bgSchemeId.toString();
            StringBuffer sql = new StringBuffer(1024);
            StringBuffer tmpsql = new StringBuffer(1024);
            sql.append("Select TOP 1 FFormula, FBgFormId from T_BG_BgData where FOrgUnitId = ? AND FBgSchemeId = ? AND FFormula in (");
            tmpsql.append("Select TOP 1 FFormula, FBgFormId from T_BG_BgTmpData where FOrgUnitId = ? AND FBgSchemeId = ? AND FFormula in (");
            for (index = 1; index < batchSize; ++index) {
                sql.append("?,");
                tmpsql.append("?,");
            }
            sql.append("?)");
            tmpsql.append("?)");
            sql.append(" and (FBgFormId <> ?)");
            tmpsql.append(" and (FBgFormId <> ?)");
            try {
                pstmt = conn.prepareStatement(sql.toString());
                for (index = 0; index < count && (formulaStr == null || tmpBgFormId == null); ++index) {
                    pstmt.setString(1, _orgUnitId);
                    pstmt.setString(2, _bgSchemeId);
                    int k = 3;
                    while (k < batchSize + 3) {
                        if (pos < size) {
                            pstmt.setString(k, (String)formulaList.get(pos));
                        } else {
                            pstmt.setString(k, noFindStr);
                        }
                        ++k;
                        ++pos;
                    }
                    pstmt.setString(batchSize + 3, bgFormId.toString());
                    try {
                        rst = pstmt.executeQuery();
                        if (!rst.next()) continue;
                        formulaStr = rst.getString(1);
                        tmpBgFormId = rst.getString(2);
                        continue;
                    }
                    finally {
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                }
                SQLUtils.cleanup(rst, (Statement)pstmt);
                if (formulaStr != null && tmpBgFormId != null) {
                    BgFormInfo tmpInfo = BgFSHelper.getBgFormInfo(conn, BOSUuid.read(tmpBgFormId), false);
                    if (tmpInfo != null) {
                        formulaInfo = new String[]{formulaStr, tmpInfo.getName()};
                    } else {
                        throw new BgFormException(BgFormException.NOBGFORMINFO);
                    }
                }
                if (formulaInfo != null) break block25;
                pstmt = conn.prepareStatement(tmpsql.toString());
                for (index = 0; index < count && (formulaStr == null || tmpBgFormId == null); ++index) {
                    pstmt.setString(1, _orgUnitId);
                    pstmt.setString(2, _bgSchemeId);
                    int k = 3;
                    while (k < batchSize + 3) {
                        if (pos < size) {
                            pstmt.setString(k, (String)formulaList.get(pos));
                        } else {
                            pstmt.setString(k, noFindStr);
                        }
                        ++k;
                        ++pos;
                    }
                    pstmt.setString(batchSize + 3, bgFormId.toString());
                    try {
                        rst = pstmt.executeQuery();
                        if (!rst.next()) continue;
                        formulaStr = rst.getString(1);
                        tmpBgFormId = rst.getString(2);
                        continue;
                    }
                    finally {
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                }
                SQLUtils.cleanup(rst, (Statement)pstmt);
                if (formulaStr == null || tmpBgFormId == null) break block25;
                BgFormInfo tmpInfo = BgFSHelper.getBgFormInfo(conn, BOSUuid.read(tmpBgFormId), false);
                if (tmpInfo != null) {
                    formulaInfo = new String[]{formulaStr, tmpInfo.getName()};
                    break block25;
                }
                throw new BgFormException(BgFormException.NOBGFORMINFO);
            }
            catch (SQLException ex) {
                logger.error((Object)ex);
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            finally {
                SQLUtils.cleanup(rst, (Statement)pstmt);
            }
        }
        return formulaInfo;
    }

    public static final void addNewBgDataBudgetValue(Connection conn, BgFormInfo bgFormInfo, List formulas, List bValues, List aValues, List bgItemList, List bgPeriodList, List bgElementList, List currencyList, Map bgItemMap, Map bgPeriodMap, Map bgElementMap, Map currencyMap, List isCtrlList, List isFlexCtrlList, List flexCtrlParamList, List periodCtrlPolicyList, List isGroupCtrlList, List groupCtrlNoList) throws EASBizException {
        if (conn == null || bgFormInfo == null || formulas == null || bValues == null || bgItemList == null || bgPeriodList == null || bgElementList == null || currencyList == null || bgItemMap == null || bgPeriodMap == null || bgElementMap == null || currencyMap == null || isCtrlList == null || isFlexCtrlList == null || flexCtrlParamList == null || periodCtrlPolicyList == null || isGroupCtrlList == null || groupCtrlNoList == null) {
            return;
        }
        if (formulas.isEmpty() || formulas.size() != bValues.size() || formulas.size() != aValues.size()) {
            return;
        }
        PreparedStatement pstmt = null;
        BigDecimal bValue = null;
        BigDecimal aValue = null;
        BigDecimal cValue = null;
        BOSObjectType type = new BgDataInfo().getBOSType();
        int batchSize = 200;
        int batchIndex = 0;
        String ctrlString = null;
        String _bgItemId = null;
        String _bgPeriodId = null;
        String _bgElementId = null;
        String _currencyId = null;
        String _bgFormId = bgFormInfo.getId().toString();
        String _orgUnitId = bgFormInfo.getOrgUnit().getId().toString();
        String _bgSchemeId = bgFormInfo.getBgScheme().getId().toString();
        String _bgTemplateId = bgFormInfo.getBgTemplate().getId().toString();
        try {
            pstmt = conn.prepareStatement("Insert Into T_BG_BgData (FID, FBgValue,FBizActual, FBgBalance, FFormula, FBgPeriodId, FBgFormId, FBgElementId,FCurrencyId, FOrgUnitId, FBgSchemeId, FBgTemplateId, FBgItemCombinId,FIsControl, FIsFlexible, FFlexParam, FCtrlType, FIsGroupCtrl, FGroupNo) Values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            int count = formulas.size();
            for (int index = 0; index < count; ++index) {
                try {
                    bValue = new BigDecimal(bValues.get(index).toString());
                }
                catch (Exception ex) {
                    bValue = BgConstants.BIGZERO;
                }
                if (aValues != null && aValues.size() == bValues.size()) {
                    try {
                        aValue = new BigDecimal(aValues.get(index).toString());
                    }
                    catch (Exception ex) {
                        aValue = BgConstants.BIGZERO;
                    }
                } else {
                    aValue = BgConstants.BIGZERO;
                }
                pstmt.setString(1, BOSUuid.create((BOSObjectType)type).toString());
                pstmt.setBigDecimal(2, bValue.setScale(8, 4));
                pstmt.setBigDecimal(3, aValue.setScale(8, 4));
                pstmt.setBigDecimal(4, bValue.setScale(8, 4));
                pstmt.setString(5, formulas.get(index).toString());
                _bgPeriodId = (String)bgPeriodMap.get(bgPeriodList.get(index));
                if (_bgPeriodId == null) {
                    logger.debug((Object)("bgPeriod number error:" + bgPeriodList.get(index).toString()));
                    throw new BgFormException(BgFormException.SUBMITNOPERIOD, new String[]{bgPeriodList.get(index).toString()});
                }
                pstmt.setString(6, _bgPeriodId);
                pstmt.setString(7, _bgFormId);
                _bgElementId = (String)bgElementMap.get(bgElementList.get(index));
                if (_bgElementId == null) {
                    logger.debug((Object)("bgElement number error:" + bgElementList.get(index).toString()));
                    throw new BgFormException(BgFormException.SUBMITNOELEMENT, new String[]{bgElementList.get(index).toString()});
                }
                pstmt.setString(8, _bgElementId);
                _currencyId = (String)currencyMap.get(currencyList.get(index));
                if (_currencyId == null) {
                    logger.debug((Object)("currency number error:" + currencyList.get(index).toString()));
                    throw new BgFormException(BgFormException.SUBMITNOCURRENCY, new String[]{currencyList.get(index).toString()});
                }
                pstmt.setString(9, _currencyId);
                pstmt.setString(10, _orgUnitId);
                pstmt.setString(11, _bgSchemeId);
                pstmt.setString(12, _bgTemplateId);
                _bgItemId = (String)bgItemMap.get(bgItemList.get(index));
                if (_bgItemId == null) {
                    logger.debug((Object)("bgItem number error:" + bgItemList.get(index).toString()));
                    throw new BgFormException(BgFormException.SUBMITNOITEM, new String[]{bgItemList.get(index).toString()});
                }
                pstmt.setString(13, _bgItemId);
                ctrlString = (String)isCtrlList.get(index);
                if (ctrlString != null && ctrlString.equals(Boolean.TRUE.toString())) {
                    pstmt.setInt(14, 1);
                } else {
                    pstmt.setInt(14, 0);
                }
                ctrlString = (String)isFlexCtrlList.get(index);
                if (ctrlString != null && ctrlString.equals(Boolean.TRUE.toString())) {
                    pstmt.setInt(15, 1);
                } else {
                    pstmt.setInt(15, 0);
                }
                try {
                    cValue = new BigDecimal(flexCtrlParamList.get(index).toString());
                }
                catch (Exception ex) {
                    cValue = BgConstants.BIGZERO;
                }
                pstmt.setBigDecimal(16, cValue.setScale(8, 4));
                ctrlString = (String)periodCtrlPolicyList.get(index);
                if (ctrlString != null) {
                    try {
                        pstmt.setInt(17, new Integer(ctrlString));
                    }
                    catch (Exception ex) {
                        pstmt.setInt(17, 10);
                    }
                } else {
                    pstmt.setInt(17, 10);
                }
                ctrlString = (String)isGroupCtrlList.get(index);
                if (ctrlString != null && ctrlString.equals(Boolean.TRUE.toString())) {
                    pstmt.setInt(18, 1);
                } else {
                    pstmt.setInt(18, 0);
                }
                pstmt.setString(19, (String)groupCtrlNoList.get(index));
                pstmt.addBatch();
                if (++batchIndex < batchSize) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex.getMessage());
            throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        catch (EASBizException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    public static final void updateBgDataBudgetValue(Connection conn, BOSUuid bgFormId, List formulas, List bValues, List aValues, List isCtrlList, List isFlexCtrlList, List flexCtrlParamList, List periodCtrlPolicyList, List isGroupCtrlList, List groupCtrlNoList) throws EASBizException {
        if (bgFormId == null || formulas == null || bValues == null || aValues == null || formulas.size() != bValues.size() || formulas.size() != aValues.size()) {
            return;
        }
        PreparedStatement pstmt = null;
        BigDecimal bValue = null;
        BigDecimal aValue = null;
        BigDecimal ctrlValue = null;
        int batchSize = 200;
        int batchIndex = 0;
        String formulaStr = null;
        String valueStr = null;
        String ctrlString = null;
        String _bgFormId = bgFormId.toString();
        StringBuffer sql = new StringBuffer();
        sql.append("update T_BG_BgData set FBgValue = ?, FBizActual = ?, FIsControl = ?, FIsFlexible = ?, FFlexParam = ?, FCtrlType = ?, FIsGroupCtrl = ?, FGroupNo = ? where FBgFormId = ? and FFormula = ?");
        try {
            pstmt = conn.prepareStatement(sql.toString());
            int count = formulas.size();
            for (int index = 0; index < count; ++index) {
                formulaStr = (String)formulas.get(index);
                valueStr = (String)bValues.get(index);
                try {
                    bValue = new BigDecimal(valueStr);
                }
                catch (Exception ex) {
                    bValue = BgConstants.BIGZERO;
                }
                valueStr = (String)aValues.get(index);
                try {
                    aValue = new BigDecimal(valueStr);
                }
                catch (Exception ex) {
                    aValue = BgConstants.BIGZERO;
                }
                pstmt.setBigDecimal(1, bValue.setScale(8, 4));
                pstmt.setBigDecimal(2, aValue.setScale(8, 4));
                ctrlString = (String)isCtrlList.get(index);
                if (ctrlString != null && ctrlString.equals(Boolean.TRUE.toString())) {
                    pstmt.setInt(3, 1);
                } else {
                    pstmt.setInt(3, 0);
                }
                ctrlString = (String)isFlexCtrlList.get(index);
                if (ctrlString != null && ctrlString.equals(Boolean.TRUE.toString())) {
                    pstmt.setInt(4, 1);
                } else {
                    pstmt.setInt(4, 0);
                }
                ctrlString = (String)flexCtrlParamList.get(index);
                try {
                    ctrlValue = new BigDecimal(ctrlString);
                }
                catch (Exception ex) {
                    ctrlValue = BgConstants.BIGZERO;
                }
                pstmt.setBigDecimal(5, ctrlValue.setScale(8, 4));
                ctrlString = (String)periodCtrlPolicyList.get(index);
                if (ctrlString != null) {
                    try {
                        pstmt.setInt(6, new Integer(ctrlString));
                    }
                    catch (Exception ex) {
                        pstmt.setInt(6, 10);
                    }
                } else {
                    pstmt.setInt(6, 10);
                }
                ctrlString = (String)isGroupCtrlList.get(index);
                if (ctrlString != null && ctrlString.equals(Boolean.TRUE.toString())) {
                    pstmt.setInt(7, 1);
                } else {
                    pstmt.setInt(7, 0);
                }
                pstmt.setString(8, (String)groupCtrlNoList.get(index));
                pstmt.setString(9, _bgFormId);
                pstmt.setString(10, formulaStr);
                pstmt.addBatch();
                if (++batchIndex < batchSize) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
    }

    public static final void updateBgDataBudgetValue(Connection conn, BOSUuid orgUnitId, BOSUuid bgSchemeId, List formulas, List values, List isCtrlList, List isFlexCtrlList, List flexCtrlParamList, List periodCtrlPolicyList, List isGroupCtrlList, List groupCtrlNoList) throws EASBizException {
        if (orgUnitId == null || bgSchemeId == null || formulas == null || values == null || formulas.size() != values.size()) {
            return;
        }
        PreparedStatement pstmt = null;
        BigDecimal value = null;
        BigDecimal ctrlValue = null;
        int batchSize = 200;
        int batchIndex = 0;
        String formulaStr = null;
        String ctrlString = null;
        String _orgUnitId = orgUnitId.toString();
        String _bgSchemeId = bgSchemeId.toString();
        StringBuffer sql = new StringBuffer();
        sql.append("update T_BG_BgData set FBgValue = ?, FIsControl = ?, FIsFlexible = ?, FFlexParam = ?, FCtrlType = ?, FIsGroupCtrl = ?, FGroupNo = ? where FOrgUnitId = ? and FBgSchemeId = ? and FFormula = ?");
        try {
            pstmt = conn.prepareStatement(sql.toString());
            int count = formulas.size();
            for (int index = 0; index < count; ++index) {
                formulaStr = (String)formulas.get(index);
                value = (BigDecimal)values.get(index);
                pstmt.setBigDecimal(1, value.setScale(8, 4));
                ctrlString = (String)isCtrlList.get(index);
                if (ctrlString != null && ctrlString.equals(Boolean.TRUE.toString())) {
                    pstmt.setInt(2, 1);
                } else {
                    pstmt.setInt(2, 0);
                }
                ctrlString = (String)isFlexCtrlList.get(index);
                if (ctrlString != null && ctrlString.equals(Boolean.TRUE.toString())) {
                    pstmt.setInt(3, 1);
                } else {
                    pstmt.setInt(3, 0);
                }
                ctrlString = (String)flexCtrlParamList.get(index);
                try {
                    ctrlValue = new BigDecimal(ctrlString);
                }
                catch (Exception ex) {
                    ctrlValue = BgConstants.BIGZERO;
                }
                pstmt.setBigDecimal(4, ctrlValue.setScale(8, 4));
                ctrlString = (String)periodCtrlPolicyList.get(index);
                if (ctrlString != null) {
                    try {
                        pstmt.setInt(5, new Integer(ctrlString));
                    }
                    catch (Exception ex) {
                        pstmt.setInt(5, 10);
                    }
                } else {
                    pstmt.setInt(5, 10);
                }
                ctrlString = (String)isGroupCtrlList.get(index);
                if (ctrlString != null && ctrlString.equals(Boolean.TRUE.toString())) {
                    pstmt.setInt(6, 1);
                } else {
                    pstmt.setInt(6, 0);
                }
                pstmt.setString(7, (String)groupCtrlNoList.get(index));
                pstmt.setString(8, _orgUnitId);
                pstmt.setString(9, _bgSchemeId);
                pstmt.setString(10, formulaStr);
                pstmt.addBatch();
                if (++batchIndex < batchSize) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
    }

    public static final int updateBgDataBudgetValue(Connection conn, BOSUuid bgFormId, String formula, BigDecimal value) throws EASBizException {
        int result = 0;
        if (conn == null || bgFormId == null || formula == null || value == null) {
            return result;
        }
        PreparedStatement pstmt = null;
        StringBuffer sql = new StringBuffer();
        sql.append("update T_BG_BgData set FBgValue = ? where FBgFormId = ? and FFormula = ?");
        try {
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, bgFormId.toString());
            pstmt.setString(2, formula);
            pstmt.setBigDecimal(3, value);
            result = pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
        return result;
    }

    public static final int updateBgDataBudgetValue(Connection conn, BOSUuid orgUnitId, BOSUuid bgSchemeId, String formula, BigDecimal value) throws EASBizException {
        int result = 0;
        if (conn == null || orgUnitId == null || bgSchemeId == null || formula == null || value == null) {
            return result;
        }
        PreparedStatement pstmt = null;
        StringBuffer sql = new StringBuffer();
        sql.append("update T_BG_BgData set FBgValue = ? where FOrgUnitId = ? and FBgSchemeId = ? and FFormula = ?");
        try {
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, orgUnitId.toString());
            pstmt.setString(2, bgSchemeId.toString());
            pstmt.setString(3, formula);
            pstmt.setBigDecimal(3, value);
            result = pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
        return result;
    }

    public static final void removeBgDataBudgetValue(Connection conn, BOSUuid bgFormId, List formulas) throws EASBizException {
        if (conn == null || bgFormId == null || formulas == null) {
            return;
        }
        PreparedStatement pstmt = null;
        int batchSize = 200;
        int batchIndex = 0;
        String formulaStr = null;
        String _bgFormId = bgFormId.toString();
        StringBuffer sql = new StringBuffer();
        sql.append("delete T_BG_BgData where FBgFormId = ? and FFormula = ?");
        try {
            pstmt = conn.prepareStatement(sql.toString());
            int in = formulas.size();
            for (int i = 0; i < in; ++i) {
                formulaStr = (String)formulas.get(i);
                pstmt.setString(1, _bgFormId);
                pstmt.setString(2, formulaStr);
                pstmt.addBatch();
                if (++batchIndex < batchSize) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
    }

    public static final void checkValue(String value, int rowIndex, int colIndex) throws EASBizException {
        if (StringUtils.isEmpty((String)value)) {
            return;
        }
        BigDecimal _value = null;
        try {
            _value = new BigDecimal(value);
        }
        catch (Exception ex) {
            _value = BgConstants.BIGZERO;
        }
        BgFacadeHelper.checkValue(_value, rowIndex, colIndex);
    }

    public static final void checkValue(BigDecimal value, int rowIndex, int colIndex) throws EASBizException {
        if (value == null) {
            return;
        }
        int compareValue = value.compareTo(BgConstants.BIGZERO);
        if (compareValue > 0) {
            if (BgFSHelper.checkHasOverstepMax(value)) {
                throw new BgFormException(BgFormException.VALUEHASOVERSTEPMAX, new String[]{TableToolkit.xy2range((int)colIndex, (int)rowIndex)});
            }
        } else if (compareValue < 0 && BgFSHelper.checkHasOverstepMin(value)) {
            throw new BgFormException(BgFormException.VALUEHASOVERSTEPMIN, new String[]{TableToolkit.xy2range((int)colIndex, (int)rowIndex)});
        }
    }

    public static final Map getBgItemMap(Connection conn, Map bgItemMap, List bgItemList) throws BOSException, EASBizException {
        if (conn == null || bgItemList == null || bgItemList.isEmpty()) {
            return new HashMap();
        }
        HashSet<String> _bgItemSet = new HashSet<String>();
        ArrayList<String> _bgItemList = new ArrayList<String>();
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int index = 0;
        int batchNum = 200;
        int size = 0;
        int count = 0;
        int pos = 0;
        String bgItemId = null;
        String bgItemKey = null;
        String noFindStr = "#";
        StringBuffer sql = new StringBuffer(1024);
        sql.append("select FID, FKey from T_BG_BgItemCombination where FKey IN (");
        for (index = 1; index < batchNum; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        if (bgItemMap == null) {
            bgItemMap = new HashMap<String, String>();
        }
        int in = bgItemList.size();
        for (int i = 0; i < in; ++i) {
            bgItemKey = (String)bgItemList.get(i);
            if (bgItemMap.containsKey(bgItemKey) || _bgItemSet.contains(bgItemKey)) continue;
            _bgItemSet.add(bgItemKey);
            _bgItemList.add(bgItemKey);
        }
        size = _bgItemList.size();
        count = (size - 1) / batchNum + 1;
        try {
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                int k = 1;
                while (k <= batchNum) {
                    if (pos < size) {
                        pstmt.setString(k, (String)_bgItemList.get(pos));
                    } else {
                        pstmt.setString(k, noFindStr);
                    }
                    ++k;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bgItemId = rst.getString(1);
                    bgItemKey = rst.getString(2);
                    bgItemMap.put(bgItemKey, bgItemId);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        return bgItemMap;
    }

    public static final Map createBgItemMap(Context ctx, Map bgItemMap, List bgItemList) throws BOSException, EASBizException {
        String bgItemKey2 = null;
        String bgItemId = null;
        ArrayList<String> createNew = new ArrayList<String>();
        HashSet<String> _bgItemSet = new HashSet<String>();
        Hashtable _bgItemMap = null;
        int count = bgItemList.size();
        for (int index = 0; index < count; ++index) {
            bgItemKey2 = (String)bgItemList.get(index);
            if (bgItemMap.containsKey(bgItemKey2) || _bgItemSet.contains(bgItemKey2)) continue;
            createNew.add(bgItemKey2.replaceAll("_", ","));
            _bgItemSet.add(bgItemKey2);
        }
        IBgTemplate ibgTemplate = null;
        try {
            ibgTemplate = BgTemplateFactory.getLocalInstance(ctx);
            if (ibgTemplate == null) {
                throw new BgFormException(BgFormException.NOINSTANCE);
            }
            _bgItemMap = ibgTemplate.getItemCombinIds(createNew);
            if (_bgItemMap != null && !_bgItemMap.isEmpty()) {
                for (String bgItemKey2 : _bgItemMap.keySet()) {
                    bgItemId = (String)_bgItemMap.get(bgItemKey2);
                    bgItemMap.put(bgItemKey2.replaceAll(",", "_"), bgItemId);
                }
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
        return bgItemMap;
    }

    public static final Map getBgPeriodMap(Connection conn, Map bgPeriodMap, List bgPeriodList) throws EASBizException {
        if (conn == null || bgPeriodList == null || bgPeriodList.isEmpty()) {
            return new HashMap();
        }
        HashSet<String> _bgPeriodSet = new HashSet<String>();
        ArrayList<String> _bgPeriodList = new ArrayList<String>();
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int index = 0;
        int batchNum = 200;
        int size = 0;
        int count = 0;
        int pos = 0;
        String bgPeriodId = null;
        String bgPeriodNum = null;
        String noFindStr = "#";
        StringBuffer sql = new StringBuffer(1024);
        sql.append("select FID, FNumber from T_BG_BgPeriod where FNumber IN (");
        for (index = 1; index < batchNum; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        if (bgPeriodMap == null) {
            bgPeriodMap = new HashMap<String, String>();
        }
        int in = bgPeriodList.size();
        for (int i = 0; i < in; ++i) {
            bgPeriodNum = (String)bgPeriodList.get(i);
            if (bgPeriodMap.containsKey(bgPeriodNum) || _bgPeriodSet.contains(bgPeriodNum)) continue;
            _bgPeriodSet.add(bgPeriodNum);
            _bgPeriodList.add(bgPeriodNum);
        }
        size = _bgPeriodList.size();
        count = (size - 1) / batchNum + 1;
        try {
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                int k = 1;
                while (k <= batchNum) {
                    if (pos < size) {
                        pstmt.setString(k, (String)_bgPeriodList.get(pos));
                    } else {
                        pstmt.setString(k, noFindStr);
                    }
                    ++k;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bgPeriodId = rst.getString(1);
                    bgPeriodNum = rst.getString(2);
                    bgPeriodMap.put(bgPeriodNum, bgPeriodId);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        return bgPeriodMap;
    }

    public static final Map getBgElementMap(Connection conn, Map bgElementMap, List bgElementList) throws EASBizException {
        if (conn == null || bgElementList == null || bgElementList.isEmpty()) {
            return new HashMap();
        }
        HashSet<String> _bgElementSet = new HashSet<String>();
        ArrayList<String> _bgElementList = new ArrayList<String>();
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int index = 0;
        int batchNum = 200;
        int size = 0;
        int count = 0;
        int pos = 0;
        String bgElementId = null;
        String bgElementNum = null;
        String noFindStr = "#";
        StringBuffer sql = new StringBuffer(1024);
        sql.append("select FID, FNumber from T_BG_BgElement where FNumber IN (");
        for (index = 1; index < batchNum; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        if (bgElementMap == null) {
            bgElementMap = new HashMap<String, String>();
        }
        int in = bgElementList.size();
        for (int i = 0; i < in; ++i) {
            bgElementNum = (String)bgElementList.get(i);
            if (bgElementMap.containsKey(bgElementNum) || _bgElementSet.contains(bgElementNum)) continue;
            _bgElementSet.add(bgElementNum);
            _bgElementList.add(bgElementNum);
        }
        size = _bgElementList.size();
        count = (size - 1) / batchNum + 1;
        try {
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                int k = 1;
                while (k <= batchNum) {
                    if (pos < size) {
                        pstmt.setString(k, (String)_bgElementList.get(pos));
                    } else {
                        pstmt.setString(k, noFindStr);
                    }
                    ++k;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bgElementId = rst.getString(1);
                    bgElementNum = rst.getString(2);
                    bgElementMap.put(bgElementNum, bgElementId);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        return bgElementMap;
    }

    public static final Map getCurrencyMap(Connection conn, Map currencyMap, List currencyList) throws EASBizException {
        if (conn == null || currencyList == null || currencyList.isEmpty()) {
            return new HashMap();
        }
        HashSet<String> _currencySet = new HashSet<String>();
        ArrayList<String> _currencyList = new ArrayList<String>();
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int index = 0;
        int batchNum = 200;
        int size = 0;
        int count = 0;
        int pos = 0;
        String currencyId = null;
        String currencyNum = null;
        String noFindStr = "#";
        StringBuffer sql = new StringBuffer(1024);
        sql.append("select FID, FNumber from T_BD_Currency where FNumber IN (");
        for (index = 1; index < batchNum; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        if (currencyMap == null) {
            currencyMap = new HashMap<String, String>();
        }
        int in = currencyList.size();
        for (int i = 0; i < in; ++i) {
            currencyNum = (String)currencyList.get(i);
            if (currencyMap.containsKey(currencyNum) || _currencySet.contains(currencyNum)) continue;
            _currencySet.add(currencyNum);
            _currencyList.add(currencyNum);
        }
        size = _currencyList.size();
        count = (size - 1) / batchNum + 1;
        try {
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                int k = 1;
                while (k <= batchNum) {
                    if (pos < size) {
                        pstmt.setString(k, (String)_currencyList.get(pos));
                    } else {
                        pstmt.setString(k, noFindStr);
                    }
                    ++k;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    currencyId = rst.getString(1);
                    currencyNum = rst.getString(2);
                    currencyMap.put(currencyNum, currencyId);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        return currencyMap;
    }

    public static final void dealRefBgItem(Connection conn, BOSUuid bgFormId, Map refBgItemMap) throws EASBizException {
        if (conn == null || bgFormId == null || refBgItemMap == null || refBgItemMap.isEmpty()) {
            return;
        }
        int batchSize = 200;
        int batchIndex = 0;
        String bgItemKey2 = null;
        String bgItemId = null;
        String _bgFormId = bgFormId.toString();
        BgRefBgItemCombinInfo bgRefItemInfo = new BgRefBgItemCombinInfo();
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement("DELETE FROM T_BG_BgRefBgItemCombin WHERE FBgFormID = ?");
            pstmt.setString(1, _bgFormId);
            pstmt.executeUpdate();
            SQLUtils.cleanup((Statement)pstmt);
            pstmt = conn.prepareStatement("INSERT INTO T_BG_BgRefBgItemCombin(FID, FBgFormID, FBgItemCombinId) VALUES (?, ?, ?)");
            for (String bgItemKey2 : refBgItemMap.keySet()) {
                bgItemId = (String)refBgItemMap.get(bgItemKey2);
                if (bgItemId != null) {
                    pstmt.setString(1, BOSUuid.create((BOSObjectType)bgRefItemInfo.getBOSType()).toString());
                    pstmt.setString(2, _bgFormId);
                    pstmt.setString(3, bgItemId);
                    pstmt.addBatch();
                    if (++batchIndex < batchSize) continue;
                    pstmt.executeBatch();
                    batchIndex = 0;
                    continue;
                }
                throw new BgFormException(BgFormException.SUBMITNOPERIOD, new String[]{bgItemKey2});
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        catch (EASBizException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    public static final void dealRefBgItemCombin(Connection conn) throws EASBizException {
    }

    public static final void dealRefBgPeriod(Connection conn, BOSUuid bgFormId, Map refBgPeriodMap) throws EASBizException {
        if (conn == null || bgFormId == null || refBgPeriodMap == null || refBgPeriodMap.isEmpty()) {
            return;
        }
        int batchSize = 200;
        int batchIndex = 0;
        String bgPeriodNumbr2 = null;
        String bgPeriodId = null;
        String _bgFormId = bgFormId.toString();
        BgRefBgPeriodInfo bgRefPeriodInfo = new BgRefBgPeriodInfo();
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement("DELETE FROM T_BG_BgRefBgPeriod WHERE FBgFormID = ?");
            pstmt.setString(1, _bgFormId);
            pstmt.executeUpdate();
            SQLUtils.cleanup((Statement)pstmt);
            pstmt = conn.prepareStatement("INSERT INTO T_BG_BgRefBgPeriod(FID, FBgFormID, FBgPeriodID) VALUES (?, ?, ?)");
            for (String bgPeriodNumbr2 : refBgPeriodMap.keySet()) {
                bgPeriodId = (String)refBgPeriodMap.get(bgPeriodNumbr2);
                if (bgPeriodId != null) {
                    pstmt.setString(1, BOSUuid.create((BOSObjectType)bgRefPeriodInfo.getBOSType()).toString());
                    pstmt.setString(2, _bgFormId);
                    pstmt.setString(3, bgPeriodId);
                    pstmt.addBatch();
                    if (++batchIndex < batchSize) continue;
                    pstmt.executeBatch();
                    batchIndex = 0;
                    continue;
                }
                throw new BgFormException(BgFormException.SUBMITNOPERIOD, new String[]{bgPeriodNumbr2});
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        catch (EASBizException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    public static final void dealRefBgElement(Connection conn, BOSUuid bgFormId, Map refBgElementMap) throws EASBizException {
        if (conn == null || bgFormId == null || refBgElementMap == null || refBgElementMap.isEmpty()) {
            return;
        }
        int batchSize = 200;
        int batchIndex = 0;
        String bgElementId = null;
        String bgElementNum2 = null;
        String _bgFormId = bgFormId.toString();
        BgRefBgPeriodInfo bgRefElementInfo = new BgRefBgPeriodInfo();
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement("DELETE FROM T_BG_BgRefBgElement WHERE FBgFormID = ?");
            pstmt.setString(1, _bgFormId);
            pstmt.executeUpdate();
            SQLUtils.cleanup((Statement)pstmt);
            pstmt = conn.prepareStatement("INSERT INTO T_BG_BgRefBgElement(FID, FBgFormID, FBgElementID) VALUES (?,?,?)");
            for (String bgElementNum2 : refBgElementMap.keySet()) {
                bgElementId = (String)refBgElementMap.get(bgElementNum2);
                if (bgElementId != null) {
                    pstmt.setString(1, BOSUuid.create((BOSObjectType)bgRefElementInfo.getBOSType()).toString());
                    pstmt.setString(2, _bgFormId);
                    pstmt.setString(3, bgElementId);
                    pstmt.addBatch();
                    if (++batchIndex < batchSize) continue;
                    pstmt.executeBatch();
                    batchIndex = 0;
                    continue;
                }
                throw new BgFormException(BgFormException.SUBMITNOELEMENT, new String[]{bgElementNum2});
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex.getMessage());
            throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        catch (EASBizException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    public static final void dealRefCurrency(Connection conn, BOSUuid bgFormId, Map refCurrencyMap) throws EASBizException {
        if (conn == null || bgFormId == null || refCurrencyMap == null || refCurrencyMap.isEmpty()) {
            return;
        }
        int batchSize = 200;
        int batchIndex = 0;
        String currencyId = null;
        String currencyNum2 = null;
        String _bgFormId = bgFormId.toString();
        BgRefBgCurrencyInfo bgRefCurrencyInfo = new BgRefBgCurrencyInfo();
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement("DELETE FROM T_BG_BgRefBgCurrency WHERE FBgFormID = ?");
            pstmt.setString(1, _bgFormId);
            pstmt.executeUpdate();
            SQLUtils.cleanup((Statement)pstmt);
            pstmt = conn.prepareStatement("INSERT INTO T_BG_BgRefBgCurrency(FID, FBgFormID, FBgCurrencyID) VALUES (?, ?, ?)");
            for (String currencyNum2 : refCurrencyMap.keySet()) {
                currencyId = (String)refCurrencyMap.get(currencyNum2);
                if (currencyId != null) {
                    pstmt.setString(1, BOSUuid.create((BOSObjectType)bgRefCurrencyInfo.getBOSType()).toString());
                    pstmt.setString(2, _bgFormId);
                    pstmt.setString(3, currencyId);
                    pstmt.addBatch();
                    if (++batchIndex < batchSize) continue;
                    pstmt.executeBatch();
                    batchIndex = 0;
                    continue;
                }
                throw new BgFormException(BgFormException.SUBMITNOCURRENCY, new String[]{currencyNum2});
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        catch (EASBizException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }
}

