/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.kscript.dom.expr.BinaryOpExpr;
import com.kingdee.bos.kscript.dom.expr.CodeExpr;
import com.kingdee.bos.kscript.dom.expr.MethodInvokeExpr;
import com.kingdee.bos.kscript.dom.expr.StringExpr;
import com.kingdee.bos.kscript.dom.stmt.ExprStmt;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.RptCell;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.util.RptFormulaParser;
import com.kingdee.eas.ma.budget.BgElementCollection;
import com.kingdee.eas.ma.budget.BgFSHelper;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgFormulaFacadeFactory;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemObject;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.IBgFormulaFacade;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.ma.budget.client.BgCurrencyF7UI;
import com.kingdee.eas.ma.budget.client.BgElementF7UI;
import com.kingdee.eas.ma.budget.client.BgPeriodF7UI;
import com.kingdee.eas.ma.budget.client.BgProcessUI;
import com.kingdee.eas.ma.budget.client.BgTemplateProcessUI;
import com.kingdee.eas.ma.budget.client.NewBgItemGroupListF7UI;
import com.kingdee.eas.ma.budget.client.ProjectFormulaUI;
import com.kingdee.eas.ma.budget.client.ProjectSameFormulaUI;
import com.kingdee.eas.ma.nbudget.client.BgParamCHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgFillHelper {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.BgFillHelper");
    public static final String H = "h";
    public static final String V = "v";
    public static final String BGFILLTYPE = "bgFillType";
    public static final String BGFILLVALUE = "bgFillValue";
    public static final String BGFILLVALUETYPE_ITEM = "bgFillValueType_item";
    public static final String BGFILLVALUETYPE_PERIOD = "bgFillValueType_period";
    public static final String BGFILLVALUETYPE_ELEMENT = "bgFillValueType_element";
    public static final String BGFILLVALUETYPE_CURRENCY = "bgFillValueType_currency";
    public static final String VISUALBOSTYPE = "DDD88DDD";
    public static final String CMD_BGFORMULA = "BgFormula";
    public static final String CMD_BGACTUALS = "BgActualS";
    public static final String CMD_BGBAL = "BgBal";
    public static final String CMD_BGFORMULAF = "BgFormulaF";
    public static final String CMD_BGACTUALSF = "BgActualSF";
    public static final String CMD_BGBALF = "BgBalF";
    public static final String CMD_BGACTUALEXT = "BgActualExt";
    public static final String CMD_BGACTUALEXTF = "BgActualExtF";
    public static final String ISATTACHFORMUAL = "isAttachFormula";
    public static final String BGFILLVALUE_ITEMID = "bgFillValue_itemId";
    public static final int SHOW_NAME_ONLY = 1;
    public static final int SHOW_NUMBER_ONLY = 2;
    public static final int SHOW_NAME_NUMBER_BOTH = 3;

    public static void showCurrency(IUIObject win, KDTable table) {
        block8: {
            KDTRange range = BgFillHelper.getSelectRange(win, table);
            UIContext uiContext = new UIContext((Object)win);
            IUIWindow uiWindow = null;
            try {
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.ma.budget.client.BgCurrencyF7UI", (Map)uiContext);
            }
            catch (UIException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
            uiWindow.show();
            BgCurrencyF7UI f7ui = (BgCurrencyF7UI)uiWindow.getUIObject();
            if (f7ui.getResultColl() == null || f7ui.getResultColl().size() <= 0) break block8;
            CurrencyCollection coll = f7ui.getResultColl();
            if (range.size() > 0) {
                KDTSelectBlock block = (KDTSelectBlock)range.get(0);
                if (block.getBeginRow() == block.getEndRow() && block.getBeginCol() != block.getEndCol()) {
                    int index = 0;
                    int j = block.getBeginRow();
                    for (int k = block.getBeginCol(); k <= (coll.size() >= block.getEndCol() - block.getBeginCol() + 1 ? block.getBeginCol() + coll.size() - 1 : block.getEndCol()); ++k) {
                        ICell cell = table.getCell(j, k);
                        RptCell eptCell = new RptCell(cell);
                        eptCell.setItemFormula(new ItemFormula());
                        eptCell.getItemFormula().putExt(BGFILLTYPE, BGFILLVALUETYPE_CURRENCY);
                        eptCell.getItemFormula().putExt(BGFILLVALUE, coll.get(index % coll.size()).getNumber());
                        if (cell == null) continue;
                        cell.setValue((Object)coll.get(index % coll.size()).getName());
                        cell.setUserObject((Object)eptCell);
                        ++index;
                    }
                } else if (block.getBeginCol() == block.getEndCol()) {
                    int index = 0;
                    int k = block.getBeginCol();
                    for (int j = block.getBeginRow(); j <= (coll.size() >= block.getEndRow() - block.getBeginRow() + 1 ? block.getBeginRow() + coll.size() - 1 : block.getEndRow()); ++j) {
                        ICell cell = table.getCell(j, k);
                        RptCell eptCell = new RptCell(cell);
                        eptCell.setItemFormula(new ItemFormula());
                        eptCell.getItemFormula().putExt(BGFILLTYPE, BGFILLVALUETYPE_CURRENCY);
                        eptCell.getItemFormula().putExt(BGFILLVALUE, coll.get(index % coll.size()).getNumber());
                        if (cell == null) continue;
                        cell.setValue((Object)coll.get(index % coll.size()).getName());
                        cell.setUserObject((Object)eptCell);
                        ++index;
                    }
                }
            }
        }
    }

    public static void showElement(IUIObject win, KDTable table) {
        block8: {
            KDTRange range = BgFillHelper.getSelectRange(win, table);
            UIContext uiContext = new UIContext((Object)win);
            uiContext.put((Object)"isFilterText", (Object)new Boolean(false));
            uiContext.put((Object)"isChooseOne", (Object)new Boolean(false));
            IUIWindow uiWindow = null;
            try {
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.ma.budget.client.BgElementF7UI", (Map)uiContext);
            }
            catch (UIException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
            uiWindow.show();
            BgElementF7UI f7ui = (BgElementF7UI)uiWindow.getUIObject();
            if (f7ui.getResult() == null || f7ui.getResult().getResult().size() == 0) break block8;
            BgElementCollection eleColl = f7ui.getResult().getResult();
            if (range.size() > 0) {
                KDTSelectBlock block = (KDTSelectBlock)range.get(0);
                if (block.getBeginRow() == block.getEndRow() && block.getBeginCol() != block.getEndCol()) {
                    int index = 0;
                    int j = block.getBeginRow();
                    for (int k = block.getBeginCol(); k <= (eleColl.size() >= block.getEndCol() - block.getBeginCol() + 1 ? block.getBeginCol() + eleColl.size() - 1 : block.getEndCol()); ++k) {
                        ICell cell = table.getCell(j, k);
                        RptCell eptCell = new RptCell(cell);
                        eptCell.setItemFormula(new ItemFormula());
                        eptCell.getItemFormula().putExt(BGFILLTYPE, BGFILLVALUETYPE_ELEMENT);
                        boolean isAttachFormula = eleColl.get(index % eleColl.size()).getDataType().getValue() != 5 && eleColl.get(index % eleColl.size()).getDataType().getValue() != 4;
                        eptCell.getItemFormula().putExt(ISATTACHFORMUAL, String.valueOf(isAttachFormula));
                        eptCell.getItemFormula().putExt(BGFILLVALUE, eleColl.get(index % eleColl.size()).getNumber());
                        if (cell == null) continue;
                        cell.setValue((Object)eleColl.get(index % eleColl.size()).getName());
                        cell.setUserObject((Object)eptCell);
                        ++index;
                    }
                } else if (block.getBeginCol() == block.getEndCol()) {
                    int index = 0;
                    int k = block.getBeginCol();
                    for (int j = block.getBeginRow(); j <= (eleColl.size() >= block.getEndRow() - block.getBeginRow() + 1 ? block.getBeginRow() + eleColl.size() - 1 : block.getEndRow()); ++j) {
                        ICell cell = table.getCell(j, k);
                        RptCell eptCell = new RptCell(cell);
                        eptCell.setItemFormula(new ItemFormula());
                        eptCell.getItemFormula().putExt(BGFILLTYPE, BGFILLVALUETYPE_ELEMENT);
                        boolean isAttachFormula = eleColl.get(index % eleColl.size()).getDataType().getValue() != 5 && eleColl.get(index % eleColl.size()).getDataType().getValue() != 4;
                        eptCell.getItemFormula().putExt(ISATTACHFORMUAL, String.valueOf(isAttachFormula));
                        eptCell.getItemFormula().putExt(BGFILLVALUE, eleColl.get(index % eleColl.size()).getNumber());
                        if (cell == null) continue;
                        cell.setValue((Object)eleColl.get(index % eleColl.size()).getName());
                        cell.setUserObject((Object)eptCell);
                        ++index;
                    }
                }
            }
        }
    }

    public static void showBgItem(IUIObject win, KDTable table, String orgUnitId, boolean isAutoCreateFormula, String srcBgPeriodNumber, String srcCurrencyNumber, Map itemFormulaMap) throws EASBizException, BOSException {
        block21: {
            KDTRange range = BgFillHelper.getSelectRange(win, table);
            UIContext uiContext = new UIContext((Object)win);
            uiContext.put((Object)"isSelectCombinItem", (Object)Boolean.FALSE);
            uiContext.put((Object)"ORGUNITID", (Object)orgUnitId);
            IUIWindow uiWindow = null;
            try {
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.ma.budget.client.NewBgItemGroupListF7UI", (Map)uiContext);
            }
            catch (UIException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
            NewBgItemGroupListF7UI f7ui = (NewBgItemGroupListF7UI)uiWindow.getUIObject();
            uiWindow.show();
            if (f7ui.getResult() == null || ((BgItemObject)f7ui.getResult()).getResult().size() == 0) break block21;
            int bgItemShowStyle = f7ui.BGITEM_WHOW_STYLE;
            boolean isFromForm = false;
            if (!(win instanceof BgTemplateProcessUI) && win instanceof BgProcessUI) {
                isFromForm = true;
            }
            BgItemCollection coll = ((BgItemObject)f7ui.getResult()).getResult();
            if (range.size() > 0) {
                KDTSelectBlock block = (KDTSelectBlock)range.get(0);
                if (block.getBeginRow() == block.getEndRow() && block.getBeginCol() != block.getEndCol()) {
                    int index = 0;
                    int j = block.getBeginRow();
                    for (int k = block.getBeginCol(); k <= (coll.size() >= block.getEndCol() - block.getBeginCol() + 1 ? block.getBeginCol() + coll.size() - 1 : block.getEndCol()); ++k) {
                        ICell cell = table.getCell(j, k);
                        RptCell eptCell = new RptCell(cell);
                        eptCell.setItemFormula(new ItemFormula());
                        eptCell.getItemFormula().putExt(BGFILLTYPE, BGFILLVALUETYPE_ITEM);
                        eptCell.getItemFormula().putExt(BGFILLVALUE, coll.get(index % coll.size()).getNumber());
                        eptCell.getItemFormula().putExt(BGFILLVALUE_ITEMID, coll.get(index % coll.size()).getId() == null ? "" : coll.get(index % coll.size()).getId().toString());
                        if (cell == null) continue;
                        if (bgItemShowStyle == 2) {
                            cell.setValue((Object)coll.get(index % coll.size()).getNumber());
                        } else if (bgItemShowStyle == 3) {
                            cell.setValue((Object)(coll.get(index % coll.size()).getNumber() + " " + coll.get(index % coll.size()).getName()));
                        } else {
                            cell.setValue((Object)coll.get(index % coll.size()).getName());
                        }
                        cell.setUserObject((Object)eptCell);
                        ++index;
                    }
                } else if (block.getBeginCol() == block.getEndCol()) {
                    int index = 0;
                    for (int j = block.getBeginRow(); j <= (coll.size() >= block.getEndRow() - block.getBeginRow() + 1 ? block.getBeginRow() + coll.size() - 1 : block.getEndRow()); ++j) {
                        int k = block.getBeginCol();
                        ICell cell = table.getCell(j, k);
                        RptCell eptCell = new RptCell(cell);
                        eptCell.setItemFormula(new ItemFormula());
                        eptCell.getItemFormula().putExt(BGFILLTYPE, BGFILLVALUETYPE_ITEM);
                        eptCell.getItemFormula().putExt(BGFILLVALUE, coll.get(index % coll.size()).getNumber());
                        eptCell.getItemFormula().putExt(BGFILLVALUE_ITEMID, coll.get(index % coll.size()).getId() == null ? "" : coll.get(index % coll.size()).getId().toString());
                        if (bgItemShowStyle == 2) {
                            cell.setValue((Object)coll.get(index % coll.size()).getNumber());
                        } else if (bgItemShowStyle == 3) {
                            cell.setValue((Object)(coll.get(index % coll.size()).getNumber() + " " + coll.get(index % coll.size()).getName()));
                        } else {
                            cell.setValue((Object)coll.get(index % coll.size()).getName());
                        }
                        cell.setUserObject((Object)eptCell);
                        if (BgParamCHelper.isFodian()) {
                            ICell cell1 = table.getCell(j, k + 1);
                            cell1.setValue((Object)coll.get(index % coll.size()).getSpecialNumber());
                            if (isAutoCreateFormula) {
                                String bgItemNumber = BgFillHelper.getBgCombinItemNumber(table, j, k + 2, BGFILLVALUETYPE_ITEM);
                                BgFillHelper.createItemFormulaFromContract(table, orgUnitId, j, k + 2, bgItemNumber, srcBgPeriodNumber, srcCurrencyNumber, isFromForm, itemFormulaMap);
                            }
                        } else if (isAutoCreateFormula) {
                            String bgItemNumber = BgFillHelper.getBgCombinItemNumber(table, j, k + 1, BGFILLVALUETYPE_ITEM);
                            BgFillHelper.createItemFormulaFromContract(table, orgUnitId, j, k + 1, bgItemNumber, srcBgPeriodNumber, srcCurrencyNumber, isFromForm, itemFormulaMap);
                        }
                        ++index;
                    }
                }
            }
        }
    }

    private static KDTRange getSelectRange(IUIObject win, KDTable table) {
        KDTSelectBlock block;
        KDTRange range = table.getSelectManager().toRange();
        if (range.size() > 1) {
            MsgBox.showWarning((Component)((Component)win), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"notSelectMulti"));
            SysUtil.abort();
        } else if (range.size() == 1 && (block = (KDTSelectBlock)range.get(0)).getBeginRow() != block.getEndRow() && block.getBeginCol() != block.getEndCol()) {
            MsgBox.showWarning((Component)((Component)win), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"selectSingle"));
            SysUtil.abort();
        }
        return range;
    }

    public static void showBgPeriod(IUIObject win, KDTable table) throws UIException {
        block8: {
            KDTRange range = BgFillHelper.getSelectRange(win, table);
            UIContext uiContext = new UIContext((Object)win);
            uiContext.put((Object)"bgPeriodEnum", null);
            uiContext.put((Object)"beginDate", null);
            uiContext.put((Object)"endDate", null);
            uiContext.put((Object)"isMultiSelect", (Object)Boolean.TRUE);
            IUIFactory uiFactory = null;
            IUIWindow uiWindow = null;
            try {
                uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
                uiWindow = uiFactory.create("com.kingdee.eas.ma.budget.client.BgPeriodF7UI", (Map)uiContext, null, OprtState.EDIT);
            }
            catch (UIException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
            uiWindow.show();
            BgPeriodF7UI f7ui = (BgPeriodF7UI)uiWindow.getUIObject();
            if (f7ui.getBgPeriodColl() == null || f7ui.getBgPeriodColl().size() <= 0) break block8;
            BgPeriodCollection coll = f7ui.getBgPeriodColl();
            if (range.size() > 0) {
                KDTSelectBlock block = (KDTSelectBlock)range.get(0);
                if (block.getBeginRow() == block.getEndRow() && block.getBeginCol() != block.getEndCol()) {
                    int index = 0;
                    int j = block.getBeginRow();
                    for (int k = block.getBeginCol(); k <= (coll.size() >= block.getEndCol() - block.getBeginCol() + 1 ? block.getBeginCol() + coll.size() - 1 : block.getEndCol()); ++k) {
                        ICell cell = table.getCell(j, k);
                        RptCell eptCell = new RptCell(cell);
                        eptCell.setItemFormula(new ItemFormula());
                        eptCell.getItemFormula().putExt(BGFILLTYPE, BGFILLVALUETYPE_PERIOD);
                        eptCell.getItemFormula().putExt(BGFILLVALUE, coll.get(index % coll.size()).getNumber());
                        if (cell == null) continue;
                        cell.setValue((Object)coll.get(index % coll.size()).getName());
                        cell.setUserObject((Object)eptCell);
                        ++index;
                    }
                } else if (block.getBeginCol() == block.getEndCol()) {
                    int index = 0;
                    int k = block.getBeginCol();
                    for (int j = block.getBeginRow(); j <= (coll.size() >= block.getEndRow() - block.getBeginRow() + 1 ? block.getBeginRow() + coll.size() - 1 : block.getEndRow()); ++j) {
                        ICell cell = table.getCell(j, k);
                        RptCell eptCell = new RptCell(cell);
                        eptCell.setItemFormula(new ItemFormula());
                        eptCell.getItemFormula().putExt(BGFILLTYPE, BGFILLVALUETYPE_PERIOD);
                        eptCell.getItemFormula().putExt(BGFILLVALUE, coll.get(index % coll.size()).getNumber());
                        if (cell == null) continue;
                        cell.setValue((Object)coll.get(index % coll.size()).getName());
                        cell.setUserObject((Object)eptCell);
                        ++index;
                    }
                }
            }
        }
    }

    public static void createItemFormula(KDTable table, String orgUnitId, IObjectValue value, Map itemFormulaMap, boolean isFromTemplate) throws BOSException, EASBizException {
        KDTRange range = table.getSelectManager().toRange();
        for (int i = 0; i < range.size(); ++i) {
            KDTSelectBlock block = (KDTSelectBlock)range.get(i);
            for (int j = block.getBeginRow(); j <= block.getEndRow(); ++j) {
                for (int k = block.getBeginCol(); k <= block.getEndCol(); ++k) {
                    ICell cell = table.getCell(j, k);
                    if (cell.getMergeBlock() != null || cell.getUserObject() != null && cell.getUserObject() instanceof RptCell && ((RptCell)cell.getUserObject()).getItemFormula() != null && ((RptCell)cell.getUserObject()).getItemFormula().getExt(BGFILLTYPE) != null || !BgFillHelper.checkFormulaOfCellIsHasEdit((RptCell)cell.getUserObject())) continue;
                    HashMap map = new HashMap();
                    BgFillHelper.initAllFormulaElement(table, cell, map);
                    BgFillHelper.subCreateItemFormula(table, map, cell, value, itemFormulaMap, isFromTemplate);
                }
            }
            BgClientHelper.dealWith((KDTable)table, (String)orgUnitId, null, (Map)itemFormulaMap, (boolean)isFromTemplate, (boolean)true);
        }
    }

    public static void createBgFormula(KDTable table, String orgUnitId, IObjectValue value, String formulaKind) throws BOSException, EASBizException {
        KDTSelectBlock block;
        int i;
        KDTRange range = table.getSelectManager().toRange();
        int num = range.size();
        if (num <= 0) {
            return;
        }
        boolean hasNotLock = false;
        for (i = 0; i < num; ++i) {
            block = (KDTSelectBlock)range.get(i);
            int xn = block.getEndRow();
            for (int x = block.getBeginRow(); x <= xn; ++x) {
                int yn = block.getEndCol();
                for (int y = block.getBeginCol(); y <= yn; ++y) {
                    ICell cell = table.getCell(x, y);
                    if (cell.getStyleAttributes().isLocked()) continue;
                    hasNotLock = true;
                }
            }
        }
        if (!hasNotLock) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"cellLock"));
            SysUtil.abort();
        }
        for (i = 0; i < range.size(); ++i) {
            block = (KDTSelectBlock)range.get(i);
            for (int j = block.getBeginRow(); j <= block.getEndRow(); ++j) {
                for (int k = block.getBeginCol(); k <= block.getEndCol(); ++k) {
                    HashMap map;
                    ICell cell = table.getCell(j, k);
                    if (cell.getMergeBlock() != null || cell.getUserObject() != null && cell.getUserObject() instanceof RptCell && ((RptCell)cell.getUserObject()).getItemFormula() != null && ((RptCell)cell.getUserObject()).getItemFormula().getExt(BGFILLTYPE) != null) continue;
                    if (value instanceof BgFormInfo) {
                        if (cell.getStyleAttributes().isLocked()) continue;
                        map = new HashMap();
                        BgFillHelper.initAllFormulaElement(table, cell, map);
                        BgFillHelper.subCreateBgFormula(map, cell, value, formulaKind);
                        continue;
                    }
                    map = new HashMap();
                    BgFillHelper.initAllFormulaElement(table, cell, map);
                    BgFillHelper.subCreateBgFormula(map, cell, value, formulaKind);
                }
            }
            BgClientHelper.dealWith((KDTable)table, (String)orgUnitId, null, null, (boolean)false, (boolean)false);
        }
    }

    public static void initAllFormulaElement(KDTable table, ICell cell, HashMap map) throws BOSException, EASBizException {
        KDTRange range = table.getSelectManager().toRange();
        for (int i = 0; i < range.size(); ++i) {
            KDTSelectBlock block = (KDTSelectBlock)range.get(i);
            BgFillHelper.initFormulaElement(table, cell, block, map, BGFILLVALUETYPE_ITEM);
            BgFillHelper.initFormulaElement(table, cell, block, map, BGFILLVALUETYPE_ELEMENT);
            BgFillHelper.initFormulaElement(table, cell, block, map, BGFILLVALUETYPE_PERIOD);
            BgFillHelper.initFormulaElement(table, cell, block, map, BGFILLVALUETYPE_CURRENCY);
        }
    }

    public static void subCreateItemFormula(KDTable table, HashMap map, ICell cell, IObjectValue value, Map itemFormulaMap, boolean isFromTemplate) {
        String currencyNumber;
        if (map.isEmpty()) {
            return;
        }
        boolean isBgForm = false;
        if (value instanceof BgFormInfo) {
            isBgForm = true;
        }
        if (!map.isEmpty() && map.get(ISATTACHFORMUAL) != null && map.get(ISATTACHFORMUAL).toString().equals("false")) {
            return;
        }
        RptCell eptCell = new RptCell(cell);
        String itemCombinStr = map.get(BGFILLVALUETYPE_ITEM) == null ? "" : map.get(BGFILLVALUETYPE_ITEM).toString();
        String bgPeriodNumber = map.get(BGFILLVALUETYPE_PERIOD) == null ? "" : map.get(BGFILLVALUETYPE_PERIOD).toString();
        String elementNumber = map.get(BGFILLVALUETYPE_ELEMENT) == null ? "" : map.get(BGFILLVALUETYPE_ELEMENT).toString();
        String string = currencyNumber = map.get(BGFILLVALUETYPE_CURRENCY) == null ? "" : map.get(BGFILLVALUETYPE_CURRENCY).toString();
        if (isBgForm) {
            BgFormInfo info = (BgFormInfo)value;
            bgPeriodNumber = bgPeriodNumber.equals("") ? info.getBgPeriod().getNumber() : bgPeriodNumber;
            currencyNumber = currencyNumber.equals("") ? info.getCurrency().getNumber() : currencyNumber;
        }
        String formulaLine = "=BgItem(\"" + itemCombinStr + "\",\"" + bgPeriodNumber + "\",\"" + elementNumber + "\",\"BgData\",true,\"" + currencyNumber + "\")";
        eptCell.setItemFormula(formulaLine);
        if (isFromTemplate) {
            itemFormulaMap.put(formulaLine, formulaLine);
        }
        eptCell.getItemFormula().putExt("BGITEM_CANUPDATE", "true");
        cell.setUserObject((Object)eptCell);
    }

    public static void subCreateBgFormula(HashMap map, ICell cell, IObjectValue value, String formulaKind) {
        if (map.isEmpty()) {
            return;
        }
        boolean isBgForm = false;
        if (value instanceof BgFormInfo) {
            isBgForm = true;
        }
        String itemCombinStr = map.get(BGFILLVALUETYPE_ITEM) == null ? "" : map.get(BGFILLVALUETYPE_ITEM).toString();
        String bgPeriodNumber = map.get(BGFILLVALUETYPE_PERIOD) == null ? "" : map.get(BGFILLVALUETYPE_PERIOD).toString();
        String elementNumber = map.get(BGFILLVALUETYPE_ELEMENT) == null ? "" : map.get(BGFILLVALUETYPE_ELEMENT).toString();
        String currencyNumber = map.get(BGFILLVALUETYPE_CURRENCY) == null ? "" : map.get(BGFILLVALUETYPE_CURRENCY).toString();
        String orgNumber = "";
        String bgSchemeNumber = "";
        if (isBgForm) {
            BgFormInfo info = (BgFormInfo)value;
            bgPeriodNumber = bgPeriodNumber.equals("") ? info.getBgPeriod().getNumber() : bgPeriodNumber;
            currencyNumber = currencyNumber.equals("") ? info.getCurrency().getNumber() : currencyNumber;
            orgNumber = info.getOrgUnit().getNumber();
            bgSchemeNumber = info.getBgScheme().getNumber();
        }
        cell.setExpressions("=" + formulaKind + "(\"" + orgNumber + "\",\"" + bgSchemeNumber + "\",\"" + elementNumber + "\", \"" + itemCombinStr + "\",\"" + currencyNumber + "\",\"" + bgPeriodNumber + "\",\"" + bgPeriodNumber + "\")");
    }

    public static void dealItemGroupIndex1(KDTable table, String orgUnitId, int beginRow, int endRow, int beginCol, int endCol) throws BOSException, EASBizException {
        IBgFormulaFacade iBgF = BgFormulaFacadeFactory.getRemoteInstance();
        Hashtable<String, String> map = new Hashtable<String, String>();
        for (int i = beginRow; i <= endRow; ++i) {
            for (int j = beginCol; j <= endCol; ++j) {
                RptCell rCell;
                String formula;
                List list;
                ICell cell = table.getCell(i, j);
                if (cell.getUserObject() == null || !(cell.getUserObject() instanceof RptCell) || ((RptCell)cell.getUserObject()).getItemFormulaLine() == null || (list = TableToolkit.parseFormula((String)(formula = (rCell = (RptCell)cell.getUserObject()).getItemFormulaLine()), (boolean)false)) == null || list.isEmpty()) continue;
                FormulaHint hint = (FormulaHint)list.get(0);
                String[] params = hint.getParams();
                String strItemCombi = params[0];
                String _strItemCombi = "";
                if (map.contains(strItemCombi)) {
                    _strItemCombi = (String)map.get(strItemCombi);
                    rCell.setItemFormula("=BgItem(\"" + _strItemCombi + "\",\"" + params[1] + "\",\"" + params[2] + "\",\"" + params[3] + "\"," + params[4] + ",\"" + params[5] + "\")");
                    continue;
                }
                _strItemCombi = iBgF.parseBgItemCombi(orgUnitId, strItemCombi);
                if (!strItemCombi.equals(_strItemCombi)) {
                    rCell.setItemFormula("=BgItem(\"" + _strItemCombi + "\",\"" + params[1] + "\",\"" + params[2] + "\",\"" + params[3] + "\"," + params[4] + ",\"" + params[5] + "\")");
                }
                map.put(strItemCombi, _strItemCombi);
            }
        }
    }

    public static void dealItemGroupIndexBgFormula1(KDTable table, String orgUnitId, int beginRow, int endRow, int beginCol, int endCol, String bgFormulaKind) throws BOSException, EASBizException {
        IBgFormulaFacade iBgF = BgFormulaFacadeFactory.getRemoteInstance();
        Hashtable<String, String> map = new Hashtable<String, String>();
        for (int i = beginRow; i <= endRow; ++i) {
            for (int j = beginCol; j <= endCol; ++j) {
                String formula;
                List list;
                ICell cell = table.getCell(i, j);
                if (cell.getExpressions() == null || (list = TableToolkit.parseFormula((String)(formula = cell.getExpressions()), (boolean)false)) == null || list.isEmpty()) continue;
                FormulaHint hint = (FormulaHint)list.get(0);
                if (!hint.name.equalsIgnoreCase(CMD_BGACTUALS) && !hint.name.equalsIgnoreCase(CMD_BGBAL) && !hint.name.equalsIgnoreCase(CMD_BGFORMULA)) continue;
                String[] params = hint.getParams();
                String strItemCombi = params[3];
                String _strItemCombi = "";
                if (map.contains(strItemCombi)) {
                    _strItemCombi = (String)map.get(strItemCombi);
                    cell.setExpressions("=" + bgFormulaKind + "(\"" + params[0] + "\",\"" + params[1] + "\",\"" + params[2] + "\",\"" + _strItemCombi + "\",\"" + params[4] + "\",\"" + params[5] + "\",\"" + params[6] + "\")");
                    continue;
                }
                _strItemCombi = iBgF.parseBgItemCombi(orgUnitId, strItemCombi);
                if (!strItemCombi.equals(_strItemCombi)) {
                    cell.setExpressions("=" + bgFormulaKind + "(\"" + params[0] + "\",\"" + params[1] + "\",\"" + params[2] + "\",\"" + _strItemCombi + "\",\"" + params[4] + "\",\"" + params[5] + "\",\"" + params[6] + "\")");
                }
                map.put(strItemCombi, _strItemCombi);
            }
        }
    }

    public static void initFormulaElement(KDTable table, ICell cell, KDTSelectBlock block, HashMap map, String elementType) {
        String tmpStr;
        int y;
        int x;
        KDTMergeBlock mergeBlock;
        ICell tmpCell;
        int m;
        int minRow = block.getBeginRow();
        int maxRow = block.getEndRow();
        int minCol = block.getBeginCol();
        int maxCol = block.getEndCol();
        int rowIndex = cell.getRowIndex();
        int colIndex = cell.getColumnIndex();
        boolean isInit = false;
        for (m = rowIndex - 1; m >= minRow; --m) {
            tmpCell = table.getCell(m, colIndex);
            if (tmpCell.getValue() == null && tmpCell.getUserObject() == null && tmpCell.getMergeBlock() != null) {
                mergeBlock = tmpCell.getMergeBlock();
                x = mergeBlock.getTop();
                y = mergeBlock.getLeft();
                tmpCell = table.getCell(x, y);
            }
            if (!BgFillHelper.isInBlock(tmpCell, block) || tmpCell.getUserObject() == null || !(tmpCell.getUserObject() instanceof RptCell) || ((RptCell)tmpCell.getUserObject()).getItemFormula() == null || ((RptCell)tmpCell.getUserObject()).getItemFormula().getExt(BGFILLTYPE) == null || !((RptCell)tmpCell.getUserObject()).getItemFormula().getExt(BGFILLTYPE).toString().equals(elementType)) continue;
            if (elementType.equals(BGFILLVALUETYPE_ELEMENT)) {
                map.put(ISATTACHFORMUAL, ((RptCell)tmpCell.getUserObject()).getItemFormula().getExt(ISATTACHFORMUAL));
            }
            if (elementType.equals(BGFILLVALUETYPE_ITEM)) {
                if (map.get(elementType) != null) {
                    tmpStr = map.get(elementType).toString();
                    map.put(elementType, tmpStr + "," + ((RptCell)tmpCell.getUserObject()).getItemFormula().getExt(BGFILLVALUE));
                    continue;
                }
                map.put(elementType, ((RptCell)tmpCell.getUserObject()).getItemFormula().getExt(BGFILLVALUE));
                continue;
            }
            map.put(elementType, ((RptCell)tmpCell.getUserObject()).getItemFormula().getExt(BGFILLVALUE));
            isInit = true;
            break;
        }
        if (!isInit) {
            for (m = rowIndex + 1; m <= maxRow; ++m) {
                tmpCell = table.getCell(m, colIndex);
                if (tmpCell.getValue() == null && tmpCell.getUserObject() == null && tmpCell.getMergeBlock() != null) {
                    mergeBlock = tmpCell.getMergeBlock();
                    x = mergeBlock.getTop();
                    y = mergeBlock.getLeft();
                    tmpCell = table.getCell(x, y);
                }
                if (!BgFillHelper.isInBlock(tmpCell, block) || tmpCell.getUserObject() == null || !(tmpCell.getUserObject() instanceof RptCell) || ((RptCell)tmpCell.getUserObject()).getItemFormula() == null || ((RptCell)tmpCell.getUserObject()).getItemFormula().getExt(BGFILLTYPE) == null || !((RptCell)tmpCell.getUserObject()).getItemFormula().getExt(BGFILLTYPE).toString().equals(elementType)) continue;
                if (elementType.equals(BGFILLVALUETYPE_ELEMENT)) {
                    map.put(ISATTACHFORMUAL, ((RptCell)tmpCell.getUserObject()).getItemFormula().getExt(ISATTACHFORMUAL));
                }
                if (elementType.equals(BGFILLVALUETYPE_ITEM)) {
                    if (map.get(elementType) != null) {
                        tmpStr = map.get(elementType).toString();
                        map.put(elementType, tmpStr + "," + ((RptCell)tmpCell.getUserObject()).getItemFormula().getExt(BGFILLVALUE));
                        continue;
                    }
                    map.put(elementType, ((RptCell)tmpCell.getUserObject()).getItemFormula().getExt(BGFILLVALUE));
                    continue;
                }
                map.put(elementType, ((RptCell)tmpCell.getUserObject()).getItemFormula().getExt(BGFILLVALUE));
                isInit = true;
                break;
            }
        }
        if (!isInit) {
            for (m = colIndex - 1; m >= minCol; --m) {
                tmpCell = table.getCell(rowIndex, m);
                if (tmpCell.getValue() == null && tmpCell.getUserObject() == null && tmpCell.getMergeBlock() != null) {
                    mergeBlock = tmpCell.getMergeBlock();
                    x = mergeBlock.getTop();
                    y = mergeBlock.getLeft();
                    tmpCell = table.getCell(x, y);
                }
                if (!BgFillHelper.isInBlock(tmpCell, block) || tmpCell.getUserObject() == null || !(tmpCell.getUserObject() instanceof RptCell) || ((RptCell)tmpCell.getUserObject()).getItemFormula() == null || ((RptCell)tmpCell.getUserObject()).getItemFormula().getExt(BGFILLTYPE) == null || !((RptCell)tmpCell.getUserObject()).getItemFormula().getExt(BGFILLTYPE).toString().equals(elementType)) continue;
                if (elementType.equals(BGFILLVALUETYPE_ELEMENT)) {
                    map.put(ISATTACHFORMUAL, ((RptCell)tmpCell.getUserObject()).getItemFormula().getExt(ISATTACHFORMUAL));
                }
                if (elementType.equals(BGFILLVALUETYPE_ITEM)) {
                    if (map.get(elementType) != null) {
                        tmpStr = map.get(elementType).toString();
                        map.put(elementType, tmpStr + "," + ((RptCell)tmpCell.getUserObject()).getItemFormula().getExt(BGFILLVALUE));
                        continue;
                    }
                    map.put(elementType, ((RptCell)tmpCell.getUserObject()).getItemFormula().getExt(BGFILLVALUE));
                    continue;
                }
                map.put(elementType, ((RptCell)tmpCell.getUserObject()).getItemFormula().getExt(BGFILLVALUE));
                isInit = true;
                break;
            }
        }
        if (!isInit) {
            for (m = colIndex + 1; m <= maxCol; ++m) {
                tmpCell = table.getCell(rowIndex, m);
                if (tmpCell.getValue() == null && tmpCell.getUserObject() == null && tmpCell.getMergeBlock() != null) {
                    mergeBlock = tmpCell.getMergeBlock();
                    x = mergeBlock.getTop();
                    y = mergeBlock.getLeft();
                    tmpCell = table.getCell(x, y);
                }
                if (!BgFillHelper.isInBlock(tmpCell, block) || tmpCell.getUserObject() == null || !(tmpCell.getUserObject() instanceof RptCell) || ((RptCell)tmpCell.getUserObject()).getItemFormula() == null || ((RptCell)tmpCell.getUserObject()).getItemFormula().getExt(BGFILLTYPE) == null || !((RptCell)tmpCell.getUserObject()).getItemFormula().getExt(BGFILLTYPE).toString().equals(elementType)) continue;
                if (elementType.equals(BGFILLVALUETYPE_ELEMENT)) {
                    map.put(ISATTACHFORMUAL, ((RptCell)tmpCell.getUserObject()).getItemFormula().getExt(ISATTACHFORMUAL));
                }
                if (elementType.equals(BGFILLVALUETYPE_ITEM)) {
                    if (map.get(elementType) != null) {
                        tmpStr = map.get(elementType).toString();
                        map.put(elementType, tmpStr + "," + ((RptCell)tmpCell.getUserObject()).getItemFormula().getExt(BGFILLVALUE));
                        continue;
                    }
                    map.put(elementType, ((RptCell)tmpCell.getUserObject()).getItemFormula().getExt(BGFILLVALUE));
                    continue;
                }
                map.put(elementType, ((RptCell)tmpCell.getUserObject()).getItemFormula().getExt(BGFILLVALUE));
                isInit = true;
                break;
            }
        }
    }

    public static boolean isInBlock(ICell cell, KDTSelectBlock block) {
        boolean result = false;
        int minRow = block.getBeginRow();
        int maxRow = block.getEndRow();
        int minCol = block.getBeginCol();
        int maxCol = block.getEndCol();
        int x = cell.getRowIndex();
        int y = cell.getColumnIndex();
        if (x >= minRow && x <= maxRow && y >= minCol && y <= maxCol) {
            result = true;
        }
        return result;
    }

    public static void initRowAndColUserObject(KDTable table) {
        HashMap aliMap = new HashMap();
        Map<String, BOSUuid> useMap = new HashMap();
        IRow row = null;
        IColumn column = null;
        ICell cell = null;
        boolean isClear = true;
        if (table.getUserObject() != null && table.getUserObject() instanceof HashMap && !(useMap = (Map)table.getUserObject()).containsKey("COLLECT_DATA_ID")) {
            useMap.put("COLLECT_DATA_ID", BOSUuid.create((String)VISUALBOSTYPE));
        }
        int in = table.getBody().size();
        for (int i = 0; i < in; ++i) {
            row = table.getRow(i);
            isClear = true;
            if (row == null) continue;
            int jn = table.getColumnCount();
            for (int j = 0; j < jn; ++j) {
                cell = row.getCell(j);
                if (cell == null || cell.getValue() == null && cell.getExpressions() == null && cell.getUserObject() == null) continue;
                if (row.getUserObject() != null && row.getUserObject() instanceof HashMap) {
                    useMap = (Map)row.getUserObject();
                    if (!useMap.containsKey("COLLECT_DATA_ID")) {
                        useMap.put("COLLECT_DATA_ID", BOSUuid.create((String)VISUALBOSTYPE));
                    }
                    if (!useMap.containsKey("COLLECT_DATA_SOURCE")) {
                        useMap.put("COLLECT_DATA_SOURCE", (BOSUuid)"COLLECT_SOURCE_EDIT");
                    }
                }
                aliMap.put(String.valueOf(j), null);
                isClear = false;
                break;
            }
            if (!isClear || row.getUserObject() == null) continue;
            row.setUserObject(null);
        }
        int jn = table.getColumnCount();
        for (int j = 0; j < jn; ++j) {
            column = table.getColumn(j);
            isClear = true;
            if (column == null) continue;
            if (aliMap.containsKey(String.valueOf(column.getColumnIndex()))) {
                if (column.getUserObject() == null || !(column.getUserObject() instanceof HashMap)) {
                    BgSHelper.setColObject(column, "COLLECT_DATA_ID", BOSUuid.create((String)VISUALBOSTYPE));
                    BgSHelper.setColObject(column, "COLLECT_DATA_SOURCE", "COLLECT_SOURCE_EDIT");
                } else {
                    useMap = (Map)column.getUserObject();
                    if (!useMap.containsKey("COLLECT_DATA_ID")) {
                        useMap.put("COLLECT_DATA_ID", BOSUuid.create((String)VISUALBOSTYPE));
                    }
                    if (!useMap.containsKey("COLLECT_DATA_SOURCE")) {
                        useMap.put("COLLECT_DATA_SOURCE", (BOSUuid)"COLLECT_SOURCE_EDIT");
                    }
                }
                isClear = false;
            } else {
                int in2 = table.getBody().size();
                for (int i = 0; i < in2; ++i) {
                    cell = table.getCell(i, j);
                    if (cell == null || cell.getValue() == null && cell.getExpressions() == null && cell.getUserObject() == null) continue;
                    if (column.getUserObject() == null || !(column.getUserObject() instanceof HashMap)) {
                        BgSHelper.setColObject(column, "COLLECT_DATA_ID", BOSUuid.create((String)VISUALBOSTYPE));
                        BgSHelper.setColObject(column, "COLLECT_DATA_SOURCE", "COLLECT_SOURCE_EDIT");
                    } else {
                        useMap = (Map)column.getUserObject();
                        if (!useMap.containsKey("COLLECT_DATA_ID")) {
                            useMap.put("COLLECT_DATA_ID", BOSUuid.create((String)VISUALBOSTYPE));
                        }
                        if (!useMap.containsKey("COLLECT_DATA_SOURCE")) {
                            useMap.put("COLLECT_DATA_SOURCE", (BOSUuid)"COLLECT_SOURCE_EDIT");
                        }
                    }
                    isClear = false;
                    break;
                }
            }
            if (!isClear || column.getUserObject() == null) continue;
            column.setUserObject(null);
        }
    }

    public static String[] parseStrFormulaToArray(String formula) {
        List list = new ArrayList();
        try {
            list = TableToolkit.parseFormula((String)formula, (boolean)false);
        }
        catch (ParserException e1) {
            return new String[0];
        }
        if (list == null || list.isEmpty()) {
            return new String[0];
        }
        FormulaHint hint = (FormulaHint)list.get(0);
        String[] params = hint.getParams();
        if (params.length == 4) {
            String[] pp = new String[]{params[0], params[1], params[2], "BgData", "true", params[3]};
            return pp;
        }
        return params;
    }

    public static String[] parseStrFormulaToArray(String formula, Vector formulaKind) {
        List list = new ArrayList();
        try {
            list = TableToolkit.parseFormula((String)formula, (boolean)false);
        }
        catch (ParserException e1) {
            return new String[0];
        }
        if (list == null || list.isEmpty()) {
            return new String[0];
        }
        FormulaHint hint = (FormulaHint)list.get(0);
        String formulaName = hint.name;
        boolean isExist = false;
        for (int i = 0; i < formulaKind.size(); ++i) {
            String string = (String)formulaKind.get(i);
        }
        String[] params = hint.getParams();
        return params;
    }

    public static void mutiUpdateBgItemFormula(IUIObject ui, KDTable table, String currentBgPeriodNumber) {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("Owner", ui);
        ctx.put("currentBgPeiodNumber", currentBgPeriodNumber);
        try {
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow messageDialog = uiFactory.create(ProjectFormulaUI.class.getName(), ctx);
            messageDialog.show();
        }
        catch (Exception e1) {
            ui.handUIException((Throwable)e1);
        }
        String formula = ProjectFormulaUI.getFormula();
        if (StringUtils.isEmpty((String)formula)) {
            return;
        }
        String[] newParamFormulaArray = BgFillHelper.parseStrFormulaToArray(formula);
        KDTRange range = table.getSelectManager().toRange();
        int num = range.size();
        if (num <= 0) {
            return;
        }
        for (int i = 0; i < num; ++i) {
            KDTSelectBlock block = (KDTSelectBlock)range.get(i);
            int _num = block.getEndRow();
            for (int j = block.getBeginRow(); j <= _num; ++j) {
                int __num = block.getEndCol();
                for (int k = block.getBeginCol(); k <= __num; ++k) {
                    ICell cell = table.getCell(j, k);
                    if (cell.getUserObject() == null || !(cell.getUserObject() instanceof RptCell)) continue;
                    RptCell rptCell = (RptCell)cell.getUserObject();
                    String tempFormula = ((RptCell)cell.getUserObject()).getItemFormulaLine();
                    if (tempFormula == null || !BgFillHelper.checkFormulaOfCellIsHasEdit(rptCell)) continue;
                    String[] oldParamFormulaArray = BgFillHelper.parseStrFormulaToArray(tempFormula);
                    if (oldParamFormulaArray.length == 0) {
                        return;
                    }
                    tempFormula = BgFillHelper.updateFormula(oldParamFormulaArray, newParamFormulaArray);
                    ((RptCell)cell.getUserObject()).setItemFormula(tempFormula);
                }
            }
        }
        ProjectFormulaUI.setFormula((String)"");
    }

    public static void mutiUpdateFormula(IUIObject ui, KDTable table) throws ParserException {
        KDTRange range = table.getSelectManager().toRange();
        int num = range.size();
        if (num <= 0) {
            return;
        }
        boolean hasNotLock = false;
        boolean hasExpress = false;
        for (int i = 0; i < num; ++i) {
            KDTSelectBlock block = (KDTSelectBlock)range.get(i);
            int xn = block.getEndRow();
            for (int x = block.getBeginRow(); x <= xn; ++x) {
                int yn = block.getEndCol();
                for (int y = block.getBeginCol(); y <= yn; ++y) {
                    ICell cell = table.getCell(x, y);
                    if (!BgFSHelper.checkHasExpressionsOfCell(cell)) continue;
                    hasExpress = true;
                    if (cell.getStyleAttributes().isLocked()) continue;
                    hasNotLock = true;
                }
            }
        }
        if (hasExpress && !hasNotLock) {
            MsgBox.showWarning((Component)((Component)ui), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"expressLock"));
            SysUtil.abort();
        }
        HashMap<String, IUIObject> ctx = new HashMap<String, IUIObject>();
        ctx.put("Owner", ui);
        IUIWindow messageDialog = null;
        try {
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            messageDialog = uiFactory.create(ProjectSameFormulaUI.class.getName(), ctx);
            messageDialog.show();
        }
        catch (UIException uiFactory) {
            // empty catch block
        }
        String formula = ((ProjectSameFormulaUI)messageDialog.getUIObject()).getFormula();
        Vector formulaKind = ((ProjectSameFormulaUI)messageDialog.getUIObject()).getFormulaKind();
        if (formula.equals("") || formulaKind.isEmpty()) {
            return;
        }
        String[] newParamFormulaArray = BgFillHelper.parseStrFormulaToArray(formula);
        for (int i = 0; i < num; ++i) {
            KDTSelectBlock block = (KDTSelectBlock)range.get(i);
            int _num = block.getEndRow();
            for (int j = block.getBeginRow(); j <= _num; ++j) {
                int __num = block.getEndCol();
                for (int k = block.getBeginCol(); k <= __num; ++k) {
                    String newFormual;
                    String tempFormula;
                    ICell cell = table.getCell(j, k);
                    if (cell.getExpressions() == null) continue;
                    if (ui instanceof BgProcessUI) {
                        if (cell.getStyleAttributes().isLocked()) continue;
                        tempFormula = cell.getExpressions();
                        try {
                            newFormual = BgFillHelper.dealWithExpression(tempFormula, newParamFormulaArray, formulaKind);
                            cell.setExpressions("=" + BgFillHelper.filterDupFormula(newFormual));
                        }
                        catch (ParserException e) {
                            MsgBox.showWarning((Component)((Component)ui), (String)(EASResource.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"inDataFormula") + EASResource.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"no") + (i + 1) + EASResource.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"row") + "\uff0c" + EASResource.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"no") + (j + 1) + EASResource.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"col") + ", " + EASResource.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"formulaError")));
                            SysUtil.abort();
                        }
                        continue;
                    }
                    tempFormula = cell.getExpressions();
                    try {
                        newFormual = BgFillHelper.dealWithExpression(tempFormula, newParamFormulaArray, formulaKind);
                        cell.setExpressions("=" + BgFillHelper.filterDupFormula(newFormual));
                        continue;
                    }
                    catch (ParserException e) {
                        MsgBox.showWarning((Component)((Component)ui), (String)(EASResource.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"inDataFormula") + EASResource.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"no") + (i + 1) + EASResource.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"row") + "\uff0c" + EASResource.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"no") + (j + 1) + EASResource.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"col") + ", " + EASResource.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"formulaError")));
                        SysUtil.abort();
                    }
                }
            }
        }
    }

    private static String dealWithExpression(String expression, String[] newParamFormulaArray, Vector formulaKind) throws ParserException {
        String newFormual = "";
        String[] bgFormualAry = BgFillHelper.splitExpression(expression);
        int size = bgFormualAry.length;
        for (int ii = 0; ii < size; ++ii) {
            String _formula = bgFormualAry[ii];
            _formula = _formula.charAt(0) == '=' ? "value" + _formula : "value=" + _formula;
            ExprStmt stmt = null;
            stmt = RptFormulaParser.parse((String)_formula);
            BinaryOpExpr expr = (BinaryOpExpr)stmt.expr;
            CodeExpr codeExpr = expr.right;
            BgFillHelper.subDealFormula(codeExpr, newParamFormulaArray, formulaKind);
            String result = "";
            if (codeExpr instanceof MethodInvokeExpr) {
                List params = ((MethodInvokeExpr)codeExpr).paramList;
                result = BgClientHelper.rebuildExpressionForm((String)params.get(0).toString(), (MethodInvokeExpr)((MethodInvokeExpr)codeExpr), null);
            }
            try {
                newFormual = result.equals("") ? newFormual + codeExpr.toString() : newFormual + result;
                if (ii == size - 1) continue;
                newFormual = newFormual + "+";
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return newFormual;
    }

    private static String[] splitExpression(String expression) {
        int index = expression.indexOf("+");
        if (index != -1) {
            String[] bgFormulaAry = expression.split("\\+");
            return bgFormulaAry;
        }
        return new String[]{expression};
    }

    public static void subDealFormula(CodeExpr codeExpr, String[] newParams, Vector formulaKind) {
        if (codeExpr instanceof BinaryOpExpr) {
            BinaryOpExpr bo = (BinaryOpExpr)codeExpr;
            BgFillHelper.subDealFormula(bo.left, newParams, formulaKind);
            BgFillHelper.subDealFormula(bo.right, newParams, formulaKind);
        } else if (codeExpr instanceof MethodInvokeExpr) {
            String funcName = ((MethodInvokeExpr)codeExpr).methodName;
            List params = ((MethodInvokeExpr)codeExpr).paramList;
            if (funcName != null) {
                for (int i = 0; i < formulaKind.size(); ++i) {
                    String temp = (String)formulaKind.get(i);
                    if (!funcName.equalsIgnoreCase(temp)) continue;
                    for (int j = 0; j < params.size(); ++j) {
                        CodeExpr param = (CodeExpr)params.get(j);
                        if (!(param instanceof StringExpr)) continue;
                        String str = ((StringExpr)param).text;
                        ((StringExpr)param).text = newParams[j].equals("") ? str : newParams[j];
                    }
                    break;
                }
            }
        }
    }

    public static String updateFormula(String[] oldArray, String[] newArray) {
        String[] param = new String[6];
        param = BgFillHelper.updateFormulaHelper(oldArray, newArray, param);
        String formulaTemplate = "=BgItem(\"" + param[0] + "\",\"" + param[1] + "\",\"" + param[2] + "\",\"" + param[3] + "\",true,\"" + param[5] + "\")";
        return formulaTemplate;
    }

    private static String filterDupFormula(String expression) {
        String[] formulaAry = expression.split("\\+");
        HashSet<String> filter = new HashSet<String>();
        int num = formulaAry.length;
        for (int i = 0; i < num; ++i) {
            filter.add(formulaAry[i]);
        }
        String result = "";
        Iterator itr = filter.iterator();
        while (itr.hasNext()) {
            result = result + itr.next().toString() + "+";
        }
        return result.substring(0, result.length() - 1);
    }

    public static String[] updateFormulaHelper(String[] oldArray, String[] newArray, String[] param) {
        int num = param.length;
        for (int i = 0; i < num; ++i) {
            param[i] = i == 3 || i == 4 ? oldArray[i] : (newArray[i].equals("") ? oldArray[i] : newArray[i]);
        }
        return param;
    }

    public static boolean checkFormulaOfCellIsHasEdit(RptCell rptCell) {
        if (rptCell == null) {
            return true;
        }
        boolean re = true;
        if (rptCell.getItemFormula() != null && rptCell.getItemFormula().getExt("BGITEM_CANUPDATE") == null) {
            rptCell.getItemFormula().putExt("BGITEM_CANUPDATE", "true");
            return true;
        }
        if (rptCell.getItemFormula() != null && rptCell.getItemFormula().getExt("BGITEM_CANUPDATE").equals("false")) {
            re = false;
        } else if (rptCell.getItemFormula() != null && rptCell.getItemFormula().getExt("BGITEM_CANUPDATE").equals("true")) {
            re = true;
        }
        return re;
    }

    public static String getBgItemNumber(KDTable table, int rowIndex, int colIndex) {
        String result = "";
        for (int m = colIndex - 1; m >= 0; --m) {
            ICell tmpCell = table.getCell(rowIndex, m);
            if (!(tmpCell.getUserObject() instanceof RptCell) || ((RptCell)tmpCell.getUserObject()).getItemFormula() == null || ((RptCell)tmpCell.getUserObject()).getItemFormula().getExt(BGFILLTYPE) == null || !((RptCell)tmpCell.getUserObject()).getItemFormula().getExt(BGFILLTYPE).toString().equals(BGFILLVALUETYPE_ITEM)) continue;
            result = ((RptCell)tmpCell.getUserObject()).getItemFormula().getExt(BGFILLVALUE) == null ? "" : ((RptCell)tmpCell.getUserObject()).getItemFormula().getExt(BGFILLVALUE);
            break;
        }
        return result;
    }

    public static String getBgCombinItemNumber(KDTable table, int rowIndex, int colIndex, String valueType) {
        String result = "";
        for (int m = colIndex - 1; m >= 0; --m) {
            ICell tmpCell = table.getCell(rowIndex, m);
            if (!(tmpCell.getUserObject() instanceof RptCell) || ((RptCell)tmpCell.getUserObject()).getItemFormula() == null || ((RptCell)tmpCell.getUserObject()).getItemFormula().getExt(BGFILLTYPE) == null || !((RptCell)tmpCell.getUserObject()).getItemFormula().getExt(BGFILLTYPE).toString().equals(valueType)) continue;
            result = result + (((RptCell)tmpCell.getUserObject()).getItemFormula().getExt(BGFILLVALUE) == null ? "" : ((RptCell)tmpCell.getUserObject()).getItemFormula().getExt(BGFILLVALUE)) + ",";
            if (!valueType.equals(BGFILLVALUETYPE_ITEM)) break;
        }
        result = result.substring(0, result.length() - 1);
        return result;
    }

    public static String getBgItemId(KDTable table, int rowIndex, int colIndex) {
        String result = "";
        for (int m = colIndex - 1; m >= 0; --m) {
            ICell tmpCell = table.getCell(rowIndex, m);
            if (!(tmpCell.getUserObject() instanceof RptCell) || ((RptCell)tmpCell.getUserObject()).getItemFormula() == null || ((RptCell)tmpCell.getUserObject()).getItemFormula().getExt(BGFILLTYPE) == null || !((RptCell)tmpCell.getUserObject()).getItemFormula().getExt(BGFILLTYPE).toString().equals(BGFILLVALUETYPE_ITEM)) continue;
            result = ((RptCell)tmpCell.getUserObject()).getItemFormula().getExt(BGFILLVALUE_ITEMID) == null ? "" : ((RptCell)tmpCell.getUserObject()).getItemFormula().getExt(BGFILLVALUE_ITEMID);
            break;
        }
        return result;
    }

    public static void createItemFormulaFromContract(KDTable table, String orgUnitId, int row, int col, String itemCombinStr, String srcBgPeriodNumber, String srcCurrencyNumber, boolean isFromForm, Map itemFormulaMap) throws EASBizException, BOSException {
        for (int i = col; i < table.getColumnCount(); ++i) {
            String itemCombinStr1;
            ICell cell;
            ICell tmpCell;
            int k;
            ICell tmpCell2;
            int k2;
            String result = null;
            String result1 = null;
            String result2 = null;
            String result3 = null;
            for (k2 = row - 1; k2 >= 0; --k2) {
                tmpCell2 = table.getCell(k2, i);
                if (!(tmpCell2.getUserObject() instanceof RptCell) || ((RptCell)tmpCell2.getUserObject()).getItemFormula() == null || ((RptCell)tmpCell2.getUserObject()).getItemFormula().getExt(BGFILLTYPE) == null || !((RptCell)tmpCell2.getUserObject()).getItemFormula().getExt(BGFILLTYPE).toString().equals(BGFILLVALUETYPE_PERIOD)) continue;
                result = ((RptCell)tmpCell2.getUserObject()).getItemFormula().getExt(BGFILLVALUE);
                break;
            }
            for (k2 = row - 1; k2 >= 0; --k2) {
                tmpCell2 = table.getCell(k2, i);
                if (!(tmpCell2.getUserObject() instanceof RptCell) || ((RptCell)tmpCell2.getUserObject()).getItemFormula() == null || ((RptCell)tmpCell2.getUserObject()).getItemFormula().getExt(BGFILLTYPE) == null || !((RptCell)tmpCell2.getUserObject()).getItemFormula().getExt(BGFILLTYPE).toString().equals(BGFILLVALUETYPE_ITEM)) continue;
                result3 = ((RptCell)tmpCell2.getUserObject()).getItemFormula().getExt(BGFILLVALUE);
                break;
            }
            boolean isContinue = false;
            for (k = row - 1; k >= 0; --k) {
                tmpCell = table.getCell(k, i);
                if (!(tmpCell.getUserObject() instanceof RptCell) || ((RptCell)tmpCell.getUserObject()).getItemFormula() == null || ((RptCell)tmpCell.getUserObject()).getItemFormula().getExt(BGFILLTYPE) == null || !((RptCell)tmpCell.getUserObject()).getItemFormula().getExt(BGFILLTYPE).toString().equals(BGFILLVALUETYPE_ELEMENT)) continue;
                result1 = ((RptCell)tmpCell.getUserObject()).getItemFormula().getExt(BGFILLVALUE);
                String trueStr = ((RptCell)tmpCell.getUserObject()).getItemFormula().getExt(ISATTACHFORMUAL);
                if (!trueStr.equals("false")) break;
                isContinue = true;
                break;
            }
            if (isContinue) continue;
            for (k = row - 1; k >= 0; --k) {
                tmpCell = table.getCell(k, i);
                if (!(tmpCell.getUserObject() instanceof RptCell) || ((RptCell)tmpCell.getUserObject()).getItemFormula() == null || ((RptCell)tmpCell.getUserObject()).getItemFormula().getExt(BGFILLTYPE) == null || !((RptCell)tmpCell.getUserObject()).getItemFormula().getExt(BGFILLTYPE).toString().equals(BGFILLVALUETYPE_CURRENCY)) continue;
                result2 = ((RptCell)tmpCell.getUserObject()).getItemFormula().getExt(BGFILLVALUE);
                break;
            }
            if (result == null && result1 == null && result2 == null || !BgFSHelper.checkCanUpdateOfCell(cell = table.getCell(row, i))) continue;
            RptCell eptCell = new RptCell(cell);
            String bgPeriodNumber = result == null ? "" : result.trim();
            String elementNumber = result1 == null ? "" : result1.trim();
            String currencyNumber = result2 == null ? "" : result2.trim();
            String string = itemCombinStr1 = result3 == null ? itemCombinStr : itemCombinStr + "," + result3.trim();
            if (isFromForm) {
                bgPeriodNumber = bgPeriodNumber.equals("") ? srcBgPeriodNumber : bgPeriodNumber;
                currencyNumber = currencyNumber.equals("") ? srcCurrencyNumber : currencyNumber;
            }
            String formulaLine = "=BgItem(\"" + itemCombinStr1 + "\",\"" + bgPeriodNumber + "\",\"" + elementNumber + "\",\"BgData\",true,\"" + currencyNumber + "\")";
            eptCell.setItemFormula(formulaLine);
            if (!isFromForm && itemFormulaMap != null) {
                itemFormulaMap.put(formulaLine, formulaLine);
            }
            eptCell.getItemFormula().putExt("BGITEM_CANUPDATE", "true");
            cell.setUserObject((Object)eptCell);
        }
        BgClientHelper.dealWith((KDTable)table, (String)orgUnitId, null, (Map)itemFormulaMap, (!isFromForm ? 1 : 0) != 0, (boolean)true);
    }

    public static void selectBgItem(IUIObject ui, KDTable table, String orgUnitId, String srcBgPeriodNumber, String srcCurrencyNumber, Map itemFormulaMap) throws EASBizException, BOSException {
        BgFillHelper.showBgItem(ui, table, orgUnitId, false, srcBgPeriodNumber, srcCurrencyNumber, itemFormulaMap);
        boolean isSelectItem = false;
        boolean isFromForm = false;
        if (isSelectItem) {
            KDTRange range = table.getSelectManager().toRange();
            for (int i = 0; i < range.size(); ++i) {
                KDTSelectBlock block = (KDTSelectBlock)range.get(i);
                for (int j = block.getBeginRow(); j <= block.getEndRow(); ++j) {
                    for (int k = block.getBeginCol(); k <= block.getEndCol(); ++k) {
                        for (int y = k + 1; y < table.getColumnCount(); ++y) {
                            ICell cell = table.getCell(j, y);
                            if (!(cell.getUserObject() instanceof RptCell) || ((RptCell)cell.getUserObject()).getItemFormula() == null || ((RptCell)cell.getUserObject()).getItemFormulaLine() == null) continue;
                            cell.setUserObject(null);
                        }
                        String bgItemNumber = BgFillHelper.getBgItemNumber(table, j, k + 1);
                        BgFillHelper.createItemFormulaFromContract(table, orgUnitId, j, k + 1, bgItemNumber, srcBgPeriodNumber, srcCurrencyNumber, isFromForm, itemFormulaMap);
                    }
                }
            }
        }
    }

    public static void createBgFormulaFromItemFormula(KDTable table, String orgUnitId, IObjectValue value, String formulaKind) throws BOSException, EASBizException {
        KDTSelectBlock block;
        int i;
        KDTRange range = table.getSelectManager().toRange();
        int num = range.size();
        if (num <= 0) {
            return;
        }
        boolean hasNotLock = false;
        for (i = 0; i < num; ++i) {
            block = (KDTSelectBlock)range.get(i);
            int xn = block.getEndRow();
            for (int x = block.getBeginRow(); x <= xn; ++x) {
                int yn = block.getEndCol();
                for (int y = block.getBeginCol(); y <= yn; ++y) {
                    ICell cell = table.getCell(x, y);
                    if (cell.getStyleAttributes().isLocked()) continue;
                    hasNotLock = true;
                }
            }
        }
        if (!hasNotLock) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"cellLock"));
            SysUtil.abort();
        }
        for (i = 0; i < range.size(); ++i) {
            block = (KDTSelectBlock)range.get(i);
            for (int j = block.getBeginRow(); j <= block.getEndRow(); ++j) {
                for (int k = block.getBeginCol(); k <= block.getEndCol(); ++k) {
                    ICell cell = table.getCell(j, k);
                    if (value instanceof BgFormInfo) {
                        if (cell.getStyleAttributes().isLocked()) continue;
                        BgFillHelper.subCreateBgFormulaFromItemFormula(cell, value, formulaKind);
                        continue;
                    }
                    BgFillHelper.subCreateBgFormulaFromItemFormula(cell, value, formulaKind);
                }
            }
            BgClientHelper.dealWith((KDTable)table, (String)orgUnitId, null, null, (boolean)false, (boolean)false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void subCreateBgFormulaFromItemFormula(ICell cell, IObjectValue value, String formulaKind) {
        if (cell == null) {
            return;
        }
        boolean isBgForm = false;
        if (value instanceof BgFormInfo) {
            isBgForm = true;
        }
        String itemCombinStr = "";
        String bgPeriodNumber = "";
        String elementNumber = "";
        String currencyNumber = "";
        String orgNumber = "";
        String bgSchemeNumber = "";
        if (cell.getUserObject() == null) return;
        if (!(cell.getUserObject() instanceof RptCell)) return;
        RptCell rCell = (RptCell)cell.getUserObject();
        String itemFormula = rCell.getItemFormulaLine();
        if (itemFormula == null || rCell.getItemFormula() == null) return;
        List list = new ArrayList();
        try {
            list = TableToolkit.parseFormula((String)itemFormula, (boolean)false);
        }
        catch (ParserException e1) {
            return;
        }
        if (list == null || list.isEmpty()) {
            return;
        }
        FormulaHint hint = (FormulaHint)list.get(0);
        String[] params = hint.getParams();
        if (params.length == 6 && hint.name.equalsIgnoreCase("BgItem")) {
            itemCombinStr = params[0] == null ? "" : params[0];
            bgPeriodNumber = params[1] == null ? "" : params[1];
            elementNumber = params[2] == null ? "" : params[2];
            currencyNumber = params[5] == null ? "" : params[5];
            orgNumber = "";
            bgSchemeNumber = "";
        }
        if (isBgForm) {
            BgFormInfo info = (BgFormInfo)value;
            bgPeriodNumber = bgPeriodNumber.equals("") ? info.getBgPeriod().getNumber() : bgPeriodNumber;
            currencyNumber = currencyNumber.equals("") ? info.getCurrency().getNumber() : currencyNumber;
            orgNumber = info.getOrgUnit().getNumber();
            bgSchemeNumber = info.getBgScheme().getNumber();
        }
        cell.setExpressions("=" + formulaKind + "(\"" + orgNumber + "\",\"" + bgSchemeNumber + "\",\"" + elementNumber + "\", \"" + itemCombinStr + "\",\"" + currencyNumber + "\",\"" + bgPeriodNumber + "\",\"" + bgPeriodNumber + "\")");
    }
}

