/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemException;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BgItemHelper {
    public static final String SUMITEMFORMULA = "SUMITEMFORMULA";
    public static final String SYS_IMPORT = "SYS_IMPORT";
    public static final String GZW_IMPORT = "GZW_IMPORT";
    public static final String ORGUNITID = "ORGUNITID";
    public static final String ELIMTYPE = "ELIMTYPE";
    public static final String BGITEM_IMPORT_RES = "com.kingdee.eas.ma.budget.BgImportItemResource";

    public static String transformSumFormula(String exp, String formulaStr, Map allFormulaPos) {
        if (StringUtils.isEmpty((String)exp) || StringUtils.isEmpty((String)formulaStr) || allFormulaPos == null || allFormulaPos.isEmpty()) {
            return null;
        }
        String resultExp = exp;
        Map itemNumbers = BgItemHelper.getItemNumbersFromSumFormula(exp);
        String item = null;
        String period = null;
        String element = null;
        String currency = null;
        String[] params = BgNFSHelper.parseFormulaPara(null, (String)formulaStr);
        if (params.length == 4) {
            item = params[0];
            period = params[1];
            element = params[2];
            currency = params[3];
        } else if (params.length == 6) {
            item = params[0];
            period = params[1];
            element = params[2];
            currency = params[5];
        }
        String formulaStr22 = null;
        String[] params2 = null;
        String item2 = null;
        String period2 = null;
        String element2 = null;
        String currency2 = null;
        String[] pos = null;
        for (String formulaStr22 : allFormulaPos.keySet()) {
            params2 = BgNFSHelper.parseFormulaPara(null, (String)formulaStr22);
            if (params2.length == 4) {
                item2 = params2[0];
                period2 = params2[1];
                element2 = params2[2];
                currency2 = params2[3];
            } else if (params2.length == 6) {
                item2 = params2[0];
                period2 = params2[1];
                element2 = params2[2];
                currency2 = params2[5];
            }
            if (!itemNumbers.containsKey(item2) || element == null || !element.equals(element2) || period == null || !period.equals(period2) || currency == null || !currency.equals(currency2) || allFormulaPos.get(formulaStr22) == null || (pos = ((String)allFormulaPos.get(formulaStr22)).split(",")) == null) continue;
            itemNumbers.put(item2, TableToolkit.xy2range((int)Integer.parseInt(pos[1]), (int)Integer.parseInt(pos[0])));
        }
        String _number2 = null;
        String _pos = null;
        String bgformulaExp = null;
        for (String _number2 : itemNumbers.keySet()) {
            _pos = (String)itemNumbers.get(_number2);
            if (_pos != null) {
                resultExp = resultExp.replaceFirst(_number2, _pos);
                continue;
            }
            bgformulaExp = "BgFormula(\"\",\"\",\"" + element + "\", \"" + _number2 + "\",\"" + currency + "\",\"" + period + "\",\"" + period + "\")";
            resultExp = resultExp.replaceFirst(_number2, bgformulaExp);
        }
        return resultExp;
    }

    public static Map getItemNumbersFromSumFormula(String exp) {
        if (StringUtils.isEmpty((String)exp)) {
            return null;
        }
        HashMap<String, Object> numbers = new HashMap<String, Object>();
        String regexp = "([\\(]*)([^\\+|^\\-|^\\*|^\\/|^\\(|^\\))]{1,})([\\+|\\-|\\*|\\/|\\(|\\)]*)";
        Pattern pt = Pattern.compile(regexp);
        Matcher matcher = pt.matcher(exp);
        while (matcher.find()) {
            String subItemNumber = matcher.group(2).trim();
            numbers.put(subItemNumber, null);
        }
        return numbers;
    }

    public static Map getFormulaPosFromBook(Book book) {
        Sheet sheet = book.getActiveSheet();
        Cell cell = null;
        HashMap<String, String> formulaPos = new HashMap<String, String>();
        int rowCount = sheet.getMaxRowIndex() + 1;
        int colCount = sheet.getMaxColIndex() + 1;
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            for (int colIndex = 0; colIndex < colCount; ++colIndex) {
                cell = sheet.getCell(rowIndex, colIndex, false);
                if (!BgNFSHelper.checkHasFormulaOfCell((Cell)cell)) continue;
                String formulaStr = BgNFSHelper.getFormulaOfCell((Cell)cell);
                formulaPos.put(formulaStr, rowIndex + "," + colIndex);
            }
        }
        return formulaPos;
    }

    public static String[] mapkey2Array(Map map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        String[] array = new String[map.keySet().size()];
        int i = 0;
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            array[i] = (String)it.next();
            ++i;
        }
        return array;
    }

    public static String mapkey2String(Map map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            sb.append("'").append(it.next()).append("',");
        }
        sb.delete(sb.length() - 1, sb.length());
        sb.append(")");
        return sb.toString();
    }

    public static String getSumFormulaFromChild(BgItemInfo itemInfo, BgItemCollection col) {
        if (itemInfo == null || col == null || col.isEmpty()) {
            return null;
        }
        String sumFormula = "";
        String itemType = itemInfo.getExtendedProperty("itemType");
        String direction = null;
        String childDirection = null;
        String itemId = itemInfo.getId().toString();
        BgItemInfo childInfo = null;
        if (itemType != null && itemType.equals("accountType")) {
            direction = itemInfo.getExtendedProperty("direction") == null ? "+" : itemInfo.getExtendedProperty("direction");
            Iterator it = col.iterator();
            while (it.hasNext()) {
                childInfo = (BgItemInfo)it.next();
                if (childInfo.getId().toString().equals(itemId) || !childInfo.getParent().getId().toString().equals(itemId)) continue;
                childDirection = childInfo.getExtendedProperty("direction");
                if (childDirection != null && childDirection.equals(direction)) {
                    sumFormula = sumFormula + "+" + childInfo.getNumber();
                    continue;
                }
                if (childDirection == null || childDirection.equals(direction)) continue;
                sumFormula = sumFormula + "-" + childInfo.getNumber();
            }
        } else {
            Iterator it = col.iterator();
            while (it.hasNext()) {
                childInfo = (BgItemInfo)it.next();
                if (childInfo.getId().toString().equals(itemId) || !childInfo.getParent().getId().toString().equals(itemId)) continue;
                sumFormula = sumFormula + "+" + childInfo.getNumber();
            }
        }
        if (sumFormula.startsWith("+")) {
            sumFormula = sumFormula.substring(1, sumFormula.length());
        }
        return sumFormula;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void checkBgItemExist(Context ctx, String orgUnitId, List checkList) throws EASBizException {
        if (!BgSHelper.isBgItemIsolate(ctx)) {
            orgUnitId = "00000000-0000-0000-0000-000000000000CCE7AED4";
        }
        if (StringUtils.isEmpty((String)orgUnitId)) return;
        if (checkList == null) return;
        if (checkList.isEmpty()) {
            return;
        }
        ArrayList notExistList = new ArrayList();
        notExistList.addAll(checkList);
        int pos = 0;
        int size = checkList.size();
        int batchSize = 200;
        int count = (size - 1) / batchSize + 1;
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT FNumber FROM T_BG_BGItem WHERE FOrgUnitID = ? AND FNumber IN(");
        for (int i = 1; i < batchSize; ++i) {
            sb.append("?,");
        }
        sb.append("?)");
        String number = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sb.toString());
            pstmt.setString(1, orgUnitId);
            for (int i = 0; i < count; ++i) {
                for (int j = 0; j < batchSize; ++j, ++pos) {
                    if (pos < size) {
                        pstmt.setString(j + 2, (String)checkList.get(pos));
                        continue;
                    }
                    pstmt.setString(j + 2, "#");
                }
                try {
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        number = rst.getString(1);
                        if (!notExistList.contains(number)) continue;
                        notExistList.remove(number);
                    }
                    continue;
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst);
                }
            }
            if (!notExistList.isEmpty()) {
                StringBuffer msg = new StringBuffer();
                int i2 = 0;
                while (true) {
                    if (i2 >= notExistList.size()) {
                        msg.delete(msg.length() - 1, msg.length());
                        throw new BgItemException(BgItemException.BGITEMNOTEXIST, new String[]{msg.toString()});
                    }
                    msg.append(notExistList.get(i2)).append(",");
                    ++i2;
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{e.getMessage()});
                catch (EASBizException ex) {
                    throw ex;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
    }

    public static void changeNumber(BgItemInfo bgItemInfo) {
        bgItemInfo.setNumber(BgItemHelper.changeNumber(bgItemInfo.getNumber()));
    }

    public static String changeNumber(String bgItemNumber) {
        if (bgItemNumber == null) {
            return bgItemNumber;
        }
        bgItemNumber = bgItemNumber.replaceAll("\\_", "*");
        bgItemNumber = bgItemNumber.replaceAll("\\|", "*");
        return bgItemNumber;
    }
}

