/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.ma.budget.BgActualRecordInfo;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.util.PropertyContainer;

public class BgRptReportPropertyAdapter
implements IReportPropertyAdapter {
    private static final long serialVersionUID = 2153051364296710294L;
    public static final String BG_COST_CENTER_NUMBER = "BgCostCenterNum";
    public static final String BG_PERIOD_TYPE = "BG_PERIOD_TYPE";
    public static final String BG_PERIOD_YEAR = "BG_PERIOD_YEAR";
    public static final String BG_PERIOD_MONTH = "BG_PERIOD_MONTH";
    public static final String BG_PERIOD_ID = "BG_PERIOD_ID";
    public static final String BG_PERIOD_NUMBER = "BG_PERIOD_NUMBER";
    public static final String BG_ORG_ID = "BG_ORG_ID";
    public static final String BG_FORM_ID = "BG_FORM_ID";
    public static final String BG_ORG_NUMBER = "BG_ORG_NUMBER";
    public static final String BG_ORG_NAME = "BG_ORG_NAME";
    public static final String BG_SCHEME_NUMBER = "BG_SCHEME_NUMBER";
    public static final String Bg_Begin_Date = "bg_begin_date";
    public static final String Bg_End_Date = "bg_end_date";
    public static final String Report_StartYear = "Report_StartYear";
    public static final String Report_EndYear = "Report_EndYear";
    public static final String Report_StartPeriod = "Report_StartPeriod";
    public static final String Report_EndPeriod = "Report_EndPeriod";
    public static final String Report_FormulaMap = "Report_FormulaMap";
    private PropertyContainer p;

    public BgRptReportPropertyAdapter() {
    }

    public BgRptReportPropertyAdapter(BgFormInfo report) {
        this.setProperties(report);
    }

    private void setProperties(BgFormInfo report) {
        FullOrgUnitInfo org;
        if (this.p == null) {
            this.p = new PropertyContainer();
        }
        if (report.getCompany() != null && report.getCompany().getId() != null) {
            this.p.setString("Company.Name", report.getCompany().getName());
            this.p.setString("Company.Number", report.getCompany().getNumber());
            this.p.setString("Company.ID", report.getCompany().getId().toString());
        }
        this.p.setString(BG_ORG_ID, (org = report.getOrgUnit()) == null ? "" : org.getId().toString());
        this.p.setString(BG_ORG_NUMBER, org == null ? "" : org.getNumber());
        this.p.setString(BG_ORG_NAME, org == null ? "" : org.getName());
        this.p.setString(BG_FORM_ID, report.getId() == null ? "" : report.getId().toString());
        if (report.getBgScheme() != null) {
            this.p.setString(BG_SCHEME_NUMBER, report.getBgScheme().getNumber());
        }
        if (BgNFSHelper.getFormulaMap((BgFormInfo)report) != null) {
            this.p.put(Report_FormulaMap, (Object)BgNFSHelper.getFormulaMap((BgFormInfo)report));
        }
        BgPeriodInfo period = report.getBgPeriod();
        if (report.getBgPeriod() != null) {
            if (report.getBgPeriod().getBeginDate() != null) {
                this.p.setString(Bg_Begin_Date, String.valueOf(report.getBgPeriod().getBeginDate()));
            }
            if (report.getBgPeriod().getEndDate() != null) {
                this.p.setString(Bg_End_Date, String.valueOf(report.getBgPeriod().getEndDate()));
            }
        }
        if (period != null) {
            String id = period.getId().toString();
            BgPeriodEnum periodType = period.getPeriodType();
            int year = period.getYear();
            int halfYear = period.getHalfYear();
            int month = period.getMonth();
            int quart = period.getQuarter();
            this.p.setString(BG_PERIOD_ID, id);
            this.p.setString(BG_PERIOD_NUMBER, period.getNumber());
            if (period.getPeriodType() != null) {
                this.p.setInt(BG_PERIOD_TYPE, period.getPeriodType().getValue());
                this.p.setInt(BG_PERIOD_YEAR, period.getYear());
            }
            if (periodType != null) {
                if (periodType.getValue() == 1) {
                    report.setPeriodType(RptPeriodTypeEnum.YEARLY);
                    report.setYear(year);
                    report.setPeriod((short)1);
                } else if (periodType.getValue() == 2) {
                    report.setPeriodType(RptPeriodTypeEnum.SEMIYEARLY);
                    report.setYear(year);
                    report.setPeriod((short)halfYear);
                    this.p.setInt(BG_PERIOD_MONTH, period.getHalfYear());
                } else if (periodType.getValue() == 3) {
                    report.setPeriodType(RptPeriodTypeEnum.QUARTERLY);
                    report.setYear(year);
                    report.setPeriod((short)quart);
                    this.p.setInt(BG_PERIOD_MONTH, period.getQuarter());
                } else if (periodType.getValue() == 4) {
                    report.setPeriodType(RptPeriodTypeEnum.MONTHLY);
                    report.setYear(year);
                    report.setPeriod((short)month);
                    this.p.setInt(BG_PERIOD_MONTH, period.getMonth());
                } else if (periodType.getValue() == 5 || periodType.getValue() == 6) {
                    report.setPeriodType(RptPeriodTypeEnum.MONTHLY);
                    report.setYear(year);
                    report.setPeriod((short)month);
                    this.p.setInt(BG_PERIOD_MONTH, period.getWeek());
                }
            }
        }
        this.p.setInt("Report.Year", report.getYear());
        this.p.setInt("Report.Period", (int)report.getPeriod());
        if (report.getCurrency() != null) {
            this.p.setString("Currency.Number", report.getCurrency().getNumber());
        }
        if (report.getLastUpdateUser() != null) {
            this.p.setString("LastUpdater.Name", report.getLastUpdateUser().getName());
        }
        this.p.setString("Report.Name", report.getName());
        if (report.getSourceType() != null) {
            this.p.setInt("Report.SourceType", report.getSourceType().getValue());
        }
        if (report.getCU() != null) {
            this.p.setString("CU.Name", report.getCU().getId().toString());
        }
        if (report.getCreator() != null) {
            this.p.setString("Creater.Name", report.getCreator().getName());
        }
        this.p.setDate("Report_StartDate", report.getStartDate());
        this.p.setDate("Report_EndDate", report.getEndDate());
        FullOrgUnitInfo costCenter = report.getOrgUnit();
        if (costCenter != null) {
            this.p.setString(BG_COST_CENTER_NUMBER, costCenter.getNumber());
        }
        if (report.getSheetParam() != null && report.getSheetParam().size() > 0) {
            this.p.setInt(Report_StartYear, report.getSheetParam().get(0).getStartYear());
            this.p.setInt(Report_StartPeriod, report.getSheetParam().get(0).getStartPeriod());
            this.p.setInt(Report_EndYear, report.getSheetParam().get(0).getEndYear());
            this.p.setInt(Report_EndPeriod, report.getSheetParam().get(0).getEndPeriod());
        }
        if (report.getPeriodType() != null) {
            this.p.setInt("PeriodType", report.getPeriodType().getValue());
        }
    }

    public Object getReportProperty(String name) {
        return this.p.get(name);
    }

    public void initReportProperties(IObjectValue vo, Context ctx) {
        if (vo instanceof BgFormInfo) {
            this.setProperties((BgFormInfo)vo);
        } else if (vo instanceof BgActualRecordInfo) {
            this.setProperties(((BgActualRecordInfo)vo).getBgForm());
        }
    }
}

