/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgFormDiversityData;
import com.kingdee.eas.ma.budget.BgFormPeriodData;
import com.kingdee.eas.ma.budget.BgFormPeriodFilterParam;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BgTransPeriodHelper {
    public static List getFormulaValueOfBook(Book book) {
        ArrayList<BgFormDiversityData> formulaList = new ArrayList<BgFormDiversityData>();
        if (book == null) {
            return formulaList;
        }
        Sheet _sheet = null;
        Cell _cell = null;
        BigDecimal _value = null;
        String _formulaStr = null;
        int rowCount = 0;
        int rowIndex = 0;
        int colCount = 0;
        int colIndex = 0;
        BgFormDiversityData divData = null;
        int sheetCount = book.getSheetCount();
        for (int index = 0; index < sheetCount; ++index) {
            _sheet = book.getSheet(index);
            rowCount = _sheet.getMaxRowIndex();
            colCount = _sheet.getMaxColIndex();
            for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    if (!BgNFSHelper.checkHasFormulaOfCell((Cell)_cell)) continue;
                    _formulaStr = BgNFSHelper.getFormulaOfCell((Cell)_cell);
                    if (BgNFSHelper.checkIsEmptyValue((Cell)_cell)) {
                        _value = BgNConstants.ZERO;
                    } else {
                        try {
                            _value = (BigDecimal)BgNFSHelper.getValue((Cell)_cell);
                        }
                        catch (Exception ex) {
                            _value = BgNConstants.ZERO;
                        }
                    }
                    divData = new BgFormDiversityData();
                    divData.setFormula(_formulaStr);
                    divData.setNewValue(_value);
                    formulaList.add(divData);
                }
            }
        }
        return formulaList;
    }

    public static void setFormulaValueOfBook(Book book, Object filterParam, Map valueMap, Map formulaMap) {
        if (valueMap == null || valueMap.isEmpty()) {
            return;
        }
        Sheet _sheet = null;
        Cell _cell = null;
        BgFormPeriodData data = null;
        BgPeriodInfo bgPeriodInfo = null;
        BigDecimal value = null;
        BigDecimal rateValue = null;
        String formulaString = null;
        String key = null;
        String[] formulaStr = null;
        int rowCount = 0;
        int rowIndex = 0;
        int colCount = 0;
        int colIndex = 0;
        List targetData = ((BgFormPeriodFilterParam)filterParam).getTargetData();
        int sheetCount = book.getSheetCount();
        for (int index = 0; index < sheetCount; ++index) {
            _sheet = book.getSheet(index);
            rowCount = _sheet.getMaxRowIndex();
            colCount = _sheet.getMaxColIndex();
            for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    if (!BgNFSHelper.checkHasFormulaOfCell((Cell)_cell) || (formulaStr = BgNFSHelper.parseFormulaPara((Map)formulaMap, (String)(formulaString = BgNFSHelper.getFormulaOfCell((Cell)_cell)))) == null) continue;
                    int in = targetData.size();
                    for (int i = 0; i < in; ++i) {
                        data = (BgFormPeriodData)targetData.get(i);
                        bgPeriodInfo = data.getBgPeriodInfo();
                        rateValue = data.getRateValue().divide(BgConstants.HUNDRED, 8, 4);
                        key = !StringUtils.isEmpty((String)formulaStr[0]) ? formulaStr[0] : "";
                        key = !StringUtils.isEmpty((String)formulaStr[2]) ? key + "_" + formulaStr[2] : key + "_";
                        key = !StringUtils.isEmpty((String)formulaStr[5]) ? key + "_" + formulaStr[5] : key + "_";
                        if (StringUtils.isEmpty((String)formulaStr[1]) || !formulaStr[1].equals(bgPeriodInfo.getNumber()) || !valueMap.containsKey(key)) continue;
                        value = (BigDecimal)valueMap.get(key);
                        value = value.multiply(rateValue);
                        BgTransPeriodHelper.setFormulaValueOfCell(_cell, value);
                    }
                }
            }
        }
    }

    private static void setFormulaValueOfCell(Cell cell, BigDecimal value) {
        if (cell != null && value != null) {
            BgNFSHelper.setValue((Cell)cell, (Object)value);
        }
    }
}

