/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.fi.rpt.batch.FormulaValueBackfill;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgValueBatchCalculater {
    private static final Logger logger = Logger.getLogger((String)BgValueBatchCalculater.class.getName());
    private Map formulasMap = null;
    private Map orgMap = null;
    private Map schemeMap = null;
    private BgPeriodCollection periodColl = null;
    private Context ctx;

    public BgValueBatchCalculater(Context ctx) {
        this.ctx = ctx;
    }

    public void execute(SortedParameterArray params) {
        this.formulasMap = new HashMap(params.size());
        try {
            this.preProcessParam(params);
            logger.info((Object)("invoke getBgDataParamList strat = " + new Timestamp(System.currentTimeMillis())));
            List bgDataParamList = this.getBgDataParamList(this.formulasMap);
            logger.info((Object)("invoke getBgDataParamList end = " + new Timestamp(System.currentTimeMillis())));
            String bgValueTblName = "T_Bg_BgData";
            String bgAdjValueTblName = "T_Bg_BgTmpData";
            HashMap bgDataMap = new HashMap();
            HashMap bgAdjDataMap = new HashMap();
            int len = 500;
            int size = bgDataParamList.size();
            int mod = size % len == 0 ? 0 : 1;
            int beginIndex = 0;
            int endIndex = 0;
            for (int i = 0; i < size / len + mod; ++i) {
                beginIndex = i * len;
                endIndex = (i + 1) * len - 1;
                if (endIndex > size - 1) {
                    endIndex = size - 1;
                }
                logger.info((Object)("invoke buildBgDataMap strat = " + new Timestamp(System.currentTimeMillis()) + " beginIndex = " + beginIndex + " endIndex = " + endIndex));
                this.buildBgDataMap(bgValueTblName, bgDataParamList, beginIndex, endIndex, bgDataMap);
                logger.info((Object)("invoke buildBgDataMap end = " + new Timestamp(System.currentTimeMillis()) + " beginIndex = " + beginIndex + " endIndex = " + endIndex));
                logger.info((Object)("invoke buildBgAdjDataMap strat = " + new Timestamp(System.currentTimeMillis()) + " beginIndex = " + beginIndex + " endIndex = " + endIndex));
                this.buildBgDataMap(bgAdjValueTblName, bgDataParamList, beginIndex, endIndex, bgAdjDataMap);
                logger.info((Object)("invoke buildBgAdjDataMap end = " + new Timestamp(System.currentTimeMillis()) + " beginIndex = " + beginIndex + " endIndex = " + endIndex));
            }
            logger.info((Object)("invoke exportData strat = " + new Timestamp(System.currentTimeMillis())));
            this.exportData(bgDataMap, bgAdjDataMap);
            logger.info((Object)("invoke exportData end = " + new Timestamp(System.currentTimeMillis())));
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
            for (int i = 0; i < params.size(); ++i) {
                params.getParameter(i).setValue((Object)("#BAD FUNCTION " + e.getMessage()));
            }
        }
        logger.info((Object)"invoke bgValueBatch finished!");
    }

    private void preProcessParam(SortedParameterArray params) {
        for (int i = 0; i < params.size(); ++i) {
            BgFormula bgFormula = new BgFormula(params.getParameter(i));
            String key = bgFormula.toString();
            ArrayList<BgFormula> list = (ArrayList<BgFormula>)this.formulasMap.get(key);
            if (list == null) {
                list = new ArrayList<BgFormula>(2);
                this.formulasMap.put(key, list);
            }
            list.add(bgFormula);
        }
    }

    private void buildBgDataMap(String tblName, List bgDataParamList, int beginIndex, int endIndex, Map bgDataMap) throws BOSException {
        StringBuffer sql = new StringBuffer();
        if (tblName.equalsIgnoreCase("t_bg_bgtmpdata")) {
            sql.append("SELECT FBgbalance FBgValue, FOrgUnitId, FBgSchemeId, FFormula FROM ").append(tblName).append("  WHERE ");
        } else {
            sql.append("SELECT FBgValue, FOrgUnitId, FBgSchemeId, FFormula FROM ").append(tblName).append("  WHERE ");
        }
        int num = 0;
        for (int i = beginIndex; i <= endIndex; ++i) {
            if (num > 0) {
                sql.append(" OR ");
            }
            ++num;
            sql.append(" (FOrgUnitId = ? AND FBgSchemeId = ? AND FFormula = ? )");
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)this.ctx);
            pstmt = conn.prepareStatement(sql.toString());
            BgDataParam dataParam = null;
            int index = 0;
            for (int i = beginIndex; i <= endIndex; ++i) {
                dataParam = (BgDataParam)bgDataParamList.get(i);
                pstmt.setString(index * 3 + 1, dataParam.orgId);
                pstmt.setString(index * 3 + 2, dataParam.schemeId);
                pstmt.setString(index * 3 + 3, dataParam.formula);
                ++index;
            }
            rs = pstmt.executeQuery();
            String orgId = null;
            String schemeId = null;
            String formula = null;
            String key = null;
            while (rs.next()) {
                orgId = rs.getString("FOrgUnitId");
                schemeId = rs.getString("FBgSchemeId");
                formula = rs.getString("FFormula");
                key = orgId + "_" + schemeId + "_" + formula;
                bgDataMap.put(key, rs.getBigDecimal("FBgValue"));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"budget error:", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
    }

    private List getBgDataParamList(Map formulasMap) throws BOSException {
        ArrayList<BgDataParam> list = new ArrayList<BgDataParam>();
        BgDataParam bgDataParam = null;
        String orgId = null;
        String schemeId = null;
        String[] formulas = null;
        for (Map.Entry entry : formulasMap.entrySet()) {
            List l = (List)entry.getValue();
            for (int k = 0; k < l.size(); ++k) {
                BgFormula bgFormula = (BgFormula)l.get(k);
                bgFormula.parser();
                orgId = bgFormula.orgId;
                schemeId = bgFormula.schemeId;
                formulas = bgFormula.formulas;
                for (int i = 0; i < formulas.length; ++i) {
                    bgDataParam = new BgDataParam(orgId, schemeId, formulas[i]);
                    if (list.contains(bgDataParam)) continue;
                    list.add(bgDataParam);
                }
            }
        }
        return list;
    }

    private void exportData(Map bgDataMap, Map bgAdjDataMap) {
        String key2 = null;
        BigDecimal bgValue = FMConstants.ZERO;
        for (String key2 : bgDataMap.keySet()) {
            bgValue = (BigDecimal)bgDataMap.get(key2);
            if (bgAdjDataMap.containsKey(key2)) {
                bgValue = bgValue.add((BigDecimal)bgAdjDataMap.get(key2));
            }
            bgDataMap.put(key2, bgValue);
        }
        BgFormula bgFormula = null;
        for (Map.Entry entry : this.formulasMap.entrySet()) {
            List list = (List)entry.getValue();
            for (int j = 0; j < list.size(); ++j) {
                bgFormula = (BgFormula)list.get(j);
                bgValue = FMConstants.ZERO;
                for (int i = 0; i < bgFormula.formulas.length; ++i) {
                    key2 = bgFormula.orgId + "_" + bgFormula.schemeId + "_" + bgFormula.formulas[i];
                    bgValue = bgDataMap.containsKey(key2) ? bgValue.add((BigDecimal)bgDataMap.get(key2)) : bgValue.add(FMConstants.ZERO);
                }
                bgFormula.formulaValue.setValue((Object)bgValue);
            }
        }
    }

    private String getOrgId(String orgNum) throws BOSException {
        if (this.orgMap == null) {
            this.orgMap = this.getOrgMap();
        }
        return (String)this.orgMap.get(orgNum);
    }

    private Map getOrgMap() throws BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        String sql = "SELECT FID, FNumber FROM T_Org_BaseUnit ";
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
        try {
            while (rs.next()) {
                map.put(rs.getString("FNumber"), rs.getString("FID"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)"budget error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    private String getSchemeId(String orgNum, String schemeNum) throws BOSException {
        if (this.schemeMap == null) {
            this.schemeMap = this.getSchemeMap();
        }
        String key = orgNum + "_" + schemeNum;
        return (String)this.schemeMap.get(key);
    }

    private Map getSchemeMap() throws BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT b.FNumber orgNum, a.FNumber schemeNum, a.FID schemeID ").append(" FROM T_Bg_BgScheme a JOIN T_Org_BaseUnit b ON a.FOrgUnitID = b.FID");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        try {
            String key = null;
            while (rs.next()) {
                key = rs.getString("orgNum") + "_" + rs.getString("schemeNum");
                map.put(key, rs.getString("schemeID"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)"budget error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    private BgPeriodCollection getPeriodColl(String beginPeriodNum, String endPeriodNum) throws BOSException {
        if (this.periodColl == null) {
            EntityViewInfo evi = new EntityViewInfo();
            SorterItemCollection sic = evi.getSorter();
            sic.add(new SorterItemInfo("number"));
            IBgPeriod iBgPeriod = BgPeriodFactory.getLocalInstance(this.ctx);
            this.periodColl = iBgPeriod.getBgPeriodCollection(evi);
        }
        BgPeriodCollection coll = new BgPeriodCollection();
        BgPeriodInfo info = null;
        boolean isInclude = false;
        boolean isEnd = false;
        int size = this.periodColl.size();
        for (int i = 0; i < size; ++i) {
            info = this.periodColl.get(i);
            if (beginPeriodNum.equals(info.getNumber())) {
                isInclude = true;
            }
            if (endPeriodNum.equals(info.getNumber())) {
                isEnd = true;
            }
            if (isInclude) {
                coll.add(info);
            }
            if (isEnd) break;
        }
        return coll;
    }

    private class BgFormula {
        String orgNum;
        String schemeNum;
        String elementNum;
        String bgItemNum;
        String currencyNum;
        String beginPeriodNum;
        String endPeriodNum;
        String reportNumber;
        String companyNumber;
        String orgId;
        String schemeId;
        String[] formulas;
        FormulaValueBackfill formulaValue;

        public BgFormula(Parameter param) {
            Object[] params = param.getArgs();
            this.initBgFormula((String)((Variant)params[0]).getValue(), (String)((Variant)params[1]).getValue(), (String)((Variant)params[2]).getValue(), (String)((Variant)params[3]).getValue(), (String)((Variant)params[4]).getValue(), (String)((Variant)params[5]).getValue(), (String)((Variant)params[6]).getValue());
            this.formulaValue = new FormulaValueBackfill(param);
            this.formulaValue.setValue((Object)"");
        }

        private void initBgFormula(String orgNum, String schemeNum, String elementNum, String bgItemNum, String currencyNum, String beginPeriodNum, String endPeriodNum) {
            this.orgNum = orgNum;
            this.schemeNum = schemeNum;
            this.elementNum = elementNum;
            this.bgItemNum = bgItemNum;
            this.currencyNum = currencyNum;
            this.beginPeriodNum = beginPeriodNum;
            this.endPeriodNum = endPeriodNum;
        }

        public void parser() throws BOSException {
            BgPeriodCollection periodColl = BgValueBatchCalculater.this.getPeriodColl(this.beginPeriodNum, this.endPeriodNum);
            int size = periodColl.size();
            this.formulas = new String[size];
            for (int i = 0; i < size; ++i) {
                this.formulas[i] = "=BgItem(\"" + this.bgItemNum + "\",\"" + periodColl.get(i).getNumber() + "\",\"" + this.elementNum + "\",\"BgData\",true,\"" + this.currencyNum + "\")";
            }
            this.orgId = BgValueBatchCalculater.this.getOrgId(this.orgNum);
            this.schemeId = BgValueBatchCalculater.this.getSchemeId(this.orgNum, this.schemeNum);
        }

        public String toString() {
            return this.orgNum + "_" + this.schemeNum + "_" + this.elementNum + "_" + this.bgItemNum + "_" + this.currencyNum + "_" + this.beginPeriodNum + "_" + this.endPeriodNum;
        }

        boolean isFull() {
            return true;
        }
    }

    private class BgDataParam {
        String orgId;
        String schemeId;
        String formula;

        public BgDataParam(String orgId, String schemeId, String formula) {
            this.orgId = orgId;
            this.schemeId = schemeId;
            this.formula = formula;
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

