/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public final class BookHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.BookHelper");

    public static Book getNewBook() {
        return Book.Manager.getNewBook();
    }

    public static Book getNewBook(String bookName, int sheetSize) {
        return Book.Manager.getNewBook((String)bookName, (int)sheetSize);
    }

    public static Book clone(Book book) {
        if (book == null) {
            return BookHelper.getNewBook();
        }
        Book _book = null;
        Sheet sheet = null;
        Sheet _sheet = null;
        Cell cell = null;
        Cell _cell = null;
        _book = BookHelper.getNewBook(book.getName(), book.getSheetCount());
        BgNFSHelper.disableCal((Book)_book);
        BgNFSHelper.disableUndo((Book)_book);
        int count = book.getSheetCount();
        for (int index = 0; index < count; ++index) {
            sheet = book.getSheet(index);
            _sheet = _book.getSheet(index);
            int rowCount = sheet.getMaxRowIndex();
            int colCount = sheet.getMaxColIndex();
            for (int rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                    cell = sheet.getCell(rowIndex, colIndex, false);
                    if (cell == null) continue;
                    _cell = _sheet.getCell(rowIndex, colIndex, true);
                    if (cell.hasFormula()) {
                        _cell.setFormula(cell.getFormula());
                    }
                    if (_cell.getValue() == Variant.nullVariant) continue;
                    _cell.setValue(cell.getValue());
                }
            }
        }
        return _book;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Book deepClone(Book book) {
        if (book == null) {
            return BookHelper.getNewBook();
        }
        Book _book = null;
        byte[] _byte = null;
        try {
            _byte = IOHelper.packBook((Book)book);
            _book = IOHelper.unpackBook((byte[])_byte);
        }
        catch (Exception ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
        }
        finally {
            _byte = null;
        }
        if (_book == null) {
            _book = BookHelper.getNewBook();
        }
        return _book;
    }

    public static void copyBook(Book fromBook, Book toBook, int VIEW_MODE) {
        if (fromBook == null || toBook == null) {
            return;
        }
        Sheet _fromSheet = null;
        Sheet _toSheet = null;
        Cell _fromCell = null;
        Cell _toCell = null;
        String _expression = null;
        BgNFSHelper.disableCal((Book)toBook);
        BgNFSHelper.disableUndo((Book)toBook);
        int count = fromBook.getSheetCount();
        for (int index = 0; index < count; ++index) {
            _fromSheet = fromBook.getSheet(index);
            _toSheet = toBook.getSheet(index);
            int rowCount = _fromSheet.getMaxRowIndex();
            int colCount = _fromSheet.getMaxColIndex();
            for (int rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _fromCell = _fromSheet.getCell(rowIndex, colIndex, false);
                    _expression = BgNFSHelper.loadExpression((Cell)_fromCell, (int)VIEW_MODE);
                    if (!StringUtils.isEmpty((String)_expression)) {
                        _toCell = _toSheet.getCell(rowIndex, colIndex, true);
                        _toCell.setFormula(_expression);
                        if (_toCell.getValue() == Variant.nullVariant) continue;
                        _toCell.setValue(_toCell.getValue());
                        continue;
                    }
                    _toCell = _toSheet.getCell(rowIndex, colIndex, false);
                    if (_toCell == null) continue;
                    _toCell.setFormula(null);
                    if (_toCell.getValue() == Variant.nullVariant) continue;
                    _toCell.setValue(_toCell.getValue());
                }
            }
        }
    }

    public static void pauseBook(Book fromBook, Book toBook, int VIEW_MODE) {
        if (fromBook == null || toBook == null) {
            return;
        }
        Sheet _fromSheet = null;
        Sheet _toSheet = null;
        Cell _fromCell = null;
        Cell _toCell = null;
        String _expression = null;
        int count = toBook.getSheetCount();
        for (int index = 0; index < count; ++index) {
            _toSheet = toBook.getSheet(index);
            _fromSheet = fromBook.getSheet(index);
            int rowCount = _toSheet.getMaxRowIndex();
            int colCount = _toSheet.getMaxColIndex();
            for (int rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _fromCell = _fromSheet.getCell(rowIndex, colIndex, false);
                    if (!BgNFSHelper.checkHasExpression((Cell)_fromCell) || StringUtils.isEmpty((String)(_expression = BgNFSHelper.getExpression((Cell)_fromCell)))) continue;
                    _toCell = _toSheet.getCell(rowIndex, colIndex, true);
                    BgNFSHelper.saveExpression((Cell)_toCell, (String)_expression, (int)VIEW_MODE);
                }
            }
        }
    }

    public static Sheet clone(Sheet sheet) {
        if (sheet == null) {
            return null;
        }
        Sheet _sheet = null;
        Cell cell = null;
        Cell _cell = null;
        _sheet = new Sheet(sheet.getBook(), sheet.getSheetName());
        int rowCount = sheet.getMaxRowIndex();
        int colCount = sheet.getMaxColIndex();
        for (int rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
            for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                cell = sheet.getCell(rowIndex, colIndex, false);
                if (cell == null) continue;
                _cell = _sheet.getCell(rowIndex, colIndex, true);
                if (cell.hasFormula()) {
                    _cell.setFormula(cell.getFormula());
                }
                if (_cell.getValue() == Variant.nullVariant) continue;
                _cell.setValue(cell.getValue());
            }
        }
        return _sheet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Sheet deepClone(Sheet sheet) {
        if (sheet == null) {
            return null;
        }
        Book book = sheet.getBook();
        Book _book = null;
        byte[] _byte = null;
        try {
            _byte = IOHelper.packBook((Book)book);
            _book = IOHelper.unpackBook((byte[])_byte);
        }
        catch (Exception ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
        }
        finally {
            _byte = null;
        }
        if (_book == null) {
            return null;
        }
        return _book.getSheet(sheet.getID());
    }

    public static void copySheet(Sheet _fromSheet, Sheet _toSheet, int VIEW_MODE) {
        if (_fromSheet == null || _toSheet == null) {
            return;
        }
        Cell _fromCell = null;
        Cell _toCell = null;
        String _expression = null;
        int rowCount = _fromSheet.getMaxRowIndex();
        int colCount = _fromSheet.getMaxColIndex();
        BgNFSHelper.disableCal((Book)_toSheet.getBook());
        BgNFSHelper.disableUndo((Book)_toSheet.getBook());
        for (int rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
            for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                _fromCell = _fromSheet.getCell(rowIndex, colIndex, false);
                if (!BgNFSHelper.checkHasFormulaOfCell((Cell)_fromCell)) continue;
                _toCell = _toSheet.getCell(rowIndex, colIndex, true);
                _expression = BgNFSHelper.loadExpression((Cell)_fromCell, (int)VIEW_MODE);
                if (StringUtils.isEmpty((String)_expression)) continue;
                _toCell.setFormula(_expression);
                if (_toCell.getValue() == Variant.nullVariant) continue;
                _toCell.setValue(_toCell.getValue());
            }
        }
    }

    public static void pauseSheet(Sheet _fromSheet, Sheet _toSheet, int VIEW_MODE) {
        if (_fromSheet == null || _toSheet == null) {
            return;
        }
        Cell _fromCell = null;
        Cell _toCell = null;
        String _expression = null;
        int rowCount = _toSheet.getMaxRowIndex();
        int colCount = _toSheet.getMaxColIndex();
        for (int rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
            for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                _toCell = _toSheet.getCell(rowIndex, colIndex, false);
                if (!BgNFSHelper.checkHasFormulaOfCell((Cell)_toCell) || StringUtils.isEmpty((String)(_expression = BgNFSHelper.loadExpression((Cell)(_fromCell = _fromSheet.getCell(rowIndex, colIndex, false)), (int)VIEW_MODE)))) continue;
                BgNFSHelper.saveExpression((Cell)_toCell, (String)_expression, (int)VIEW_MODE);
            }
        }
    }
}

