/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.appframework.databinding.BindingUtility;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.ma.budget.BgControlMultiRuleCollection;
import com.kingdee.eas.ma.budget.BgControlMultiRuleInfo;
import com.kingdee.eas.ma.budget.BgControlSchemeInfo;
import com.kingdee.eas.ma.budget.BgCtrlException;
import com.kingdee.eas.ma.budget.BgCtrlParamCollection;
import com.kingdee.eas.ma.budget.BgCtrlParamInfo;
import com.kingdee.eas.ma.budget.BgCtrlResultCollection;
import com.kingdee.eas.ma.budget.BgCtrlResultInfo;
import com.kingdee.eas.ma.budget.BgCtrlTypeEnum;
import com.kingdee.eas.ma.budget.BgDataInfo;
import com.kingdee.eas.ma.budget.BgOverspendInfo;
import com.kingdee.eas.ma.budget.BudgetCtrlConstants;
import com.kingdee.eas.ma.budget.BudgetCtrlFacadeFactory;
import com.kingdee.eas.ma.budget.IBudgetCtrlFacade;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNSHelper;
import com.kingdee.eas.util.ResourceBase;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BudgetCtrlUtil {
    private static Logger logger = Logger.getLogger(BudgetCtrlUtil.class);

    public static boolean checkCtrlResultCol(Context ctx, boolean isCanControlWithoutBudget, boolean isAllowAccessCtrlScheme, boolean isWorkFlow, BgCtrlResultCollection ctrlResultCol) throws BgCtrlException {
        BgDataInfo bgDataInfo;
        BgCtrlResultInfo ctrlResultInfo;
        int i;
        boolean isZeroDealtoNull = BgNSHelper.isZeroDealtoNull((Context)ctx);
        String resultMsg = BudgetCtrlUtil.analyseCtrlResultCol(ctx, isCanControlWithoutBudget, isAllowAccessCtrlScheme, ctrlResultCol);
        if (BudgetCtrlUtil.isEmpty((Object)ctrlResultCol)) {
            return true;
        }
        boolean isPass = true;
        HashMap<String, BigDecimal> bgDataId2SumReqAmtMap = new HashMap<String, BigDecimal>();
        for (i = 0; i < ctrlResultCol.size(); ++i) {
            boolean isGroupCtrl;
            BigDecimal BgBal;
            ctrlResultInfo = ctrlResultCol.get(i);
            if (BudgetCtrlUtil.isEmpty(ctrlResultInfo.getBgDataId())) {
                if (isCanControlWithoutBudget) continue;
                throw new BgCtrlException(BgCtrlException.NOTACROSS, new String[]{resultMsg});
            }
            bgDataInfo = (BgDataInfo)ctrlResultInfo.get("bgData");
            BigDecimal bigDecimal = BgBal = bgDataInfo != null ? bgDataInfo.getBgValue() : BgNConstants.ZERO;
            if (BgBal == null) {
                BgBal = BudgetCtrlConstants.ZERO_AMOUNT;
            }
            if (BgBal.compareTo(BudgetCtrlConstants.ZERO_AMOUNT) == 0 && isCanControlWithoutBudget && isZeroDealtoNull) continue;
            boolean isCtrl = bgDataInfo != null ? bgDataInfo.isIsControl() : false;
            BgCtrlTypeEnum ctrlType = ctrlResultInfo.getCtrlType();
            if (!isCtrl || ctrlType == BgCtrlTypeEnum.NoCtrl) continue;
            BigDecimal balance = ctrlResultInfo.getBalance();
            BigDecimal reqAmount = ctrlResultInfo.getReqAmount();
            if (balance == null || reqAmount == null) continue;
            String bgDataId = ctrlResultInfo.getBgDataId();
            BigDecimal sumReqAmt = BudgetCtrlConstants.ZERO_AMOUNT;
            boolean bl = isGroupCtrl = bgDataInfo == null ? false : bgDataInfo.isIsGroupCtrl();
            if (isGroupCtrl) {
                String groupNo = bgDataInfo.getGroupNo() + ctrlResultInfo.getBgPeriodType();
                if (bgDataId2SumReqAmtMap.containsKey(groupNo) && bgDataId2SumReqAmtMap.get(groupNo) instanceof BigDecimal) {
                    BigDecimal _reqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(groupNo);
                    sumReqAmt = _reqAmt.add(reqAmount);
                } else {
                    sumReqAmt = reqAmount;
                }
                bgDataId2SumReqAmtMap.put(groupNo, sumReqAmt);
                continue;
            }
            if (bgDataId2SumReqAmtMap.containsKey(bgDataId) && bgDataId2SumReqAmtMap.get(bgDataId) instanceof BigDecimal) {
                BigDecimal _reqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(bgDataId);
                sumReqAmt = _reqAmt.add(reqAmount);
            } else {
                sumReqAmt = reqAmount;
            }
            bgDataId2SumReqAmtMap.put(bgDataId, sumReqAmt);
        }
        for (i = 0; i < ctrlResultCol.size(); ++i) {
            boolean isGroupCtrl;
            BigDecimal balance;
            ctrlResultInfo = ctrlResultCol.get(i);
            if (BudgetCtrlUtil.isEmpty(ctrlResultInfo.getBgDataId()) && isCanControlWithoutBudget) continue;
            bgDataInfo = (BgDataInfo)ctrlResultInfo.get("bgData");
            boolean isCtrl = bgDataInfo != null ? bgDataInfo.isIsControl() : false;
            BgCtrlTypeEnum ctrlType = ctrlResultInfo.getCtrlType();
            if (!isCtrl || ctrlType == BgCtrlTypeEnum.NoCtrl || (balance = ctrlResultInfo.getBalance()) == null) continue;
            String bgDataId = ctrlResultInfo.getBgDataId();
            BigDecimal sumReqAmt = BudgetCtrlConstants.ZERO_AMOUNT;
            boolean bl = isGroupCtrl = bgDataInfo == null ? false : bgDataInfo.isIsGroupCtrl();
            if (isGroupCtrl) {
                String groupNo = bgDataInfo.getGroupNo() + ctrlResultInfo.getBgPeriodType();
                sumReqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(groupNo);
            } else {
                sumReqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(bgDataId);
            }
            if (sumReqAmt == null || sumReqAmt.compareTo(balance) <= 0) continue;
            if (!isAllowAccessCtrlScheme || !ctrlResultInfo.isIsAllowAccess()) {
                throw new BgCtrlException(BgCtrlException.NOTACROSS, new String[]{resultMsg});
            }
            if (!isWorkFlow) continue;
            logger.error((Object)resultMsg);
            isPass = false;
        }
        return isPass;
    }

    public static boolean checkCtrlResultCol(Context ctx, boolean isCanControlWithoutBudget, boolean isAllowAccessCtrlScheme, boolean isWorkFlow, BgCtrlResultCollection ctrlResultCol, BgCtrlParamCollection ctrlParamCol, BgControlSchemeInfo ctrlScheme) throws BgCtrlException {
        int i;
        String resultMsg = BudgetCtrlUtil.analyseCtrlResultCol(ctx, isCanControlWithoutBudget, isAllowAccessCtrlScheme, ctrlResultCol, ctrlParamCol, ctrlScheme);
        if (BudgetCtrlUtil.isEmpty((Object)ctrlResultCol)) {
            return true;
        }
        boolean isPass = true;
        boolean hasZeroIsNull = BgNSHelper.isZeroDealtoNull((Context)ctx);
        BgControlMultiRuleCollection multiRuleCol = ctrlScheme.getMultiRule();
        HashMap<String, BgControlMultiRuleInfo> multiRuleMap = new HashMap<String, BgControlMultiRuleInfo>();
        if (multiRuleCol == null || multiRuleCol.size() == 0) {
            // empty if block
        }
        for (int i2 = 0; i2 < multiRuleCol.size(); ++i2) {
            BgControlMultiRuleInfo multiRule = multiRuleCol.get(i2);
            String bizItemCombNumber = multiRule.getBizItemCombinNumber();
            multiRuleMap.put(bizItemCombNumber, multiRule);
        }
        HashMap groupCheckMap = new HashMap();
        for (int i3 = 0; i3 < multiRuleMap.size(); ++i3) {
            BgControlMultiRuleInfo multiRule = multiRuleCol.get(i3);
            boolean isGourpCheck = multiRule.isIsGroupCheck();
            if (!isGourpCheck) continue;
            Map<String, BgControlMultiRuleInfo> groupitem = new HashMap<String, BgControlMultiRuleInfo>();
            String ItemCombNumber = multiRule.getCtrlItemCombinId();
            String bizItemCombNumber = multiRule.getBizItemCombinNumber();
            if (groupCheckMap.containsKey(ItemCombNumber)) {
                groupitem = (Map)groupCheckMap.get(ItemCombNumber);
                groupitem.put(bizItemCombNumber, multiRule);
            } else {
                groupitem.put(bizItemCombNumber, multiRule);
            }
            groupCheckMap.put(ItemCombNumber, groupitem);
        }
        HashMap<String, BigDecimal> bgDataId2SumReqAmtMap = new HashMap<String, BigDecimal>();
        for (i = 0; i < ctrlResultCol.size(); ++i) {
            BgControlMultiRuleInfo groupMultiRuleInfo;
            String CtrlItemID;
            boolean isGroupCtrl;
            BgCtrlResultInfo ctrlResultInfo = ctrlResultCol.get(i);
            BgCtrlParamInfo ctrlParamInfo = ctrlParamCol.get(i);
            if (ctrlParamInfo == null) continue;
            String bizItemCombNumber = ctrlParamInfo.getItemCombinNumber().replaceAll(",", "_");
            BgControlMultiRuleInfo multiRuleInfo = (BgControlMultiRuleInfo)multiRuleMap.get(bizItemCombNumber);
            if (BudgetCtrlUtil.isEmpty(ctrlResultInfo.getBgDataId())) {
                if (isCanControlWithoutBudget) continue;
                throw new BgCtrlException(BgCtrlException.NOTACROSS, new String[]{resultMsg});
            }
            BgDataInfo bgDataInfo = (BgDataInfo)ctrlResultInfo.get("bgData");
            if (hasZeroIsNull && BudgetCtrlConstants.ZERO_AMOUNT.compareTo(bgDataInfo.getBgValue()) == 0 && isCanControlWithoutBudget) continue;
            boolean isCtrl = bgDataInfo != null ? bgDataInfo.isIsControl() : false;
            BgCtrlTypeEnum ctrlType = ctrlResultInfo.getCtrlType();
            if (!isCtrl || ctrlType == BgCtrlTypeEnum.NoCtrl) continue;
            BigDecimal balance = ctrlResultInfo.getBalance();
            BigDecimal reqAmount = ctrlResultInfo.getReqAmount();
            if (balance == null || reqAmount == null) continue;
            String bgDataId = ctrlResultInfo.getBgDataId();
            BigDecimal sumReqAmt = BudgetCtrlConstants.ZERO_AMOUNT;
            boolean bl = isGroupCtrl = bgDataInfo == null ? false : bgDataInfo.isIsGroupCtrl();
            if (isGroupCtrl) {
                String groupNo = bgDataInfo.getGroupNo() + ctrlResultInfo.getBgPeriodType();
                if (bgDataId2SumReqAmtMap.containsKey(groupNo) && bgDataId2SumReqAmtMap.get(groupNo) instanceof BigDecimal) {
                    BigDecimal _reqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(groupNo);
                    sumReqAmt = _reqAmt.add(reqAmount);
                } else {
                    sumReqAmt = reqAmount;
                }
                bgDataId2SumReqAmtMap.put(groupNo, sumReqAmt);
                continue;
            }
            if (bgDataId2SumReqAmtMap.containsKey(bgDataId) && bgDataId2SumReqAmtMap.get(bgDataId) instanceof BigDecimal) {
                BigDecimal _reqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(bgDataId);
                sumReqAmt = _reqAmt.add(reqAmount);
            } else {
                sumReqAmt = reqAmount;
            }
            if (multiRuleMap != null && multiRuleMap.size() != 0 && !groupCheckMap.isEmpty() && groupCheckMap.size() != 0 && multiRuleMap.containsKey(bizItemCombNumber) && groupCheckMap.containsKey(CtrlItemID = (groupMultiRuleInfo = (BgControlMultiRuleInfo)multiRuleMap.get(bizItemCombNumber)).getCtrlItemCombinId()) && groupMultiRuleInfo.isIsGroupCheck()) {
                Map group = (Map)groupCheckMap.get(CtrlItemID);
                String bgSchemeId = ctrlResultInfo.getBgSchemeId();
                for (int k = 0; k < ctrlResultCol.size(); ++k) {
                    BgCtrlResultInfo tmpResultInfo = ctrlResultCol.get(k);
                    String tmpSchemeId = tmpResultInfo.getBgSchemeId();
                    String tmpitem = tmpResultInfo.getItemCombinNumber().replaceAll(",", "_");
                    if (!group.containsKey(tmpitem) || bizItemCombNumber.equals(tmpitem) || !tmpSchemeId.equals(bgSchemeId)) continue;
                    sumReqAmt = sumReqAmt.add(tmpResultInfo.getReqAmount());
                }
            }
            bgDataId2SumReqAmtMap.put(bgDataId, sumReqAmt);
        }
        for (i = 0; i < ctrlResultCol.size(); ++i) {
            boolean isGroupCtrl;
            BigDecimal balance;
            BgCtrlResultInfo ctrlResultInfo = ctrlResultCol.get(i);
            if (BudgetCtrlUtil.isEmpty(ctrlResultInfo.getBgDataId()) && isCanControlWithoutBudget) continue;
            BgDataInfo bgDataInfo = (BgDataInfo)ctrlResultInfo.get("bgData");
            boolean isCtrl = bgDataInfo != null ? bgDataInfo.isIsControl() : false;
            BgCtrlTypeEnum ctrlType = ctrlResultInfo.getCtrlType();
            if (!isCtrl || ctrlType == BgCtrlTypeEnum.NoCtrl || (balance = ctrlResultInfo.getBalance()) == null) continue;
            String bgDataId = ctrlResultInfo.getBgDataId();
            BigDecimal sumReqAmt = BudgetCtrlConstants.ZERO_AMOUNT;
            boolean bl = isGroupCtrl = bgDataInfo == null ? false : bgDataInfo.isIsGroupCtrl();
            if (isGroupCtrl) {
                String groupNo = bgDataInfo.getGroupNo() + ctrlResultInfo.getBgPeriodType();
                sumReqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(groupNo);
            } else {
                sumReqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(bgDataId);
            }
            if (sumReqAmt == null || sumReqAmt.compareTo(new BigDecimal(0)) <= 0 || sumReqAmt == null || sumReqAmt.compareTo(balance) <= 0) continue;
            if (!isAllowAccessCtrlScheme || !ctrlResultInfo.isIsAllowAccess()) {
                throw new BgCtrlException(BgCtrlException.NOTACROSS, new String[]{resultMsg});
            }
            if (!isWorkFlow) continue;
            logger.error((Object)resultMsg);
            isPass = false;
        }
        return isPass;
    }

    public static List checkCtrlResultColWithMessage(Context ctx, boolean isCanControlWithoutBudget, boolean isAllowAccessCtrlScheme, boolean isWorkFlow, BgCtrlResultCollection ctrlResultCol, BgCtrlParamCollection ctrlParamCol, BgControlSchemeInfo ctrlScheme) {
        BgCtrlParamInfo ctrlParamInfo;
        int i;
        LinkedList<BgOverspendInfo> overspendList = new LinkedList<BgOverspendInfo>();
        BgOverspendInfo bgOverspend = null;
        bgOverspend = new BgOverspendInfo();
        bgOverspend.setIsAudit("true");
        overspendList.add(bgOverspend);
        if (BudgetCtrlUtil.isEmpty((Object)ctrlResultCol)) {
            return overspendList;
        }
        boolean hasZeroIsNull = BgNSHelper.isZeroDealtoNull((Context)ctx);
        BgControlMultiRuleCollection multiRuleCol = ctrlScheme.getMultiRule();
        HashMap<String, BgControlMultiRuleInfo> multiRuleMap = new HashMap<String, BgControlMultiRuleInfo>();
        if (multiRuleCol == null || multiRuleCol.size() == 0) {
            // empty if block
        }
        for (int i2 = 0; i2 < multiRuleCol.size(); ++i2) {
            BgControlMultiRuleInfo multiRule = multiRuleCol.get(i2);
            String bizItemCombNumber = multiRule.getBizItemCombinNumber();
            multiRuleMap.put(bizItemCombNumber, multiRule);
        }
        HashMap groupCheckMap = new HashMap();
        for (int i3 = 0; i3 < multiRuleMap.size(); ++i3) {
            BgControlMultiRuleInfo multiRule = multiRuleCol.get(i3);
            boolean isGourpCheck = multiRule.isIsGroupCheck();
            if (!isGourpCheck) continue;
            Map<String, BgControlMultiRuleInfo> groupitem = new HashMap<String, BgControlMultiRuleInfo>();
            String ItemCombNumber = multiRule.getCtrlItemCombinId();
            String bizItemCombNumber = multiRule.getBizItemCombinNumber();
            if (groupCheckMap.containsKey(ItemCombNumber)) {
                groupitem = (Map)groupCheckMap.get(ItemCombNumber);
                groupitem.put(bizItemCombNumber, multiRule);
            } else {
                groupitem.put(bizItemCombNumber, multiRule);
            }
            groupCheckMap.put(ItemCombNumber, groupitem);
        }
        HashMap<String, BigDecimal> bgDataId2SumReqAmtMap = new HashMap<String, BigDecimal>();
        for (i = 0; i < ctrlResultCol.size(); ++i) {
            BgControlMultiRuleInfo groupMultiRuleInfo;
            String CtrlItemID;
            boolean isGroupCtrl;
            BgCtrlResultInfo ctrlResultInfo = ctrlResultCol.get(i);
            ctrlParamInfo = ctrlParamCol.get(i);
            String bizItemCombNumber = ctrlParamInfo.getItemCombinNumber().replaceAll(",", "_");
            String bizItemName = ctrlParamInfo.getItemCombinName();
            String orgUnitName = ctrlParamInfo.getOrgUnitName();
            BgControlMultiRuleInfo multiRuleInfo = (BgControlMultiRuleInfo)multiRuleMap.get(bizItemCombNumber);
            if (BudgetCtrlUtil.isEmpty(ctrlResultInfo.getBgDataId())) {
                if (isCanControlWithoutBudget) continue;
                ((BgOverspendInfo)overspendList.get(0)).setIsAudit("exception");
                bgOverspend = new BgOverspendInfo();
                bgOverspend.setBgItemName(bizItemName);
                bgOverspend.setBgOrgName(orgUnitName);
                overspendList.add(bgOverspend);
                return overspendList;
            }
            BgDataInfo bgDataInfo = (BgDataInfo)ctrlResultInfo.get("bgData");
            if (hasZeroIsNull && BudgetCtrlConstants.ZERO_AMOUNT.compareTo(bgDataInfo.getBgValue()) == 0 && isCanControlWithoutBudget) continue;
            boolean isCtrl = bgDataInfo != null ? bgDataInfo.isIsControl() : false;
            BgCtrlTypeEnum ctrlType = ctrlResultInfo.getCtrlType();
            if (!isCtrl || ctrlType == BgCtrlTypeEnum.NoCtrl) continue;
            BigDecimal balance = ctrlResultInfo.getBalance();
            BigDecimal reqAmount = ctrlResultInfo.getReqAmount();
            if (balance == null || reqAmount == null) continue;
            String bgDataId = ctrlResultInfo.getBgDataId();
            BigDecimal sumReqAmt = BudgetCtrlConstants.ZERO_AMOUNT;
            boolean bl = isGroupCtrl = bgDataInfo == null ? false : bgDataInfo.isIsGroupCtrl();
            if (isGroupCtrl) {
                String groupNo = bgDataInfo.getGroupNo() + ctrlResultInfo.getBgPeriodType();
                if (bgDataId2SumReqAmtMap.containsKey(groupNo) && bgDataId2SumReqAmtMap.get(groupNo) instanceof BigDecimal) {
                    BigDecimal _reqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(groupNo);
                    sumReqAmt = _reqAmt.add(reqAmount);
                } else {
                    sumReqAmt = reqAmount;
                }
                bgDataId2SumReqAmtMap.put(groupNo, sumReqAmt);
                continue;
            }
            if (bgDataId2SumReqAmtMap.containsKey(bgDataId) && bgDataId2SumReqAmtMap.get(bgDataId) instanceof BigDecimal) {
                BigDecimal _reqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(bgDataId);
                sumReqAmt = _reqAmt.add(reqAmount);
            } else {
                sumReqAmt = reqAmount;
            }
            if (multiRuleMap != null && multiRuleMap.size() != 0 && !groupCheckMap.isEmpty() && groupCheckMap.size() != 0 && multiRuleMap.containsKey(bizItemCombNumber) && groupCheckMap.containsKey(CtrlItemID = (groupMultiRuleInfo = (BgControlMultiRuleInfo)multiRuleMap.get(bizItemCombNumber)).getCtrlItemCombinId()) && groupMultiRuleInfo.isIsGroupCheck()) {
                Map group = (Map)groupCheckMap.get(CtrlItemID);
                String bgSchemeId = ctrlResultInfo.getBgSchemeId();
                for (int k = 0; k < ctrlResultCol.size(); ++k) {
                    BgCtrlResultInfo tmpResultInfo = ctrlResultCol.get(k);
                    String tmpSchemeId = tmpResultInfo.getBgSchemeId();
                    String tmpitem = tmpResultInfo.getItemCombinNumber().replaceAll(",", "_");
                    if (!group.containsKey(tmpitem) || bizItemCombNumber.equals(tmpitem) || !tmpSchemeId.equals(bgSchemeId)) continue;
                    sumReqAmt = sumReqAmt.add(tmpResultInfo.getReqAmount());
                }
            }
            bgDataId2SumReqAmtMap.put(bgDataId, sumReqAmt);
        }
        for (i = 0; i < ctrlResultCol.size(); ++i) {
            boolean isGroupCtrl;
            BgCtrlResultInfo ctrlResultInfo = ctrlResultCol.get(i);
            ctrlParamInfo = ctrlParamCol.get(i);
            String bizItemName = ctrlParamInfo.getItemCombinName();
            String orgUnitName = ctrlParamInfo.getOrgUnitName();
            if (BudgetCtrlUtil.isEmpty(ctrlResultInfo.getBgDataId()) && isCanControlWithoutBudget) continue;
            BgDataInfo bgDataInfo = (BgDataInfo)ctrlResultInfo.get("bgData");
            boolean isCtrl = bgDataInfo != null ? bgDataInfo.isIsControl() : false;
            BgCtrlTypeEnum ctrlType = ctrlResultInfo.getCtrlType();
            if (!isCtrl || ctrlType == BgCtrlTypeEnum.NoCtrl) continue;
            BigDecimal balance = ctrlResultInfo.getBalance();
            BigDecimal sumBgVal = (BigDecimal)ctrlResultInfo.get("sumBudgetValue");
            BigDecimal sumBizActual = (BigDecimal)ctrlResultInfo.get("sumActualValue");
            if (balance == null) continue;
            String bgDataId = ctrlResultInfo.getBgDataId();
            BigDecimal sumReqAmt = BudgetCtrlConstants.ZERO_AMOUNT;
            boolean bl = isGroupCtrl = bgDataInfo == null ? false : bgDataInfo.isIsGroupCtrl();
            if (isGroupCtrl) {
                String groupNo = bgDataInfo.getGroupNo() + ctrlResultInfo.getBgPeriodType();
                sumReqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(groupNo);
            } else {
                sumReqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(bgDataId);
            }
            if (sumReqAmt == null || sumReqAmt.compareTo(balance) <= 0) continue;
            if (!isAllowAccessCtrlScheme || !ctrlResultInfo.isIsAllowAccess()) {
                ((BgOverspendInfo)overspendList.get(0)).setIsAudit("exception");
                bgOverspend = new BgOverspendInfo();
                bgOverspend.setBgItemName(bizItemName);
                bgOverspend.setBgOrgName(orgUnitName);
                bgOverspend.setBgActual(sumReqAmt.add(sumBizActual).toString());
                bgOverspend.setBgValue(sumBgVal.toString());
                bgOverspend.setBgOverSpend(sumReqAmt.add(sumBizActual).subtract(sumBgVal).toString());
                if (sumBgVal.compareTo(BgNConstants.ZERO) != 0) {
                    bgOverspend.setBgOverPercent(sumReqAmt.add(sumBizActual).subtract(sumBgVal).multiply(BgNConstants.HUNDRED).divide(sumBgVal, 2, 4).toString());
                }
                overspendList.add(bgOverspend);
                return overspendList;
            }
            if (!isWorkFlow) continue;
            ((BgOverspendInfo)overspendList.get(0)).setIsAudit("false");
            bgOverspend = new BgOverspendInfo();
            bgOverspend.setBgItemName(bizItemName);
            bgOverspend.setBgOrgName(orgUnitName);
            bgOverspend.setBgActual(sumReqAmt.add(sumBizActual).toString());
            bgOverspend.setBgValue(sumBgVal.toString());
            bgOverspend.setBgOverSpend(sumReqAmt.add(sumBizActual).subtract(sumBgVal).toString());
            if (sumBgVal.compareTo(BgNConstants.ZERO) != 0) {
                bgOverspend.setBgOverPercent(sumReqAmt.add(sumBizActual).subtract(sumBgVal).multiply(BgNConstants.HUNDRED).divide(sumBgVal, 2, 4).toString());
            }
            overspendList.add(bgOverspend);
        }
        return overspendList;
    }

    public static Map checkCtrlResultColValue(Context ctx, boolean isCanControlWithoutBudget, boolean isAllowAccessCtrlScheme, boolean isWorkFlow, BgCtrlResultCollection ctrlResultCol, BgCtrlParamCollection ctrlParamCol, BgControlSchemeInfo ctrlScheme) throws BgCtrlException {
        int i;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("result", "1");
        if (BudgetCtrlUtil.isEmpty((Object)ctrlResultCol)) {
            return result;
        }
        boolean isPass = true;
        boolean hasZeroIsNull = BgNSHelper.isZeroDealtoNull((Context)ctx);
        BgControlMultiRuleCollection multiRuleCol = ctrlScheme.getMultiRule();
        HashMap<String, BgControlMultiRuleInfo> multiRuleMap = new HashMap<String, BgControlMultiRuleInfo>();
        for (int i2 = 0; i2 < multiRuleCol.size(); ++i2) {
            BgControlMultiRuleInfo multiRule = multiRuleCol.get(i2);
            String bizItemCombNumber = multiRule.getBizItemCombinNumber();
            multiRuleMap.put(bizItemCombNumber, multiRule);
        }
        HashMap groupCheckMap = new HashMap();
        for (int i3 = 0; i3 < multiRuleMap.size(); ++i3) {
            BgControlMultiRuleInfo multiRule = multiRuleCol.get(i3);
            boolean isGourpCheck = multiRule.isIsGroupCheck();
            if (!isGourpCheck) continue;
            Map<String, BgControlMultiRuleInfo> groupitem = new HashMap<String, BgControlMultiRuleInfo>();
            String ItemCombNumber = multiRule.getCtrlItemCombinId();
            String bizItemCombNumber = multiRule.getBizItemCombinNumber();
            if (groupCheckMap.containsKey(ItemCombNumber)) {
                groupitem = (Map)groupCheckMap.get(ItemCombNumber);
                groupitem.put(bizItemCombNumber, multiRule);
            } else {
                groupitem.put(bizItemCombNumber, multiRule);
            }
            groupCheckMap.put(ItemCombNumber, groupitem);
        }
        HashMap<String, BigDecimal> bgDataId2SumReqAmtMap = new HashMap<String, BigDecimal>();
        for (i = 0; i < ctrlResultCol.size(); ++i) {
            BgControlMultiRuleInfo groupMultiRuleInfo;
            String CtrlItemID;
            boolean isGroupCtrl;
            BgCtrlResultInfo ctrlResultInfo = ctrlResultCol.get(i);
            BgCtrlParamInfo ctrlParamInfo = ctrlParamCol.get(i);
            String bizItemCombNumber = ctrlParamInfo.getItemCombinNumber().replaceAll(",", "_");
            BgControlMultiRuleInfo multiRuleInfo = (BgControlMultiRuleInfo)multiRuleMap.get(bizItemCombNumber);
            if (BudgetCtrlUtil.isEmpty(ctrlResultInfo.getBgDataId())) {
                if (isCanControlWithoutBudget) continue;
                result.put("result", "-4");
                return result;
            }
            BgDataInfo bgDataInfo = (BgDataInfo)ctrlResultInfo.get("bgData");
            if (hasZeroIsNull && BudgetCtrlConstants.ZERO_AMOUNT.compareTo(bgDataInfo.getBgValue()) == 0 && isCanControlWithoutBudget) continue;
            boolean isCtrl = bgDataInfo != null ? bgDataInfo.isIsControl() : false;
            BgCtrlTypeEnum ctrlType = ctrlResultInfo.getCtrlType();
            if (!isCtrl || ctrlType == BgCtrlTypeEnum.NoCtrl) continue;
            BigDecimal balance = ctrlResultInfo.getBalance();
            BigDecimal reqAmount = ctrlResultInfo.getReqAmount();
            if (balance == null || reqAmount == null) continue;
            String bgDataId = ctrlResultInfo.getBgDataId();
            BigDecimal sumReqAmt = BudgetCtrlConstants.ZERO_AMOUNT;
            boolean bl = isGroupCtrl = bgDataInfo == null ? false : bgDataInfo.isIsGroupCtrl();
            if (isGroupCtrl) {
                String groupNo = bgDataInfo.getGroupNo() + ctrlResultInfo.getBgPeriodType();
                if (bgDataId2SumReqAmtMap.containsKey(groupNo) && bgDataId2SumReqAmtMap.get(groupNo) instanceof BigDecimal) {
                    BigDecimal _reqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(groupNo);
                    sumReqAmt = _reqAmt.add(reqAmount);
                } else {
                    sumReqAmt = reqAmount;
                }
                bgDataId2SumReqAmtMap.put(groupNo, sumReqAmt);
                continue;
            }
            if (bgDataId2SumReqAmtMap.containsKey(bgDataId) && bgDataId2SumReqAmtMap.get(bgDataId) instanceof BigDecimal) {
                BigDecimal _reqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(bgDataId);
                sumReqAmt = _reqAmt.add(reqAmount);
            } else {
                sumReqAmt = reqAmount;
            }
            if (multiRuleMap != null && multiRuleMap.size() != 0 && !groupCheckMap.isEmpty() && groupCheckMap.size() != 0 && multiRuleMap.containsKey(bizItemCombNumber) && groupCheckMap.containsKey(CtrlItemID = (groupMultiRuleInfo = (BgControlMultiRuleInfo)multiRuleMap.get(bizItemCombNumber)).getCtrlItemCombinId()) && groupMultiRuleInfo.isIsGroupCheck()) {
                Map group = (Map)groupCheckMap.get(CtrlItemID);
                for (int k = 0; k < ctrlResultCol.size(); ++k) {
                    BgCtrlResultInfo tmpResultInfo = ctrlResultCol.get(k);
                    String tmpitem = tmpResultInfo.getItemCombinNumber().replaceAll(",", "_");
                    if (!group.containsKey(tmpitem) || bizItemCombNumber.equals(tmpitem)) continue;
                    sumReqAmt = sumReqAmt.add(tmpResultInfo.getReqAmount());
                }
            }
            bgDataId2SumReqAmtMap.put(bgDataId, sumReqAmt);
        }
        for (i = 0; i < ctrlResultCol.size(); ++i) {
            boolean isGroupCtrl;
            BigDecimal balance;
            BgCtrlResultInfo ctrlResultInfo = ctrlResultCol.get(i);
            if (BudgetCtrlUtil.isEmpty(ctrlResultInfo.getBgDataId()) && isCanControlWithoutBudget) continue;
            BgDataInfo bgDataInfo = (BgDataInfo)ctrlResultInfo.get("bgData");
            boolean isCtrl = bgDataInfo != null ? bgDataInfo.isIsControl() : false;
            BgCtrlTypeEnum ctrlType = ctrlResultInfo.getCtrlType();
            if (!isCtrl || ctrlType == BgCtrlTypeEnum.NoCtrl || (balance = ctrlResultInfo.getBalance()) == null) continue;
            String bgDataId = ctrlResultInfo.getBgDataId();
            BigDecimal sumReqAmt = BudgetCtrlConstants.ZERO_AMOUNT;
            boolean bl = isGroupCtrl = bgDataInfo == null ? false : bgDataInfo.isIsGroupCtrl();
            if (isGroupCtrl) {
                String groupNo = bgDataInfo.getGroupNo() + ctrlResultInfo.getBgPeriodType();
                sumReqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(groupNo);
            } else {
                sumReqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(bgDataId);
            }
            if (sumReqAmt == null || sumReqAmt.compareTo(balance) <= 0) continue;
            result.put(ctrlResultCol.get(i).getOrgUnitId() + "-" + i, balance.subtract(sumReqAmt));
            result.put("balance", balance.subtract(sumReqAmt));
            if (!isAllowAccessCtrlScheme || !ctrlResultInfo.isIsAllowAccess()) {
                result.put("result", "0");
                return result;
            }
            if (!isWorkFlow) continue;
            result.put("result", "0");
        }
        return result;
    }

    private static String analyseCtrlResultCol(Context ctx, boolean isCanControlWithoutBudget, boolean isAllowAccessCtrlScheme, BgCtrlResultCollection ctrlResultCol) {
        BgDataInfo bgDataInfo;
        String s;
        int j;
        String[] tmp;
        String _billItemAlias;
        String billItemAlias;
        BgCtrlResultInfo ctrlResultInfo;
        int i;
        boolean isZeroDealtoNull = BgNSHelper.isZeroDealtoNull((Context)ctx);
        StringBuffer result = new StringBuffer("");
        String resourcePath = "com.kingdee.eas.ma.budget.BudgetResource";
        if (BudgetCtrlUtil.isEmpty((Object)ctrlResultCol)) {
            return result.toString();
        }
        HashMap<String, BigDecimal> bgDataId2SumReqAmtMap = new HashMap<String, BigDecimal>();
        for (i = 0; i < ctrlResultCol.size(); ++i) {
            boolean isGroupCtrl;
            ctrlResultInfo = ctrlResultCol.get(i);
            billItemAlias = ctrlResultInfo.getBillItemAlias();
            _billItemAlias = "";
            if (!BudgetCtrlUtil.isEmpty(billItemAlias)) {
                tmp = billItemAlias.split("\\@");
                for (j = 0; j < tmp.length; ++j) {
                    String[] subTmp = tmp[j].split("\\|");
                    s = subTmp[0];
                    if (s.endsWith(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"103_BgUtilsHelper", (Locale)ctx.getLocale()))) {
                        s = s.replaceAll(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"103_BgUtilsHelper", (Locale)ctx.getLocale()), "");
                    }
                    _billItemAlias = j != tmp.length - 1 ? _billItemAlias + s + "_" : _billItemAlias + s;
                }
            }
            if (BudgetCtrlUtil.isEmpty(ctrlResultInfo.getBgDataId())) {
                if (isCanControlWithoutBudget) continue;
                StringBuffer sb = new StringBuffer();
                sb.append(_billItemAlias);
                sb.append("[");
                sb.append(ctrlResultInfo.getBillItemName());
                sb.append("]");
                sb.append(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"108_BudgetCtrlUtil", (Locale)ctx.getLocale()));
                sb.append("[");
                sb.append(ctrlResultInfo.getOrgUnitName());
                sb.append("]");
                sb.append(ResourceBase.getString((String)resourcePath, (String)"NoBudget", (Locale)ctx.getLocale()));
                if (result.indexOf(sb.toString()) == -1) {
                    result.append(sb);
                    result.append(",");
                }
            }
            bgDataInfo = (BgDataInfo)ctrlResultInfo.get("bgData");
            BigDecimal BgBal = null;
            if (bgDataInfo != null) {
                BgBal = bgDataInfo.getBgValue();
            }
            if (BgBal == null) {
                BgBal = BudgetCtrlConstants.ZERO_AMOUNT;
            }
            if (BgBal.compareTo(BudgetCtrlConstants.ZERO_AMOUNT) == 0 && isCanControlWithoutBudget && isZeroDealtoNull) continue;
            boolean isCtrl = bgDataInfo != null ? bgDataInfo.isIsControl() : false;
            BgCtrlTypeEnum ctrlType = ctrlResultInfo.getCtrlType();
            if (!isCtrl || ctrlType == BgCtrlTypeEnum.NoCtrl) continue;
            BigDecimal balance = ctrlResultInfo.getBalance();
            BigDecimal reqAmount = ctrlResultInfo.getReqAmount();
            if (balance == null || reqAmount == null) continue;
            String bgDataId = ctrlResultInfo.getBgDataId();
            BigDecimal sumReqAmt = BudgetCtrlConstants.ZERO_AMOUNT;
            boolean append = true;
            boolean bl = isGroupCtrl = bgDataInfo == null ? false : bgDataInfo.isIsGroupCtrl();
            if (isGroupCtrl) {
                String groupNo = bgDataInfo.getGroupNo() + ctrlResultInfo.getBgPeriodType();
                if (bgDataId2SumReqAmtMap.containsKey(groupNo) && bgDataId2SumReqAmtMap.get(groupNo) instanceof BigDecimal) {
                    BigDecimal _reqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(groupNo);
                    sumReqAmt = _reqAmt.add(reqAmount);
                    if (_reqAmt.compareTo(balance) > 0) {
                        append = false;
                    }
                } else {
                    sumReqAmt = reqAmount;
                }
                bgDataId2SumReqAmtMap.put(groupNo, sumReqAmt);
                continue;
            }
            if (bgDataId2SumReqAmtMap.containsKey(bgDataId) && bgDataId2SumReqAmtMap.get(bgDataId) instanceof BigDecimal) {
                BigDecimal _reqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(bgDataId);
                sumReqAmt = _reqAmt.add(reqAmount);
                if (_reqAmt.compareTo(balance) > 0) {
                    append = false;
                }
            } else {
                sumReqAmt = reqAmount;
            }
            bgDataId2SumReqAmtMap.put(bgDataId, sumReqAmt);
        }
        for (i = 0; i < ctrlResultCol.size(); ++i) {
            boolean isGroupCtrl;
            BigDecimal balance;
            ctrlResultInfo = ctrlResultCol.get(i);
            billItemAlias = ctrlResultInfo.getBillItemAlias();
            _billItemAlias = "";
            if (!BudgetCtrlUtil.isEmpty(billItemAlias)) {
                tmp = billItemAlias.split("\\@");
                for (j = 0; j < tmp.length; ++j) {
                    String[] subTmp = tmp[j].split("\\|");
                    s = subTmp[0];
                    if (s.endsWith(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"103_BgUtilsHelper", (Locale)ctx.getLocale()))) {
                        s = s.replaceAll(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"103_BgUtilsHelper", (Locale)ctx.getLocale()), "");
                    }
                    _billItemAlias = j != tmp.length - 1 ? _billItemAlias + s + "_" : _billItemAlias + s;
                }
            }
            if (BudgetCtrlUtil.isEmpty(ctrlResultInfo.getBgDataId()) && isCanControlWithoutBudget) continue;
            bgDataInfo = (BgDataInfo)ctrlResultInfo.get("bgData");
            boolean isCtrl = bgDataInfo != null ? bgDataInfo.isIsControl() : false;
            BgCtrlTypeEnum ctrlType = ctrlResultInfo.getCtrlType();
            if (!isCtrl || ctrlType == BgCtrlTypeEnum.NoCtrl || (balance = ctrlResultInfo.getBalance()) == null) continue;
            String bgDataId = ctrlResultInfo.getBgDataId();
            BigDecimal sumReqAmt = BudgetCtrlConstants.ZERO_AMOUNT;
            boolean append = true;
            boolean bl = isGroupCtrl = bgDataInfo == null ? false : bgDataInfo.isIsGroupCtrl();
            if (isGroupCtrl) {
                String groupNo = bgDataInfo.getGroupNo() + ctrlResultInfo.getBgPeriodType();
                sumReqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(groupNo);
            } else {
                sumReqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(bgDataId);
            }
            if (sumReqAmt == null || sumReqAmt.compareTo(balance) <= 0 || !append || isAllowAccessCtrlScheme && ctrlResultInfo.isIsAllowAccess()) continue;
            StringBuffer sb = new StringBuffer();
            sb.append(_billItemAlias);
            sb.append("[");
            sb.append(ctrlResultInfo.getBillItemName());
            sb.append("]");
            sb.append(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"108_BudgetCtrlUtil", (Locale)ctx.getLocale()));
            sb.append("[");
            sb.append(ctrlResultInfo.getOrgUnitName());
            sb.append("]");
            sb.append(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"44_BgItemImportFacadeControllerBean", (Locale)ctx.getLocale()));
            sb.append(ResourceBase.getString((String)resourcePath, (String)"bgitem", (Locale)ctx.getLocale()));
            sb.append("[");
            sb.append(ctrlResultInfo.getItemCombinName());
            sb.append("]");
            sb.append(ResourceBase.getString((String)resourcePath, (String)"BgItemBalanceLack", (Locale)ctx.getLocale()));
            if (result.indexOf(sb.toString()) != -1) continue;
            result.append(sb);
            result.append(",");
        }
        String resultString = result.toString();
        if (resultString.length() > 0) {
            resultString = BudgetCtrlUtil.deleteStrTail(resultString);
            resultString = resultString.replaceAll(",", "\\\n");
        }
        return resultString;
    }

    private static String analyseCtrlResultCol(Context ctx, boolean isCanControlWithoutBudget, boolean isAllowAccessCtrlScheme, BgCtrlResultCollection ctrlResultCol, BgCtrlParamCollection ctrlParamCol, BgControlSchemeInfo ctrlScheme) {
        int i;
        StringBuffer result = new StringBuffer("");
        String resourcePath = "com.kingdee.eas.ma.budget.BudgetResource";
        BgControlMultiRuleCollection multiRuleCol = ctrlScheme.getMultiRule();
        HashMap<String, BgControlMultiRuleInfo> multiRuleMap = new HashMap<String, BgControlMultiRuleInfo>();
        if (multiRuleCol == null || multiRuleCol.size() == 0) {
            // empty if block
        }
        for (int i2 = 0; i2 < multiRuleCol.size(); ++i2) {
            BgControlMultiRuleInfo multiRule = multiRuleCol.get(i2);
            String bizItemCombNumber = multiRule.getBizItemCombinNumber();
            multiRuleMap.put(bizItemCombNumber, multiRule);
        }
        HashMap groupCheckMap = new HashMap();
        for (int i3 = 0; i3 < multiRuleMap.size(); ++i3) {
            BgControlMultiRuleInfo multiRule = multiRuleCol.get(i3);
            boolean isGourpCheck = multiRule.isIsGroupCheck();
            if (!isGourpCheck) continue;
            Map<String, BgControlMultiRuleInfo> groupitem = new HashMap<String, BgControlMultiRuleInfo>();
            String ItemCombNumber = multiRule.getCtrlItemCombinId();
            String bizItemCombNumber = multiRule.getBizItemCombinNumber();
            if (groupCheckMap.containsKey(ItemCombNumber)) {
                groupitem = (Map)groupCheckMap.get(ItemCombNumber);
                groupitem.put(bizItemCombNumber, multiRule);
            } else {
                groupitem.put(bizItemCombNumber, multiRule);
            }
            groupCheckMap.put(ItemCombNumber, groupitem);
        }
        HashMap<String, BigDecimal> bgDataId2SumReqAmtMap = new HashMap<String, BigDecimal>();
        for (i = 0; i < ctrlResultCol.size(); ++i) {
            BgControlMultiRuleInfo groupMultiRuleInfo;
            String CtrlItemID;
            boolean isGroupCtrl;
            BgDataInfo bgDataInfo;
            BgCtrlResultInfo ctrlResultInfo = ctrlResultCol.get(i);
            BgCtrlParamInfo ctrlParamInfo = ctrlParamCol.get(i);
            if (ctrlParamInfo == null) continue;
            String bizItemCombNumber = ctrlParamInfo.getItemCombinNumber().replaceAll(",", "_");
            BgControlMultiRuleInfo multiRuleInfo = (BgControlMultiRuleInfo)multiRuleMap.get(bizItemCombNumber);
            String billItemAlias = ctrlResultInfo.getBillItemAlias();
            String _billItemAlias = "";
            if (!BudgetCtrlUtil.isEmpty(billItemAlias)) {
                String[] tmp = billItemAlias.split("\\@");
                for (int j = 0; j < tmp.length; ++j) {
                    String[] subTmp = tmp[j].split("\\|");
                    String s = subTmp[0];
                    if (s.endsWith(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"103_BgUtilsHelper", (Locale)ctx.getLocale()))) {
                        s = s.replaceAll(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"103_BgUtilsHelper", (Locale)ctx.getLocale()), "");
                    }
                    _billItemAlias = j != tmp.length - 1 ? _billItemAlias + s + "_" : _billItemAlias + s;
                }
            }
            if (BudgetCtrlUtil.isEmpty(ctrlResultInfo.getBgDataId())) {
                if (isCanControlWithoutBudget) continue;
                StringBuffer sb = new StringBuffer();
                sb.append(_billItemAlias);
                sb.append("[");
                sb.append(ctrlResultInfo.getBillItemName());
                sb.append("]");
                sb.append(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"108_BudgetCtrlUtil", (Locale)ctx.getLocale()));
                sb.append("[");
                sb.append(ctrlResultInfo.getOrgUnitName());
                sb.append("]");
                sb.append(ResourceBase.getString((String)resourcePath, (String)"NoBudget", (Locale)ctx.getLocale()));
                if (result.indexOf(sb.toString()) == -1) {
                    result.append(sb);
                    result.append(",");
                }
            }
            boolean isCtrl = (bgDataInfo = (BgDataInfo)ctrlResultInfo.get("bgData")) != null ? bgDataInfo.isIsControl() : false;
            BgCtrlTypeEnum ctrlType = ctrlResultInfo.getCtrlType();
            if (!isCtrl || ctrlType == BgCtrlTypeEnum.NoCtrl) continue;
            BigDecimal balance = ctrlResultInfo.getBalance();
            BigDecimal reqAmount = ctrlResultInfo.getReqAmount();
            if (balance == null || reqAmount == null) continue;
            String bgDataId = ctrlResultInfo.getBgDataId();
            BigDecimal sumReqAmt = BudgetCtrlConstants.ZERO_AMOUNT;
            boolean append = true;
            boolean bl = isGroupCtrl = bgDataInfo == null ? false : bgDataInfo.isIsGroupCtrl();
            if (isGroupCtrl) {
                String groupNo = bgDataInfo.getGroupNo() + ctrlResultInfo.getBgPeriodType();
                if (bgDataId2SumReqAmtMap.containsKey(groupNo) && bgDataId2SumReqAmtMap.get(groupNo) instanceof BigDecimal) {
                    BigDecimal _reqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(groupNo);
                    sumReqAmt = _reqAmt.add(reqAmount);
                    if (_reqAmt.compareTo(balance) > 0) {
                        append = false;
                    }
                } else {
                    sumReqAmt = reqAmount;
                }
                bgDataId2SumReqAmtMap.put(groupNo, sumReqAmt);
                continue;
            }
            if (bgDataId2SumReqAmtMap.containsKey(bgDataId) && bgDataId2SumReqAmtMap.get(bgDataId) instanceof BigDecimal) {
                BigDecimal _reqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(bgDataId);
                sumReqAmt = _reqAmt.add(reqAmount);
                if (_reqAmt.compareTo(balance) > 0) {
                    append = false;
                }
            } else {
                sumReqAmt = reqAmount;
            }
            if (multiRuleMap != null && multiRuleMap.size() != 0 && !groupCheckMap.isEmpty() && groupCheckMap.size() != 0 && multiRuleMap.containsKey(bizItemCombNumber) && groupCheckMap.containsKey(CtrlItemID = (groupMultiRuleInfo = (BgControlMultiRuleInfo)multiRuleMap.get(bizItemCombNumber)).getCtrlItemCombinId()) && groupMultiRuleInfo.isIsGroupCheck()) {
                Map group = (Map)groupCheckMap.get(CtrlItemID);
                for (int k = 0; k < ctrlResultCol.size(); ++k) {
                    BgCtrlResultInfo tmpResultInfo = ctrlResultCol.get(k);
                    String tmpitem = tmpResultInfo.getItemCombinNumber().replaceAll(",", "_");
                    if (!group.containsKey(tmpitem) || bizItemCombNumber.equals(tmpitem)) continue;
                    sumReqAmt = sumReqAmt.add(tmpResultInfo.getReqAmount());
                }
            }
            bgDataId2SumReqAmtMap.put(bgDataId, sumReqAmt);
        }
        for (i = 0; i < ctrlResultCol.size(); ++i) {
            boolean isGroupCtrl;
            BigDecimal balance;
            BgCtrlResultInfo ctrlResultInfo = ctrlResultCol.get(i);
            String billItemAlias = ctrlResultInfo.getBillItemAlias();
            String _billItemAlias = "";
            if (!BudgetCtrlUtil.isEmpty(billItemAlias)) {
                String[] tmp = billItemAlias.split("\\@");
                for (int j = 0; j < tmp.length; ++j) {
                    String[] subTmp = tmp[j].split("\\|");
                    String s = subTmp[0];
                    if (s.endsWith(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"103_BgUtilsHelper", (Locale)ctx.getLocale()))) {
                        s = s.replaceAll(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"103_BgUtilsHelper", (Locale)ctx.getLocale()), "");
                    }
                    _billItemAlias = j != tmp.length - 1 ? _billItemAlias + s + "_" : _billItemAlias + s;
                }
            }
            if (BudgetCtrlUtil.isEmpty(ctrlResultInfo.getBgDataId()) && isCanControlWithoutBudget) continue;
            BgDataInfo bgDataInfo = (BgDataInfo)ctrlResultInfo.get("bgData");
            boolean isCtrl = bgDataInfo != null ? bgDataInfo.isIsControl() : false;
            BgCtrlTypeEnum ctrlType = ctrlResultInfo.getCtrlType();
            if (!isCtrl || ctrlType == BgCtrlTypeEnum.NoCtrl || (balance = ctrlResultInfo.getBalance()) == null) continue;
            String bgDataId = ctrlResultInfo.getBgDataId();
            BigDecimal sumReqAmt = BudgetCtrlConstants.ZERO_AMOUNT;
            boolean append = true;
            boolean bl = isGroupCtrl = bgDataInfo == null ? false : bgDataInfo.isIsGroupCtrl();
            if (isGroupCtrl) {
                String groupNo = bgDataInfo.getGroupNo() + ctrlResultInfo.getBgPeriodType();
                sumReqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(groupNo);
            } else {
                sumReqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(bgDataId);
            }
            if (sumReqAmt == null || sumReqAmt.compareTo(balance) <= 0 || !append || isAllowAccessCtrlScheme && ctrlResultInfo.isIsAllowAccess()) continue;
            StringBuffer sb = new StringBuffer();
            sb.append(_billItemAlias);
            sb.append("[");
            sb.append(ctrlResultInfo.getBillItemName());
            sb.append("]");
            sb.append(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"108_BudgetCtrlUtil", (Locale)ctx.getLocale()));
            sb.append("[");
            sb.append(ctrlResultInfo.getOrgUnitName());
            sb.append("]");
            sb.append(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"44_BgItemImportFacadeControllerBean", (Locale)ctx.getLocale()));
            sb.append(ResourceBase.getString((String)resourcePath, (String)"bgitem", (Locale)ctx.getLocale()));
            sb.append("[");
            sb.append(ctrlResultInfo.getItemCombinName());
            sb.append("]");
            sb.append(ResourceBase.getString((String)resourcePath, (String)"BgItemBalanceLack", (Locale)ctx.getLocale()));
            if (result.indexOf(sb.toString()) != -1) continue;
            result.append(sb);
            result.append(",");
        }
        String resultString = result.toString();
        if (resultString.length() > 0) {
            resultString = BudgetCtrlUtil.deleteStrTail(resultString);
            resultString = resultString.replaceAll(",", "\\\n");
        }
        return resultString;
    }

    public static Vector getFieldValue(IObjectValue info, String[] orgUnitSubFields) {
        Vector resultList = new Vector(10);
        ArrayList paramList = new ArrayList();
        BudgetCtrlUtil.subGetFieldValue(info, paramList, orgUnitSubFields, 0, false);
        for (int i = 0; paramList != null && i < paramList.size(); ++i) {
            resultList.add(paramList.get(i));
        }
        return resultList;
    }

    private static void subGetFieldValue(IObjectValue info, List paramList, String[] orgUnitSubFields, int index, boolean isFilterSame) {
        if (BindingUtility.getBeanProperty((Object)info, (String)orgUnitSubFields[index]) != null) {
            if (BindingUtility.getBeanProperty((Object)info, (String)orgUnitSubFields[index]) instanceof IObjectCollection) {
                IObjectCollection coll = (IObjectCollection)BindingUtility.getBeanProperty((Object)info, (String)orgUnitSubFields[index]);
                for (int i = 0; i < coll.size(); ++i) {
                    IObjectValue tmpInfo = coll.getObject(i);
                    if (index + 1 < orgUnitSubFields.length) {
                        BudgetCtrlUtil.subGetFieldValue(tmpInfo, paramList, orgUnitSubFields, index + 1, isFilterSame);
                        continue;
                    }
                    if (isFilterSame) {
                        if (paramList.contains(BindingUtility.getBeanProperty((Object)info, (String)orgUnitSubFields[index]))) continue;
                        paramList.add(BindingUtility.getBeanProperty((Object)info, (String)orgUnitSubFields[index]));
                        continue;
                    }
                    paramList.add(BindingUtility.getBeanProperty((Object)info, (String)orgUnitSubFields[index]));
                }
            } else if (BindingUtility.getBeanProperty((Object)info, (String)orgUnitSubFields[index]) instanceof IObjectValue) {
                IObjectValue tmpInfo = (IObjectValue)BindingUtility.getBeanProperty((Object)info, (String)orgUnitSubFields[index]);
                if (index + 1 < orgUnitSubFields.length) {
                    BudgetCtrlUtil.subGetFieldValue(tmpInfo, paramList, orgUnitSubFields, index + 1, isFilterSame);
                } else if (isFilterSame) {
                    if (!paramList.contains(BindingUtility.getBeanProperty((Object)info, (String)orgUnitSubFields[index]))) {
                        paramList.add(BindingUtility.getBeanProperty((Object)info, (String)orgUnitSubFields[index]));
                    }
                } else {
                    paramList.add(BindingUtility.getBeanProperty((Object)info, (String)orgUnitSubFields[index]));
                }
            } else if (isFilterSame) {
                if (!paramList.contains(BindingUtility.getBeanProperty((Object)info, (String)orgUnitSubFields[index]))) {
                    paramList.add(BindingUtility.getBeanProperty((Object)info, (String)orgUnitSubFields[index]));
                }
            } else {
                paramList.add(BindingUtility.getBeanProperty((Object)info, (String)orgUnitSubFields[index]));
            }
        }
    }

    public static IBudgetCtrlFacade getBudgetCtrlFacadeImpl(Context ctx) throws BOSException {
        if (ctx == null) {
            return BudgetCtrlFacadeFactory.getRemoteInstance();
        }
        return BudgetCtrlFacadeFactory.getLocalInstance(ctx);
    }

    public static boolean isEmpty(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof String) {
            return o.toString() == null || o.toString().trim().length() == 0;
        }
        if (o instanceof Map) {
            return ((Map)o).isEmpty();
        }
        if (o instanceof Collection) {
            return ((Collection)o).isEmpty();
        }
        if (o instanceof IObjectValue) {
            return ((IObjectValue)o).isEmpty() || ((IObjectValue)o).get("id") == null || ((IObjectValue)o).get("id").toString().trim().length() == 0;
        }
        if (o instanceof IObjectCollection) {
            return ((IObjectCollection)o).isEmpty();
        }
        if (o instanceof String[]) {
            return ((String[])o).length == 0;
        }
        if (o instanceof Object[]) {
            return ((Object[])o).length == 0;
        }
        return false;
    }

    public static boolean isNotEmpty(Object o) {
        return !BudgetCtrlUtil.isEmpty(o);
    }

    public static void assertEmpty(Object o, String msg) {
        if (!BudgetCtrlUtil.isEmpty(o)) {
            throw new IllegalArgumentException(msg);
        }
    }

    public static void assertNotEmpty(Object o, String msg) {
        if (BudgetCtrlUtil.isEmpty(o)) {
            throw new IllegalArgumentException(msg);
        }
    }

    public static String replaceNULL(String val, String nullVal) {
        if (val == null) {
            return nullVal;
        }
        return val;
    }

    public static String replaceNULL(Object val, Object nullVal) {
        if (val == null) {
            if (nullVal == null) {
                return "";
            }
            return nullVal.toString();
        }
        return val.toString();
    }

    public static String deleteStrTail(String s) {
        if (BudgetCtrlUtil.isEmpty(s)) {
            return null;
        }
        if (s.length() == 1) {
            return "";
        }
        return s.substring(0, s.length() - 1);
    }

    public static String buildItemFormula(String itemCombNumber, String bgPeriodNumber, String elementNumber, String currencyNumber) {
        return "=BgItem(\"" + itemCombNumber + "\",\"" + bgPeriodNumber + "\",\"" + elementNumber + "\",\"BgData\",true,\"" + currencyNumber + "\")";
    }
}

