/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget;

import com.kingdee.bos.Context;
import com.kingdee.eas.ma.budget.BgControlMultiRuleCollection;
import com.kingdee.eas.ma.budget.BgControlMultiRuleInfo;
import com.kingdee.eas.ma.budget.BgControlSchemeInfo;
import com.kingdee.eas.ma.budget.BgCtrlException;
import com.kingdee.eas.ma.budget.BgCtrlManualDecisionException;
import com.kingdee.eas.ma.budget.BgCtrlParamCollection;
import com.kingdee.eas.ma.budget.BgCtrlParamInfo;
import com.kingdee.eas.ma.budget.BgCtrlResultCollection;
import com.kingdee.eas.ma.budget.BgCtrlResultInfo;
import com.kingdee.eas.ma.budget.BgCtrlTypeEnum;
import com.kingdee.eas.ma.budget.BgDataInfo;
import com.kingdee.eas.ma.budget.BgOverspendInfo;
import com.kingdee.eas.ma.budget.BudgetCtrlConstants;
import com.kingdee.eas.ma.budget.BudgetCtrlUtil;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNSHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BudgetCtrlWithHintUtil {
    private static Logger logger = Logger.getLogger(BudgetCtrlUtil.class);

    public static boolean checkCtrlResultCol(Context ctx, boolean isCanControlWithoutBudget, boolean isAllowAccessCtrlScheme, boolean isWorkFlow, BgCtrlResultCollection ctrlResultCol, BgCtrlParamCollection ctrlParamCol, BgControlSchemeInfo ctrlScheme) throws BgCtrlException, BgCtrlManualDecisionException {
        String resultMsg = BudgetCtrlWithHintUtil.analyseCtrlResultCol(ctx, isCanControlWithoutBudget, isAllowAccessCtrlScheme, ctrlResultCol, ctrlParamCol, ctrlScheme, true);
        if (BudgetCtrlUtil.isEmpty((Object)ctrlResultCol)) {
            return true;
        }
        boolean isPass = true;
        boolean hasZeroIsNull = BgNSHelper.isZeroDealtoNull((Context)ctx);
        BgControlMultiRuleCollection multiRuleCol = ctrlScheme.getMultiRule();
        HashMap<String, BgControlMultiRuleInfo> multiRuleMap = new HashMap<String, BgControlMultiRuleInfo>();
        if (multiRuleCol == null || multiRuleCol.size() == 0) {
            // empty if block
        }
        for (int i = 0; i < multiRuleCol.size(); ++i) {
            BgControlMultiRuleInfo multiRule = multiRuleCol.get(i);
            String bizItemCombNumber = multiRule.getBizItemCombinNumber();
            multiRuleMap.put(bizItemCombNumber, multiRule);
        }
        HashMap groupCheckMap = new HashMap();
        for (int i = 0; i < multiRuleMap.size(); ++i) {
            BgControlMultiRuleInfo multiRule = multiRuleCol.get(i);
            boolean isGourpCheck = multiRule.isIsGroupCheck();
            if (!isGourpCheck) continue;
            Map<String, BgControlMultiRuleInfo> groupitem = new HashMap<String, BgControlMultiRuleInfo>();
            String ItemCombNumber = multiRule.getCtrlItemCombinId();
            String bizItemCombNumber = multiRule.getBizItemCombinNumber();
            if (groupCheckMap.containsKey(ItemCombNumber)) {
                groupitem = (Map)groupCheckMap.get(ItemCombNumber);
                groupitem.put(bizItemCombNumber, multiRule);
            } else {
                groupitem.put(bizItemCombNumber, multiRule);
            }
            groupCheckMap.put(ItemCombNumber, groupitem);
        }
        HashMap<String, BigDecimal> bgDataId2SumReqAmtMap = new HashMap<String, BigDecimal>();
        for (int i = 0; i < ctrlResultCol.size(); ++i) {
            BgControlMultiRuleInfo groupMultiRuleInfo;
            String CtrlItemID;
            BgCtrlResultInfo ctrlResultInfo = ctrlResultCol.get(i);
            BgCtrlParamInfo ctrlParamInfo = ctrlParamCol.get(i);
            String bizItemCombNumber = null;
            if (ctrlParamInfo != null) {
                bizItemCombNumber = ctrlParamInfo.getItemCombinNumber().replaceAll(",", "_");
            }
            BgControlMultiRuleInfo multiRuleInfo = (BgControlMultiRuleInfo)multiRuleMap.get(bizItemCombNumber);
            if (BudgetCtrlUtil.isEmpty(ctrlResultInfo.getBgDataId())) {
                if (isCanControlWithoutBudget) continue;
                throw new BgCtrlException(BgCtrlException.NOTACROSS, new String[]{resultMsg});
            }
            BgDataInfo bgDataInfo = (BgDataInfo)ctrlResultInfo.get("bgData");
            if (hasZeroIsNull && BudgetCtrlConstants.ZERO_AMOUNT.compareTo(bgDataInfo.getBgValue()) == 0 && isCanControlWithoutBudget) continue;
            boolean isCtrl = bgDataInfo != null ? bgDataInfo.isIsControl() : false;
            BgCtrlTypeEnum ctrlType = ctrlResultInfo.getCtrlType();
            if (!isCtrl || ctrlType == BgCtrlTypeEnum.NoCtrl) continue;
            BigDecimal balance = ctrlResultInfo.getBalance();
            BigDecimal reqAmount = ctrlResultInfo.getReqAmount();
            if (balance == null || reqAmount == null) continue;
            String bgDataId = ctrlResultInfo.getBgDataId();
            BigDecimal sumReqAmt = BudgetCtrlConstants.ZERO_AMOUNT;
            boolean isGroupCtrl = bgDataInfo == null ? false : bgDataInfo.isIsGroupCtrl();
            Object obj = ctrlResultInfo.get("IS_REQUEST_BUDGET");
            boolean isRequestBudget = true;
            if (obj instanceof Boolean) {
                isRequestBudget = (Boolean)obj;
            }
            if (isGroupCtrl) {
                String groupNo = bgDataInfo.getGroupNo();
                String key = groupNo + isRequestBudget;
                if (bgDataId2SumReqAmtMap.containsKey(key) && bgDataId2SumReqAmtMap.get(key) instanceof BigDecimal) {
                    BigDecimal _reqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(key);
                    sumReqAmt = _reqAmt.add(reqAmount);
                } else {
                    sumReqAmt = reqAmount;
                }
                bgDataId2SumReqAmtMap.put(key, sumReqAmt);
                continue;
            }
            if (bgDataId2SumReqAmtMap.containsKey(bgDataId) && bgDataId2SumReqAmtMap.get(bgDataId) instanceof BigDecimal) {
                BigDecimal _reqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(bgDataId);
                sumReqAmt = _reqAmt.add(reqAmount);
            } else {
                sumReqAmt = reqAmount;
            }
            if (multiRuleMap != null && multiRuleMap.size() != 0 && !groupCheckMap.isEmpty() && groupCheckMap.size() != 0 && multiRuleMap.containsKey(bizItemCombNumber) && groupCheckMap.containsKey(CtrlItemID = (groupMultiRuleInfo = (BgControlMultiRuleInfo)multiRuleMap.get(bizItemCombNumber)).getCtrlItemCombinId()) && groupMultiRuleInfo.isIsGroupCheck()) {
                Map group = (Map)groupCheckMap.get(CtrlItemID);
                String bgSchemeId = ctrlResultInfo.getBgSchemeId();
                for (int k = 0; k < ctrlResultCol.size(); ++k) {
                    BgCtrlResultInfo tmpResultInfo = ctrlResultCol.get(k);
                    String tmpSchemeId = tmpResultInfo.getBgSchemeId();
                    String tmpitem = tmpResultInfo.getItemCombinNumber().replaceAll(",", "_");
                    if (!group.containsKey(tmpitem) || bizItemCombNumber != null && bizItemCombNumber.equals(tmpitem) || !tmpSchemeId.equals(bgSchemeId)) continue;
                    sumReqAmt = sumReqAmt.add(tmpResultInfo.getReqAmount());
                }
            }
            bgDataId2SumReqAmtMap.put(bgDataId, sumReqAmt);
        }
        boolean hint_flag = false;
        for (int i = 0; i < ctrlResultCol.size(); ++i) {
            BigDecimal balance;
            BgCtrlResultInfo ctrlResultInfo = ctrlResultCol.get(i);
            if (BudgetCtrlUtil.isEmpty(ctrlResultInfo.getBgDataId()) && isCanControlWithoutBudget) continue;
            BgDataInfo bgDataInfo = (BgDataInfo)ctrlResultInfo.get("bgData");
            boolean isCtrl = bgDataInfo != null ? bgDataInfo.isIsControl() : false;
            BgCtrlTypeEnum ctrlType = ctrlResultInfo.getCtrlType();
            if (!isCtrl || ctrlType == BgCtrlTypeEnum.NoCtrl || (balance = ctrlResultInfo.getBalance()) == null) continue;
            String bgDataId = ctrlResultInfo.getBgDataId();
            BigDecimal sumReqAmt = BudgetCtrlConstants.ZERO_AMOUNT;
            boolean isGroupCtrl = bgDataInfo == null ? false : bgDataInfo.isIsGroupCtrl();
            Object obj = ctrlResultInfo.get("IS_REQUEST_BUDGET");
            boolean isRequestBudget = true;
            if (obj instanceof Boolean) {
                isRequestBudget = (Boolean)obj;
            }
            if (isGroupCtrl) {
                String groupNo = bgDataInfo.getGroupNo();
                String key = groupNo + isRequestBudget;
                sumReqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(key);
            } else {
                sumReqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(bgDataId);
            }
            if (sumReqAmt == null || sumReqAmt.compareTo(new BigDecimal(0)) <= 0 || sumReqAmt == null || sumReqAmt.compareTo(balance) <= 0) continue;
            if (!isRequestBudget) {
                if (hint_flag) continue;
                hint_flag = true;
                continue;
            }
            if (!isAllowAccessCtrlScheme || !ctrlResultInfo.isIsAllowAccess()) {
                throw new BgCtrlException(BgCtrlException.NOTACROSS, new String[]{resultMsg});
            }
            logger.error((Object)resultMsg);
            isPass = false;
        }
        if (!isPass || hint_flag) {
            throw new BgCtrlManualDecisionException(BgCtrlManualDecisionException.MANUALDECISION, new Object[]{resultMsg});
        }
        return isPass;
    }

    public static List checkCtrlResultColWithMessage(Context ctx, boolean isCanControlWithoutBudget, boolean isAllowAccessCtrlScheme, boolean isWorkFlow, BgCtrlResultCollection ctrlResultCol, BgCtrlParamCollection ctrlParamCol, BgControlSchemeInfo ctrlScheme) throws BgCtrlManualDecisionException {
        String key;
        String groupNo;
        boolean isRequestBudget;
        Object obj;
        boolean isGroupCtrl;
        BigDecimal sumReqAmt;
        String bgDataId;
        String orgUnitName;
        String bizItemName;
        String resultMsg = BudgetCtrlWithHintUtil.analyseCtrlResultCol(ctx, isCanControlWithoutBudget, isAllowAccessCtrlScheme, ctrlResultCol, ctrlParamCol, ctrlScheme, true);
        LinkedList<BgOverspendInfo> overspendList = new LinkedList<BgOverspendInfo>();
        BgOverspendInfo bgOverspend = null;
        bgOverspend = new BgOverspendInfo();
        bgOverspend.setIsAudit("true");
        overspendList.add(bgOverspend);
        if (BudgetCtrlUtil.isEmpty((Object)ctrlResultCol)) {
            return overspendList;
        }
        boolean isPass = true;
        boolean hasZeroIsNull = BgNSHelper.isZeroDealtoNull((Context)ctx);
        BgControlMultiRuleCollection multiRuleCol = ctrlScheme.getMultiRule();
        HashMap<String, BgControlMultiRuleInfo> multiRuleMap = new HashMap<String, BgControlMultiRuleInfo>();
        if (multiRuleCol == null || multiRuleCol.size() == 0) {
            // empty if block
        }
        for (int i = 0; i < multiRuleCol.size(); ++i) {
            BgControlMultiRuleInfo multiRule = multiRuleCol.get(i);
            String bizItemCombNumber = multiRule.getBizItemCombinNumber();
            multiRuleMap.put(bizItemCombNumber, multiRule);
        }
        HashMap groupCheckMap = new HashMap();
        for (int i = 0; i < multiRuleMap.size(); ++i) {
            BgControlMultiRuleInfo multiRule = multiRuleCol.get(i);
            boolean isGourpCheck = multiRule.isIsGroupCheck();
            if (!isGourpCheck) continue;
            Map<String, BgControlMultiRuleInfo> groupitem = new HashMap<String, BgControlMultiRuleInfo>();
            String ItemCombNumber = multiRule.getCtrlItemCombinId();
            String bizItemCombNumber = multiRule.getBizItemCombinNumber();
            if (groupCheckMap.containsKey(ItemCombNumber)) {
                groupitem = (Map)groupCheckMap.get(ItemCombNumber);
                groupitem.put(bizItemCombNumber, multiRule);
            } else {
                groupitem.put(bizItemCombNumber, multiRule);
            }
            groupCheckMap.put(ItemCombNumber, groupitem);
        }
        HashMap<String, BigDecimal> bgDataId2SumReqAmtMap = new HashMap<String, BigDecimal>();
        for (int i = 0; i < ctrlResultCol.size(); ++i) {
            BgControlMultiRuleInfo groupMultiRuleInfo;
            String CtrlItemID;
            BgCtrlResultInfo ctrlResultInfo = ctrlResultCol.get(i);
            BgCtrlParamInfo ctrlParamInfo = ctrlParamCol.get(i);
            String bizItemCombNumber = null;
            bizItemName = null;
            orgUnitName = null;
            if (ctrlParamInfo != null) {
                bizItemCombNumber = ctrlParamInfo.getItemCombinNumber().replaceAll(",", "_");
                bizItemName = ctrlParamInfo.getItemCombinName();
                orgUnitName = ctrlParamInfo.getOrgUnitName();
            }
            BgControlMultiRuleInfo multiRuleInfo = (BgControlMultiRuleInfo)multiRuleMap.get(bizItemCombNumber);
            if (BudgetCtrlUtil.isEmpty(ctrlResultInfo.getBgDataId())) {
                if (isCanControlWithoutBudget) continue;
                ((BgOverspendInfo)overspendList.get(0)).setIsAudit("exception");
                bgOverspend = new BgOverspendInfo();
                bgOverspend.setBgItemName(bizItemName);
                bgOverspend.setBgOrgName(orgUnitName);
                overspendList.add(bgOverspend);
                return overspendList;
            }
            BgDataInfo bgDataInfo = (BgDataInfo)ctrlResultInfo.get("bgData");
            if (hasZeroIsNull && BudgetCtrlConstants.ZERO_AMOUNT.compareTo(bgDataInfo.getBgValue()) == 0 && isCanControlWithoutBudget) continue;
            boolean isCtrl = bgDataInfo != null ? bgDataInfo.isIsControl() : false;
            BgCtrlTypeEnum ctrlType = ctrlResultInfo.getCtrlType();
            if (!isCtrl || ctrlType == BgCtrlTypeEnum.NoCtrl) continue;
            BigDecimal balance = ctrlResultInfo.getBalance();
            BigDecimal reqAmount = ctrlResultInfo.getReqAmount();
            if (balance == null || reqAmount == null) continue;
            bgDataId = ctrlResultInfo.getBgDataId();
            sumReqAmt = BudgetCtrlConstants.ZERO_AMOUNT;
            isGroupCtrl = bgDataInfo == null ? false : bgDataInfo.isIsGroupCtrl();
            obj = ctrlResultInfo.get("IS_REQUEST_BUDGET");
            isRequestBudget = true;
            if (obj instanceof Boolean) {
                isRequestBudget = (Boolean)obj;
            }
            if (isGroupCtrl) {
                groupNo = bgDataInfo.getGroupNo() + ctrlResultInfo.getBgPeriodType();
                key = groupNo + isRequestBudget;
                if (bgDataId2SumReqAmtMap.containsKey(key) && bgDataId2SumReqAmtMap.get(key) instanceof BigDecimal) {
                    BigDecimal _reqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(key);
                    sumReqAmt = _reqAmt.add(reqAmount);
                } else {
                    sumReqAmt = reqAmount;
                }
                bgDataId2SumReqAmtMap.put(key, sumReqAmt);
                continue;
            }
            if (bgDataId2SumReqAmtMap.containsKey(bgDataId) && bgDataId2SumReqAmtMap.get(bgDataId) instanceof BigDecimal) {
                BigDecimal _reqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(bgDataId);
                sumReqAmt = _reqAmt.add(reqAmount);
            } else {
                sumReqAmt = reqAmount;
            }
            if (multiRuleMap != null && multiRuleMap.size() != 0 && !groupCheckMap.isEmpty() && groupCheckMap.size() != 0 && multiRuleMap.containsKey(bizItemCombNumber) && groupCheckMap.containsKey(CtrlItemID = (groupMultiRuleInfo = (BgControlMultiRuleInfo)multiRuleMap.get(bizItemCombNumber)).getCtrlItemCombinId()) && groupMultiRuleInfo.isIsGroupCheck()) {
                Map group = (Map)groupCheckMap.get(CtrlItemID);
                String bgSchemeId = ctrlResultInfo.getBgSchemeId();
                for (int k = 0; k < ctrlResultCol.size(); ++k) {
                    BgCtrlResultInfo tmpResultInfo = ctrlResultCol.get(k);
                    String tmpSchemeId = tmpResultInfo.getBgSchemeId();
                    String tmpitem = tmpResultInfo.getItemCombinNumber().replaceAll(",", "_");
                    if (!group.containsKey(tmpitem) || bizItemCombNumber != null && bizItemCombNumber.equals(tmpitem) || !tmpSchemeId.equals(bgSchemeId)) continue;
                    sumReqAmt = sumReqAmt.add(tmpResultInfo.getReqAmount());
                }
            }
            bgDataId2SumReqAmtMap.put(bgDataId, sumReqAmt);
        }
        boolean hint_flag = false;
        for (int i = 0; i < ctrlResultCol.size(); ++i) {
            BgCtrlResultInfo ctrlResultInfo = ctrlResultCol.get(i);
            BgCtrlParamInfo ctrlParamInfo = ctrlParamCol.get(i);
            bizItemName = null;
            orgUnitName = null;
            if (ctrlParamInfo != null) {
                bizItemName = ctrlParamInfo.getItemCombinName();
                orgUnitName = ctrlParamInfo.getOrgUnitName();
            }
            if (BudgetCtrlUtil.isEmpty(ctrlResultInfo.getBgDataId()) && isCanControlWithoutBudget) continue;
            BgDataInfo bgDataInfo = (BgDataInfo)ctrlResultInfo.get("bgData");
            boolean isCtrl = bgDataInfo != null ? bgDataInfo.isIsControl() : false;
            BgCtrlTypeEnum ctrlType = ctrlResultInfo.getCtrlType();
            if (!isCtrl || ctrlType == BgCtrlTypeEnum.NoCtrl) continue;
            BigDecimal balance = ctrlResultInfo.getBalance();
            BigDecimal sumBgVal = (BigDecimal)ctrlResultInfo.get("sumBudgetValue");
            BigDecimal sumBizActual = (BigDecimal)ctrlResultInfo.get("sumActualValue");
            if (balance == null) continue;
            bgDataId = ctrlResultInfo.getBgDataId();
            sumReqAmt = BudgetCtrlConstants.ZERO_AMOUNT;
            isGroupCtrl = bgDataInfo == null ? false : bgDataInfo.isIsGroupCtrl();
            obj = ctrlResultInfo.get("IS_REQUEST_BUDGET");
            isRequestBudget = true;
            if (obj instanceof Boolean) {
                isRequestBudget = (Boolean)obj;
            }
            if (isGroupCtrl) {
                groupNo = bgDataInfo.getGroupNo() + ctrlResultInfo.getBgPeriodType();
                key = groupNo + isRequestBudget;
                sumReqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(key);
            } else {
                sumReqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(bgDataId);
            }
            if (sumReqAmt == null || sumReqAmt.compareTo(balance) <= 0) continue;
            if (!isRequestBudget) {
                if (hint_flag) continue;
                hint_flag = true;
                continue;
            }
            if (!isAllowAccessCtrlScheme || !ctrlResultInfo.isIsAllowAccess()) {
                ((BgOverspendInfo)overspendList.get(0)).setIsAudit("exception");
                bgOverspend = new BgOverspendInfo();
                bgOverspend.setBgItemName(bizItemName);
                bgOverspend.setBgOrgName(orgUnitName);
                bgOverspend.setBgActual(sumReqAmt.add(sumBizActual).toString());
                bgOverspend.setBgValue(sumBgVal.toString());
                bgOverspend.setBgOverSpend(sumReqAmt.add(sumBizActual).subtract(sumBgVal).toString());
                if (sumBgVal.compareTo(BgNConstants.ZERO) != 0) {
                    bgOverspend.setBgOverPercent(sumReqAmt.add(sumBizActual).subtract(sumBgVal).multiply(BgNConstants.HUNDRED).divide(sumBgVal, 2, 4).toString());
                }
                overspendList.add(bgOverspend);
                return overspendList;
            }
            logger.error((Object)resultMsg);
            isPass = false;
        }
        if (!isPass || hint_flag) {
            throw new BgCtrlManualDecisionException(BgCtrlManualDecisionException.MANUALDECISION, new Object[]{resultMsg});
        }
        return overspendList;
    }

    public static Map checkCtrlResultColValue(Context ctx, boolean isCanControlWithoutBudget, boolean isAllowAccessCtrlScheme, boolean isWorkFlow, BgCtrlResultCollection ctrlResultCol, BgCtrlParamCollection ctrlParamCol, BgControlSchemeInfo ctrlScheme) throws BgCtrlException, BgCtrlManualDecisionException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("result", "1");
        if (BudgetCtrlUtil.isEmpty((Object)ctrlResultCol)) {
            result.put("result", "1");
            return result;
        }
        boolean isPass = true;
        boolean hasZeroIsNull = BgNSHelper.isZeroDealtoNull((Context)ctx);
        BgControlMultiRuleCollection multiRuleCol = ctrlScheme.getMultiRule();
        HashMap<String, BgControlMultiRuleInfo> multiRuleMap = new HashMap<String, BgControlMultiRuleInfo>();
        if (multiRuleCol == null || multiRuleCol.size() == 0) {
            // empty if block
        }
        for (int i = 0; i < multiRuleCol.size(); ++i) {
            BgControlMultiRuleInfo multiRule = multiRuleCol.get(i);
            String bizItemCombNumber = multiRule.getBizItemCombinNumber();
            multiRuleMap.put(bizItemCombNumber, multiRule);
        }
        HashMap groupCheckMap = new HashMap();
        for (int i = 0; i < multiRuleMap.size(); ++i) {
            BgControlMultiRuleInfo multiRule = multiRuleCol.get(i);
            boolean isGourpCheck = multiRule.isIsGroupCheck();
            if (!isGourpCheck) continue;
            Map<String, BgControlMultiRuleInfo> groupitem = new HashMap<String, BgControlMultiRuleInfo>();
            String ItemCombNumber = multiRule.getCtrlItemCombinId();
            String bizItemCombNumber = multiRule.getBizItemCombinNumber();
            if (groupCheckMap.containsKey(ItemCombNumber)) {
                groupitem = (Map)groupCheckMap.get(ItemCombNumber);
                groupitem.put(bizItemCombNumber, multiRule);
            } else {
                groupitem.put(bizItemCombNumber, multiRule);
            }
            groupCheckMap.put(ItemCombNumber, groupitem);
        }
        HashMap<String, BigDecimal> bgDataId2SumReqAmtMap = new HashMap<String, BigDecimal>();
        for (int i = 0; i < ctrlResultCol.size(); ++i) {
            BgControlMultiRuleInfo groupMultiRuleInfo;
            String CtrlItemID;
            BgCtrlResultInfo ctrlResultInfo = ctrlResultCol.get(i);
            BgCtrlParamInfo ctrlParamInfo = ctrlParamCol.get(i);
            String bizItemCombNumber = null;
            if (ctrlParamInfo != null) {
                bizItemCombNumber = ctrlParamInfo.getItemCombinNumber().replaceAll(",", "_");
            }
            BgControlMultiRuleInfo multiRuleInfo = (BgControlMultiRuleInfo)multiRuleMap.get(bizItemCombNumber);
            if (BudgetCtrlUtil.isEmpty(ctrlResultInfo.getBgDataId())) {
                if (isCanControlWithoutBudget) continue;
                result.put("result", "-4");
                return result;
            }
            BgDataInfo bgDataInfo = (BgDataInfo)ctrlResultInfo.get("bgData");
            if (hasZeroIsNull && BudgetCtrlConstants.ZERO_AMOUNT.compareTo(bgDataInfo.getBgValue()) == 0 && isCanControlWithoutBudget) continue;
            boolean isCtrl = bgDataInfo != null ? bgDataInfo.isIsControl() : false;
            BgCtrlTypeEnum ctrlType = ctrlResultInfo.getCtrlType();
            if (!isCtrl || ctrlType == BgCtrlTypeEnum.NoCtrl) continue;
            BigDecimal balance = ctrlResultInfo.getBalance();
            BigDecimal reqAmount = ctrlResultInfo.getReqAmount();
            if (balance == null || reqAmount == null) continue;
            String bgDataId = ctrlResultInfo.getBgDataId();
            BigDecimal sumReqAmt = BudgetCtrlConstants.ZERO_AMOUNT;
            boolean isGroupCtrl = bgDataInfo == null ? false : bgDataInfo.isIsGroupCtrl();
            Object obj = ctrlResultInfo.get("IS_REQUEST_BUDGET");
            boolean isRequestBudget = true;
            if (obj instanceof Boolean) {
                isRequestBudget = (Boolean)obj;
            }
            if (isGroupCtrl) {
                String groupNo = bgDataInfo.getGroupNo();
                String key = groupNo + isRequestBudget;
                if (bgDataId2SumReqAmtMap.containsKey(key) && bgDataId2SumReqAmtMap.get(key) instanceof BigDecimal) {
                    BigDecimal _reqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(key);
                    sumReqAmt = _reqAmt.add(reqAmount);
                } else {
                    sumReqAmt = reqAmount;
                }
                bgDataId2SumReqAmtMap.put(key, sumReqAmt);
                continue;
            }
            if (bgDataId2SumReqAmtMap.containsKey(bgDataId) && bgDataId2SumReqAmtMap.get(bgDataId) instanceof BigDecimal) {
                BigDecimal _reqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(bgDataId);
                sumReqAmt = _reqAmt.add(reqAmount);
            } else {
                sumReqAmt = reqAmount;
            }
            if (multiRuleMap != null && multiRuleMap.size() != 0 && !groupCheckMap.isEmpty() && groupCheckMap.size() != 0 && multiRuleMap.containsKey(bizItemCombNumber) && groupCheckMap.containsKey(CtrlItemID = (groupMultiRuleInfo = (BgControlMultiRuleInfo)multiRuleMap.get(bizItemCombNumber)).getCtrlItemCombinId()) && groupMultiRuleInfo.isIsGroupCheck()) {
                Map group = (Map)groupCheckMap.get(CtrlItemID);
                for (int k = 0; k < ctrlResultCol.size(); ++k) {
                    BgCtrlResultInfo tmpResultInfo = ctrlResultCol.get(k);
                    String tmpitem = tmpResultInfo.getItemCombinNumber().replaceAll(",", "_");
                    if (!group.containsKey(tmpitem) || bizItemCombNumber != null && bizItemCombNumber.equals(tmpitem)) continue;
                    sumReqAmt = sumReqAmt.add(tmpResultInfo.getReqAmount());
                }
            }
            bgDataId2SumReqAmtMap.put(bgDataId, sumReqAmt);
        }
        boolean hint_flag = false;
        for (int i = 0; i < ctrlResultCol.size(); ++i) {
            BigDecimal balance;
            BgCtrlResultInfo ctrlResultInfo = ctrlResultCol.get(i);
            if (BudgetCtrlUtil.isEmpty(ctrlResultInfo.getBgDataId()) && isCanControlWithoutBudget) continue;
            BgDataInfo bgDataInfo = (BgDataInfo)ctrlResultInfo.get("bgData");
            boolean isCtrl = bgDataInfo != null ? bgDataInfo.isIsControl() : false;
            BgCtrlTypeEnum ctrlType = ctrlResultInfo.getCtrlType();
            if (!isCtrl || ctrlType == BgCtrlTypeEnum.NoCtrl || (balance = ctrlResultInfo.getBalance()) == null) continue;
            String bgDataId = ctrlResultInfo.getBgDataId();
            BigDecimal sumReqAmt = BudgetCtrlConstants.ZERO_AMOUNT;
            boolean isGroupCtrl = bgDataInfo == null ? false : bgDataInfo.isIsGroupCtrl();
            Object obj = ctrlResultInfo.get("IS_REQUEST_BUDGET");
            boolean isRequestBudget = true;
            if (obj instanceof Boolean) {
                isRequestBudget = (Boolean)obj;
            }
            if (isGroupCtrl) {
                String groupNo = bgDataInfo.getGroupNo();
                String key = groupNo + isRequestBudget;
                sumReqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(key);
            } else {
                sumReqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(bgDataId);
            }
            if (sumReqAmt == null || sumReqAmt.compareTo(balance) <= 0) continue;
            if (!isRequestBudget) {
                if (hint_flag) continue;
                hint_flag = true;
                continue;
            }
            result.put(ctrlResultCol.get(i).getOrgUnitId() + "-" + i, balance.subtract(sumReqAmt));
            result.put("balance", balance.subtract(sumReqAmt));
            if (!isAllowAccessCtrlScheme || !ctrlResultInfo.isIsAllowAccess()) {
                result.put("result", "0");
                return result;
            }
            isPass = false;
        }
        if (!isPass || hint_flag) {
            result.put("result", "2");
            return result;
        }
        return result;
    }

    private static String analyseCtrlResultCol(Context ctx, boolean isCanControlWithoutBudget, boolean isAllowAccessCtrlScheme, BgCtrlResultCollection ctrlResultCol, BgCtrlParamCollection ctrlParamCol, BgControlSchemeInfo ctrlScheme) {
        int i;
        StringBuffer result = new StringBuffer("");
        String resourcePath = "com.kingdee.eas.ma.budget.BudgetResource";
        BgControlMultiRuleCollection multiRuleCol = ctrlScheme.getMultiRule();
        HashMap<String, BgControlMultiRuleInfo> multiRuleMap = new HashMap<String, BgControlMultiRuleInfo>();
        if (multiRuleCol == null || multiRuleCol.size() == 0) {
            // empty if block
        }
        for (int i2 = 0; i2 < multiRuleCol.size(); ++i2) {
            BgControlMultiRuleInfo multiRule = multiRuleCol.get(i2);
            String bizItemCombNumber = multiRule.getBizItemCombinNumber();
            multiRuleMap.put(bizItemCombNumber, multiRule);
        }
        HashMap groupCheckMap = new HashMap();
        for (int i3 = 0; i3 < multiRuleMap.size(); ++i3) {
            BgControlMultiRuleInfo multiRule = multiRuleCol.get(i3);
            boolean isGourpCheck = multiRule.isIsGroupCheck();
            if (!isGourpCheck) continue;
            Map<String, BgControlMultiRuleInfo> groupitem = new HashMap<String, BgControlMultiRuleInfo>();
            String ItemCombNumber = multiRule.getCtrlItemCombinId();
            String bizItemCombNumber = multiRule.getBizItemCombinNumber();
            if (groupCheckMap.containsKey(ItemCombNumber)) {
                groupitem = (Map)groupCheckMap.get(ItemCombNumber);
                groupitem.put(bizItemCombNumber, multiRule);
            } else {
                groupitem.put(bizItemCombNumber, multiRule);
            }
            groupCheckMap.put(ItemCombNumber, groupitem);
        }
        HashMap<String, BigDecimal> bgDataId2SumReqAmtMap = new HashMap<String, BigDecimal>();
        for (i = 0; i < ctrlResultCol.size(); ++i) {
            BgControlMultiRuleInfo groupMultiRuleInfo;
            String CtrlItemID;
            boolean isGroupCtrl;
            BgDataInfo bgDataInfo;
            BgCtrlResultInfo ctrlResultInfo = ctrlResultCol.get(i);
            Object obj = ctrlResultInfo.get("IS_REQUEST_BUDGET");
            boolean isRequestBudget = true;
            if (obj instanceof Boolean) {
                isRequestBudget = (Boolean)obj;
            }
            BgCtrlParamInfo ctrlParamInfo = ctrlParamCol.get(i);
            String bizItemCombNumber = "";
            if (ctrlParamInfo != null) {
                bizItemCombNumber = ctrlParamInfo.getItemCombinNumber().replaceAll(",", "_");
            }
            BgControlMultiRuleInfo multiRuleInfo = (BgControlMultiRuleInfo)multiRuleMap.get(bizItemCombNumber);
            String billItemAlias = ctrlResultInfo.getBillItemAlias();
            String _billItemAlias = "";
            if (!BudgetCtrlUtil.isEmpty(billItemAlias)) {
                String[] tmp = billItemAlias.split("\\@");
                for (int j = 0; j < tmp.length; ++j) {
                    String[] subTmp = tmp[j].split("\\|");
                    String s = subTmp[0];
                    if (s.endsWith(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"103_BgUtilsHelper"))) {
                        s = s.replaceAll(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"103_BgUtilsHelper"), "");
                    }
                    _billItemAlias = j != tmp.length - 1 ? _billItemAlias + s + "_" : _billItemAlias + s;
                }
            }
            if (BudgetCtrlUtil.isEmpty(ctrlResultInfo.getBgDataId())) {
                if (isCanControlWithoutBudget) continue;
                StringBuffer sb = new StringBuffer();
                sb.append(_billItemAlias);
                sb.append("[");
                sb.append(ctrlResultInfo.getBillItemName());
                sb.append("]");
                sb.append(ResourceBase.getString((String)resourcePath, (String)"NoBudget", (Locale)ctx.getLocale()));
                if (result.indexOf(sb.toString()) == -1) {
                    result.append(sb);
                    result.append(",");
                }
            }
            boolean isCtrl = (bgDataInfo = (BgDataInfo)ctrlResultInfo.get("bgData")) != null ? bgDataInfo.isIsControl() : false;
            BgCtrlTypeEnum ctrlType = ctrlResultInfo.getCtrlType();
            if (!isCtrl || ctrlType == BgCtrlTypeEnum.NoCtrl) continue;
            BigDecimal balance = ctrlResultInfo.getBalance();
            BigDecimal reqAmount = ctrlResultInfo.getReqAmount();
            if (balance == null || reqAmount == null) continue;
            String bgDataId = ctrlResultInfo.getBgDataId();
            BigDecimal sumReqAmt = BudgetCtrlConstants.ZERO_AMOUNT;
            boolean append = true;
            boolean bl = isGroupCtrl = bgDataInfo == null ? false : bgDataInfo.isIsGroupCtrl();
            if (isGroupCtrl) {
                String groupNo = bgDataInfo.getGroupNo();
                String key = groupNo + isRequestBudget;
                if (bgDataId2SumReqAmtMap.containsKey(key) && bgDataId2SumReqAmtMap.get(key) instanceof BigDecimal) {
                    BigDecimal _reqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(key);
                    sumReqAmt = _reqAmt.add(reqAmount);
                    if (_reqAmt.compareTo(balance) > 0) {
                        append = false;
                    }
                } else {
                    sumReqAmt = reqAmount;
                }
                bgDataId2SumReqAmtMap.put(key, sumReqAmt);
                continue;
            }
            if (bgDataId2SumReqAmtMap.containsKey(bgDataId) && bgDataId2SumReqAmtMap.get(bgDataId) instanceof BigDecimal) {
                BigDecimal _reqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(bgDataId);
                sumReqAmt = _reqAmt.add(reqAmount);
                if (_reqAmt.compareTo(balance) > 0) {
                    append = false;
                }
            } else {
                sumReqAmt = reqAmount;
            }
            if (multiRuleMap != null && multiRuleMap.size() != 0 && !groupCheckMap.isEmpty() && groupCheckMap.size() != 0 && multiRuleMap.containsKey(bizItemCombNumber) && groupCheckMap.containsKey(CtrlItemID = (groupMultiRuleInfo = (BgControlMultiRuleInfo)multiRuleMap.get(bizItemCombNumber)).getCtrlItemCombinId()) && groupMultiRuleInfo.isIsGroupCheck()) {
                Map group = (Map)groupCheckMap.get(CtrlItemID);
                for (int k = 0; k < ctrlResultCol.size(); ++k) {
                    BgCtrlResultInfo tmpResultInfo = ctrlResultCol.get(k);
                    String tmpitem = tmpResultInfo.getItemCombinNumber().replaceAll(",", "_");
                    if (!group.containsKey(tmpitem) || bizItemCombNumber.equals(tmpitem)) continue;
                    sumReqAmt = sumReqAmt.add(tmpResultInfo.getReqAmount());
                }
            }
            bgDataId2SumReqAmtMap.put(bgDataId, sumReqAmt);
        }
        for (i = 0; i < ctrlResultCol.size(); ++i) {
            BigDecimal balance;
            BgCtrlResultInfo ctrlResultInfo = ctrlResultCol.get(i);
            String billItemAlias = ctrlResultInfo.getBillItemAlias();
            String _billItemAlias = "";
            if (!BudgetCtrlUtil.isEmpty(billItemAlias)) {
                String[] tmp = billItemAlias.split("\\@");
                for (int j = 0; j < tmp.length; ++j) {
                    String[] subTmp = tmp[j].split("\\|");
                    String s = subTmp[0];
                    if (s.endsWith(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"103_BgUtilsHelper"))) {
                        s = s.replaceAll(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"103_BgUtilsHelper"), "");
                    }
                    _billItemAlias = j != tmp.length - 1 ? _billItemAlias + s + "_" : _billItemAlias + s;
                }
            }
            if (BudgetCtrlUtil.isEmpty(ctrlResultInfo.getBgDataId()) && isCanControlWithoutBudget) continue;
            BgDataInfo bgDataInfo = (BgDataInfo)ctrlResultInfo.get("bgData");
            boolean isCtrl = bgDataInfo != null ? bgDataInfo.isIsControl() : false;
            BgCtrlTypeEnum ctrlType = ctrlResultInfo.getCtrlType();
            if (!isCtrl || ctrlType == BgCtrlTypeEnum.NoCtrl || (balance = ctrlResultInfo.getBalance()) == null) continue;
            String bgDataId = ctrlResultInfo.getBgDataId();
            BigDecimal sumReqAmt = BudgetCtrlConstants.ZERO_AMOUNT;
            boolean append = true;
            boolean isGroupCtrl = bgDataInfo == null ? false : bgDataInfo.isIsGroupCtrl();
            Object obj = ctrlResultInfo.get("IS_REQUEST_BUDGET");
            boolean isRequestBudget = true;
            if (obj instanceof Boolean) {
                isRequestBudget = (Boolean)obj;
            }
            if (isGroupCtrl) {
                String groupNo = bgDataInfo.getGroupNo();
                String key = groupNo + isRequestBudget;
                sumReqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(key);
            } else {
                sumReqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(bgDataId);
            }
            if (sumReqAmt == null || sumReqAmt.compareTo(balance) <= 0 || !append) continue;
            StringBuffer sb = new StringBuffer();
            sb.append(_billItemAlias);
            sb.append("[");
            sb.append(ctrlResultInfo.getBillItemName());
            sb.append("]");
            sb.append(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"108_BudgetCtrlUtil"));
            sb.append("[");
            sb.append(ctrlResultInfo.getOrgUnitName());
            sb.append("]");
            sb.append(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"44_BgItemImportFacadeControllerBean"));
            sb.append(ResourceBase.getString((String)resourcePath, (String)"bgitem", (Locale)ctx.getLocale()));
            sb.append("[");
            sb.append(ctrlResultInfo.getItemCombinName());
            sb.append("]");
            sb.append(ResourceBase.getString((String)resourcePath, (String)"BgItemBalanceLack", (Locale)ctx.getLocale()));
            if (result.indexOf(sb.toString()) != -1) continue;
            result.append(sb);
            result.append(",");
        }
        String resultString = result.toString();
        if (resultString.length() > 0) {
            resultString = BudgetCtrlUtil.deleteStrTail(resultString);
            resultString = resultString.replaceAll(",", "\\\n");
        }
        return resultString;
    }

    public static Map checkCtrlResultColAccess(Context ctx, boolean isCanControlWithoutBudget, boolean isAllowAccessCtrlScheme, boolean isWorkFlow, BgCtrlResultCollection ctrlResultCol, BgCtrlParamCollection ctrlParamCol, BgControlSchemeInfo ctrlScheme) throws BgCtrlException, BgCtrlManualDecisionException {
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        if (BudgetCtrlUtil.isEmpty((Object)ctrlResultCol)) {
            return resMap;
        }
        String resultMsg = BudgetCtrlWithHintUtil.analyseCtrlResultCol(ctx, isCanControlWithoutBudget, isAllowAccessCtrlScheme, ctrlResultCol, ctrlParamCol, ctrlScheme, false);
        boolean isPass = true;
        boolean hasZeroIsNull = BgNSHelper.isZeroDealtoNull((Context)ctx);
        BgControlMultiRuleCollection multiRuleCol = ctrlScheme.getMultiRule();
        HashMap<String, BgControlMultiRuleInfo> multiRuleMap = new HashMap<String, BgControlMultiRuleInfo>();
        if (multiRuleCol == null || multiRuleCol.size() == 0) {
            // empty if block
        }
        for (int i = 0; i < multiRuleCol.size(); ++i) {
            BgControlMultiRuleInfo multiRule = multiRuleCol.get(i);
            String bizItemCombNumber = multiRule.getBizItemCombinNumber();
            multiRuleMap.put(bizItemCombNumber, multiRule);
        }
        HashMap groupCheckMap = new HashMap();
        for (int i = 0; i < multiRuleMap.size(); ++i) {
            BgControlMultiRuleInfo multiRule = multiRuleCol.get(i);
            boolean isGourpCheck = multiRule.isIsGroupCheck();
            if (!isGourpCheck) continue;
            Map<String, BgControlMultiRuleInfo> groupitem = new HashMap<String, BgControlMultiRuleInfo>();
            String ItemCombNumber = multiRule.getCtrlItemCombinId();
            String bizItemCombNumber = multiRule.getBizItemCombinNumber();
            if (groupCheckMap.containsKey(ItemCombNumber)) {
                groupitem = (Map)groupCheckMap.get(ItemCombNumber);
                groupitem.put(bizItemCombNumber, multiRule);
            } else {
                groupitem.put(bizItemCombNumber, multiRule);
            }
            groupCheckMap.put(ItemCombNumber, groupitem);
        }
        HashMap<String, BigDecimal> bgDataId2SumReqAmtMap = new HashMap<String, BigDecimal>();
        for (int i = 0; i < ctrlResultCol.size(); ++i) {
            BgControlMultiRuleInfo groupMultiRuleInfo;
            String CtrlItemID;
            BgCtrlResultInfo ctrlResultInfo = ctrlResultCol.get(i);
            BgCtrlParamInfo ctrlParamInfo = ctrlParamCol.get(i);
            String bizItemCombNumber = null;
            if (ctrlParamInfo != null) {
                bizItemCombNumber = ctrlParamInfo.getItemCombinNumber().replaceAll(",", "_");
            }
            BgControlMultiRuleInfo multiRuleInfo = (BgControlMultiRuleInfo)multiRuleMap.get(bizItemCombNumber);
            if (BudgetCtrlUtil.isEmpty(ctrlResultInfo.getBgDataId())) {
                if (isCanControlWithoutBudget) continue;
                throw new BgCtrlException(BgCtrlException.NOTACROSS, new String[]{resultMsg});
            }
            BgDataInfo bgDataInfo = (BgDataInfo)ctrlResultInfo.get("bgData");
            if (hasZeroIsNull && BudgetCtrlConstants.ZERO_AMOUNT.compareTo(bgDataInfo.getBgValue()) == 0 && isCanControlWithoutBudget) continue;
            boolean isCtrl = bgDataInfo != null ? bgDataInfo.isIsControl() : false;
            BgCtrlTypeEnum ctrlType = ctrlResultInfo.getCtrlType();
            if (!isCtrl || ctrlType == BgCtrlTypeEnum.NoCtrl) continue;
            BigDecimal balance = ctrlResultInfo.getBalance();
            BigDecimal reqAmount = ctrlResultInfo.getReqAmount();
            if (balance == null || reqAmount == null) continue;
            String bgDataId = ctrlResultInfo.getBgDataId();
            BigDecimal sumReqAmt = BudgetCtrlConstants.ZERO_AMOUNT;
            boolean isGroupCtrl = bgDataInfo == null ? false : bgDataInfo.isIsGroupCtrl();
            Object obj = ctrlResultInfo.get("IS_REQUEST_BUDGET");
            boolean isRequestBudget = true;
            if (obj instanceof Boolean) {
                isRequestBudget = (Boolean)obj;
            }
            if (isGroupCtrl) {
                String groupNo = bgDataInfo.getGroupNo() + ctrlResultInfo.getBgPeriodType();
                String key = groupNo + isRequestBudget;
                if (bgDataId2SumReqAmtMap.containsKey(key) && bgDataId2SumReqAmtMap.get(key) instanceof BigDecimal) {
                    BigDecimal _reqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(key);
                    sumReqAmt = _reqAmt.add(reqAmount);
                } else {
                    sumReqAmt = reqAmount;
                }
                bgDataId2SumReqAmtMap.put(key, sumReqAmt);
                continue;
            }
            if (bgDataId2SumReqAmtMap.containsKey(bgDataId) && bgDataId2SumReqAmtMap.get(bgDataId) instanceof BigDecimal) {
                BigDecimal _reqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(bgDataId);
                sumReqAmt = _reqAmt.add(reqAmount);
            } else {
                sumReqAmt = reqAmount;
            }
            if (multiRuleMap != null && multiRuleMap.size() != 0 && !groupCheckMap.isEmpty() && groupCheckMap.size() != 0 && multiRuleMap.containsKey(bizItemCombNumber) && groupCheckMap.containsKey(CtrlItemID = (groupMultiRuleInfo = (BgControlMultiRuleInfo)multiRuleMap.get(bizItemCombNumber)).getCtrlItemCombinId()) && groupMultiRuleInfo.isIsGroupCheck()) {
                Map group = (Map)groupCheckMap.get(CtrlItemID);
                for (int k = 0; k < ctrlResultCol.size(); ++k) {
                    BgCtrlResultInfo tmpResultInfo = ctrlResultCol.get(k);
                    String tmpitem = tmpResultInfo.getItemCombinNumber().replaceAll(",", "_");
                    if (!group.containsKey(tmpitem) || bizItemCombNumber != null && bizItemCombNumber.equals(tmpitem)) continue;
                    sumReqAmt = sumReqAmt.add(tmpResultInfo.getReqAmount());
                }
            }
            bgDataId2SumReqAmtMap.put(bgDataId, sumReqAmt);
        }
        boolean hint_flag = false;
        for (int i = 0; i < ctrlResultCol.size(); ++i) {
            BigDecimal balance;
            BgCtrlResultInfo ctrlResultInfo = ctrlResultCol.get(i);
            if (BudgetCtrlUtil.isEmpty(ctrlResultInfo.getBgDataId()) && isCanControlWithoutBudget) continue;
            BgDataInfo bgDataInfo = (BgDataInfo)ctrlResultInfo.get("bgData");
            boolean isCtrl = bgDataInfo != null ? bgDataInfo.isIsControl() : false;
            BgCtrlTypeEnum ctrlType = ctrlResultInfo.getCtrlType();
            if (!isCtrl || ctrlType == BgCtrlTypeEnum.NoCtrl || (balance = ctrlResultInfo.getBalance()) == null) continue;
            String bgDataId = ctrlResultInfo.getBgDataId();
            BigDecimal sumReqAmt = BudgetCtrlConstants.ZERO_AMOUNT;
            boolean isGroupCtrl = bgDataInfo == null ? false : bgDataInfo.isIsGroupCtrl();
            Object obj = ctrlResultInfo.get("IS_REQUEST_BUDGET");
            boolean isRequestBudget = true;
            if (obj instanceof Boolean) {
                isRequestBudget = (Boolean)obj;
            }
            if (isGroupCtrl) {
                String groupNo = bgDataInfo.getGroupNo() + ctrlResultInfo.getBgPeriodType();
                String key = groupNo + isRequestBudget;
                sumReqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(key);
            } else {
                sumReqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(bgDataId);
            }
            if (sumReqAmt == null || sumReqAmt.compareTo(balance) <= 0) continue;
            if (!isRequestBudget) {
                if (hint_flag) continue;
                hint_flag = true;
                continue;
            }
            if (isAllowAccessCtrlScheme && ctrlResultInfo.isIsAllowAccess()) continue;
            isPass = false;
        }
        resMap.put("isBudgetPass", isPass);
        if (resultMsg != null && resultMsg.length() > 0) {
            resMap.put("message", resultMsg);
        }
        return resMap;
    }

    private static String analyseCtrlResultCol(Context ctx, boolean isCanControlWithoutBudget, boolean isAllowAccessCtrlScheme, BgCtrlResultCollection ctrlResultCol, BgCtrlParamCollection ctrlParamCol, BgControlSchemeInfo ctrlScheme, boolean isNeedOrgInfo) {
        int i;
        StringBuffer result = new StringBuffer("");
        String resourcePath = "com.kingdee.eas.ma.budget.BudgetResource";
        BgControlMultiRuleCollection multiRuleCol = ctrlScheme.getMultiRule();
        HashMap<String, BgControlMultiRuleInfo> multiRuleMap = new HashMap<String, BgControlMultiRuleInfo>();
        if (multiRuleCol == null || multiRuleCol.size() == 0) {
            // empty if block
        }
        for (int i2 = 0; i2 < multiRuleCol.size(); ++i2) {
            BgControlMultiRuleInfo multiRule = multiRuleCol.get(i2);
            String bizItemCombNumber = multiRule.getBizItemCombinNumber();
            multiRuleMap.put(bizItemCombNumber, multiRule);
        }
        HashMap groupCheckMap = new HashMap();
        for (int i3 = 0; i3 < multiRuleMap.size(); ++i3) {
            BgControlMultiRuleInfo multiRule = multiRuleCol.get(i3);
            boolean isGourpCheck = multiRule.isIsGroupCheck();
            if (!isGourpCheck) continue;
            Map<String, BgControlMultiRuleInfo> groupitem = new HashMap<String, BgControlMultiRuleInfo>();
            String ItemCombNumber = multiRule.getCtrlItemCombinId();
            String bizItemCombNumber = multiRule.getBizItemCombinNumber();
            if (groupCheckMap.containsKey(ItemCombNumber)) {
                groupitem = (Map)groupCheckMap.get(ItemCombNumber);
                groupitem.put(bizItemCombNumber, multiRule);
            } else {
                groupitem.put(bizItemCombNumber, multiRule);
            }
            groupCheckMap.put(ItemCombNumber, groupitem);
        }
        HashMap<String, BigDecimal> bgDataId2SumReqAmtMap = new HashMap<String, BigDecimal>();
        for (i = 0; i < ctrlResultCol.size(); ++i) {
            BgControlMultiRuleInfo groupMultiRuleInfo;
            String CtrlItemID;
            boolean isGroupCtrl;
            BgDataInfo bgDataInfo;
            BgCtrlResultInfo ctrlResultInfo = ctrlResultCol.get(i);
            Object obj = ctrlResultInfo.get("IS_REQUEST_BUDGET");
            boolean isRequestBudget = true;
            if (obj instanceof Boolean) {
                isRequestBudget = (Boolean)obj;
            }
            BgCtrlParamInfo ctrlParamInfo = ctrlParamCol.get(i);
            String bizItemCombNumber = "";
            if (ctrlParamInfo != null) {
                bizItemCombNumber = ctrlParamInfo.getItemCombinNumber().replaceAll(",", "_");
            }
            BgControlMultiRuleInfo multiRuleInfo = (BgControlMultiRuleInfo)multiRuleMap.get(bizItemCombNumber);
            String billItemAlias = ctrlResultInfo.getBillItemAlias();
            String _billItemAlias = "";
            if (!BudgetCtrlUtil.isEmpty(billItemAlias)) {
                String[] tmp = billItemAlias.split("\\@");
                for (int j = 0; j < tmp.length; ++j) {
                    String[] subTmp = tmp[j].split("\\|");
                    String s = subTmp[0];
                    if (s.endsWith(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"103_BgUtilsHelper"))) {
                        s = s.replaceAll(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"103_BgUtilsHelper"), "");
                    }
                    _billItemAlias = j != tmp.length - 1 ? _billItemAlias + s + "_" : _billItemAlias + s;
                }
            }
            if (BudgetCtrlUtil.isEmpty(ctrlResultInfo.getBgDataId())) {
                if (isCanControlWithoutBudget) continue;
                StringBuffer sb = new StringBuffer();
                sb.append(_billItemAlias);
                sb.append("[");
                sb.append(ctrlResultInfo.getBillItemName());
                sb.append("]");
                if (isNeedOrgInfo) {
                    sb.append(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"108_BudgetCtrlUtil"));
                    sb.append("[");
                    sb.append(ctrlResultInfo.getOrgUnitName());
                    sb.append("]");
                }
                sb.append(ResourceBase.getString((String)resourcePath, (String)"NoBudget", (Locale)ctx.getLocale()));
                if (result.indexOf(sb.toString()) == -1) {
                    result.append(sb);
                    result.append(",");
                }
            }
            boolean isCtrl = (bgDataInfo = (BgDataInfo)ctrlResultInfo.get("bgData")) != null ? bgDataInfo.isIsControl() : false;
            BgCtrlTypeEnum ctrlType = ctrlResultInfo.getCtrlType();
            if (!isCtrl || ctrlType == BgCtrlTypeEnum.NoCtrl) continue;
            BigDecimal balance = ctrlResultInfo.getBalance();
            BigDecimal reqAmount = ctrlResultInfo.getReqAmount();
            if (balance == null || reqAmount == null) continue;
            String bgDataId = ctrlResultInfo.getBgDataId();
            BigDecimal sumReqAmt = BudgetCtrlConstants.ZERO_AMOUNT;
            boolean append = true;
            boolean bl = isGroupCtrl = bgDataInfo == null ? false : bgDataInfo.isIsGroupCtrl();
            if (isGroupCtrl) {
                String groupNo = bgDataInfo.getGroupNo() + ctrlResultInfo.getBgPeriodType();
                String key = groupNo + isRequestBudget;
                if (bgDataId2SumReqAmtMap.containsKey(key) && bgDataId2SumReqAmtMap.get(key) instanceof BigDecimal) {
                    BigDecimal _reqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(key);
                    sumReqAmt = _reqAmt.add(reqAmount);
                    if (_reqAmt.compareTo(balance) > 0) {
                        append = false;
                    }
                } else {
                    sumReqAmt = reqAmount;
                }
                bgDataId2SumReqAmtMap.put(key, sumReqAmt);
                continue;
            }
            if (bgDataId2SumReqAmtMap.containsKey(bgDataId) && bgDataId2SumReqAmtMap.get(bgDataId) instanceof BigDecimal) {
                BigDecimal _reqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(bgDataId);
                sumReqAmt = _reqAmt.add(reqAmount);
                if (_reqAmt.compareTo(balance) > 0) {
                    append = false;
                }
            } else {
                sumReqAmt = reqAmount;
            }
            if (multiRuleMap != null && multiRuleMap.size() != 0 && !groupCheckMap.isEmpty() && groupCheckMap.size() != 0 && multiRuleMap.containsKey(bizItemCombNumber) && groupCheckMap.containsKey(CtrlItemID = (groupMultiRuleInfo = (BgControlMultiRuleInfo)multiRuleMap.get(bizItemCombNumber)).getCtrlItemCombinId()) && groupMultiRuleInfo.isIsGroupCheck()) {
                Map group = (Map)groupCheckMap.get(CtrlItemID);
                for (int k = 0; k < ctrlResultCol.size(); ++k) {
                    BgCtrlResultInfo tmpResultInfo = ctrlResultCol.get(k);
                    String tmpitem = tmpResultInfo.getItemCombinNumber().replaceAll(",", "_");
                    if (!group.containsKey(tmpitem) || bizItemCombNumber.equals(tmpitem)) continue;
                    sumReqAmt = sumReqAmt.add(tmpResultInfo.getReqAmount());
                }
            }
            bgDataId2SumReqAmtMap.put(bgDataId, sumReqAmt);
        }
        for (i = 0; i < ctrlResultCol.size(); ++i) {
            BigDecimal balance;
            BgCtrlResultInfo ctrlResultInfo = ctrlResultCol.get(i);
            String billItemAlias = ctrlResultInfo.getBillItemAlias();
            String _billItemAlias = "";
            if (!BudgetCtrlUtil.isEmpty(billItemAlias)) {
                String[] tmp = billItemAlias.split("\\@");
                for (int j = 0; j < tmp.length; ++j) {
                    String[] subTmp = tmp[j].split("\\|");
                    String s = subTmp[0];
                    if (s.endsWith(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"103_BgUtilsHelper"))) {
                        s = s.replaceAll(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"103_BgUtilsHelper"), "");
                    }
                    _billItemAlias = j != tmp.length - 1 ? _billItemAlias + s + "_" : _billItemAlias + s;
                }
            }
            if (BudgetCtrlUtil.isEmpty(ctrlResultInfo.getBgDataId()) && isCanControlWithoutBudget) continue;
            BgDataInfo bgDataInfo = (BgDataInfo)ctrlResultInfo.get("bgData");
            boolean isCtrl = bgDataInfo != null ? bgDataInfo.isIsControl() : false;
            BgCtrlTypeEnum ctrlType = ctrlResultInfo.getCtrlType();
            if (!isCtrl || ctrlType == BgCtrlTypeEnum.NoCtrl || (balance = ctrlResultInfo.getBalance()) == null) continue;
            String bgDataId = ctrlResultInfo.getBgDataId();
            BigDecimal sumReqAmt = BudgetCtrlConstants.ZERO_AMOUNT;
            boolean append = true;
            boolean isGroupCtrl = bgDataInfo == null ? false : bgDataInfo.isIsGroupCtrl();
            Object obj = ctrlResultInfo.get("IS_REQUEST_BUDGET");
            boolean isRequestBudget = true;
            if (obj instanceof Boolean) {
                isRequestBudget = (Boolean)obj;
            }
            if (isGroupCtrl) {
                String groupNo = bgDataInfo.getGroupNo() + ctrlResultInfo.getBgPeriodType();
                String key = groupNo + isRequestBudget;
                sumReqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(key);
            } else {
                sumReqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(bgDataId);
            }
            if (sumReqAmt == null || sumReqAmt.compareTo(balance) <= 0 || !append) continue;
            StringBuffer sb = new StringBuffer();
            sb.append(_billItemAlias);
            sb.append("[");
            sb.append(ctrlResultInfo.getBillItemName());
            sb.append("]");
            sb.append(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"108_BudgetCtrlUtil"));
            sb.append("[");
            sb.append(ctrlResultInfo.getOrgUnitName());
            sb.append("]");
            sb.append(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"44_BgItemImportFacadeControllerBean"));
            sb.append(ResourceBase.getString((String)resourcePath, (String)"bgitem", (Locale)ctx.getLocale()));
            sb.append("[");
            sb.append(ctrlResultInfo.getItemCombinName());
            sb.append("]");
            sb.append(ResourceBase.getString((String)resourcePath, (String)"BgItemBalanceLack", (Locale)ctx.getLocale()));
            if (result.indexOf(sb.toString()) != -1) continue;
            result.append(sb);
            result.append(",");
        }
        String resultString = result.toString();
        if (resultString.length() > 0) {
            resultString = BudgetCtrlUtil.deleteStrTail(resultString);
            resultString = resultString.replaceAll(",", "\\\n");
        }
        return resultString;
    }
}

