/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;

public class MateUtils {
    public static String getEntityPropertyAlias(EntityObjectInfo mainEntity, String propertyValue) {
        String alias = null;
        EntityObjectInfo currentEntity = mainEntity;
        String currentProperty = propertyValue;
        PropertyCollection propertyCollection = MateUtils.getAllEntityProperties(currentEntity);
        int size = propertyCollection.size();
        int index = currentProperty.indexOf(".");
        String compareProperty = null;
        if (index != -1) {
            compareProperty = currentProperty.substring(0, index);
            currentProperty = currentProperty.substring(index + 1);
        } else {
            compareProperty = currentProperty;
        }
        for (int i = 0; i < size; ++i) {
            PropertyInfo propertyInfo = propertyCollection.get(i);
            if (!propertyInfo.getName().equalsIgnoreCase(compareProperty)) continue;
            alias = alias == null ? MateUtils.getPropertyAlias(propertyInfo) : alias + MateUtils.getPropertyAlias(propertyInfo);
            if (propertyInfo instanceof LinkPropertyInfo) {
                currentEntity = MateUtils.getEntity(currentEntity.getFullName(), (LinkPropertyInfo)propertyInfo);
                alias = alias + "." + MateUtils.getEntityPropertyAlias(currentEntity, currentProperty);
                return MateUtils.processEntityPropertyAlias(currentEntity, currentProperty, alias);
            }
            return MateUtils.processEntityPropertyAlias(currentEntity, currentProperty, alias);
        }
        return compareProperty;
    }

    public static PropertyCollection getAllEntityProperties(EntityObjectInfo entity) {
        PropertyCollection properties = new PropertyCollection();
        properties.addObjectCollection((IObjectCollection)entity.getProperties());
        while (entity.getBaseEntity() != null) {
            properties.addObjectCollection((IObjectCollection)entity.getBaseEntity().getProperties());
            entity = entity.getBaseEntity();
        }
        return properties;
    }

    public static String getPropertyAlias(PropertyInfo propertyInfo) {
        String alias = propertyInfo.getAlias();
        if (alias == null || alias.trim().equalsIgnoreCase("")) {
            alias = propertyInfo.getName();
        }
        return alias;
    }

    public static EntityObjectInfo getEntity(String mainEntityName, LinkPropertyInfo linkPropertyInfo) {
        String tempEntityName = linkPropertyInfo.getRelationship().getSupplierObject().getFullName();
        if (!tempEntityName.equalsIgnoreCase(mainEntityName)) {
            return linkPropertyInfo.getRelationship().getSupplierObject();
        }
        return linkPropertyInfo.getRelationship().getClientObject();
    }

    protected static String processEntityPropertyAlias(EntityObjectInfo entity, String property, String alias) {
        if (MateUtils.isEntityPK(entity, property)) {
            int sep = alias.lastIndexOf(".");
            alias = sep == -1 ? MateUtils.getEntityAlias(entity) : alias.substring(0, sep);
        }
        return alias;
    }

    public static boolean isEntityPK(EntityObjectInfo entity, String propertyName) {
        while (entity != null) {
            PropertyCollection propertyCollection = entity.getLogicalKey().getKeyPropertys();
            int size = propertyCollection.size();
            if (size > 1) {
                throw new IllegalArgumentException("not support multi LogicalKey");
            }
            for (int j = 0; j < size; ++j) {
                PropertyInfo propertyInfo = propertyCollection.get(j);
                if (!propertyInfo.getName().equalsIgnoreCase(propertyName)) continue;
                return true;
            }
            entity = entity.getBaseEntity();
        }
        return false;
    }

    public static String getEntityAlias(EntityObjectInfo entity) {
        String alias = entity.getAlias();
        if (alias == null || alias.trim().equalsIgnoreCase("")) {
            return entity.getName();
        }
        return alias;
    }
}

