/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.client.LongTimeDialog;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class OrgUnitUtils {
    private static Color COLOR_DEFAULT = Color.BLACK;
    private static Color COLOR_SELECT = Color.RED;

    public static Color getCOLOR_DEFAULT() {
        return COLOR_DEFAULT;
    }

    public static Color getCOLOR_SELECT() {
        return COLOR_SELECT;
    }

    public static TreeModel getOrgTreeModel(KDTree kdTree, String orgUnitId) throws Exception {
        return OrgUnitUtils.getOrgTreeModel(kdTree, OrgViewType.COSTCENTER, orgUnitId, null);
    }

    public static TreeModel getOrgTreeModel(KDTree kdTree, String orgUnitId, TreeWillExpandListener listener) throws Exception {
        return OrgUnitUtils.getOrgTreeModel(kdTree, OrgViewType.COSTCENTER, orgUnitId, listener);
    }

    public static TreeModel getOrgTreeModelWithCompany(KDTree kdTree, String orgUnitId, TreeWillExpandListener listener) throws Exception {
        return OrgUnitUtils.getOrgTreeModelWithCompany(kdTree, OrgViewType.COSTCENTER, orgUnitId, listener);
    }

    public static TreeModel getOrgTreeModelWithCompany(KDTree kdTree, OrgViewType orgViewType, String orgUnitId, TreeWillExpandListener listener) throws Exception {
        TreeModel model;
        if (kdTree == null) {
            return null;
        }
        if (orgViewType == null) {
            orgViewType = OrgViewType.COSTCENTER;
        }
        if (StringUtils.isEmpty((String)orgUnitId)) {
            orgUnitId = SysContext.getSysContext().getCurrentCostUnit().getId().toString();
        }
        if ((model = OrgUnitUtils.getTreeModel(orgViewType, orgUnitId)) != null) {
            if (listener == null) {
                kdTree.addTreeWillExpandListener(new TreeWillExpandListener(){

                    @Override
                    public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
                        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)e.getPath().getLastPathComponent();
                        try {
                            OrgUnitUtils.addChildNode(node, null);
                        }
                        catch (Exception ex) {
                            ExceptionHandler.handle((String)"", (Throwable)ex);
                        }
                    }

                    @Override
                    public void treeWillCollapse(TreeExpansionEvent e) throws ExpandVetoException {
                    }
                });
            } else {
                kdTree.addTreeWillExpandListener(listener);
            }
        }
        OrgUnitUtils.fullProperties4OrgUnit((DefaultKingdeeTreeNode)model.getRoot());
        return model;
    }

    public static TreeModel getOrgTreeModel(KDTree kdTree, OrgViewType orgViewType, String orgUnitId, TreeWillExpandListener listener) throws Exception {
        TreeModel model;
        if (kdTree == null) {
            return null;
        }
        if (orgViewType == null) {
            orgViewType = OrgViewType.COSTCENTER;
        }
        if (StringUtils.isEmpty((String)orgUnitId)) {
            orgUnitId = SysContext.getSysContext().getCurrentCostUnit().getId().toString();
        }
        if ((model = OrgUnitUtils.getTreeModel(orgViewType, orgUnitId)) != null) {
            if (listener == null) {
                kdTree.addTreeWillExpandListener(new TreeWillExpandListener(){

                    @Override
                    public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
                        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)e.getPath().getLastPathComponent();
                        try {
                            OrgUnitUtils.addChildNode(node, null);
                        }
                        catch (Exception ex) {
                            ExceptionHandler.handle((String)"", (Throwable)ex);
                        }
                    }

                    @Override
                    public void treeWillCollapse(TreeExpansionEvent e) throws ExpandVetoException {
                    }
                });
            } else {
                kdTree.addTreeWillExpandListener(listener);
            }
        }
        return model;
    }

    protected static IOrgStructure getOrgStructureInterface() throws BOSException {
        return OrgStructureFactory.getRemoteInstance();
    }

    protected static TreeModel getTreeModel(OrgViewType orgViewType, String orgUnitId) throws Exception {
        OrgStructureInfo selNode = OrgUnitUtils.getOrgStructureInterface().getOrgStructureInfo("select id, longnumber ,unit.id,unit.number,unit.longnumber,unit.name where unit.id = '" + orgUnitId + "' and tree.id = '" + NewOrgViewHelper.convert2TreeId((OrgViewType)orgViewType) + "'");
        DefaultKingdeeTreeNode rootNode = new DefaultKingdeeTreeNode((Object)selNode);
        DefaultTreeModel model = null;
        DefaultKingdeeTreeNode node = OrgUnitUtils.getDefaultKingdeeTreeNode(rootNode, orgViewType);
        if (node != null) {
            node.setTextColor(Color.BLACK);
            OrgUnitUtils.dealNode(node, null, false);
            model = new DefaultTreeModel((TreeNode)node);
        }
        return model;
    }

    public static DefaultKingdeeTreeNode getDefaultKingdeeTreeNode(DefaultKingdeeTreeNode root, OrgViewType viewType) throws EASBizException, BOSException {
        if (root == null) {
            return null;
        }
        if (viewType == null) {
            viewType = OrgViewType.COSTCENTER;
        }
        return NewOrgViewFacadeFactory.getRemoteInstance().getViewDirectChildNodesByMultiCondition(viewType, NewOrgViewHelper.convert2TreeId((OrgViewType)viewType), true, true, root, true, true, null, null, null);
    }

    public static void dealNode(DefaultKingdeeTreeNode root, Set<String> selOrgUnitIds, boolean isSelect) {
        if (root == null || root.getChildCount() == 0) {
            return;
        }
        DefaultKingdeeTreeNode node = null;
        OrgStructureInfo oui = null;
        FullOrgUnitInfo unitInfo = null;
        int count = root.getChildCount();
        for (int index = 0; index < count; ++index) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(index);
            node.setTextColor(OrgUnitUtils.getCOLOR_DEFAULT());
            oui = (OrgStructureInfo)node.getUserObject();
            if (oui != null && !oui.isIsLeaf()) {
                node.add((MutableTreeNode)new DefaultKingdeeTreeNode());
            }
            if (oui == null || selOrgUnitIds == null || (unitInfo = oui.getUnit()) == null || !selOrgUnitIds.contains(unitInfo.getId().toString())) continue;
            if (isSelect) {
                if (!OrgUnitUtils.canTheNodeBeSelected(node)) continue;
                node.setChecked(true);
                continue;
            }
            node.setTextColor(OrgUnitUtils.getCOLOR_SELECT());
        }
    }

    public static void dealNode(DefaultKingdeeTreeNode root, Set<String> selOrgUnitIds, boolean isSelect, boolean isFinSelect) {
        if (root == null || root.getChildCount() == 0) {
            return;
        }
        DefaultKingdeeTreeNode node = null;
        OrgStructureInfo oui = null;
        FullOrgUnitInfo unitInfo = null;
        int count = root.getChildCount();
        for (int index = 0; index < count; ++index) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(index);
            node.setTextColor(OrgUnitUtils.getCOLOR_DEFAULT());
            oui = (OrgStructureInfo)node.getUserObject();
            if (oui != null && !oui.isIsLeaf()) {
                node.add((MutableTreeNode)new DefaultKingdeeTreeNode());
            }
            unitInfo = oui.getUnit();
            if (isFinSelect && !unitInfo.isIsCompanyOrgUnit()) {
                node.setTextColor(Color.GRAY);
                node.setCheckBoxVisible(false);
                node.setCheckBoxEnabled(false);
            }
            if (oui == null || selOrgUnitIds == null || unitInfo == null || !selOrgUnitIds.contains(unitInfo.getId().toString())) continue;
            if (isSelect) {
                if (!OrgUnitUtils.canTheNodeBeSelected(node)) continue;
                node.setChecked(true);
                continue;
            }
            node.setTextColor(OrgUnitUtils.getCOLOR_SELECT());
        }
    }

    public static void addChildNode(DefaultKingdeeTreeNode root, Set<String> selOrgUnitIds) throws Exception {
        OrgUnitUtils.addChildNode(root, selOrgUnitIds, false);
    }

    public static void addChildNode(DefaultKingdeeTreeNode root, Set<String> selOrgUnitIds, boolean isSelect) throws Exception {
        if (root == null) {
            return;
        }
        int childCount = root.getChildCount();
        if (childCount == 1) {
            int index;
            DefaultKingdeeTreeNode tempNode = (DefaultKingdeeTreeNode)root.getChildAt(0);
            if (tempNode.getUserObject() != null) {
                return;
            }
            root.removeAllChildren();
            DefaultKingdeeTreeNode _root = OrgUnitUtils.getDefaultKingdeeTreeNode(root, null);
            OrgUnitUtils.dealNode(_root, selOrgUnitIds, isSelect);
            ArrayList<TreeNode> list = new ArrayList<TreeNode>();
            for (index = _root.getChildCount(); index > 0; --index) {
                list.add(_root.getChildAt(index - 1));
            }
            if (!list.isEmpty()) {
                for (index = list.size(); index > 0; --index) {
                    root.add((MutableTreeNode)((DefaultKingdeeTreeNode)list.get(index - 1)));
                }
            }
        }
    }

    public static void addChildNode(DefaultKingdeeTreeNode root, Set<String> selOrgUnitIds, boolean isSelect, boolean isFinSelect) throws Exception {
        if (root == null) {
            return;
        }
        int childCount = root.getChildCount();
        if (childCount == 1) {
            int index;
            DefaultKingdeeTreeNode tempNode = (DefaultKingdeeTreeNode)root.getChildAt(0);
            if (tempNode.getUserObject() != null) {
                OrgStructureInfo structureInfo = (OrgStructureInfo)tempNode.getUserObject();
                if (isFinSelect && structureInfo != null && structureInfo.getUnit() != null && !structureInfo.getUnit().isIsCompanyOrgUnit()) {
                    tempNode.setTextColor(Color.GRAY);
                    tempNode.setCheckBoxVisible(false);
                    tempNode.setCheckBoxEnabled(false);
                }
                return;
            }
            root.removeAllChildren();
            DefaultKingdeeTreeNode _root = OrgUnitUtils.getDefaultKingdeeTreeNode(root, null);
            OrgUnitUtils.fullProperties4OrgUnit(_root);
            OrgUnitUtils.dealNode(_root, selOrgUnitIds, isSelect, isFinSelect);
            ArrayList<TreeNode> list = new ArrayList<TreeNode>();
            for (index = _root.getChildCount(); index > 0; --index) {
                list.add(_root.getChildAt(index - 1));
            }
            if (!list.isEmpty()) {
                for (index = list.size(); index > 0; --index) {
                    root.add((MutableTreeNode)((DefaultKingdeeTreeNode)list.get(index - 1)));
                }
            }
        }
    }

    private static void fullProperties4OrgUnit(DefaultKingdeeTreeNode node) throws BOSException {
        HashSet<String> orgUnitIdSet = new HashSet<String>();
        OrgUnitUtils.findAllUnitId(node, orgUnitIdSet);
        CoreBaseCollection coll = FullOrgUnitFactory.getRemoteInstance().getCollection("select id, isCompanyOrgUnit where id in (" + OrgUnitUtils.buildInCondition(orgUnitIdSet) + ")");
        HashMap<String, CoreBaseInfo> propertiesMap = new HashMap<String, CoreBaseInfo>();
        for (int i = 0; i < coll.size(); ++i) {
            CoreBaseInfo coreBaseInfo = coll.get(i);
            propertiesMap.put(coreBaseInfo.getId().toString(), coreBaseInfo);
        }
        OrgUnitUtils.fullProperties(node, propertiesMap);
    }

    private static String buildInCondition(Set<String> ids) {
        StringBuilder sb = new StringBuilder();
        for (String id : ids) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append("'").append(id).append("'");
        }
        return sb.toString();
    }

    private static void fullProperties(DefaultKingdeeTreeNode node, Map<String, CoreBaseInfo> propertiesMap) {
        OrgStructureInfo currInfo = (OrgStructureInfo)node.getUserObject();
        if (currInfo != null && currInfo.getUnit() != null && currInfo.getUnit().getId() != null) {
            String currId = currInfo.getUnit().getId().toString();
            currInfo.getUnit().setIsCompanyOrgUnit(propertiesMap.get(currId).getBoolean("isCompanyOrgUnit"));
        }
        for (int index = 0; index < node.getChildCount(); ++index) {
            OrgStructureInfo orginfo;
            DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)node.getChildAt(index);
            if (childNode == null || childNode.getUserObject() == null || !(childNode.getUserObject() instanceof OrgStructureInfo) || (orginfo = (OrgStructureInfo)childNode.getUserObject()).getUnit() == null || orginfo.getUnit().isIsLeaf()) continue;
            OrgUnitUtils.fullProperties(childNode, propertiesMap);
        }
    }

    private static void findAllUnitId(DefaultKingdeeTreeNode node, Set<String> result) {
        OrgStructureInfo currInfo = (OrgStructureInfo)node.getUserObject();
        if (currInfo != null && currInfo.getUnit() != null && currInfo.getUnit().getId() != null) {
            result.add(currInfo.getUnit().getId().toString());
        }
        for (int index = 0; index < node.getChildCount(); ++index) {
            DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)node.getChildAt(index);
            OrgStructureInfo orginfo = (OrgStructureInfo)childNode.getUserObject();
            if (orginfo == null || orginfo.getUnit() == null || orginfo.getUnit().isIsLeaf()) continue;
            OrgUnitUtils.findAllUnitId(childNode, result);
        }
    }

    public static List<OrgStructureInfo> getSelectOrgUnitInfo(KDTree kdTree) {
        if (kdTree == null) {
            return null;
        }
        ArrayList<OrgStructureInfo> orgUnits = new ArrayList<OrgStructureInfo>();
        return OrgUnitUtils.getSelectOrgUnitInfo((DefaultKingdeeTreeNode)kdTree.getModel().getRoot(), orgUnits);
    }

    private static List<OrgStructureInfo> getSelectOrgUnitInfo(DefaultKingdeeTreeNode root, List<OrgStructureInfo> orgUnits) {
        if (root == null || orgUnits == null) {
            return null;
        }
        DefaultKingdeeTreeNode node = null;
        int count = root.getChildCount();
        for (int index = 0; index < count; ++index) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(index);
            if (node.isChecked() && node.getUserObject() instanceof OrgStructureInfo) {
                orgUnits.add((OrgStructureInfo)node.getUserObject());
            }
            if (node.isLeaf()) continue;
            orgUnits = OrgUnitUtils.getSelectOrgUnitInfo(node, orgUnits);
        }
        return orgUnits;
    }

    public static List<String> getSelectOrgUnitIds(KDTree kdTree) {
        if (kdTree == null) {
            return null;
        }
        ArrayList<String> orgUnits = new ArrayList<String>();
        return OrgUnitUtils.getSelectOrgUnitIds((DefaultKingdeeTreeNode)kdTree.getModel().getRoot(), orgUnits);
    }

    private static List<String> getSelectOrgUnitIds(DefaultKingdeeTreeNode root, List<String> orgUnitIds) {
        if (root == null || orgUnitIds == null) {
            return null;
        }
        DefaultKingdeeTreeNode node = null;
        OrgStructureInfo os = null;
        int count = root.getChildCount();
        for (int index = 0; index < count; ++index) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(index);
            if (node.isChecked()) {
                if (node.getUserObject() instanceof OrgStructureInfo) {
                    os = (OrgStructureInfo)node.getUserObject();
                    orgUnitIds.add(os.getUnit().getId().toString());
                } else if (node.getUserObject() instanceof OrgUnitInfo) {
                    orgUnitIds.add(((OrgUnitInfo)node.getUserObject()).getId().toString());
                }
            }
            if (node.isLeaf()) continue;
            orgUnitIds = OrgUnitUtils.getSelectOrgUnitIds(node, orgUnitIds);
        }
        return orgUnitIds;
    }

    public static void selectOrgUnit(KDTree kdTree, boolean selected) {
        if (kdTree == null) {
            return;
        }
        OrgUnitUtils.selectOrgUnit(kdTree, selected, true);
    }

    public static void selectOrgUnit(KDTree kdTree, boolean selected, boolean isIncludeChildren) {
        if (kdTree == null) {
            return;
        }
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)kdTree.getModel().getRoot();
        if (kdTree.getSelectionPath() != null) {
            root = (DefaultKingdeeTreeNode)kdTree.getSelectionPath().getLastPathComponent();
        }
        OrgUnitUtils.selectOrgUnit(root, selected, isIncludeChildren);
        kdTree.updateUI();
    }

    public static void selectOrgUnit(DefaultKingdeeTreeNode root, boolean selected) {
        OrgUnitUtils.selectOrgUnit(root, selected, true);
    }

    public static void selectOrgUnit(DefaultKingdeeTreeNode root, boolean selected, boolean isIncludeChildren) {
        if (root == null) {
            return;
        }
        if (OrgUnitUtils.canTheNodeBeSelected(root)) {
            root.setChecked(selected);
        }
        DefaultKingdeeTreeNode node = null;
        int count = root.getChildCount();
        for (int index = 0; index < count; ++index) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(index);
            if (OrgUnitUtils.canTheNodeBeSelected(node)) {
                node.setChecked(selected);
            }
            if (node.isLeaf() || !isIncludeChildren) continue;
            OrgUnitUtils.selectOrgUnit(node, selected);
        }
    }

    public static void selectOrgUnit(KDTree kdTree, Set<String> selOrgUnitIds) {
        if (kdTree == null || selOrgUnitIds == null) {
            return;
        }
        OrgUnitUtils.selectOrgUnit((DefaultKingdeeTreeNode)kdTree.getModel().getRoot(), selOrgUnitIds);
    }

    public static void selectOrgUnit(DefaultKingdeeTreeNode root, Set<String> selOrgUnitIds) {
        if (root == null) {
            return;
        }
        DefaultKingdeeTreeNode node = null;
        OrgStructureInfo oui = null;
        Object userObject = root.getUserObject();
        if (userObject != null) {
            OrgUnitInfo orgUnit;
            if (userObject instanceof OrgStructureInfo) {
                oui = (OrgStructureInfo)userObject;
                if (oui.getUnit() != null && selOrgUnitIds.contains(oui.getUnit().getId().toString())) {
                    root.setChecked(true);
                }
            } else if (userObject instanceof OrgUnitInfo && selOrgUnitIds.contains((orgUnit = (OrgUnitInfo)userObject).getId().toString())) {
                root.setChecked(true);
            }
        }
        int count = root.getChildCount();
        for (int index = 0; index < count; ++index) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(index);
            OrgUnitUtils.selectOrgUnit(node, selOrgUnitIds);
        }
    }

    public static void unSelectRoot(KDTree treeOrgUnit) {
        if (treeOrgUnit == null) {
            return;
        }
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)treeOrgUnit.getModel().getRoot();
        if (OrgUnitUtils.canTheNodeBeSelected(root)) {
            root.setChecked(false);
        }
    }

    public static void selectOrgUnitAll(Component component, KDTree treeOrgUnit, boolean isSelected) throws Exception {
        OrgUnitUtils.selectOrgUnitAll(component, treeOrgUnit, isSelected, true);
    }

    public static void selectOrgUnitAll(Component component, KDTree treeOrgUnit, boolean isSelected, boolean isIncludeChildren) throws Exception {
        if (component == null || treeOrgUnit == null) {
            return;
        }
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)treeOrgUnit.getModel().getRoot();
        if (treeOrgUnit.getSelectionPath() != null) {
            root = (DefaultKingdeeTreeNode)treeOrgUnit.getSelectionPath().getLastPathComponent();
        }
        OrgUnitUtils.selectOrgUnitAll(component, root, isSelected, isIncludeChildren);
        treeOrgUnit.repaint();
    }

    public static void selectOrgUnitAllWithCompany(Component component, KDTree treeOrgUnit, boolean isSelected, boolean isIncludeChildren) throws Exception {
        if (component == null || treeOrgUnit == null) {
            return;
        }
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)treeOrgUnit.getModel().getRoot();
        if (treeOrgUnit.getSelectionPath() != null) {
            root = (DefaultKingdeeTreeNode)treeOrgUnit.getSelectionPath().getLastPathComponent();
        }
        OrgUnitUtils.selectOrgUnitAll(component, root, isSelected, isIncludeChildren);
        OrgUnitUtils.fullProperties4OrgUnit(root);
        treeOrgUnit.repaint();
    }

    public static void selectOrgUnitAll(Component component, final DefaultKingdeeTreeNode root, final boolean isSelected, final boolean isIncludeChildren) throws Exception {
        if (component == null || root == null) {
            return;
        }
        LongTimeDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor(component);
        if (win instanceof Frame) {
            dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new LongTimeDialog((Dialog)win);
        }
        if (dialog == null) {
            return;
        }
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                OrgUnitUtils.selectAllAndExpend(root, isSelected, isIncludeChildren);
                return null;
            }

            public void afterExec(Object result) throws Exception {
            }
        });
        dialog.show();
    }

    private static void selectAllAndExpend(DefaultKingdeeTreeNode root, boolean isSelected, boolean isIncludeChildren) throws Exception {
        if (root == null) {
            return;
        }
        if (OrgUnitUtils.canTheNodeBeSelected(root)) {
            root.setChecked(isSelected);
        }
        DefaultKingdeeTreeNode node = null;
        Enumeration children = root.children();
        while (children.hasMoreElements()) {
            node = (DefaultKingdeeTreeNode)children.nextElement();
            if (OrgUnitUtils.canTheNodeBeSelected(node)) {
                node.setChecked(isSelected);
            }
            if (node.isLeaf()) continue;
            BgNFSHelper.addChildNode((DefaultKingdeeTreeNode)node);
            if (!isIncludeChildren) continue;
            OrgUnitUtils.selectAllAndExpend(node, isSelected, isIncludeChildren);
        }
    }

    private static boolean canTheNodeBeSelected(DefaultKingdeeTreeNode node) {
        return node.isCheckBoxVisible() && node.isCheckBoxEnabled();
    }

    public static void selectDirectOrgUnit(DefaultKingdeeTreeNode root, boolean selected) {
        if (root == null) {
            return;
        }
        if (OrgUnitUtils.canTheNodeBeSelected(root)) {
            root.setChecked(selected);
        }
        DefaultKingdeeTreeNode node = null;
        int count = root.getChildCount();
        for (int index = 0; index < count; ++index) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(index);
            if (!OrgUnitUtils.canTheNodeBeSelected(root)) continue;
            node.setChecked(selected);
        }
    }

    public static CompanyOrgUnitInfo getCompanyOrgUnit(Context ctx, IObjectValue costCenterInfo) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = null;
        CostCenterOrgUnitInfo cost = (CostCenterOrgUnitInfo)costCenterInfo;
        if (cost.getId() == null) {
            return company;
        }
        String orgId = cost.getId().toString();
        if (cost.isIsCompanyOrgUnit()) {
            company = (CompanyOrgUnitInfo)NewOrgViewHelper.getOrgUnitInfo((Context)ctx, (String)cost.getId().toString(), (OrgType)OrgType.Company);
        } else {
            IOrgUnitRelation our = null;
            our = ctx == null ? OrgUnitRelationFactory.getRemoteInstance() : OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            OrgUnitCollection col = our.getToUnit(orgId, 5, 1);
            if (col != null && !col.isEmpty()) {
                company = (CompanyOrgUnitInfo)col.get(0);
            } else {
                String[] numbers = cost.getLongNumber().split("!");
                ICompanyOrgUnit cou = null;
                cou = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                EntityViewInfo evi = new EntityViewInfo();
                evi.setFilter(new FilterInfo());
                evi.getFilter().getFilterItems().add(new FilterItemInfo("number", new HashSet<String>(Arrays.asList(numbers)), CompareType.INCLUDE));
                evi.setSelector(new SelectorItemCollection());
                evi.getSelector().add("id");
                evi.getSelector().add("number");
                evi.getSelector().add("name");
                evi.getSelector().add("longNumber");
                evi.getSelector().add("accountTable.id");
                CompanyOrgUnitCollection ccol = cou.getCompanyOrgUnitCollection(evi);
                if (ccol != null && !ccol.isEmpty()) {
                    block0: for (int n = numbers.length - 1; n >= 0; --n) {
                        for (int c = 0; c < ccol.size(); ++c) {
                            if (!numbers[n].equals(ccol.get(c).getNumber())) continue;
                            company = ccol.get(c);
                            break block0;
                        }
                    }
                }
            }
        }
        return company;
    }
}

